<?php
require_once(__DIR__ . '/../config.php');
require_once($CFG->dirroot . '/my/lib.php');
require_once($CFG->libdir . '/tablelib.php');

redirect_if_major_upgrade_required();

$edit   = optional_param('edit', null, PARAM_BOOL);
$reset  = optional_param('reset', null, PARAM_BOOL);

require_login();

$hassiteconfig = has_capability('moodle/site:config', context_system::instance());
if ($hassiteconfig && moodle_needs_upgrading()) {
    redirect(new moodle_url('/admin/index.php'));
}

$strmymoodle = get_string('myhome');

if (empty($CFG->enabledashboard)) {
    $defaultpage = get_default_home_page();
    if ($defaultpage == HOMEPAGE_MYCOURSES) {
        redirect(new moodle_url('/my/courses.php'));
    } else {
        throw new moodle_exception('error:dashboardisdisabled', 'my');
    }
}

if (isguestuser()) {
    if (empty($CFG->allowguestmymoodle)) {
        redirect(new moodle_url('/', array('redirect' => 0)));
    }
    $userid = null;
    $USER->editing = $edit = 0;
    $context = context_system::instance();
    $PAGE->set_blocks_editing_capability('moodle/my:configsyspages');
    $pagetitle = "$strmymoodle (" . get_string('guest') . ")";
} else {
    $userid = $USER->id;
    $context = context_user::instance($USER->id);
    $PAGE->set_blocks_editing_capability('moodle/my:manageblocks');
    $pagetitle = $strmymoodle;
}

if (!$currentpage = my_get_page($userid, MY_PAGE_PRIVATE)) {
    print_error('mymoodlesetup');
}

$params = array();
$PAGE->set_context($context);
$PAGE->set_url('/my/index.php', $params);
$PAGE->set_pagelayout('mydashboard');
$PAGE->add_body_class('limitedwidth');
$PAGE->set_pagetype('my-index');
$PAGE->blocks->add_region('content');
$PAGE->set_subpage($currentpage->id);
$PAGE->set_title($pagetitle);
$PAGE->set_heading($pagetitle);

// ===== ROLE-BASED CUSTOM DASHBOARD =====
global $DB, $USER;

$contextsys = context_system::instance();
$userroles = get_user_roles($contextsys, $USER->id);

// Define roles
$learnerroles = ['student', 'learner', 'trainee'];
$managerroles = ['manager'];

$islearner = false;
$ismanager = false;

foreach ($userroles as $role) {
    $r = strtolower($role->shortname);
    if (in_array($r, $learnerroles)) $islearner = true;
    if (in_array($r, $managerroles)) $ismanager = true;
}

echo $OUTPUT->header();
// ====== LEARNER DASHBOARD ======
if ($islearner) {

    $total_batches = $DB->count_records('cohort'); 
    ?>
    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        /* Main Container */
        .dashboard {
            padding: 20px;
            font-family: 'Segoe UI', sans-serif;
            background-color: #f8fafc;
        }

        /* Welcome Header */
        .dashboard h2 {
            font-size: 22px;
            font-weight: bold;
            margin-bottom: 20px;
            color: #1f2937;
        }

        /* Stats Container */
        .stats-container {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-bottom: 25px;
        }

        /* Stat Card */
        .stat-card {
            flex: 1;
            min-width: 220px;
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 3px 8px rgba(0,0,0,0.08);
            padding: 20px;
            text-align: center;
            display: flex;
            align-items: center;
            gap: 15px;
            transition: transform 0.2s ease-in-out;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        /* Icon Style */
        .icon {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
        }

        .green-icon {
            background-color: #d1fae5;
            color: #059669;
        }

        .pink-icon {
            background-color: #ffe4e6;
            color: #db2777;
        }

        /* Text Style */
        .stat-text h3 {
            margin: 0;
            font-size: 26px;
            font-weight: bold;
            color: #111827;
        }

        .stat-text p {
            margin: 5px 0 0;
            font-size: 14px;
            color: #6b7280;
        }

        /* Recent Activities Section */
        .recent-activities {
            background: #fff;
            padding: 15px;
            border-radius: 10px;
            box-shadow: 0 3px 8px rgba(0,0,0,0.08);
            margin-top: 10px;
        }

        .recent-activities h3 {
            font-size: 18px;
            color: #111827;
            margin-bottom: 10px;
        }

        .no-records {
            text-align: center;
            padding: 15px;
            color: #9ca3af;
            font-style: italic;
        }

        /* Responsive Design */
        @media screen and (max-width: 768px) {
            .stats-container {
                flex-direction: column;
            }
        }
    </style>

    <div class="dashboard">
        <h2>Welcome, <?php echo fullname($USER); ?> </h2>

        <!-- Stats Section -->
        <div class="stats-container">
            <div class="stat-card">
                <div class="icon green-icon"><i class="fa fa-graduation-cap"></i></div>
                <div class="stat-text">
                    <h3>5</h3>
                    <p>Learning Paths</p>
                </div>
            </div>
            <div class="stat-card">
                <div class="icon pink-icon"><i class="fa fa-users"></i></div>
                <div class="stat-text">
                    <h3><?php echo $total_batches; ?></h3>
                    <p>Batches</p>
                </div>
            </div>
        </div>

        <!-- Recent Activities -->
        <div class="recent-activities">
            <h3>Recent Activities</h3>
            <div class="no-records">No Records Found</div>
        </div>
    </div>
    <?php
}

// ====== MANAGER DASHBOARD ======
elseif ($ismanager) {
     global $DB;

    // Get student role IDs dynamically (usually roleid = 5)
    $studentroles = $DB->get_records('role', ['shortname' => 'student']);
    $studentroleids = array_keys($studentroles);

    // Prepare SQL for counting learners
    list($roleinsql, $params) = $DB->get_in_or_equal($studentroleids, SQL_PARAMS_NAMED);

   $roleShortName = 'student';

// Query to count all users who have the 'student' role
$sql = "SELECT COUNT(DISTINCT u.id) AS total_users
        FROM {user} u
        JOIN {role_assignments} ra ON ra.userid = u.id
        JOIN {role} r ON r.id = ra.roleid
        WHERE r.shortname = :rolename";

$params = ['rolename' => $roleShortName];
$total_batches = $DB->count_records('cohort'); 
// Execute query
$total_learners = $DB->count_records_sql($sql, $params);

$aws_report_url      = new moodle_url('/course/waws_report.php');
$practice_test_url   = new moodle_url('/course/practice_test_report.php');
$hands_on_lab_url    = new moodle_url('/course/hands_on_lab_report.php');
$online_course_url   = new moodle_url('/course/online_course_report.php');

// Prepare report cards data
$report_cards = [
    ['icon' => 'fa-layer-group',  'title' => 'AWS Digital Course Report', 'url' => $aws_report_url],
    ['icon' => 'fa-edit',         'title' => 'Practice Test Report',      'url' => $practice_test_url],
    ['icon' => 'fa-flask',        'title' => 'Hands-On Labs Report',       'url' => $hands_on_lab_url],
    ['icon' => 'fa-play-circle',  'title' => 'Online Course Report',      'url' => $online_course_url],
];
    ?>
    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        /* Main container */
        .manager-dashboard {
            padding: 20px;
            font-family: 'Segoe UI', sans-serif;
            background-color: #f8fafc;
        }

        /* Welcome text */
        .manager-dashboard .header {
            font-size: 22px;
            font-weight: bold;
            margin-bottom: 20px;
            color: #1f2937;
        }

        /* Stats container */
        .stats-container {
            display: grid;
            grid-template-columns: 1fr 2fr;
            gap: 20px;
            margin-bottom: 25px;
        }

        /* Left vertical card */
        .vertical-card {
            background: #fff;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 3px 8px rgba(0,0,0,0.08);
            display: flex;
            flex-direction: column;
            gap: 20px;
            justify-content: center;
        }

        /* Inside vertical card items */
        .vertical-item {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .vertical-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
        }

        .total-users-icon {
            background-color: #fff3e6;
            color: #f97316;
        }

        .enrolled-icon {
            background-color: #fee2e2;
            color: #ef4444;
        }

        .vertical-text h3 {
            margin: 0;
            font-size: 26px;
            font-weight: bold;
            color: #111827;
        }

        .vertical-text p {
            margin: 0;
            font-size: 14px;
            color: #6b7280;
        }

        /* Horizontal stat cards */
        .horizontal-stats {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }

        .stat-card {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 3px 8px rgba(0,0,0,0.08);
            padding: 20px;
            display: flex;
            align-items: center;
            gap: 15px;
            transition: transform 0.2s ease-in-out;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
        }

        .green-icon {
            background-color: #d1fae5;
            color: #059669;
        }

        .pink-icon {
            background-color: #ffe4e6;
            color: #db2777;
        }

        .stat-info h3 {
            margin: 0;
            font-size: 26px;
            font-weight: bold;
            color: #111827;
        }

        .stat-info p {
            margin: 0;
            font-size: 14px;
            color: #6b7280;
        }

        /* Reports section */
        .report-section {
            margin-top: 25px;
        }

        .reports-row {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
            margin-top: 10px;
        }

        .report-card {
            background: #fffaf5;
            padding: 20px;
            border-radius: 12px;
            text-align: center;
            box-shadow: 0 3px 8px rgba(0,0,0,0.08);
            cursor: pointer;
            transition: transform 0.3s;
        }

        .report-card:hover {
            transform: scale(1.05);
        }

        .report-icon {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: #ffeede;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 30px;
            color: #374151;
            margin: 0 auto 10px;
        }

        .report-card p {
            margin: 0;
            font-size: 14px;
            color: #374151;
            font-weight: 500;
        }

        /* Recent Activities */
        .recent-activities {
            margin-top: 30px;
            background: #fff;
            padding: 15px;
            border-radius: 10px;
            box-shadow: 0 3px 8px rgba(0,0,0,0.08);
        }

        .recent-activities h3 {
            font-size: 18px;
            color: #111827;
            margin-bottom: 10px;
        }

        .no-records {
            text-align: center;
            color: #9ca3af;
            font-style: italic;
            padding: 10px;
        }

        /* Responsive Design */
        @media screen and (max-width: 992px) {
            .stats-container {
                grid-template-columns: 1fr;
            }
            .reports-row {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media screen and (max-width: 576px) {
            .reports-row {
                grid-template-columns: 1fr;
            }
        }
    </style>

    <div class="manager-dashboard">
        <!-- Welcome Header -->
        <div class="header">Welcome, <?php echo fullname($USER); ?> </div>

        <!-- Stats Section -->
        <div class="stats-container">
            <!-- Left Vertical Card -->
            <div class="vertical-card">
                <div class="vertical-item">
                    <div class="vertical-icon total-users-icon"><i class="fa fa-users"></i></div>
                    <div class="vertical-text">
                        <h3><?php echo $total_learners; ?></h3>
                        <p>Total Learners</p>
                    </div>
                </div>
                <div class="vertical-item">
                    <div class="vertical-icon enrolled-icon"><i class="fa fa-book-reader"></i></div>
                    <div class="vertical-text">
                        <h3>8</h3>
                        <p>Learning Paths Enrolled</p>
                    </div>
                </div>
            </div>

            <!-- Right Horizontal Stats -->
            <div class="horizontal-stats">
                <div class="stat-card">
                    <div class="stat-icon green-icon"><i class="fa fa-flask"></i></div>
                    <div class="stat-info">
                        <h3>86</h3>
                        <p>Learning Paths</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon pink-icon"><i class="fa fa-user-friends"></i></div>
                    <div class="stat-info">
                         <h3><?php echo $total_batches; ?></h3>
                        <p>Batches</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Reports Section -->
       <div class="report-section">
    <div class="reports-row">
        <?php foreach ($report_cards as $card): ?>
            <div class="report-card clickable-card" data-url="<?php echo $card['url']; ?>">
                <div class="report-icon"><i class="fa <?php echo $card['icon']; ?>"></i></div>
                <p><?php echo $card['title']; ?></p>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.clickable-card').forEach(function(card) {
        card.addEventListener('click', function() {
            // Navigate to the URL stored in data-url
            var url = card.getAttribute('data-url');
            window.location.href = url;
        });
    });
});
</script>

        <!-- Recent Activities -->
        <div class="recent-activities">
            <h3>Recent Activities</h3>
            <div class="no-records">No Records Found</div>
        </div>
    </div>
    <?php
}

// ====== DEFAULT DASHBOARD ======
else {
    echo $OUTPUT->addblockbutton('content');
    echo $OUTPUT->custom_block_region('content');
}

echo $OUTPUT->footer();

// Trigger event
$eventparams = ['context' => $context];
$event = \core\event\dashboard_viewed::create($eventparams);
$event->trigger();
?>
