<?php
defined('MOODLE_INTERNAL') || die();

class local_welcome_observer {
    public static function user_created_handler(\core\event\user_created $event) {
        global $DB, $CFG;

        require_once($CFG->dirroot.'/user/lib.php');
        require_once($CFG->dirroot.'/lib/moodlelib.php');

        $user = $DB->get_record('user', ['id' => $event->objectid]);
        if (!$user || empty($user->email)) {
            return true;
        }

        // Create a password reset record manually (since core_user::get_password_reset_token does not exist in Moodle 4.0)
        $token = random_string(32);
        $resetrecord = (object)[
            'userid' => $user->id,
            'token' => $token,
            'timerequested' => time(),
            'timererequested' => time()
        ];

        // Insert into user_password_resets
        $DB->insert_record('user_password_resets', $resetrecord);

        // Build reset URL
        $reseturl = $CFG->wwwroot . '/login/forgot_password.php?token=' . $token . '&id=' . $user->id;

        // Email subject & body
    // Email subject
$subject = "Welcome to Trainocate Portal";

// Simple HTML email body – header + plain links, no button
$messagehtml = '
<table width="100%" cellpadding="0" cellspacing="0" style="font-family:Arial,sans-serif;background:#f9f9f9;padding:20px">
  <tr>
    <td>
      <div style="max-width:600px;margin:0 auto;background:#ffffff;border-radius:4px;overflow:hidden;">
        <div style="background:#e34a26;padding:18px;text-align:left;">
          <h2 style="color:#ffffff;margin:0;font-size:20px;">Welcome to Trainocate Portal</h2>
        </div>
        <div style="padding:24px;">
          <p style="font-size:15px;margin:0 0 12px;">Hi '.fullname($user).',</p>
          <p style="font-size:15px;margin:0 0 12px;">
            Welcome to Trainocate. Your account has been created successfully.<br>
            Please find your credentials below:
          </p>
          <p style="font-size:15px;margin:0 0 8px;"><strong>URL:</strong> <a href="'.$CFG->wwwroot.'">'.$CFG->wwwroot.'</a></p>
          <p style="font-size:15px;margin:0 0 8px;"><strong>Username:</strong> '.$user->username.'</p>
          <p style="font-size:15px;margin:0 0 12px;">
            You can set up your account password by clicking on the link below:
          </p>
          <p style="font-size:15px;word-break:break-all;"><a href="'.$reseturl.'">'.$reseturl.'</a></p>
          <p style="font-size:15px;margin-top:20px;">Thanks,<br>Trainocate Team</p>
        </div>
      </div>
    </td>
  </tr>
</table>';

// Plain-text fallback
$messagetext = html_to_text($messagehtml);


        // Send email
        email_to_user($user, core_user::get_support_user(), $subject, $messagetext, $messagehtml);

        return true;
    }
}
