<?php
defined('MOODLE_INTERNAL') || die();

/**
 * Store LTI progress payloads from mod/lti/services.php.
 *
 * @param string $path The request path from LTI.
 * @param string $rawbody The raw JSON string.
 */
function local_ltiprogress_process(string $path, string $rawbody): void {
    global $DB;

    $data = json_decode($rawbody);
    if (!$data || empty($data->userId)) {
        error_log("local_ltiprogress: invalid payload");
        return;
    }

    $userid = (int)$data->userId;
    $activityprogress = $data->activityProgress ?? null;
    $gradingprogress  = $data->gradingProgress ?? null;
    $score = $data->score ?? null;
    $scoremax = $data->scoreMaximum ?? null;

    // Try to extract context and lineitem ids from path
    $courseid = 0; $cmid = 0; $ltiid = 0;
    if (preg_match('#/mod/lti/services\.php/(\d+)/lineitems/(\d+)/#', $path, $m)) {
        $courseid = (int)$m[1];
        $ltiid = (int)$m[2];
    }

    $record = [
        'userid' => $userid,
        'courseid' => $courseid,
        'cmid' => $cmid,
        'ltiid' => $ltiid,
        'activityprogress' => $activityprogress,
        'gradingprogress' => $gradingprogress,
        'score' => $score,
        'scoremax' => $scoremax,
        'timecreated' => time(),
        'timemodified' => time(),
    ];

    $DB->insert_record('local_ltiprogress', $record);
    error_log("local_ltiprogress: stored payload for user {$userid} in course {$courseid}");
}
