<?php
require_once(__DIR__ . '/../config.php');
require_once($CFG->dirroot . '/my/lib.php');
require_once($CFG->libdir . '/tablelib.php');

global $USER;   // <-- bring the global $USER into scope

// Redirect ONLY when user id is 2
if ((int)$USER->id === 2) {
    redirect(new moodle_url('/course/wcompanylist.php'));
    exit;
}
redirect_if_major_upgrade_required();

$edit   = optional_param('edit', null, PARAM_BOOL);
$reset  = optional_param('reset', null, PARAM_BOOL);

require_login();

$hassiteconfig = has_capability('moodle/site:config', context_system::instance());
if ($hassiteconfig && moodle_needs_upgrading()) {
    redirect(new moodle_url('/admin/index.php'));
}

$strmymoodle = get_string('myhome');

if (empty($CFG->enabledashboard)) {
    $defaultpage = get_default_home_page();
    if ($defaultpage == HOMEPAGE_MYCOURSES) {
        redirect(new moodle_url('/my/courses.php'));
    } else {
        throw new moodle_exception('error:dashboardisdisabled', 'my');
    }
}

if (isguestuser()) {
    if (empty($CFG->allowguestmymoodle)) {
        redirect(new moodle_url('/', array('redirect' => 0)));
    }
    $userid = null;
    $USER->editing = $edit = 0;
    $context = context_system::instance();
    $PAGE->set_blocks_editing_capability('moodle/my:configsyspages');
    $pagetitle = "$strmymoodle (" . get_string('guest') . ")";
} else {
    $userid = $USER->id;
    $context = context_user::instance($USER->id);
    $PAGE->set_blocks_editing_capability('moodle/my:manageblocks');
    $pagetitle = $strmymoodle;
}

if (!$currentpage = my_get_page($userid, MY_PAGE_PRIVATE)) {
    print_error('mymoodlesetup');
}

$params = array();
$PAGE->set_context($context);
$PAGE->set_url('/my/index.php', $params);
$PAGE->set_pagelayout('mydashboard');
$PAGE->add_body_class('limitedwidth');
$PAGE->set_pagetype('my-index');
$PAGE->blocks->add_region('content');
$PAGE->set_subpage($currentpage->id);
$PAGE->set_title($pagetitle);
$PAGE->set_heading($pagetitle);

// ===== ROLE-BASED CUSTOM DASHBOARD =====
global $DB, $USER;

$contextsys = context_system::instance();
$userroles = get_user_roles($contextsys, $USER->id);

// Define roles
$learnerroles = ['student', 'learner', 'trainee'];
$managerroles = ['manager'];

$islearner = false;
$ismanager = false;

foreach ($userroles as $role) {
    $r = strtolower($role->shortname);
    if (in_array($r, $learnerroles)) $islearner = true;
    if (in_array($r, $managerroles)) $ismanager = true;
}

echo $OUTPUT->header();
// ====== LEARNER DASHBOARD ======
if ($islearner) {

$assigned_courses = $DB->count_records_sql("
    SELECT COUNT(DISTINCT e.courseid)
    FROM {user_enrolments} ue
    JOIN {enrol} e ON e.id = ue.enrolid
    JOIN {course} c ON c.id = e.courseid
    WHERE ue.userid = :userid
      AND c.visible = 1
", ['userid' => $USER->id]);

// Count all course enrol requests for current user
$requested_courses_count = $DB->count_records_sql("
    SELECT COUNT(*)
    FROM {course_enrol_requests} r
    JOIN {course} c ON c.id = r.courseid
    WHERE r.userid = :userid
", ['userid' => $USER->id]);

$completed_courses_count = $DB->count_records_sql("
    SELECT COUNT(DISTINCT lp.courseid)
    FROM {local_ltiprogress} lp
    WHERE lp.userid = :userid
      AND lp.activityprogress = 'Completed'
", ['userid' => $USER->id]);


    $total_batches = $DB->count_records_sql("
        SELECT COUNT(*) 
        FROM {cohort_members} cm
        JOIN {cohort} c ON cm.cohortid = c.id
        WHERE cm.userid = :userid
    ", ['userid' => $USER->id]);
    ?>
    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        /* Main Container */
        .dashboard {
            padding: 20px;
            font-family: 'Segoe UI', sans-serif;
            background-color: #f8fafc;
        }

        /* Welcome Header */
        .dashboard h2 {
            font-size: 22px;
            font-weight: bold;
            margin-bottom: 20px;
            color: #1f2937;
        }

        /* Stats Container */
        .stats-container {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-bottom: 25px;
        }

        /* Stat Card */
        .stat-card {
            flex: 1;
            min-width: 220px;
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 3px 8px rgba(0,0,0,0.08);
            padding: 20px;
            text-align: center;
            display: flex;
            align-items: center;
            gap: 15px;
            transition: transform 0.2s ease-in-out;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        /* Icon Style */
        .icon {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
        }

        .green-icon {
            background-color: #d1fae5;
            color: #059669;
        }

        .pink-icon {
            background-color: #ffe4e6;
            color: #db2777;
        }

        /* Text Style */
        .stat-text h3 {
            margin: 0;
            font-size: 26px;
            font-weight: bold;
            color: #111827;
        }

        .stat-text p {
            margin: 5px 0 0;
            font-size: 14px;
            color: #6b7280;
        }

        /* Recent Activities Section */
        .recent-activities {
            background: #fff;
            padding: 15px;
            border-radius: 10px;
            box-shadow: 0 3px 8px rgba(0,0,0,0.08);
            margin-top: 10px;
        }

        .recent-activities h3 {
            font-size: 18px;
            color: #111827;
            margin-bottom: 10px;
        }

        .no-records {
            text-align: center;
            padding: 15px;
            color: #9ca3af;
            font-style: italic;
        }

        /* Responsive Design */
        @media screen and (max-width: 768px) {
            .stats-container {
                flex-direction: column;
            }
        }
    </style>

    <div class="dashboard">
        <h2>Welcome, <?php echo fullname($USER); ?> </h2>

        <!-- Stats Section -->
        <div class="stats-container">
             <div class="stat-card">
                <div class="icon green-icon"><i class="fa fa-graduation-cap"></i></div>
                <div class="stat-text">
                      <h3><?php echo $assigned_courses; ?></h3>
                    <p>Assigned Courses</p>
                </div>
            </div> 
            <div class="stat-card">
                <div class="icon pink-icon"><i class="fa fa-users"></i></div>
                <div class="stat-text">
                    <h3><?php echo $requested_courses_count; ?></h3>
                    <p>Requested Courses</p>
                </div>
            </div>
            <div class="stat-card">
                <div class="icon green-icon"><i class="fa fa-graduation-cap"></i></div>
                <div class="stat-text">
                    <h3><?php echo $completed_courses_count; ?></h3>
                    <p>Completed Courses</p>
                </div>
            </div>
        </div>

        <!-- Recent Activities -->
<div class="recent-activities">
    <h3>Recent Activities</h3>
    <?php
    $activities = $DB->get_records_sql("
        SELECT l.id, l.timecreated, l.action, l.target, l.courseid
        FROM {logstore_standard_log} l
        WHERE l.userid = :userid
        ORDER BY l.timecreated DESC
        LIMIT 15
    ", ['userid' => $USER->id]);

    if ($activities) {
        echo '<table class="recent-activities-table">';
        echo '<thead>
                <tr>
                    <th>Date</th>
                    <th>Course</th>
                    <th>Action</th>
                </tr>
              </thead>
              <tbody>';
        foreach ($activities as $act) {
            // Show only date (not time)
            $date = userdate($act->timecreated, get_string('strftimedate'));
            $coursename = $act->courseid ? $DB->get_field('course', 'fullname', ['id' => $act->courseid]) : '-';
            $action = ucfirst($act->action) . ' ' . $act->target;

            echo "<tr>
                    <td>{$date}</td>
                    <td>{$coursename}</td>
                    <td>{$action}</td>
                  </tr>";
        }
        echo '</tbody></table>';
    } else {
        echo '<div class="no-records">No Records Found</div>';
    }
    ?>
</div>

<style>
.recent-activities-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
}

.recent-activities-table th,
.recent-activities-table td {
    border: 1px solid #ddd;
    padding: 10px;
    text-align: left;
    font-size: 14px;
}

.recent-activities-table th {
    background-color: #f5f5f5;
    font-weight: bold;
}

.recent-activities-table tr:nth-child(even) {
    background-color: #fafafa;
}

.recent-activities h3 {
    margin-bottom: 10px;
    font-size: 18px;
    font-weight: 600;
}

.no-records {
    padding: 12px;
    background: #fff3cd;
    border: 1px solid #ffeeba;
    border-radius: 4px;
    margin-top: 10px;
}
</style>


    <?php
}

// ====== MANAGER DASHBOARD ======
elseif ($ismanager) {
     global $DB;
$sql = "
    SELECT COUNT(DISTINCT u.id)
    FROM {user} u
    JOIN {role_assignments} ra ON ra.userid = u.id
    JOIN {role} r ON r.id = ra.roleid
    WHERE r.shortname = :rolename
      AND u.deleted   = 0
      AND u.suspended = 0
      AND u.confirmed = 1
      -- Exclude site admins
      AND u.id NOT IN (
            SELECT sa.id
            FROM {user} sa
            JOIN {config} cfg ON cfg.name = 'siteadmins'
            WHERE FIND_IN_SET(sa.id, cfg.value)
      )
      -- Exclude anyone who also has the manager role
      AND u.id NOT IN (
            SELECT rm.userid
            FROM {role_assignments} rm
            JOIN {role} rr ON rr.id = rm.roleid
            WHERE rr.shortname = 'manager'
      )";

$total_learners = $DB->count_records_sql($sql, ['rolename' => 'student']);



// $total_learners = $DB->count_records_sql($sql_learners, $params_learners);



// Count total managers/admins
    $sql_managers = "SELECT COUNT(DISTINCT u.id) AS total
                     FROM {user} u
                     JOIN {role_assignments} ra ON ra.userid = u.id
                     JOIN {role} r ON r.id = ra.roleid
                     WHERE r.shortname = :rolename
                       AND u.deleted = 0";
    $total_managers = $DB->count_records_sql($sql_managers, ['rolename' => 'manager']);


$sql_cohorts = "SELECT COUNT(*) 
                FROM {cohort}
                WHERE visible = 1";

$total_cohorts = $DB->count_records_sql($sql_cohorts);


$aws_report_url      = new moodle_url('/course/waws_report.php');
$practice_test_url   = new moodle_url('/course/practice_test_report.php');
$hands_on_lab_url    = new moodle_url('/course/hands_on_lab_report.php');
$online_course_url   = new moodle_url('/course/online_course_report.php');

// Prepare report cards data
$report_cards = [
    ['icon' => 'fa-layer-group',  'title' => 'AWS Digital Course Report', 'url' => $aws_report_url],
    // ['icon' => 'fa-edit',         'title' => 'Practice Test Report',      'url' => $practice_test_url],
    // ['icon' => 'fa-flask',        'title' => 'Hands-On Labs Report',       'url' => $hands_on_lab_url],
    // ['icon' => 'fa-play-circle',  'title' => 'Online Course Report',      'url' => $online_course_url],
];
    ?>
    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        /* Main container */
        .manager-dashboard {
            padding: 20px;
            font-family: 'Segoe UI', sans-serif;
            background-color: #f8fafc;
        }

        /* Welcome text */
        .manager-dashboard .header {
            font-size: 22px;
            font-weight: bold;
            margin-bottom: 20px;
            color: #1f2937;
        }

        /* Stats container */
        .stats-container {
            display: grid;
            grid-template-columns: 1fr 2fr;
            gap: 20px;
            margin-bottom: 25px;
        }

        /* Left vertical card */
        .vertical-card {
            background: #fff;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 3px 8px rgba(0,0,0,0.08);
            display: flex;
            flex-direction: column;
            gap: 20px;
            justify-content: center;
        }

        /* Inside vertical card items */
        .vertical-item {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .vertical-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
        }

        .total-users-icon {
            background-color: #fff3e6;
            color: #f97316;
        }

        .enrolled-icon {
            background-color: #fee2e2;
            color: #ef4444;
        }

        .vertical-text h3 {
            margin: 0;
            font-size: 26px;
            font-weight: bold;
            color: #111827;
        }

        .vertical-text p {
            margin: 0;
            font-size: 14px;
            color: #6b7280;
        }

        /* Horizontal stat cards */
        .horizontal-stats {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }

        .stat-card {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 3px 8px rgba(0,0,0,0.08);
            padding: 20px;
            display: flex;
            align-items: center;
            gap: 15px;
            transition: transform 0.2s ease-in-out;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
        }

        .green-icon {
            background-color: #d1fae5;
            color: #059669;
        }

        .pink-icon {
            background-color: #ffe4e6;
            color: #db2777;
        }

        .stat-info h3 {
            margin: 0;
            font-size: 26px;
            font-weight: bold;
            color: #111827;
        }

        .stat-info p {
            margin: 0;
            font-size: 14px;
            color: #6b7280;
        }

        /* Reports section */
        .report-section {
            margin-top: 25px;
        }

        .reports-row {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
            margin-top: 10px;
        }

        .report-card {
            background: #fffaf5;
            padding: 20px;
            border-radius: 12px;
            text-align: center;
            box-shadow: 0 3px 8px rgba(0,0,0,0.08);
            cursor: pointer;
            transition: transform 0.3s;
        }

        .report-card:hover {
            transform: scale(1.05);
        }

        .report-icon {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: #ffeede;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 30px;
            color: #374151;
            margin: 0 auto 10px;
        }

        .report-card p {
            margin: 0;
            font-size: 14px;
            color: #374151;
            font-weight: 500;
        }

        /* Recent Activities */
        .recent-activities {
            margin-top: 30px;
            background: #fff;
            padding: 15px;
            border-radius: 10px;
            box-shadow: 0 3px 8px rgba(0,0,0,0.08);
        }

        .recent-activities h3 {
            font-size: 18px;
            color: #111827;
            margin-bottom: 10px;
        }

        .no-records {
            text-align: center;
            color: #9ca3af;
            font-style: italic;
            padding: 10px;
        }

        /* Responsive Design */
        @media screen and (max-width: 992px) {
            .stats-container {
                grid-template-columns: 1fr;
            }
            .reports-row {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media screen and (max-width: 576px) {
            .reports-row {
                grid-template-columns: 1fr;
            }
        }
    </style>

    <div class="manager-dashboard">
        <!-- Welcome Header -->
        <div class="header">Welcome, <?php echo fullname($USER); ?> </div>

        <!-- Stats Section -->
        <div class="stats-container">
            <!-- Left Vertical Card -->
            <div class="vertical-card">
                <div class="vertical-item">
                    <div class="vertical-icon total-users-icon"><i class="fa fa-users"></i></div>
                    <div class="vertical-text">
                        <h3><?php echo $total_learners; ?></h3>
                        <p>Total Learners</p>
                    </div>
                </div>
                <!-- <div class="vertical-item">
                    <div class="vertical-icon enrolled-icon"><i class="fa fa-book-reader"></i></div>
                    <div class="vertical-text">
                        <h3>8</h3>
                        <p>Learning Paths Enrolled</p>
                    </div>
                </div> -->
            </div>

            <!-- Right Horizontal Stats -->
            <div class="horizontal-stats">
                <!-- <div class="stat-card">
                    <div class="stat-icon green-icon"><i class="fa fa-flask"></i></div>
                    <div class="stat-info">
                        <h3>86</h3>
                        <p>Learning Paths</p>
                    </div>
                </div> -->
                <div class="stat-card">
                    <div class="stat-icon pink-icon"><i class="fa fa-book"></i></div>
                    <div class="stat-info">
                         <h3><?php echo $total_cohorts; ?></h3>
                        <p>Total Batches</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Reports Section -->
       <div class="report-section">
    <div class="reports-row">
        <?php foreach ($report_cards as $card): ?>
            <div class="report-card clickable-card" data-url="<?php echo $card['url']; ?>">
                <div class="report-icon"><i class="fa <?php echo $card['icon']; ?>"></i></div>
                <p><?php echo $card['title']; ?></p>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.clickable-card').forEach(function(card) {
        card.addEventListener('click', function() {
            // Navigate to the URL stored in data-url
            var url = card.getAttribute('data-url');
            window.location.href = url;
        });
    });
});
</script>

       <!-- Recent Activities -->
<div class="recent-activities">
    <h3>Recent Activities</h3>
    <?php
    // Get all student activities, excluding admins.
// Get all student activities, excluding admins, limited to 15 rows
$activities = $DB->get_records_sql(
    "SELECT l.id, l.timecreated, l.userid, l.courseid
     FROM {logstore_standard_log} l
     JOIN {user} u ON u.id = l.userid
     WHERE u.deleted = 0
       AND u.suspended = 0
       AND u.id IN (
         SELECT ra.userid
         FROM {role_assignments} ra
         JOIN {role} r ON ra.roleid = r.id
         WHERE r.shortname = 'student'
           AND ra.userid NOT IN (
               SELECT ra2.userid
               FROM {role_assignments} ra2
               JOIN {role} r2 ON ra2.roleid = r2.id
               WHERE r2.shortname = 'manager'
           )
           AND ra.userid NOT IN (
               SELECT ra3.userid
               FROM {role_assignments} ra3
               JOIN {role} r3 ON ra3.roleid = r3.id
               WHERE r3.shortname = 'admin'
           )
           AND ra.userid NOT IN (1,2)
       )
       AND l.userid != :currentuser
     ORDER BY l.timecreated DESC",
    ['currentuser' => $USER->id],
    0,    // offset
    15    // limit
);

if ($activities) {
    echo '<table class="recent-activities-table">';
    echo '<thead>
            <tr>
                <th>Date</th>
                <th>Student</th>
                <th>Course</th>
                <th>Attempts</th>
            </tr>
          </thead>
          <tbody>';

    foreach ($activities as $act) {
        $date = userdate($act->timecreated, get_string('strftimedate'));
        $student = fullname($DB->get_record('user', ['id' => $act->userid]));
        $coursename = $act->courseid ? $DB->get_field('course', 'fullname', ['id' => $act->courseid]) : '-';

        // Get quiz attempts count for this user and course
        $attempts = $DB->get_field_sql("
            SELECT COUNT(qa.id)
            FROM {quiz_attempts} qa
            JOIN {quiz} q ON qa.quiz = q.id
            WHERE qa.userid = :userid
              AND q.course = :courseid
        ", [
            'userid'   => $act->userid,
            'courseid' => $act->courseid
        ]);

        echo "<tr>
                <td>{$date}</td>
                <td>{$student}</td>
                <td>{$coursename}</td>
                <td>{$attempts}</td>
              </tr>";
    }

    echo '</tbody></table>';
} else {
    echo '<div class="no-records">No Records Found</div>';
}


    ?>
</div>

<style>
.recent-activities-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
}

.recent-activities-table th,
.recent-activities-table td {
    border: 1px solid #ddd;
    padding: 10px;
    text-align: left;
    font-size: 14px;
}

.recent-activities-table th {
    background-color: #f5f5f5;
    font-weight: bold;
}

.recent-activities-table tr:nth-child(even) {
    background-color: #fafafa;
}

.recent-activities h3 {
    margin-bottom: 10px;
    font-size: 18px;
    font-weight: 600;
}

.no-records {
    padding: 12px;
    background: #fff3cd;
    border: 1px solid #ffeeba;
    border-radius: 4px;
    margin-top: 10px;
}
</style>

    <?php
}

// ====== DEFAULT DASHBOARD ======
else {
    echo $OUTPUT->addblockbutton('content');
    echo $OUTPUT->custom_block_region('content');
}

echo $OUTPUT->footer();

// Trigger event
$eventparams = ['context' => $context];
$event = \core\event\dashboard_viewed::create($eventparams);
$event->trigger();
?>
