<?php
require_once(__DIR__ . '/../../config.php');
require_login();
global $DB, $OUTPUT;

require_sesskey();

$term = optional_param('term', '', PARAM_RAW);
$categoryid = optional_param('category', 0, PARAM_INT);

$params = [];
$sql = "SELECT id, fullname FROM {course} WHERE id > 1";

if ($categoryid) {
    $sql .= " AND category = :category";
    $params['category'] = $categoryid;
}

if (!empty($term)) {
    $sql .= " AND fullname LIKE :term";
    $params['term'] = '%' . $DB->sql_like_escape($term) . '%';
}

$sql .= " ORDER BY fullname ASC LIMIT 50"; // limit for performance

$courses = $DB->get_records_sql($sql, $params);
$results = [];

foreach ($courses as $c) {
    $results[] = [
        'id' => $c->id,
        'fullname' => format_string($c->fullname)
    ];
}

echo json_encode(array_values($results));
die;
