define(['jquery', 'core/modal_factory', 'core/modal_events', 'core/str'], function($, ModalFactory, ModalEvents, Str) {

    function init() {
        console.log('✅ Learning Path JS initialized');

        // Handle Add Activity click
        $(document).on('click', '.add-activity', function(e) {
            e.preventDefault();

            const sectionId = $(this).data('section-id');
            const categoryId = $('#categoryid').val();

            if (!categoryId) {
                alert('⚠️ Please select a category first!');
                return;
            }

            $.ajax({
                url: M.cfg.wwwroot + '/local/learningpath/ajax_get_courses.php',
                method: 'GET',
                data: { categoryid: categoryId },
                success: function(response) {
                    try {
                        const data = JSON.parse(response);
                        let bodyHtml = `
                            <div class="form-group">
                                <label>Select Courses</label>
                                <select multiple class="form-control select-courses" style="min-height:200px;">`;

                        data.forEach(c => {
                            bodyHtml += `<option value="${c.id}">${c.fullname}</option>`;
                        });

                        bodyHtml += `
                                </select>
                            </div>
                            <div class="text-right">
                                <button class="btn btn-primary save-activity" data-section-id="${sectionId}">Add</button>
                            </div>
                        `;

                        ModalFactory.create({
                            title: 'Add Activity',
                            body: bodyHtml,
                            type: ModalFactory.types.DEFAULT
                        }).done(function(modal) {
                            modal.show();

                            // Save button inside modal
                            modal.getRoot().on('click', '.save-activity', function() {
                                const selected = [];
                                modal.getRoot().find('.select-courses option:selected').each(function() {
                                    selected.push($(this).val());
                                });

                                if (selected.length === 0) {
                                    alert('Please select at least one course.');
                                    return;
                                }

                                $.ajax({
                                    url: M.cfg.wwwroot + '/local/learningpath/ajax_save_courses.php',
                                    method: 'POST',
                                    data: {
                                        sectionid: sectionId,
                                        courses: selected
                                    },
                                    success: function(res) {
                                        modal.hide();
                                        window.location.reload();
                                    },
                                    error: function(err) {
                                        console.error(err);
                                        alert('Error saving activity');
                                    }
                                });
                            });
                        });

                    } catch (e) {
                        console.error('Invalid JSON', e, response);
                    }
                },
                error: function(err) {
                    console.error(err);
                    alert('Error loading courses');
                }
            });
        });
    }

    return { init: init };
});
