<?php
require_once(__DIR__ . '/../../config.php');
require_login();

global $DB, $USER, $OUTPUT, $PAGE;

// Set up page
$PAGE->set_url(new moodle_url('/local/custompage/requested_course.php'));
$PAGE->set_context(context_system::instance());
$PAGE->set_title('Requested Courses');
$PAGE->set_heading('Requested Courses');

// Include DataTables CSS & JS
echo html_writer::tag('link', '', [
    'rel' => 'stylesheet',
    'type' => 'text/css',
    'href' => 'https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css'
]);
echo html_writer::tag('script', '', [
    'src' => 'https://code.jquery.com/jquery-3.6.0.min.js'
]);
echo html_writer::tag('script', '', [
    'src' => 'https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js'
]);

echo $OUTPUT->header();
echo html_writer::tag('h3', 'My Requested Courses', ['class' => 'mb-3']);

// Fetch all course enrol requests for **current user**
$sql = "SELECT r.id, r.courseid, r.requested_at, c.fullname AS coursename
        FROM {course_enrol_requests} r
        JOIN {course} c ON c.id = r.courseid
        WHERE r.userid = :userid
        ORDER BY r.requested_at DESC";

$requests = $DB->get_records_sql($sql, ['userid' => $USER->id]);

// Create table
$table = new html_table();
$table->id = 'requested_courses';
$table->head = ['Course Name', 'Requested Date'];

// Populate table data
if (!empty($requests)) {
    foreach ($requests as $req) {
        $coursename = format_string($req->coursename);
        $requested_on = userdate($req->requested_at, get_string('strftimedate', 'langconfig')); // Moodle date format

        $table->data[] = [$coursename, $requested_on];
    }
} else {
    // No requests: keep same number of columns
    $table->data[] = ['No course requests found', ''];
}

echo html_writer::table($table);
?>

<!-- Table Styling -->
<style>
#requested_courses td, #requested_courses th {
    padding: 8px;
    text-align: center;
}
</style>

<!-- Initialize DataTables -->
<script>
jQuery(document).ready(function($) {
    $('#requested_courses').DataTable({
        "pageLength": 10,
        "lengthMenu": [[10, 25, 50, 100], [10, 25, 50, 100]],
        "order": [[1, "desc"]],
        "language": {
            "search": "Search:",
            "lengthMenu": "Show _MENU_ entries",
            "info": "Showing _START_ to _END_ of _TOTAL_ requests",
            "paginate": {
                "first": "First",
                "last": "Last",
                "next": "Next",
                "previous": "Previous"
            }
        }
    });
});
</script>

<?php
echo $OUTPUT->footer();
?>
