<?php
require_once(__DIR__ . '/../../config.php');
require_login();

global $DB, $USER, $OUTPUT, $PAGE;

// Get course ID from URL
$courseid = required_param('courseid', PARAM_INT);

// Get course info
$course = $DB->get_record('course', ['id' => $courseid], '*', MUST_EXIST);

// Set up page with system context and minimal layout
$PAGE->set_url(new moodle_url('/local/custompage/enrollment_user_report.php', ['courseid' => $courseid]));
$PAGE->set_context(context_system::instance());
$PAGE->set_title('Enrolled Users for ' . $course->fullname);
$PAGE->set_heading('Enrolled Users for ' . $course->fullname);

echo $OUTPUT->header();
echo html_writer::tag('h3', 'Enrolled Users for ' . $course->fullname, ['class' => 'mb-3']);

// Fetch all enrolled users for the course
$context = context_course::instance($courseid);
$enrolled_users = get_enrolled_users($context);

// Create table
$table = new html_table();
$table->id = 'enrolled_users';
$table->head = ['S.No', 'Full Name', 'Email'];

// Populate table data
if (!empty($enrolled_users)) {
    $count = 1;
    foreach ($enrolled_users as $user) {
        $fullname = fullname($user);
       
        $email = $user->email;
        
        $table->data[] = [$count++, $fullname, $email,];
    }
}  else {
    $table->data[] = ['No users enrolled in this course', '', ''];
}


// Output table
echo html_writer::table($table);

// Include DataTables CSS & JS
echo html_writer::tag('link', '', [
    'rel' => 'stylesheet',
    'type' => 'text/css',
    'href' => 'https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css'
]);
echo html_writer::tag('script', '', ['src' => 'https://code.jquery.com/jquery-3.6.0.min.js']);
echo html_writer::tag('script', '', ['src' => 'https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js']);
?>

<!-- Table Styling -->
<style>
#enrolled_users td, #enrolled_users th {
    padding: 8px;
    text-align: center;
}
</style>

<!-- Initialize DataTables -->
<script>
jQuery(document).ready(function($) {
    $('#enrolled_users').DataTable({
    "pageLength": 10,
    "lengthMenu": [[10, 25, 50, 100], [10, 25, 50, 100]],
    "order": [],             // disable initial ordering
    "columnDefs": [
        { "orderable": false, "targets": 0 } // S.No column cannot be sorted
    ],
    "language": {
        "search": "Search User:",
        "lengthMenu": "Show _MENU_ entries",
        "info": "Showing _START_ to _END_ of _TOTAL_ users",
        "paginate": {
            "first": "First",
            "last": "Last",
            "next": "Next",
            "previous": "Previous"
        }
    }
});

});
</script>

<?php
echo $OUTPUT->footer();
