<?php
require_once(__DIR__ . '/../../config.php');
require_login();
global $DB, $PAGE, $OUTPUT;

$courseid = required_param('course', PARAM_INT);
$batchid = optional_param('batch', 0, PARAM_INT);
$userids = optional_param('userids', '', PARAM_RAW);

$context = context_system::instance();
$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/local/bulk_enrolmanager/preview.php'));
$PAGE->set_title('Enrolment Preview');
$PAGE->set_heading('Enrolment Preview');

$course = $DB->get_record('course', ['id' => $courseid], '*', MUST_EXIST);
$users = [];
if ($userids) {
    list($insql, $params) = $DB->get_in_or_equal(explode(',', $userids));
    $users = $DB->get_records_select('user', "id $insql", $params, '', 'id, firstname, lastname, email');
}

echo $OUTPUT->header();
echo html_writer::tag('h3', 'Preview Enrolment Details', ['style' => 'color:#0073aa;']);

echo html_writer::start_tag('div', ['class' => 'enrol-preview']);
echo html_writer::tag('p', '<strong>Course:</strong> ' . format_string($course->fullname));

if ($batchid) {
    echo html_writer::tag('p', '<strong>Batch ID:</strong> ' . $batchid);
}

if ($users) {
    echo html_writer::start_tag('ul');
    foreach ($users as $u) {
        echo html_writer::tag('li', fullname($u) . " ({$u->email})");
    }
    echo html_writer::end_tag('ul');
} else {
    echo html_writer::tag('p', '<strong>All users in batch will be enrolled.</strong>');
}
echo html_writer::end_tag('div');

// Confirmation form
echo html_writer::start_tag('form', ['method' => 'post', 'action' => new moodle_url('/local/bulk_enrolmanager/enrol_confirm.php')]);
echo html_writer::empty_tag('input', ['type' => 'hidden', 'name' => 'course', 'value' => $courseid]);
echo html_writer::empty_tag('input', ['type' => 'hidden', 'name' => 'batch', 'value' => $batchid]);
echo html_writer::empty_tag('input', ['type' => 'hidden', 'name' => 'userids', 'value' => $userids]);
echo html_writer::tag('button', 'Confirm Enrolment', ['type' => 'submit', 'class' => 'btn btn-success']);
echo html_writer::link(new moodle_url('/local/bulk_enrolmanager/index.php'), 'Cancel', ['class' => 'btn btn-secondary', 'style' => 'margin-left:10px']);
echo html_writer::end_tag('form');

echo $OUTPUT->footer();
