<?php
require_once(__DIR__ . '/../config.php');
require_login();

$courseid = required_param('id', PARAM_INT);
$fieldid  = 22; // 🔹 same AWS custom field ID

global $DB;
$launchurl = $DB->get_field_sql(
    "SELECT cf.value
     FROM {customfield_data} cf
     WHERE cf.instanceid = :courseid AND cf.fieldid = :fieldid",
    ['courseid' => $courseid, 'fieldid' => $fieldid]
);

if ($launchurl) {
    redirect($launchurl);
} else {
    print_error('Launch URL not found');
}
