<?php
require_once(__DIR__ . '/../config.php');
require_login();

// Get cohort ID.
$cohortid = required_param('id', PARAM_INT);

// Context and permission.
$context = context_system::instance();
require_capability('moodle/cohort:view', $context);

// Get cohort record.
$cohort = $DB->get_record('cohort', ['id' => $cohortid], '*', MUST_EXIST);

// Pagination setup.
$perpage = 10; // ✅ 10 rows visible per page
$page = optional_param('page', 0, PARAM_INT);
$offset = $page * $perpage;

// Page setup.
$PAGE->set_url(new moodle_url('/cohort/wbatch_courses.php', ['id' => $cohortid]));
$PAGE->set_context($context);
$PAGE->set_title("Courses in Cohort: {$cohort->name}");
$PAGE->set_heading("Courses in Cohort: {$cohort->name}");

echo $OUTPUT->header();
echo html_writer::tag('h3',  format_string($cohort->name), ['class' => 'mb-3']);

// ✅ SQL query (core logic)
$sql = "SELECT DISTINCT 
            c.id AS courseid,
            c.fullname AS coursename
        FROM {user_enrolments} ue
        JOIN {enrol} e ON e.id = ue.enrolid
        JOIN {course} c ON c.id = e.courseid
        JOIN {cohort_members} cm ON cm.userid = ue.userid
        JOIN {cohort} ch ON ch.id = cm.cohortid
        WHERE ch.id = :cohortid
        ORDER BY c.fullname ASC";

$params = ['cohortid' => $cohortid];

// Count total records.
$totalcourses = $DB->count_records_sql("SELECT COUNT(1) FROM ($sql) temp", $params);

// Add pagination limit.
$sql .= " LIMIT $perpage OFFSET $offset";
$courses = $DB->get_records_sql($sql, $params);

// ✅ Display courses in a Moodle-styled table.
if ($courses) {
    echo html_writer::start_div('table-responsive');
    $table = new html_table();
    $table->head = [
        'Sr. No.',
        'Course Name',
        // get_string('action', 'moodle')
    ];
    $table->attributes['class'] = 'generaltable admintable table-striped table-hover';

    $count = $offset + 1;
    foreach ($courses as $course) {
       $courselink = format_string($course->coursename);


        // $actionlink = html_writer::link(
        //     new moodle_url('/course/view.php', ['id' => $course->courseid]),
        //     $OUTPUT->pix_icon('i/course', get_string('view'))
        // );

        $table->data[] = [
            $count++,
            $courselink,
            // $actionlink
        ];
    }

    echo html_writer::table($table);
    echo html_writer::end_div();

    // ✅ Moodle pagination bar.
    $baseurl = new moodle_url('/cohort/wbatch_courses.php', ['id' => $cohortid]);
    echo $OUTPUT->paging_bar($totalcourses, $page, $perpage, $baseurl);
} else {
    echo $OUTPUT->notification('No courses found for this batch.', 'info');
}

echo $OUTPUT->footer();
