<?php
require_once(__DIR__ . '/../config.php');
require_login();
global $DB, $CFG, $OUTPUT;

$PAGE->set_context(context_system::instance());
$PAGE->set_url(new moodle_url('/course/wcompany.php'));
$PAGE->set_title('Add/Edit Company');

// Enable debugging
@error_reporting(E_ALL | E_STRICT);
@ini_set('display_errors', '1');
$CFG->debug = (E_ALL | E_STRICT);
$CFG->debugdisplay = 1;

// Get company ID from URL if editing
$companyid = optional_param('id', 0, PARAM_INT);
$company = null;

if ($companyid) {
    $company = $DB->get_record('company', ['id' => $companyid], '*', MUST_EXIST);
}

// Handle form submit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $record = new stdClass();
        $record->com_name       = required_param('com_name', PARAM_TEXT);
        $record->class_manager  = required_param('class_manager', PARAM_TEXT);
        $record->phone          = optional_param('phone', 0, PARAM_INT);
        $record->website        = optional_param('website', '', PARAM_RAW_TRIMMED);
        $record->address        = optional_param('address', '', PARAM_TEXT);
        $record->zip            = optional_param('zip', 0, PARAM_INT);

        if ($companyid) {
            $record->id = $companyid;
            $DB->update_record('company', $record);
            redirect(new moodle_url('/course/wcompanylist.php'), '✅ Company updated successfully!', 2);
        } else {
            $record->timecreated = time();
            $DB->insert_record('company', $record);
            redirect(new moodle_url('/course/wcompany.php'), '✅ Company added successfully!', 2);
        }

          redirect(new moodle_url('/course/wcompanylist.php'), '✅ Company saved successfully!', 2);

    } catch (Exception $e) {
        echo $OUTPUT->notification("❌ Database error: " . $e->getMessage(), 'notifyproblem');
    }
}


echo $OUTPUT->header();
?>
<?php
// Get the role ID for 'manager'.
$manager_role = $DB->get_record('role', ['shortname' => 'manager'], '*', MUST_EXIST);

// Fetch all unique users who have the Manager role.
$managers = $DB->get_records_sql("
    SELECT DISTINCT u.id AS userid, u.firstname, u.lastname
    FROM {role_assignments} ra
    JOIN {user} u ON u.id = ra.userid
    WHERE ra.roleid = :roleid
    ORDER BY u.firstname ASC
", ['roleid' => $manager_role->id]);
?>


<!-- CSS Styles -->
<style>
    #page-header { margin-top: 0px !important; }
    #region-main { padding: 0px 0px !important; }

   .company-form-container {
    width: 100%;
    max-width: 1000px; /* reduced max width for mobile */
    margin: 20px auto;
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
    font-family: "Segoe UI", sans-serif;
    overflow: hidden;
    padding: 10px; /* add some padding */
}

    .company-form-header {
        background-color: #f7f7f7;
        padding: 20px 30px;
        font-size: 22px;
        font-weight: bold;
        color: #2c3e50;
        display: flex;
        justify-content: space-between;
        align-items: center;
        border-bottom: 1px solid #ddd;
    }

    .company-form-body {
        padding: 30px;
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 25px;
    }

    .form-group {
        display: flex;
        flex-direction: column;
    }

    .form-group label {
        font-weight: 600;
        margin-bottom: 6px;
        color: #333;
    }

    .form-group input,
    .form-group select,
    .form-group textarea {
        padding: 12px;
        border: 1px solid #ccc;
        border-radius: 6px;
        font-size: 15px;
    }

    textarea {
        resize: vertical;
        height: 100px;
    }

    .company-form-footer {
        grid-column: 1 / -1;
        text-align: right;
        margin-top: 10px;
    }

    @media (max-width: 992px) {
        .company-form-container { width: 90%; margin: 20px auto; }
        .company-form-body { grid-template-columns: 1fr; }
        .company-form-footer { text-align: center; }
    }

    @media (max-width: 480px) {
        .company-form-header {
            flex-direction: column;
            gap: 10px;
            text-align: center;
        }
    }

    .form-group input,
.form-group select,
.form-group textarea {
    width: 100%;
    box-sizing: border-box;
}



</style>


<!-- HTML Form -->
<div class="company-form-container">
    <div class="company-form-header">
        <span><?= $companyid ? 'Edit Company' : 'Add Company' ?></span>
        <a href="#" onclick="window.history.back();" class="btn btn-secondary">Back</a>
    </div>

    <form method="post" class="company-form-body">
        <div class="form-group">
            <label>Company Name *</label>
            <input type="text" name="com_name" required placeholder="Enter company name"
                   value="<?= $company->com_name ?? '' ?>">
        </div>

       <div class="form-group">
    <label>Class Manager *</label>
    <select name="class_manager" required>
        <option value="">Select Class Manager</option>
        <?php foreach ($managers as $manager): ?>
            <option value="<?= $manager->userid ?>"
                <?= isset($company) && $company->class_manager == $manager->userid ? 'selected' : '' ?>>
                <?= fullname($manager) ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>


        <div class="form-group">
            <label>Phone</label>
            <input type="text" name="phone" placeholder="Enter phone number"
                   value="<?= $company->phone ?? '' ?>">
        </div>

        <div class="form-group">
            <label>Website</label>
            <input type="text" name="website" placeholder="Enter website"
                   value="<?= $company->website ?? '' ?>">
        </div>

        <div class="form-group" style="grid-column: 1 / -1;">
            <label>Address</label>
            <textarea name="address" placeholder="Enter company address"><?= $company->address ?? '' ?></textarea>
        </div>

        <div class="form-group">
            <label>Zip Code</label>
            <input type="text" name="zip" placeholder="Enter zip code"
                   value="<?= $company->zip ?? '' ?>">
        </div>

        <div class="company-form-footer">
            <button type="submit" class="btn btn-primary"><?= $companyid ? 'Update' : 'Create' ?></button>
        </div>
    </form>
</div>

<?php echo $OUTPUT->footer(); ?>
