<?php
require('../config.php');
require_login();

$context = context_system::instance();
require_capability('moodle/category:manage', $context);

// Standard Moodle page setup
$PAGE->set_url(new moodle_url('/course/category_display.php'));
$PAGE->set_context($context);
$PAGE->set_pagelayout('report');
$PAGE->set_title(get_string('coursecategories', 'moodle'));
$PAGE->set_heading($SITE->fullname);

echo $OUTPUT->header();

// Load Moodle's flexible table library
require_once($CFG->libdir . '/tablelib.php');

// Add "Add new category" button (top right)
echo html_writer::div(
    $OUTPUT->single_button(
        new moodle_url('/course/editcategory.php', ['parent' => 0]),
        get_string('addnewcategory', 'moodle'),
        'get'
    ),
    'd-flex justify-content-end mb-3'
);

// Handle delete action
$deleteid = optional_param('delete', 0, PARAM_INT);
if ($deleteid) {
    require_sesskey();
    $DB->delete_records('course_categories', ['id' => $deleteid]);
    redirect(new moodle_url('/course/category_display.php'), get_string('categorydeleted', 'moodle'));
}

// Setup flexible table
$table = new flexible_table('course-category-table');
$table->define_columns(['id', 'name', 'parent', 'courses', 'actions']);
$table->define_headers([
    'ID',
    get_string('category'),
    get_string('parentcategory'),
    get_string('courses'),
    get_string('actions')
]);
$table->define_baseurl($PAGE->url);
$table->sortable(true, 'name', SORT_ASC);
$table->pageable(true); // Enable paging
$totalcount = $DB->count_records('course_categories');
$table->pagesize(10, $totalcount); // SHOW 10 RECORDS PER PAGE
$table->set_attribute('class', 'generaltable generalbox boxaligncenter');
$table->setup();

// Get sorting
list($sort, $sortparams) = $table->get_sql_sort();
if (empty($sort)) {
    $sort = 'name ASC';
}

// Fetch paginated data
$categories = $DB->get_records('course_categories', null, $sort,
    '*', $table->get_page_start(), $table->get_page_size());

if ($categories) {
    $rownum = $table->get_page_start() + 1;

    foreach ($categories as $cat) {
        $parentname = ($cat->parent == 0)
            ? get_string('top', 'moodle')
            : $DB->get_field('course_categories', 'name', ['id' => $cat->parent]);

        $coursecount = $DB->count_records('course', ['category' => $cat->id]);

        // Actions
        $editurl = new moodle_url('/course/editcategory.php', ['id' => $cat->id]);
        $deleteurl = new moodle_url('/course/management.php', [
            'categoryid' => $cat->id,
            'sesskey' => sesskey(),
            'action' => 'deletecategory'
        ]);

        $editicon = $OUTPUT->action_icon($editurl,
            new pix_icon('t/edit', get_string('edit')));
        $deleteicon = $OUTPUT->action_icon($deleteurl,
            new pix_icon('t/delete', get_string('delete')));
        $actions = $editicon . ' ' . $deleteicon;

        $table->add_data([
            $rownum++,
            html_writer::link(
                new moodle_url('/course/index.php', ['categoryid' => $cat->id]),
                format_string($cat->name)
            ),
            $parentname,
            $coursecount,
            $actions
        ]);
    }

    // Important → Renders pagination automatically
    $table->finish_output();
} else {
    echo $OUTPUT->notification(get_string('nocategories', 'moodle'), 'notifymessage');
}

echo $OUTPUT->footer();
