<?php
require('../../../config.php');
require_once($CFG->libdir.'/adminlib.php');
require_once($CFG->libdir.'/csvlib.class.php');
require_once($CFG->dirroot.'/'.$CFG->admin.'/tool/uploaduser/locallib.php');
require_once($CFG->dirroot.'/'.$CFG->admin.'/tool/uploaduser/user_form.php');

$iid         = optional_param('iid', '', PARAM_INT);
$previewrows = optional_param('previewrows', 10, PARAM_INT);

core_php_time_limit::raise(60 * 60);
raise_memory_limit(MEMORY_HUGE);

admin_externalpage_setup('tooluploaduser');

$returnurl = new moodle_url('/admin/tool/uploaduser/index.php');
$bulknurl  = new moodle_url('/admin/user/user_bulk.php');

// Start session to carry role between forms
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (empty($iid)) {
    $mform1 = new admin_uploaduser_form1();

    if ($formdata = $mform1->get_data()) {
        // Store selected role in session
        $_SESSION['uploaduser_assignrole'] = $formdata->assignrole;

        $iid = csv_import_reader::get_new_iid('uploaduser');
        $cir = new csv_import_reader($iid, 'uploaduser');

       $content = $mform1->get_file_content('userfile');
$delimiter = isset($formdata->delimiter_name) ? $formdata->delimiter_name : ','; // default comma
$readcount = $cir->load_csv_content($content, $formdata->encoding, $delimiter);
$csvloaderror = $cir->get_error();
unset($content);


        if (!is_null($csvloaderror)) {
            print_error('csvloaderror', '', $returnurl, $csvloaderror);
        }
    } else {
        echo $OUTPUT->header();
        echo $OUTPUT->heading_with_help(get_string('uploadusers', 'tool_uploaduser'), 'uploadusers', 'tool_uploaduser');
        $mform1->display();
        echo $OUTPUT->footer();
        die;
    }
} else {
    $cir = new csv_import_reader($iid, 'uploaduser');
}

// Test if columns ok
$process = new \tool_uploaduser\process($cir);
$filecolumns = $process->get_file_columns();

// Pass stored role from session to form2
$mform2 = new admin_uploaduser_form2(null, [
    'columns' => $filecolumns,
    'data' => [
        'iid' => $iid,
        'previewrows' => $previewrows,
        'assignrole' => $_SESSION['uploaduser_assignrole'] ?? null
    ]
]);

if ($formdata = $mform2->is_cancelled()) {
    $cir->cleanup(true);
    redirect($returnurl);

} else if ($formdata = $mform2->get_data()) {
    echo $OUTPUT->header();
    echo $OUTPUT->heading(get_string('uploadusersresult', 'tool_uploaduser'));

    // Ensure role is set
    if (!isset($formdata->assignrole)) {
        $formdata->assignrole = $_SESSION['uploaduser_assignrole'] ?? null;
    }

    $process->set_form_data($formdata);
    $process->process();

    echo $OUTPUT->box_start('boxwidthnarrow boxaligncenter generalbox', 'uploadresults');
    echo html_writer::tag('p', join('<br />', $process->get_stats()));
    echo $OUTPUT->box_end();

    if ($process->get_bulk()) {
        echo $OUTPUT->continue_button($bulknurl);
    } else {
        echo $OUTPUT->continue_button($returnurl);
    }
    echo $OUTPUT->footer();
    die;
}

// Preview table
echo $OUTPUT->header();
echo $OUTPUT->heading(get_string('uploaduserspreview', 'tool_uploaduser'));

$table = new \tool_uploaduser\preview($cir, $filecolumns, $previewrows);
echo html_writer::tag('div', html_writer::table($table), ['class' => 'flexible-wrap']);

if ($table->get_no_error()) {
    $mform2->display();
}
echo $OUTPUT->footer();
die;
