-- MySQL dump 10.13  Distrib 8.0.43, for Linux (x86_64)
--
-- Host: localhost    Database: Trainocate-lms
-- ------------------------------------------------------
-- Server version	8.0.43-0ubuntu0.24.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `mdl_adminpresets`
--

DROP TABLE IF EXISTS `mdl_adminpresets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_adminpresets` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comments` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `site` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `author` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moodleversion` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `moodlerelease` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `iscore` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timeimported` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Table to store presets data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_adminpresets`
--

LOCK TABLES `mdl_adminpresets` WRITE;
/*!40000 ALTER TABLE `mdl_adminpresets` DISABLE KEYS */;
INSERT INTO `mdl_adminpresets` VALUES (1,0,'Starter','Moodle with all of the most popular features, including Assignment, Feedback, Forum, H5P, Quiz and Completion tracking.','http://lms.techgigs.in/Trainocate','','','',1,1753775879,0),(2,0,'Full','All the Starter features plus External (LTI) tool, SCORM, Workshop, Analytics, Badges, Competencies, Learning plans and lots more.','http://lms.techgigs.in/Trainocate','','','',2,1753775880,0);
/*!40000 ALTER TABLE `mdl_adminpresets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_adminpresets_app`
--

DROP TABLE IF EXISTS `mdl_adminpresets_app`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_adminpresets_app` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `time` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_admiapp_adm_ix` (`adminpresetid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Applied presets';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_adminpresets_app`
--

LOCK TABLES `mdl_adminpresets_app` WRITE;
/*!40000 ALTER TABLE `mdl_adminpresets_app` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_adminpresets_app` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_adminpresets_app_it`
--

DROP TABLE IF EXISTS `mdl_adminpresets_app_it`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_adminpresets_app_it` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetapplyid` bigint NOT NULL,
  `configlogid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_admiappit_con_ix` (`configlogid`),
  KEY `mdl_admiappit_adm_ix` (`adminpresetapplyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Admin presets applied items. To maintain the relation with c';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_adminpresets_app_it`
--

LOCK TABLES `mdl_adminpresets_app_it` WRITE;
/*!40000 ALTER TABLE `mdl_adminpresets_app_it` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_adminpresets_app_it` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_adminpresets_app_it_a`
--

DROP TABLE IF EXISTS `mdl_adminpresets_app_it_a`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_adminpresets_app_it_a` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetapplyid` bigint NOT NULL,
  `configlogid` bigint NOT NULL,
  `itemname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_admiappita_con_ix` (`configlogid`),
  KEY `mdl_admiappita_adm_ix` (`adminpresetapplyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Attributes of the applied items';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_adminpresets_app_it_a`
--

LOCK TABLES `mdl_adminpresets_app_it_a` WRITE;
/*!40000 ALTER TABLE `mdl_adminpresets_app_it_a` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_adminpresets_app_it_a` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_adminpresets_app_plug`
--

DROP TABLE IF EXISTS `mdl_adminpresets_app_plug`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_adminpresets_app_plug` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetapplyid` bigint NOT NULL,
  `plugin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` smallint NOT NULL DEFAULT '0',
  `oldvalue` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_admiappplug_adm_ix` (`adminpresetapplyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Admin presets plugins applied';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_adminpresets_app_plug`
--

LOCK TABLES `mdl_adminpresets_app_plug` WRITE;
/*!40000 ALTER TABLE `mdl_adminpresets_app_plug` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_adminpresets_app_plug` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_adminpresets_it`
--

DROP TABLE IF EXISTS `mdl_adminpresets_it`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_adminpresets_it` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetid` bigint NOT NULL,
  `plugin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_admiit_adm_ix` (`adminpresetid`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Table to store settings';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_adminpresets_it`
--

LOCK TABLES `mdl_adminpresets_it` WRITE;
/*!40000 ALTER TABLE `mdl_adminpresets_it` DISABLE KEYS */;
INSERT INTO `mdl_adminpresets_it` VALUES (1,1,'none','usecomments','0'),(2,1,'none','usetags','0'),(3,1,'none','enablenotes','0'),(4,1,'none','enableblogs','0'),(5,1,'none','enablebadges','0'),(6,1,'none','enableanalytics','0'),(7,1,'core_competency','enabled','0'),(8,1,'core_competency','pushcourseratingstouserplans','0'),(9,1,'tool_dataprivacy','showdataretentionsummary','0'),(10,1,'none','forum_maxattachments','3'),(11,1,'none','guestloginbutton','0'),(12,1,'none','activitychoosertabmode','1'),(13,2,'none','usecomments','1'),(14,2,'none','usetags','1'),(15,2,'none','enablenotes','1'),(16,2,'none','enableblogs','1'),(17,2,'none','enablebadges','1'),(18,2,'none','enableanalytics','1'),(19,2,'core_competency','enabled','1'),(20,2,'core_competency','pushcourseratingstouserplans','1'),(21,2,'tool_dataprivacy','showdataretentionsummary','1'),(22,2,'none','forum_maxattachments','9'),(23,2,'none','guestloginbutton','1'),(24,2,'none','activitychoosertabmode','0');
/*!40000 ALTER TABLE `mdl_adminpresets_it` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_adminpresets_it_a`
--

DROP TABLE IF EXISTS `mdl_adminpresets_it_a`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_adminpresets_it_a` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `itemid` bigint NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_admiita_ite_ix` (`itemid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Admin presets items attributes. For settings with attributes';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_adminpresets_it_a`
--

LOCK TABLES `mdl_adminpresets_it_a` WRITE;
/*!40000 ALTER TABLE `mdl_adminpresets_it_a` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_adminpresets_it_a` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_adminpresets_plug`
--

DROP TABLE IF EXISTS `mdl_adminpresets_plug`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_adminpresets_plug` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetid` bigint NOT NULL,
  `plugin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `enabled` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_admiplug_adm_ix` (`adminpresetid`)
) ENGINE=InnoDB AUTO_INCREMENT=118 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Admin presets plugins status, to store information about whe';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_adminpresets_plug`
--

LOCK TABLES `mdl_adminpresets_plug` WRITE;
/*!40000 ALTER TABLE `mdl_adminpresets_plug` DISABLE KEYS */;
INSERT INTO `mdl_adminpresets_plug` VALUES (1,1,'mod','chat',0),(2,1,'mod','data',0),(3,1,'mod','lti',0),(4,1,'mod','imscp',0),(5,1,'mod','lesson',0),(6,1,'mod','scorm',0),(7,1,'mod','survey',0),(8,1,'mod','wiki',0),(9,1,'mod','workshop',0),(10,1,'availability','grouping',0),(11,1,'availability','profile',0),(12,1,'block','activity_modules',0),(13,1,'block','blog_menu',0),(14,1,'block','blog_tags',0),(15,1,'block','comments',0),(16,1,'block','completionstatus',0),(17,1,'block','course_summary',0),(18,1,'block','course_list',0),(19,1,'block','tag_flickr',0),(20,1,'block','globalsearch',0),(21,1,'block','badges',0),(22,1,'block','lp',0),(23,1,'block','myprofile',0),(24,1,'block','login',0),(25,1,'block','site_main_menu',0),(26,1,'block','mentees',0),(27,1,'block','mnet_hosts',0),(28,1,'block','private_files',0),(29,1,'block','blog_recent',0),(30,1,'block','rss_client',0),(31,1,'block','search_forums',0),(32,1,'block','section_links',0),(33,1,'block','selfcompletion',0),(34,1,'block','social_activities',0),(35,1,'block','tags',0),(36,1,'block','tag_youtube',0),(37,1,'block','feedback',0),(38,1,'block','online_users',0),(39,1,'block','recentlyaccessedcourses',0),(40,1,'block','starredcourses',0),(41,1,'format','social',0),(42,1,'dataformat','json',0),(43,1,'enrol','cohort',0),(44,1,'enrol','guest',0),(45,1,'filter','mathjaxloader',-9999),(46,1,'filter','activitynames',-9999),(47,1,'qbehaviour','adaptivenopenalty',0),(48,1,'qbehaviour','deferredcbm',0),(49,1,'qbehaviour','immediatecbm',0),(50,1,'qtype','calculated',0),(51,1,'qtype','calculatedmulti',0),(52,1,'qtype','calculatedsimple',0),(53,1,'qtype','ddmarker',0),(54,1,'qtype','ddimageortext',0),(55,1,'qtype','multianswer',0),(56,1,'qtype','numerical',0),(57,1,'qtype','randomsamatch',0),(58,1,'repository','local',0),(59,1,'repository','url',0),(60,1,'repository','wikimedia',0),(61,1,'editor','tinymce',0),(62,2,'mod','chat',1),(63,2,'mod','data',1),(64,2,'mod','lti',1),(65,2,'mod','imscp',1),(66,2,'mod','lesson',1),(67,2,'mod','scorm',1),(68,2,'mod','survey',1),(69,2,'mod','wiki',1),(70,2,'mod','workshop',1),(71,2,'availability','grouping',1),(72,2,'availability','profile',1),(73,2,'block','activity_modules',1),(74,2,'block','blog_menu',1),(75,2,'block','blog_tags',1),(76,2,'block','comments',1),(77,2,'block','completionstatus',1),(78,2,'block','course_list',1),(79,2,'block','tag_flickr',1),(80,2,'block','globalsearch',1),(81,2,'block','badges',1),(82,2,'block','lp',1),(83,2,'block','myprofile',1),(84,2,'block','login',1),(85,2,'block','site_main_menu',1),(86,2,'block','mentees',1),(87,2,'block','mnet_hosts',1),(88,2,'block','private_files',1),(89,2,'block','blog_recent',1),(90,2,'block','search_forums',1),(91,2,'block','section_links',1),(92,2,'block','social_activities',1),(93,2,'block','tags',1),(94,2,'block','online_users',1),(95,2,'block','recentlyaccessedcourses',1),(96,2,'block','starredcourses',1),(97,2,'format','social',1),(98,2,'dataformat','json',1),(99,2,'enrol','cohort',1),(100,2,'enrol','guest',1),(101,2,'filter','mathjaxloader',1),(102,2,'filter','activitynames',1),(103,2,'qbehaviour','adaptivenopenalty',1),(104,2,'qbehaviour','deferredcbm',1),(105,2,'qbehaviour','immediatecbm',1),(106,2,'qtype','calculated',1),(107,2,'qtype','calculatedmulti',1),(108,2,'qtype','calculatedsimple',1),(109,2,'qtype','ddmarker',1),(110,2,'qtype','ddimageortext',1),(111,2,'qtype','multianswer',1),(112,2,'qtype','numerical',1),(113,2,'qtype','randomsamatch',1),(114,2,'repository','local',1),(115,2,'repository','url',1),(116,2,'repository','wikimedia',1),(117,2,'editor','tinymce',1);
/*!40000 ALTER TABLE `mdl_adminpresets_plug` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_indicator_calc`
--

DROP TABLE IF EXISTS `mdl_analytics_indicator_calc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_analytics_indicator_calc` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `starttime` bigint NOT NULL,
  `endtime` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `sampleorigin` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sampleid` bigint NOT NULL,
  `indicator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` decimal(10,2) DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analindicalc_staendcon_ix` (`starttime`,`endtime`,`contextid`),
  KEY `mdl_analindicalc_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stored indicator calculations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_indicator_calc`
--

LOCK TABLES `mdl_analytics_indicator_calc` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_indicator_calc` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_indicator_calc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_models`
--

DROP TABLE IF EXISTS `mdl_analytics_models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_analytics_models` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `trained` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `indicators` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `timesplitting` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `predictionsprocessor` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` bigint NOT NULL,
  `contextids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint DEFAULT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analmode_enatra_ix` (`enabled`,`trained`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Analytic models.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_models`
--

LOCK TABLES `mdl_analytics_models` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_models` DISABLE KEYS */;
INSERT INTO `mdl_analytics_models` VALUES (1,0,0,NULL,'\\core_course\\analytics\\target\\course_dropout','[\"\\\\core\\\\analytics\\\\indicator\\\\any_access_after_end\",\"\\\\core\\\\analytics\\\\indicator\\\\any_access_before_start\",\"\\\\core\\\\analytics\\\\indicator\\\\any_write_action_in_course\",\"\\\\core\\\\analytics\\\\indicator\\\\read_actions\",\"\\\\core_course\\\\analytics\\\\indicator\\\\completion_enabled\",\"\\\\core_course\\\\analytics\\\\indicator\\\\potential_cognitive_depth\",\"\\\\core_course\\\\analytics\\\\indicator\\\\potential_social_breadth\",\"\\\\mod_assign\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_assign\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_book\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_book\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_chat\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_chat\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_choice\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_choice\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_data\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_data\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_feedback\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_feedback\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_folder\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_folder\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_forum\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_forum\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_glossary\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_glossary\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_imscp\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_imscp\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_label\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_label\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_lesson\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_lesson\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_lti\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_lti\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_page\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_page\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_quiz\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_quiz\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_resource\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_resource\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_scorm\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_scorm\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_survey\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_survey\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_url\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_url\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_wiki\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_wiki\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_workshop\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_workshop\\\\analytics\\\\indicator\\\\social_breadth\"]',NULL,NULL,1753775883,NULL,1753775883,1753775883,0),(2,1,1,NULL,'\\core_course\\analytics\\target\\no_teaching','[\"\\\\core_course\\\\analytics\\\\indicator\\\\no_teacher\",\"\\\\core_course\\\\analytics\\\\indicator\\\\no_student\"]','\\core\\analytics\\time_splitting\\single_range',NULL,1753775883,NULL,1753775883,1753775883,0),(3,1,1,NULL,'\\core_user\\analytics\\target\\upcoming_activities_due','[\"\\\\core_course\\\\analytics\\\\indicator\\\\activities_due\"]','\\core\\analytics\\time_splitting\\upcoming_week',NULL,1753775883,NULL,1753775883,1753775883,0),(4,1,1,NULL,'\\core_course\\analytics\\target\\no_access_since_course_start','[\"\\\\core\\\\analytics\\\\indicator\\\\any_course_access\"]','\\core\\analytics\\time_splitting\\one_month_after_start',NULL,1753775883,NULL,1753775883,1753775883,0),(5,1,1,NULL,'\\core_course\\analytics\\target\\no_recent_accesses','[\"\\\\core\\\\analytics\\\\indicator\\\\any_course_access\"]','\\core\\analytics\\time_splitting\\past_month',NULL,1753775883,NULL,1753775883,1753775883,0);
/*!40000 ALTER TABLE `mdl_analytics_models` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_models_log`
--

DROP TABLE IF EXISTS `mdl_analytics_models_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_analytics_models_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `version` bigint NOT NULL,
  `evaluationmode` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `target` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `indicators` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `timesplitting` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `score` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `info` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `dir` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analmodelog_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Analytic models changes during evaluation.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_models_log`
--

LOCK TABLES `mdl_analytics_models_log` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_models_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_models_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_predict_samples`
--

DROP TABLE IF EXISTS `mdl_analytics_predict_samples`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_analytics_predict_samples` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `analysableid` bigint NOT NULL,
  `timesplitting` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rangeindex` bigint NOT NULL,
  `sampleids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_analpredsamp_modanatimr_ix` (`modelid`,`analysableid`,`timesplitting`,`rangeindex`),
  KEY `mdl_analpredsamp_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Samples already used for predictions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_predict_samples`
--

LOCK TABLES `mdl_analytics_predict_samples` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_predict_samples` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_predict_samples` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_prediction_actions`
--

DROP TABLE IF EXISTS `mdl_analytics_prediction_actions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_analytics_prediction_actions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `predictionid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `actionname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analpredacti_preuseact_ix` (`predictionid`,`userid`,`actionname`),
  KEY `mdl_analpredacti_pre_ix` (`predictionid`),
  KEY `mdl_analpredacti_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Register of user actions over predictions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_prediction_actions`
--

LOCK TABLES `mdl_analytics_prediction_actions` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_prediction_actions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_prediction_actions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_predictions`
--

DROP TABLE IF EXISTS `mdl_analytics_predictions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_analytics_predictions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `sampleid` bigint NOT NULL,
  `rangeindex` mediumint NOT NULL,
  `prediction` decimal(10,2) NOT NULL,
  `predictionscore` decimal(10,5) NOT NULL,
  `calculations` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timestart` bigint DEFAULT NULL,
  `timeend` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analpred_modcon_ix` (`modelid`,`contextid`),
  KEY `mdl_analpred_mod_ix` (`modelid`),
  KEY `mdl_analpred_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Predictions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_predictions`
--

LOCK TABLES `mdl_analytics_predictions` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_predictions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_predictions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_train_samples`
--

DROP TABLE IF EXISTS `mdl_analytics_train_samples`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_analytics_train_samples` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `analysableid` bigint NOT NULL,
  `timesplitting` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sampleids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_analtraisamp_modanatim_ix` (`modelid`,`analysableid`,`timesplitting`),
  KEY `mdl_analtraisamp_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Samples used for training';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_train_samples`
--

LOCK TABLES `mdl_analytics_train_samples` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_train_samples` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_train_samples` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_used_analysables`
--

DROP TABLE IF EXISTS `mdl_analytics_used_analysables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_analytics_used_analysables` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `analysableid` bigint NOT NULL,
  `firstanalysis` bigint NOT NULL,
  `timeanalysed` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analusedanal_modact_ix` (`modelid`,`action`),
  KEY `mdl_analusedanal_ana_ix` (`analysableid`),
  KEY `mdl_analusedanal_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='List of analysables used by each model';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_used_analysables`
--

LOCK TABLES `mdl_analytics_used_analysables` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_used_analysables` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_used_analysables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_used_files`
--

DROP TABLE IF EXISTS `mdl_analytics_used_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_analytics_used_files` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL DEFAULT '0',
  `fileid` bigint NOT NULL DEFAULT '0',
  `action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `time` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_analusedfile_modactfil_ix` (`modelid`,`action`,`fileid`),
  KEY `mdl_analusedfile_mod_ix` (`modelid`),
  KEY `mdl_analusedfile_fil_ix` (`fileid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Files that have already been used for training and predictio';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_used_files`
--

LOCK TABLES `mdl_analytics_used_files` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_used_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_used_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign`
--

DROP TABLE IF EXISTS `mdl_assign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assign` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `alwaysshowdescription` tinyint NOT NULL DEFAULT '0',
  `nosubmissions` tinyint NOT NULL DEFAULT '0',
  `submissiondrafts` tinyint NOT NULL DEFAULT '0',
  `sendnotifications` tinyint NOT NULL DEFAULT '0',
  `sendlatenotifications` tinyint NOT NULL DEFAULT '0',
  `duedate` bigint NOT NULL DEFAULT '0',
  `allowsubmissionsfromdate` bigint NOT NULL DEFAULT '0',
  `grade` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `requiresubmissionstatement` tinyint NOT NULL DEFAULT '0',
  `completionsubmit` tinyint NOT NULL DEFAULT '0',
  `cutoffdate` bigint NOT NULL DEFAULT '0',
  `gradingduedate` bigint NOT NULL DEFAULT '0',
  `teamsubmission` tinyint NOT NULL DEFAULT '0',
  `requireallteammemberssubmit` tinyint NOT NULL DEFAULT '0',
  `teamsubmissiongroupingid` bigint NOT NULL DEFAULT '0',
  `blindmarking` tinyint NOT NULL DEFAULT '0',
  `hidegrader` tinyint NOT NULL DEFAULT '0',
  `revealidentities` tinyint NOT NULL DEFAULT '0',
  `attemptreopenmethod` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  `maxattempts` mediumint NOT NULL DEFAULT '-1',
  `markingworkflow` tinyint NOT NULL DEFAULT '0',
  `markingallocation` tinyint NOT NULL DEFAULT '0',
  `sendstudentnotifications` tinyint NOT NULL DEFAULT '1',
  `preventsubmissionnotingroup` tinyint NOT NULL DEFAULT '0',
  `activity` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `activityformat` smallint NOT NULL DEFAULT '0',
  `timelimit` bigint NOT NULL DEFAULT '0',
  `submissionattachments` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assi_cou_ix` (`course`),
  KEY `mdl_assi_tea_ix` (`teamsubmissiongroupingid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table saves information about an instance of mod_assign';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign`
--

LOCK TABLES `mdl_assign` WRITE;
/*!40000 ALTER TABLE `mdl_assign` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_grades`
--

DROP TABLE IF EXISTS `mdl_assign_grades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assign_grades` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `grader` bigint NOT NULL DEFAULT '0',
  `grade` decimal(10,5) DEFAULT '0.00000',
  `attemptnumber` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_assigrad_assuseatt_uix` (`assignment`,`userid`,`attemptnumber`),
  KEY `mdl_assigrad_use_ix` (`userid`),
  KEY `mdl_assigrad_att_ix` (`attemptnumber`),
  KEY `mdl_assigrad_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Grading information about a single assignment submission.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_grades`
--

LOCK TABLES `mdl_assign_grades` WRITE;
/*!40000 ALTER TABLE `mdl_assign_grades` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_grades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_overrides`
--

DROP TABLE IF EXISTS `mdl_assign_overrides`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assign_overrides` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint DEFAULT NULL,
  `userid` bigint DEFAULT NULL,
  `sortorder` bigint DEFAULT NULL,
  `allowsubmissionsfromdate` bigint DEFAULT NULL,
  `duedate` bigint DEFAULT NULL,
  `cutoffdate` bigint DEFAULT NULL,
  `timelimit` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_assiover_ass_ix` (`assignid`),
  KEY `mdl_assiover_gro_ix` (`groupid`),
  KEY `mdl_assiover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The overrides to assign settings.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_overrides`
--

LOCK TABLES `mdl_assign_overrides` WRITE;
/*!40000 ALTER TABLE `mdl_assign_overrides` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_overrides` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_plugin_config`
--

DROP TABLE IF EXISTS `mdl_assign_plugin_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assign_plugin_config` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `plugin` varchar(28) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subtype` varchar(28) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(28) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_assiplugconf_plu_ix` (`plugin`),
  KEY `mdl_assiplugconf_sub_ix` (`subtype`),
  KEY `mdl_assiplugconf_nam_ix` (`name`),
  KEY `mdl_assiplugconf_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Config data for an instance of a plugin in an assignment.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_plugin_config`
--

LOCK TABLES `mdl_assign_plugin_config` WRITE;
/*!40000 ALTER TABLE `mdl_assign_plugin_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_plugin_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_submission`
--

DROP TABLE IF EXISTS `mdl_assign_submission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assign_submission` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `timestarted` bigint DEFAULT NULL,
  `status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `groupid` bigint NOT NULL DEFAULT '0',
  `attemptnumber` bigint NOT NULL DEFAULT '0',
  `latest` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_assisubm_assusegroatt_uix` (`assignment`,`userid`,`groupid`,`attemptnumber`),
  KEY `mdl_assisubm_use_ix` (`userid`),
  KEY `mdl_assisubm_att_ix` (`attemptnumber`),
  KEY `mdl_assisubm_assusegrolat_ix` (`assignment`,`userid`,`groupid`,`latest`),
  KEY `mdl_assisubm_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table keeps information about student interactions with';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_submission`
--

LOCK TABLES `mdl_assign_submission` WRITE;
/*!40000 ALTER TABLE `mdl_assign_submission` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_submission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_user_flags`
--

DROP TABLE IF EXISTS `mdl_assign_user_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assign_user_flags` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `assignment` bigint NOT NULL DEFAULT '0',
  `locked` bigint NOT NULL DEFAULT '0',
  `mailed` smallint NOT NULL DEFAULT '0',
  `extensionduedate` bigint NOT NULL DEFAULT '0',
  `workflowstate` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allocatedmarker` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assiuserflag_mai_ix` (`mailed`),
  KEY `mdl_assiuserflag_use_ix` (`userid`),
  KEY `mdl_assiuserflag_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='List of flags that can be set for a single user in a single ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_user_flags`
--

LOCK TABLES `mdl_assign_user_flags` WRITE;
/*!40000 ALTER TABLE `mdl_assign_user_flags` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_user_flags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_user_mapping`
--

DROP TABLE IF EXISTS `mdl_assign_user_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assign_user_mapping` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assiusermapp_ass_ix` (`assignment`),
  KEY `mdl_assiusermapp_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Map an assignment specific id number to a user';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_user_mapping`
--

LOCK TABLES `mdl_assign_user_mapping` WRITE;
/*!40000 ALTER TABLE `mdl_assign_user_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_user_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_comments`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assignfeedback_comments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `grade` bigint NOT NULL DEFAULT '0',
  `commenttext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `commentformat` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assicomm_ass_ix` (`assignment`),
  KEY `mdl_assicomm_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Text feedback for submitted assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_comments`
--

LOCK TABLES `mdl_assignfeedback_comments` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_annot`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_annot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assignfeedback_editpdf_annot` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `gradeid` bigint NOT NULL DEFAULT '0',
  `pageno` bigint NOT NULL DEFAULT '0',
  `x` bigint DEFAULT '0',
  `y` bigint DEFAULT '0',
  `endx` bigint DEFAULT '0',
  `endy` bigint DEFAULT '0',
  `path` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'line',
  `colour` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'black',
  `draft` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_assieditanno_grapag_ix` (`gradeid`,`pageno`),
  KEY `mdl_assieditanno_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='stores annotations added to pdfs submitted by students';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_annot`
--

LOCK TABLES `mdl_assignfeedback_editpdf_annot` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_annot` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_annot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_cmnt`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_cmnt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assignfeedback_editpdf_cmnt` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `gradeid` bigint NOT NULL DEFAULT '0',
  `x` bigint DEFAULT '0',
  `y` bigint DEFAULT '0',
  `width` bigint DEFAULT '120',
  `rawtext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `pageno` bigint NOT NULL DEFAULT '0',
  `colour` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'black',
  `draft` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_assieditcmnt_grapag_ix` (`gradeid`,`pageno`),
  KEY `mdl_assieditcmnt_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores comments added to pdfs';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_cmnt`
--

LOCK TABLES `mdl_assignfeedback_editpdf_cmnt` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_cmnt` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_cmnt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_queue`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assignfeedback_editpdf_queue` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `submissionid` bigint NOT NULL,
  `submissionattempt` bigint NOT NULL,
  `attemptedconversions` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_assieditqueu_subsub_uix` (`submissionid`,`submissionattempt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Queue for processing.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_queue`
--

LOCK TABLES `mdl_assignfeedback_editpdf_queue` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_quick`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_quick`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assignfeedback_editpdf_quick` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `rawtext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` bigint NOT NULL DEFAULT '120',
  `colour` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'yellow',
  PRIMARY KEY (`id`),
  KEY `mdl_assieditquic_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores teacher specified quicklist comments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_quick`
--

LOCK TABLES `mdl_assignfeedback_editpdf_quick` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_quick` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_quick` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_rot`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_rot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assignfeedback_editpdf_rot` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `gradeid` bigint NOT NULL DEFAULT '0',
  `pageno` bigint NOT NULL DEFAULT '0',
  `pathnamehash` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `isrotated` tinyint(1) NOT NULL DEFAULT '0',
  `degree` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_assieditrot_grapag_uix` (`gradeid`,`pageno`),
  KEY `mdl_assieditrot_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores rotation information of a page.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_rot`
--

LOCK TABLES `mdl_assignfeedback_editpdf_rot` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_rot` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_rot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_file`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assignfeedback_file` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `grade` bigint NOT NULL DEFAULT '0',
  `numfiles` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assifile_ass2_ix` (`assignment`),
  KEY `mdl_assifile_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores info about the number of files submitted by a student';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_file`
--

LOCK TABLES `mdl_assignfeedback_file` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_file` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignment`
--

DROP TABLE IF EXISTS `mdl_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assignment` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `assignmenttype` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `resubmit` tinyint NOT NULL DEFAULT '0',
  `preventlate` tinyint NOT NULL DEFAULT '0',
  `emailteachers` tinyint NOT NULL DEFAULT '0',
  `var1` bigint DEFAULT '0',
  `var2` bigint DEFAULT '0',
  `var3` bigint DEFAULT '0',
  `var4` bigint DEFAULT '0',
  `var5` bigint DEFAULT '0',
  `maxbytes` bigint NOT NULL DEFAULT '100000',
  `timedue` bigint NOT NULL DEFAULT '0',
  `timeavailable` bigint NOT NULL DEFAULT '0',
  `grade` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assi_cou2_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignment`
--

LOCK TABLES `mdl_assignment` WRITE;
/*!40000 ALTER TABLE `mdl_assignment` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignment_submissions`
--

DROP TABLE IF EXISTS `mdl_assignment_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assignment_submissions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `numfiles` bigint NOT NULL DEFAULT '0',
  `data1` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `data2` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `grade` bigint NOT NULL DEFAULT '0',
  `submissioncomment` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `format` smallint NOT NULL DEFAULT '0',
  `teacher` bigint NOT NULL DEFAULT '0',
  `timemarked` bigint NOT NULL DEFAULT '0',
  `mailed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assisubm_use2_ix` (`userid`),
  KEY `mdl_assisubm_mai_ix` (`mailed`),
  KEY `mdl_assisubm_tim_ix` (`timemarked`),
  KEY `mdl_assisubm_ass2_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Info about submitted assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignment_submissions`
--

LOCK TABLES `mdl_assignment_submissions` WRITE;
/*!40000 ALTER TABLE `mdl_assignment_submissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignment_submissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignment_upgrade`
--

DROP TABLE IF EXISTS `mdl_assignment_upgrade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assignment_upgrade` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `oldcmid` bigint NOT NULL DEFAULT '0',
  `oldinstance` bigint NOT NULL DEFAULT '0',
  `newcmid` bigint NOT NULL DEFAULT '0',
  `newinstance` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assiupgr_old_ix` (`oldcmid`),
  KEY `mdl_assiupgr_old2_ix` (`oldinstance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Info about upgraded assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignment_upgrade`
--

LOCK TABLES `mdl_assignment_upgrade` WRITE;
/*!40000 ALTER TABLE `mdl_assignment_upgrade` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignment_upgrade` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignsubmission_file`
--

DROP TABLE IF EXISTS `mdl_assignsubmission_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assignsubmission_file` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `submission` bigint NOT NULL DEFAULT '0',
  `numfiles` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assifile_ass_ix` (`assignment`),
  KEY `mdl_assifile_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Info about file submissions for assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignsubmission_file`
--

LOCK TABLES `mdl_assignsubmission_file` WRITE;
/*!40000 ALTER TABLE `mdl_assignsubmission_file` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignsubmission_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignsubmission_onlinetext`
--

DROP TABLE IF EXISTS `mdl_assignsubmission_onlinetext`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_assignsubmission_onlinetext` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `submission` bigint NOT NULL DEFAULT '0',
  `onlinetext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `onlineformat` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assionli_ass_ix` (`assignment`),
  KEY `mdl_assionli_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Info about onlinetext submission';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignsubmission_onlinetext`
--

LOCK TABLES `mdl_assignsubmission_onlinetext` WRITE;
/*!40000 ALTER TABLE `mdl_assignsubmission_onlinetext` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignsubmission_onlinetext` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_auth_lti_linked_login`
--

DROP TABLE IF EXISTS `mdl_auth_lti_linked_login`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_auth_lti_linked_login` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `issuer` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `issuer256` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sub` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sub256` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_authltilinklogi_useiss_uix` (`userid`,`issuer256`,`sub256`),
  KEY `mdl_authltilinklogi_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Accounts linked to a users Moodle account.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_auth_lti_linked_login`
--

LOCK TABLES `mdl_auth_lti_linked_login` WRITE;
/*!40000 ALTER TABLE `mdl_auth_lti_linked_login` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_auth_lti_linked_login` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_auth_oauth2_linked_login`
--

DROP TABLE IF EXISTS `mdl_auth_oauth2_linked_login`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_auth_oauth2_linked_login` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `issuerid` bigint NOT NULL,
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `confirmtoken` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirmtokenexpires` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_authoautlinklogi_useis_uix` (`userid`,`issuerid`,`username`),
  KEY `mdl_authoautlinklogi_issuse_ix` (`issuerid`,`username`),
  KEY `mdl_authoautlinklogi_use_ix` (`usermodified`),
  KEY `mdl_authoautlinklogi_use2_ix` (`userid`),
  KEY `mdl_authoautlinklogi_iss_ix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Accounts linked to a users Moodle account.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_auth_oauth2_linked_login`
--

LOCK TABLES `mdl_auth_oauth2_linked_login` WRITE;
/*!40000 ALTER TABLE `mdl_auth_oauth2_linked_login` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_auth_oauth2_linked_login` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_backup_controllers`
--

DROP TABLE IF EXISTS `mdl_backup_controllers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_backup_controllers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `operation` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'backup',
  `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `format` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `interactive` smallint NOT NULL,
  `purpose` smallint NOT NULL,
  `userid` bigint NOT NULL,
  `status` smallint NOT NULL,
  `execution` smallint NOT NULL,
  `executiontime` bigint NOT NULL,
  `checksum` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `progress` decimal(15,14) NOT NULL DEFAULT '0.00000000000000',
  `controller` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_backcont_bac_uix` (`backupid`),
  KEY `mdl_backcont_typite_ix` (`type`,`itemid`),
  KEY `mdl_backcont_useite_ix` (`userid`,`itemid`),
  KEY `mdl_backcont_use_ix` (`userid`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='To store the backup_controllers as they are used';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_backup_controllers`
--

LOCK TABLES `mdl_backup_controllers` WRITE;
/*!40000 ALTER TABLE `mdl_backup_controllers` DISABLE KEYS */;
INSERT INTO `mdl_backup_controllers` VALUES (1,'39d8c436bf18bf26b4eab90095720ba6','backup','activity',2,'moodle2',0,50,2,1000,1,0,'630871ac6d62e2b22d347770e19fc20f',1755000909,1755000909,0.00000000000000,''),(2,'e956e6d00aaf6e699c5dbf8e5175a9b8','backup','activity',5,'moodle2',0,50,2,1000,1,0,'45128c477deb5c85aac916a04179d294',1755018203,1755018204,0.00000000000000,''),(3,'feaebc5fe89157a0d6553a9a6e942898','backup','course',28,'moodle2',0,50,2,1000,1,0,'39c1a4c559c8a4d994ed18abc93936a6',1756098428,1756098429,0.00000000000000,''),(4,'d0d7a95d6c80a9989ab18a57a400d531','backup','course',27,'moodle2',0,50,2,1000,1,0,'7e2114f91dc0d1aab3a1be69fe818ded',1756098445,1756098445,0.00000000000000,''),(5,'3bb991a7c862d4a8ec342a4f1e93b55c','backup','course',26,'moodle2',0,50,2,1000,1,0,'16b542c195bedb2cf5e5d00477efd011',1756098486,1756098486,0.00000000000000,''),(6,'e4f77ceee23c46cf2a248aa79d14ab0d','backup','course',25,'moodle2',0,50,2,1000,1,0,'db0a783c521c1e03f108ffcb60ed16a1',1756098500,1756098500,0.00000000000000,''),(7,'381004d26777f53dff61ab1224fb921f','backup','course',24,'moodle2',0,50,2,1000,1,0,'2a3a7768e94e06c4bb6c9a89dc09b171',1756098515,1756098515,0.00000000000000,''),(8,'80c51da05692758ad30a2136464f1b78','backup','course',23,'moodle2',0,50,2,1000,1,0,'8374319914ca4ee48f13b5834185f780',1756098582,1756098582,0.00000000000000,''),(9,'b7ceef2ed4b7dd3b02ab84f062a9f8dc','backup','course',22,'moodle2',0,50,2,1000,1,0,'cef7075a11a3a0eee5f7bc6e3f1fec15',1756098606,1756098606,0.00000000000000,''),(10,'9b7479fdc7c0393719045c5ad76ae42b','backup','course',21,'moodle2',0,50,2,1000,1,0,'b620a9c6dd927115e03e566d3239d6a0',1756098617,1756098617,0.00000000000000,''),(11,'5e7073982b24f56c59cdaafbf76eba37','backup','course',20,'moodle2',0,50,2,1000,1,0,'e6a00e91027e689878e756c690c81813',1756098629,1756098629,0.00000000000000,''),(12,'516ea11b89d7a041f3bd19d8bcd13fbd','backup','course',18,'moodle2',0,50,2,1000,1,0,'1c046177b3f863e90e4999a0cbe3ac5c',1756098641,1756098641,0.00000000000000,''),(13,'3291685e6849c87d89d888ac5fdd14a2','backup','course',19,'moodle2',0,50,2,1000,1,0,'2c008ce6121bb5a046ca4e7a79b1697a',1756098656,1756098656,0.00000000000000,''),(14,'b1de518c698ba7b668b7148f3829757b','backup','course',17,'moodle2',0,50,2,1000,1,0,'b5fb2aea672e734532f5c3258c285bea',1756098667,1756098667,0.00000000000000,''),(15,'893aab448c42083cd2accb1301ec0ad9','backup','course',16,'moodle2',0,50,2,1000,1,0,'a3f13f18818920b43cfba2904a3f9f41',1756098681,1756098681,0.00000000000000,''),(16,'45d9b9e9123f42c9de56f61bccd3209f','backup','course',15,'moodle2',0,50,2,1000,1,0,'19c89ab5b8ca33ea5df7168ad1b4c497',1756098698,1756098698,0.00000000000000,''),(17,'8a0bd1f91cc44c0954c94d6adafc80f8','backup','course',14,'moodle2',0,50,2,1000,1,0,'318d8688e97bc25671193c61b4f7a181',1756098725,1756098725,0.00000000000000,''),(18,'30feea09eaf6d2bb7296300769bd803c','backup','course',10,'moodle2',0,50,2,1000,1,0,'5bc94c1f8021681d45129f20a64d8811',1756098754,1756098754,0.00000000000000,''),(19,'89f5909024694e42ff81b091c21ec0f1','backup','course',13,'moodle2',0,50,2,1000,1,0,'ef81a64300fc777ecbe00d8f7cf0a378',1756098764,1756098764,0.00000000000000,''),(20,'f76db4986f555366355c390e3fc425fa','backup','course',12,'moodle2',0,50,2,1000,1,0,'ff47fde0d7ed2ca9198dfbe6e39d102e',1756098777,1756098777,0.00000000000000,''),(21,'edea603628cc011c628165a8997b72ae','backup','course',46,'moodle2',0,50,2,1000,1,0,'71ff82157f0e71751ad54ee6827b33f6',1756099370,1756099370,0.00000000000000,''),(22,'4fe755976fd2092c0298a360246c8075','backup','course',44,'moodle2',0,50,2,1000,1,0,'6a205282a4176d7e9d56375e41641ee3',1756099381,1756099381,0.00000000000000,''),(23,'196dba56c014fa8f618b911b803bde29','backup','course',31,'moodle2',0,50,2,1000,1,0,'11da644229a6891d61f98fc269d1b6fa',1756099393,1756099393,0.00000000000000,''),(24,'be3ea3e26011b7b2fbff9c4b6fa678a6','backup','course',2,'moodle2',0,50,2,1000,1,0,'07c873f207cdf7ff70eef92acb74c349',1756100622,1756100622,0.00000000000000,''),(25,'0224f5a2321a0b7f4abb1d14d1ce84df','backup','course',3,'moodle2',0,50,2,1000,1,0,'f3252555bf6dd404c3d10275d8c81e5c',1756100638,1756100638,0.00000000000000,''),(26,'264a429217c245e961a9f8d4fe2bc4e6','backup','course',4,'moodle2',0,50,2,1000,1,0,'6c992a13bfbc0381d14731d1fa391e9c',1756100653,1756100653,0.00000000000000,''),(27,'6e4e534ba144082a970ac883367a1085','backup','course',5,'moodle2',0,50,2,1000,1,0,'da683c699534d29f9768e6f4747ac4ed',1756100670,1756100670,0.00000000000000,''),(28,'7909be6a0eea4e33b32e95a5e5f3df78','backup','course',49,'moodle2',0,50,2,1000,1,0,'d34ca15c4a56b663cdee496a150e6d0c',1756100682,1756100682,0.00000000000000,''),(29,'14e1ea333ac86d3b781d5ad45c444218','backup','course',48,'moodle2',0,50,2,1000,1,0,'23814b056db00d3d480a62bd72dfcdce',1756100695,1756100696,0.00000000000000,''),(30,'8fc1aa8d55cf60dd820a65539b24ebe3','backup','course',47,'moodle2',0,50,2,1000,1,0,'2a97972f6aa0a8820886a6c2009d93e3',1756100706,1756100706,0.00000000000000,''),(31,'4bfbab7e8dff3d0528906892eb00bb39','backup','course',43,'moodle2',0,50,2,1000,1,0,'711de984fdb0a78aef08ad87ace28f58',1756100730,1756100730,0.00000000000000,''),(32,'ecfb00af6c59610f434c82683cdcb3bb','backup','course',42,'moodle2',0,50,2,1000,1,0,'888e8858171bb1d19f83393bdc0ff791',1756100751,1756100751,0.00000000000000,''),(33,'6a21330329c1de34aeedfed3efd37cf8','backup','course',41,'moodle2',0,50,2,1000,1,0,'3cd685e8acaed23497d51887d2a792a9',1756100763,1756100763,0.00000000000000,''),(34,'447910f225835cad117556554f9bd4b7','backup','course',40,'moodle2',0,50,2,1000,1,0,'7c89da62da2e4956b3b05bab10de4d67',1756100773,1756100773,0.00000000000000,''),(35,'9cd9c5f1701c014153c2c65457dc8825','backup','course',39,'moodle2',0,50,2,1000,1,0,'484100c0b9e1750159328d01ca61970c',1756100784,1756100784,0.00000000000000,''),(36,'fedbcaf73ecae79d3dcf67b038c9c958','backup','course',38,'moodle2',0,50,2,1000,1,0,'beb902b6a08916ad17ea63d760cd32e0',1756100797,1756100797,0.00000000000000,''),(37,'e380317e3a74f30bca2213b52a2ad456','backup','course',36,'moodle2',0,50,2,1000,1,0,'248fc9d257bb752b6c225a72a38fadae',1756100815,1756100815,0.00000000000000,''),(38,'4fbba58de026d260a68733dad994063f','backup','course',37,'moodle2',0,50,2,1000,1,0,'c25cc5ced695bc3096bf06f6fba1a0eb',1756100825,1756100826,0.00000000000000,''),(39,'0bbb599539a0f9e99b2be43ec9aa5a86','backup','course',32,'moodle2',0,50,2,1000,1,0,'10cbcbd8d52fc10a919521c8b96d9957',1756100837,1756100838,0.00000000000000,''),(40,'767ed2d61955da5602d73978e153d98d','backup','course',34,'moodle2',0,50,2,1000,1,0,'a34fbebe64e99d3c187f7e404aa76009',1756100849,1756100849,0.00000000000000,''),(41,'e04b332168f1a070e1ff2eb36a152610','backup','course',35,'moodle2',0,50,2,1000,1,0,'85c3abade895a3e752997344b5b43785',1756100860,1756100860,0.00000000000000,''),(42,'5c418388cf6565f60b10846f7da5f1d4','backup','course',33,'moodle2',0,50,2,1000,1,0,'76d5d6d40cec5bdf3dc4c52d0d5e5618',1756100870,1756100870,0.00000000000000,''),(43,'ad55d4eadaab277459a1674e25ee4f1d','backup','course',30,'moodle2',0,50,2,1000,1,0,'1a1e3c4b15bc04dcbacbece650e2da1a',1756100879,1756100880,0.00000000000000,''),(44,'d5aee0827c5507a8215aef7bd57e57ab','backup','course',29,'moodle2',0,50,2,1000,1,0,'c14a98d00621814f48bfd14d7d630951',1756100896,1756100896,0.00000000000000,''),(45,'84901b52e2dde921d87753187d7ccc88','backup','course',9,'moodle2',0,50,2,1000,1,0,'10cebbe826614f4a953a188759a3f613',1756100921,1756100921,0.00000000000000,''),(46,'70a501b5fd14df4c640f9660223ed369','backup','course',7,'moodle2',0,50,2,1000,1,0,'525c5bbc4bd8815dde22894f49183f66',1756100933,1756100933,0.00000000000000,''),(47,'c425a8ed7f2aa60e7276871fd6b3a4ec','backup','course',8,'moodle2',0,50,2,1000,1,0,'fe8b5f8f629bcf5f58b81c38722f09f3',1756100944,1756100944,0.00000000000000,''),(48,'b0c9bb8f11326d793edf405c4e429159','backup','course',11,'moodle2',0,50,2,1000,1,0,'a0983073b496057d82aadbf7b2d9d5ad',1756100956,1756100956,0.00000000000000,''),(49,'683837366b5c0b7f75bf6f14cc3e7f14','backup','course',6,'moodle2',0,50,2,1000,1,0,'f9683c98513ed08f62535569b3c8d3eb',1756101004,1756101004,0.00000000000000,''),(50,'075b3384c04e8dd0186dde248be3026f','backup','course',45,'moodle2',0,50,2,1000,1,0,'e06cd420a76ef11f7b85da4b0b5f93d1',1756101020,1756101020,0.00000000000000,''),(51,'005d38a00abe767fa7a74d92770cd643','backup','course',52,'moodle2',0,50,2,1000,1,0,'2ddbac0c823401dfd76da772540cc60c',1756102054,1756102055,0.00000000000000,''),(52,'96efa1ab0f2db332ce8c3d60b3f87d9b','backup','course',51,'moodle2',0,50,2,1000,1,0,'9e1d8ab42b628e02bc5447c495f4ba6e',1756102065,1756102066,0.00000000000000,''),(53,'b1330cc49bb4dfe2e082c818a8fac8d2','backup','course',50,'moodle2',0,50,2,1000,1,0,'57eaffea87e4368868db9ebc0a1f46bf',1756102074,1756102075,0.00000000000000,''),(54,'5d23c8fdd6fa4f4a8f306f2e5b37a5ea','backup','course',55,'moodle2',0,50,2,1000,1,0,'7870e14457f77e0fd5091ba81cf400f2',1756102669,1756102669,0.00000000000000,''),(55,'bc42b06162ce6847b67a59de30dedd05','backup','course',54,'moodle2',0,50,2,1000,1,0,'76d7e8fdd932e4288c3fea81db23705a',1756102679,1756102679,0.00000000000000,''),(56,'3d588942df1cad3840e1d785b2d57556','backup','course',53,'moodle2',0,50,2,1000,1,0,'24958887e9f8dee4f7860e54341f5591',1756102695,1756102695,0.00000000000000,''),(57,'6fdd04cbcf6ae8de864e2df89db95947','backup','course',56,'moodle2',0,50,2,1000,1,0,'291729955dc5530dc221f226af50a14c',1756102976,1756102976,0.00000000000000,''),(58,'95b60587c53b62870f191741d39b8a12','backup','course',57,'moodle2',0,50,2,1000,1,0,'b1a9d913ecc44671d7ac757a2c0a8afd',1756102986,1756102986,0.00000000000000,''),(59,'26ecc5dca656f35fe96f6daac1ba467f','backup','course',59,'moodle2',0,50,2,1000,1,0,'f8e8848cdb7bc4d8118e3e5e0e0bdd2f',1756103224,1756103224,0.00000000000000,''),(60,'f248bbfae474d970afde89db97f5dcde','backup','course',58,'moodle2',0,50,2,1000,1,0,'0dad86dd9defcee6f042e667d230c49a',1756103232,1756103233,0.00000000000000,''),(61,'72213cce51f5fd370c789bfbbb6c55d4','backup','course',3345,'moodle2',0,50,2,1000,1,0,'602353fcd373cec961ff200e198e7c9f',1756382219,1756382219,0.00000000000000,''),(62,'d2fab6ccce8960e1d683e6e68d7b34aa','backup','course',3346,'moodle2',0,50,2,1000,1,0,'6a7515fe78b75a12e606651c0f3034f9',1757564571,1757564572,0.00000000000000,'');
/*!40000 ALTER TABLE `mdl_backup_controllers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_backup_courses`
--

DROP TABLE IF EXISTS `mdl_backup_courses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_backup_courses` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL DEFAULT '0',
  `laststarttime` bigint NOT NULL DEFAULT '0',
  `lastendtime` bigint NOT NULL DEFAULT '0',
  `laststatus` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '5',
  `nextstarttime` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_backcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='To store every course backup status';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_backup_courses`
--

LOCK TABLES `mdl_backup_courses` WRITE;
/*!40000 ALTER TABLE `mdl_backup_courses` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_backup_courses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_backup_logs`
--

DROP TABLE IF EXISTS `mdl_backup_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_backup_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `loglevel` smallint NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_backlogs_bacid_uix` (`backupid`,`id`),
  KEY `mdl_backlogs_bac_ix` (`backupid`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='To store all the logs from backup and restore operations (by';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_backup_logs`
--

LOCK TABLES `mdl_backup_logs` WRITE;
/*!40000 ALTER TABLE `mdl_backup_logs` DISABLE KEYS */;
INSERT INTO `mdl_backup_logs` VALUES (1,'39d8c436bf18bf26b4eab90095720ba6',40,'instantiating backup controller 39d8c436bf18bf26b4eab90095720ba6',1755000909),(2,'39d8c436bf18bf26b4eab90095720ba6',50,'setting controller status to 100',1755000909),(3,'39d8c436bf18bf26b4eab90095720ba6',50,'loading controller plan',1755000909),(4,'39d8c436bf18bf26b4eab90095720ba6',50,'setting controller status to 300',1755000909),(5,'39d8c436bf18bf26b4eab90095720ba6',50,'applying plan defaults',1755000909),(6,'39d8c436bf18bf26b4eab90095720ba6',50,'setting controller status to 400',1755000909),(7,'39d8c436bf18bf26b4eab90095720ba6',50,'setting file inclusion to ',1755000909),(8,'39d8c436bf18bf26b4eab90095720ba6',40,'checking plan security',1755000909),(9,'39d8c436bf18bf26b4eab90095720ba6',50,'setting controller status to 700',1755000909),(10,'39d8c436bf18bf26b4eab90095720ba6',50,'saving controller to db',1755000909),(11,'39d8c436bf18bf26b4eab90095720ba6',50,'calculating controller checksum 5e585c7ad84947f98c1026e45764b401',1755000909),(12,'39d8c436bf18bf26b4eab90095720ba6',50,'loading controller from db',1755000909),(13,'39d8c436bf18bf26b4eab90095720ba6',50,'setting file inclusion to 1',1755000909),(14,'39d8c436bf18bf26b4eab90095720ba6',50,'setting controller status to 800',1755000909),(15,'39d8c436bf18bf26b4eab90095720ba6',50,'saving controller to db',1755000909),(16,'39d8c436bf18bf26b4eab90095720ba6',50,'calculating controller checksum 630871ac6d62e2b22d347770e19fc20f',1755000909),(17,'39d8c436bf18bf26b4eab90095720ba6',50,'loading controller from db',1755000909),(18,'39d8c436bf18bf26b4eab90095720ba6',50,'setting controller status to 1000',1755000909),(19,'39d8c436bf18bf26b4eab90095720ba6',50,'saving controller to db',1755000909),(20,'e956e6d00aaf6e699c5dbf8e5175a9b8',40,'instantiating backup controller e956e6d00aaf6e699c5dbf8e5175a9b8',1755018203),(21,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'setting controller status to 100',1755018203),(22,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'loading controller plan',1755018203),(23,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'setting controller status to 300',1755018203),(24,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'applying plan defaults',1755018203),(25,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'setting controller status to 400',1755018203),(26,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'setting file inclusion to ',1755018203),(27,'e956e6d00aaf6e699c5dbf8e5175a9b8',40,'checking plan security',1755018203),(28,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'setting controller status to 700',1755018203),(29,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'saving controller to db',1755018203),(30,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'calculating controller checksum c89d8e43a3338096fec6e7cef901338f',1755018203),(31,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'loading controller from db',1755018203),(32,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'setting file inclusion to 1',1755018203),(33,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'setting controller status to 800',1755018203),(34,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'saving controller to db',1755018203),(35,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'calculating controller checksum 45128c477deb5c85aac916a04179d294',1755018203),(36,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'loading controller from db',1755018203),(37,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'setting controller status to 1000',1755018204),(38,'e956e6d00aaf6e699c5dbf8e5175a9b8',50,'saving controller to db',1755018204);
/*!40000 ALTER TABLE `mdl_backup_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge`
--

DROP TABLE IF EXISTS `mdl_badge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `usercreated` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `issuername` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `issuerurl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `issuercontact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expiredate` bigint DEFAULT NULL,
  `expireperiod` bigint DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `courseid` bigint DEFAULT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `messagesubject` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attachment` tinyint(1) NOT NULL DEFAULT '1',
  `notification` tinyint(1) NOT NULL DEFAULT '1',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `nextcron` bigint DEFAULT NULL,
  `version` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageauthorname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageauthoremail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageauthorurl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imagecaption` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_badg_typ_ix` (`type`),
  KEY `mdl_badg_cou_ix` (`courseid`),
  KEY `mdl_badg_use_ix` (`usermodified`),
  KEY `mdl_badg_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines badge';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge`
--

LOCK TABLES `mdl_badge` WRITE;
/*!40000 ALTER TABLE `mdl_badge` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_alignment`
--

DROP TABLE IF EXISTS `mdl_badge_alignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge_alignment` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `targetname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `targeturl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `targetdescription` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `targetframework` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `targetcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgalig_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines alignment for badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_alignment`
--

LOCK TABLES `mdl_badge_alignment` WRITE;
/*!40000 ALTER TABLE `mdl_badge_alignment` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_alignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_backpack`
--

DROP TABLE IF EXISTS `mdl_badge_backpack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge_backpack` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `backpackuid` bigint NOT NULL,
  `autosync` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `externalbackpackid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgback_useext_uix` (`userid`,`externalbackpackid`),
  KEY `mdl_badgback_use_ix` (`userid`),
  KEY `mdl_badgback_ext_ix` (`externalbackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines settings for connecting external backpack';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_backpack`
--

LOCK TABLES `mdl_badge_backpack` WRITE;
/*!40000 ALTER TABLE `mdl_badge_backpack` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_backpack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_backpack_oauth2`
--

DROP TABLE IF EXISTS `mdl_badge_backpack_oauth2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge_backpack_oauth2` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL,
  `issuerid` bigint NOT NULL,
  `externalbackpackid` bigint NOT NULL,
  `token` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `refreshtoken` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expires` bigint DEFAULT NULL,
  `scope` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_badgbackoaut_use_ix` (`usermodified`),
  KEY `mdl_badgbackoaut_use2_ix` (`userid`),
  KEY `mdl_badgbackoaut_iss_ix` (`issuerid`),
  KEY `mdl_badgbackoaut_ext_ix` (`externalbackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Default comment for the table, please edit me';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_backpack_oauth2`
--

LOCK TABLES `mdl_badge_backpack_oauth2` WRITE;
/*!40000 ALTER TABLE `mdl_badge_backpack_oauth2` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_backpack_oauth2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_criteria`
--

DROP TABLE IF EXISTS `mdl_badge_criteria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge_criteria` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `criteriatype` bigint DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '1',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgcrit_badcri_uix` (`badgeid`,`criteriatype`),
  KEY `mdl_badgcrit_cri_ix` (`criteriatype`),
  KEY `mdl_badgcrit_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines criteria for issuing badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_criteria`
--

LOCK TABLES `mdl_badge_criteria` WRITE;
/*!40000 ALTER TABLE `mdl_badge_criteria` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_criteria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_criteria_met`
--

DROP TABLE IF EXISTS `mdl_badge_criteria_met`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge_criteria_met` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `issuedid` bigint DEFAULT NULL,
  `critid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `datemet` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgcritmet_cri_ix` (`critid`),
  KEY `mdl_badgcritmet_use_ix` (`userid`),
  KEY `mdl_badgcritmet_iss_ix` (`issuedid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines criteria that were met for an issued badge';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_criteria_met`
--

LOCK TABLES `mdl_badge_criteria_met` WRITE;
/*!40000 ALTER TABLE `mdl_badge_criteria_met` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_criteria_met` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_criteria_param`
--

DROP TABLE IF EXISTS `mdl_badge_criteria_param`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge_criteria_param` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `critid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgcritpara_cri_ix` (`critid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines parameters for badges criteria';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_criteria_param`
--

LOCK TABLES `mdl_badge_criteria_param` WRITE;
/*!40000 ALTER TABLE `mdl_badge_criteria_param` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_criteria_param` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_endorsement`
--

DROP TABLE IF EXISTS `mdl_badge_endorsement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge_endorsement` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `issuername` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `issuerurl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `issueremail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `claimid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `claimcomment` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `dateissued` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_badgendo_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines endorsement for badge';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_endorsement`
--

LOCK TABLES `mdl_badge_endorsement` WRITE;
/*!40000 ALTER TABLE `mdl_badge_endorsement` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_endorsement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_external`
--

DROP TABLE IF EXISTS `mdl_badge_external`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge_external` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `backpackid` bigint NOT NULL,
  `collectionid` bigint NOT NULL,
  `entityid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assertion` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_badgexte_bac_ix` (`backpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Setting for external badges display';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_external`
--

LOCK TABLES `mdl_badge_external` WRITE;
/*!40000 ALTER TABLE `mdl_badge_external` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_external` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_external_backpack`
--

DROP TABLE IF EXISTS `mdl_badge_external_backpack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge_external_backpack` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `backpackapiurl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `backpackweburl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `apiversion` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1.0',
  `sortorder` bigint NOT NULL DEFAULT '0',
  `oauth2_issuerid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgexteback_bac_uix` (`backpackapiurl`),
  UNIQUE KEY `mdl_badgexteback_bac2_uix` (`backpackweburl`),
  KEY `mdl_badgexteback_oau_ix` (`oauth2_issuerid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines settings for site level backpacks that a user can co';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_external_backpack`
--

LOCK TABLES `mdl_badge_external_backpack` WRITE;
/*!40000 ALTER TABLE `mdl_badge_external_backpack` DISABLE KEYS */;
INSERT INTO `mdl_badge_external_backpack` VALUES (1,'https://api.badgr.io/v2','https://badgr.io','2',1,NULL);
/*!40000 ALTER TABLE `mdl_badge_external_backpack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_external_identifier`
--

DROP TABLE IF EXISTS `mdl_badge_external_identifier`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge_external_identifier` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `sitebackpackid` bigint NOT NULL,
  `internalid` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `externalid` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgexteiden_sitintext_uix` (`sitebackpackid`,`internalid`,`externalid`,`type`),
  KEY `mdl_badgexteiden_sit_ix` (`sitebackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Setting for external badges mappings';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_external_identifier`
--

LOCK TABLES `mdl_badge_external_identifier` WRITE;
/*!40000 ALTER TABLE `mdl_badge_external_identifier` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_external_identifier` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_issued`
--

DROP TABLE IF EXISTS `mdl_badge_issued`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge_issued` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `uniquehash` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateissued` bigint NOT NULL DEFAULT '0',
  `dateexpire` bigint DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '0',
  `issuernotified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgissu_baduse_uix` (`badgeid`,`userid`),
  KEY `mdl_badgissu_bad_ix` (`badgeid`),
  KEY `mdl_badgissu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines issued badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_issued`
--

LOCK TABLES `mdl_badge_issued` WRITE;
/*!40000 ALTER TABLE `mdl_badge_issued` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_issued` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_manual_award`
--

DROP TABLE IF EXISTS `mdl_badge_manual_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge_manual_award` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL,
  `recipientid` bigint NOT NULL,
  `issuerid` bigint NOT NULL,
  `issuerrole` bigint NOT NULL,
  `datemet` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgmanuawar_bad_ix` (`badgeid`),
  KEY `mdl_badgmanuawar_rec_ix` (`recipientid`),
  KEY `mdl_badgmanuawar_iss_ix` (`issuerid`),
  KEY `mdl_badgmanuawar_iss2_ix` (`issuerrole`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Track manual award criteria for badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_manual_award`
--

LOCK TABLES `mdl_badge_manual_award` WRITE;
/*!40000 ALTER TABLE `mdl_badge_manual_award` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_manual_award` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_related`
--

DROP TABLE IF EXISTS `mdl_badge_related`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_badge_related` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `relatedbadgeid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgrela_badrel_uix` (`badgeid`,`relatedbadgeid`),
  KEY `mdl_badgrela_bad_ix` (`badgeid`),
  KEY `mdl_badgrela_rel_ix` (`relatedbadgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines badge related for badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_related`
--

LOCK TABLES `mdl_badge_related` WRITE;
/*!40000 ALTER TABLE `mdl_badge_related` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_related` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_bigbluebuttonbn`
--

DROP TABLE IF EXISTS `mdl_bigbluebuttonbn`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_bigbluebuttonbn` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `type` tinyint NOT NULL DEFAULT '0',
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `introformat` smallint NOT NULL DEFAULT '1',
  `meetingid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `moderatorpass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `viewerpass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `wait` tinyint(1) NOT NULL DEFAULT '0',
  `record` tinyint(1) NOT NULL DEFAULT '0',
  `recordallfromstart` tinyint(1) NOT NULL DEFAULT '0',
  `recordhidebutton` tinyint(1) NOT NULL DEFAULT '0',
  `welcome` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `voicebridge` mediumint NOT NULL DEFAULT '0',
  `openingtime` bigint NOT NULL DEFAULT '0',
  `closingtime` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `presentation` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `participants` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `userlimit` smallint NOT NULL DEFAULT '0',
  `recordings_html` tinyint(1) NOT NULL DEFAULT '0',
  `recordings_deleted` tinyint(1) NOT NULL DEFAULT '1',
  `recordings_imported` tinyint(1) NOT NULL DEFAULT '0',
  `recordings_preview` tinyint(1) NOT NULL DEFAULT '0',
  `clienttype` tinyint(1) NOT NULL DEFAULT '0',
  `muteonstart` tinyint(1) NOT NULL DEFAULT '0',
  `disablecam` tinyint(1) NOT NULL DEFAULT '0',
  `disablemic` tinyint(1) NOT NULL DEFAULT '0',
  `disableprivatechat` tinyint(1) NOT NULL DEFAULT '0',
  `disablepublicchat` tinyint(1) NOT NULL DEFAULT '0',
  `disablenote` tinyint(1) NOT NULL DEFAULT '0',
  `hideuserlist` tinyint(1) NOT NULL DEFAULT '0',
  `lockedlayout` tinyint(1) NOT NULL DEFAULT '0',
  `lockonjoin` tinyint(1) NOT NULL DEFAULT '0',
  `lockonjoinconfigurable` tinyint(1) NOT NULL DEFAULT '0',
  `completionattendance` int NOT NULL DEFAULT '0',
  `completionengagementchats` int NOT NULL DEFAULT '0',
  `completionengagementtalks` int NOT NULL DEFAULT '0',
  `completionengagementraisehand` int NOT NULL DEFAULT '0',
  `completionengagementpollvotes` int NOT NULL DEFAULT '0',
  `completionengagementemojis` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The bigbluebuttonbn table to store information about a meeti';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_bigbluebuttonbn`
--

LOCK TABLES `mdl_bigbluebuttonbn` WRITE;
/*!40000 ALTER TABLE `mdl_bigbluebuttonbn` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_bigbluebuttonbn` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_bigbluebuttonbn_logs`
--

DROP TABLE IF EXISTS `mdl_bigbluebuttonbn_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_bigbluebuttonbn_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `bigbluebuttonbnid` bigint NOT NULL,
  `userid` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `meetingid` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `log` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_bigblogs_cou_ix` (`courseid`),
  KEY `mdl_bigblogs_log_ix` (`log`),
  KEY `mdl_bigblogs_coubiguselog_ix` (`courseid`,`bigbluebuttonbnid`,`userid`,`log`),
  KEY `mdl_bigblogs_uselog_ix` (`userid`,`log`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The bigbluebuttonbn table to store meeting activity events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_bigbluebuttonbn_logs`
--

LOCK TABLES `mdl_bigbluebuttonbn_logs` WRITE;
/*!40000 ALTER TABLE `mdl_bigbluebuttonbn_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_bigbluebuttonbn_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_bigbluebuttonbn_recordings`
--

DROP TABLE IF EXISTS `mdl_bigbluebuttonbn_recordings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_bigbluebuttonbn_recordings` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `bigbluebuttonbnid` bigint NOT NULL,
  `groupid` bigint DEFAULT NULL,
  `recordingid` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `headless` tinyint(1) NOT NULL DEFAULT '0',
  `imported` tinyint(1) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `importeddata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_bigbreco_cou_ix` (`courseid`),
  KEY `mdl_bigbreco_rec_ix` (`recordingid`),
  KEY `mdl_bigbreco_big_ix` (`bigbluebuttonbnid`),
  KEY `mdl_bigbreco_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The bigbluebuttonbn table to store references to recordings';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_bigbluebuttonbn_recordings`
--

LOCK TABLES `mdl_bigbluebuttonbn_recordings` WRITE;
/*!40000 ALTER TABLE `mdl_bigbluebuttonbn_recordings` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_bigbluebuttonbn_recordings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block`
--

DROP TABLE IF EXISTS `mdl_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_block` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cron` bigint NOT NULL DEFAULT '0',
  `lastcron` bigint NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_bloc_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='contains all installed blocks';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block`
--

LOCK TABLES `mdl_block` WRITE;
/*!40000 ALTER TABLE `mdl_block` DISABLE KEYS */;
INSERT INTO `mdl_block` VALUES (1,'accessreview',0,0,1),(2,'activity_modules',0,0,1),(3,'activity_results',0,0,1),(4,'admin_bookmarks',0,0,1),(5,'badges',0,0,1),(6,'blog_menu',0,0,1),(7,'blog_recent',0,0,1),(8,'blog_tags',0,0,1),(9,'calendar_month',0,0,0),(10,'calendar_upcoming',0,0,1),(11,'comments',0,0,1),(12,'completionstatus',0,0,1),(13,'course_list',0,0,1),(14,'course_summary',0,0,0),(15,'feedback',0,0,0),(16,'globalsearch',0,0,1),(17,'glossary_random',0,0,1),(19,'login',0,0,1),(20,'lp',0,0,1),(21,'mentees',0,0,1),(22,'mnet_hosts',0,0,1),(23,'myoverview',0,0,1),(24,'myprofile',0,0,1),(25,'navigation',0,0,1),(26,'news_items',0,0,1),(27,'online_users',0,0,1),(28,'private_files',0,0,1),(29,'recent_activity',0,0,1),(30,'recentlyaccessedcourses',0,0,1),(31,'recentlyaccesseditems',0,0,1),(32,'rss_client',0,0,0),(33,'search_forums',0,0,1),(34,'section_links',0,0,1),(35,'selfcompletion',0,0,0),(36,'settings',0,0,1),(37,'site_main_menu',0,0,1),(38,'social_activities',0,0,1),(39,'starredcourses',0,0,1),(40,'tag_flickr',0,0,1),(41,'tag_youtube',0,0,0),(42,'tags',0,0,1),(43,'timeline',0,0,1),(44,'html',0,0,1);
/*!40000 ALTER TABLE `mdl_block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_instances`
--

DROP TABLE IF EXISTS `mdl_block_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_block_instances` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `blockname` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parentcontextid` bigint NOT NULL,
  `showinsubcontexts` smallint NOT NULL,
  `requiredbytheme` smallint NOT NULL DEFAULT '0',
  `pagetypepattern` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subpagepattern` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `defaultregion` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `defaultweight` bigint NOT NULL,
  `configdata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_blocinst_parshopagsub_ix` (`parentcontextid`,`showinsubcontexts`,`pagetypepattern`,`subpagepattern`),
  KEY `mdl_blocinst_tim_ix` (`timemodified`),
  KEY `mdl_blocinst_par_ix` (`parentcontextid`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table stores block instances. The type of block this is';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_instances`
--

LOCK TABLES `mdl_block_instances` WRITE;
/*!40000 ALTER TABLE `mdl_block_instances` DISABLE KEYS */;
INSERT INTO `mdl_block_instances` VALUES (1,'admin_bookmarks',1,0,0,'admin-*',NULL,'side-pre',2,'',1753775939,1753775939),(2,'recentlyaccesseditems',1,0,0,'my-index','2','side-post',0,'',1753775939,1753775939),(3,'timeline',1,0,0,'my-index','2','content',0,'',1753775939,1753775939),(4,'calendar_month',1,0,0,'my-index','2','content',1,'',1753775939,1753775939),(5,'myoverview',1,0,0,'my-index','3','content',0,'',1753775939,1753775939),(11,'myoverview',5,0,0,'my-index',NULL,'content',2,'Tzo4OiJzdGRDbGFzcyI6MDp7fQ==',1753857517,1753870681),(22,'navigation',5,0,0,'my-index','4','side-pre',0,'',1753961672,1753961672),(23,'course_list',5,0,0,'my-index','4','side-pre',1,'',1754981222,1754981222),(38,'course_list',1,0,0,'my-index','2','content',2,'',1755770813,1755770813);
/*!40000 ALTER TABLE `mdl_block_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_positions`
--

DROP TABLE IF EXISTS `mdl_block_positions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_block_positions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `blockinstanceid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `pagetype` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subpage` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `visible` smallint NOT NULL,
  `region` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `weight` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_blocposi_bloconpagsub_uix` (`blockinstanceid`,`contextid`,`pagetype`,`subpage`),
  KEY `mdl_blocposi_blo_ix` (`blockinstanceid`),
  KEY `mdl_blocposi_con_ix` (`contextid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the position of a sticky block_instance on a another ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_positions`
--

LOCK TABLES `mdl_block_positions` WRITE;
/*!40000 ALTER TABLE `mdl_block_positions` DISABLE KEYS */;
INSERT INTO `mdl_block_positions` VALUES (2,11,5,'my-index','4',1,'content',-1);
/*!40000 ALTER TABLE `mdl_block_positions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_recent_activity`
--

DROP TABLE IF EXISTS `mdl_block_recent_activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_block_recent_activity` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `cmid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `action` tinyint(1) NOT NULL,
  `modname` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_blocreceacti_coutim_ix` (`courseid`,`timecreated`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Recent activity block';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_recent_activity`
--

LOCK TABLES `mdl_block_recent_activity` WRITE;
/*!40000 ALTER TABLE `mdl_block_recent_activity` DISABLE KEYS */;
INSERT INTO `mdl_block_recent_activity` VALUES (1,2,2,1753870544,2,0,NULL),(2,2,3,1753875094,2,0,NULL),(3,3,6,1754131930,2,0,NULL),(4,4,8,1754285119,2,0,NULL),(5,4,8,1754285488,2,1,NULL),(6,3,9,1754307348,2,0,NULL),(7,5,11,1754474112,2,0,NULL),(8,5,12,1754478813,2,0,NULL),(9,3,13,1754544428,2,0,NULL),(10,3,13,1754544643,2,1,NULL),(11,3,13,1754545160,2,1,NULL),(12,3,13,1754545161,2,1,NULL),(13,3,13,1754545222,2,1,NULL),(14,3,14,1754546233,2,0,NULL),(15,3,15,1754628771,2,0,NULL),(16,3,15,1754628874,2,1,NULL),(17,3,16,1754908578,2,0,NULL),(18,3,17,1754908579,2,0,NULL),(19,3,16,1754908621,2,1,NULL),(20,2,2,1755000910,2,2,'quiz'),(21,3,18,1755008333,2,0,NULL),(22,3,5,1755018204,2,2,'forum'),(23,3,13,1755058843,2,1,NULL),(24,6,20,1755146267,2,0,NULL),(25,6,21,1755146268,2,0,NULL),(26,6,22,1755146269,2,0,NULL),(27,6,23,1755146270,2,0,NULL),(28,6,24,1755146271,2,0,NULL),(29,6,25,1755146272,2,0,NULL),(30,6,26,1755146273,2,0,NULL),(31,6,27,1755146274,2,0,NULL),(32,6,28,1755146274,2,0,NULL),(33,6,29,1755146275,2,0,NULL),(34,7,31,1755597450,2,0,NULL),(35,7,32,1755614658,2,0,NULL),(36,7,33,1755615685,2,0,NULL),(37,7,33,1755615735,2,1,NULL),(38,7,34,1755688348,2,0,NULL),(39,9,37,1755842704,2,0,NULL),(40,28,2715,1755931254,2,0,NULL),(41,49,2716,1756100062,2,1,NULL),(42,61,2725,1756190045,2,1,NULL),(43,62,3386,1756273910,2,1,NULL),(44,3345,6670,1756290528,2,0,NULL),(45,3345,6670,1756292422,2,1,NULL),(46,3326,6650,1756359530,2,1,NULL),(47,3326,6650,1756359628,2,1,NULL),(48,3346,6672,1756981542,52,0,NULL),(49,3346,6672,1756981680,52,1,NULL),(50,3328,6652,1757505772,50,1,NULL),(51,3343,6667,1757570723,52,1,NULL);
/*!40000 ALTER TABLE `mdl_block_recent_activity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_recentlyaccesseditems`
--

DROP TABLE IF EXISTS `mdl_block_recentlyaccesseditems`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_block_recentlyaccesseditems` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `cmid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `timeaccess` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_blocrece_usecoucmi_uix` (`userid`,`courseid`,`cmid`),
  KEY `mdl_blocrece_use_ix` (`userid`),
  KEY `mdl_blocrece_cou_ix` (`courseid`),
  KEY `mdl_blocrece_cmi_ix` (`cmid`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Most recently accessed items accessed by a user';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_recentlyaccesseditems`
--

LOCK TABLES `mdl_block_recentlyaccesseditems` WRITE;
/*!40000 ALTER TABLE `mdl_block_recentlyaccesseditems` DISABLE KEYS */;
INSERT INTO `mdl_block_recentlyaccesseditems` VALUES (48,61,2725,4,1756103548),(49,61,2725,2,1756190241),(50,62,3386,4,1756275286),(51,3333,6657,2,1756274299),(52,3333,6657,4,1756275108),(53,3343,6667,2,1756275090),(54,3342,6666,2,1756275241),(57,3326,6650,2,1756295591),(58,3344,6668,2,1756968881),(59,1464,4788,2,1757415300),(60,1,4,52,1757586575),(61,3328,6652,2,1757928919);
/*!40000 ALTER TABLE `mdl_block_recentlyaccesseditems` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_rss_client`
--

DROP TABLE IF EXISTS `mdl_block_rss_client`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_block_rss_client` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `preferredtitle` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `shared` tinyint NOT NULL DEFAULT '0',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `skiptime` bigint NOT NULL DEFAULT '0',
  `skipuntil` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Remote news feed information. Contains the news feed id, the';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_rss_client`
--

LOCK TABLES `mdl_block_rss_client` WRITE;
/*!40000 ALTER TABLE `mdl_block_rss_client` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_rss_client` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_blog_association`
--

DROP TABLE IF EXISTS `mdl_blog_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_blog_association` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `blogid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_blogasso_con_ix` (`contextid`),
  KEY `mdl_blogasso_blo_ix` (`blogid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Associations of blog entries with courses and module instanc';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_blog_association`
--

LOCK TABLES `mdl_blog_association` WRITE;
/*!40000 ALTER TABLE `mdl_blog_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_blog_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_blog_external`
--

DROP TABLE IF EXISTS `mdl_blog_external`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_blog_external` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `url` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `filtertags` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `failedlastsync` tinyint(1) NOT NULL DEFAULT '0',
  `timemodified` bigint DEFAULT NULL,
  `timefetched` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_blogexte_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='External blog links used for RSS copying of blog entries to ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_blog_external`
--

LOCK TABLES `mdl_blog_external` WRITE;
/*!40000 ALTER TABLE `mdl_blog_external` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_blog_external` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_book`
--

DROP TABLE IF EXISTS `mdl_book`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_book` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `introformat` smallint NOT NULL DEFAULT '0',
  `numbering` smallint NOT NULL DEFAULT '0',
  `navstyle` smallint NOT NULL DEFAULT '1',
  `customtitles` tinyint NOT NULL DEFAULT '0',
  `revision` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines book';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_book`
--

LOCK TABLES `mdl_book` WRITE;
/*!40000 ALTER TABLE `mdl_book` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_book` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_book_chapters`
--

DROP TABLE IF EXISTS `mdl_book_chapters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_book_chapters` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `bookid` bigint NOT NULL DEFAULT '0',
  `pagenum` bigint NOT NULL DEFAULT '0',
  `subchapter` bigint NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `contentformat` smallint NOT NULL DEFAULT '0',
  `hidden` tinyint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `importsrc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_bookchap_boo_ix` (`bookid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines book_chapters';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_book_chapters`
--

LOCK TABLES `mdl_book_chapters` WRITE;
/*!40000 ALTER TABLE `mdl_book_chapters` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_book_chapters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cache_filters`
--

DROP TABLE IF EXISTS `mdl_cache_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_cache_filters` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` bigint NOT NULL DEFAULT '0',
  `md5key` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rawtext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_cachfilt_filmd5_ix` (`filter`,`md5key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='For keeping information about cached data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cache_filters`
--

LOCK TABLES `mdl_cache_filters` WRITE;
/*!40000 ALTER TABLE `mdl_cache_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_cache_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cache_flags`
--

DROP TABLE IF EXISTS `mdl_cache_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_cache_flags` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `flagtype` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_cachflag_fla_ix` (`flagtype`),
  KEY `mdl_cachflag_nam_ix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3515 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Cache of time-sensitive flags';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cache_flags`
--

LOCK TABLES `mdl_cache_flags` WRITE;
/*!40000 ALTER TABLE `mdl_cache_flags` DISABLE KEYS */;
INSERT INTO `mdl_cache_flags` VALUES (1,'userpreferenceschanged','2',1758546212,'1',1758575012),(2,'accesslib/dirtyusers','2',1758543163,'1',1758571963),(3,'userpreferenceschanged','3',1755767770,'1',1755796570),(4,'accesslib/dirtyusers','3',1756447421,'1',1756476221),(5,'userpreferenceschanged','4',1758534224,'1',1758563024),(6,'accesslib/dirtyusers','4',1758542330,'1',1758571130),(7,'userpreferenceschanged','5',1754113183,'1',1754141983),(8,'accesslib/dirtyusers','5',1754131151,'1',1754159951),(9,'userpreferenceschanged','6',1754130575,'1',1754159375),(10,'accesslib/dirtyusers','6',1754544047,'1',1754572847),(11,'userpreferenceschanged','7',1754544027,'1',1754572827),(12,'accesslib/dirtyusers','7',1756447317,'1',1756476117),(13,'userpreferenceschanged','8',1754544381,'1',1754573181),(14,'accesslib/dirtyusers','8',1754544408,'1',1754573208),(15,'userpreferenceschanged','9',1754544513,'1',1754573313),(16,'accesslib/dirtyusers','9',1754544525,'1',1754573325),(17,'userpreferenceschanged','10',1754544647,'1',1754573447),(18,'accesslib/dirtyusers','10',1754544905,'1',1754573705),(19,'userpreferenceschanged','11',1754544889,'1',1754573689),(20,'accesslib/dirtyusers','11',1754544898,'1',1754573698),(21,'userpreferenceschanged','12',1754545025,'1',1754573825),(22,'accesslib/dirtyusers','12',1754548207,'1',1754577007),(23,'userpreferenceschanged','13',1755015493,'1',1755044293),(24,'accesslib/dirtyusers','13',1758542350,'1',1758571150),(25,'userpreferenceschanged','14',1758537220,'1',1758566020),(26,'accesslib/dirtyusers','14',1758542275,'1',1758571075),(27,'accesslib/dirtycontexts','/1/3/82',1755584689,'1',1755613489),(28,'userpreferenceschanged','15',1755598637,'1',1755627437),(29,'userpreferenceschanged','16',1755598564,'1',1755627364),(30,'userpreferenceschanged','17',1755598564,'1',1755627364),(31,'accesslib/dirtyusers','15',1756447356,'1',1756476156),(32,'userpreferenceschanged','18',1755603632,'1',1755632432),(33,'accesslib/dirtyusers','18',1756447365,'1',1756476165),(34,'userpreferenceschanged','19',1755673148,'1',1755701948),(35,'accesslib/dirtyusers','19',1755682372,'1',1755711172),(36,'accesslib/dirtyusers','20',1755677420,'1',1755706220),(37,'userpreferenceschanged','20',1755677381,'1',1755706181),(38,'accesslib/dirtyusers','21',1755677981,'1',1755706781),(39,'userpreferenceschanged','21',1755677649,'1',1755706449),(40,'accesslib/dirtyusers','22',1755678008,'1',1755706808),(41,'userpreferenceschanged','22',1755677810,'1',1755706610),(42,'accesslib/dirtyusers','23',1755677989,'1',1755706789),(43,'userpreferenceschanged','23',1755677810,'1',1755706610),(44,'accesslib/dirtyusers','24',1755677999,'1',1755706799),(45,'userpreferenceschanged','24',1755677810,'1',1755706610),(46,'accesslib/dirtyusers','25',1755678084,'1',1755706884),(47,'userpreferenceschanged','25',1755678050,'1',1755706850),(48,'accesslib/dirtyusers','26',1755678076,'1',1755706876),(49,'userpreferenceschanged','26',1755678050,'1',1755706850),(50,'accesslib/dirtyusers','27',1755678092,'1',1755706892),(51,'userpreferenceschanged','27',1755678050,'1',1755706850),(52,'accesslib/dirtyusers','28',1755679138,'1',1755707938),(53,'userpreferenceschanged','28',1755678157,'1',1755706957),(54,'accesslib/dirtyusers','29',1755679146,'1',1755707946),(55,'userpreferenceschanged','29',1755678157,'1',1755706957),(56,'accesslib/dirtyusers','30',1755679155,'1',1755707955),(57,'userpreferenceschanged','30',1755678157,'1',1755706957),(58,'accesslib/dirtyusers','33',1755679824,'1',1755708624),(59,'userpreferenceschanged','33',1755679799,'1',1755708599),(60,'accesslib/dirtyusers','34',1755679835,'1',1755708635),(61,'userpreferenceschanged','34',1755679800,'1',1755708600),(62,'accesslib/dirtyusers','35',1755680307,'1',1755709107),(63,'userpreferenceschanged','35',1755679800,'1',1755708600),(64,'accesslib/dirtyusers','36',1755682034,'1',1755710834),(65,'userpreferenceschanged','36',1755680488,'1',1755709288),(66,'accesslib/dirtyusers','37',1755682060,'1',1755710860),(67,'userpreferenceschanged','37',1755680489,'1',1755709289),(68,'accesslib/dirtyusers','38',1755682042,'1',1755710842),(69,'userpreferenceschanged','38',1755680489,'1',1755709289),(70,'accesslib/dirtyusers','39',1755682050,'1',1755710850),(71,'userpreferenceschanged','39',1755680677,'1',1755709477),(72,'accesslib/dirtyusers','40',1758100865,'1',1758129665),(73,'userpreferenceschanged','40',1757484631,'1',1757513431),(74,'accesslib/dirtyusers','41',1758100854,'1',1758129654),(75,'userpreferenceschanged','41',1757481300,'1',1757510100),(76,'accesslib/dirtyusers','42',1755683075,'1',1755711875),(77,'userpreferenceschanged','42',1755682422,'1',1755711222),(78,'userpreferenceschanged','43',1755683108,'1',1755711908),(79,'accesslib/dirtyusers','44',1756447433,'1',1756476233),(80,'userpreferenceschanged','44',1755683311,'1',1755712111),(81,'userpreferenceschanged','45',1756444311,'1',1756473111),(82,'accesslib/dirtyusers','45',1756447382,'1',1756476182),(83,'accesslib/dirtycontexts','/1/84/150',1756098755,'1',1756127555),(84,'accesslib/dirtycontexts','/1/84/151',1756100956,'1',1756129756),(85,'accesslib/dirtycontexts','/1/84/152',1756098777,'1',1756127577),(86,'accesslib/dirtycontexts','/1/84/153',1756098765,'1',1756127565),(87,'accesslib/dirtycontexts','/1/84/154',1756098725,'1',1756127525),(88,'accesslib/dirtycontexts','/1/84/155',1756098698,'1',1756127498),(89,'accesslib/dirtycontexts','/1/84/156',1756098681,'1',1756127481),(90,'accesslib/dirtycontexts','/1/84/157',1756098667,'1',1756127467),(91,'accesslib/dirtycontexts','/1/84/158',1756098641,'1',1756127441),(92,'accesslib/dirtycontexts','/1/84/159',1756098656,'1',1756127456),(93,'accesslib/dirtycontexts','/1/84/160',1756098629,'1',1756127429),(94,'accesslib/dirtycontexts','/1/84/161',1756098618,'1',1756127418),(95,'accesslib/dirtycontexts','/1/84/162',1756098606,'1',1756127406),(96,'accesslib/dirtycontexts','/1/84/163',1756098582,'1',1756127382),(97,'accesslib/dirtycontexts','/1/84/164',1756098515,'1',1756127315),(98,'accesslib/dirtycontexts','/1/84/165',1756098500,'1',1756127300),(99,'accesslib/dirtycontexts','/1/84/166',1756098487,'1',1756127287),(100,'accesslib/dirtycontexts','/1/84/167',1756098446,'1',1756127246),(101,'accesslib/dirtycontexts','/1/84/168',1756098429,'1',1756127229),(102,'accesslib/dirtycontexts','/1/84/169',1756100897,'1',1756129697),(103,'accesslib/dirtycontexts','/1/84/170',1756100880,'1',1756129680),(104,'accesslib/dirtycontexts','/1/84/171',1756099393,'1',1756128193),(105,'accesslib/dirtycontexts','/1/84/172',1756100838,'1',1756129638),(106,'accesslib/dirtycontexts','/1/84/173',1756100870,'1',1756129670),(107,'accesslib/dirtycontexts','/1/84/174',1756100849,'1',1756129649),(108,'accesslib/dirtycontexts','/1/84/175',1756100861,'1',1756129661),(109,'accesslib/dirtycontexts','/1/84/176',1756100815,'1',1756129615),(110,'accesslib/dirtycontexts','/1/84/177',1756100826,'1',1756129626),(111,'accesslib/dirtycontexts','/1/84/178',1756100798,'1',1756129598),(112,'accesslib/dirtycontexts','/1/84/179',1756100785,'1',1756129585),(113,'accesslib/dirtycontexts','/1/84/180',1756100774,'1',1756129574),(114,'accesslib/dirtycontexts','/1/84/181',1756100763,'1',1756129563),(115,'accesslib/dirtycontexts','/1/84/182',1756100751,'1',1756129551),(116,'accesslib/dirtycontexts','/1/84/183',1756100730,'1',1756129530),(117,'accesslib/dirtycontexts','/1/84/184',1756099382,'1',1756128182),(118,'accesslib/dirtycontexts','/1/84/185',1756101021,'1',1756129821),(119,'accesslib/dirtycontexts','/1/84/186',1756099371,'1',1756128171),(120,'accesslib/dirtycontexts','/1/84/187',1756100706,'1',1756129506),(121,'accesslib/dirtycontexts','/1/84/188',1756100696,'1',1756129496),(122,'accesslib/dirtycontexts','/1/84/189',1756100682,'1',1756129482),(123,'accesslib/dirtycontexts','/1/84/190',1756102075,'1',1756130875),(124,'accesslib/dirtycontexts','/1/84/191',1756102066,'1',1756130866),(125,'accesslib/dirtycontexts','/1/84/192',1756102055,'1',1756130855),(126,'accesslib/dirtycontexts','/1/84/193',1756102695,'1',1756131495),(127,'accesslib/dirtycontexts','/1/84/194',1756102679,'1',1756131479),(128,'accesslib/dirtycontexts','/1/84/195',1756102669,'1',1756131469),(129,'accesslib/dirtycontexts','/1/84/196',1756102976,'1',1756131776),(130,'accesslib/dirtycontexts','/1/84/197',1756102986,'1',1756131786),(131,'accesslib/dirtycontexts','/1/84/198',1756103233,'1',1756132033),(132,'accesslib/dirtycontexts','/1/84/199',1756103224,'1',1756132024),(133,'accesslib/dirtycontexts','/1/84/200',1756271583,'1',1756300383),(134,'accesslib/dirtycontexts','/1/84/201',1756271583,'1',1756300383),(135,'accesslib/dirtycontexts','/1/84/202',1756271583,'1',1756300383),(136,'accesslib/dirtycontexts','/1/84/203',1756271583,'1',1756300383),(137,'accesslib/dirtycontexts','/1/84/204',1756271584,'1',1756300384),(138,'accesslib/dirtycontexts','/1/84/205',1756271584,'1',1756300384),(139,'accesslib/dirtycontexts','/1/84/206',1756271584,'1',1756300384),(140,'accesslib/dirtycontexts','/1/84/207',1756271584,'1',1756300384),(141,'accesslib/dirtycontexts','/1/84/208',1756271584,'1',1756300384),(142,'accesslib/dirtycontexts','/1/84/209',1756271585,'1',1756300385),(143,'accesslib/dirtycontexts','/1/84/210',1756271585,'1',1756300385),(144,'accesslib/dirtycontexts','/1/84/211',1756271585,'1',1756300385),(145,'accesslib/dirtycontexts','/1/84/212',1756271585,'1',1756300385),(146,'accesslib/dirtycontexts','/1/84/213',1756271585,'1',1756300385),(147,'accesslib/dirtycontexts','/1/84/214',1756271586,'1',1756300386),(148,'accesslib/dirtycontexts','/1/84/215',1756271586,'1',1756300386),(149,'accesslib/dirtycontexts','/1/84/216',1756271586,'1',1756300386),(150,'accesslib/dirtycontexts','/1/84/217',1756271586,'1',1756300386),(151,'accesslib/dirtycontexts','/1/84/218',1756271586,'1',1756300386),(152,'accesslib/dirtycontexts','/1/84/219',1756271586,'1',1756300386),(153,'accesslib/dirtycontexts','/1/84/220',1756271587,'1',1756300387),(154,'accesslib/dirtycontexts','/1/84/221',1756271587,'1',1756300387),(155,'accesslib/dirtycontexts','/1/84/222',1756271587,'1',1756300387),(156,'accesslib/dirtycontexts','/1/84/223',1756271587,'1',1756300387),(157,'accesslib/dirtycontexts','/1/84/224',1756271587,'1',1756300387),(158,'accesslib/dirtycontexts','/1/84/225',1756271588,'1',1756300388),(159,'accesslib/dirtycontexts','/1/84/226',1756271588,'1',1756300388),(160,'accesslib/dirtycontexts','/1/84/227',1756271588,'1',1756300388),(161,'accesslib/dirtycontexts','/1/84/228',1756271588,'1',1756300388),(162,'accesslib/dirtycontexts','/1/84/229',1756271588,'1',1756300388),(163,'accesslib/dirtycontexts','/1/84/230',1756271589,'1',1756300389),(164,'accesslib/dirtycontexts','/1/84/231',1756271589,'1',1756300389),(165,'accesslib/dirtycontexts','/1/84/232',1756271589,'1',1756300389),(166,'accesslib/dirtycontexts','/1/84/233',1756271589,'1',1756300389),(167,'accesslib/dirtycontexts','/1/84/234',1756271589,'1',1756300389),(168,'accesslib/dirtycontexts','/1/84/235',1756271590,'1',1756300390),(169,'accesslib/dirtycontexts','/1/84/236',1756271590,'1',1756300390),(170,'accesslib/dirtycontexts','/1/84/237',1756271590,'1',1756300390),(171,'accesslib/dirtycontexts','/1/84/238',1756271590,'1',1756300390),(172,'accesslib/dirtycontexts','/1/84/239',1756271590,'1',1756300390),(173,'accesslib/dirtycontexts','/1/84/240',1756271591,'1',1756300391),(174,'accesslib/dirtycontexts','/1/84/241',1756271591,'1',1756300391),(175,'accesslib/dirtycontexts','/1/84/242',1756271591,'1',1756300391),(176,'accesslib/dirtycontexts','/1/84/243',1756271591,'1',1756300391),(177,'accesslib/dirtycontexts','/1/84/244',1756271591,'1',1756300391),(178,'accesslib/dirtycontexts','/1/84/245',1756271591,'1',1756300391),(179,'accesslib/dirtycontexts','/1/84/246',1756271592,'1',1756300392),(180,'accesslib/dirtycontexts','/1/84/247',1756271592,'1',1756300392),(181,'accesslib/dirtycontexts','/1/84/248',1756271592,'1',1756300392),(182,'accesslib/dirtycontexts','/1/84/249',1756271592,'1',1756300392),(183,'accesslib/dirtycontexts','/1/84/250',1756271592,'1',1756300392),(184,'accesslib/dirtycontexts','/1/84/251',1756271593,'1',1756300393),(185,'accesslib/dirtycontexts','/1/84/252',1756271593,'1',1756300393),(186,'accesslib/dirtycontexts','/1/84/253',1756271593,'1',1756300393),(187,'accesslib/dirtycontexts','/1/84/254',1756271593,'1',1756300393),(188,'accesslib/dirtycontexts','/1/84/255',1756271593,'1',1756300393),(189,'accesslib/dirtycontexts','/1/84/256',1756271594,'1',1756300394),(190,'accesslib/dirtycontexts','/1/84/257',1756271594,'1',1756300394),(191,'accesslib/dirtycontexts','/1/84/258',1756271594,'1',1756300394),(192,'accesslib/dirtycontexts','/1/84/259',1756271594,'1',1756300394),(193,'accesslib/dirtycontexts','/1/84/260',1756271594,'1',1756300394),(194,'accesslib/dirtycontexts','/1/84/261',1756271595,'1',1756300395),(195,'accesslib/dirtycontexts','/1/84/262',1756271595,'1',1756300395),(196,'accesslib/dirtycontexts','/1/84/263',1756271595,'1',1756300395),(197,'accesslib/dirtycontexts','/1/84/264',1756271595,'1',1756300395),(198,'accesslib/dirtycontexts','/1/84/265',1756271595,'1',1756300395),(199,'accesslib/dirtycontexts','/1/84/266',1756271596,'1',1756300396),(200,'accesslib/dirtycontexts','/1/84/267',1756271596,'1',1756300396),(201,'accesslib/dirtycontexts','/1/84/268',1756271596,'1',1756300396),(202,'accesslib/dirtycontexts','/1/84/269',1756271596,'1',1756300396),(203,'accesslib/dirtycontexts','/1/84/270',1756271597,'1',1756300397),(204,'accesslib/dirtycontexts','/1/84/271',1756271597,'1',1756300397),(205,'accesslib/dirtycontexts','/1/84/272',1756271597,'1',1756300397),(206,'accesslib/dirtycontexts','/1/84/273',1756271597,'1',1756300397),(207,'accesslib/dirtycontexts','/1/84/274',1756271598,'1',1756300398),(208,'accesslib/dirtycontexts','/1/84/275',1756271598,'1',1756300398),(209,'accesslib/dirtycontexts','/1/84/276',1756271598,'1',1756300398),(210,'accesslib/dirtycontexts','/1/84/277',1756271598,'1',1756300398),(211,'accesslib/dirtycontexts','/1/84/278',1756271598,'1',1756300398),(212,'accesslib/dirtycontexts','/1/84/279',1756271599,'1',1756300399),(213,'accesslib/dirtycontexts','/1/84/280',1756271599,'1',1756300399),(214,'accesslib/dirtycontexts','/1/84/281',1756271599,'1',1756300399),(215,'accesslib/dirtycontexts','/1/84/282',1756271599,'1',1756300399),(216,'accesslib/dirtycontexts','/1/84/283',1756271599,'1',1756300399),(217,'accesslib/dirtycontexts','/1/84/284',1756271600,'1',1756300400),(218,'accesslib/dirtycontexts','/1/84/285',1756271600,'1',1756300400),(219,'accesslib/dirtycontexts','/1/84/286',1756271600,'1',1756300400),(220,'accesslib/dirtycontexts','/1/84/287',1756271600,'1',1756300400),(221,'accesslib/dirtycontexts','/1/84/288',1756271600,'1',1756300400),(222,'accesslib/dirtycontexts','/1/84/289',1756271601,'1',1756300401),(223,'accesslib/dirtycontexts','/1/84/290',1756271601,'1',1756300401),(224,'accesslib/dirtycontexts','/1/84/291',1756271601,'1',1756300401),(225,'accesslib/dirtycontexts','/1/84/292',1756271601,'1',1756300401),(226,'accesslib/dirtycontexts','/1/84/293',1756271601,'1',1756300401),(227,'accesslib/dirtycontexts','/1/84/294',1756271602,'1',1756300402),(228,'accesslib/dirtycontexts','/1/84/295',1756271602,'1',1756300402),(229,'accesslib/dirtycontexts','/1/84/296',1756271602,'1',1756300402),(230,'accesslib/dirtycontexts','/1/84/297',1756271603,'1',1756300403),(231,'accesslib/dirtycontexts','/1/84/298',1756271603,'1',1756300403),(232,'accesslib/dirtycontexts','/1/84/299',1756271603,'1',1756300403),(233,'accesslib/dirtycontexts','/1/84/300',1756271603,'1',1756300403),(234,'accesslib/dirtycontexts','/1/84/301',1756271603,'1',1756300403),(235,'accesslib/dirtycontexts','/1/84/302',1756271604,'1',1756300404),(236,'accesslib/dirtycontexts','/1/84/303',1756271604,'1',1756300404),(237,'accesslib/dirtycontexts','/1/84/304',1756271604,'1',1756300404),(238,'accesslib/dirtycontexts','/1/84/305',1756271604,'1',1756300404),(239,'accesslib/dirtycontexts','/1/84/306',1756271605,'1',1756300405),(240,'accesslib/dirtycontexts','/1/84/307',1756271605,'1',1756300405),(241,'accesslib/dirtycontexts','/1/84/308',1756271605,'1',1756300405),(242,'accesslib/dirtycontexts','/1/84/309',1756271605,'1',1756300405),(243,'accesslib/dirtycontexts','/1/84/310',1756271605,'1',1756300405),(244,'accesslib/dirtycontexts','/1/84/311',1756271606,'1',1756300406),(245,'accesslib/dirtycontexts','/1/84/312',1756271606,'1',1756300406),(246,'accesslib/dirtycontexts','/1/84/313',1756271606,'1',1756300406),(247,'accesslib/dirtycontexts','/1/84/314',1756271606,'1',1756300406),(248,'accesslib/dirtycontexts','/1/84/315',1756271606,'1',1756300406),(249,'accesslib/dirtycontexts','/1/84/316',1756271606,'1',1756300406),(250,'accesslib/dirtycontexts','/1/84/317',1756271607,'1',1756300407),(251,'accesslib/dirtycontexts','/1/84/318',1756271607,'1',1756300407),(252,'accesslib/dirtycontexts','/1/84/319',1756271607,'1',1756300407),(253,'accesslib/dirtycontexts','/1/84/320',1756271607,'1',1756300407),(254,'accesslib/dirtycontexts','/1/84/321',1756271607,'1',1756300407),(255,'accesslib/dirtycontexts','/1/84/322',1756271608,'1',1756300408),(256,'accesslib/dirtycontexts','/1/84/323',1756271608,'1',1756300408),(257,'accesslib/dirtycontexts','/1/84/324',1756271608,'1',1756300408),(258,'accesslib/dirtycontexts','/1/84/325',1756271608,'1',1756300408),(259,'accesslib/dirtycontexts','/1/84/326',1756271608,'1',1756300408),(260,'accesslib/dirtycontexts','/1/84/327',1756271609,'1',1756300409),(261,'accesslib/dirtycontexts','/1/84/328',1756271609,'1',1756300409),(262,'accesslib/dirtycontexts','/1/84/329',1756271609,'1',1756300409),(263,'accesslib/dirtycontexts','/1/84/330',1756271609,'1',1756300409),(264,'accesslib/dirtycontexts','/1/84/331',1756271609,'1',1756300409),(265,'accesslib/dirtycontexts','/1/84/332',1756271610,'1',1756300410),(266,'accesslib/dirtycontexts','/1/84/333',1756271610,'1',1756300410),(267,'accesslib/dirtycontexts','/1/84/334',1756271610,'1',1756300410),(268,'accesslib/dirtycontexts','/1/84/335',1756271610,'1',1756300410),(269,'accesslib/dirtycontexts','/1/84/336',1756271610,'1',1756300410),(270,'accesslib/dirtycontexts','/1/84/337',1756271611,'1',1756300411),(271,'accesslib/dirtycontexts','/1/84/338',1756271611,'1',1756300411),(272,'accesslib/dirtycontexts','/1/84/339',1756271611,'1',1756300411),(273,'accesslib/dirtycontexts','/1/84/340',1756271611,'1',1756300411),(274,'accesslib/dirtycontexts','/1/84/341',1756271611,'1',1756300411),(275,'accesslib/dirtycontexts','/1/84/342',1756271612,'1',1756300412),(276,'accesslib/dirtycontexts','/1/84/343',1756271612,'1',1756300412),(277,'accesslib/dirtycontexts','/1/84/344',1756271612,'1',1756300412),(278,'accesslib/dirtycontexts','/1/84/345',1756271612,'1',1756300412),(279,'accesslib/dirtycontexts','/1/84/346',1756271612,'1',1756300412),(280,'accesslib/dirtycontexts','/1/84/347',1756271613,'1',1756300413),(281,'accesslib/dirtycontexts','/1/84/348',1756271613,'1',1756300413),(282,'accesslib/dirtycontexts','/1/84/349',1756271613,'1',1756300413),(283,'accesslib/dirtycontexts','/1/84/350',1756271613,'1',1756300413),(284,'accesslib/dirtycontexts','/1/84/351',1756271613,'1',1756300413),(285,'accesslib/dirtycontexts','/1/84/352',1756271614,'1',1756300414),(286,'accesslib/dirtycontexts','/1/84/353',1756271614,'1',1756300414),(287,'accesslib/dirtycontexts','/1/84/354',1756271614,'1',1756300414),(288,'accesslib/dirtycontexts','/1/84/355',1756271614,'1',1756300414),(289,'accesslib/dirtycontexts','/1/84/356',1756271614,'1',1756300414),(290,'accesslib/dirtycontexts','/1/84/357',1756271614,'1',1756300414),(291,'accesslib/dirtycontexts','/1/84/358',1756271615,'1',1756300415),(292,'accesslib/dirtycontexts','/1/84/359',1756271615,'1',1756300415),(293,'accesslib/dirtycontexts','/1/84/360',1756271615,'1',1756300415),(294,'accesslib/dirtycontexts','/1/84/361',1756271615,'1',1756300415),(295,'accesslib/dirtycontexts','/1/84/362',1756271616,'1',1756300416),(296,'accesslib/dirtycontexts','/1/84/363',1756271616,'1',1756300416),(297,'accesslib/dirtycontexts','/1/84/364',1756271616,'1',1756300416),(298,'accesslib/dirtycontexts','/1/84/365',1756271616,'1',1756300416),(299,'accesslib/dirtycontexts','/1/84/366',1756271616,'1',1756300416),(300,'accesslib/dirtycontexts','/1/84/367',1756271617,'1',1756300417),(301,'accesslib/dirtycontexts','/1/84/368',1756271617,'1',1756300417),(302,'accesslib/dirtycontexts','/1/84/369',1756271617,'1',1756300417),(303,'accesslib/dirtycontexts','/1/84/370',1756271617,'1',1756300417),(304,'accesslib/dirtycontexts','/1/84/371',1756271617,'1',1756300417),(305,'accesslib/dirtycontexts','/1/84/372',1756271618,'1',1756300418),(306,'accesslib/dirtycontexts','/1/84/373',1756271618,'1',1756300418),(307,'accesslib/dirtycontexts','/1/84/374',1756271618,'1',1756300418),(308,'accesslib/dirtycontexts','/1/84/375',1756271618,'1',1756300418),(309,'accesslib/dirtycontexts','/1/84/376',1756271619,'1',1756300419),(310,'accesslib/dirtycontexts','/1/84/377',1756271619,'1',1756300419),(311,'accesslib/dirtycontexts','/1/84/378',1756271619,'1',1756300419),(312,'accesslib/dirtycontexts','/1/84/379',1756271619,'1',1756300419),(313,'accesslib/dirtycontexts','/1/84/380',1756271620,'1',1756300420),(314,'accesslib/dirtycontexts','/1/84/381',1756271620,'1',1756300420),(315,'accesslib/dirtycontexts','/1/84/382',1756271620,'1',1756300420),(316,'accesslib/dirtycontexts','/1/84/383',1756271620,'1',1756300420),(317,'accesslib/dirtycontexts','/1/84/384',1756271620,'1',1756300420),(318,'accesslib/dirtycontexts','/1/84/385',1756271620,'1',1756300420),(319,'accesslib/dirtycontexts','/1/84/386',1756271621,'1',1756300421),(320,'accesslib/dirtycontexts','/1/84/387',1756271621,'1',1756300421),(321,'accesslib/dirtycontexts','/1/84/388',1756271621,'1',1756300421),(322,'accesslib/dirtycontexts','/1/84/389',1756271621,'1',1756300421),(323,'accesslib/dirtycontexts','/1/84/390',1756271621,'1',1756300421),(324,'accesslib/dirtycontexts','/1/84/391',1756271622,'1',1756300422),(325,'accesslib/dirtycontexts','/1/84/392',1756271622,'1',1756300422),(326,'accesslib/dirtycontexts','/1/84/393',1756271622,'1',1756300422),(327,'accesslib/dirtycontexts','/1/84/394',1756271622,'1',1756300422),(328,'accesslib/dirtycontexts','/1/84/395',1756271622,'1',1756300422),(329,'accesslib/dirtycontexts','/1/84/396',1756271623,'1',1756300423),(330,'accesslib/dirtycontexts','/1/84/397',1756271623,'1',1756300423),(331,'accesslib/dirtycontexts','/1/84/398',1756271623,'1',1756300423),(332,'accesslib/dirtycontexts','/1/84/399',1756271623,'1',1756300423),(333,'accesslib/dirtycontexts','/1/84/400',1756271624,'1',1756300424),(334,'accesslib/dirtycontexts','/1/84/401',1756271624,'1',1756300424),(335,'accesslib/dirtycontexts','/1/84/402',1756271624,'1',1756300424),(336,'accesslib/dirtycontexts','/1/84/403',1756271624,'1',1756300424),(337,'accesslib/dirtycontexts','/1/84/404',1756271624,'1',1756300424),(338,'accesslib/dirtycontexts','/1/84/405',1756271625,'1',1756300425),(339,'accesslib/dirtycontexts','/1/84/406',1756271625,'1',1756300425),(340,'accesslib/dirtycontexts','/1/84/407',1756271625,'1',1756300425),(341,'accesslib/dirtycontexts','/1/84/408',1756271625,'1',1756300425),(342,'accesslib/dirtycontexts','/1/84/409',1756271625,'1',1756300425),(343,'accesslib/dirtycontexts','/1/84/410',1756271626,'1',1756300426),(344,'accesslib/dirtycontexts','/1/84/411',1756271626,'1',1756300426),(345,'accesslib/dirtycontexts','/1/84/412',1756271626,'1',1756300426),(346,'accesslib/dirtycontexts','/1/84/413',1756271626,'1',1756300426),(347,'accesslib/dirtycontexts','/1/84/414',1756271626,'1',1756300426),(348,'accesslib/dirtycontexts','/1/84/415',1756271626,'1',1756300426),(349,'accesslib/dirtycontexts','/1/84/416',1756271627,'1',1756300427),(350,'accesslib/dirtycontexts','/1/84/417',1756271627,'1',1756300427),(351,'accesslib/dirtycontexts','/1/84/418',1756271627,'1',1756300427),(352,'accesslib/dirtycontexts','/1/84/419',1756271627,'1',1756300427),(353,'accesslib/dirtycontexts','/1/84/420',1756271627,'1',1756300427),(354,'accesslib/dirtycontexts','/1/84/421',1756271628,'1',1756300428),(355,'accesslib/dirtycontexts','/1/84/422',1756271628,'1',1756300428),(356,'accesslib/dirtycontexts','/1/84/423',1756271628,'1',1756300428),(357,'accesslib/dirtycontexts','/1/84/424',1756271628,'1',1756300428),(358,'accesslib/dirtycontexts','/1/84/425',1756271628,'1',1756300428),(359,'accesslib/dirtycontexts','/1/84/426',1756271629,'1',1756300429),(360,'accesslib/dirtycontexts','/1/84/427',1756271629,'1',1756300429),(361,'accesslib/dirtycontexts','/1/84/428',1756271629,'1',1756300429),(362,'accesslib/dirtycontexts','/1/84/429',1756271629,'1',1756300429),(363,'accesslib/dirtycontexts','/1/84/430',1756271630,'1',1756300430),(364,'accesslib/dirtycontexts','/1/84/431',1756271630,'1',1756300430),(365,'accesslib/dirtycontexts','/1/84/432',1756271630,'1',1756300430),(366,'accesslib/dirtycontexts','/1/84/433',1756271630,'1',1756300430),(367,'accesslib/dirtycontexts','/1/84/434',1756271630,'1',1756300430),(368,'accesslib/dirtycontexts','/1/84/435',1756271631,'1',1756300431),(369,'accesslib/dirtycontexts','/1/84/436',1756271631,'1',1756300431),(370,'accesslib/dirtycontexts','/1/84/437',1756271631,'1',1756300431),(371,'accesslib/dirtycontexts','/1/84/438',1756271631,'1',1756300431),(372,'accesslib/dirtycontexts','/1/84/439',1756271631,'1',1756300431),(373,'accesslib/dirtycontexts','/1/84/440',1756271632,'1',1756300432),(374,'accesslib/dirtycontexts','/1/84/441',1756271632,'1',1756300432),(375,'accesslib/dirtycontexts','/1/84/442',1756271632,'1',1756300432),(376,'accesslib/dirtycontexts','/1/84/443',1756271632,'1',1756300432),(377,'accesslib/dirtycontexts','/1/84/444',1756271632,'1',1756300432),(378,'accesslib/dirtycontexts','/1/84/445',1756271633,'1',1756300433),(379,'accesslib/dirtycontexts','/1/84/446',1756271633,'1',1756300433),(380,'accesslib/dirtycontexts','/1/84/447',1756271633,'1',1756300433),(381,'accesslib/dirtycontexts','/1/84/448',1756271633,'1',1756300433),(382,'accesslib/dirtycontexts','/1/84/449',1756271634,'1',1756300434),(383,'accesslib/dirtycontexts','/1/84/450',1756271634,'1',1756300434),(384,'accesslib/dirtycontexts','/1/84/451',1756271635,'1',1756300435),(385,'accesslib/dirtycontexts','/1/84/452',1756271635,'1',1756300435),(386,'accesslib/dirtycontexts','/1/84/453',1756271636,'1',1756300436),(387,'accesslib/dirtycontexts','/1/84/454',1756271636,'1',1756300436),(388,'accesslib/dirtycontexts','/1/84/455',1756271637,'1',1756300437),(389,'accesslib/dirtycontexts','/1/84/456',1756271637,'1',1756300437),(390,'accesslib/dirtycontexts','/1/84/457',1756271638,'1',1756300438),(391,'accesslib/dirtycontexts','/1/84/458',1756271638,'1',1756300438),(392,'accesslib/dirtycontexts','/1/84/459',1756271639,'1',1756300439),(393,'accesslib/dirtycontexts','/1/84/460',1756271639,'1',1756300439),(394,'accesslib/dirtycontexts','/1/84/461',1756271639,'1',1756300439),(395,'accesslib/dirtycontexts','/1/84/462',1756271640,'1',1756300440),(396,'accesslib/dirtycontexts','/1/84/463',1756271640,'1',1756300440),(397,'accesslib/dirtycontexts','/1/84/464',1756271640,'1',1756300440),(398,'accesslib/dirtycontexts','/1/84/465',1756271640,'1',1756300440),(399,'accesslib/dirtycontexts','/1/84/466',1756271640,'1',1756300440),(400,'accesslib/dirtycontexts','/1/84/467',1756271641,'1',1756300441),(401,'accesslib/dirtycontexts','/1/84/468',1756271641,'1',1756300441),(402,'accesslib/dirtycontexts','/1/84/469',1756271641,'1',1756300441),(403,'accesslib/dirtycontexts','/1/84/470',1756271641,'1',1756300441),(404,'accesslib/dirtycontexts','/1/84/471',1756271642,'1',1756300442),(405,'accesslib/dirtycontexts','/1/84/472',1756271642,'1',1756300442),(406,'accesslib/dirtycontexts','/1/84/473',1756271642,'1',1756300442),(407,'accesslib/dirtycontexts','/1/84/474',1756271642,'1',1756300442),(408,'accesslib/dirtycontexts','/1/84/475',1756271642,'1',1756300442),(409,'accesslib/dirtycontexts','/1/84/476',1756271642,'1',1756300442),(410,'accesslib/dirtycontexts','/1/84/477',1756271643,'1',1756300443),(411,'accesslib/dirtycontexts','/1/84/478',1756271643,'1',1756300443),(412,'accesslib/dirtycontexts','/1/84/479',1756271643,'1',1756300443),(413,'accesslib/dirtycontexts','/1/84/480',1756271643,'1',1756300443),(414,'accesslib/dirtycontexts','/1/84/481',1756271643,'1',1756300443),(415,'accesslib/dirtycontexts','/1/84/482',1756271644,'1',1756300444),(416,'accesslib/dirtycontexts','/1/84/483',1756271644,'1',1756300444),(417,'accesslib/dirtycontexts','/1/84/484',1756271644,'1',1756300444),(418,'accesslib/dirtycontexts','/1/84/485',1756271644,'1',1756300444),(419,'accesslib/dirtycontexts','/1/84/486',1756271644,'1',1756300444),(420,'accesslib/dirtycontexts','/1/84/487',1756271645,'1',1756300445),(421,'accesslib/dirtycontexts','/1/84/488',1756271645,'1',1756300445),(422,'accesslib/dirtycontexts','/1/84/489',1756271645,'1',1756300445),(423,'accesslib/dirtycontexts','/1/84/490',1756271645,'1',1756300445),(424,'accesslib/dirtycontexts','/1/84/491',1756271645,'1',1756300445),(425,'accesslib/dirtycontexts','/1/84/492',1756271646,'1',1756300446),(426,'accesslib/dirtycontexts','/1/84/493',1756271646,'1',1756300446),(427,'accesslib/dirtycontexts','/1/84/494',1756271646,'1',1756300446),(428,'accesslib/dirtycontexts','/1/84/495',1756271646,'1',1756300446),(429,'accesslib/dirtycontexts','/1/84/496',1756271646,'1',1756300446),(430,'accesslib/dirtycontexts','/1/84/497',1756271647,'1',1756300447),(431,'accesslib/dirtycontexts','/1/84/498',1756271647,'1',1756300447),(432,'accesslib/dirtycontexts','/1/84/499',1756271647,'1',1756300447),(433,'accesslib/dirtycontexts','/1/84/500',1756271647,'1',1756300447),(434,'accesslib/dirtycontexts','/1/84/501',1756271648,'1',1756300448),(435,'accesslib/dirtycontexts','/1/84/502',1756271648,'1',1756300448),(436,'accesslib/dirtycontexts','/1/84/503',1756271648,'1',1756300448),(437,'accesslib/dirtycontexts','/1/84/504',1756271648,'1',1756300448),(438,'accesslib/dirtycontexts','/1/84/505',1756271648,'1',1756300448),(439,'accesslib/dirtycontexts','/1/84/506',1756271649,'1',1756300449),(440,'accesslib/dirtycontexts','/1/84/507',1756271649,'1',1756300449),(441,'accesslib/dirtycontexts','/1/84/508',1756271649,'1',1756300449),(442,'accesslib/dirtycontexts','/1/84/509',1756271649,'1',1756300449),(443,'accesslib/dirtycontexts','/1/84/510',1756271649,'1',1756300449),(444,'accesslib/dirtycontexts','/1/84/511',1756271650,'1',1756300450),(445,'accesslib/dirtycontexts','/1/84/512',1756271650,'1',1756300450),(446,'accesslib/dirtycontexts','/1/84/513',1756271650,'1',1756300450),(447,'accesslib/dirtycontexts','/1/84/514',1756271650,'1',1756300450),(448,'accesslib/dirtycontexts','/1/84/515',1756271650,'1',1756300450),(449,'accesslib/dirtycontexts','/1/84/516',1756271651,'1',1756300451),(450,'accesslib/dirtycontexts','/1/84/517',1756271651,'1',1756300451),(451,'accesslib/dirtycontexts','/1/84/518',1756271651,'1',1756300451),(452,'accesslib/dirtycontexts','/1/84/519',1756271651,'1',1756300451),(453,'accesslib/dirtycontexts','/1/84/520',1756271651,'1',1756300451),(454,'accesslib/dirtycontexts','/1/84/521',1756271652,'1',1756300452),(455,'accesslib/dirtycontexts','/1/84/522',1756271652,'1',1756300452),(456,'accesslib/dirtycontexts','/1/84/523',1756271652,'1',1756300452),(457,'accesslib/dirtycontexts','/1/84/524',1756271653,'1',1756300453),(458,'accesslib/dirtycontexts','/1/84/525',1756271654,'1',1756300454),(459,'accesslib/dirtycontexts','/1/84/526',1756271654,'1',1756300454),(460,'accesslib/dirtycontexts','/1/84/527',1756271655,'1',1756300455),(461,'accesslib/dirtycontexts','/1/84/528',1756271656,'1',1756300456),(462,'accesslib/dirtycontexts','/1/84/529',1756271657,'1',1756300457),(463,'accesslib/dirtycontexts','/1/84/530',1756271657,'1',1756300457),(464,'accesslib/dirtycontexts','/1/84/531',1756271658,'1',1756300458),(465,'accesslib/dirtycontexts','/1/84/532',1756271658,'1',1756300458),(466,'accesslib/dirtycontexts','/1/84/533',1756271658,'1',1756300458),(467,'accesslib/dirtycontexts','/1/84/534',1756271658,'1',1756300458),(468,'accesslib/dirtycontexts','/1/84/535',1756271659,'1',1756300459),(469,'accesslib/dirtycontexts','/1/84/536',1756271659,'1',1756300459),(470,'accesslib/dirtycontexts','/1/84/537',1756271659,'1',1756300459),(471,'accesslib/dirtycontexts','/1/84/538',1756271659,'1',1756300459),(472,'accesslib/dirtycontexts','/1/84/539',1756271659,'1',1756300459),(473,'accesslib/dirtycontexts','/1/84/540',1756271659,'1',1756300459),(474,'accesslib/dirtycontexts','/1/84/541',1756271660,'1',1756300460),(475,'accesslib/dirtycontexts','/1/84/542',1756271660,'1',1756300460),(476,'accesslib/dirtycontexts','/1/84/543',1756271660,'1',1756300460),(477,'accesslib/dirtycontexts','/1/84/544',1756271660,'1',1756300460),(478,'accesslib/dirtycontexts','/1/84/545',1756271661,'1',1756300461),(479,'accesslib/dirtycontexts','/1/84/546',1756271661,'1',1756300461),(480,'accesslib/dirtycontexts','/1/84/547',1756271661,'1',1756300461),(481,'accesslib/dirtycontexts','/1/84/548',1756271661,'1',1756300461),(482,'accesslib/dirtycontexts','/1/84/549',1756271661,'1',1756300461),(483,'accesslib/dirtycontexts','/1/84/550',1756271662,'1',1756300462),(484,'accesslib/dirtycontexts','/1/84/551',1756271662,'1',1756300462),(485,'accesslib/dirtycontexts','/1/84/552',1756271663,'1',1756300463),(486,'accesslib/dirtycontexts','/1/84/553',1756271663,'1',1756300463),(487,'accesslib/dirtycontexts','/1/84/554',1756271663,'1',1756300463),(488,'accesslib/dirtycontexts','/1/84/555',1756271663,'1',1756300463),(489,'accesslib/dirtycontexts','/1/84/556',1756271664,'1',1756300464),(490,'accesslib/dirtycontexts','/1/84/557',1756271664,'1',1756300464),(491,'accesslib/dirtycontexts','/1/84/558',1756271664,'1',1756300464),(492,'accesslib/dirtycontexts','/1/84/559',1756271664,'1',1756300464),(493,'accesslib/dirtycontexts','/1/84/560',1756271665,'1',1756300465),(494,'accesslib/dirtycontexts','/1/84/561',1756271665,'1',1756300465),(495,'accesslib/dirtycontexts','/1/84/562',1756271665,'1',1756300465),(496,'accesslib/dirtycontexts','/1/84/563',1756271665,'1',1756300465),(497,'accesslib/dirtycontexts','/1/84/564',1756271665,'1',1756300465),(498,'accesslib/dirtycontexts','/1/84/565',1756271666,'1',1756300466),(499,'accesslib/dirtycontexts','/1/84/566',1756271666,'1',1756300466),(500,'accesslib/dirtycontexts','/1/84/567',1756271666,'1',1756300466),(501,'accesslib/dirtycontexts','/1/84/568',1756271666,'1',1756300466),(502,'accesslib/dirtycontexts','/1/84/569',1756271667,'1',1756300467),(503,'accesslib/dirtycontexts','/1/84/570',1756271667,'1',1756300467),(504,'accesslib/dirtycontexts','/1/84/571',1756271667,'1',1756300467),(505,'accesslib/dirtycontexts','/1/84/572',1756271667,'1',1756300467),(506,'accesslib/dirtycontexts','/1/84/573',1756271667,'1',1756300467),(507,'accesslib/dirtycontexts','/1/84/574',1756271667,'1',1756300467),(508,'accesslib/dirtycontexts','/1/84/575',1756271668,'1',1756300468),(509,'accesslib/dirtycontexts','/1/84/576',1756271668,'1',1756300468),(510,'accesslib/dirtycontexts','/1/84/577',1756271668,'1',1756300468),(511,'accesslib/dirtycontexts','/1/84/578',1756271668,'1',1756300468),(512,'accesslib/dirtycontexts','/1/84/579',1756271668,'1',1756300468),(513,'accesslib/dirtycontexts','/1/84/580',1756271669,'1',1756300469),(514,'accesslib/dirtycontexts','/1/84/581',1756271669,'1',1756300469),(515,'accesslib/dirtycontexts','/1/84/582',1756271669,'1',1756300469),(516,'accesslib/dirtycontexts','/1/84/583',1756271669,'1',1756300469),(517,'accesslib/dirtycontexts','/1/84/584',1756271669,'1',1756300469),(518,'accesslib/dirtycontexts','/1/84/585',1756271670,'1',1756300470),(519,'accesslib/dirtycontexts','/1/84/586',1756271670,'1',1756300470),(520,'accesslib/dirtycontexts','/1/84/587',1756271670,'1',1756300470),(521,'accesslib/dirtycontexts','/1/84/588',1756271670,'1',1756300470),(522,'accesslib/dirtycontexts','/1/84/589',1756271670,'1',1756300470),(523,'accesslib/dirtycontexts','/1/84/590',1756271671,'1',1756300471),(524,'accesslib/dirtycontexts','/1/84/591',1756271671,'1',1756300471),(525,'accesslib/dirtycontexts','/1/84/592',1756271671,'1',1756300471),(526,'accesslib/dirtycontexts','/1/84/593',1756271671,'1',1756300471),(527,'accesslib/dirtycontexts','/1/84/594',1756271671,'1',1756300471),(528,'accesslib/dirtycontexts','/1/84/595',1756271672,'1',1756300472),(529,'accesslib/dirtycontexts','/1/84/596',1756271672,'1',1756300472),(530,'accesslib/dirtycontexts','/1/84/597',1756271672,'1',1756300472),(531,'accesslib/dirtycontexts','/1/84/598',1756271672,'1',1756300472),(532,'accesslib/dirtycontexts','/1/84/599',1756271672,'1',1756300472),(533,'accesslib/dirtycontexts','/1/84/600',1756271673,'1',1756300473),(534,'accesslib/dirtycontexts','/1/84/601',1756271673,'1',1756300473),(535,'accesslib/dirtycontexts','/1/84/602',1756271673,'1',1756300473),(536,'accesslib/dirtycontexts','/1/84/603',1756271673,'1',1756300473),(537,'accesslib/dirtycontexts','/1/84/604',1756271673,'1',1756300473),(538,'accesslib/dirtycontexts','/1/84/605',1756271674,'1',1756300474),(539,'accesslib/dirtycontexts','/1/84/606',1756271674,'1',1756300474),(540,'accesslib/dirtycontexts','/1/84/607',1756271674,'1',1756300474),(541,'accesslib/dirtycontexts','/1/84/608',1756271674,'1',1756300474),(542,'accesslib/dirtycontexts','/1/84/609',1756271674,'1',1756300474),(543,'accesslib/dirtycontexts','/1/84/610',1756271675,'1',1756300475),(544,'accesslib/dirtycontexts','/1/84/611',1756271675,'1',1756300475),(545,'accesslib/dirtycontexts','/1/84/612',1756271675,'1',1756300475),(546,'accesslib/dirtycontexts','/1/84/613',1756271675,'1',1756300475),(547,'accesslib/dirtycontexts','/1/84/614',1756271675,'1',1756300475),(548,'accesslib/dirtycontexts','/1/84/615',1756271676,'1',1756300476),(549,'accesslib/dirtycontexts','/1/84/616',1756271676,'1',1756300476),(550,'accesslib/dirtycontexts','/1/84/617',1756271676,'1',1756300476),(551,'accesslib/dirtycontexts','/1/84/618',1756271676,'1',1756300476),(552,'accesslib/dirtycontexts','/1/84/619',1756271676,'1',1756300476),(553,'accesslib/dirtycontexts','/1/84/620',1756271677,'1',1756300477),(554,'accesslib/dirtycontexts','/1/84/621',1756271677,'1',1756300477),(555,'accesslib/dirtycontexts','/1/84/622',1756271677,'1',1756300477),(556,'accesslib/dirtycontexts','/1/84/623',1756271677,'1',1756300477),(557,'accesslib/dirtycontexts','/1/84/624',1756271678,'1',1756300478),(558,'accesslib/dirtycontexts','/1/84/625',1756271678,'1',1756300478),(559,'accesslib/dirtycontexts','/1/84/626',1756271678,'1',1756300478),(560,'accesslib/dirtycontexts','/1/84/627',1756271678,'1',1756300478),(561,'accesslib/dirtycontexts','/1/84/628',1756271678,'1',1756300478),(562,'accesslib/dirtycontexts','/1/84/629',1756271679,'1',1756300479),(563,'accesslib/dirtycontexts','/1/84/630',1756271679,'1',1756300479),(564,'accesslib/dirtycontexts','/1/84/631',1756271679,'1',1756300479),(565,'accesslib/dirtycontexts','/1/84/632',1756271679,'1',1756300479),(566,'accesslib/dirtycontexts','/1/84/633',1756271679,'1',1756300479),(567,'accesslib/dirtycontexts','/1/84/634',1756271680,'1',1756300480),(568,'accesslib/dirtycontexts','/1/84/635',1756271680,'1',1756300480),(569,'accesslib/dirtycontexts','/1/84/636',1756271680,'1',1756300480),(570,'accesslib/dirtycontexts','/1/84/637',1756271680,'1',1756300480),(571,'accesslib/dirtycontexts','/1/84/638',1756271680,'1',1756300480),(572,'accesslib/dirtycontexts','/1/84/639',1756271681,'1',1756300481),(573,'accesslib/dirtycontexts','/1/84/640',1756271681,'1',1756300481),(574,'accesslib/dirtycontexts','/1/84/641',1756271681,'1',1756300481),(575,'accesslib/dirtycontexts','/1/84/642',1756271681,'1',1756300481),(576,'accesslib/dirtycontexts','/1/84/643',1756271681,'1',1756300481),(577,'accesslib/dirtycontexts','/1/84/644',1756271682,'1',1756300482),(578,'accesslib/dirtycontexts','/1/84/645',1756271682,'1',1756300482),(579,'accesslib/dirtycontexts','/1/84/646',1756271682,'1',1756300482),(580,'accesslib/dirtycontexts','/1/84/647',1756271682,'1',1756300482),(581,'accesslib/dirtycontexts','/1/84/648',1756271683,'1',1756300483),(582,'accesslib/dirtycontexts','/1/84/649',1756271683,'1',1756300483),(583,'accesslib/dirtycontexts','/1/84/650',1756271683,'1',1756300483),(584,'accesslib/dirtycontexts','/1/84/651',1756271683,'1',1756300483),(585,'accesslib/dirtycontexts','/1/84/652',1756271683,'1',1756300483),(586,'accesslib/dirtycontexts','/1/84/653',1756271684,'1',1756300484),(587,'accesslib/dirtycontexts','/1/84/654',1756271684,'1',1756300484),(588,'accesslib/dirtycontexts','/1/84/655',1756271684,'1',1756300484),(589,'accesslib/dirtycontexts','/1/84/656',1756271684,'1',1756300484),(590,'accesslib/dirtycontexts','/1/84/657',1756271684,'1',1756300484),(591,'accesslib/dirtycontexts','/1/84/658',1756271684,'1',1756300484),(592,'accesslib/dirtycontexts','/1/84/659',1756271685,'1',1756300485),(593,'accesslib/dirtycontexts','/1/84/660',1756271685,'1',1756300485),(594,'accesslib/dirtycontexts','/1/84/661',1756271685,'1',1756300485),(595,'accesslib/dirtycontexts','/1/84/662',1756271685,'1',1756300485),(596,'accesslib/dirtycontexts','/1/84/663',1756271685,'1',1756300485),(597,'accesslib/dirtycontexts','/1/84/664',1756271686,'1',1756300486),(598,'accesslib/dirtycontexts','/1/84/665',1756271686,'1',1756300486),(599,'accesslib/dirtycontexts','/1/84/666',1756271686,'1',1756300486),(600,'accesslib/dirtycontexts','/1/84/667',1756271686,'1',1756300486),(601,'accesslib/dirtycontexts','/1/84/668',1756271686,'1',1756300486),(602,'accesslib/dirtycontexts','/1/84/669',1756271687,'1',1756300487),(603,'accesslib/dirtycontexts','/1/84/670',1756271687,'1',1756300487),(604,'accesslib/dirtycontexts','/1/84/671',1756271687,'1',1756300487),(605,'accesslib/dirtycontexts','/1/84/672',1756271687,'1',1756300487),(606,'accesslib/dirtycontexts','/1/84/673',1756271687,'1',1756300487),(607,'accesslib/dirtycontexts','/1/84/674',1756271688,'1',1756300488),(608,'accesslib/dirtycontexts','/1/84/675',1756271688,'1',1756300488),(609,'accesslib/dirtycontexts','/1/84/676',1756271688,'1',1756300488),(610,'accesslib/dirtycontexts','/1/84/677',1756271688,'1',1756300488),(611,'accesslib/dirtycontexts','/1/84/678',1756271688,'1',1756300488),(612,'accesslib/dirtycontexts','/1/84/679',1756271689,'1',1756300489),(613,'accesslib/dirtycontexts','/1/84/680',1756271689,'1',1756300489),(614,'accesslib/dirtycontexts','/1/84/681',1756271689,'1',1756300489),(615,'accesslib/dirtycontexts','/1/84/682',1756271689,'1',1756300489),(616,'accesslib/dirtycontexts','/1/84/683',1756271690,'1',1756300490),(617,'accesslib/dirtycontexts','/1/84/684',1756271690,'1',1756300490),(618,'accesslib/dirtycontexts','/1/84/685',1756271690,'1',1756300490),(619,'accesslib/dirtycontexts','/1/84/686',1756271690,'1',1756300490),(620,'accesslib/dirtycontexts','/1/84/687',1756271690,'1',1756300490),(621,'accesslib/dirtycontexts','/1/84/688',1756271691,'1',1756300491),(622,'accesslib/dirtycontexts','/1/84/689',1756271691,'1',1756300491),(623,'accesslib/dirtycontexts','/1/84/690',1756271691,'1',1756300491),(624,'accesslib/dirtycontexts','/1/84/691',1756271691,'1',1756300491),(625,'accesslib/dirtycontexts','/1/84/692',1756271691,'1',1756300491),(626,'accesslib/dirtycontexts','/1/84/693',1756271692,'1',1756300492),(627,'accesslib/dirtycontexts','/1/84/694',1756271692,'1',1756300492),(628,'accesslib/dirtycontexts','/1/84/695',1756271692,'1',1756300492),(629,'accesslib/dirtycontexts','/1/84/696',1756271692,'1',1756300492),(630,'accesslib/dirtycontexts','/1/84/697',1756271692,'1',1756300492),(631,'accesslib/dirtycontexts','/1/84/698',1756271693,'1',1756300493),(632,'accesslib/dirtycontexts','/1/84/699',1756271693,'1',1756300493),(633,'accesslib/dirtycontexts','/1/84/700',1756271693,'1',1756300493),(634,'accesslib/dirtycontexts','/1/84/701',1756271693,'1',1756300493),(635,'accesslib/dirtycontexts','/1/84/702',1756271693,'1',1756300493),(636,'accesslib/dirtycontexts','/1/84/703',1756271693,'1',1756300493),(637,'accesslib/dirtycontexts','/1/84/704',1756271694,'1',1756300494),(638,'accesslib/dirtycontexts','/1/84/705',1756271694,'1',1756300494),(639,'accesslib/dirtycontexts','/1/84/706',1756271694,'1',1756300494),(640,'accesslib/dirtycontexts','/1/84/707',1756271694,'1',1756300494),(641,'accesslib/dirtycontexts','/1/84/708',1756271694,'1',1756300494),(642,'accesslib/dirtycontexts','/1/84/709',1756271695,'1',1756300495),(643,'accesslib/dirtycontexts','/1/84/710',1756271695,'1',1756300495),(644,'accesslib/dirtycontexts','/1/84/711',1756271695,'1',1756300495),(645,'accesslib/dirtycontexts','/1/84/712',1756271695,'1',1756300495),(646,'accesslib/dirtycontexts','/1/84/713',1756271695,'1',1756300495),(647,'accesslib/dirtycontexts','/1/84/714',1756271696,'1',1756300496),(648,'accesslib/dirtycontexts','/1/84/715',1756271696,'1',1756300496),(649,'accesslib/dirtycontexts','/1/84/716',1756271696,'1',1756300496),(650,'accesslib/dirtycontexts','/1/84/717',1756271696,'1',1756300496),(651,'accesslib/dirtycontexts','/1/84/718',1756271696,'1',1756300496),(652,'accesslib/dirtycontexts','/1/84/719',1756271696,'1',1756300496),(653,'accesslib/dirtycontexts','/1/84/720',1756271697,'1',1756300497),(654,'accesslib/dirtycontexts','/1/84/721',1756271697,'1',1756300497),(655,'accesslib/dirtycontexts','/1/84/722',1756271697,'1',1756300497),(656,'accesslib/dirtycontexts','/1/84/723',1756271697,'1',1756300497),(657,'accesslib/dirtycontexts','/1/84/724',1756271697,'1',1756300497),(658,'accesslib/dirtycontexts','/1/84/725',1756271698,'1',1756300498),(659,'accesslib/dirtycontexts','/1/84/726',1756271698,'1',1756300498),(660,'accesslib/dirtycontexts','/1/84/727',1756271698,'1',1756300498),(661,'accesslib/dirtycontexts','/1/84/728',1756271698,'1',1756300498),(662,'accesslib/dirtycontexts','/1/84/729',1756271698,'1',1756300498),(663,'accesslib/dirtycontexts','/1/84/730',1756271699,'1',1756300499),(664,'accesslib/dirtycontexts','/1/84/731',1756271699,'1',1756300499),(665,'accesslib/dirtycontexts','/1/84/732',1756271699,'1',1756300499),(666,'accesslib/dirtycontexts','/1/84/733',1756271699,'1',1756300499),(667,'accesslib/dirtycontexts','/1/84/734',1756271699,'1',1756300499),(668,'accesslib/dirtycontexts','/1/84/735',1756271700,'1',1756300500),(669,'accesslib/dirtycontexts','/1/84/736',1756271700,'1',1756300500),(670,'accesslib/dirtycontexts','/1/84/737',1756271700,'1',1756300500),(671,'accesslib/dirtycontexts','/1/84/738',1756271700,'1',1756300500),(672,'accesslib/dirtycontexts','/1/84/739',1756271700,'1',1756300500),(673,'accesslib/dirtycontexts','/1/84/740',1756271701,'1',1756300501),(674,'accesslib/dirtycontexts','/1/84/741',1756271701,'1',1756300501),(675,'accesslib/dirtycontexts','/1/84/742',1756271701,'1',1756300501),(676,'accesslib/dirtycontexts','/1/84/743',1756271701,'1',1756300501),(677,'accesslib/dirtycontexts','/1/84/744',1756271701,'1',1756300501),(678,'accesslib/dirtycontexts','/1/84/745',1756271702,'1',1756300502),(679,'accesslib/dirtycontexts','/1/84/746',1756271702,'1',1756300502),(680,'accesslib/dirtycontexts','/1/84/747',1756271702,'1',1756300502),(681,'accesslib/dirtycontexts','/1/84/748',1756271702,'1',1756300502),(682,'accesslib/dirtycontexts','/1/84/749',1756271703,'1',1756300503),(683,'accesslib/dirtycontexts','/1/84/750',1756271703,'1',1756300503),(684,'accesslib/dirtycontexts','/1/84/751',1756271703,'1',1756300503),(685,'accesslib/dirtycontexts','/1/84/752',1756271703,'1',1756300503),(686,'accesslib/dirtycontexts','/1/84/753',1756271703,'1',1756300503),(687,'accesslib/dirtycontexts','/1/84/754',1756271704,'1',1756300504),(688,'accesslib/dirtycontexts','/1/84/755',1756271704,'1',1756300504),(689,'accesslib/dirtycontexts','/1/84/756',1756271704,'1',1756300504),(690,'accesslib/dirtycontexts','/1/84/757',1756271704,'1',1756300504),(691,'accesslib/dirtycontexts','/1/84/758',1756271704,'1',1756300504),(692,'accesslib/dirtycontexts','/1/84/759',1756271705,'1',1756300505),(693,'accesslib/dirtycontexts','/1/84/760',1756271705,'1',1756300505),(694,'accesslib/dirtycontexts','/1/84/761',1756271705,'1',1756300505),(695,'accesslib/dirtycontexts','/1/84/762',1756271705,'1',1756300505),(696,'accesslib/dirtycontexts','/1/84/763',1756271706,'1',1756300506),(697,'accesslib/dirtycontexts','/1/84/764',1756271706,'1',1756300506),(698,'accesslib/dirtycontexts','/1/84/765',1756271706,'1',1756300506),(699,'accesslib/dirtycontexts','/1/84/766',1756271706,'1',1756300506),(700,'accesslib/dirtycontexts','/1/84/767',1756271707,'1',1756300507),(701,'accesslib/dirtycontexts','/1/84/768',1756271707,'1',1756300507),(702,'accesslib/dirtycontexts','/1/84/769',1756271707,'1',1756300507),(703,'accesslib/dirtycontexts','/1/84/770',1756271707,'1',1756300507),(704,'accesslib/dirtycontexts','/1/84/771',1756271707,'1',1756300507),(705,'accesslib/dirtycontexts','/1/84/772',1756271708,'1',1756300508),(706,'accesslib/dirtycontexts','/1/84/773',1756271708,'1',1756300508),(707,'accesslib/dirtycontexts','/1/84/774',1756271708,'1',1756300508),(708,'accesslib/dirtycontexts','/1/84/775',1756271708,'1',1756300508),(709,'accesslib/dirtycontexts','/1/84/776',1756271708,'1',1756300508),(710,'accesslib/dirtycontexts','/1/84/777',1756271709,'1',1756300509),(711,'accesslib/dirtycontexts','/1/84/778',1756271709,'1',1756300509),(712,'accesslib/dirtycontexts','/1/84/779',1756271709,'1',1756300509),(713,'accesslib/dirtycontexts','/1/84/780',1756271709,'1',1756300509),(714,'accesslib/dirtycontexts','/1/84/781',1756271710,'1',1756300510),(715,'accesslib/dirtycontexts','/1/84/782',1756271710,'1',1756300510),(716,'accesslib/dirtycontexts','/1/84/783',1756271710,'1',1756300510),(717,'accesslib/dirtycontexts','/1/84/784',1756271710,'1',1756300510),(718,'accesslib/dirtycontexts','/1/84/785',1756271710,'1',1756300510),(719,'accesslib/dirtycontexts','/1/84/786',1756271711,'1',1756300511),(720,'accesslib/dirtycontexts','/1/84/787',1756271711,'1',1756300511),(721,'accesslib/dirtycontexts','/1/84/788',1756271711,'1',1756300511),(722,'accesslib/dirtycontexts','/1/84/789',1756271711,'1',1756300511),(723,'accesslib/dirtycontexts','/1/84/790',1756271711,'1',1756300511),(724,'accesslib/dirtycontexts','/1/84/791',1756271712,'1',1756300512),(725,'accesslib/dirtycontexts','/1/84/792',1756271712,'1',1756300512),(726,'accesslib/dirtycontexts','/1/84/793',1756271712,'1',1756300512),(727,'accesslib/dirtycontexts','/1/84/794',1756271712,'1',1756300512),(728,'accesslib/dirtycontexts','/1/84/795',1756271712,'1',1756300512),(729,'accesslib/dirtycontexts','/1/84/796',1756271713,'1',1756300513),(730,'accesslib/dirtycontexts','/1/84/797',1756271713,'1',1756300513),(731,'accesslib/dirtycontexts','/1/84/798',1756271713,'1',1756300513),(732,'accesslib/dirtycontexts','/1/84/799',1756271713,'1',1756300513),(733,'accesslib/dirtycontexts','/1/84/800',1756271713,'1',1756300513),(734,'accesslib/dirtycontexts','/1/84/801',1756271714,'1',1756300514),(735,'accesslib/dirtycontexts','/1/84/802',1756271714,'1',1756300514),(736,'accesslib/dirtycontexts','/1/84/803',1756271714,'1',1756300514),(737,'accesslib/dirtycontexts','/1/84/804',1756271714,'1',1756300514),(738,'accesslib/dirtycontexts','/1/84/805',1756271715,'1',1756300515),(739,'accesslib/dirtycontexts','/1/84/806',1756271715,'1',1756300515),(740,'accesslib/dirtycontexts','/1/84/807',1756271715,'1',1756300515),(741,'accesslib/dirtycontexts','/1/84/808',1756271715,'1',1756300515),(742,'accesslib/dirtycontexts','/1/84/809',1756271716,'1',1756300516),(743,'accesslib/dirtycontexts','/1/84/810',1756271716,'1',1756300516),(744,'accesslib/dirtycontexts','/1/84/811',1756271716,'1',1756300516),(745,'accesslib/dirtycontexts','/1/84/812',1756271716,'1',1756300516),(746,'accesslib/dirtycontexts','/1/84/813',1756271716,'1',1756300516),(747,'accesslib/dirtycontexts','/1/84/814',1756271717,'1',1756300517),(748,'accesslib/dirtycontexts','/1/84/815',1756271717,'1',1756300517),(749,'accesslib/dirtycontexts','/1/84/816',1756271717,'1',1756300517),(750,'accesslib/dirtycontexts','/1/84/817',1756271717,'1',1756300517),(751,'accesslib/dirtycontexts','/1/84/818',1756271717,'1',1756300517),(752,'accesslib/dirtycontexts','/1/84/819',1756271718,'1',1756300518),(753,'accesslib/dirtycontexts','/1/84/820',1756271718,'1',1756300518),(754,'accesslib/dirtycontexts','/1/84/821',1756271718,'1',1756300518),(755,'accesslib/dirtycontexts','/1/84/822',1756271718,'1',1756300518),(756,'accesslib/dirtycontexts','/1/84/823',1756271719,'1',1756300519),(757,'accesslib/dirtycontexts','/1/84/824',1756271719,'1',1756300519),(758,'accesslib/dirtycontexts','/1/84/825',1756271719,'1',1756300519),(759,'accesslib/dirtycontexts','/1/84/826',1756271719,'1',1756300519),(760,'accesslib/dirtycontexts','/1/84/827',1756271719,'1',1756300519),(761,'accesslib/dirtycontexts','/1/84/828',1756271719,'1',1756300519),(762,'accesslib/dirtycontexts','/1/84/829',1756271720,'1',1756300520),(763,'accesslib/dirtycontexts','/1/84/830',1756271720,'1',1756300520),(764,'accesslib/dirtycontexts','/1/84/831',1756271720,'1',1756300520),(765,'accesslib/dirtycontexts','/1/84/832',1756271720,'1',1756300520),(766,'accesslib/dirtycontexts','/1/84/833',1756271720,'1',1756300520),(767,'accesslib/dirtycontexts','/1/84/834',1756271721,'1',1756300521),(768,'accesslib/dirtycontexts','/1/84/835',1756271721,'1',1756300521),(769,'accesslib/dirtycontexts','/1/84/836',1756271721,'1',1756300521),(770,'accesslib/dirtycontexts','/1/84/837',1756271721,'1',1756300521),(771,'accesslib/dirtycontexts','/1/84/838',1756271721,'1',1756300521),(772,'accesslib/dirtycontexts','/1/84/839',1756271722,'1',1756300522),(773,'accesslib/dirtycontexts','/1/84/840',1756271722,'1',1756300522),(774,'accesslib/dirtycontexts','/1/84/841',1756271722,'1',1756300522),(775,'accesslib/dirtycontexts','/1/84/842',1756271722,'1',1756300522),(776,'accesslib/dirtycontexts','/1/84/843',1756271722,'1',1756300522),(777,'accesslib/dirtycontexts','/1/84/844',1756271723,'1',1756300523),(778,'accesslib/dirtycontexts','/1/84/845',1756271723,'1',1756300523),(779,'accesslib/dirtycontexts','/1/84/846',1756271723,'1',1756300523),(780,'accesslib/dirtycontexts','/1/84/847',1756271723,'1',1756300523),(781,'accesslib/dirtycontexts','/1/84/848',1756271723,'1',1756300523),(782,'accesslib/dirtycontexts','/1/84/849',1756271724,'1',1756300524),(783,'accesslib/dirtycontexts','/1/84/850',1756271724,'1',1756300524),(784,'accesslib/dirtycontexts','/1/84/851',1756271724,'1',1756300524),(785,'accesslib/dirtycontexts','/1/84/852',1756271724,'1',1756300524),(786,'accesslib/dirtycontexts','/1/84/853',1756271724,'1',1756300524),(787,'accesslib/dirtycontexts','/1/84/854',1756271725,'1',1756300525),(788,'accesslib/dirtycontexts','/1/84/855',1756271725,'1',1756300525),(789,'accesslib/dirtycontexts','/1/84/856',1756271725,'1',1756300525),(790,'accesslib/dirtycontexts','/1/84/857',1756271725,'1',1756300525),(791,'accesslib/dirtycontexts','/1/84/858',1756271725,'1',1756300525),(792,'accesslib/dirtycontexts','/1/84/859',1756271726,'1',1756300526),(793,'accesslib/dirtycontexts','/1/84/860',1756271726,'1',1756300526),(794,'accesslib/dirtycontexts','/1/84/861',1756271726,'1',1756300526),(795,'accesslib/dirtycontexts','/1/84/862',1756271726,'1',1756300526),(796,'accesslib/dirtycontexts','/1/84/863',1756271726,'1',1756300526),(797,'accesslib/dirtycontexts','/1/84/864',1756271727,'1',1756300527),(798,'accesslib/dirtycontexts','/1/84/865',1756271727,'1',1756300527),(799,'accesslib/dirtycontexts','/1/84/866',1756271727,'1',1756300527),(800,'accesslib/dirtycontexts','/1/84/867',1756271727,'1',1756300527),(801,'accesslib/dirtycontexts','/1/84/868',1756271727,'1',1756300527),(802,'accesslib/dirtycontexts','/1/84/869',1756271728,'1',1756300528),(803,'accesslib/dirtycontexts','/1/84/870',1756271728,'1',1756300528),(804,'accesslib/dirtycontexts','/1/84/871',1756271728,'1',1756300528),(805,'accesslib/dirtycontexts','/1/84/872',1756271728,'1',1756300528),(806,'accesslib/dirtycontexts','/1/84/873',1756271728,'1',1756300528),(807,'accesslib/dirtycontexts','/1/84/874',1756271729,'1',1756300529),(808,'accesslib/dirtycontexts','/1/84/875',1756271729,'1',1756300529),(809,'accesslib/dirtycontexts','/1/84/876',1756271729,'1',1756300529),(810,'accesslib/dirtycontexts','/1/84/877',1756271729,'1',1756300529),(811,'accesslib/dirtycontexts','/1/84/878',1756271729,'1',1756300529),(812,'accesslib/dirtycontexts','/1/84/879',1756271730,'1',1756300530),(813,'accesslib/dirtycontexts','/1/84/880',1756271730,'1',1756300530),(814,'accesslib/dirtycontexts','/1/84/881',1756271730,'1',1756300530),(815,'accesslib/dirtycontexts','/1/84/882',1756271730,'1',1756300530),(816,'accesslib/dirtycontexts','/1/84/883',1756271730,'1',1756300530),(817,'accesslib/dirtycontexts','/1/84/884',1756271731,'1',1756300531),(818,'accesslib/dirtycontexts','/1/84/885',1756271731,'1',1756300531),(819,'accesslib/dirtycontexts','/1/84/886',1756271731,'1',1756300531),(820,'accesslib/dirtycontexts','/1/84/887',1756271731,'1',1756300531),(821,'accesslib/dirtycontexts','/1/84/888',1756271731,'1',1756300531),(822,'accesslib/dirtycontexts','/1/84/889',1756271732,'1',1756300532),(823,'accesslib/dirtycontexts','/1/84/890',1756271732,'1',1756300532),(824,'accesslib/dirtycontexts','/1/84/891',1756271732,'1',1756300532),(825,'accesslib/dirtycontexts','/1/84/892',1756271732,'1',1756300532),(826,'accesslib/dirtycontexts','/1/84/893',1756271732,'1',1756300532),(827,'accesslib/dirtycontexts','/1/84/894',1756271733,'1',1756300533),(828,'accesslib/dirtycontexts','/1/84/895',1756271733,'1',1756300533),(829,'accesslib/dirtycontexts','/1/84/896',1756271733,'1',1756300533),(830,'accesslib/dirtycontexts','/1/84/897',1756271733,'1',1756300533),(831,'accesslib/dirtycontexts','/1/84/898',1756271733,'1',1756300533),(832,'accesslib/dirtycontexts','/1/84/899',1756271734,'1',1756300534),(833,'accesslib/dirtycontexts','/1/84/900',1756271734,'1',1756300534),(834,'accesslib/dirtycontexts','/1/84/901',1756271734,'1',1756300534),(835,'accesslib/dirtycontexts','/1/84/902',1756271734,'1',1756300534),(836,'accesslib/dirtycontexts','/1/84/903',1756271735,'1',1756300535),(837,'accesslib/dirtycontexts','/1/84/904',1756271735,'1',1756300535),(838,'accesslib/dirtycontexts','/1/84/905',1756271735,'1',1756300535),(839,'accesslib/dirtycontexts','/1/84/906',1756271735,'1',1756300535),(840,'accesslib/dirtycontexts','/1/84/907',1756271736,'1',1756300536),(841,'accesslib/dirtycontexts','/1/84/908',1756271736,'1',1756300536),(842,'accesslib/dirtycontexts','/1/84/909',1756271736,'1',1756300536),(843,'accesslib/dirtycontexts','/1/84/910',1756271736,'1',1756300536),(844,'accesslib/dirtycontexts','/1/84/911',1756271736,'1',1756300536),(845,'accesslib/dirtycontexts','/1/84/912',1756271737,'1',1756300537),(846,'accesslib/dirtycontexts','/1/84/913',1756271737,'1',1756300537),(847,'accesslib/dirtycontexts','/1/84/914',1756271737,'1',1756300537),(848,'accesslib/dirtycontexts','/1/84/915',1756271737,'1',1756300537),(849,'accesslib/dirtycontexts','/1/84/916',1756271738,'1',1756300538),(850,'accesslib/dirtycontexts','/1/84/917',1756271738,'1',1756300538),(851,'accesslib/dirtycontexts','/1/84/918',1756271738,'1',1756300538),(852,'accesslib/dirtycontexts','/1/84/919',1756271738,'1',1756300538),(853,'accesslib/dirtycontexts','/1/84/920',1756271738,'1',1756300538),(854,'accesslib/dirtycontexts','/1/84/921',1756271739,'1',1756300539),(855,'accesslib/dirtycontexts','/1/84/922',1756271739,'1',1756300539),(856,'accesslib/dirtycontexts','/1/84/923',1756271739,'1',1756300539),(857,'accesslib/dirtycontexts','/1/84/924',1756271739,'1',1756300539),(858,'accesslib/dirtycontexts','/1/84/925',1756271739,'1',1756300539),(859,'accesslib/dirtycontexts','/1/84/926',1756271740,'1',1756300540),(860,'accesslib/dirtycontexts','/1/84/927',1756271740,'1',1756300540),(861,'accesslib/dirtycontexts','/1/84/928',1756271740,'1',1756300540),(862,'accesslib/dirtycontexts','/1/84/929',1756271740,'1',1756300540),(863,'accesslib/dirtycontexts','/1/84/930',1756271740,'1',1756300540),(864,'accesslib/dirtycontexts','/1/84/931',1756271740,'1',1756300540),(865,'accesslib/dirtycontexts','/1/84/932',1756271741,'1',1756300541),(866,'accesslib/dirtycontexts','/1/84/933',1756271741,'1',1756300541),(867,'accesslib/dirtycontexts','/1/84/934',1756271741,'1',1756300541),(868,'accesslib/dirtycontexts','/1/84/935',1756271741,'1',1756300541),(869,'accesslib/dirtycontexts','/1/84/936',1756271741,'1',1756300541),(870,'accesslib/dirtycontexts','/1/84/937',1756271742,'1',1756300542),(871,'accesslib/dirtycontexts','/1/84/938',1756271742,'1',1756300542),(872,'accesslib/dirtycontexts','/1/84/939',1756271742,'1',1756300542),(873,'accesslib/dirtycontexts','/1/84/940',1756271742,'1',1756300542),(874,'accesslib/dirtycontexts','/1/84/941',1756271742,'1',1756300542),(875,'accesslib/dirtycontexts','/1/84/942',1756271743,'1',1756300543),(876,'accesslib/dirtycontexts','/1/84/943',1756271743,'1',1756300543),(877,'accesslib/dirtycontexts','/1/84/944',1756271743,'1',1756300543),(878,'accesslib/dirtycontexts','/1/84/945',1756271743,'1',1756300543),(879,'accesslib/dirtycontexts','/1/84/946',1756271743,'1',1756300543),(880,'accesslib/dirtycontexts','/1/84/947',1756271744,'1',1756300544),(881,'accesslib/dirtycontexts','/1/84/948',1756271744,'1',1756300544),(882,'accesslib/dirtycontexts','/1/84/949',1756271744,'1',1756300544),(883,'accesslib/dirtycontexts','/1/84/950',1756271744,'1',1756300544),(884,'accesslib/dirtycontexts','/1/84/951',1756271744,'1',1756300544),(885,'accesslib/dirtycontexts','/1/84/952',1756271745,'1',1756300545),(886,'accesslib/dirtycontexts','/1/84/953',1756271745,'1',1756300545),(887,'accesslib/dirtycontexts','/1/84/954',1756271745,'1',1756300545),(888,'accesslib/dirtycontexts','/1/84/955',1756271745,'1',1756300545),(889,'accesslib/dirtycontexts','/1/84/956',1756271745,'1',1756300545),(890,'accesslib/dirtycontexts','/1/84/957',1756271745,'1',1756300545),(891,'accesslib/dirtycontexts','/1/84/958',1756271746,'1',1756300546),(892,'accesslib/dirtycontexts','/1/84/959',1756271746,'1',1756300546),(893,'accesslib/dirtycontexts','/1/84/960',1756271746,'1',1756300546),(894,'accesslib/dirtycontexts','/1/84/961',1756271746,'1',1756300546),(895,'accesslib/dirtycontexts','/1/84/962',1756271746,'1',1756300546),(896,'accesslib/dirtycontexts','/1/84/963',1756271747,'1',1756300547),(897,'accesslib/dirtycontexts','/1/84/964',1756271747,'1',1756300547),(898,'accesslib/dirtycontexts','/1/84/965',1756271747,'1',1756300547),(899,'accesslib/dirtycontexts','/1/84/966',1756271747,'1',1756300547),(900,'accesslib/dirtycontexts','/1/84/967',1756271748,'1',1756300548),(901,'accesslib/dirtycontexts','/1/84/968',1756271748,'1',1756300548),(902,'accesslib/dirtycontexts','/1/84/969',1756271748,'1',1756300548),(903,'accesslib/dirtycontexts','/1/84/970',1756271748,'1',1756300548),(904,'accesslib/dirtycontexts','/1/84/971',1756271748,'1',1756300548),(905,'accesslib/dirtycontexts','/1/84/972',1756271749,'1',1756300549),(906,'accesslib/dirtycontexts','/1/84/973',1756271749,'1',1756300549),(907,'accesslib/dirtycontexts','/1/84/974',1756271749,'1',1756300549),(908,'accesslib/dirtycontexts','/1/84/975',1756271749,'1',1756300549),(909,'accesslib/dirtycontexts','/1/84/976',1756271749,'1',1756300549),(910,'accesslib/dirtycontexts','/1/84/977',1756271750,'1',1756300550),(911,'accesslib/dirtycontexts','/1/84/978',1756271750,'1',1756300550),(912,'accesslib/dirtycontexts','/1/84/979',1756271750,'1',1756300550),(913,'accesslib/dirtycontexts','/1/84/980',1756271750,'1',1756300550),(914,'accesslib/dirtycontexts','/1/84/981',1756271750,'1',1756300550),(915,'accesslib/dirtycontexts','/1/84/982',1756271751,'1',1756300551),(916,'accesslib/dirtycontexts','/1/84/983',1756271751,'1',1756300551),(917,'accesslib/dirtycontexts','/1/84/984',1756271751,'1',1756300551),(918,'accesslib/dirtycontexts','/1/84/985',1756271751,'1',1756300551),(919,'accesslib/dirtycontexts','/1/84/986',1756271751,'1',1756300551),(920,'accesslib/dirtycontexts','/1/84/987',1756271752,'1',1756300552),(921,'accesslib/dirtycontexts','/1/84/988',1756271752,'1',1756300552),(922,'accesslib/dirtycontexts','/1/84/989',1756271752,'1',1756300552),(923,'accesslib/dirtycontexts','/1/84/990',1756271752,'1',1756300552),(924,'accesslib/dirtycontexts','/1/84/991',1756271752,'1',1756300552),(925,'accesslib/dirtycontexts','/1/84/992',1756271753,'1',1756300553),(926,'accesslib/dirtycontexts','/1/84/993',1756271753,'1',1756300553),(927,'accesslib/dirtycontexts','/1/84/994',1756271753,'1',1756300553),(928,'accesslib/dirtycontexts','/1/84/995',1756271753,'1',1756300553),(929,'accesslib/dirtycontexts','/1/84/996',1756271753,'1',1756300553),(930,'accesslib/dirtycontexts','/1/84/997',1756271754,'1',1756300554),(931,'accesslib/dirtycontexts','/1/84/998',1756271754,'1',1756300554),(932,'accesslib/dirtycontexts','/1/84/999',1756271754,'1',1756300554),(933,'accesslib/dirtycontexts','/1/84/1000',1756271754,'1',1756300554),(934,'accesslib/dirtycontexts','/1/84/1001',1756271754,'1',1756300554),(935,'accesslib/dirtycontexts','/1/84/1002',1756271755,'1',1756300555),(936,'accesslib/dirtycontexts','/1/84/1003',1756271755,'1',1756300555),(937,'accesslib/dirtycontexts','/1/84/1004',1756271755,'1',1756300555),(938,'accesslib/dirtycontexts','/1/84/1005',1756271755,'1',1756300555),(939,'accesslib/dirtycontexts','/1/84/1006',1756271755,'1',1756300555),(940,'accesslib/dirtycontexts','/1/84/1007',1756271756,'1',1756300556),(941,'accesslib/dirtycontexts','/1/84/1008',1756271756,'1',1756300556),(942,'accesslib/dirtycontexts','/1/84/1009',1756271756,'1',1756300556),(943,'accesslib/dirtycontexts','/1/84/1010',1756271756,'1',1756300556),(944,'accesslib/dirtycontexts','/1/84/1011',1756271756,'1',1756300556),(945,'accesslib/dirtycontexts','/1/84/1012',1756271757,'1',1756300557),(946,'accesslib/dirtycontexts','/1/84/1013',1756271757,'1',1756300557),(947,'accesslib/dirtycontexts','/1/84/1014',1756271757,'1',1756300557),(948,'accesslib/dirtycontexts','/1/84/1015',1756271758,'1',1756300558),(949,'accesslib/dirtycontexts','/1/84/1016',1756271758,'1',1756300558),(950,'accesslib/dirtycontexts','/1/84/1017',1756271758,'1',1756300558),(951,'accesslib/dirtycontexts','/1/84/1018',1756271759,'1',1756300559),(952,'accesslib/dirtycontexts','/1/84/1019',1756271759,'1',1756300559),(953,'accesslib/dirtycontexts','/1/84/1020',1756271759,'1',1756300559),(954,'accesslib/dirtycontexts','/1/84/1021',1756271759,'1',1756300559),(955,'accesslib/dirtycontexts','/1/84/1022',1756271759,'1',1756300559),(956,'accesslib/dirtycontexts','/1/84/1023',1756271760,'1',1756300560),(957,'accesslib/dirtycontexts','/1/84/1024',1756271760,'1',1756300560),(958,'accesslib/dirtycontexts','/1/84/1025',1756271760,'1',1756300560),(959,'accesslib/dirtycontexts','/1/84/1026',1756271760,'1',1756300560),(960,'accesslib/dirtycontexts','/1/84/1027',1756271760,'1',1756300560),(961,'accesslib/dirtycontexts','/1/84/1028',1756271761,'1',1756300561),(962,'accesslib/dirtycontexts','/1/84/1029',1756271761,'1',1756300561),(963,'accesslib/dirtycontexts','/1/84/1030',1756271761,'1',1756300561),(964,'accesslib/dirtycontexts','/1/84/1031',1756271761,'1',1756300561),(965,'accesslib/dirtycontexts','/1/84/1032',1756271761,'1',1756300561),(966,'accesslib/dirtycontexts','/1/84/1033',1756271762,'1',1756300562),(967,'accesslib/dirtycontexts','/1/84/1034',1756271762,'1',1756300562),(968,'accesslib/dirtycontexts','/1/84/1035',1756271762,'1',1756300562),(969,'accesslib/dirtycontexts','/1/84/1036',1756271762,'1',1756300562),(970,'accesslib/dirtycontexts','/1/84/1037',1756271762,'1',1756300562),(971,'accesslib/dirtycontexts','/1/84/1038',1756271763,'1',1756300563),(972,'accesslib/dirtycontexts','/1/84/1039',1756271763,'1',1756300563),(973,'accesslib/dirtycontexts','/1/84/1040',1756271763,'1',1756300563),(974,'accesslib/dirtycontexts','/1/84/1041',1756271763,'1',1756300563),(975,'accesslib/dirtycontexts','/1/84/1042',1756271763,'1',1756300563),(976,'accesslib/dirtycontexts','/1/84/1043',1756271764,'1',1756300564),(977,'accesslib/dirtycontexts','/1/84/1044',1756271764,'1',1756300564),(978,'accesslib/dirtycontexts','/1/84/1045',1756271764,'1',1756300564),(979,'accesslib/dirtycontexts','/1/84/1046',1756271764,'1',1756300564),(980,'accesslib/dirtycontexts','/1/84/1047',1756271765,'1',1756300565),(981,'accesslib/dirtycontexts','/1/84/1048',1756271765,'1',1756300565),(982,'accesslib/dirtycontexts','/1/84/1049',1756271765,'1',1756300565),(983,'accesslib/dirtycontexts','/1/84/1050',1756271765,'1',1756300565),(984,'accesslib/dirtycontexts','/1/84/1051',1756271766,'1',1756300566),(985,'accesslib/dirtycontexts','/1/84/1052',1756271766,'1',1756300566),(986,'accesslib/dirtycontexts','/1/84/1053',1756271767,'1',1756300567),(987,'accesslib/dirtycontexts','/1/84/1054',1756271767,'1',1756300567),(988,'accesslib/dirtycontexts','/1/84/1055',1756271767,'1',1756300567),(989,'accesslib/dirtycontexts','/1/84/1056',1756271767,'1',1756300567),(990,'accesslib/dirtycontexts','/1/84/1057',1756271767,'1',1756300567),(991,'accesslib/dirtycontexts','/1/84/1058',1756271768,'1',1756300568),(992,'accesslib/dirtycontexts','/1/84/1059',1756271768,'1',1756300568),(993,'accesslib/dirtycontexts','/1/84/1060',1756271768,'1',1756300568),(994,'accesslib/dirtycontexts','/1/84/1061',1756271768,'1',1756300568),(995,'accesslib/dirtycontexts','/1/84/1062',1756271768,'1',1756300568),(996,'accesslib/dirtycontexts','/1/84/1063',1756271769,'1',1756300569),(997,'accesslib/dirtycontexts','/1/84/1064',1756271769,'1',1756300569),(998,'accesslib/dirtycontexts','/1/84/1065',1756271769,'1',1756300569),(999,'accesslib/dirtycontexts','/1/84/1066',1756271769,'1',1756300569),(1000,'accesslib/dirtycontexts','/1/84/1067',1756271769,'1',1756300569),(1001,'accesslib/dirtycontexts','/1/84/1068',1756271769,'1',1756300569),(1002,'accesslib/dirtycontexts','/1/84/1069',1756271770,'1',1756300570),(1003,'accesslib/dirtycontexts','/1/84/1070',1756271770,'1',1756300570),(1004,'accesslib/dirtycontexts','/1/84/1071',1756271770,'1',1756300570),(1005,'accesslib/dirtycontexts','/1/84/1072',1756271770,'1',1756300570),(1006,'accesslib/dirtycontexts','/1/84/1073',1756271770,'1',1756300570),(1007,'accesslib/dirtycontexts','/1/84/1074',1756271771,'1',1756300571),(1008,'accesslib/dirtycontexts','/1/84/1075',1756271771,'1',1756300571),(1009,'accesslib/dirtycontexts','/1/84/1076',1756271771,'1',1756300571),(1010,'accesslib/dirtycontexts','/1/84/1077',1756271771,'1',1756300571),(1011,'accesslib/dirtycontexts','/1/84/1078',1756271771,'1',1756300571),(1012,'accesslib/dirtycontexts','/1/84/1079',1756271772,'1',1756300572),(1013,'accesslib/dirtycontexts','/1/84/1080',1756271772,'1',1756300572),(1014,'accesslib/dirtycontexts','/1/84/1081',1756271772,'1',1756300572),(1015,'accesslib/dirtycontexts','/1/84/1082',1756271772,'1',1756300572),(1016,'accesslib/dirtycontexts','/1/84/1083',1756271772,'1',1756300572),(1017,'accesslib/dirtycontexts','/1/84/1084',1756271773,'1',1756300573),(1018,'accesslib/dirtycontexts','/1/84/1085',1756271773,'1',1756300573),(1019,'accesslib/dirtycontexts','/1/84/1086',1756271773,'1',1756300573),(1020,'accesslib/dirtycontexts','/1/84/1087',1756271773,'1',1756300573),(1021,'accesslib/dirtycontexts','/1/84/1088',1756271773,'1',1756300573),(1022,'accesslib/dirtycontexts','/1/84/1089',1756271773,'1',1756300573),(1023,'accesslib/dirtycontexts','/1/84/1090',1756271774,'1',1756300574),(1024,'accesslib/dirtycontexts','/1/84/1091',1756271774,'1',1756300574),(1025,'accesslib/dirtycontexts','/1/84/1092',1756271774,'1',1756300574),(1026,'accesslib/dirtycontexts','/1/84/1093',1756271774,'1',1756300574),(1027,'accesslib/dirtycontexts','/1/84/1094',1756271774,'1',1756300574),(1028,'accesslib/dirtycontexts','/1/84/1095',1756271775,'1',1756300575),(1029,'accesslib/dirtycontexts','/1/84/1096',1756271775,'1',1756300575),(1030,'accesslib/dirtycontexts','/1/84/1097',1756271775,'1',1756300575),(1031,'accesslib/dirtycontexts','/1/84/1098',1756271775,'1',1756300575),(1032,'accesslib/dirtycontexts','/1/84/1099',1756271775,'1',1756300575),(1033,'accesslib/dirtycontexts','/1/84/1100',1756271776,'1',1756300576),(1034,'accesslib/dirtycontexts','/1/84/1101',1756271776,'1',1756300576),(1035,'accesslib/dirtycontexts','/1/84/1102',1756271776,'1',1756300576),(1036,'accesslib/dirtycontexts','/1/84/1103',1756271776,'1',1756300576),(1037,'accesslib/dirtycontexts','/1/84/1104',1756271776,'1',1756300576),(1038,'accesslib/dirtycontexts','/1/84/1105',1756271777,'1',1756300577),(1039,'accesslib/dirtycontexts','/1/84/1106',1756271777,'1',1756300577),(1040,'accesslib/dirtycontexts','/1/84/1107',1756271777,'1',1756300577),(1041,'accesslib/dirtycontexts','/1/84/1108',1756271777,'1',1756300577),(1042,'accesslib/dirtycontexts','/1/84/1109',1756271777,'1',1756300577),(1043,'accesslib/dirtycontexts','/1/84/1110',1756271778,'1',1756300578),(1044,'accesslib/dirtycontexts','/1/84/1111',1756271778,'1',1756300578),(1045,'accesslib/dirtycontexts','/1/84/1112',1756271778,'1',1756300578),(1046,'accesslib/dirtycontexts','/1/84/1113',1756271778,'1',1756300578),(1047,'accesslib/dirtycontexts','/1/84/1114',1756271778,'1',1756300578),(1048,'accesslib/dirtycontexts','/1/84/1115',1756271779,'1',1756300579),(1049,'accesslib/dirtycontexts','/1/84/1116',1756271779,'1',1756300579),(1050,'accesslib/dirtycontexts','/1/84/1117',1756271779,'1',1756300579),(1051,'accesslib/dirtycontexts','/1/84/1118',1756271779,'1',1756300579),(1052,'accesslib/dirtycontexts','/1/84/1119',1756271779,'1',1756300579),(1053,'accesslib/dirtycontexts','/1/84/1120',1756271779,'1',1756300579),(1054,'accesslib/dirtycontexts','/1/84/1121',1756271780,'1',1756300580),(1055,'accesslib/dirtycontexts','/1/84/1122',1756271780,'1',1756300580),(1056,'accesslib/dirtycontexts','/1/84/1123',1756271780,'1',1756300580),(1057,'accesslib/dirtycontexts','/1/84/1124',1756271780,'1',1756300580),(1058,'accesslib/dirtycontexts','/1/84/1125',1756271780,'1',1756300580),(1059,'accesslib/dirtycontexts','/1/84/1126',1756271781,'1',1756300581),(1060,'accesslib/dirtycontexts','/1/84/1127',1756271781,'1',1756300581),(1061,'accesslib/dirtycontexts','/1/84/1128',1756271781,'1',1756300581),(1062,'accesslib/dirtycontexts','/1/84/1129',1756271781,'1',1756300581),(1063,'accesslib/dirtycontexts','/1/84/1130',1756271781,'1',1756300581),(1064,'accesslib/dirtycontexts','/1/84/1131',1756271782,'1',1756300582),(1065,'accesslib/dirtycontexts','/1/84/1132',1756271782,'1',1756300582),(1066,'accesslib/dirtycontexts','/1/84/1133',1756271782,'1',1756300582),(1067,'accesslib/dirtycontexts','/1/84/1134',1756271782,'1',1756300582),(1068,'accesslib/dirtycontexts','/1/84/1135',1756271782,'1',1756300582),(1069,'accesslib/dirtycontexts','/1/84/1136',1756271783,'1',1756300583),(1070,'accesslib/dirtycontexts','/1/84/1137',1756271783,'1',1756300583),(1071,'accesslib/dirtycontexts','/1/84/1138',1756271783,'1',1756300583),(1072,'accesslib/dirtycontexts','/1/84/1139',1756271783,'1',1756300583),(1073,'accesslib/dirtycontexts','/1/84/1140',1756271783,'1',1756300583),(1074,'accesslib/dirtycontexts','/1/84/1141',1756271783,'1',1756300583),(1075,'accesslib/dirtycontexts','/1/84/1142',1756271784,'1',1756300584),(1076,'accesslib/dirtycontexts','/1/84/1143',1756271784,'1',1756300584),(1077,'accesslib/dirtycontexts','/1/84/1144',1756271784,'1',1756300584),(1078,'accesslib/dirtycontexts','/1/84/1145',1756271784,'1',1756300584),(1079,'accesslib/dirtycontexts','/1/84/1146',1756271784,'1',1756300584),(1080,'accesslib/dirtycontexts','/1/84/1147',1756271785,'1',1756300585),(1081,'accesslib/dirtycontexts','/1/84/1148',1756271785,'1',1756300585),(1082,'accesslib/dirtycontexts','/1/84/1149',1756271785,'1',1756300585),(1083,'accesslib/dirtycontexts','/1/84/1150',1756271785,'1',1756300585),(1084,'accesslib/dirtycontexts','/1/84/1151',1756271785,'1',1756300585),(1085,'accesslib/dirtycontexts','/1/84/1152',1756271786,'1',1756300586),(1086,'accesslib/dirtycontexts','/1/84/1153',1756271787,'1',1756300587),(1087,'accesslib/dirtycontexts','/1/84/1154',1756271788,'1',1756300588),(1088,'accesslib/dirtycontexts','/1/84/1155',1756271789,'1',1756300589),(1089,'accesslib/dirtycontexts','/1/84/1156',1756271790,'1',1756300590),(1090,'accesslib/dirtycontexts','/1/84/1157',1756271790,'1',1756300590),(1091,'accesslib/dirtycontexts','/1/84/1158',1756271791,'1',1756300591),(1092,'accesslib/dirtycontexts','/1/84/1159',1756271792,'1',1756300592),(1093,'accesslib/dirtycontexts','/1/84/1160',1756271793,'1',1756300593),(1094,'accesslib/dirtycontexts','/1/84/1161',1756271794,'1',1756300594),(1095,'accesslib/dirtycontexts','/1/84/1162',1756271794,'1',1756300594),(1096,'accesslib/dirtycontexts','/1/84/1163',1756271795,'1',1756300595),(1097,'accesslib/dirtycontexts','/1/84/1164',1756271796,'1',1756300596),(1098,'accesslib/dirtycontexts','/1/84/1165',1756271796,'1',1756300596),(1099,'accesslib/dirtycontexts','/1/84/1166',1756271796,'1',1756300596),(1100,'accesslib/dirtycontexts','/1/84/1167',1756271796,'1',1756300596),(1101,'accesslib/dirtycontexts','/1/84/1168',1756271797,'1',1756300597),(1102,'accesslib/dirtycontexts','/1/84/1169',1756271797,'1',1756300597),(1103,'accesslib/dirtycontexts','/1/84/1170',1756271797,'1',1756300597),(1104,'accesslib/dirtycontexts','/1/84/1171',1756271797,'1',1756300597),(1105,'accesslib/dirtycontexts','/1/84/1172',1756271797,'1',1756300597),(1106,'accesslib/dirtycontexts','/1/84/1173',1756271798,'1',1756300598),(1107,'accesslib/dirtycontexts','/1/84/1174',1756271798,'1',1756300598),(1108,'accesslib/dirtycontexts','/1/84/1175',1756271798,'1',1756300598),(1109,'accesslib/dirtycontexts','/1/84/1176',1756271798,'1',1756300598),(1110,'accesslib/dirtycontexts','/1/84/1177',1756271798,'1',1756300598),(1111,'accesslib/dirtycontexts','/1/84/1178',1756271799,'1',1756300599),(1112,'accesslib/dirtycontexts','/1/84/1179',1756271799,'1',1756300599),(1113,'accesslib/dirtycontexts','/1/84/1180',1756271799,'1',1756300599),(1114,'accesslib/dirtycontexts','/1/84/1181',1756271799,'1',1756300599),(1115,'accesslib/dirtycontexts','/1/84/1182',1756271799,'1',1756300599),(1116,'accesslib/dirtycontexts','/1/84/1183',1756271800,'1',1756300600),(1117,'accesslib/dirtycontexts','/1/84/1184',1756271800,'1',1756300600),(1118,'accesslib/dirtycontexts','/1/84/1185',1756271800,'1',1756300600),(1119,'accesslib/dirtycontexts','/1/84/1186',1756271800,'1',1756300600),(1120,'accesslib/dirtycontexts','/1/84/1187',1756271801,'1',1756300601),(1121,'accesslib/dirtycontexts','/1/84/1188',1756271801,'1',1756300601),(1122,'accesslib/dirtycontexts','/1/84/1189',1756271801,'1',1756300601),(1123,'accesslib/dirtycontexts','/1/84/1190',1756271801,'1',1756300601),(1124,'accesslib/dirtycontexts','/1/84/1191',1756271801,'1',1756300601),(1125,'accesslib/dirtycontexts','/1/84/1192',1756271802,'1',1756300602),(1126,'accesslib/dirtycontexts','/1/84/1193',1756271802,'1',1756300602),(1127,'accesslib/dirtycontexts','/1/84/1194',1756271802,'1',1756300602),(1128,'accesslib/dirtycontexts','/1/84/1195',1756271802,'1',1756300602),(1129,'accesslib/dirtycontexts','/1/84/1196',1756271802,'1',1756300602),(1130,'accesslib/dirtycontexts','/1/84/1197',1756271803,'1',1756300603),(1131,'accesslib/dirtycontexts','/1/84/1198',1756271803,'1',1756300603),(1132,'accesslib/dirtycontexts','/1/84/1199',1756271803,'1',1756300603),(1133,'accesslib/dirtycontexts','/1/84/1200',1756271803,'1',1756300603),(1134,'accesslib/dirtycontexts','/1/84/1201',1756271803,'1',1756300603),(1135,'accesslib/dirtycontexts','/1/84/1202',1756271804,'1',1756300604),(1136,'accesslib/dirtycontexts','/1/84/1203',1756271804,'1',1756300604),(1137,'accesslib/dirtycontexts','/1/84/1204',1756271804,'1',1756300604),(1138,'accesslib/dirtycontexts','/1/84/1205',1756271804,'1',1756300604),(1139,'accesslib/dirtycontexts','/1/84/1206',1756271804,'1',1756300604),(1140,'accesslib/dirtycontexts','/1/84/1207',1756271804,'1',1756300604),(1141,'accesslib/dirtycontexts','/1/84/1208',1756271805,'1',1756300605),(1142,'accesslib/dirtycontexts','/1/84/1209',1756271805,'1',1756300605),(1143,'accesslib/dirtycontexts','/1/84/1210',1756271805,'1',1756300605),(1144,'accesslib/dirtycontexts','/1/84/1211',1756271805,'1',1756300605),(1145,'accesslib/dirtycontexts','/1/84/1212',1756271805,'1',1756300605),(1146,'accesslib/dirtycontexts','/1/84/1213',1756271806,'1',1756300606),(1147,'accesslib/dirtycontexts','/1/84/1214',1756271806,'1',1756300606),(1148,'accesslib/dirtycontexts','/1/84/1215',1756271806,'1',1756300606),(1149,'accesslib/dirtycontexts','/1/84/1216',1756271806,'1',1756300606),(1150,'accesslib/dirtycontexts','/1/84/1217',1756271807,'1',1756300607),(1151,'accesslib/dirtycontexts','/1/84/1218',1756271807,'1',1756300607),(1152,'accesslib/dirtycontexts','/1/84/1219',1756271807,'1',1756300607),(1153,'accesslib/dirtycontexts','/1/84/1220',1756271807,'1',1756300607),(1154,'accesslib/dirtycontexts','/1/84/1221',1756271808,'1',1756300608),(1155,'accesslib/dirtycontexts','/1/84/1222',1756271808,'1',1756300608),(1156,'accesslib/dirtycontexts','/1/84/1223',1756271808,'1',1756300608),(1157,'accesslib/dirtycontexts','/1/84/1224',1756271808,'1',1756300608),(1158,'accesslib/dirtycontexts','/1/84/1225',1756271809,'1',1756300609),(1159,'accesslib/dirtycontexts','/1/84/1226',1756271809,'1',1756300609),(1160,'accesslib/dirtycontexts','/1/84/1227',1756271809,'1',1756300609),(1161,'accesslib/dirtycontexts','/1/84/1228',1756271809,'1',1756300609),(1162,'accesslib/dirtycontexts','/1/84/1229',1756271809,'1',1756300609),(1163,'accesslib/dirtycontexts','/1/84/1230',1756271810,'1',1756300610),(1164,'accesslib/dirtycontexts','/1/84/1231',1756271810,'1',1756300610),(1165,'accesslib/dirtycontexts','/1/84/1232',1756271810,'1',1756300610),(1166,'accesslib/dirtycontexts','/1/84/1233',1756271810,'1',1756300610),(1167,'accesslib/dirtycontexts','/1/84/1234',1756271810,'1',1756300610),(1168,'accesslib/dirtycontexts','/1/84/1235',1756271811,'1',1756300611),(1169,'accesslib/dirtycontexts','/1/84/1236',1756271811,'1',1756300611),(1170,'accesslib/dirtycontexts','/1/84/1237',1756271811,'1',1756300611),(1171,'accesslib/dirtycontexts','/1/84/1238',1756271811,'1',1756300611),(1172,'accesslib/dirtycontexts','/1/84/1239',1756271811,'1',1756300611),(1173,'accesslib/dirtycontexts','/1/84/1240',1756271811,'1',1756300611),(1174,'accesslib/dirtycontexts','/1/84/1241',1756271812,'1',1756300612),(1175,'accesslib/dirtycontexts','/1/84/1242',1756271812,'1',1756300612),(1176,'accesslib/dirtycontexts','/1/84/1243',1756271812,'1',1756300612),(1177,'accesslib/dirtycontexts','/1/84/1244',1756271812,'1',1756300612),(1178,'accesslib/dirtycontexts','/1/84/1245',1756271812,'1',1756300612),(1179,'accesslib/dirtycontexts','/1/84/1246',1756271813,'1',1756300613),(1180,'accesslib/dirtycontexts','/1/84/1247',1756271813,'1',1756300613),(1181,'accesslib/dirtycontexts','/1/84/1248',1756271813,'1',1756300613),(1182,'accesslib/dirtycontexts','/1/84/1249',1756271813,'1',1756300613),(1183,'accesslib/dirtycontexts','/1/84/1250',1756271813,'1',1756300613),(1184,'accesslib/dirtycontexts','/1/84/1251',1756271814,'1',1756300614),(1185,'accesslib/dirtycontexts','/1/84/1252',1756271814,'1',1756300614),(1186,'accesslib/dirtycontexts','/1/84/1253',1756271814,'1',1756300614),(1187,'accesslib/dirtycontexts','/1/84/1254',1756271814,'1',1756300614),(1188,'accesslib/dirtycontexts','/1/84/1255',1756271814,'1',1756300614),(1189,'accesslib/dirtycontexts','/1/84/1256',1756271814,'1',1756300614),(1190,'accesslib/dirtycontexts','/1/84/1257',1756271815,'1',1756300615),(1191,'accesslib/dirtycontexts','/1/84/1258',1756271815,'1',1756300615),(1192,'accesslib/dirtycontexts','/1/84/1259',1756271815,'1',1756300615),(1193,'accesslib/dirtycontexts','/1/84/1260',1756271815,'1',1756300615),(1194,'accesslib/dirtycontexts','/1/84/1261',1756271815,'1',1756300615),(1195,'accesslib/dirtycontexts','/1/84/1262',1756271816,'1',1756300616),(1196,'accesslib/dirtycontexts','/1/84/1263',1756271816,'1',1756300616),(1197,'accesslib/dirtycontexts','/1/84/1264',1756271816,'1',1756300616),(1198,'accesslib/dirtycontexts','/1/84/1265',1756271816,'1',1756300616),(1199,'accesslib/dirtycontexts','/1/84/1266',1756271816,'1',1756300616),(1200,'accesslib/dirtycontexts','/1/84/1267',1756271817,'1',1756300617),(1201,'accesslib/dirtycontexts','/1/84/1268',1756271817,'1',1756300617),(1202,'accesslib/dirtycontexts','/1/84/1269',1756271818,'1',1756300618),(1203,'accesslib/dirtycontexts','/1/84/1270',1756271818,'1',1756300618),(1204,'accesslib/dirtycontexts','/1/84/1271',1756271818,'1',1756300618),(1205,'accesslib/dirtycontexts','/1/84/1272',1756271819,'1',1756300619),(1206,'accesslib/dirtycontexts','/1/84/1273',1756271819,'1',1756300619),(1207,'accesslib/dirtycontexts','/1/84/1274',1756271819,'1',1756300619),(1208,'accesslib/dirtycontexts','/1/84/1275',1756271820,'1',1756300620),(1209,'accesslib/dirtycontexts','/1/84/1276',1756271820,'1',1756300620),(1210,'accesslib/dirtycontexts','/1/84/1277',1756271820,'1',1756300620),(1211,'accesslib/dirtycontexts','/1/84/1278',1756271821,'1',1756300621),(1212,'accesslib/dirtycontexts','/1/84/1279',1756271821,'1',1756300621),(1213,'accesslib/dirtycontexts','/1/84/1280',1756271821,'1',1756300621),(1214,'accesslib/dirtycontexts','/1/84/1281',1756271822,'1',1756300622),(1215,'accesslib/dirtycontexts','/1/84/1282',1756271822,'1',1756300622),(1216,'accesslib/dirtycontexts','/1/84/1283',1756271822,'1',1756300622),(1217,'accesslib/dirtycontexts','/1/84/1284',1756271823,'1',1756300623),(1218,'accesslib/dirtycontexts','/1/84/1285',1756271823,'1',1756300623),(1219,'accesslib/dirtycontexts','/1/84/1286',1756271823,'1',1756300623),(1220,'accesslib/dirtycontexts','/1/84/1287',1756271823,'1',1756300623),(1221,'accesslib/dirtycontexts','/1/84/1288',1756271823,'1',1756300623),(1222,'accesslib/dirtycontexts','/1/84/1289',1756271823,'1',1756300623),(1223,'accesslib/dirtycontexts','/1/84/1290',1756271824,'1',1756300624),(1224,'accesslib/dirtycontexts','/1/84/1291',1756271824,'1',1756300624),(1225,'accesslib/dirtycontexts','/1/84/1292',1756271824,'1',1756300624),(1226,'accesslib/dirtycontexts','/1/84/1293',1756271824,'1',1756300624),(1227,'accesslib/dirtycontexts','/1/84/1294',1756271824,'1',1756300624),(1228,'accesslib/dirtycontexts','/1/84/1295',1756271825,'1',1756300625),(1229,'accesslib/dirtycontexts','/1/84/1296',1756271825,'1',1756300625),(1230,'accesslib/dirtycontexts','/1/84/1297',1756271825,'1',1756300625),(1231,'accesslib/dirtycontexts','/1/84/1298',1756271825,'1',1756300625),(1232,'accesslib/dirtycontexts','/1/84/1299',1756271825,'1',1756300625),(1233,'accesslib/dirtycontexts','/1/84/1300',1756271826,'1',1756300626),(1234,'accesslib/dirtycontexts','/1/84/1301',1756271826,'1',1756300626),(1235,'accesslib/dirtycontexts','/1/84/1302',1756271826,'1',1756300626),(1236,'accesslib/dirtycontexts','/1/84/1303',1756271826,'1',1756300626),(1237,'accesslib/dirtycontexts','/1/84/1304',1756271826,'1',1756300626),(1238,'accesslib/dirtycontexts','/1/84/1305',1756271827,'1',1756300627),(1239,'accesslib/dirtycontexts','/1/84/1306',1756271827,'1',1756300627),(1240,'accesslib/dirtycontexts','/1/84/1307',1756271827,'1',1756300627),(1241,'accesslib/dirtycontexts','/1/84/1308',1756271827,'1',1756300627),(1242,'accesslib/dirtycontexts','/1/84/1309',1756271827,'1',1756300627),(1243,'accesslib/dirtycontexts','/1/84/1310',1756271828,'1',1756300628),(1244,'accesslib/dirtycontexts','/1/84/1311',1756271828,'1',1756300628),(1245,'accesslib/dirtycontexts','/1/84/1312',1756271828,'1',1756300628),(1246,'accesslib/dirtycontexts','/1/84/1313',1756271828,'1',1756300628),(1247,'accesslib/dirtycontexts','/1/84/1314',1756271828,'1',1756300628),(1248,'accesslib/dirtycontexts','/1/84/1315',1756271829,'1',1756300629),(1249,'accesslib/dirtycontexts','/1/84/1316',1756271829,'1',1756300629),(1250,'accesslib/dirtycontexts','/1/84/1317',1756271829,'1',1756300629),(1251,'accesslib/dirtycontexts','/1/84/1318',1756271829,'1',1756300629),(1252,'accesslib/dirtycontexts','/1/84/1319',1756271830,'1',1756300630),(1253,'accesslib/dirtycontexts','/1/84/1320',1756271830,'1',1756300630),(1254,'accesslib/dirtycontexts','/1/84/1321',1756271831,'1',1756300631),(1255,'accesslib/dirtycontexts','/1/84/1322',1756271831,'1',1756300631),(1256,'accesslib/dirtycontexts','/1/84/1323',1756271832,'1',1756300632),(1257,'accesslib/dirtycontexts','/1/84/1324',1756271832,'1',1756300632),(1258,'accesslib/dirtycontexts','/1/84/1325',1756271833,'1',1756300633),(1259,'accesslib/dirtycontexts','/1/84/1326',1756271834,'1',1756300634),(1260,'accesslib/dirtycontexts','/1/84/1327',1756271834,'1',1756300634),(1261,'accesslib/dirtycontexts','/1/84/1328',1756271834,'1',1756300634),(1262,'accesslib/dirtycontexts','/1/84/1329',1756271835,'1',1756300635),(1263,'accesslib/dirtycontexts','/1/84/1330',1756271835,'1',1756300635),(1264,'accesslib/dirtycontexts','/1/84/1331',1756271835,'1',1756300635),(1265,'accesslib/dirtycontexts','/1/84/1332',1756271836,'1',1756300636),(1266,'accesslib/dirtycontexts','/1/84/1333',1756271836,'1',1756300636),(1267,'accesslib/dirtycontexts','/1/84/1334',1756271836,'1',1756300636),(1268,'accesslib/dirtycontexts','/1/84/1335',1756271836,'1',1756300636),(1269,'accesslib/dirtycontexts','/1/84/1336',1756271837,'1',1756300637),(1270,'accesslib/dirtycontexts','/1/84/1337',1756271837,'1',1756300637),(1271,'accesslib/dirtycontexts','/1/84/1338',1756271837,'1',1756300637),(1272,'accesslib/dirtycontexts','/1/84/1339',1756271837,'1',1756300637),(1273,'accesslib/dirtycontexts','/1/84/1340',1756271837,'1',1756300637),(1274,'accesslib/dirtycontexts','/1/84/1341',1756271838,'1',1756300638),(1275,'accesslib/dirtycontexts','/1/84/1342',1756271838,'1',1756300638),(1276,'accesslib/dirtycontexts','/1/84/1343',1756271838,'1',1756300638),(1277,'accesslib/dirtycontexts','/1/84/1344',1756271838,'1',1756300638),(1278,'accesslib/dirtycontexts','/1/84/1345',1756271838,'1',1756300638),(1279,'accesslib/dirtycontexts','/1/84/1346',1756271839,'1',1756300639),(1280,'accesslib/dirtycontexts','/1/84/1347',1756271839,'1',1756300639),(1281,'accesslib/dirtycontexts','/1/84/1348',1756271839,'1',1756300639),(1282,'accesslib/dirtycontexts','/1/84/1349',1756271839,'1',1756300639),(1283,'accesslib/dirtycontexts','/1/84/1350',1756271839,'1',1756300639),(1284,'accesslib/dirtycontexts','/1/84/1351',1756271840,'1',1756300640),(1285,'accesslib/dirtycontexts','/1/84/1352',1756271840,'1',1756300640),(1286,'accesslib/dirtycontexts','/1/84/1353',1756271840,'1',1756300640),(1287,'accesslib/dirtycontexts','/1/84/1354',1756271840,'1',1756300640),(1288,'accesslib/dirtycontexts','/1/84/1355',1756271841,'1',1756300641),(1289,'accesslib/dirtycontexts','/1/84/1356',1756271841,'1',1756300641),(1290,'accesslib/dirtycontexts','/1/84/1357',1756271841,'1',1756300641),(1291,'accesslib/dirtycontexts','/1/84/1358',1756271841,'1',1756300641),(1292,'accesslib/dirtycontexts','/1/84/1359',1756271841,'1',1756300641),(1293,'accesslib/dirtycontexts','/1/84/1360',1756271842,'1',1756300642),(1294,'accesslib/dirtycontexts','/1/84/1361',1756271842,'1',1756300642),(1295,'accesslib/dirtycontexts','/1/84/1362',1756271842,'1',1756300642),(1296,'accesslib/dirtycontexts','/1/84/1363',1756271842,'1',1756300642),(1297,'accesslib/dirtycontexts','/1/84/1364',1756271842,'1',1756300642),(1298,'accesslib/dirtycontexts','/1/84/1365',1756271843,'1',1756300643),(1299,'accesslib/dirtycontexts','/1/84/1366',1756271843,'1',1756300643),(1300,'accesslib/dirtycontexts','/1/84/1367',1756271843,'1',1756300643),(1301,'accesslib/dirtycontexts','/1/84/1368',1756271843,'1',1756300643),(1302,'accesslib/dirtycontexts','/1/84/1369',1756271843,'1',1756300643),(1303,'accesslib/dirtycontexts','/1/84/1370',1756271844,'1',1756300644),(1304,'accesslib/dirtycontexts','/1/84/1371',1756271844,'1',1756300644),(1305,'accesslib/dirtycontexts','/1/84/1372',1756271844,'1',1756300644),(1306,'accesslib/dirtycontexts','/1/84/1373',1756271844,'1',1756300644),(1307,'accesslib/dirtycontexts','/1/84/1374',1756271845,'1',1756300645),(1308,'accesslib/dirtycontexts','/1/84/1375',1756271845,'1',1756300645),(1309,'accesslib/dirtycontexts','/1/84/1376',1756271845,'1',1756300645),(1310,'accesslib/dirtycontexts','/1/84/1377',1756271845,'1',1756300645),(1311,'accesslib/dirtycontexts','/1/84/1378',1756271846,'1',1756300646),(1312,'accesslib/dirtycontexts','/1/84/1379',1756271846,'1',1756300646),(1313,'accesslib/dirtycontexts','/1/84/1380',1756271846,'1',1756300646),(1314,'accesslib/dirtycontexts','/1/84/1381',1756271846,'1',1756300646),(1315,'accesslib/dirtycontexts','/1/84/1382',1756271847,'1',1756300647),(1316,'accesslib/dirtycontexts','/1/84/1383',1756271847,'1',1756300647),(1317,'accesslib/dirtycontexts','/1/84/1384',1756271847,'1',1756300647),(1318,'accesslib/dirtycontexts','/1/84/1385',1756271847,'1',1756300647),(1319,'accesslib/dirtycontexts','/1/84/1386',1756271847,'1',1756300647),(1320,'accesslib/dirtycontexts','/1/84/1387',1756271848,'1',1756300648),(1321,'accesslib/dirtycontexts','/1/84/1388',1756271848,'1',1756300648),(1322,'accesslib/dirtycontexts','/1/84/1389',1756271848,'1',1756300648),(1323,'accesslib/dirtycontexts','/1/84/1390',1756271848,'1',1756300648),(1324,'accesslib/dirtycontexts','/1/84/1391',1756271848,'1',1756300648),(1325,'accesslib/dirtycontexts','/1/84/1392',1756271849,'1',1756300649),(1326,'accesslib/dirtycontexts','/1/84/1393',1756271849,'1',1756300649),(1327,'accesslib/dirtycontexts','/1/84/1394',1756271849,'1',1756300649),(1328,'accesslib/dirtycontexts','/1/84/1395',1756271849,'1',1756300649),(1329,'accesslib/dirtycontexts','/1/84/1396',1756271849,'1',1756300649),(1330,'accesslib/dirtycontexts','/1/84/1397',1756271850,'1',1756300650),(1331,'accesslib/dirtycontexts','/1/84/1398',1756271850,'1',1756300650),(1332,'accesslib/dirtycontexts','/1/84/1399',1756271850,'1',1756300650),(1333,'accesslib/dirtycontexts','/1/84/1400',1756271850,'1',1756300650),(1334,'accesslib/dirtycontexts','/1/84/1401',1756271850,'1',1756300650),(1335,'accesslib/dirtycontexts','/1/84/1402',1756271851,'1',1756300651),(1336,'accesslib/dirtycontexts','/1/84/1403',1756271851,'1',1756300651),(1337,'accesslib/dirtycontexts','/1/84/1404',1756271851,'1',1756300651),(1338,'accesslib/dirtycontexts','/1/84/1405',1756271851,'1',1756300651),(1339,'accesslib/dirtycontexts','/1/84/1406',1756271851,'1',1756300651),(1340,'accesslib/dirtycontexts','/1/84/1407',1756271852,'1',1756300652),(1341,'accesslib/dirtycontexts','/1/84/1408',1756271852,'1',1756300652),(1342,'accesslib/dirtycontexts','/1/84/1409',1756271852,'1',1756300652),(1343,'accesslib/dirtycontexts','/1/84/1410',1756271852,'1',1756300652),(1344,'accesslib/dirtycontexts','/1/84/1411',1756271852,'1',1756300652),(1345,'accesslib/dirtycontexts','/1/84/1412',1756271853,'1',1756300653),(1346,'accesslib/dirtycontexts','/1/84/1413',1756271853,'1',1756300653),(1347,'accesslib/dirtycontexts','/1/84/1414',1756271853,'1',1756300653),(1348,'accesslib/dirtycontexts','/1/84/1415',1756271853,'1',1756300653),(1349,'accesslib/dirtycontexts','/1/84/1416',1756271853,'1',1756300653),(1350,'accesslib/dirtycontexts','/1/84/1417',1756271854,'1',1756300654),(1351,'accesslib/dirtycontexts','/1/84/1418',1756271854,'1',1756300654),(1352,'accesslib/dirtycontexts','/1/84/1419',1756271854,'1',1756300654),(1353,'accesslib/dirtycontexts','/1/84/1420',1756271854,'1',1756300654),(1354,'accesslib/dirtycontexts','/1/84/1421',1756271854,'1',1756300654),(1355,'accesslib/dirtycontexts','/1/84/1422',1756271855,'1',1756300655),(1356,'accesslib/dirtycontexts','/1/84/1423',1756271855,'1',1756300655),(1357,'accesslib/dirtycontexts','/1/84/1424',1756271855,'1',1756300655),(1358,'accesslib/dirtycontexts','/1/84/1425',1756271855,'1',1756300655),(1359,'accesslib/dirtycontexts','/1/84/1426',1756271855,'1',1756300655),(1360,'accesslib/dirtycontexts','/1/84/1427',1756271856,'1',1756300656),(1361,'accesslib/dirtycontexts','/1/84/1428',1756271856,'1',1756300656),(1362,'accesslib/dirtycontexts','/1/84/1429',1756271856,'1',1756300656),(1363,'accesslib/dirtycontexts','/1/84/1430',1756271856,'1',1756300656),(1364,'accesslib/dirtycontexts','/1/84/1431',1756271856,'1',1756300656),(1365,'accesslib/dirtycontexts','/1/84/1432',1756271857,'1',1756300657),(1366,'accesslib/dirtycontexts','/1/84/1433',1756271857,'1',1756300657),(1367,'accesslib/dirtycontexts','/1/84/1434',1756271857,'1',1756300657),(1368,'accesslib/dirtycontexts','/1/84/1435',1756271857,'1',1756300657),(1369,'accesslib/dirtycontexts','/1/84/1436',1756271857,'1',1756300657),(1370,'accesslib/dirtycontexts','/1/84/1437',1756271858,'1',1756300658),(1371,'accesslib/dirtycontexts','/1/84/1438',1756271858,'1',1756300658),(1372,'accesslib/dirtycontexts','/1/84/1439',1756271858,'1',1756300658),(1373,'accesslib/dirtycontexts','/1/84/1440',1756271858,'1',1756300658),(1374,'accesslib/dirtycontexts','/1/84/1441',1756271858,'1',1756300658),(1375,'accesslib/dirtycontexts','/1/84/1442',1756271859,'1',1756300659),(1376,'accesslib/dirtycontexts','/1/84/1443',1756271859,'1',1756300659),(1377,'accesslib/dirtycontexts','/1/84/1444',1756271859,'1',1756300659),(1378,'accesslib/dirtycontexts','/1/84/1445',1756271859,'1',1756300659),(1379,'accesslib/dirtycontexts','/1/84/1446',1756271859,'1',1756300659),(1380,'accesslib/dirtycontexts','/1/84/1447',1756271860,'1',1756300660),(1381,'accesslib/dirtycontexts','/1/84/1448',1756271860,'1',1756300660),(1382,'accesslib/dirtycontexts','/1/84/1449',1756271860,'1',1756300660),(1383,'accesslib/dirtycontexts','/1/84/1450',1756271860,'1',1756300660),(1384,'accesslib/dirtycontexts','/1/84/1451',1756271860,'1',1756300660),(1385,'accesslib/dirtycontexts','/1/84/1452',1756271861,'1',1756300661),(1386,'accesslib/dirtycontexts','/1/84/1453',1756271861,'1',1756300661),(1387,'accesslib/dirtycontexts','/1/84/1454',1756271861,'1',1756300661),(1388,'accesslib/dirtycontexts','/1/84/1455',1756271861,'1',1756300661),(1389,'accesslib/dirtycontexts','/1/84/1456',1756271861,'1',1756300661),(1390,'accesslib/dirtycontexts','/1/84/1457',1756271862,'1',1756300662),(1391,'accesslib/dirtycontexts','/1/84/1458',1756271862,'1',1756300662),(1392,'accesslib/dirtycontexts','/1/84/1459',1756271862,'1',1756300662),(1393,'accesslib/dirtycontexts','/1/84/1460',1756271862,'1',1756300662),(1394,'accesslib/dirtycontexts','/1/84/1461',1756271862,'1',1756300662),(1395,'accesslib/dirtycontexts','/1/84/1462',1756271863,'1',1756300663),(1396,'accesslib/dirtycontexts','/1/84/1463',1756271863,'1',1756300663),(1397,'accesslib/dirtycontexts','/1/84/1464',1756271863,'1',1756300663),(1398,'accesslib/dirtycontexts','/1/84/1465',1756271863,'1',1756300663),(1399,'accesslib/dirtycontexts','/1/84/1466',1756271864,'1',1756300664),(1400,'accesslib/dirtycontexts','/1/84/1467',1756271864,'1',1756300664),(1401,'accesslib/dirtycontexts','/1/84/1468',1756271864,'1',1756300664),(1402,'accesslib/dirtycontexts','/1/84/1469',1756271864,'1',1756300664),(1403,'accesslib/dirtycontexts','/1/84/1470',1756271864,'1',1756300664),(1404,'accesslib/dirtycontexts','/1/84/1471',1756271865,'1',1756300665),(1405,'accesslib/dirtycontexts','/1/84/1472',1756271865,'1',1756300665),(1406,'accesslib/dirtycontexts','/1/84/1473',1756271865,'1',1756300665),(1407,'accesslib/dirtycontexts','/1/84/1474',1756271865,'1',1756300665),(1408,'accesslib/dirtycontexts','/1/84/1475',1756271865,'1',1756300665),(1409,'accesslib/dirtycontexts','/1/84/1476',1756271866,'1',1756300666),(1410,'accesslib/dirtycontexts','/1/84/1477',1756271866,'1',1756300666),(1411,'accesslib/dirtycontexts','/1/84/1478',1756271866,'1',1756300666),(1412,'accesslib/dirtycontexts','/1/84/1479',1756271866,'1',1756300666),(1413,'accesslib/dirtycontexts','/1/84/1480',1756271866,'1',1756300666),(1414,'accesslib/dirtycontexts','/1/84/1481',1756271867,'1',1756300667),(1415,'accesslib/dirtycontexts','/1/84/1482',1756271867,'1',1756300667),(1416,'accesslib/dirtycontexts','/1/84/1483',1756271867,'1',1756300667),(1417,'accesslib/dirtycontexts','/1/84/1484',1756271867,'1',1756300667),(1418,'accesslib/dirtycontexts','/1/84/1485',1756271867,'1',1756300667),(1419,'accesslib/dirtycontexts','/1/84/1486',1756271868,'1',1756300668),(1420,'accesslib/dirtycontexts','/1/84/1487',1756271868,'1',1756300668),(1421,'accesslib/dirtycontexts','/1/84/1488',1756271868,'1',1756300668),(1422,'accesslib/dirtycontexts','/1/84/1489',1756271868,'1',1756300668),(1423,'accesslib/dirtycontexts','/1/84/1490',1756271868,'1',1756300668),(1424,'accesslib/dirtycontexts','/1/84/1491',1756271869,'1',1756300669),(1425,'accesslib/dirtycontexts','/1/84/1492',1756271869,'1',1756300669),(1426,'accesslib/dirtycontexts','/1/84/1493',1756271869,'1',1756300669),(1427,'accesslib/dirtycontexts','/1/84/1494',1756271869,'1',1756300669),(1428,'accesslib/dirtycontexts','/1/84/1495',1756271869,'1',1756300669),(1429,'accesslib/dirtycontexts','/1/84/1496',1756271869,'1',1756300669),(1430,'accesslib/dirtycontexts','/1/84/1497',1756271870,'1',1756300670),(1431,'accesslib/dirtycontexts','/1/84/1498',1756271870,'1',1756300670),(1432,'accesslib/dirtycontexts','/1/84/1499',1756271870,'1',1756300670),(1433,'accesslib/dirtycontexts','/1/84/1500',1756271870,'1',1756300670),(1434,'accesslib/dirtycontexts','/1/84/1501',1756271871,'1',1756300671),(1435,'accesslib/dirtycontexts','/1/84/1502',1756271871,'1',1756300671),(1436,'accesslib/dirtycontexts','/1/84/1503',1756271871,'1',1756300671),(1437,'accesslib/dirtycontexts','/1/84/1504',1756271871,'1',1756300671),(1438,'accesslib/dirtycontexts','/1/84/1505',1756271871,'1',1756300671),(1439,'accesslib/dirtycontexts','/1/84/1506',1756271872,'1',1756300672),(1440,'accesslib/dirtycontexts','/1/84/1507',1756271872,'1',1756300672),(1441,'accesslib/dirtycontexts','/1/84/1508',1756271872,'1',1756300672),(1442,'accesslib/dirtycontexts','/1/84/1509',1756271873,'1',1756300673),(1443,'accesslib/dirtycontexts','/1/84/1510',1756271873,'1',1756300673),(1444,'accesslib/dirtycontexts','/1/84/1511',1756271873,'1',1756300673),(1445,'accesslib/dirtycontexts','/1/84/1512',1756271873,'1',1756300673),(1446,'accesslib/dirtycontexts','/1/84/1513',1756271873,'1',1756300673),(1447,'accesslib/dirtycontexts','/1/84/1514',1756271873,'1',1756300673),(1448,'accesslib/dirtycontexts','/1/84/1515',1756271874,'1',1756300674),(1449,'accesslib/dirtycontexts','/1/84/1516',1756271874,'1',1756300674),(1450,'accesslib/dirtycontexts','/1/84/1517',1756271874,'1',1756300674),(1451,'accesslib/dirtycontexts','/1/84/1518',1756271874,'1',1756300674),(1452,'accesslib/dirtycontexts','/1/84/1519',1756271874,'1',1756300674),(1453,'accesslib/dirtycontexts','/1/84/1520',1756271875,'1',1756300675),(1454,'accesslib/dirtycontexts','/1/84/1521',1756271875,'1',1756300675),(1455,'accesslib/dirtycontexts','/1/84/1522',1756271875,'1',1756300675),(1456,'accesslib/dirtycontexts','/1/84/1523',1756271875,'1',1756300675),(1457,'accesslib/dirtycontexts','/1/84/1524',1756271875,'1',1756300675),(1458,'accesslib/dirtycontexts','/1/84/1525',1756271876,'1',1756300676),(1459,'accesslib/dirtycontexts','/1/84/1526',1756271876,'1',1756300676),(1460,'accesslib/dirtycontexts','/1/84/1527',1756271876,'1',1756300676),(1461,'accesslib/dirtycontexts','/1/84/1528',1756271876,'1',1756300676),(1462,'accesslib/dirtycontexts','/1/84/1529',1756271876,'1',1756300676),(1463,'accesslib/dirtycontexts','/1/84/1530',1756271877,'1',1756300677),(1464,'accesslib/dirtycontexts','/1/84/1531',1756271877,'1',1756300677),(1465,'accesslib/dirtycontexts','/1/84/1532',1756271877,'1',1756300677),(1466,'accesslib/dirtycontexts','/1/84/1533',1756271877,'1',1756300677),(1467,'accesslib/dirtycontexts','/1/84/1534',1756271877,'1',1756300677),(1468,'accesslib/dirtycontexts','/1/84/1535',1756271878,'1',1756300678),(1469,'accesslib/dirtycontexts','/1/84/1536',1756271878,'1',1756300678),(1470,'accesslib/dirtycontexts','/1/84/1537',1756271878,'1',1756300678),(1471,'accesslib/dirtycontexts','/1/84/1538',1756271878,'1',1756300678),(1472,'accesslib/dirtycontexts','/1/84/1539',1756271878,'1',1756300678),(1473,'accesslib/dirtycontexts','/1/84/1540',1756271879,'1',1756300679),(1474,'accesslib/dirtycontexts','/1/84/1541',1756271879,'1',1756300679),(1475,'accesslib/dirtycontexts','/1/84/1542',1756271879,'1',1756300679),(1476,'accesslib/dirtycontexts','/1/84/1543',1756271879,'1',1756300679),(1477,'accesslib/dirtycontexts','/1/84/1544',1756271880,'1',1756300680),(1478,'accesslib/dirtycontexts','/1/84/1545',1756271880,'1',1756300680),(1479,'accesslib/dirtycontexts','/1/84/1546',1756271880,'1',1756300680),(1480,'accesslib/dirtycontexts','/1/84/1547',1756271880,'1',1756300680),(1481,'accesslib/dirtycontexts','/1/84/1548',1756271880,'1',1756300680),(1482,'accesslib/dirtycontexts','/1/84/1549',1756271881,'1',1756300681),(1483,'accesslib/dirtycontexts','/1/84/1550',1756271881,'1',1756300681),(1484,'accesslib/dirtycontexts','/1/84/1551',1756271881,'1',1756300681),(1485,'accesslib/dirtycontexts','/1/84/1552',1756271881,'1',1756300681),(1486,'accesslib/dirtycontexts','/1/84/1553',1756271882,'1',1756300682),(1487,'accesslib/dirtycontexts','/1/84/1554',1756271882,'1',1756300682),(1488,'accesslib/dirtycontexts','/1/84/1555',1756271882,'1',1756300682),(1489,'accesslib/dirtycontexts','/1/84/1556',1756271882,'1',1756300682),(1490,'accesslib/dirtycontexts','/1/84/1557',1756271882,'1',1756300682),(1491,'accesslib/dirtycontexts','/1/84/1558',1756271883,'1',1756300683),(1492,'accesslib/dirtycontexts','/1/84/1559',1756271883,'1',1756300683),(1493,'accesslib/dirtycontexts','/1/84/1560',1756271883,'1',1756300683),(1494,'accesslib/dirtycontexts','/1/84/1561',1756271883,'1',1756300683),(1495,'accesslib/dirtycontexts','/1/84/1562',1756271883,'1',1756300683),(1496,'accesslib/dirtycontexts','/1/84/1563',1756271883,'1',1756300683),(1497,'accesslib/dirtycontexts','/1/84/1564',1756271884,'1',1756300684),(1498,'accesslib/dirtycontexts','/1/84/1565',1756271884,'1',1756300684),(1499,'accesslib/dirtycontexts','/1/84/1566',1756271884,'1',1756300684),(1500,'accesslib/dirtycontexts','/1/84/1567',1756271884,'1',1756300684),(1501,'accesslib/dirtycontexts','/1/84/1568',1756271884,'1',1756300684),(1502,'accesslib/dirtycontexts','/1/84/1569',1756271885,'1',1756300685),(1503,'accesslib/dirtycontexts','/1/84/1570',1756271885,'1',1756300685),(1504,'accesslib/dirtycontexts','/1/84/1571',1756271885,'1',1756300685),(1505,'accesslib/dirtycontexts','/1/84/1572',1756271885,'1',1756300685),(1506,'accesslib/dirtycontexts','/1/84/1573',1756271885,'1',1756300685),(1507,'accesslib/dirtycontexts','/1/84/1574',1756271886,'1',1756300686),(1508,'accesslib/dirtycontexts','/1/84/1575',1756271886,'1',1756300686),(1509,'accesslib/dirtycontexts','/1/84/1576',1756271886,'1',1756300686),(1510,'accesslib/dirtycontexts','/1/84/1577',1756271886,'1',1756300686),(1511,'accesslib/dirtycontexts','/1/84/1578',1756271886,'1',1756300686),(1512,'accesslib/dirtycontexts','/1/84/1579',1756271887,'1',1756300687),(1513,'accesslib/dirtycontexts','/1/84/1580',1756271887,'1',1756300687),(1514,'accesslib/dirtycontexts','/1/84/1581',1756271887,'1',1756300687),(1515,'accesslib/dirtycontexts','/1/84/1582',1756271887,'1',1756300687),(1516,'accesslib/dirtycontexts','/1/84/1583',1756271887,'1',1756300687),(1517,'accesslib/dirtycontexts','/1/84/1584',1756271888,'1',1756300688),(1518,'accesslib/dirtycontexts','/1/84/1585',1756271888,'1',1756300688),(1519,'accesslib/dirtycontexts','/1/84/1586',1756271888,'1',1756300688),(1520,'accesslib/dirtycontexts','/1/84/1587',1756271888,'1',1756300688),(1521,'accesslib/dirtycontexts','/1/84/1588',1756271888,'1',1756300688),(1522,'accesslib/dirtycontexts','/1/84/1589',1756271888,'1',1756300688),(1523,'accesslib/dirtycontexts','/1/84/1590',1756271889,'1',1756300689),(1524,'accesslib/dirtycontexts','/1/84/1591',1756271889,'1',1756300689),(1525,'accesslib/dirtycontexts','/1/84/1592',1756271889,'1',1756300689),(1526,'accesslib/dirtycontexts','/1/84/1593',1756271889,'1',1756300689),(1527,'accesslib/dirtycontexts','/1/84/1594',1756271889,'1',1756300689),(1528,'accesslib/dirtycontexts','/1/84/1595',1756271890,'1',1756300690),(1529,'accesslib/dirtycontexts','/1/84/1596',1756271890,'1',1756300690),(1530,'accesslib/dirtycontexts','/1/84/1597',1756271890,'1',1756300690),(1531,'accesslib/dirtycontexts','/1/84/1598',1756271890,'1',1756300690),(1532,'accesslib/dirtycontexts','/1/84/1599',1756271890,'1',1756300690),(1533,'accesslib/dirtycontexts','/1/84/1600',1756271891,'1',1756300691),(1534,'accesslib/dirtycontexts','/1/84/1601',1756271891,'1',1756300691),(1535,'accesslib/dirtycontexts','/1/84/1602',1756271891,'1',1756300691),(1536,'accesslib/dirtycontexts','/1/84/1603',1756271891,'1',1756300691),(1537,'accesslib/dirtycontexts','/1/84/1604',1756271892,'1',1756300692),(1538,'accesslib/dirtycontexts','/1/84/1605',1756271892,'1',1756300692),(1539,'accesslib/dirtycontexts','/1/84/1606',1756271892,'1',1756300692),(1540,'accesslib/dirtycontexts','/1/84/1607',1756271892,'1',1756300692),(1541,'accesslib/dirtycontexts','/1/84/1608',1756271892,'1',1756300692),(1542,'accesslib/dirtycontexts','/1/84/1609',1756271893,'1',1756300693),(1543,'accesslib/dirtycontexts','/1/84/1610',1756271893,'1',1756300693),(1544,'accesslib/dirtycontexts','/1/84/1611',1756271893,'1',1756300693),(1545,'accesslib/dirtycontexts','/1/84/1612',1756271893,'1',1756300693),(1546,'accesslib/dirtycontexts','/1/84/1613',1756271893,'1',1756300693),(1547,'accesslib/dirtycontexts','/1/84/1614',1756271894,'1',1756300694),(1548,'accesslib/dirtycontexts','/1/84/1615',1756271894,'1',1756300694),(1549,'accesslib/dirtycontexts','/1/84/1616',1756271894,'1',1756300694),(1550,'accesslib/dirtycontexts','/1/84/1617',1756271894,'1',1756300694),(1551,'accesslib/dirtycontexts','/1/84/1618',1756271894,'1',1756300694),(1552,'accesslib/dirtycontexts','/1/84/1619',1756271895,'1',1756300695),(1553,'accesslib/dirtycontexts','/1/84/1620',1756271895,'1',1756300695),(1554,'accesslib/dirtycontexts','/1/84/1621',1756271895,'1',1756300695),(1555,'accesslib/dirtycontexts','/1/84/1622',1756271895,'1',1756300695),(1556,'accesslib/dirtycontexts','/1/84/1623',1756271895,'1',1756300695),(1557,'accesslib/dirtycontexts','/1/84/1624',1756271896,'1',1756300696),(1558,'accesslib/dirtycontexts','/1/84/1625',1756271896,'1',1756300696),(1559,'accesslib/dirtycontexts','/1/84/1626',1756271896,'1',1756300696),(1560,'accesslib/dirtycontexts','/1/84/1627',1756271896,'1',1756300696),(1561,'accesslib/dirtycontexts','/1/84/1628',1756271896,'1',1756300696),(1562,'accesslib/dirtycontexts','/1/84/1629',1756271897,'1',1756300697),(1563,'accesslib/dirtycontexts','/1/84/1630',1756271897,'1',1756300697),(1564,'accesslib/dirtycontexts','/1/84/1631',1756271897,'1',1756300697),(1565,'accesslib/dirtycontexts','/1/84/1632',1756271897,'1',1756300697),(1566,'accesslib/dirtycontexts','/1/84/1633',1756271897,'1',1756300697),(1567,'accesslib/dirtycontexts','/1/84/1634',1756271898,'1',1756300698),(1568,'accesslib/dirtycontexts','/1/84/1635',1756271898,'1',1756300698),(1569,'accesslib/dirtycontexts','/1/84/1636',1756271899,'1',1756300699),(1570,'accesslib/dirtycontexts','/1/84/1637',1756271899,'1',1756300699),(1571,'accesslib/dirtycontexts','/1/84/1638',1756271899,'1',1756300699),(1572,'accesslib/dirtycontexts','/1/84/1639',1756271900,'1',1756300700),(1573,'accesslib/dirtycontexts','/1/84/1640',1756271900,'1',1756300700),(1574,'accesslib/dirtycontexts','/1/84/1641',1756271900,'1',1756300700),(1575,'accesslib/dirtycontexts','/1/84/1642',1756271900,'1',1756300700),(1576,'accesslib/dirtycontexts','/1/84/1643',1756271901,'1',1756300701),(1577,'accesslib/dirtycontexts','/1/84/1644',1756271901,'1',1756300701),(1578,'accesslib/dirtycontexts','/1/84/1645',1756271901,'1',1756300701),(1579,'accesslib/dirtycontexts','/1/84/1646',1756271901,'1',1756300701),(1580,'accesslib/dirtycontexts','/1/84/1647',1756271902,'1',1756300702),(1581,'accesslib/dirtycontexts','/1/84/1648',1756271902,'1',1756300702),(1582,'accesslib/dirtycontexts','/1/84/1649',1756271902,'1',1756300702),(1583,'accesslib/dirtycontexts','/1/84/1650',1756271902,'1',1756300702),(1584,'accesslib/dirtycontexts','/1/84/1651',1756271902,'1',1756300702),(1585,'accesslib/dirtycontexts','/1/84/1652',1756271903,'1',1756300703),(1586,'accesslib/dirtycontexts','/1/84/1653',1756271903,'1',1756300703),(1587,'accesslib/dirtycontexts','/1/84/1654',1756271903,'1',1756300703),(1588,'accesslib/dirtycontexts','/1/84/1655',1756271903,'1',1756300703),(1589,'accesslib/dirtycontexts','/1/84/1656',1756271903,'1',1756300703),(1590,'accesslib/dirtycontexts','/1/84/1657',1756271904,'1',1756300704),(1591,'accesslib/dirtycontexts','/1/84/1658',1756271904,'1',1756300704),(1592,'accesslib/dirtycontexts','/1/84/1659',1756271904,'1',1756300704),(1593,'accesslib/dirtycontexts','/1/84/1660',1756271905,'1',1756300705),(1594,'accesslib/dirtycontexts','/1/84/1661',1756271905,'1',1756300705),(1595,'accesslib/dirtycontexts','/1/84/1662',1756271905,'1',1756300705),(1596,'accesslib/dirtycontexts','/1/84/1663',1756271905,'1',1756300705),(1597,'accesslib/dirtycontexts','/1/84/1664',1756271905,'1',1756300705),(1598,'accesslib/dirtycontexts','/1/84/1665',1756271905,'1',1756300705),(1599,'accesslib/dirtycontexts','/1/84/1666',1756271906,'1',1756300706),(1600,'accesslib/dirtycontexts','/1/84/1667',1756271906,'1',1756300706),(1601,'accesslib/dirtycontexts','/1/84/1668',1756271906,'1',1756300706),(1602,'accesslib/dirtycontexts','/1/84/1669',1756271906,'1',1756300706),(1603,'accesslib/dirtycontexts','/1/84/1670',1756271907,'1',1756300707),(1604,'accesslib/dirtycontexts','/1/84/1671',1756271907,'1',1756300707),(1605,'accesslib/dirtycontexts','/1/84/1672',1756271907,'1',1756300707),(1606,'accesslib/dirtycontexts','/1/84/1673',1756271907,'1',1756300707),(1607,'accesslib/dirtycontexts','/1/84/1674',1756271907,'1',1756300707),(1608,'accesslib/dirtycontexts','/1/84/1675',1756271908,'1',1756300708),(1609,'accesslib/dirtycontexts','/1/84/1676',1756271908,'1',1756300708),(1610,'accesslib/dirtycontexts','/1/84/1677',1756271908,'1',1756300708),(1611,'accesslib/dirtycontexts','/1/84/1678',1756271908,'1',1756300708),(1612,'accesslib/dirtycontexts','/1/84/1679',1756271908,'1',1756300708),(1613,'accesslib/dirtycontexts','/1/84/1680',1756271908,'1',1756300708),(1614,'accesslib/dirtycontexts','/1/84/1681',1756271909,'1',1756300709),(1615,'accesslib/dirtycontexts','/1/84/1682',1756271909,'1',1756300709),(1616,'accesslib/dirtycontexts','/1/84/1683',1756271909,'1',1756300709),(1617,'accesslib/dirtycontexts','/1/84/1684',1756271909,'1',1756300709),(1618,'accesslib/dirtycontexts','/1/84/1685',1756271910,'1',1756300710),(1619,'accesslib/dirtycontexts','/1/84/1686',1756271910,'1',1756300710),(1620,'accesslib/dirtycontexts','/1/84/1687',1756271910,'1',1756300710),(1621,'accesslib/dirtycontexts','/1/84/1688',1756271910,'1',1756300710),(1622,'accesslib/dirtycontexts','/1/84/1689',1756271910,'1',1756300710),(1623,'accesslib/dirtycontexts','/1/84/1690',1756271911,'1',1756300711),(1624,'accesslib/dirtycontexts','/1/84/1691',1756271911,'1',1756300711),(1625,'accesslib/dirtycontexts','/1/84/1692',1756271911,'1',1756300711),(1626,'accesslib/dirtycontexts','/1/84/1693',1756271911,'1',1756300711),(1627,'accesslib/dirtycontexts','/1/84/1694',1756271911,'1',1756300711),(1628,'accesslib/dirtycontexts','/1/84/1695',1756271912,'1',1756300712),(1629,'accesslib/dirtycontexts','/1/84/1696',1756271912,'1',1756300712),(1630,'accesslib/dirtycontexts','/1/84/1697',1756271912,'1',1756300712),(1631,'accesslib/dirtycontexts','/1/84/1698',1756271912,'1',1756300712),(1632,'accesslib/dirtycontexts','/1/84/1699',1756271912,'1',1756300712),(1633,'accesslib/dirtycontexts','/1/84/1700',1756271913,'1',1756300713),(1634,'accesslib/dirtycontexts','/1/84/1701',1756271913,'1',1756300713),(1635,'accesslib/dirtycontexts','/1/84/1702',1756271913,'1',1756300713),(1636,'accesslib/dirtycontexts','/1/84/1703',1756271913,'1',1756300713),(1637,'accesslib/dirtycontexts','/1/84/1704',1756271913,'1',1756300713),(1638,'accesslib/dirtycontexts','/1/84/1705',1756271914,'1',1756300714),(1639,'accesslib/dirtycontexts','/1/84/1706',1756271914,'1',1756300714),(1640,'accesslib/dirtycontexts','/1/84/1707',1756271914,'1',1756300714),(1641,'accesslib/dirtycontexts','/1/84/1708',1756271914,'1',1756300714),(1642,'accesslib/dirtycontexts','/1/84/1709',1756271914,'1',1756300714),(1643,'accesslib/dirtycontexts','/1/84/1710',1756271915,'1',1756300715),(1644,'accesslib/dirtycontexts','/1/84/1711',1756271915,'1',1756300715),(1645,'accesslib/dirtycontexts','/1/84/1712',1756271915,'1',1756300715),(1646,'accesslib/dirtycontexts','/1/84/1713',1756271915,'1',1756300715),(1647,'accesslib/dirtycontexts','/1/84/1714',1756271915,'1',1756300715),(1648,'accesslib/dirtycontexts','/1/84/1715',1756271915,'1',1756300715),(1649,'accesslib/dirtycontexts','/1/84/1716',1756271916,'1',1756300716),(1650,'accesslib/dirtycontexts','/1/84/1717',1756271916,'1',1756300716),(1651,'accesslib/dirtycontexts','/1/84/1718',1756271916,'1',1756300716),(1652,'accesslib/dirtycontexts','/1/84/1719',1756271916,'1',1756300716),(1653,'accesslib/dirtycontexts','/1/84/1720',1756271917,'1',1756300717),(1654,'accesslib/dirtycontexts','/1/84/1721',1756271917,'1',1756300717),(1655,'accesslib/dirtycontexts','/1/84/1722',1756271917,'1',1756300717),(1656,'accesslib/dirtycontexts','/1/84/1723',1756271918,'1',1756300718),(1657,'accesslib/dirtycontexts','/1/84/1724',1756271918,'1',1756300718),(1658,'accesslib/dirtycontexts','/1/84/1725',1756271918,'1',1756300718),(1659,'accesslib/dirtycontexts','/1/84/1726',1756271918,'1',1756300718),(1660,'accesslib/dirtycontexts','/1/84/1727',1756271918,'1',1756300718),(1661,'accesslib/dirtycontexts','/1/84/1728',1756271918,'1',1756300718),(1662,'accesslib/dirtycontexts','/1/84/1729',1756271919,'1',1756300719),(1663,'accesslib/dirtycontexts','/1/84/1730',1756271919,'1',1756300719),(1664,'accesslib/dirtycontexts','/1/84/1731',1756271919,'1',1756300719),(1665,'accesslib/dirtycontexts','/1/84/1732',1756271919,'1',1756300719),(1666,'accesslib/dirtycontexts','/1/84/1733',1756271919,'1',1756300719),(1667,'accesslib/dirtycontexts','/1/84/1734',1756271920,'1',1756300720),(1668,'accesslib/dirtycontexts','/1/84/1735',1756271920,'1',1756300720),(1669,'accesslib/dirtycontexts','/1/84/1736',1756271920,'1',1756300720),(1670,'accesslib/dirtycontexts','/1/84/1737',1756271920,'1',1756300720),(1671,'accesslib/dirtycontexts','/1/84/1738',1756271920,'1',1756300720),(1672,'accesslib/dirtycontexts','/1/84/1739',1756271921,'1',1756300721),(1673,'accesslib/dirtycontexts','/1/84/1740',1756271921,'1',1756300721),(1674,'accesslib/dirtycontexts','/1/84/1741',1756271921,'1',1756300721),(1675,'accesslib/dirtycontexts','/1/84/1742',1756271921,'1',1756300721),(1676,'accesslib/dirtycontexts','/1/84/1743',1756271921,'1',1756300721),(1677,'accesslib/dirtycontexts','/1/84/1744',1756271921,'1',1756300721),(1678,'accesslib/dirtycontexts','/1/84/1745',1756271922,'1',1756300722),(1679,'accesslib/dirtycontexts','/1/84/1746',1756271922,'1',1756300722),(1680,'accesslib/dirtycontexts','/1/84/1747',1756271922,'1',1756300722),(1681,'accesslib/dirtycontexts','/1/84/1748',1756271922,'1',1756300722),(1682,'accesslib/dirtycontexts','/1/84/1749',1756271923,'1',1756300723),(1683,'accesslib/dirtycontexts','/1/84/1750',1756271923,'1',1756300723),(1684,'accesslib/dirtycontexts','/1/84/1751',1756271923,'1',1756300723),(1685,'accesslib/dirtycontexts','/1/84/1752',1756271923,'1',1756300723),(1686,'accesslib/dirtycontexts','/1/84/1753',1756271923,'1',1756300723),(1687,'accesslib/dirtycontexts','/1/84/1754',1756271923,'1',1756300723),(1688,'accesslib/dirtycontexts','/1/84/1755',1756271924,'1',1756300724),(1689,'accesslib/dirtycontexts','/1/84/1756',1756271924,'1',1756300724),(1690,'accesslib/dirtycontexts','/1/84/1757',1756271924,'1',1756300724),(1691,'accesslib/dirtycontexts','/1/84/1758',1756271924,'1',1756300724),(1692,'accesslib/dirtycontexts','/1/84/1759',1756271924,'1',1756300724),(1693,'accesslib/dirtycontexts','/1/84/1760',1756271925,'1',1756300725),(1694,'accesslib/dirtycontexts','/1/84/1761',1756271925,'1',1756300725),(1695,'accesslib/dirtycontexts','/1/84/1762',1756271925,'1',1756300725),(1696,'accesslib/dirtycontexts','/1/84/1763',1756271925,'1',1756300725),(1697,'accesslib/dirtycontexts','/1/84/1764',1756271925,'1',1756300725),(1698,'accesslib/dirtycontexts','/1/84/1765',1756271926,'1',1756300726),(1699,'accesslib/dirtycontexts','/1/84/1766',1756271926,'1',1756300726),(1700,'accesslib/dirtycontexts','/1/84/1767',1756271926,'1',1756300726),(1701,'accesslib/dirtycontexts','/1/84/1768',1756271926,'1',1756300726),(1702,'accesslib/dirtycontexts','/1/84/1769',1756271926,'1',1756300726),(1703,'accesslib/dirtycontexts','/1/84/1770',1756271926,'1',1756300726),(1704,'accesslib/dirtycontexts','/1/84/1771',1756271927,'1',1756300727),(1705,'accesslib/dirtycontexts','/1/84/1772',1756271927,'1',1756300727),(1706,'accesslib/dirtycontexts','/1/84/1773',1756271927,'1',1756300727),(1707,'accesslib/dirtycontexts','/1/84/1774',1756271927,'1',1756300727),(1708,'accesslib/dirtycontexts','/1/84/1775',1756271927,'1',1756300727),(1709,'accesslib/dirtycontexts','/1/84/1776',1756271928,'1',1756300728),(1710,'accesslib/dirtycontexts','/1/84/1777',1756271928,'1',1756300728),(1711,'accesslib/dirtycontexts','/1/84/1778',1756271928,'1',1756300728),(1712,'accesslib/dirtycontexts','/1/84/1779',1756271928,'1',1756300728),(1713,'accesslib/dirtycontexts','/1/84/1780',1756271928,'1',1756300728),(1714,'accesslib/dirtycontexts','/1/84/1781',1756271929,'1',1756300729),(1715,'accesslib/dirtycontexts','/1/84/1782',1756271929,'1',1756300729),(1716,'accesslib/dirtycontexts','/1/84/1783',1756271929,'1',1756300729),(1717,'accesslib/dirtycontexts','/1/84/1784',1756271929,'1',1756300729),(1718,'accesslib/dirtycontexts','/1/84/1785',1756271929,'1',1756300729),(1719,'accesslib/dirtycontexts','/1/84/1786',1756271929,'1',1756300729),(1720,'accesslib/dirtycontexts','/1/84/1787',1756271930,'1',1756300730),(1721,'accesslib/dirtycontexts','/1/84/1788',1756271930,'1',1756300730),(1722,'accesslib/dirtycontexts','/1/84/1789',1756271930,'1',1756300730),(1723,'accesslib/dirtycontexts','/1/84/1790',1756271930,'1',1756300730),(1724,'accesslib/dirtycontexts','/1/84/1791',1756271930,'1',1756300730),(1725,'accesslib/dirtycontexts','/1/84/1792',1756271931,'1',1756300731),(1726,'accesslib/dirtycontexts','/1/84/1793',1756271931,'1',1756300731),(1727,'accesslib/dirtycontexts','/1/84/1794',1756271931,'1',1756300731),(1728,'accesslib/dirtycontexts','/1/84/1795',1756271931,'1',1756300731),(1729,'accesslib/dirtycontexts','/1/84/1796',1756271932,'1',1756300732),(1730,'accesslib/dirtycontexts','/1/84/1797',1756271932,'1',1756300732),(1731,'accesslib/dirtycontexts','/1/84/1798',1756271932,'1',1756300732),(1732,'accesslib/dirtycontexts','/1/84/1799',1756271932,'1',1756300732),(1733,'accesslib/dirtycontexts','/1/84/1800',1756271932,'1',1756300732),(1734,'accesslib/dirtycontexts','/1/84/1801',1756271933,'1',1756300733),(1735,'accesslib/dirtycontexts','/1/84/1802',1756271933,'1',1756300733),(1736,'accesslib/dirtycontexts','/1/84/1803',1756271933,'1',1756300733),(1737,'accesslib/dirtycontexts','/1/84/1804',1756271933,'1',1756300733),(1738,'accesslib/dirtycontexts','/1/84/1805',1756271933,'1',1756300733),(1739,'accesslib/dirtycontexts','/1/84/1806',1756271934,'1',1756300734),(1740,'accesslib/dirtycontexts','/1/84/1807',1756271934,'1',1756300734),(1741,'accesslib/dirtycontexts','/1/84/1808',1756271934,'1',1756300734),(1742,'accesslib/dirtycontexts','/1/84/1809',1756271934,'1',1756300734),(1743,'accesslib/dirtycontexts','/1/84/1810',1756271934,'1',1756300734),(1744,'accesslib/dirtycontexts','/1/84/1811',1756271934,'1',1756300734),(1745,'accesslib/dirtycontexts','/1/84/1812',1756271935,'1',1756300735),(1746,'accesslib/dirtycontexts','/1/84/1813',1756271935,'1',1756300735),(1747,'accesslib/dirtycontexts','/1/84/1814',1756271935,'1',1756300735),(1748,'accesslib/dirtycontexts','/1/84/1815',1756271935,'1',1756300735),(1749,'accesslib/dirtycontexts','/1/84/1816',1756271935,'1',1756300735),(1750,'accesslib/dirtycontexts','/1/84/1817',1756271936,'1',1756300736),(1751,'accesslib/dirtycontexts','/1/84/1818',1756271936,'1',1756300736),(1752,'accesslib/dirtycontexts','/1/84/1819',1756271936,'1',1756300736),(1753,'accesslib/dirtycontexts','/1/84/1820',1756271936,'1',1756300736),(1754,'accesslib/dirtycontexts','/1/84/1821',1756271936,'1',1756300736),(1755,'accesslib/dirtycontexts','/1/84/1822',1756271937,'1',1756300737),(1756,'accesslib/dirtycontexts','/1/84/1823',1756271937,'1',1756300737),(1757,'accesslib/dirtycontexts','/1/84/1824',1756271937,'1',1756300737),(1758,'accesslib/dirtycontexts','/1/84/1825',1756271937,'1',1756300737),(1759,'accesslib/dirtycontexts','/1/84/1826',1756271937,'1',1756300737),(1760,'accesslib/dirtycontexts','/1/84/1827',1756271938,'1',1756300738),(1761,'accesslib/dirtycontexts','/1/84/1828',1756271938,'1',1756300738),(1762,'accesslib/dirtycontexts','/1/84/1829',1756271938,'1',1756300738),(1763,'accesslib/dirtycontexts','/1/84/1830',1756271938,'1',1756300738),(1764,'accesslib/dirtycontexts','/1/84/1831',1756271938,'1',1756300738),(1765,'accesslib/dirtycontexts','/1/84/1832',1756271939,'1',1756300739),(1766,'accesslib/dirtycontexts','/1/84/1833',1756271939,'1',1756300739),(1767,'accesslib/dirtycontexts','/1/84/1834',1756271939,'1',1756300739),(1768,'accesslib/dirtycontexts','/1/84/1835',1756271939,'1',1756300739),(1769,'accesslib/dirtycontexts','/1/84/1836',1756271939,'1',1756300739),(1770,'accesslib/dirtycontexts','/1/84/1837',1756271940,'1',1756300740),(1771,'accesslib/dirtycontexts','/1/84/1838',1756271940,'1',1756300740),(1772,'accesslib/dirtycontexts','/1/84/1839',1756271940,'1',1756300740),(1773,'accesslib/dirtycontexts','/1/84/1840',1756271940,'1',1756300740),(1774,'accesslib/dirtycontexts','/1/84/1841',1756271940,'1',1756300740),(1775,'accesslib/dirtycontexts','/1/84/1842',1756271941,'1',1756300741),(1776,'accesslib/dirtycontexts','/1/84/1843',1756271941,'1',1756300741),(1777,'accesslib/dirtycontexts','/1/84/1844',1756271941,'1',1756300741),(1778,'accesslib/dirtycontexts','/1/84/1845',1756271941,'1',1756300741),(1779,'accesslib/dirtycontexts','/1/84/1846',1756271941,'1',1756300741),(1780,'accesslib/dirtycontexts','/1/84/1847',1756271942,'1',1756300742),(1781,'accesslib/dirtycontexts','/1/84/1848',1756271942,'1',1756300742),(1782,'accesslib/dirtycontexts','/1/84/1849',1756271942,'1',1756300742),(1783,'accesslib/dirtycontexts','/1/84/1850',1756271942,'1',1756300742),(1784,'accesslib/dirtycontexts','/1/84/1851',1756271942,'1',1756300742),(1785,'accesslib/dirtycontexts','/1/84/1852',1756271943,'1',1756300743),(1786,'accesslib/dirtycontexts','/1/84/1853',1756271943,'1',1756300743),(1787,'accesslib/dirtycontexts','/1/84/1854',1756271943,'1',1756300743),(1788,'accesslib/dirtycontexts','/1/84/1855',1756271943,'1',1756300743),(1789,'accesslib/dirtycontexts','/1/84/1856',1756271944,'1',1756300744),(1790,'accesslib/dirtycontexts','/1/84/1857',1756271944,'1',1756300744),(1791,'accesslib/dirtycontexts','/1/84/1858',1756271944,'1',1756300744),(1792,'accesslib/dirtycontexts','/1/84/1859',1756271944,'1',1756300744),(1793,'accesslib/dirtycontexts','/1/84/1860',1756271944,'1',1756300744),(1794,'accesslib/dirtycontexts','/1/84/1861',1756271945,'1',1756300745),(1795,'accesslib/dirtycontexts','/1/84/1862',1756271945,'1',1756300745),(1796,'accesslib/dirtycontexts','/1/84/1863',1756271945,'1',1756300745),(1797,'accesslib/dirtycontexts','/1/84/1864',1756271945,'1',1756300745),(1798,'accesslib/dirtycontexts','/1/84/1865',1756271945,'1',1756300745),(1799,'accesslib/dirtycontexts','/1/84/1866',1756271945,'1',1756300745),(1800,'accesslib/dirtycontexts','/1/84/1867',1756271946,'1',1756300746),(1801,'accesslib/dirtycontexts','/1/84/1868',1756271946,'1',1756300746),(1802,'accesslib/dirtycontexts','/1/84/1869',1756271946,'1',1756300746),(1803,'accesslib/dirtycontexts','/1/84/1870',1756271946,'1',1756300746),(1804,'accesslib/dirtycontexts','/1/84/1871',1756271946,'1',1756300746),(1805,'accesslib/dirtycontexts','/1/84/1872',1756271947,'1',1756300747),(1806,'accesslib/dirtycontexts','/1/84/1873',1756271947,'1',1756300747),(1807,'accesslib/dirtycontexts','/1/84/1874',1756271947,'1',1756300747),(1808,'accesslib/dirtycontexts','/1/84/1875',1756271947,'1',1756300747),(1809,'accesslib/dirtycontexts','/1/84/1876',1756271947,'1',1756300747),(1810,'accesslib/dirtycontexts','/1/84/1877',1756271948,'1',1756300748),(1811,'accesslib/dirtycontexts','/1/84/1878',1756271948,'1',1756300748),(1812,'accesslib/dirtycontexts','/1/84/1879',1756271948,'1',1756300748),(1813,'accesslib/dirtycontexts','/1/84/1880',1756271949,'1',1756300749),(1814,'accesslib/dirtycontexts','/1/84/1881',1756271949,'1',1756300749),(1815,'accesslib/dirtycontexts','/1/84/1882',1756271950,'1',1756300750),(1816,'accesslib/dirtycontexts','/1/84/1883',1756271951,'1',1756300751),(1817,'accesslib/dirtycontexts','/1/84/1884',1756271951,'1',1756300751),(1818,'accesslib/dirtycontexts','/1/84/1885',1756271952,'1',1756300752),(1819,'accesslib/dirtycontexts','/1/84/1886',1756271952,'1',1756300752),(1820,'accesslib/dirtycontexts','/1/84/1887',1756271953,'1',1756300753),(1821,'accesslib/dirtycontexts','/1/84/1888',1756271954,'1',1756300754),(1822,'accesslib/dirtycontexts','/1/84/1889',1756271954,'1',1756300754),(1823,'accesslib/dirtycontexts','/1/84/1890',1756271954,'1',1756300754),(1824,'accesslib/dirtycontexts','/1/84/1891',1756271955,'1',1756300755),(1825,'accesslib/dirtycontexts','/1/84/1892',1756271955,'1',1756300755),(1826,'accesslib/dirtycontexts','/1/84/1893',1756271955,'1',1756300755),(1827,'accesslib/dirtycontexts','/1/84/1894',1756271955,'1',1756300755),(1828,'accesslib/dirtycontexts','/1/84/1895',1756271955,'1',1756300755),(1829,'accesslib/dirtycontexts','/1/84/1896',1756271955,'1',1756300755),(1830,'accesslib/dirtycontexts','/1/84/1897',1756271956,'1',1756300756),(1831,'accesslib/dirtycontexts','/1/84/1898',1756271956,'1',1756300756),(1832,'accesslib/dirtycontexts','/1/84/1899',1756271956,'1',1756300756),(1833,'accesslib/dirtycontexts','/1/84/1900',1756271956,'1',1756300756),(1834,'accesslib/dirtycontexts','/1/84/1901',1756271956,'1',1756300756),(1835,'accesslib/dirtycontexts','/1/84/1902',1756271957,'1',1756300757),(1836,'accesslib/dirtycontexts','/1/84/1903',1756271957,'1',1756300757),(1837,'accesslib/dirtycontexts','/1/84/1904',1756271957,'1',1756300757),(1838,'accesslib/dirtycontexts','/1/84/1905',1756271957,'1',1756300757),(1839,'accesslib/dirtycontexts','/1/84/1906',1756271957,'1',1756300757),(1840,'accesslib/dirtycontexts','/1/84/1907',1756271958,'1',1756300758),(1841,'accesslib/dirtycontexts','/1/84/1908',1756271958,'1',1756300758),(1842,'accesslib/dirtycontexts','/1/84/1909',1756271958,'1',1756300758),(1843,'accesslib/dirtycontexts','/1/84/1910',1756271958,'1',1756300758),(1844,'accesslib/dirtycontexts','/1/84/1911',1756271958,'1',1756300758),(1845,'accesslib/dirtycontexts','/1/84/1912',1756271959,'1',1756300759),(1846,'accesslib/dirtycontexts','/1/84/1913',1756271959,'1',1756300759),(1847,'accesslib/dirtycontexts','/1/84/1914',1756271959,'1',1756300759),(1848,'accesslib/dirtycontexts','/1/84/1915',1756271959,'1',1756300759),(1849,'accesslib/dirtycontexts','/1/84/1916',1756271960,'1',1756300760),(1850,'accesslib/dirtycontexts','/1/84/1917',1756271960,'1',1756300760),(1851,'accesslib/dirtycontexts','/1/84/1918',1756271960,'1',1756300760),(1852,'accesslib/dirtycontexts','/1/84/1919',1756271961,'1',1756300761),(1853,'accesslib/dirtycontexts','/1/84/1920',1756271961,'1',1756300761),(1854,'accesslib/dirtycontexts','/1/84/1921',1756271961,'1',1756300761),(1855,'accesslib/dirtycontexts','/1/84/1922',1756271962,'1',1756300762),(1856,'accesslib/dirtycontexts','/1/84/1923',1756271962,'1',1756300762),(1857,'accesslib/dirtycontexts','/1/84/1924',1756271962,'1',1756300762),(1858,'accesslib/dirtycontexts','/1/84/1925',1756271962,'1',1756300762),(1859,'accesslib/dirtycontexts','/1/84/1926',1756271962,'1',1756300762),(1860,'accesslib/dirtycontexts','/1/84/1927',1756271963,'1',1756300763),(1861,'accesslib/dirtycontexts','/1/84/1928',1756271963,'1',1756300763),(1862,'accesslib/dirtycontexts','/1/84/1929',1756271963,'1',1756300763),(1863,'accesslib/dirtycontexts','/1/84/1930',1756271963,'1',1756300763),(1864,'accesslib/dirtycontexts','/1/84/1931',1756271964,'1',1756300764),(1865,'accesslib/dirtycontexts','/1/84/1932',1756271964,'1',1756300764),(1866,'accesslib/dirtycontexts','/1/84/1933',1756271964,'1',1756300764),(1867,'accesslib/dirtycontexts','/1/84/1934',1756271964,'1',1756300764),(1868,'accesslib/dirtycontexts','/1/84/1935',1756271964,'1',1756300764),(1869,'accesslib/dirtycontexts','/1/84/1936',1756271965,'1',1756300765),(1870,'accesslib/dirtycontexts','/1/84/1937',1756271965,'1',1756300765),(1871,'accesslib/dirtycontexts','/1/84/1938',1756271965,'1',1756300765),(1872,'accesslib/dirtycontexts','/1/84/1939',1756271965,'1',1756300765),(1873,'accesslib/dirtycontexts','/1/84/1940',1756271965,'1',1756300765),(1874,'accesslib/dirtycontexts','/1/84/1941',1756271966,'1',1756300766),(1875,'accesslib/dirtycontexts','/1/84/1942',1756271966,'1',1756300766),(1876,'accesslib/dirtycontexts','/1/84/1943',1756271966,'1',1756300766),(1877,'accesslib/dirtycontexts','/1/84/1944',1756271966,'1',1756300766),(1878,'accesslib/dirtycontexts','/1/84/1945',1756271966,'1',1756300766),(1879,'accesslib/dirtycontexts','/1/84/1946',1756271967,'1',1756300767),(1880,'accesslib/dirtycontexts','/1/84/1947',1756271967,'1',1756300767),(1881,'accesslib/dirtycontexts','/1/84/1948',1756271967,'1',1756300767),(1882,'accesslib/dirtycontexts','/1/84/1949',1756271967,'1',1756300767),(1883,'accesslib/dirtycontexts','/1/84/1950',1756271967,'1',1756300767),(1884,'accesslib/dirtycontexts','/1/84/1951',1756271968,'1',1756300768),(1885,'accesslib/dirtycontexts','/1/84/1952',1756271968,'1',1756300768),(1886,'accesslib/dirtycontexts','/1/84/1953',1756271968,'1',1756300768),(1887,'accesslib/dirtycontexts','/1/84/1954',1756271968,'1',1756300768),(1888,'accesslib/dirtycontexts','/1/84/1955',1756271968,'1',1756300768),(1889,'accesslib/dirtycontexts','/1/84/1956',1756271969,'1',1756300769),(1890,'accesslib/dirtycontexts','/1/84/1957',1756271969,'1',1756300769),(1891,'accesslib/dirtycontexts','/1/84/1958',1756271969,'1',1756300769),(1892,'accesslib/dirtycontexts','/1/84/1959',1756271969,'1',1756300769),(1893,'accesslib/dirtycontexts','/1/84/1960',1756271969,'1',1756300769),(1894,'accesslib/dirtycontexts','/1/84/1961',1756271970,'1',1756300770),(1895,'accesslib/dirtycontexts','/1/84/1962',1756271970,'1',1756300770),(1896,'accesslib/dirtycontexts','/1/84/1963',1756271970,'1',1756300770),(1897,'accesslib/dirtycontexts','/1/84/1964',1756271970,'1',1756300770),(1898,'accesslib/dirtycontexts','/1/84/1965',1756271970,'1',1756300770),(1899,'accesslib/dirtycontexts','/1/84/1966',1756271971,'1',1756300771),(1900,'accesslib/dirtycontexts','/1/84/1967',1756271971,'1',1756300771),(1901,'accesslib/dirtycontexts','/1/84/1968',1756271971,'1',1756300771),(1902,'accesslib/dirtycontexts','/1/84/1969',1756271971,'1',1756300771),(1903,'accesslib/dirtycontexts','/1/84/1970',1756271971,'1',1756300771),(1904,'accesslib/dirtycontexts','/1/84/1971',1756271972,'1',1756300772),(1905,'accesslib/dirtycontexts','/1/84/1972',1756271972,'1',1756300772),(1906,'accesslib/dirtycontexts','/1/84/1973',1756271972,'1',1756300772),(1907,'accesslib/dirtycontexts','/1/84/1974',1756271972,'1',1756300772),(1908,'accesslib/dirtycontexts','/1/84/1975',1756271973,'1',1756300773),(1909,'accesslib/dirtycontexts','/1/84/1976',1756271973,'1',1756300773),(1910,'accesslib/dirtycontexts','/1/84/1977',1756271973,'1',1756300773),(1911,'accesslib/dirtycontexts','/1/84/1978',1756271973,'1',1756300773),(1912,'accesslib/dirtycontexts','/1/84/1979',1756271973,'1',1756300773),(1913,'accesslib/dirtycontexts','/1/84/1980',1756271973,'1',1756300773),(1914,'accesslib/dirtycontexts','/1/84/1981',1756271974,'1',1756300774),(1915,'accesslib/dirtycontexts','/1/84/1982',1756271974,'1',1756300774),(1916,'accesslib/dirtycontexts','/1/84/1983',1756271974,'1',1756300774),(1917,'accesslib/dirtycontexts','/1/84/1984',1756271974,'1',1756300774),(1918,'accesslib/dirtycontexts','/1/84/1985',1756271974,'1',1756300774),(1919,'accesslib/dirtycontexts','/1/84/1986',1756271975,'1',1756300775),(1920,'accesslib/dirtycontexts','/1/84/1987',1756271975,'1',1756300775),(1921,'accesslib/dirtycontexts','/1/84/1988',1756271975,'1',1756300775),(1922,'accesslib/dirtycontexts','/1/84/1989',1756271975,'1',1756300775),(1923,'accesslib/dirtycontexts','/1/84/1990',1756271975,'1',1756300775),(1924,'accesslib/dirtycontexts','/1/84/1991',1756271976,'1',1756300776),(1925,'accesslib/dirtycontexts','/1/84/1992',1756271976,'1',1756300776),(1926,'accesslib/dirtycontexts','/1/84/1993',1756271976,'1',1756300776),(1927,'accesslib/dirtycontexts','/1/84/1994',1756271976,'1',1756300776),(1928,'accesslib/dirtycontexts','/1/84/1995',1756271976,'1',1756300776),(1929,'accesslib/dirtycontexts','/1/84/1996',1756271977,'1',1756300777),(1930,'accesslib/dirtycontexts','/1/84/1997',1756271977,'1',1756300777),(1931,'accesslib/dirtycontexts','/1/84/1998',1756271977,'1',1756300777),(1932,'accesslib/dirtycontexts','/1/84/1999',1756271977,'1',1756300777),(1933,'accesslib/dirtycontexts','/1/84/2000',1756271977,'1',1756300777),(1934,'accesslib/dirtycontexts','/1/84/2001',1756271977,'1',1756300777),(1935,'accesslib/dirtycontexts','/1/84/2002',1756271978,'1',1756300778),(1936,'accesslib/dirtycontexts','/1/84/2003',1756271978,'1',1756300778),(1937,'accesslib/dirtycontexts','/1/84/2004',1756271978,'1',1756300778),(1938,'accesslib/dirtycontexts','/1/84/2005',1756271978,'1',1756300778),(1939,'accesslib/dirtycontexts','/1/84/2006',1756271978,'1',1756300778),(1940,'accesslib/dirtycontexts','/1/84/2007',1756271979,'1',1756300779),(1941,'accesslib/dirtycontexts','/1/84/2008',1756271979,'1',1756300779),(1942,'accesslib/dirtycontexts','/1/84/2009',1756271979,'1',1756300779),(1943,'accesslib/dirtycontexts','/1/84/2010',1756271979,'1',1756300779),(1944,'accesslib/dirtycontexts','/1/84/2011',1756271979,'1',1756300779),(1945,'accesslib/dirtycontexts','/1/84/2012',1756271980,'1',1756300780),(1946,'accesslib/dirtycontexts','/1/84/2013',1756271980,'1',1756300780),(1947,'accesslib/dirtycontexts','/1/84/2014',1756271980,'1',1756300780),(1948,'accesslib/dirtycontexts','/1/84/2015',1756271981,'1',1756300781),(1949,'accesslib/dirtycontexts','/1/84/2016',1756271981,'1',1756300781),(1950,'accesslib/dirtycontexts','/1/84/2017',1756271981,'1',1756300781),(1951,'accesslib/dirtycontexts','/1/84/2018',1756271981,'1',1756300781),(1952,'accesslib/dirtycontexts','/1/84/2019',1756271981,'1',1756300781),(1953,'accesslib/dirtycontexts','/1/84/2020',1756271981,'1',1756300781),(1954,'accesslib/dirtycontexts','/1/84/2021',1756271982,'1',1756300782),(1955,'accesslib/dirtycontexts','/1/84/2022',1756271982,'1',1756300782),(1956,'accesslib/dirtycontexts','/1/84/2023',1756271982,'1',1756300782),(1957,'accesslib/dirtycontexts','/1/84/2024',1756271982,'1',1756300782),(1958,'accesslib/dirtycontexts','/1/84/2025',1756271983,'1',1756300783),(1959,'accesslib/dirtycontexts','/1/84/2026',1756271983,'1',1756300783),(1960,'accesslib/dirtycontexts','/1/84/2027',1756271983,'1',1756300783),(1961,'accesslib/dirtycontexts','/1/84/2028',1756271983,'1',1756300783),(1962,'accesslib/dirtycontexts','/1/84/2029',1756271984,'1',1756300784),(1963,'accesslib/dirtycontexts','/1/84/2030',1756271984,'1',1756300784),(1964,'accesslib/dirtycontexts','/1/84/2031',1756271984,'1',1756300784),(1965,'accesslib/dirtycontexts','/1/84/2032',1756271984,'1',1756300784),(1966,'accesslib/dirtycontexts','/1/84/2033',1756271985,'1',1756300785),(1967,'accesslib/dirtycontexts','/1/84/2034',1756271985,'1',1756300785),(1968,'accesslib/dirtycontexts','/1/84/2035',1756271985,'1',1756300785),(1969,'accesslib/dirtycontexts','/1/84/2036',1756271985,'1',1756300785),(1970,'accesslib/dirtycontexts','/1/84/2037',1756271986,'1',1756300786),(1971,'accesslib/dirtycontexts','/1/84/2038',1756271986,'1',1756300786),(1972,'accesslib/dirtycontexts','/1/84/2039',1756271986,'1',1756300786),(1973,'accesslib/dirtycontexts','/1/84/2040',1756271986,'1',1756300786),(1974,'accesslib/dirtycontexts','/1/84/2041',1756271987,'1',1756300787),(1975,'accesslib/dirtycontexts','/1/84/2042',1756271987,'1',1756300787),(1976,'accesslib/dirtycontexts','/1/84/2043',1756271987,'1',1756300787),(1977,'accesslib/dirtycontexts','/1/84/2044',1756271987,'1',1756300787),(1978,'accesslib/dirtycontexts','/1/84/2045',1756271987,'1',1756300787),(1979,'accesslib/dirtycontexts','/1/84/2046',1756271988,'1',1756300788),(1980,'accesslib/dirtycontexts','/1/84/2047',1756271988,'1',1756300788),(1981,'accesslib/dirtycontexts','/1/84/2048',1756271988,'1',1756300788),(1982,'accesslib/dirtycontexts','/1/84/2049',1756271988,'1',1756300788),(1983,'accesslib/dirtycontexts','/1/84/2050',1756271988,'1',1756300788),(1984,'accesslib/dirtycontexts','/1/84/2051',1756271989,'1',1756300789),(1985,'accesslib/dirtycontexts','/1/84/2052',1756271989,'1',1756300789),(1986,'accesslib/dirtycontexts','/1/84/2053',1756271989,'1',1756300789),(1987,'accesslib/dirtycontexts','/1/84/2054',1756271989,'1',1756300789),(1988,'accesslib/dirtycontexts','/1/84/2055',1756271990,'1',1756300790),(1989,'accesslib/dirtycontexts','/1/84/2056',1756271990,'1',1756300790),(1990,'accesslib/dirtycontexts','/1/84/2057',1756271990,'1',1756300790),(1991,'accesslib/dirtycontexts','/1/84/2058',1756271990,'1',1756300790),(1992,'accesslib/dirtycontexts','/1/84/2059',1756271990,'1',1756300790),(1993,'accesslib/dirtycontexts','/1/84/2060',1756271991,'1',1756300791),(1994,'accesslib/dirtycontexts','/1/84/2061',1756271991,'1',1756300791),(1995,'accesslib/dirtycontexts','/1/84/2062',1756271991,'1',1756300791),(1996,'accesslib/dirtycontexts','/1/84/2063',1756271991,'1',1756300791),(1997,'accesslib/dirtycontexts','/1/84/2064',1756271991,'1',1756300791),(1998,'accesslib/dirtycontexts','/1/84/2065',1756271992,'1',1756300792),(1999,'accesslib/dirtycontexts','/1/84/2066',1756271992,'1',1756300792),(2000,'accesslib/dirtycontexts','/1/84/2067',1756271992,'1',1756300792),(2001,'accesslib/dirtycontexts','/1/84/2068',1756271992,'1',1756300792),(2002,'accesslib/dirtycontexts','/1/84/2069',1756271992,'1',1756300792),(2003,'accesslib/dirtycontexts','/1/84/2070',1756271992,'1',1756300792),(2004,'accesslib/dirtycontexts','/1/84/2071',1756271993,'1',1756300793),(2005,'accesslib/dirtycontexts','/1/84/2072',1756271993,'1',1756300793),(2006,'accesslib/dirtycontexts','/1/84/2073',1756271993,'1',1756300793),(2007,'accesslib/dirtycontexts','/1/84/2074',1756271994,'1',1756300794),(2008,'accesslib/dirtycontexts','/1/84/2075',1756271994,'1',1756300794),(2009,'accesslib/dirtycontexts','/1/84/2076',1756271994,'1',1756300794),(2010,'accesslib/dirtycontexts','/1/84/2077',1756271994,'1',1756300794),(2011,'accesslib/dirtycontexts','/1/84/2078',1756271994,'1',1756300794),(2012,'accesslib/dirtycontexts','/1/84/2079',1756271994,'1',1756300794),(2013,'accesslib/dirtycontexts','/1/84/2080',1756271995,'1',1756300795),(2014,'accesslib/dirtycontexts','/1/84/2081',1756271995,'1',1756300795),(2015,'accesslib/dirtycontexts','/1/84/2082',1756271995,'1',1756300795),(2016,'accesslib/dirtycontexts','/1/84/2083',1756271995,'1',1756300795),(2017,'accesslib/dirtycontexts','/1/84/2084',1756271995,'1',1756300795),(2018,'accesslib/dirtycontexts','/1/84/2085',1756271996,'1',1756300796),(2019,'accesslib/dirtycontexts','/1/84/2086',1756271996,'1',1756300796),(2020,'accesslib/dirtycontexts','/1/84/2087',1756271996,'1',1756300796),(2021,'accesslib/dirtycontexts','/1/84/2088',1756271996,'1',1756300796),(2022,'accesslib/dirtycontexts','/1/84/2089',1756271996,'1',1756300796),(2023,'accesslib/dirtycontexts','/1/84/2090',1756271997,'1',1756300797),(2024,'accesslib/dirtycontexts','/1/84/2091',1756271997,'1',1756300797),(2025,'accesslib/dirtycontexts','/1/84/2092',1756271997,'1',1756300797),(2026,'accesslib/dirtycontexts','/1/84/2093',1756271997,'1',1756300797),(2027,'accesslib/dirtycontexts','/1/84/2094',1756271997,'1',1756300797),(2028,'accesslib/dirtycontexts','/1/84/2095',1756271998,'1',1756300798),(2029,'accesslib/dirtycontexts','/1/84/2096',1756271998,'1',1756300798),(2030,'accesslib/dirtycontexts','/1/84/2097',1756271998,'1',1756300798),(2031,'accesslib/dirtycontexts','/1/84/2098',1756271998,'1',1756300798),(2032,'accesslib/dirtycontexts','/1/84/2099',1756271999,'1',1756300799),(2033,'accesslib/dirtycontexts','/1/84/2100',1756271999,'1',1756300799),(2034,'accesslib/dirtycontexts','/1/84/2101',1756271999,'1',1756300799),(2035,'accesslib/dirtycontexts','/1/84/2102',1756271999,'1',1756300799),(2036,'accesslib/dirtycontexts','/1/84/2103',1756271999,'1',1756300799),(2037,'accesslib/dirtycontexts','/1/84/2104',1756272000,'1',1756300800),(2038,'accesslib/dirtycontexts','/1/84/2105',1756272000,'1',1756300800),(2039,'accesslib/dirtycontexts','/1/84/2106',1756272000,'1',1756300800),(2040,'accesslib/dirtycontexts','/1/84/2107',1756272000,'1',1756300800),(2041,'accesslib/dirtycontexts','/1/84/2108',1756272000,'1',1756300800),(2042,'accesslib/dirtycontexts','/1/84/2109',1756272001,'1',1756300801),(2043,'accesslib/dirtycontexts','/1/84/2110',1756272001,'1',1756300801),(2044,'accesslib/dirtycontexts','/1/84/2111',1756272001,'1',1756300801),(2045,'accesslib/dirtycontexts','/1/84/2112',1756272001,'1',1756300801),(2046,'accesslib/dirtycontexts','/1/84/2113',1756272001,'1',1756300801),(2047,'accesslib/dirtycontexts','/1/84/2114',1756272002,'1',1756300802),(2048,'accesslib/dirtycontexts','/1/84/2115',1756272002,'1',1756300802),(2049,'accesslib/dirtycontexts','/1/84/2116',1756272002,'1',1756300802),(2050,'accesslib/dirtycontexts','/1/84/2117',1756272002,'1',1756300802),(2051,'accesslib/dirtycontexts','/1/84/2118',1756272002,'1',1756300802),(2052,'accesslib/dirtycontexts','/1/84/2119',1756272003,'1',1756300803),(2053,'accesslib/dirtycontexts','/1/84/2120',1756272003,'1',1756300803),(2054,'accesslib/dirtycontexts','/1/84/2121',1756272003,'1',1756300803),(2055,'accesslib/dirtycontexts','/1/84/2122',1756272003,'1',1756300803),(2056,'accesslib/dirtycontexts','/1/84/2123',1756272004,'1',1756300804),(2057,'accesslib/dirtycontexts','/1/84/2124',1756272004,'1',1756300804),(2058,'accesslib/dirtycontexts','/1/84/2125',1756272004,'1',1756300804),(2059,'accesslib/dirtycontexts','/1/84/2126',1756272004,'1',1756300804),(2060,'accesslib/dirtycontexts','/1/84/2127',1756272004,'1',1756300804),(2061,'accesslib/dirtycontexts','/1/84/2128',1756272005,'1',1756300805),(2062,'accesslib/dirtycontexts','/1/84/2129',1756272005,'1',1756300805),(2063,'accesslib/dirtycontexts','/1/84/2130',1756272005,'1',1756300805),(2064,'accesslib/dirtycontexts','/1/84/2131',1756272006,'1',1756300806),(2065,'accesslib/dirtycontexts','/1/84/2132',1756272006,'1',1756300806),(2066,'accesslib/dirtycontexts','/1/84/2133',1756272006,'1',1756300806),(2067,'accesslib/dirtycontexts','/1/84/2134',1756272007,'1',1756300807),(2068,'accesslib/dirtycontexts','/1/84/2135',1756272007,'1',1756300807),(2069,'accesslib/dirtycontexts','/1/84/2136',1756272007,'1',1756300807),(2070,'accesslib/dirtycontexts','/1/84/2137',1756272007,'1',1756300807),(2071,'accesslib/dirtycontexts','/1/84/2138',1756272008,'1',1756300808),(2072,'accesslib/dirtycontexts','/1/84/2139',1756272008,'1',1756300808),(2073,'accesslib/dirtycontexts','/1/84/2140',1756272008,'1',1756300808),(2074,'accesslib/dirtycontexts','/1/84/2141',1756272008,'1',1756300808),(2075,'accesslib/dirtycontexts','/1/84/2142',1756272008,'1',1756300808),(2076,'accesslib/dirtycontexts','/1/84/2143',1756272009,'1',1756300809),(2077,'accesslib/dirtycontexts','/1/84/2144',1756272009,'1',1756300809),(2078,'accesslib/dirtycontexts','/1/84/2145',1756272009,'1',1756300809),(2079,'accesslib/dirtycontexts','/1/84/2146',1756272009,'1',1756300809),(2080,'accesslib/dirtycontexts','/1/84/2147',1756272009,'1',1756300809),(2081,'accesslib/dirtycontexts','/1/84/2148',1756272010,'1',1756300810),(2082,'accesslib/dirtycontexts','/1/84/2149',1756272010,'1',1756300810),(2083,'accesslib/dirtycontexts','/1/84/2150',1756272010,'1',1756300810),(2084,'accesslib/dirtycontexts','/1/84/2151',1756272010,'1',1756300810),(2085,'accesslib/dirtycontexts','/1/84/2152',1756272010,'1',1756300810),(2086,'accesslib/dirtycontexts','/1/84/2153',1756272011,'1',1756300811),(2087,'accesslib/dirtycontexts','/1/84/2154',1756272011,'1',1756300811),(2088,'accesslib/dirtycontexts','/1/84/2155',1756272011,'1',1756300811),(2089,'accesslib/dirtycontexts','/1/84/2156',1756272011,'1',1756300811),(2090,'accesslib/dirtycontexts','/1/84/2157',1756272011,'1',1756300811),(2091,'accesslib/dirtycontexts','/1/84/2158',1756272012,'1',1756300812),(2092,'accesslib/dirtycontexts','/1/84/2159',1756272012,'1',1756300812),(2093,'accesslib/dirtycontexts','/1/84/2160',1756272012,'1',1756300812),(2094,'accesslib/dirtycontexts','/1/84/2161',1756272012,'1',1756300812),(2095,'accesslib/dirtycontexts','/1/84/2162',1756272012,'1',1756300812),(2096,'accesslib/dirtycontexts','/1/84/2163',1756272013,'1',1756300813),(2097,'accesslib/dirtycontexts','/1/84/2164',1756272013,'1',1756300813),(2098,'accesslib/dirtycontexts','/1/84/2165',1756272013,'1',1756300813),(2099,'accesslib/dirtycontexts','/1/84/2166',1756272013,'1',1756300813),(2100,'accesslib/dirtycontexts','/1/84/2167',1756272013,'1',1756300813),(2101,'accesslib/dirtycontexts','/1/84/2168',1756272014,'1',1756300814),(2102,'accesslib/dirtycontexts','/1/84/2169',1756272014,'1',1756300814),(2103,'accesslib/dirtycontexts','/1/84/2170',1756272014,'1',1756300814),(2104,'accesslib/dirtycontexts','/1/84/2171',1756272014,'1',1756300814),(2105,'accesslib/dirtycontexts','/1/84/2172',1756272014,'1',1756300814),(2106,'accesslib/dirtycontexts','/1/84/2173',1756272015,'1',1756300815),(2107,'accesslib/dirtycontexts','/1/84/2174',1756272015,'1',1756300815),(2108,'accesslib/dirtycontexts','/1/84/2175',1756272015,'1',1756300815),(2109,'accesslib/dirtycontexts','/1/84/2176',1756272015,'1',1756300815),(2110,'accesslib/dirtycontexts','/1/84/2177',1756272016,'1',1756300816),(2111,'accesslib/dirtycontexts','/1/84/2178',1756272017,'1',1756300817),(2112,'accesslib/dirtycontexts','/1/84/2179',1756272017,'1',1756300817),(2113,'accesslib/dirtycontexts','/1/84/2180',1756272018,'1',1756300818),(2114,'accesslib/dirtycontexts','/1/84/2181',1756272018,'1',1756300818),(2115,'accesslib/dirtycontexts','/1/84/2182',1756272019,'1',1756300819),(2116,'accesslib/dirtycontexts','/1/84/2183',1756272020,'1',1756300820),(2117,'accesslib/dirtycontexts','/1/84/2184',1756272021,'1',1756300821),(2118,'accesslib/dirtycontexts','/1/84/2185',1756272021,'1',1756300821),(2119,'accesslib/dirtycontexts','/1/84/2186',1756272022,'1',1756300822),(2120,'accesslib/dirtycontexts','/1/84/2187',1756272022,'1',1756300822),(2121,'accesslib/dirtycontexts','/1/84/2188',1756272023,'1',1756300823),(2122,'accesslib/dirtycontexts','/1/84/2189',1756272023,'1',1756300823),(2123,'accesslib/dirtycontexts','/1/84/2190',1756272023,'1',1756300823),(2124,'accesslib/dirtycontexts','/1/84/2191',1756272023,'1',1756300823),(2125,'accesslib/dirtycontexts','/1/84/2192',1756272024,'1',1756300824),(2126,'accesslib/dirtycontexts','/1/84/2193',1756272024,'1',1756300824),(2127,'accesslib/dirtycontexts','/1/84/2194',1756272024,'1',1756300824),(2128,'accesslib/dirtycontexts','/1/84/2195',1756272024,'1',1756300824),(2129,'accesslib/dirtycontexts','/1/84/2196',1756272024,'1',1756300824),(2130,'accesslib/dirtycontexts','/1/84/2197',1756272025,'1',1756300825),(2131,'accesslib/dirtycontexts','/1/84/2198',1756272025,'1',1756300825),(2132,'accesslib/dirtycontexts','/1/84/2199',1756272025,'1',1756300825),(2133,'accesslib/dirtycontexts','/1/84/2200',1756272025,'1',1756300825),(2134,'accesslib/dirtycontexts','/1/84/2201',1756272025,'1',1756300825),(2135,'accesslib/dirtycontexts','/1/84/2202',1756272026,'1',1756300826),(2136,'accesslib/dirtycontexts','/1/84/2203',1756272026,'1',1756300826),(2137,'accesslib/dirtycontexts','/1/84/2204',1756272026,'1',1756300826),(2138,'accesslib/dirtycontexts','/1/84/2205',1756272027,'1',1756300827),(2139,'accesslib/dirtycontexts','/1/84/2206',1756272027,'1',1756300827),(2140,'accesslib/dirtycontexts','/1/84/2207',1756272027,'1',1756300827),(2141,'accesslib/dirtycontexts','/1/84/2208',1756272027,'1',1756300827),(2142,'accesslib/dirtycontexts','/1/84/2209',1756272027,'1',1756300827),(2143,'accesslib/dirtycontexts','/1/84/2210',1756272028,'1',1756300828),(2144,'accesslib/dirtycontexts','/1/84/2211',1756272028,'1',1756300828),(2145,'accesslib/dirtycontexts','/1/84/2212',1756272028,'1',1756300828),(2146,'accesslib/dirtycontexts','/1/84/2213',1756272028,'1',1756300828),(2147,'accesslib/dirtycontexts','/1/84/2214',1756272028,'1',1756300828),(2148,'accesslib/dirtycontexts','/1/84/2215',1756272029,'1',1756300829),(2149,'accesslib/dirtycontexts','/1/84/2216',1756272029,'1',1756300829),(2150,'accesslib/dirtycontexts','/1/84/2217',1756272029,'1',1756300829),(2151,'accesslib/dirtycontexts','/1/84/2218',1756272029,'1',1756300829),(2152,'accesslib/dirtycontexts','/1/84/2219',1756272030,'1',1756300830),(2153,'accesslib/dirtycontexts','/1/84/2220',1756272030,'1',1756300830),(2154,'accesslib/dirtycontexts','/1/84/2221',1756272030,'1',1756300830),(2155,'accesslib/dirtycontexts','/1/84/2222',1756272030,'1',1756300830),(2156,'accesslib/dirtycontexts','/1/84/2223',1756272031,'1',1756300831),(2157,'accesslib/dirtycontexts','/1/84/2224',1756272032,'1',1756300832),(2158,'accesslib/dirtycontexts','/1/84/2225',1756272033,'1',1756300833),(2159,'accesslib/dirtycontexts','/1/84/2226',1756272034,'1',1756300834),(2160,'accesslib/dirtycontexts','/1/84/2227',1756272035,'1',1756300835),(2161,'accesslib/dirtycontexts','/1/84/2228',1756272036,'1',1756300836),(2162,'accesslib/dirtycontexts','/1/84/2229',1756272038,'1',1756300838),(2163,'accesslib/dirtycontexts','/1/84/2230',1756272039,'1',1756300839),(2164,'accesslib/dirtycontexts','/1/84/2231',1756272040,'1',1756300840),(2165,'accesslib/dirtycontexts','/1/84/2232',1756272040,'1',1756300840),(2166,'accesslib/dirtycontexts','/1/84/2233',1756272040,'1',1756300840),(2167,'accesslib/dirtycontexts','/1/84/2234',1756272040,'1',1756300840),(2168,'accesslib/dirtycontexts','/1/84/2235',1756272041,'1',1756300841),(2169,'accesslib/dirtycontexts','/1/84/2236',1756272041,'1',1756300841),(2170,'accesslib/dirtycontexts','/1/84/2237',1756272041,'1',1756300841),(2171,'accesslib/dirtycontexts','/1/84/2238',1756272041,'1',1756300841),(2172,'accesslib/dirtycontexts','/1/84/2239',1756272042,'1',1756300842),(2173,'accesslib/dirtycontexts','/1/84/2240',1756272042,'1',1756300842),(2174,'accesslib/dirtycontexts','/1/84/2241',1756272042,'1',1756300842),(2175,'accesslib/dirtycontexts','/1/84/2242',1756272042,'1',1756300842),(2176,'accesslib/dirtycontexts','/1/84/2243',1756272042,'1',1756300842),(2177,'accesslib/dirtycontexts','/1/84/2244',1756272043,'1',1756300843),(2178,'accesslib/dirtycontexts','/1/84/2245',1756272043,'1',1756300843),(2179,'accesslib/dirtycontexts','/1/84/2246',1756272043,'1',1756300843),(2180,'accesslib/dirtycontexts','/1/84/2247',1756272043,'1',1756300843),(2181,'accesslib/dirtycontexts','/1/84/2248',1756272043,'1',1756300843),(2182,'accesslib/dirtycontexts','/1/84/2249',1756272043,'1',1756300843),(2183,'accesslib/dirtycontexts','/1/84/2250',1756272044,'1',1756300844),(2184,'accesslib/dirtycontexts','/1/84/2251',1756272044,'1',1756300844),(2185,'accesslib/dirtycontexts','/1/84/2252',1756272044,'1',1756300844),(2186,'accesslib/dirtycontexts','/1/84/2253',1756272044,'1',1756300844),(2187,'accesslib/dirtycontexts','/1/84/2254',1756272044,'1',1756300844),(2188,'accesslib/dirtycontexts','/1/84/2255',1756272045,'1',1756300845),(2189,'accesslib/dirtycontexts','/1/84/2256',1756272045,'1',1756300845),(2190,'accesslib/dirtycontexts','/1/84/2257',1756272045,'1',1756300845),(2191,'accesslib/dirtycontexts','/1/84/2258',1756272045,'1',1756300845),(2192,'accesslib/dirtycontexts','/1/84/2259',1756272045,'1',1756300845),(2193,'accesslib/dirtycontexts','/1/84/2260',1756272046,'1',1756300846),(2194,'accesslib/dirtycontexts','/1/84/2261',1756272046,'1',1756300846),(2195,'accesslib/dirtycontexts','/1/84/2262',1756272046,'1',1756300846),(2196,'accesslib/dirtycontexts','/1/84/2263',1756272046,'1',1756300846),(2197,'accesslib/dirtycontexts','/1/84/2264',1756272046,'1',1756300846),(2198,'accesslib/dirtycontexts','/1/84/2265',1756272047,'1',1756300847),(2199,'accesslib/dirtycontexts','/1/84/2266',1756272047,'1',1756300847),(2200,'accesslib/dirtycontexts','/1/84/2267',1756272047,'1',1756300847),(2201,'accesslib/dirtycontexts','/1/84/2268',1756272047,'1',1756300847),(2202,'accesslib/dirtycontexts','/1/84/2269',1756272047,'1',1756300847),(2203,'accesslib/dirtycontexts','/1/84/2270',1756272048,'1',1756300848),(2204,'accesslib/dirtycontexts','/1/84/2271',1756272048,'1',1756300848),(2205,'accesslib/dirtycontexts','/1/84/2272',1756272048,'1',1756300848),(2206,'accesslib/dirtycontexts','/1/84/2273',1756272048,'1',1756300848),(2207,'accesslib/dirtycontexts','/1/84/2274',1756272048,'1',1756300848),(2208,'accesslib/dirtycontexts','/1/84/2275',1756272048,'1',1756300848),(2209,'accesslib/dirtycontexts','/1/84/2276',1756272049,'1',1756300849),(2210,'accesslib/dirtycontexts','/1/84/2277',1756272049,'1',1756300849),(2211,'accesslib/dirtycontexts','/1/84/2278',1756272049,'1',1756300849),(2212,'accesslib/dirtycontexts','/1/84/2279',1756272049,'1',1756300849),(2213,'accesslib/dirtycontexts','/1/84/2280',1756272049,'1',1756300849),(2214,'accesslib/dirtycontexts','/1/84/2281',1756272050,'1',1756300850),(2215,'accesslib/dirtycontexts','/1/84/2282',1756272050,'1',1756300850),(2216,'accesslib/dirtycontexts','/1/84/2283',1756272050,'1',1756300850),(2217,'accesslib/dirtycontexts','/1/84/2284',1756272050,'1',1756300850),(2218,'accesslib/dirtycontexts','/1/84/2285',1756272050,'1',1756300850),(2219,'accesslib/dirtycontexts','/1/84/2286',1756272051,'1',1756300851),(2220,'accesslib/dirtycontexts','/1/84/2287',1756272051,'1',1756300851),(2221,'accesslib/dirtycontexts','/1/84/2288',1756272051,'1',1756300851),(2222,'accesslib/dirtycontexts','/1/84/2289',1756272051,'1',1756300851),(2223,'accesslib/dirtycontexts','/1/84/2290',1756272051,'1',1756300851),(2224,'accesslib/dirtycontexts','/1/84/2291',1756272052,'1',1756300852),(2225,'accesslib/dirtycontexts','/1/84/2292',1756272052,'1',1756300852),(2226,'accesslib/dirtycontexts','/1/84/2293',1756272052,'1',1756300852),(2227,'accesslib/dirtycontexts','/1/84/2294',1756272052,'1',1756300852),(2228,'accesslib/dirtycontexts','/1/84/2295',1756272052,'1',1756300852),(2229,'accesslib/dirtycontexts','/1/84/2296',1756272053,'1',1756300853),(2230,'accesslib/dirtycontexts','/1/84/2297',1756272053,'1',1756300853),(2231,'accesslib/dirtycontexts','/1/84/2298',1756272053,'1',1756300853),(2232,'accesslib/dirtycontexts','/1/84/2299',1756272053,'1',1756300853),(2233,'accesslib/dirtycontexts','/1/84/2300',1756272053,'1',1756300853),(2234,'accesslib/dirtycontexts','/1/84/2301',1756272053,'1',1756300853),(2235,'accesslib/dirtycontexts','/1/84/2302',1756272054,'1',1756300854),(2236,'accesslib/dirtycontexts','/1/84/2303',1756272054,'1',1756300854),(2237,'accesslib/dirtycontexts','/1/84/2304',1756272054,'1',1756300854),(2238,'accesslib/dirtycontexts','/1/84/2305',1756272054,'1',1756300854),(2239,'accesslib/dirtycontexts','/1/84/2306',1756272054,'1',1756300854),(2240,'accesslib/dirtycontexts','/1/84/2307',1756272055,'1',1756300855),(2241,'accesslib/dirtycontexts','/1/84/2308',1756272055,'1',1756300855),(2242,'accesslib/dirtycontexts','/1/84/2309',1756272055,'1',1756300855),(2243,'accesslib/dirtycontexts','/1/84/2310',1756272055,'1',1756300855),(2244,'accesslib/dirtycontexts','/1/84/2311',1756272055,'1',1756300855),(2245,'accesslib/dirtycontexts','/1/84/2312',1756272056,'1',1756300856),(2246,'accesslib/dirtycontexts','/1/84/2313',1756272056,'1',1756300856),(2247,'accesslib/dirtycontexts','/1/84/2314',1756272056,'1',1756300856),(2248,'accesslib/dirtycontexts','/1/84/2315',1756272056,'1',1756300856),(2249,'accesslib/dirtycontexts','/1/84/2316',1756272056,'1',1756300856),(2250,'accesslib/dirtycontexts','/1/84/2317',1756272057,'1',1756300857),(2251,'accesslib/dirtycontexts','/1/84/2318',1756272057,'1',1756300857),(2252,'accesslib/dirtycontexts','/1/84/2319',1756272057,'1',1756300857),(2253,'accesslib/dirtycontexts','/1/84/2320',1756272057,'1',1756300857),(2254,'accesslib/dirtycontexts','/1/84/2321',1756272057,'1',1756300857),(2255,'accesslib/dirtycontexts','/1/84/2322',1756272058,'1',1756300858),(2256,'accesslib/dirtycontexts','/1/84/2323',1756272058,'1',1756300858),(2257,'accesslib/dirtycontexts','/1/84/2324',1756272058,'1',1756300858),(2258,'accesslib/dirtycontexts','/1/84/2325',1756272058,'1',1756300858),(2259,'accesslib/dirtycontexts','/1/84/2326',1756272058,'1',1756300858),(2260,'accesslib/dirtycontexts','/1/84/2327',1756272059,'1',1756300859),(2261,'accesslib/dirtycontexts','/1/84/2328',1756272059,'1',1756300859),(2262,'accesslib/dirtycontexts','/1/84/2329',1756272059,'1',1756300859),(2263,'accesslib/dirtycontexts','/1/84/2330',1756272059,'1',1756300859),(2264,'accesslib/dirtycontexts','/1/84/2331',1756272060,'1',1756300860),(2265,'accesslib/dirtycontexts','/1/84/2332',1756272060,'1',1756300860),(2266,'accesslib/dirtycontexts','/1/84/2333',1756272060,'1',1756300860),(2267,'accesslib/dirtycontexts','/1/84/2334',1756272060,'1',1756300860),(2268,'accesslib/dirtycontexts','/1/84/2335',1756272061,'1',1756300861),(2269,'accesslib/dirtycontexts','/1/84/2336',1756272061,'1',1756300861),(2270,'accesslib/dirtycontexts','/1/84/2337',1756272061,'1',1756300861),(2271,'accesslib/dirtycontexts','/1/84/2338',1756272061,'1',1756300861),(2272,'accesslib/dirtycontexts','/1/84/2339',1756272061,'1',1756300861),(2273,'accesslib/dirtycontexts','/1/84/2340',1756272062,'1',1756300862),(2274,'accesslib/dirtycontexts','/1/84/2341',1756272062,'1',1756300862),(2275,'accesslib/dirtycontexts','/1/84/2342',1756272062,'1',1756300862),(2276,'accesslib/dirtycontexts','/1/84/2343',1756272062,'1',1756300862),(2277,'accesslib/dirtycontexts','/1/84/2344',1756272063,'1',1756300863),(2278,'accesslib/dirtycontexts','/1/84/2345',1756272063,'1',1756300863),(2279,'accesslib/dirtycontexts','/1/84/2346',1756272063,'1',1756300863),(2280,'accesslib/dirtycontexts','/1/84/2347',1756272063,'1',1756300863),(2281,'accesslib/dirtycontexts','/1/84/2348',1756272063,'1',1756300863),(2282,'accesslib/dirtycontexts','/1/84/2349',1756272064,'1',1756300864),(2283,'accesslib/dirtycontexts','/1/84/2350',1756272064,'1',1756300864),(2284,'accesslib/dirtycontexts','/1/84/2351',1756272064,'1',1756300864),(2285,'accesslib/dirtycontexts','/1/84/2352',1756272064,'1',1756300864),(2286,'accesslib/dirtycontexts','/1/84/2353',1756272065,'1',1756300865),(2287,'accesslib/dirtycontexts','/1/84/2354',1756272065,'1',1756300865),(2288,'accesslib/dirtycontexts','/1/84/2355',1756272065,'1',1756300865),(2289,'accesslib/dirtycontexts','/1/84/2356',1756272065,'1',1756300865),(2290,'accesslib/dirtycontexts','/1/84/2357',1756272066,'1',1756300866),(2291,'accesslib/dirtycontexts','/1/84/2358',1756272066,'1',1756300866),(2292,'accesslib/dirtycontexts','/1/84/2359',1756272066,'1',1756300866),(2293,'accesslib/dirtycontexts','/1/84/2360',1756272066,'1',1756300866),(2294,'accesslib/dirtycontexts','/1/84/2361',1756272066,'1',1756300866),(2295,'accesslib/dirtycontexts','/1/84/2362',1756272066,'1',1756300866),(2296,'accesslib/dirtycontexts','/1/84/2363',1756272067,'1',1756300867),(2297,'accesslib/dirtycontexts','/1/84/2364',1756272067,'1',1756300867),(2298,'accesslib/dirtycontexts','/1/84/2365',1756272067,'1',1756300867),(2299,'accesslib/dirtycontexts','/1/84/2366',1756272067,'1',1756300867),(2300,'accesslib/dirtycontexts','/1/84/2367',1756272067,'1',1756300867),(2301,'accesslib/dirtycontexts','/1/84/2368',1756272068,'1',1756300868),(2302,'accesslib/dirtycontexts','/1/84/2369',1756272068,'1',1756300868),(2303,'accesslib/dirtycontexts','/1/84/2370',1756272068,'1',1756300868),(2304,'accesslib/dirtycontexts','/1/84/2371',1756272068,'1',1756300868),(2305,'accesslib/dirtycontexts','/1/84/2372',1756272068,'1',1756300868),(2306,'accesslib/dirtycontexts','/1/84/2373',1756272069,'1',1756300869),(2307,'accesslib/dirtycontexts','/1/84/2374',1756272069,'1',1756300869),(2308,'accesslib/dirtycontexts','/1/84/2375',1756272069,'1',1756300869),(2309,'accesslib/dirtycontexts','/1/84/2376',1756272069,'1',1756300869),(2310,'accesslib/dirtycontexts','/1/84/2377',1756272069,'1',1756300869),(2311,'accesslib/dirtycontexts','/1/84/2378',1756272070,'1',1756300870),(2312,'accesslib/dirtycontexts','/1/84/2379',1756272070,'1',1756300870),(2313,'accesslib/dirtycontexts','/1/84/2380',1756272070,'1',1756300870),(2314,'accesslib/dirtycontexts','/1/84/2381',1756272070,'1',1756300870),(2315,'accesslib/dirtycontexts','/1/84/2382',1756272070,'1',1756300870),(2316,'accesslib/dirtycontexts','/1/84/2383',1756272071,'1',1756300871),(2317,'accesslib/dirtycontexts','/1/84/2384',1756272071,'1',1756300871),(2318,'accesslib/dirtycontexts','/1/84/2385',1756272071,'1',1756300871),(2319,'accesslib/dirtycontexts','/1/84/2386',1756272071,'1',1756300871),(2320,'accesslib/dirtycontexts','/1/84/2387',1756272071,'1',1756300871),(2321,'accesslib/dirtycontexts','/1/84/2388',1756272072,'1',1756300872),(2322,'accesslib/dirtycontexts','/1/84/2389',1756272072,'1',1756300872),(2323,'accesslib/dirtycontexts','/1/84/2390',1756272072,'1',1756300872),(2324,'accesslib/dirtycontexts','/1/84/2391',1756272072,'1',1756300872),(2325,'accesslib/dirtycontexts','/1/84/2392',1756272072,'1',1756300872),(2326,'accesslib/dirtycontexts','/1/84/2393',1756272073,'1',1756300873),(2327,'accesslib/dirtycontexts','/1/84/2394',1756272073,'1',1756300873),(2328,'accesslib/dirtycontexts','/1/84/2395',1756272073,'1',1756300873),(2329,'accesslib/dirtycontexts','/1/84/2396',1756272073,'1',1756300873),(2330,'accesslib/dirtycontexts','/1/84/2397',1756272073,'1',1756300873),(2331,'accesslib/dirtycontexts','/1/84/2398',1756272074,'1',1756300874),(2332,'accesslib/dirtycontexts','/1/84/2399',1756272074,'1',1756300874),(2333,'accesslib/dirtycontexts','/1/84/2400',1756272074,'1',1756300874),(2334,'accesslib/dirtycontexts','/1/84/2401',1756272074,'1',1756300874),(2335,'accesslib/dirtycontexts','/1/84/2402',1756272074,'1',1756300874),(2336,'accesslib/dirtycontexts','/1/84/2403',1756272075,'1',1756300875),(2337,'accesslib/dirtycontexts','/1/84/2404',1756272075,'1',1756300875),(2338,'accesslib/dirtycontexts','/1/84/2405',1756272075,'1',1756300875),(2339,'accesslib/dirtycontexts','/1/84/2406',1756272075,'1',1756300875),(2340,'accesslib/dirtycontexts','/1/84/2407',1756272075,'1',1756300875),(2341,'accesslib/dirtycontexts','/1/84/2408',1756272076,'1',1756300876),(2342,'accesslib/dirtycontexts','/1/84/2409',1756272076,'1',1756300876),(2343,'accesslib/dirtycontexts','/1/84/2410',1756272076,'1',1756300876),(2344,'accesslib/dirtycontexts','/1/84/2411',1756272076,'1',1756300876),(2345,'accesslib/dirtycontexts','/1/84/2412',1756272076,'1',1756300876),(2346,'accesslib/dirtycontexts','/1/84/2413',1756272077,'1',1756300877),(2347,'accesslib/dirtycontexts','/1/84/2414',1756272077,'1',1756300877),(2348,'accesslib/dirtycontexts','/1/84/2415',1756272077,'1',1756300877),(2349,'accesslib/dirtycontexts','/1/84/2416',1756272077,'1',1756300877),(2350,'accesslib/dirtycontexts','/1/84/2417',1756272077,'1',1756300877),(2351,'accesslib/dirtycontexts','/1/84/2418',1756272078,'1',1756300878),(2352,'accesslib/dirtycontexts','/1/84/2419',1756272078,'1',1756300878),(2353,'accesslib/dirtycontexts','/1/84/2420',1756272078,'1',1756300878),(2354,'accesslib/dirtycontexts','/1/84/2421',1756272078,'1',1756300878),(2355,'accesslib/dirtycontexts','/1/84/2422',1756272078,'1',1756300878),(2356,'accesslib/dirtycontexts','/1/84/2423',1756272079,'1',1756300879),(2357,'accesslib/dirtycontexts','/1/84/2424',1756272079,'1',1756300879),(2358,'accesslib/dirtycontexts','/1/84/2425',1756272079,'1',1756300879),(2359,'accesslib/dirtycontexts','/1/84/2426',1756272079,'1',1756300879),(2360,'accesslib/dirtycontexts','/1/84/2427',1756272079,'1',1756300879),(2361,'accesslib/dirtycontexts','/1/84/2428',1756272079,'1',1756300879),(2362,'accesslib/dirtycontexts','/1/84/2429',1756272080,'1',1756300880),(2363,'accesslib/dirtycontexts','/1/84/2430',1756272080,'1',1756300880),(2364,'accesslib/dirtycontexts','/1/84/2431',1756272080,'1',1756300880),(2365,'accesslib/dirtycontexts','/1/84/2432',1756272080,'1',1756300880),(2366,'accesslib/dirtycontexts','/1/84/2433',1756272080,'1',1756300880),(2367,'accesslib/dirtycontexts','/1/84/2434',1756272081,'1',1756300881),(2368,'accesslib/dirtycontexts','/1/84/2435',1756272081,'1',1756300881),(2369,'accesslib/dirtycontexts','/1/84/2436',1756272081,'1',1756300881),(2370,'accesslib/dirtycontexts','/1/84/2437',1756272081,'1',1756300881),(2371,'accesslib/dirtycontexts','/1/84/2438',1756272081,'1',1756300881),(2372,'accesslib/dirtycontexts','/1/84/2439',1756272082,'1',1756300882),(2373,'accesslib/dirtycontexts','/1/84/2440',1756272082,'1',1756300882),(2374,'accesslib/dirtycontexts','/1/84/2441',1756272082,'1',1756300882),(2375,'accesslib/dirtycontexts','/1/84/2442',1756272082,'1',1756300882),(2376,'accesslib/dirtycontexts','/1/84/2443',1756272082,'1',1756300882),(2377,'accesslib/dirtycontexts','/1/84/2444',1756272083,'1',1756300883),(2378,'accesslib/dirtycontexts','/1/84/2445',1756272083,'1',1756300883),(2379,'accesslib/dirtycontexts','/1/84/2446',1756272083,'1',1756300883),(2380,'accesslib/dirtycontexts','/1/84/2447',1756272083,'1',1756300883),(2381,'accesslib/dirtycontexts','/1/84/2448',1756272084,'1',1756300884),(2382,'accesslib/dirtycontexts','/1/84/2449',1756272084,'1',1756300884),(2383,'accesslib/dirtycontexts','/1/84/2450',1756272084,'1',1756300884),(2384,'accesslib/dirtycontexts','/1/84/2451',1756272084,'1',1756300884),(2385,'accesslib/dirtycontexts','/1/84/2452',1756272084,'1',1756300884),(2386,'accesslib/dirtycontexts','/1/84/2453',1756272084,'1',1756300884),(2387,'accesslib/dirtycontexts','/1/84/2454',1756272085,'1',1756300885),(2388,'accesslib/dirtycontexts','/1/84/2455',1756272085,'1',1756300885),(2389,'accesslib/dirtycontexts','/1/84/2456',1756272085,'1',1756300885),(2390,'accesslib/dirtycontexts','/1/84/2457',1756272085,'1',1756300885),(2391,'accesslib/dirtycontexts','/1/84/2458',1756272085,'1',1756300885),(2392,'accesslib/dirtycontexts','/1/84/2459',1756272086,'1',1756300886),(2393,'accesslib/dirtycontexts','/1/84/2460',1756272086,'1',1756300886),(2394,'accesslib/dirtycontexts','/1/84/2461',1756272086,'1',1756300886),(2395,'accesslib/dirtycontexts','/1/84/2462',1756272086,'1',1756300886),(2396,'accesslib/dirtycontexts','/1/84/2463',1756272086,'1',1756300886),(2397,'accesslib/dirtycontexts','/1/84/2464',1756272087,'1',1756300887),(2398,'accesslib/dirtycontexts','/1/84/2465',1756272087,'1',1756300887),(2399,'accesslib/dirtycontexts','/1/84/2466',1756272087,'1',1756300887),(2400,'accesslib/dirtycontexts','/1/84/2467',1756272087,'1',1756300887),(2401,'accesslib/dirtycontexts','/1/84/2468',1756272087,'1',1756300887),(2402,'accesslib/dirtycontexts','/1/84/2469',1756272088,'1',1756300888),(2403,'accesslib/dirtycontexts','/1/84/2470',1756272088,'1',1756300888),(2404,'accesslib/dirtycontexts','/1/84/2471',1756272088,'1',1756300888),(2405,'accesslib/dirtycontexts','/1/84/2472',1756272088,'1',1756300888),(2406,'accesslib/dirtycontexts','/1/84/2473',1756272089,'1',1756300889),(2407,'accesslib/dirtycontexts','/1/84/2474',1756272089,'1',1756300889),(2408,'accesslib/dirtycontexts','/1/84/2475',1756272089,'1',1756300889),(2409,'accesslib/dirtycontexts','/1/84/2476',1756272089,'1',1756300889),(2410,'accesslib/dirtycontexts','/1/84/2477',1756272089,'1',1756300889),(2411,'accesslib/dirtycontexts','/1/84/2478',1756272090,'1',1756300890),(2412,'accesslib/dirtycontexts','/1/84/2479',1756272090,'1',1756300890),(2413,'accesslib/dirtycontexts','/1/84/2480',1756272090,'1',1756300890),(2414,'accesslib/dirtycontexts','/1/84/2481',1756272090,'1',1756300890),(2415,'accesslib/dirtycontexts','/1/84/2482',1756272090,'1',1756300890),(2416,'accesslib/dirtycontexts','/1/84/2483',1756272091,'1',1756300891),(2417,'accesslib/dirtycontexts','/1/84/2484',1756272091,'1',1756300891),(2418,'accesslib/dirtycontexts','/1/84/2485',1756272091,'1',1756300891),(2419,'accesslib/dirtycontexts','/1/84/2486',1756272091,'1',1756300891),(2420,'accesslib/dirtycontexts','/1/84/2487',1756272091,'1',1756300891),(2421,'accesslib/dirtycontexts','/1/84/2488',1756272092,'1',1756300892),(2422,'accesslib/dirtycontexts','/1/84/2489',1756272092,'1',1756300892),(2423,'accesslib/dirtycontexts','/1/84/2490',1756272092,'1',1756300892),(2424,'accesslib/dirtycontexts','/1/84/2491',1756272092,'1',1756300892),(2425,'accesslib/dirtycontexts','/1/84/2492',1756272092,'1',1756300892),(2426,'accesslib/dirtycontexts','/1/84/2493',1756272093,'1',1756300893),(2427,'accesslib/dirtycontexts','/1/84/2494',1756272093,'1',1756300893),(2428,'accesslib/dirtycontexts','/1/84/2495',1756272093,'1',1756300893),(2429,'accesslib/dirtycontexts','/1/84/2496',1756272093,'1',1756300893),(2430,'accesslib/dirtycontexts','/1/84/2497',1756272093,'1',1756300893),(2431,'accesslib/dirtycontexts','/1/84/2498',1756272093,'1',1756300893),(2432,'accesslib/dirtycontexts','/1/84/2499',1756272094,'1',1756300894),(2433,'accesslib/dirtycontexts','/1/84/2500',1756272094,'1',1756300894),(2434,'accesslib/dirtycontexts','/1/84/2501',1756272094,'1',1756300894),(2435,'accesslib/dirtycontexts','/1/84/2502',1756272094,'1',1756300894),(2436,'accesslib/dirtycontexts','/1/84/2503',1756272094,'1',1756300894),(2437,'accesslib/dirtycontexts','/1/84/2504',1756272095,'1',1756300895),(2438,'accesslib/dirtycontexts','/1/84/2505',1756272095,'1',1756300895),(2439,'accesslib/dirtycontexts','/1/84/2506',1756272095,'1',1756300895),(2440,'accesslib/dirtycontexts','/1/84/2507',1756272095,'1',1756300895),(2441,'accesslib/dirtycontexts','/1/84/2508',1756272095,'1',1756300895),(2442,'accesslib/dirtycontexts','/1/84/2509',1756272096,'1',1756300896),(2443,'accesslib/dirtycontexts','/1/84/2510',1756272096,'1',1756300896),(2444,'accesslib/dirtycontexts','/1/84/2511',1756272096,'1',1756300896),(2445,'accesslib/dirtycontexts','/1/84/2512',1756272096,'1',1756300896),(2446,'accesslib/dirtycontexts','/1/84/2513',1756272096,'1',1756300896),(2447,'accesslib/dirtycontexts','/1/84/2514',1756272097,'1',1756300897),(2448,'accesslib/dirtycontexts','/1/84/2515',1756272097,'1',1756300897),(2449,'accesslib/dirtycontexts','/1/84/2516',1756272097,'1',1756300897),(2450,'accesslib/dirtycontexts','/1/84/2517',1756272097,'1',1756300897),(2451,'accesslib/dirtycontexts','/1/84/2518',1756272098,'1',1756300898),(2452,'accesslib/dirtycontexts','/1/84/2519',1756272098,'1',1756300898),(2453,'accesslib/dirtycontexts','/1/84/2520',1756272098,'1',1756300898),(2454,'accesslib/dirtycontexts','/1/84/2521',1756272098,'1',1756300898),(2455,'accesslib/dirtycontexts','/1/84/2522',1756272098,'1',1756300898),(2456,'accesslib/dirtycontexts','/1/84/2523',1756272099,'1',1756300899),(2457,'accesslib/dirtycontexts','/1/84/2524',1756272099,'1',1756300899),(2458,'accesslib/dirtycontexts','/1/84/2525',1756272099,'1',1756300899),(2459,'accesslib/dirtycontexts','/1/84/2526',1756272099,'1',1756300899),(2460,'accesslib/dirtycontexts','/1/84/2527',1756272099,'1',1756300899),(2461,'accesslib/dirtycontexts','/1/84/2528',1756272100,'1',1756300900),(2462,'accesslib/dirtycontexts','/1/84/2529',1756272100,'1',1756300900),(2463,'accesslib/dirtycontexts','/1/84/2530',1756272100,'1',1756300900),(2464,'accesslib/dirtycontexts','/1/84/2531',1756272100,'1',1756300900),(2465,'accesslib/dirtycontexts','/1/84/2532',1756272100,'1',1756300900),(2466,'accesslib/dirtycontexts','/1/84/2533',1756272101,'1',1756300901),(2467,'accesslib/dirtycontexts','/1/84/2534',1756272101,'1',1756300901),(2468,'accesslib/dirtycontexts','/1/84/2535',1756272101,'1',1756300901),(2469,'accesslib/dirtycontexts','/1/84/2536',1756272101,'1',1756300901),(2470,'accesslib/dirtycontexts','/1/84/2537',1756272101,'1',1756300901),(2471,'accesslib/dirtycontexts','/1/84/2538',1756272101,'1',1756300901),(2472,'accesslib/dirtycontexts','/1/84/2539',1756272102,'1',1756300902),(2473,'accesslib/dirtycontexts','/1/84/2540',1756272102,'1',1756300902),(2474,'accesslib/dirtycontexts','/1/84/2541',1756272102,'1',1756300902),(2475,'accesslib/dirtycontexts','/1/84/2542',1756272102,'1',1756300902),(2476,'accesslib/dirtycontexts','/1/84/2543',1756272102,'1',1756300902),(2477,'accesslib/dirtycontexts','/1/84/2544',1756272103,'1',1756300903),(2478,'accesslib/dirtycontexts','/1/84/2545',1756272103,'1',1756300903),(2479,'accesslib/dirtycontexts','/1/84/2546',1756272103,'1',1756300903),(2480,'accesslib/dirtycontexts','/1/84/2547',1756272103,'1',1756300903),(2481,'accesslib/dirtycontexts','/1/84/2548',1756272104,'1',1756300904),(2482,'accesslib/dirtycontexts','/1/84/2549',1756272104,'1',1756300904),(2483,'accesslib/dirtycontexts','/1/84/2550',1756272104,'1',1756300904),(2484,'accesslib/dirtycontexts','/1/84/2551',1756272104,'1',1756300904),(2485,'accesslib/dirtycontexts','/1/84/2552',1756272105,'1',1756300905),(2486,'accesslib/dirtycontexts','/1/84/2553',1756272105,'1',1756300905),(2487,'accesslib/dirtycontexts','/1/84/2554',1756272106,'1',1756300906),(2488,'accesslib/dirtycontexts','/1/84/2555',1756272106,'1',1756300906),(2489,'accesslib/dirtycontexts','/1/84/2556',1756272106,'1',1756300906),(2490,'accesslib/dirtycontexts','/1/84/2557',1756272107,'1',1756300907),(2491,'accesslib/dirtycontexts','/1/84/2558',1756272107,'1',1756300907),(2492,'accesslib/dirtycontexts','/1/84/2559',1756272107,'1',1756300907),(2493,'accesslib/dirtycontexts','/1/84/2560',1756272107,'1',1756300907),(2494,'accesslib/dirtycontexts','/1/84/2561',1756272107,'1',1756300907),(2495,'accesslib/dirtycontexts','/1/84/2562',1756272108,'1',1756300908),(2496,'accesslib/dirtycontexts','/1/84/2563',1756272108,'1',1756300908),(2497,'accesslib/dirtycontexts','/1/84/2564',1756272108,'1',1756300908),(2498,'accesslib/dirtycontexts','/1/84/2565',1756272108,'1',1756300908),(2499,'accesslib/dirtycontexts','/1/84/2566',1756272108,'1',1756300908),(2500,'accesslib/dirtycontexts','/1/84/2567',1756272109,'1',1756300909),(2501,'accesslib/dirtycontexts','/1/84/2568',1756272109,'1',1756300909),(2502,'accesslib/dirtycontexts','/1/84/2569',1756272109,'1',1756300909),(2503,'accesslib/dirtycontexts','/1/84/2570',1756272109,'1',1756300909),(2504,'accesslib/dirtycontexts','/1/84/2571',1756272109,'1',1756300909),(2505,'accesslib/dirtycontexts','/1/84/2572',1756272110,'1',1756300910),(2506,'accesslib/dirtycontexts','/1/84/2573',1756272110,'1',1756300910),(2507,'accesslib/dirtycontexts','/1/84/2574',1756272110,'1',1756300910),(2508,'accesslib/dirtycontexts','/1/84/2575',1756272110,'1',1756300910),(2509,'accesslib/dirtycontexts','/1/84/2576',1756272110,'1',1756300910),(2510,'accesslib/dirtycontexts','/1/84/2577',1756272111,'1',1756300911),(2511,'accesslib/dirtycontexts','/1/84/2578',1756272111,'1',1756300911),(2512,'accesslib/dirtycontexts','/1/84/2579',1756272111,'1',1756300911),(2513,'accesslib/dirtycontexts','/1/84/2580',1756272111,'1',1756300911),(2514,'accesslib/dirtycontexts','/1/84/2581',1756272111,'1',1756300911),(2515,'accesslib/dirtycontexts','/1/84/2582',1756272112,'1',1756300912),(2516,'accesslib/dirtycontexts','/1/84/2583',1756272112,'1',1756300912),(2517,'accesslib/dirtycontexts','/1/84/2584',1756272112,'1',1756300912),(2518,'accesslib/dirtycontexts','/1/84/2585',1756272112,'1',1756300912),(2519,'accesslib/dirtycontexts','/1/84/2586',1756272112,'1',1756300912),(2520,'accesslib/dirtycontexts','/1/84/2587',1756272113,'1',1756300913),(2521,'accesslib/dirtycontexts','/1/84/2588',1756272113,'1',1756300913),(2522,'accesslib/dirtycontexts','/1/84/2589',1756272113,'1',1756300913),(2523,'accesslib/dirtycontexts','/1/84/2590',1756272113,'1',1756300913),(2524,'accesslib/dirtycontexts','/1/84/2591',1756272113,'1',1756300913),(2525,'accesslib/dirtycontexts','/1/84/2592',1756272114,'1',1756300914),(2526,'accesslib/dirtycontexts','/1/84/2593',1756272114,'1',1756300914),(2527,'accesslib/dirtycontexts','/1/84/2594',1756272114,'1',1756300914),(2528,'accesslib/dirtycontexts','/1/84/2595',1756272114,'1',1756300914),(2529,'accesslib/dirtycontexts','/1/84/2596',1756272114,'1',1756300914),(2530,'accesslib/dirtycontexts','/1/84/2597',1756272115,'1',1756300915),(2531,'accesslib/dirtycontexts','/1/84/2598',1756272115,'1',1756300915),(2532,'accesslib/dirtycontexts','/1/84/2599',1756272115,'1',1756300915),(2533,'accesslib/dirtycontexts','/1/84/2600',1756272115,'1',1756300915),(2534,'accesslib/dirtycontexts','/1/84/2601',1756272115,'1',1756300915),(2535,'accesslib/dirtycontexts','/1/84/2602',1756272116,'1',1756300916),(2536,'accesslib/dirtycontexts','/1/84/2603',1756272116,'1',1756300916),(2537,'accesslib/dirtycontexts','/1/84/2604',1756272116,'1',1756300916),(2538,'accesslib/dirtycontexts','/1/84/2605',1756272116,'1',1756300916),(2539,'accesslib/dirtycontexts','/1/84/2606',1756272117,'1',1756300917),(2540,'accesslib/dirtycontexts','/1/84/2607',1756272117,'1',1756300917),(2541,'accesslib/dirtycontexts','/1/84/2608',1756272117,'1',1756300917),(2542,'accesslib/dirtycontexts','/1/84/2609',1756272117,'1',1756300917),(2543,'accesslib/dirtycontexts','/1/84/2610',1756272117,'1',1756300917),(2544,'accesslib/dirtycontexts','/1/84/2611',1756272118,'1',1756300918),(2545,'accesslib/dirtycontexts','/1/84/2612',1756272118,'1',1756300918),(2546,'accesslib/dirtycontexts','/1/84/2613',1756272118,'1',1756300918),(2547,'accesslib/dirtycontexts','/1/84/2614',1756272118,'1',1756300918),(2548,'accesslib/dirtycontexts','/1/84/2615',1756272118,'1',1756300918),(2549,'accesslib/dirtycontexts','/1/84/2616',1756272119,'1',1756300919),(2550,'accesslib/dirtycontexts','/1/84/2617',1756272119,'1',1756300919),(2551,'accesslib/dirtycontexts','/1/84/2618',1756272119,'1',1756300919),(2552,'accesslib/dirtycontexts','/1/84/2619',1756272119,'1',1756300919),(2553,'accesslib/dirtycontexts','/1/84/2620',1756272119,'1',1756300919),(2554,'accesslib/dirtycontexts','/1/84/2621',1756272120,'1',1756300920),(2555,'accesslib/dirtycontexts','/1/84/2622',1756272120,'1',1756300920),(2556,'accesslib/dirtycontexts','/1/84/2623',1756272120,'1',1756300920),(2557,'accesslib/dirtycontexts','/1/84/2624',1756272120,'1',1756300920),(2558,'accesslib/dirtycontexts','/1/84/2625',1756272120,'1',1756300920),(2559,'accesslib/dirtycontexts','/1/84/2626',1756272121,'1',1756300921),(2560,'accesslib/dirtycontexts','/1/84/2627',1756272121,'1',1756300921),(2561,'accesslib/dirtycontexts','/1/84/2628',1756272121,'1',1756300921),(2562,'accesslib/dirtycontexts','/1/84/2629',1756272121,'1',1756300921),(2563,'accesslib/dirtycontexts','/1/84/2630',1756272121,'1',1756300921),(2564,'accesslib/dirtycontexts','/1/84/2631',1756272122,'1',1756300922),(2565,'accesslib/dirtycontexts','/1/84/2632',1756272122,'1',1756300922),(2566,'accesslib/dirtycontexts','/1/84/2633',1756272122,'1',1756300922),(2567,'accesslib/dirtycontexts','/1/84/2634',1756272122,'1',1756300922),(2568,'accesslib/dirtycontexts','/1/84/2635',1756272123,'1',1756300923),(2569,'accesslib/dirtycontexts','/1/84/2636',1756272123,'1',1756300923),(2570,'accesslib/dirtycontexts','/1/84/2637',1756272123,'1',1756300923),(2571,'accesslib/dirtycontexts','/1/84/2638',1756272123,'1',1756300923),(2572,'accesslib/dirtycontexts','/1/84/2639',1756272123,'1',1756300923),(2573,'accesslib/dirtycontexts','/1/84/2640',1756272123,'1',1756300923),(2574,'accesslib/dirtycontexts','/1/84/2641',1756272124,'1',1756300924),(2575,'accesslib/dirtycontexts','/1/84/2642',1756272124,'1',1756300924),(2576,'accesslib/dirtycontexts','/1/84/2643',1756272124,'1',1756300924),(2577,'accesslib/dirtycontexts','/1/84/2644',1756272124,'1',1756300924),(2578,'accesslib/dirtycontexts','/1/84/2645',1756272124,'1',1756300924),(2579,'accesslib/dirtycontexts','/1/84/2646',1756272125,'1',1756300925),(2580,'accesslib/dirtycontexts','/1/84/2647',1756272125,'1',1756300925),(2581,'accesslib/dirtycontexts','/1/84/2648',1756272125,'1',1756300925),(2582,'accesslib/dirtycontexts','/1/84/2649',1756272125,'1',1756300925),(2583,'accesslib/dirtycontexts','/1/84/2650',1756272125,'1',1756300925),(2584,'accesslib/dirtycontexts','/1/84/2651',1756272126,'1',1756300926),(2585,'accesslib/dirtycontexts','/1/84/2652',1756272126,'1',1756300926),(2586,'accesslib/dirtycontexts','/1/84/2653',1756272126,'1',1756300926),(2587,'accesslib/dirtycontexts','/1/84/2654',1756272127,'1',1756300927),(2588,'accesslib/dirtycontexts','/1/84/2655',1756272127,'1',1756300927),(2589,'accesslib/dirtycontexts','/1/84/2656',1756272127,'1',1756300927),(2590,'accesslib/dirtycontexts','/1/84/2657',1756272127,'1',1756300927),(2591,'accesslib/dirtycontexts','/1/84/2658',1756272127,'1',1756300927),(2592,'accesslib/dirtycontexts','/1/84/2659',1756272128,'1',1756300928),(2593,'accesslib/dirtycontexts','/1/84/2660',1756272128,'1',1756300928),(2594,'accesslib/dirtycontexts','/1/84/2661',1756272128,'1',1756300928),(2595,'accesslib/dirtycontexts','/1/84/2662',1756272128,'1',1756300928),(2596,'accesslib/dirtycontexts','/1/84/2663',1756272128,'1',1756300928),(2597,'accesslib/dirtycontexts','/1/84/2664',1756272129,'1',1756300929),(2598,'accesslib/dirtycontexts','/1/84/2665',1756272129,'1',1756300929),(2599,'accesslib/dirtycontexts','/1/84/2666',1756272129,'1',1756300929),(2600,'accesslib/dirtycontexts','/1/84/2667',1756272129,'1',1756300929),(2601,'accesslib/dirtycontexts','/1/84/2668',1756272130,'1',1756300930),(2602,'accesslib/dirtycontexts','/1/84/2669',1756272130,'1',1756300930),(2603,'accesslib/dirtycontexts','/1/84/2670',1756272130,'1',1756300930),(2604,'accesslib/dirtycontexts','/1/84/2671',1756272130,'1',1756300930),(2605,'accesslib/dirtycontexts','/1/84/2672',1756272130,'1',1756300930),(2606,'accesslib/dirtycontexts','/1/84/2673',1756272131,'1',1756300931),(2607,'accesslib/dirtycontexts','/1/84/2674',1756272131,'1',1756300931),(2608,'accesslib/dirtycontexts','/1/84/2675',1756272131,'1',1756300931),(2609,'accesslib/dirtycontexts','/1/84/2676',1756272131,'1',1756300931),(2610,'accesslib/dirtycontexts','/1/84/2677',1756272131,'1',1756300931),(2611,'accesslib/dirtycontexts','/1/84/2678',1756272132,'1',1756300932),(2612,'accesslib/dirtycontexts','/1/84/2679',1756272132,'1',1756300932),(2613,'accesslib/dirtycontexts','/1/84/2680',1756272132,'1',1756300932),(2614,'accesslib/dirtycontexts','/1/84/2681',1756272132,'1',1756300932),(2615,'accesslib/dirtycontexts','/1/84/2682',1756272132,'1',1756300932),(2616,'accesslib/dirtycontexts','/1/84/2683',1756272133,'1',1756300933),(2617,'accesslib/dirtycontexts','/1/84/2684',1756272133,'1',1756300933),(2618,'accesslib/dirtycontexts','/1/84/2685',1756272133,'1',1756300933),(2619,'accesslib/dirtycontexts','/1/84/2686',1756272133,'1',1756300933),(2620,'accesslib/dirtycontexts','/1/84/2687',1756272133,'1',1756300933),(2621,'accesslib/dirtycontexts','/1/84/2688',1756272134,'1',1756300934),(2622,'accesslib/dirtycontexts','/1/84/2689',1756272134,'1',1756300934),(2623,'accesslib/dirtycontexts','/1/84/2690',1756272134,'1',1756300934),(2624,'accesslib/dirtycontexts','/1/84/2691',1756272134,'1',1756300934),(2625,'accesslib/dirtycontexts','/1/84/2692',1756272135,'1',1756300935),(2626,'accesslib/dirtycontexts','/1/84/2693',1756272135,'1',1756300935),(2627,'accesslib/dirtycontexts','/1/84/2694',1756272135,'1',1756300935),(2628,'accesslib/dirtycontexts','/1/84/2695',1756272136,'1',1756300936),(2629,'accesslib/dirtycontexts','/1/84/2696',1756272136,'1',1756300936),(2630,'accesslib/dirtycontexts','/1/84/2697',1756272136,'1',1756300936),(2631,'accesslib/dirtycontexts','/1/84/2698',1756272136,'1',1756300936),(2632,'accesslib/dirtycontexts','/1/84/2699',1756272136,'1',1756300936),(2633,'accesslib/dirtycontexts','/1/84/2700',1756272137,'1',1756300937),(2634,'accesslib/dirtycontexts','/1/84/2701',1756272137,'1',1756300937),(2635,'accesslib/dirtycontexts','/1/84/2702',1756272137,'1',1756300937),(2636,'accesslib/dirtycontexts','/1/84/2703',1756272137,'1',1756300937),(2637,'accesslib/dirtycontexts','/1/84/2704',1756272137,'1',1756300937),(2638,'accesslib/dirtycontexts','/1/84/2705',1756272138,'1',1756300938),(2639,'accesslib/dirtycontexts','/1/84/2706',1756272138,'1',1756300938),(2640,'accesslib/dirtycontexts','/1/84/2707',1756272138,'1',1756300938),(2641,'accesslib/dirtycontexts','/1/84/2708',1756272138,'1',1756300938),(2642,'accesslib/dirtycontexts','/1/84/2709',1756272138,'1',1756300938),(2643,'accesslib/dirtycontexts','/1/84/2710',1756272139,'1',1756300939),(2644,'accesslib/dirtycontexts','/1/84/2711',1756272139,'1',1756300939),(2645,'accesslib/dirtycontexts','/1/84/2712',1756272139,'1',1756300939),(2646,'accesslib/dirtycontexts','/1/84/2713',1756272139,'1',1756300939),(2647,'accesslib/dirtycontexts','/1/84/2714',1756272140,'1',1756300940),(2648,'accesslib/dirtycontexts','/1/84/2715',1756272140,'1',1756300940),(2649,'accesslib/dirtycontexts','/1/84/2716',1756272140,'1',1756300940),(2650,'accesslib/dirtycontexts','/1/84/2717',1756272140,'1',1756300940),(2651,'accesslib/dirtycontexts','/1/84/2718',1756272140,'1',1756300940),(2652,'accesslib/dirtycontexts','/1/84/2719',1756272141,'1',1756300941),(2653,'accesslib/dirtycontexts','/1/84/2720',1756272141,'1',1756300941),(2654,'accesslib/dirtycontexts','/1/84/2721',1756272141,'1',1756300941),(2655,'accesslib/dirtycontexts','/1/84/2722',1756272141,'1',1756300941),(2656,'accesslib/dirtycontexts','/1/84/2723',1756272141,'1',1756300941),(2657,'accesslib/dirtycontexts','/1/84/2724',1756272142,'1',1756300942),(2658,'accesslib/dirtycontexts','/1/84/2725',1756272142,'1',1756300942),(2659,'accesslib/dirtycontexts','/1/84/2726',1756272142,'1',1756300942),(2660,'accesslib/dirtycontexts','/1/84/2727',1756272142,'1',1756300942),(2661,'accesslib/dirtycontexts','/1/84/2728',1756272142,'1',1756300942),(2662,'accesslib/dirtycontexts','/1/84/2729',1756272142,'1',1756300942),(2663,'accesslib/dirtycontexts','/1/84/2730',1756272143,'1',1756300943),(2664,'accesslib/dirtycontexts','/1/84/2731',1756272143,'1',1756300943),(2665,'accesslib/dirtycontexts','/1/84/2732',1756272143,'1',1756300943),(2666,'accesslib/dirtycontexts','/1/84/2733',1756272143,'1',1756300943),(2667,'accesslib/dirtycontexts','/1/84/2734',1756272143,'1',1756300943),(2668,'accesslib/dirtycontexts','/1/84/2735',1756272144,'1',1756300944),(2669,'accesslib/dirtycontexts','/1/84/2736',1756272144,'1',1756300944),(2670,'accesslib/dirtycontexts','/1/84/2737',1756272144,'1',1756300944),(2671,'accesslib/dirtycontexts','/1/84/2738',1756272144,'1',1756300944),(2672,'accesslib/dirtycontexts','/1/84/2739',1756272144,'1',1756300944),(2673,'accesslib/dirtycontexts','/1/84/2740',1756272145,'1',1756300945),(2674,'accesslib/dirtycontexts','/1/84/2741',1756272145,'1',1756300945),(2675,'accesslib/dirtycontexts','/1/84/2742',1756272145,'1',1756300945),(2676,'accesslib/dirtycontexts','/1/84/2743',1756272145,'1',1756300945),(2677,'accesslib/dirtycontexts','/1/84/2744',1756272146,'1',1756300946),(2678,'accesslib/dirtycontexts','/1/84/2745',1756272146,'1',1756300946),(2679,'accesslib/dirtycontexts','/1/84/2746',1756272146,'1',1756300946),(2680,'accesslib/dirtycontexts','/1/84/2747',1756272147,'1',1756300947),(2681,'accesslib/dirtycontexts','/1/84/2748',1756272147,'1',1756300947),(2682,'accesslib/dirtycontexts','/1/84/2749',1756272148,'1',1756300948),(2683,'accesslib/dirtycontexts','/1/84/2750',1756272148,'1',1756300948),(2684,'accesslib/dirtycontexts','/1/84/2751',1756272149,'1',1756300949),(2685,'accesslib/dirtycontexts','/1/84/2752',1756272149,'1',1756300949),(2686,'accesslib/dirtycontexts','/1/84/2753',1756272150,'1',1756300950),(2687,'accesslib/dirtycontexts','/1/84/2754',1756272150,'1',1756300950),(2688,'accesslib/dirtycontexts','/1/84/2755',1756272151,'1',1756300951),(2689,'accesslib/dirtycontexts','/1/84/2756',1756272151,'1',1756300951),(2690,'accesslib/dirtycontexts','/1/84/2757',1756272151,'1',1756300951),(2691,'accesslib/dirtycontexts','/1/84/2758',1756272151,'1',1756300951),(2692,'accesslib/dirtycontexts','/1/84/2759',1756272152,'1',1756300952),(2693,'accesslib/dirtycontexts','/1/84/2760',1756272152,'1',1756300952),(2694,'accesslib/dirtycontexts','/1/84/2761',1756272152,'1',1756300952),(2695,'accesslib/dirtycontexts','/1/84/2762',1756272152,'1',1756300952),(2696,'accesslib/dirtycontexts','/1/84/2763',1756272152,'1',1756300952),(2697,'accesslib/dirtycontexts','/1/84/2764',1756272154,'1',1756300954),(2698,'accesslib/dirtycontexts','/1/84/2765',1756272156,'1',1756300956),(2699,'accesslib/dirtycontexts','/1/84/2766',1756272157,'1',1756300957),(2700,'accesslib/dirtycontexts','/1/84/2767',1756272158,'1',1756300958),(2701,'accesslib/dirtycontexts','/1/84/2768',1756272158,'1',1756300958),(2702,'accesslib/dirtycontexts','/1/84/2769',1756272158,'1',1756300958),(2703,'accesslib/dirtycontexts','/1/84/2770',1756272159,'1',1756300959),(2704,'accesslib/dirtycontexts','/1/84/2771',1756272159,'1',1756300959),(2705,'accesslib/dirtycontexts','/1/84/2772',1756272159,'1',1756300959),(2706,'accesslib/dirtycontexts','/1/84/2773',1756272159,'1',1756300959),(2707,'accesslib/dirtycontexts','/1/84/2774',1756272159,'1',1756300959),(2708,'accesslib/dirtycontexts','/1/84/2775',1756272160,'1',1756300960),(2709,'accesslib/dirtycontexts','/1/84/2776',1756272160,'1',1756300960),(2710,'accesslib/dirtycontexts','/1/84/2777',1756272160,'1',1756300960),(2711,'accesslib/dirtycontexts','/1/84/2778',1756272160,'1',1756300960),(2712,'accesslib/dirtycontexts','/1/84/2779',1756272160,'1',1756300960),(2713,'accesslib/dirtycontexts','/1/84/2780',1756272161,'1',1756300961),(2714,'accesslib/dirtycontexts','/1/84/2781',1756272161,'1',1756300961),(2715,'accesslib/dirtycontexts','/1/84/2782',1756272161,'1',1756300961),(2716,'accesslib/dirtycontexts','/1/84/2783',1756272161,'1',1756300961),(2717,'accesslib/dirtycontexts','/1/84/2784',1756272162,'1',1756300962),(2718,'accesslib/dirtycontexts','/1/84/2785',1756272162,'1',1756300962),(2719,'accesslib/dirtycontexts','/1/84/2786',1756272162,'1',1756300962),(2720,'accesslib/dirtycontexts','/1/84/2787',1756272162,'1',1756300962),(2721,'accesslib/dirtycontexts','/1/84/2788',1756272163,'1',1756300963),(2722,'accesslib/dirtycontexts','/1/84/2789',1756272163,'1',1756300963),(2723,'accesslib/dirtycontexts','/1/84/2790',1756272164,'1',1756300964),(2724,'accesslib/dirtycontexts','/1/84/2791',1756272164,'1',1756300964),(2725,'accesslib/dirtycontexts','/1/84/2792',1756272164,'1',1756300964),(2726,'accesslib/dirtycontexts','/1/84/2793',1756272164,'1',1756300964),(2727,'accesslib/dirtycontexts','/1/84/2794',1756272164,'1',1756300964),(2728,'accesslib/dirtycontexts','/1/84/2795',1756272164,'1',1756300964),(2729,'accesslib/dirtycontexts','/1/84/2796',1756272165,'1',1756300965),(2730,'accesslib/dirtycontexts','/1/84/2797',1756272165,'1',1756300965),(2731,'accesslib/dirtycontexts','/1/84/2798',1756272165,'1',1756300965),(2732,'accesslib/dirtycontexts','/1/84/2799',1756272165,'1',1756300965),(2733,'accesslib/dirtycontexts','/1/84/2800',1756272165,'1',1756300965),(2734,'accesslib/dirtycontexts','/1/84/2801',1756272166,'1',1756300966),(2735,'accesslib/dirtycontexts','/1/84/2802',1756272166,'1',1756300966),(2736,'accesslib/dirtycontexts','/1/84/2803',1756272166,'1',1756300966),(2737,'accesslib/dirtycontexts','/1/84/2804',1756272166,'1',1756300966),(2738,'accesslib/dirtycontexts','/1/84/2805',1756272166,'1',1756300966),(2739,'accesslib/dirtycontexts','/1/84/2806',1756272167,'1',1756300967),(2740,'accesslib/dirtycontexts','/1/84/2807',1756272167,'1',1756300967),(2741,'accesslib/dirtycontexts','/1/84/2808',1756272167,'1',1756300967),(2742,'accesslib/dirtycontexts','/1/84/2809',1756272167,'1',1756300967),(2743,'accesslib/dirtycontexts','/1/84/2810',1756272167,'1',1756300967),(2744,'accesslib/dirtycontexts','/1/84/2811',1756272168,'1',1756300968),(2745,'accesslib/dirtycontexts','/1/84/2812',1756272168,'1',1756300968),(2746,'accesslib/dirtycontexts','/1/84/2813',1756272169,'1',1756300969),(2747,'accesslib/dirtycontexts','/1/84/2814',1756272169,'1',1756300969),(2748,'accesslib/dirtycontexts','/1/84/2815',1756272170,'1',1756300970),(2749,'accesslib/dirtycontexts','/1/84/2816',1756272171,'1',1756300971),(2750,'accesslib/dirtycontexts','/1/84/2817',1756272172,'1',1756300972),(2751,'accesslib/dirtycontexts','/1/84/2818',1756272173,'1',1756300973),(2752,'accesslib/dirtycontexts','/1/84/2819',1756272173,'1',1756300973),(2753,'accesslib/dirtycontexts','/1/84/2820',1756272174,'1',1756300974),(2754,'accesslib/dirtycontexts','/1/84/2821',1756272175,'1',1756300975),(2755,'accesslib/dirtycontexts','/1/84/2822',1756272176,'1',1756300976),(2756,'accesslib/dirtycontexts','/1/84/2823',1756272177,'1',1756300977),(2757,'accesslib/dirtycontexts','/1/84/2824',1756272177,'1',1756300977),(2758,'accesslib/dirtycontexts','/1/3/17',1756100622,'1',1756129422),(2759,'accesslib/dirtycontexts','/1/3/37',1756100638,'1',1756129438),(2760,'accesslib/dirtycontexts','/1/3/40',1756100653,'1',1756129453),(2761,'accesslib/dirtycontexts','/1/3/44',1756100670,'1',1756129470),(2762,'accesslib/dirtycontexts','/1/84/143',1756100921,'1',1756129721),(2763,'accesslib/dirtycontexts','/1/84/85',1756100933,'1',1756129733),(2764,'accesslib/dirtycontexts','/1/84/141',1756100944,'1',1756129744),(2765,'accesslib/dirtycontexts','/1/3/62',1756101005,'1',1756129805),(2766,'accesslib/dirtycontexts','/1/84/2888',1756272178,'1',1756300978),(2767,'accesslib/dirtycontexts','/1/84/2889',1756272179,'1',1756300979),(2768,'accesslib/dirtycontexts','/1/84/2890',1756272180,'1',1756300980),(2769,'accesslib/dirtycontexts','/1/84/2891',1756272180,'1',1756300980),(2770,'accesslib/dirtycontexts','/1/84/2892',1756272181,'1',1756300981),(2771,'accesslib/dirtycontexts','/1/84/2893',1756272181,'1',1756300981),(2772,'accesslib/dirtycontexts','/1/84/2894',1756272181,'1',1756300981),(2773,'accesslib/dirtycontexts','/1/84/2895',1756272181,'1',1756300981),(2774,'accesslib/dirtycontexts','/1/84/2896',1756272181,'1',1756300981),(2775,'accesslib/dirtycontexts','/1/84/2897',1756272182,'1',1756300982),(2776,'accesslib/dirtycontexts','/1/84/2898',1756272182,'1',1756300982),(2777,'accesslib/dirtycontexts','/1/84/2899',1756272182,'1',1756300982),(2778,'accesslib/dirtycontexts','/1/84/2900',1756272182,'1',1756300982),(2779,'accesslib/dirtycontexts','/1/84/2901',1756272182,'1',1756300982),(2780,'accesslib/dirtycontexts','/1/84/2902',1756272183,'1',1756300983),(2781,'accesslib/dirtycontexts','/1/84/2903',1756272183,'1',1756300983),(2782,'accesslib/dirtycontexts','/1/84/2904',1756272183,'1',1756300983),(2783,'accesslib/dirtycontexts','/1/84/2905',1756272183,'1',1756300983),(2784,'accesslib/dirtycontexts','/1/84/2906',1756272183,'1',1756300983),(2785,'accesslib/dirtycontexts','/1/84/2907',1756272184,'1',1756300984),(2786,'accesslib/dirtycontexts','/1/84/2908',1756272184,'1',1756300984),(2787,'accesslib/dirtycontexts','/1/84/2909',1756272184,'1',1756300984),(2788,'accesslib/dirtycontexts','/1/84/2910',1756272184,'1',1756300984),(2789,'accesslib/dirtycontexts','/1/84/2911',1756272184,'1',1756300984),(2790,'accesslib/dirtycontexts','/1/84/2912',1756272185,'1',1756300985),(2791,'accesslib/dirtycontexts','/1/84/2913',1756272185,'1',1756300985),(2792,'accesslib/dirtycontexts','/1/84/2914',1756272185,'1',1756300985),(2793,'accesslib/dirtycontexts','/1/84/2915',1756272185,'1',1756300985),(2794,'accesslib/dirtycontexts','/1/84/2916',1756272185,'1',1756300985),(2795,'accesslib/dirtycontexts','/1/84/2917',1756272185,'1',1756300985),(2796,'accesslib/dirtycontexts','/1/84/2918',1756272186,'1',1756300986),(2797,'accesslib/dirtycontexts','/1/84/2919',1756272186,'1',1756300986),(2798,'accesslib/dirtycontexts','/1/84/2920',1756272186,'1',1756300986),(2799,'accesslib/dirtycontexts','/1/84/2921',1756272186,'1',1756300986),(2800,'accesslib/dirtycontexts','/1/84/2922',1756272187,'1',1756300987),(2801,'accesslib/dirtycontexts','/1/84/2923',1756272187,'1',1756300987),(2802,'accesslib/dirtycontexts','/1/84/2924',1756272187,'1',1756300987),(2803,'accesslib/dirtycontexts','/1/84/2925',1756272187,'1',1756300987),(2804,'accesslib/dirtycontexts','/1/84/2926',1756272187,'1',1756300987),(2805,'accesslib/dirtycontexts','/1/84/2927',1756272188,'1',1756300988),(2806,'accesslib/dirtycontexts','/1/84/2928',1756272188,'1',1756300988),(2807,'accesslib/dirtycontexts','/1/84/2929',1756272188,'1',1756300988),(2808,'accesslib/dirtycontexts','/1/84/2930',1756272188,'1',1756300988),(2809,'accesslib/dirtycontexts','/1/84/2931',1756272188,'1',1756300988),(2810,'accesslib/dirtycontexts','/1/84/2932',1756272189,'1',1756300989),(2811,'accesslib/dirtycontexts','/1/84/2933',1756272189,'1',1756300989),(2812,'accesslib/dirtycontexts','/1/84/2934',1756272189,'1',1756300989),(2813,'accesslib/dirtycontexts','/1/84/2935',1756272189,'1',1756300989),(2814,'accesslib/dirtycontexts','/1/84/2936',1756272190,'1',1756300990),(2815,'accesslib/dirtycontexts','/1/84/2937',1756272190,'1',1756300990),(2816,'accesslib/dirtycontexts','/1/84/2938',1756272191,'1',1756300991),(2817,'accesslib/dirtycontexts','/1/84/2939',1756272191,'1',1756300991),(2818,'accesslib/dirtycontexts','/1/84/2940',1756272192,'1',1756300992),(2819,'accesslib/dirtycontexts','/1/84/2941',1756272192,'1',1756300992),(2820,'accesslib/dirtycontexts','/1/84/2942',1756272193,'1',1756300993),(2821,'accesslib/dirtycontexts','/1/84/2943',1756272193,'1',1756300993),(2822,'accesslib/dirtycontexts','/1/84/2944',1756272194,'1',1756300994),(2823,'accesslib/dirtycontexts','/1/84/2945',1756272195,'1',1756300995),(2824,'accesslib/dirtycontexts','/1/84/2946',1756272195,'1',1756300995),(2825,'accesslib/dirtycontexts','/1/84/2947',1756272196,'1',1756300996),(2826,'accesslib/dirtycontexts','/1/84/2948',1756272196,'1',1756300996),(2827,'accesslib/dirtycontexts','/1/84/2949',1756272196,'1',1756300996),(2828,'accesslib/dirtycontexts','/1/84/2950',1756272196,'1',1756300996),(2829,'accesslib/dirtycontexts','/1/84/2951',1756272196,'1',1756300996),(2830,'accesslib/dirtycontexts','/1/84/2952',1756272197,'1',1756300997),(2831,'accesslib/dirtycontexts','/1/84/2953',1756272197,'1',1756300997),(2832,'accesslib/dirtycontexts','/1/84/2954',1756272197,'1',1756300997),(2833,'accesslib/dirtycontexts','/1/84/2955',1756272197,'1',1756300997),(2834,'accesslib/dirtycontexts','/1/84/2956',1756272197,'1',1756300997),(2835,'accesslib/dirtycontexts','/1/84/2957',1756272198,'1',1756300998),(2836,'accesslib/dirtycontexts','/1/84/2958',1756272198,'1',1756300998),(2837,'accesslib/dirtycontexts','/1/84/2959',1756272198,'1',1756300998),(2838,'accesslib/dirtycontexts','/1/84/2960',1756272198,'1',1756300998),(2839,'accesslib/dirtycontexts','/1/84/2961',1756272199,'1',1756300999),(2840,'accesslib/dirtycontexts','/1/84/2962',1756272199,'1',1756300999),(2841,'accesslib/dirtycontexts','/1/84/2963',1756272199,'1',1756300999),(2842,'accesslib/dirtycontexts','/1/84/2964',1756272199,'1',1756300999),(2843,'accesslib/dirtycontexts','/1/84/2965',1756272199,'1',1756300999),(2844,'accesslib/dirtycontexts','/1/84/2966',1756272200,'1',1756301000),(2845,'accesslib/dirtycontexts','/1/84/2967',1756272200,'1',1756301000),(2846,'accesslib/dirtycontexts','/1/84/2968',1756272200,'1',1756301000),(2847,'accesslib/dirtycontexts','/1/84/2969',1756272200,'1',1756301000),(2848,'accesslib/dirtycontexts','/1/84/2970',1756272200,'1',1756301000),(2849,'accesslib/dirtycontexts','/1/84/2971',1756272201,'1',1756301001),(2850,'accesslib/dirtycontexts','/1/84/2972',1756272201,'1',1756301001),(2851,'accesslib/dirtycontexts','/1/84/2973',1756272201,'1',1756301001),(2852,'accesslib/dirtycontexts','/1/84/2974',1756272201,'1',1756301001),(2853,'accesslib/dirtycontexts','/1/84/2975',1756272201,'1',1756301001),(2854,'accesslib/dirtycontexts','/1/84/2976',1756272202,'1',1756301002),(2855,'accesslib/dirtycontexts','/1/84/2977',1756272202,'1',1756301002),(2856,'accesslib/dirtycontexts','/1/84/2978',1756272202,'1',1756301002),(2857,'accesslib/dirtycontexts','/1/84/2979',1756272202,'1',1756301002),(2858,'accesslib/dirtycontexts','/1/84/2980',1756272202,'1',1756301002),(2859,'accesslib/dirtycontexts','/1/84/2981',1756272202,'1',1756301002),(2860,'accesslib/dirtycontexts','/1/84/2982',1756272203,'1',1756301003),(2861,'accesslib/dirtycontexts','/1/84/2983',1756272203,'1',1756301003),(2862,'accesslib/dirtycontexts','/1/84/2984',1756272203,'1',1756301003),(2863,'accesslib/dirtycontexts','/1/84/2985',1756272203,'1',1756301003),(2864,'accesslib/dirtycontexts','/1/84/2986',1756272203,'1',1756301003),(2865,'accesslib/dirtycontexts','/1/84/2987',1756272204,'1',1756301004),(2866,'accesslib/dirtycontexts','/1/84/2988',1756272204,'1',1756301004),(2867,'accesslib/dirtycontexts','/1/84/2989',1756272204,'1',1756301004),(2868,'accesslib/dirtycontexts','/1/84/2990',1756272204,'1',1756301004),(2869,'accesslib/dirtycontexts','/1/84/2991',1756272204,'1',1756301004),(2870,'accesslib/dirtycontexts','/1/84/2992',1756272205,'1',1756301005),(2871,'accesslib/dirtycontexts','/1/84/2993',1756272205,'1',1756301005),(2872,'accesslib/dirtycontexts','/1/84/2994',1756272205,'1',1756301005),(2873,'accesslib/dirtycontexts','/1/84/2995',1756272205,'1',1756301005),(2874,'accesslib/dirtycontexts','/1/84/2996',1756272205,'1',1756301005),(2875,'accesslib/dirtycontexts','/1/84/2997',1756272205,'1',1756301005),(2876,'accesslib/dirtycontexts','/1/84/2998',1756272206,'1',1756301006),(2877,'accesslib/dirtycontexts','/1/84/2999',1756272206,'1',1756301006),(2878,'accesslib/dirtycontexts','/1/84/3000',1756272206,'1',1756301006),(2879,'accesslib/dirtycontexts','/1/84/3001',1756272206,'1',1756301006),(2880,'accesslib/dirtycontexts','/1/84/3002',1756272206,'1',1756301006),(2881,'accesslib/dirtycontexts','/1/84/3003',1756272207,'1',1756301007),(2882,'accesslib/dirtycontexts','/1/84/3004',1756272207,'1',1756301007),(2883,'accesslib/dirtycontexts','/1/84/3005',1756272207,'1',1756301007),(2884,'accesslib/dirtycontexts','/1/84/3006',1756272207,'1',1756301007),(2885,'accesslib/dirtycontexts','/1/84/3007',1756272207,'1',1756301007),(2886,'accesslib/dirtycontexts','/1/84/3008',1756272208,'1',1756301008),(2887,'accesslib/dirtycontexts','/1/84/3009',1756272208,'1',1756301008),(2888,'accesslib/dirtycontexts','/1/84/3010',1756272208,'1',1756301008),(2889,'accesslib/dirtycontexts','/1/84/3011',1756272208,'1',1756301008),(2890,'accesslib/dirtycontexts','/1/84/3012',1756272208,'1',1756301008),(2891,'accesslib/dirtycontexts','/1/84/3013',1756272209,'1',1756301009),(2892,'accesslib/dirtycontexts','/1/84/3014',1756272209,'1',1756301009),(2893,'accesslib/dirtycontexts','/1/84/3015',1756272209,'1',1756301009),(2894,'accesslib/dirtycontexts','/1/84/3016',1756272209,'1',1756301009),(2895,'accesslib/dirtycontexts','/1/84/3017',1756272209,'1',1756301009),(2896,'accesslib/dirtycontexts','/1/84/3018',1756272209,'1',1756301009),(2897,'accesslib/dirtycontexts','/1/84/3019',1756272210,'1',1756301010),(2898,'accesslib/dirtycontexts','/1/84/3020',1756272210,'1',1756301010),(2899,'accesslib/dirtycontexts','/1/84/3021',1756272210,'1',1756301010),(2900,'accesslib/dirtycontexts','/1/84/3022',1756272210,'1',1756301010),(2901,'accesslib/dirtycontexts','/1/84/3023',1756272210,'1',1756301010),(2902,'accesslib/dirtycontexts','/1/84/3024',1756272211,'1',1756301011),(2903,'accesslib/dirtycontexts','/1/84/3025',1756272211,'1',1756301011),(2904,'accesslib/dirtycontexts','/1/84/3026',1756272211,'1',1756301011),(2905,'accesslib/dirtycontexts','/1/84/3027',1756272211,'1',1756301011),(2906,'accesslib/dirtycontexts','/1/84/3028',1756272211,'1',1756301011),(2907,'accesslib/dirtycontexts','/1/84/3029',1756272212,'1',1756301012),(2908,'accesslib/dirtycontexts','/1/84/3030',1756272212,'1',1756301012),(2909,'accesslib/dirtycontexts','/1/84/3031',1756272212,'1',1756301012),(2910,'accesslib/dirtycontexts','/1/84/3032',1756272212,'1',1756301012),(2911,'accesslib/dirtycontexts','/1/84/3033',1756272212,'1',1756301012),(2912,'accesslib/dirtycontexts','/1/84/3034',1756272213,'1',1756301013),(2913,'accesslib/dirtycontexts','/1/84/3035',1756272213,'1',1756301013),(2914,'accesslib/dirtycontexts','/1/84/3036',1756272213,'1',1756301013),(2915,'accesslib/dirtycontexts','/1/84/3037',1756272213,'1',1756301013),(2916,'accesslib/dirtycontexts','/1/84/3038',1756272213,'1',1756301013),(2917,'accesslib/dirtycontexts','/1/84/3039',1756272214,'1',1756301014),(2918,'accesslib/dirtycontexts','/1/84/3040',1756272214,'1',1756301014),(2919,'accesslib/dirtycontexts','/1/84/3041',1756272214,'1',1756301014),(2920,'accesslib/dirtycontexts','/1/84/3042',1756272214,'1',1756301014),(2921,'accesslib/dirtycontexts','/1/84/3043',1756272214,'1',1756301014),(2922,'accesslib/dirtycontexts','/1/84/3044',1756272215,'1',1756301015),(2923,'accesslib/dirtycontexts','/1/84/3045',1756272215,'1',1756301015),(2924,'accesslib/dirtycontexts','/1/84/3046',1756272215,'1',1756301015),(2925,'accesslib/dirtycontexts','/1/84/3047',1756272215,'1',1756301015),(2926,'accesslib/dirtycontexts','/1/84/3048',1756272215,'1',1756301015),(2927,'accesslib/dirtycontexts','/1/84/3049',1756272215,'1',1756301015),(2928,'accesslib/dirtycontexts','/1/84/3050',1756272216,'1',1756301016),(2929,'accesslib/dirtycontexts','/1/84/3051',1756272216,'1',1756301016),(2930,'accesslib/dirtycontexts','/1/84/3052',1756272216,'1',1756301016),(2931,'accesslib/dirtycontexts','/1/84/3053',1756272216,'1',1756301016),(2932,'accesslib/dirtycontexts','/1/84/3054',1756272216,'1',1756301016),(2933,'accesslib/dirtycontexts','/1/84/3055',1756272217,'1',1756301017),(2934,'accesslib/dirtycontexts','/1/84/3056',1756272217,'1',1756301017),(2935,'accesslib/dirtycontexts','/1/84/3057',1756272217,'1',1756301017),(2936,'accesslib/dirtycontexts','/1/84/3058',1756272217,'1',1756301017),(2937,'accesslib/dirtycontexts','/1/84/3059',1756272217,'1',1756301017),(2938,'accesslib/dirtycontexts','/1/84/3060',1756272218,'1',1756301018),(2939,'accesslib/dirtycontexts','/1/84/3061',1756272218,'1',1756301018),(2940,'accesslib/dirtycontexts','/1/84/3062',1756272218,'1',1756301018),(2941,'accesslib/dirtycontexts','/1/84/3063',1756272218,'1',1756301018),(2942,'accesslib/dirtycontexts','/1/84/3064',1756272218,'1',1756301018),(2943,'accesslib/dirtycontexts','/1/84/3065',1756272219,'1',1756301019),(2944,'accesslib/dirtycontexts','/1/84/3066',1756272219,'1',1756301019),(2945,'accesslib/dirtycontexts','/1/84/3067',1756272219,'1',1756301019),(2946,'accesslib/dirtycontexts','/1/84/3068',1756272219,'1',1756301019),(2947,'accesslib/dirtycontexts','/1/84/3069',1756272219,'1',1756301019),(2948,'accesslib/dirtycontexts','/1/84/3070',1756272220,'1',1756301020),(2949,'accesslib/dirtycontexts','/1/84/3071',1756272220,'1',1756301020),(2950,'accesslib/dirtycontexts','/1/84/3072',1756272220,'1',1756301020),(2951,'accesslib/dirtycontexts','/1/84/3073',1756272220,'1',1756301020),(2952,'accesslib/dirtycontexts','/1/84/3074',1756272220,'1',1756301020),(2953,'accesslib/dirtycontexts','/1/84/3075',1756272221,'1',1756301021),(2954,'accesslib/dirtycontexts','/1/84/3076',1756272221,'1',1756301021),(2955,'accesslib/dirtycontexts','/1/84/3077',1756272221,'1',1756301021),(2956,'accesslib/dirtycontexts','/1/84/3078',1756272221,'1',1756301021),(2957,'accesslib/dirtycontexts','/1/84/3079',1756272221,'1',1756301021),(2958,'accesslib/dirtycontexts','/1/84/3080',1756272222,'1',1756301022),(2959,'accesslib/dirtycontexts','/1/84/3081',1756272222,'1',1756301022),(2960,'accesslib/dirtycontexts','/1/84/3082',1756272222,'1',1756301022),(2961,'accesslib/dirtycontexts','/1/84/3083',1756272222,'1',1756301022),(2962,'accesslib/dirtycontexts','/1/84/3084',1756272222,'1',1756301022),(2963,'accesslib/dirtycontexts','/1/84/3085',1756272223,'1',1756301023),(2964,'accesslib/dirtycontexts','/1/84/3086',1756272223,'1',1756301023),(2965,'accesslib/dirtycontexts','/1/84/3087',1756272223,'1',1756301023),(2966,'accesslib/dirtycontexts','/1/84/3088',1756272223,'1',1756301023),(2967,'accesslib/dirtycontexts','/1/84/3089',1756272223,'1',1756301023),(2968,'accesslib/dirtycontexts','/1/84/3090',1756272224,'1',1756301024),(2969,'accesslib/dirtycontexts','/1/84/3091',1756272224,'1',1756301024),(2970,'accesslib/dirtycontexts','/1/84/3092',1756272224,'1',1756301024),(2971,'accesslib/dirtycontexts','/1/84/3093',1756272224,'1',1756301024),(2972,'accesslib/dirtycontexts','/1/84/3094',1756272224,'1',1756301024),(2973,'accesslib/dirtycontexts','/1/84/3095',1756272224,'1',1756301024),(2974,'accesslib/dirtycontexts','/1/84/3096',1756272225,'1',1756301025),(2975,'accesslib/dirtycontexts','/1/84/3097',1756272225,'1',1756301025),(2976,'accesslib/dirtycontexts','/1/84/3098',1756272225,'1',1756301025),(2977,'accesslib/dirtycontexts','/1/84/3099',1756272225,'1',1756301025),(2978,'accesslib/dirtycontexts','/1/84/3100',1756272225,'1',1756301025),(2979,'accesslib/dirtycontexts','/1/84/3101',1756272226,'1',1756301026),(2980,'accesslib/dirtycontexts','/1/84/3102',1756272226,'1',1756301026),(2981,'accesslib/dirtycontexts','/1/84/3103',1756272226,'1',1756301026),(2982,'accesslib/dirtycontexts','/1/84/3104',1756272226,'1',1756301026),(2983,'accesslib/dirtycontexts','/1/84/3105',1756272227,'1',1756301027),(2984,'accesslib/dirtycontexts','/1/84/3106',1756272227,'1',1756301027),(2985,'accesslib/dirtycontexts','/1/84/3107',1756272227,'1',1756301027),(2986,'accesslib/dirtycontexts','/1/84/3108',1756272228,'1',1756301028),(2987,'accesslib/dirtycontexts','/1/84/3109',1756272228,'1',1756301028),(2988,'accesslib/dirtycontexts','/1/84/3110',1756272228,'1',1756301028),(2989,'accesslib/dirtycontexts','/1/84/3111',1756272229,'1',1756301029),(2990,'accesslib/dirtycontexts','/1/84/3112',1756272229,'1',1756301029),(2991,'accesslib/dirtycontexts','/1/84/3113',1756272229,'1',1756301029),(2992,'accesslib/dirtycontexts','/1/84/3114',1756272229,'1',1756301029),(2993,'accesslib/dirtycontexts','/1/84/3115',1756272230,'1',1756301030),(2994,'accesslib/dirtycontexts','/1/84/3116',1756272230,'1',1756301030),(2995,'accesslib/dirtycontexts','/1/84/3117',1756272230,'1',1756301030),(2996,'accesslib/dirtycontexts','/1/84/3118',1756272231,'1',1756301031),(2997,'accesslib/dirtycontexts','/1/84/3119',1756272231,'1',1756301031),(2998,'accesslib/dirtycontexts','/1/84/3120',1756272231,'1',1756301031),(2999,'accesslib/dirtycontexts','/1/84/3121',1756272232,'1',1756301032),(3000,'accesslib/dirtycontexts','/1/84/3122',1756272232,'1',1756301032),(3001,'accesslib/dirtycontexts','/1/84/3123',1756272232,'1',1756301032),(3002,'accesslib/dirtycontexts','/1/84/3124',1756272232,'1',1756301032),(3003,'accesslib/dirtycontexts','/1/84/3125',1756272232,'1',1756301032),(3004,'accesslib/dirtycontexts','/1/84/3126',1756272232,'1',1756301032),(3005,'accesslib/dirtycontexts','/1/84/3127',1756272233,'1',1756301033),(3006,'accesslib/dirtycontexts','/1/84/3128',1756272233,'1',1756301033),(3007,'accesslib/dirtycontexts','/1/84/3129',1756272233,'1',1756301033),(3008,'accesslib/dirtycontexts','/1/84/3130',1756272233,'1',1756301033),(3009,'accesslib/dirtycontexts','/1/84/3131',1756272234,'1',1756301034),(3010,'accesslib/dirtycontexts','/1/84/3132',1756272234,'1',1756301034),(3011,'accesslib/dirtycontexts','/1/84/3133',1756272234,'1',1756301034),(3012,'accesslib/dirtycontexts','/1/84/3134',1756272234,'1',1756301034),(3013,'accesslib/dirtycontexts','/1/84/3135',1756272234,'1',1756301034),(3014,'accesslib/dirtycontexts','/1/84/3136',1756272234,'1',1756301034),(3015,'accesslib/dirtycontexts','/1/84/3137',1756272235,'1',1756301035),(3016,'accesslib/dirtycontexts','/1/84/3138',1756272235,'1',1756301035),(3017,'accesslib/dirtycontexts','/1/84/3139',1756272235,'1',1756301035),(3018,'accesslib/dirtycontexts','/1/84/3140',1756272235,'1',1756301035),(3019,'accesslib/dirtycontexts','/1/84/3141',1756272235,'1',1756301035),(3020,'accesslib/dirtycontexts','/1/84/3142',1756272236,'1',1756301036),(3021,'accesslib/dirtycontexts','/1/84/3143',1756272236,'1',1756301036),(3022,'accesslib/dirtycontexts','/1/84/3144',1756272236,'1',1756301036),(3023,'accesslib/dirtycontexts','/1/84/3145',1756272236,'1',1756301036),(3024,'accesslib/dirtycontexts','/1/84/3146',1756272236,'1',1756301036),(3025,'accesslib/dirtycontexts','/1/84/3147',1756272237,'1',1756301037),(3026,'accesslib/dirtycontexts','/1/84/3148',1756272237,'1',1756301037),(3027,'accesslib/dirtycontexts','/1/84/3149',1756272237,'1',1756301037),(3028,'accesslib/dirtycontexts','/1/84/3150',1756272237,'1',1756301037),(3029,'accesslib/dirtycontexts','/1/84/3151',1756272237,'1',1756301037),(3030,'accesslib/dirtycontexts','/1/84/3152',1756272238,'1',1756301038),(3031,'accesslib/dirtycontexts','/1/84/3153',1756272238,'1',1756301038),(3032,'accesslib/dirtycontexts','/1/84/3154',1756272238,'1',1756301038),(3033,'accesslib/dirtycontexts','/1/84/3155',1756272238,'1',1756301038),(3034,'accesslib/dirtycontexts','/1/84/3156',1756272238,'1',1756301038),(3035,'accesslib/dirtycontexts','/1/84/3157',1756272239,'1',1756301039),(3036,'accesslib/dirtycontexts','/1/84/3158',1756272239,'1',1756301039),(3037,'accesslib/dirtycontexts','/1/84/3159',1756272239,'1',1756301039),(3038,'accesslib/dirtycontexts','/1/84/3160',1756272239,'1',1756301039),(3039,'accesslib/dirtycontexts','/1/84/3161',1756272239,'1',1756301039),(3040,'accesslib/dirtycontexts','/1/84/3162',1756272240,'1',1756301040),(3041,'accesslib/dirtycontexts','/1/84/3163',1756272240,'1',1756301040),(3042,'accesslib/dirtycontexts','/1/84/3164',1756272240,'1',1756301040),(3043,'accesslib/dirtycontexts','/1/84/3165',1756272240,'1',1756301040),(3044,'accesslib/dirtycontexts','/1/84/3166',1756272240,'1',1756301040),(3045,'accesslib/dirtycontexts','/1/84/3167',1756272241,'1',1756301041),(3046,'accesslib/dirtycontexts','/1/84/3168',1756272241,'1',1756301041),(3047,'accesslib/dirtycontexts','/1/84/3169',1756272241,'1',1756301041),(3048,'accesslib/dirtycontexts','/1/84/3170',1756272241,'1',1756301041),(3049,'accesslib/dirtycontexts','/1/84/3171',1756272241,'1',1756301041),(3050,'accesslib/dirtycontexts','/1/84/3172',1756272242,'1',1756301042),(3051,'accesslib/dirtycontexts','/1/84/3173',1756272242,'1',1756301042),(3052,'accesslib/dirtycontexts','/1/84/3174',1756272242,'1',1756301042),(3053,'accesslib/dirtycontexts','/1/84/3175',1756272242,'1',1756301042),(3054,'accesslib/dirtycontexts','/1/84/3176',1756272243,'1',1756301043),(3055,'accesslib/dirtycontexts','/1/84/3177',1756272243,'1',1756301043),(3056,'accesslib/dirtycontexts','/1/84/3178',1756272243,'1',1756301043),(3057,'accesslib/dirtycontexts','/1/84/3179',1756272243,'1',1756301043),(3058,'accesslib/dirtycontexts','/1/84/3180',1756272243,'1',1756301043),(3059,'accesslib/dirtycontexts','/1/84/3181',1756272244,'1',1756301044),(3060,'accesslib/dirtycontexts','/1/84/3182',1756272244,'1',1756301044),(3061,'accesslib/dirtycontexts','/1/84/3183',1756272244,'1',1756301044),(3062,'accesslib/dirtycontexts','/1/84/3184',1756272244,'1',1756301044),(3063,'accesslib/dirtycontexts','/1/84/3185',1756272244,'1',1756301044),(3064,'accesslib/dirtycontexts','/1/84/3186',1756272244,'1',1756301044),(3065,'accesslib/dirtycontexts','/1/84/3187',1756272245,'1',1756301045),(3066,'accesslib/dirtycontexts','/1/84/3188',1756272245,'1',1756301045),(3067,'accesslib/dirtycontexts','/1/84/3189',1756272245,'1',1756301045),(3068,'accesslib/dirtycontexts','/1/84/3190',1756272245,'1',1756301045),(3069,'accesslib/dirtycontexts','/1/84/3191',1756272246,'1',1756301046),(3070,'accesslib/dirtycontexts','/1/84/3192',1756272246,'1',1756301046),(3071,'accesslib/dirtycontexts','/1/84/3193',1756272246,'1',1756301046),(3072,'accesslib/dirtycontexts','/1/84/3194',1756272246,'1',1756301046),(3073,'accesslib/dirtycontexts','/1/84/3195',1756272247,'1',1756301047),(3074,'accesslib/dirtycontexts','/1/84/3196',1756272247,'1',1756301047),(3075,'accesslib/dirtycontexts','/1/84/3197',1756272248,'1',1756301048),(3076,'accesslib/dirtycontexts','/1/84/3198',1756272248,'1',1756301048),(3077,'accesslib/dirtycontexts','/1/84/3199',1756272249,'1',1756301049),(3078,'accesslib/dirtycontexts','/1/84/3200',1756272249,'1',1756301049),(3079,'accesslib/dirtycontexts','/1/84/3201',1756272249,'1',1756301049),(3080,'accesslib/dirtycontexts','/1/84/3202',1756272249,'1',1756301049),(3081,'accesslib/dirtycontexts','/1/84/3203',1756272249,'1',1756301049),(3082,'accesslib/dirtycontexts','/1/84/3204',1756272250,'1',1756301050),(3083,'accesslib/dirtycontexts','/1/84/3205',1756272251,'1',1756301051),(3084,'accesslib/dirtycontexts','/1/84/3206',1756272252,'1',1756301052),(3085,'accesslib/dirtycontexts','/1/84/3207',1756272252,'1',1756301052),(3086,'accesslib/dirtycontexts','/1/84/3208',1756272253,'1',1756301053),(3087,'accesslib/dirtycontexts','/1/84/3209',1756272253,'1',1756301053),(3088,'accesslib/dirtycontexts','/1/84/3210',1756272253,'1',1756301053),(3089,'accesslib/dirtycontexts','/1/84/3211',1756272253,'1',1756301053),(3090,'accesslib/dirtycontexts','/1/84/3212',1756272253,'1',1756301053),(3091,'accesslib/dirtycontexts','/1/84/3213',1756272253,'1',1756301053),(3092,'accesslib/dirtycontexts','/1/84/3214',1756272254,'1',1756301054),(3093,'accesslib/dirtycontexts','/1/84/3215',1756272254,'1',1756301054),(3094,'accesslib/dirtycontexts','/1/84/3216',1756272254,'1',1756301054),(3095,'accesslib/dirtycontexts','/1/84/3217',1756272254,'1',1756301054),(3096,'accesslib/dirtycontexts','/1/84/3218',1756272254,'1',1756301054),(3097,'accesslib/dirtycontexts','/1/84/3219',1756272255,'1',1756301055),(3098,'accesslib/dirtycontexts','/1/84/3220',1756272255,'1',1756301055),(3099,'accesslib/dirtycontexts','/1/84/3221',1756272255,'1',1756301055),(3100,'accesslib/dirtycontexts','/1/84/3222',1756272255,'1',1756301055),(3101,'accesslib/dirtycontexts','/1/84/3223',1756272255,'1',1756301055),(3102,'accesslib/dirtycontexts','/1/84/3224',1756272256,'1',1756301056),(3103,'accesslib/dirtycontexts','/1/84/3225',1756272256,'1',1756301056),(3104,'accesslib/dirtycontexts','/1/84/3226',1756272256,'1',1756301056),(3105,'accesslib/dirtycontexts','/1/84/3227',1756272256,'1',1756301056),(3106,'accesslib/dirtycontexts','/1/84/3228',1756272256,'1',1756301056),(3107,'accesslib/dirtycontexts','/1/84/3229',1756272257,'1',1756301057),(3108,'accesslib/dirtycontexts','/1/84/3230',1756272257,'1',1756301057),(3109,'accesslib/dirtycontexts','/1/84/3231',1756272258,'1',1756301058),(3110,'accesslib/dirtycontexts','/1/84/3232',1756272258,'1',1756301058),(3111,'accesslib/dirtycontexts','/1/84/3233',1756272258,'1',1756301058),(3112,'accesslib/dirtycontexts','/1/84/3234',1756272258,'1',1756301058),(3113,'accesslib/dirtycontexts','/1/84/3235',1756272259,'1',1756301059),(3114,'accesslib/dirtycontexts','/1/84/3236',1756272259,'1',1756301059),(3115,'accesslib/dirtycontexts','/1/84/3237',1756272259,'1',1756301059),(3116,'accesslib/dirtycontexts','/1/84/3238',1756272259,'1',1756301059),(3117,'accesslib/dirtycontexts','/1/84/3239',1756272260,'1',1756301060),(3118,'accesslib/dirtycontexts','/1/84/3240',1756272260,'1',1756301060),(3119,'accesslib/dirtycontexts','/1/84/3241',1756272260,'1',1756301060),(3120,'accesslib/dirtycontexts','/1/84/3242',1756272260,'1',1756301060),(3121,'accesslib/dirtycontexts','/1/84/3243',1756272260,'1',1756301060),(3122,'accesslib/dirtycontexts','/1/84/3244',1756272261,'1',1756301061),(3123,'accesslib/dirtycontexts','/1/84/3245',1756272261,'1',1756301061),(3124,'accesslib/dirtycontexts','/1/84/3246',1756272261,'1',1756301061),(3125,'accesslib/dirtycontexts','/1/84/3247',1756272261,'1',1756301061),(3126,'accesslib/dirtycontexts','/1/84/3248',1756272261,'1',1756301061),(3127,'accesslib/dirtycontexts','/1/84/3249',1756272262,'1',1756301062),(3128,'accesslib/dirtycontexts','/1/84/3250',1756272262,'1',1756301062),(3129,'accesslib/dirtycontexts','/1/84/3251',1756272262,'1',1756301062),(3130,'accesslib/dirtycontexts','/1/84/3252',1756272262,'1',1756301062),(3131,'accesslib/dirtycontexts','/1/84/3253',1756272262,'1',1756301062),(3132,'accesslib/dirtycontexts','/1/84/3254',1756272263,'1',1756301063),(3133,'accesslib/dirtycontexts','/1/84/3255',1756272263,'1',1756301063),(3134,'accesslib/dirtycontexts','/1/84/3256',1756272263,'1',1756301063),(3135,'accesslib/dirtycontexts','/1/84/3257',1756272263,'1',1756301063),(3136,'accesslib/dirtycontexts','/1/84/3258',1756272263,'1',1756301063),(3137,'accesslib/dirtycontexts','/1/84/3259',1756272263,'1',1756301063),(3138,'accesslib/dirtycontexts','/1/84/3260',1756272264,'1',1756301064),(3139,'accesslib/dirtycontexts','/1/84/3261',1756272264,'1',1756301064),(3140,'accesslib/dirtycontexts','/1/84/3262',1756272264,'1',1756301064),(3141,'accesslib/dirtycontexts','/1/84/3263',1756272264,'1',1756301064),(3142,'accesslib/dirtycontexts','/1/84/3264',1756272265,'1',1756301065),(3143,'accesslib/dirtycontexts','/1/84/3265',1756272265,'1',1756301065),(3144,'accesslib/dirtycontexts','/1/84/3266',1756272265,'1',1756301065),(3145,'accesslib/dirtycontexts','/1/84/3267',1756272265,'1',1756301065),(3146,'accesslib/dirtycontexts','/1/84/3268',1756272265,'1',1756301065),(3147,'accesslib/dirtycontexts','/1/84/3269',1756272266,'1',1756301066),(3148,'accesslib/dirtycontexts','/1/84/3270',1756272266,'1',1756301066),(3149,'accesslib/dirtycontexts','/1/84/3271',1756272266,'1',1756301066),(3150,'accesslib/dirtycontexts','/1/84/3272',1756272266,'1',1756301066),(3151,'accesslib/dirtycontexts','/1/84/3273',1756272266,'1',1756301066),(3152,'accesslib/dirtycontexts','/1/84/3274',1756272266,'1',1756301066),(3153,'accesslib/dirtycontexts','/1/84/3275',1756272267,'1',1756301067),(3154,'accesslib/dirtycontexts','/1/84/3276',1756272267,'1',1756301067),(3155,'accesslib/dirtycontexts','/1/84/3277',1756272267,'1',1756301067),(3156,'accesslib/dirtycontexts','/1/84/3278',1756272267,'1',1756301067),(3157,'accesslib/dirtycontexts','/1/84/3279',1756272267,'1',1756301067),(3158,'accesslib/dirtycontexts','/1/84/3280',1756272268,'1',1756301068),(3159,'accesslib/dirtycontexts','/1/84/3281',1756272268,'1',1756301068),(3160,'accesslib/dirtycontexts','/1/84/3282',1756272268,'1',1756301068),(3161,'accesslib/dirtycontexts','/1/84/3283',1756272268,'1',1756301068),(3162,'accesslib/dirtycontexts','/1/84/3284',1756272268,'1',1756301068),(3163,'accesslib/dirtycontexts','/1/84/3285',1756272269,'1',1756301069),(3164,'accesslib/dirtycontexts','/1/84/3286',1756272269,'1',1756301069),(3165,'accesslib/dirtycontexts','/1/84/3287',1756272269,'1',1756301069),(3166,'accesslib/dirtycontexts','/1/84/3288',1756272269,'1',1756301069),(3167,'accesslib/dirtycontexts','/1/84/3289',1756272270,'1',1756301070),(3168,'accesslib/dirtycontexts','/1/84/3290',1756272270,'1',1756301070),(3169,'accesslib/dirtycontexts','/1/84/3291',1756272270,'1',1756301070),(3170,'accesslib/dirtycontexts','/1/84/3292',1756272270,'1',1756301070),(3171,'accesslib/dirtycontexts','/1/84/3293',1756272270,'1',1756301070),(3172,'accesslib/dirtycontexts','/1/84/3294',1756272270,'1',1756301070),(3173,'accesslib/dirtycontexts','/1/84/3295',1756272271,'1',1756301071),(3174,'accesslib/dirtycontexts','/1/84/3296',1756272271,'1',1756301071),(3175,'accesslib/dirtycontexts','/1/84/3297',1756272271,'1',1756301071),(3176,'accesslib/dirtycontexts','/1/84/3298',1756272271,'1',1756301071),(3177,'accesslib/dirtycontexts','/1/84/3299',1756272271,'1',1756301071),(3178,'accesslib/dirtycontexts','/1/84/3300',1756272272,'1',1756301072),(3179,'accesslib/dirtycontexts','/1/84/3301',1756272272,'1',1756301072),(3180,'accesslib/dirtycontexts','/1/84/3307',1756272272,'1',1756301072),(3181,'accesslib/dirtycontexts','/1/84/3308',1756272272,'1',1756301072),(3182,'accesslib/dirtycontexts','/1/84/3309',1756272273,'1',1756301073),(3183,'accesslib/dirtycontexts','/1/84/3310',1756272273,'1',1756301073),(3184,'accesslib/dirtycontexts','/1/84/3311',1756272273,'1',1756301073),(3185,'accesslib/dirtycontexts','/1/84/3312',1756272273,'1',1756301073),(3186,'accesslib/dirtycontexts','/1/84/3313',1756272273,'1',1756301073),(3187,'accesslib/dirtycontexts','/1/84/3314',1756272274,'1',1756301074),(3188,'accesslib/dirtycontexts','/1/84/3315',1756272274,'1',1756301074),(3189,'accesslib/dirtycontexts','/1/84/3316',1756272274,'1',1756301074),(3190,'accesslib/dirtycontexts','/1/84/3317',1756272274,'1',1756301074),(3191,'accesslib/dirtycontexts','/1/84/3318',1756272274,'1',1756301074),(3192,'accesslib/dirtycontexts','/1/84/3319',1756272275,'1',1756301075),(3193,'accesslib/dirtycontexts','/1/84/3320',1756272275,'1',1756301075),(3194,'accesslib/dirtycontexts','/1/84/3321',1756272275,'1',1756301075),(3195,'accesslib/dirtycontexts','/1/84/3322',1756272275,'1',1756301075),(3196,'accesslib/dirtycontexts','/1/84/3323',1756272275,'1',1756301075),(3197,'accesslib/dirtycontexts','/1/84/3324',1756272276,'1',1756301076),(3198,'accesslib/dirtycontexts','/1/84/3325',1756272276,'1',1756301076),(3199,'accesslib/dirtycontexts','/1/84/3326',1756272276,'1',1756301076),(3200,'accesslib/dirtycontexts','/1/84/3327',1756272276,'1',1756301076),(3201,'accesslib/dirtycontexts','/1/84/3328',1756272276,'1',1756301076),(3202,'accesslib/dirtycontexts','/1/84/3329',1756272277,'1',1756301077),(3203,'accesslib/dirtycontexts','/1/84/3330',1756272277,'1',1756301077),(3204,'accesslib/dirtycontexts','/1/84/3331',1756272277,'1',1756301077),(3205,'accesslib/dirtycontexts','/1/84/3332',1756272277,'1',1756301077),(3206,'accesslib/dirtycontexts','/1/84/3333',1756272278,'1',1756301078),(3207,'accesslib/dirtycontexts','/1/84/3334',1756272280,'1',1756301080),(3208,'accesslib/dirtycontexts','/1/84/3335',1756272281,'1',1756301081),(3209,'accesslib/dirtycontexts','/1/84/3336',1756272281,'1',1756301081),(3210,'accesslib/dirtycontexts','/1/84/3337',1756272281,'1',1756301081),(3211,'accesslib/dirtycontexts','/1/84/3338',1756272282,'1',1756301082),(3212,'accesslib/dirtycontexts','/1/84/3339',1756272282,'1',1756301082),(3213,'accesslib/dirtycontexts','/1/84/3340',1756272282,'1',1756301082),(3214,'accesslib/dirtycontexts','/1/84/3341',1756272282,'1',1756301082),(3215,'accesslib/dirtycontexts','/1/84/3342',1756272282,'1',1756301082),(3216,'accesslib/dirtycontexts','/1/84/3343',1756272283,'1',1756301083),(3217,'accesslib/dirtycontexts','/1/84/3344',1756272283,'1',1756301083),(3218,'accesslib/dirtycontexts','/1/84/3345',1756272283,'1',1756301083),(3219,'accesslib/dirtycontexts','/1/84/3346',1756272283,'1',1756301083),(3220,'accesslib/dirtycontexts','/1/84/3347',1756272283,'1',1756301083),(3221,'accesslib/dirtycontexts','/1/84/3348',1756272284,'1',1756301084),(3222,'accesslib/dirtycontexts','/1/84/3349',1756272284,'1',1756301084),(3223,'accesslib/dirtycontexts','/1/84/3350',1756272284,'1',1756301084),(3224,'accesslib/dirtycontexts','/1/84/3351',1756272284,'1',1756301084),(3225,'accesslib/dirtycontexts','/1/84/3352',1756272284,'1',1756301084),(3226,'accesslib/dirtycontexts','/1/84/3353',1756272285,'1',1756301085),(3227,'accesslib/dirtycontexts','/1/84/3354',1756272285,'1',1756301085),(3228,'accesslib/dirtycontexts','/1/84/3355',1756272285,'1',1756301085),(3229,'accesslib/dirtycontexts','/1/84/3356',1756272285,'1',1756301085),(3230,'accesslib/dirtycontexts','/1/84/3357',1756272285,'1',1756301085),(3231,'accesslib/dirtycontexts','/1/84/3358',1756272286,'1',1756301086),(3232,'accesslib/dirtycontexts','/1/84/3359',1756272286,'1',1756301086),(3233,'accesslib/dirtycontexts','/1/84/3360',1756272286,'1',1756301086),(3234,'accesslib/dirtycontexts','/1/84/3361',1756272286,'1',1756301086),(3235,'accesslib/dirtycontexts','/1/84/3362',1756272286,'1',1756301086),(3236,'accesslib/dirtycontexts','/1/84/3363',1756272287,'1',1756301087),(3237,'accesslib/dirtycontexts','/1/84/3364',1756272287,'1',1756301087),(3238,'accesslib/dirtycontexts','/1/84/3365',1756272287,'1',1756301087),(3239,'accesslib/dirtycontexts','/1/84/3366',1756272287,'1',1756301087),(3240,'accesslib/dirtycontexts','/1/84/3367',1756272287,'1',1756301087),(3241,'accesslib/dirtycontexts','/1/84/3368',1756272288,'1',1756301088),(3242,'accesslib/dirtycontexts','/1/84/3369',1756272288,'1',1756301088),(3243,'accesslib/dirtycontexts','/1/84/3370',1756272288,'1',1756301088),(3244,'accesslib/dirtycontexts','/1/84/3371',1756272288,'1',1756301088),(3245,'accesslib/dirtycontexts','/1/84/3372',1756272288,'1',1756301088),(3246,'accesslib/dirtycontexts','/1/84/3373',1756272289,'1',1756301089),(3247,'accesslib/dirtycontexts','/1/84/3374',1756272289,'1',1756301089),(3248,'accesslib/dirtycontexts','/1/84/3375',1756272289,'1',1756301089),(3249,'accesslib/dirtycontexts','/1/84/3376',1756272289,'1',1756301089),(3250,'accesslib/dirtycontexts','/1/84/3377',1756272289,'1',1756301089),(3251,'accesslib/dirtycontexts','/1/84/3378',1756272290,'1',1756301090),(3252,'accesslib/dirtycontexts','/1/84/3379',1756272290,'1',1756301090),(3253,'accesslib/dirtycontexts','/1/84/3380',1756272291,'1',1756301091),(3254,'accesslib/dirtycontexts','/1/84/3381',1756272291,'1',1756301091),(3255,'accesslib/dirtycontexts','/1/84/3382',1756272291,'1',1756301091),(3256,'accesslib/dirtycontexts','/1/84/3383',1756272291,'1',1756301091),(3257,'accesslib/dirtycontexts','/1/84/3384',1756272291,'1',1756301091),(3258,'accesslib/dirtycontexts','/1/84/3385',1756272291,'1',1756301091),(3259,'accesslib/dirtycontexts','/1/84/3386',1756272292,'1',1756301092),(3260,'accesslib/dirtycontexts','/1/84/3387',1756272292,'1',1756301092),(3261,'accesslib/dirtycontexts','/1/84/3388',1756272292,'1',1756301092),(3262,'accesslib/dirtycontexts','/1/84/3389',1756272292,'1',1756301092),(3263,'accesslib/dirtycontexts','/1/84/3390',1756272292,'1',1756301092),(3264,'accesslib/dirtycontexts','/1/84/3391',1756272293,'1',1756301093),(3265,'accesslib/dirtycontexts','/1/84/3392',1756272293,'1',1756301093),(3266,'accesslib/dirtycontexts','/1/84/3393',1756272293,'1',1756301093),(3267,'accesslib/dirtycontexts','/1/84/3394',1756272293,'1',1756301093),(3268,'accesslib/dirtycontexts','/1/84/3395',1756272293,'1',1756301093),(3269,'accesslib/dirtycontexts','/1/84/3396',1756272293,'1',1756301093),(3270,'accesslib/dirtycontexts','/1/84/3397',1756272294,'1',1756301094),(3271,'accesslib/dirtycontexts','/1/84/3398',1756272294,'1',1756301094),(3272,'accesslib/dirtycontexts','/1/84/3399',1756272294,'1',1756301094),(3273,'accesslib/dirtycontexts','/1/84/3400',1756272294,'1',1756301094),(3274,'accesslib/dirtycontexts','/1/84/3401',1756272294,'1',1756301094),(3275,'accesslib/dirtycontexts','/1/84/3402',1756272295,'1',1756301095),(3276,'accesslib/dirtycontexts','/1/84/3403',1756272295,'1',1756301095),(3277,'accesslib/dirtycontexts','/1/84/3404',1756272295,'1',1756301095),(3278,'accesslib/dirtycontexts','/1/84/3405',1756272295,'1',1756301095),(3279,'accesslib/dirtycontexts','/1/84/3406',1756272295,'1',1756301095),(3280,'accesslib/dirtycontexts','/1/84/3407',1756272296,'1',1756301096),(3281,'accesslib/dirtycontexts','/1/84/3408',1756272296,'1',1756301096),(3282,'accesslib/dirtycontexts','/1/84/3409',1756272296,'1',1756301096),(3283,'accesslib/dirtycontexts','/1/84/3410',1756272296,'1',1756301096),(3284,'accesslib/dirtycontexts','/1/84/3411',1756272296,'1',1756301096),(3285,'accesslib/dirtycontexts','/1/84/3412',1756272296,'1',1756301096),(3286,'accesslib/dirtycontexts','/1/84/3413',1756272297,'1',1756301097),(3287,'accesslib/dirtycontexts','/1/84/3414',1756272297,'1',1756301097),(3288,'accesslib/dirtycontexts','/1/84/3415',1756272297,'1',1756301097),(3289,'accesslib/dirtycontexts','/1/84/3416',1756272297,'1',1756301097),(3290,'accesslib/dirtycontexts','/1/84/3417',1756272297,'1',1756301097),(3291,'accesslib/dirtycontexts','/1/84/3418',1756272298,'1',1756301098),(3292,'accesslib/dirtycontexts','/1/84/3419',1756272298,'1',1756301098),(3293,'accesslib/dirtycontexts','/1/84/3420',1756272298,'1',1756301098),(3294,'accesslib/dirtycontexts','/1/84/3421',1756272298,'1',1756301098),(3295,'accesslib/dirtycontexts','/1/84/3422',1756272298,'1',1756301098),(3296,'accesslib/dirtycontexts','/1/84/3423',1756272298,'1',1756301098),(3297,'accesslib/dirtycontexts','/1/84/3424',1756272299,'1',1756301099),(3298,'accesslib/dirtycontexts','/1/84/3425',1756272299,'1',1756301099),(3299,'accesslib/dirtycontexts','/1/84/3426',1756272299,'1',1756301099),(3300,'accesslib/dirtycontexts','/1/84/3427',1756272299,'1',1756301099),(3301,'accesslib/dirtycontexts','/1/84/3428',1756272299,'1',1756301099),(3302,'accesslib/dirtycontexts','/1/84/3429',1756272300,'1',1756301100),(3303,'accesslib/dirtycontexts','/1/84/3430',1756272300,'1',1756301100),(3304,'accesslib/dirtycontexts','/1/84/3431',1756272300,'1',1756301100),(3305,'accesslib/dirtycontexts','/1/84/3432',1756272300,'1',1756301100),(3306,'accesslib/dirtycontexts','/1/84/3433',1756272300,'1',1756301100),(3307,'accesslib/dirtycontexts','/1/84/3434',1756272301,'1',1756301101),(3308,'accesslib/dirtycontexts','/1/84/3435',1756272301,'1',1756301101),(3309,'accesslib/dirtycontexts','/1/84/3436',1756272301,'1',1756301101),(3310,'accesslib/dirtycontexts','/1/84/3437',1756272301,'1',1756301101),(3311,'accesslib/dirtycontexts','/1/84/3438',1756272301,'1',1756301101),(3312,'accesslib/dirtycontexts','/1/84/3439',1756272302,'1',1756301102),(3313,'accesslib/dirtycontexts','/1/84/3440',1756272302,'1',1756301102),(3314,'accesslib/dirtycontexts','/1/84/3441',1756272302,'1',1756301102),(3315,'accesslib/dirtycontexts','/1/84/3442',1756272302,'1',1756301102),(3316,'accesslib/dirtycontexts','/1/84/3443',1756272302,'1',1756301102),(3317,'accesslib/dirtycontexts','/1/84/3444',1756272303,'1',1756301103),(3318,'accesslib/dirtycontexts','/1/84/3445',1756272303,'1',1756301103),(3319,'accesslib/dirtycontexts','/1/84/3446',1756272303,'1',1756301103),(3320,'accesslib/dirtycontexts','/1/84/3447',1756272303,'1',1756301103),(3321,'accesslib/dirtycontexts','/1/84/3448',1756272303,'1',1756301103),(3322,'accesslib/dirtycontexts','/1/84/3449',1756272304,'1',1756301104),(3323,'accesslib/dirtycontexts','/1/84/3450',1756272304,'1',1756301104),(3324,'accesslib/dirtycontexts','/1/84/3451',1756272304,'1',1756301104),(3325,'accesslib/dirtycontexts','/1/84/3452',1756272304,'1',1756301104),(3326,'accesslib/dirtycontexts','/1/84/3453',1756272304,'1',1756301104),(3327,'accesslib/dirtycontexts','/1/84/3454',1756272305,'1',1756301105),(3328,'accesslib/dirtycontexts','/1/84/3455',1756272305,'1',1756301105),(3329,'accesslib/dirtycontexts','/1/84/3456',1756272305,'1',1756301105),(3330,'accesslib/dirtycontexts','/1/84/3457',1756272305,'1',1756301105),(3331,'accesslib/dirtycontexts','/1/84/3458',1756272305,'1',1756301105),(3332,'accesslib/dirtycontexts','/1/84/3459',1756272306,'1',1756301106),(3333,'accesslib/dirtycontexts','/1/84/3460',1756272306,'1',1756301106),(3334,'accesslib/dirtycontexts','/1/84/3461',1756272306,'1',1756301106),(3335,'accesslib/dirtycontexts','/1/84/3462',1756272306,'1',1756301106),(3336,'accesslib/dirtycontexts','/1/84/3463',1756272306,'1',1756301106),(3337,'accesslib/dirtycontexts','/1/84/3464',1756272306,'1',1756301106),(3338,'accesslib/dirtycontexts','/1/84/3465',1756272307,'1',1756301107),(3339,'accesslib/dirtycontexts','/1/84/3466',1756272307,'1',1756301107),(3340,'accesslib/dirtycontexts','/1/84/3467',1756272307,'1',1756301107),(3341,'accesslib/dirtycontexts','/1/84/3468',1756272307,'1',1756301107),(3342,'accesslib/dirtycontexts','/1/84/3469',1756272308,'1',1756301108),(3343,'accesslib/dirtycontexts','/1/84/3470',1756272308,'1',1756301108),(3344,'accesslib/dirtycontexts','/1/84/3471',1756272308,'1',1756301108),(3345,'accesslib/dirtycontexts','/1/84/3472',1756272308,'1',1756301108),(3346,'accesslib/dirtycontexts','/1/84/3473',1756272308,'1',1756301108),(3347,'accesslib/dirtycontexts','/1/84/3474',1756272309,'1',1756301109),(3348,'accesslib/dirtycontexts','/1/84/3475',1756272309,'1',1756301109),(3349,'accesslib/dirtycontexts','/1/84/3476',1756272309,'1',1756301109),(3350,'accesslib/dirtycontexts','/1/84/3477',1756272309,'1',1756301109),(3351,'accesslib/dirtycontexts','/1/84/3478',1756272309,'1',1756301109),(3352,'accesslib/dirtycontexts','/1/84/3479',1756272309,'1',1756301109),(3353,'accesslib/dirtycontexts','/1/84/3480',1756272310,'1',1756301110),(3354,'accesslib/dirtycontexts','/1/84/3481',1756272310,'1',1756301110),(3355,'accesslib/dirtycontexts','/1/84/3482',1756272310,'1',1756301110),(3356,'accesslib/dirtycontexts','/1/84/3483',1756272310,'1',1756301110),(3357,'accesslib/dirtycontexts','/1/84/3484',1756272310,'1',1756301110),(3358,'accesslib/dirtycontexts','/1/84/3485',1756272311,'1',1756301111),(3359,'accesslib/dirtycontexts','/1/84/3486',1756272311,'1',1756301111),(3360,'accesslib/dirtycontexts','/1/84/3487',1756272311,'1',1756301111),(3361,'accesslib/dirtycontexts','/1/84/3488',1756272311,'1',1756301111),(3362,'accesslib/dirtycontexts','/1/84/3489',1756272311,'1',1756301111),(3363,'accesslib/dirtycontexts','/1/84/3490',1756272312,'1',1756301112),(3364,'accesslib/dirtycontexts','/1/84/3491',1756272312,'1',1756301112),(3365,'accesslib/dirtycontexts','/1/84/3492',1756272312,'1',1756301112),(3366,'accesslib/dirtycontexts','/1/84/3493',1756272312,'1',1756301112),(3367,'accesslib/dirtycontexts','/1/84/3494',1756272312,'1',1756301112),(3368,'accesslib/dirtycontexts','/1/84/3495',1756272313,'1',1756301113),(3369,'accesslib/dirtycontexts','/1/84/3496',1756272313,'1',1756301113),(3370,'accesslib/dirtycontexts','/1/84/3497',1756272313,'1',1756301113),(3371,'accesslib/dirtycontexts','/1/84/3498',1756272313,'1',1756301113),(3372,'accesslib/dirtycontexts','/1/84/3499',1756272313,'1',1756301113),(3373,'accesslib/dirtycontexts','/1/84/3500',1756272314,'1',1756301114),(3374,'accesslib/dirtycontexts','/1/84/3501',1756272314,'1',1756301114),(3375,'accesslib/dirtycontexts','/1/84/3502',1756272314,'1',1756301114),(3376,'accesslib/dirtycontexts','/1/84/3503',1756272314,'1',1756301114),(3377,'accesslib/dirtycontexts','/1/84/3504',1756272314,'1',1756301114),(3378,'accesslib/dirtycontexts','/1/84/3505',1756272315,'1',1756301115),(3379,'accesslib/dirtycontexts','/1/84/3506',1756272315,'1',1756301115),(3380,'accesslib/dirtycontexts','/1/84/3507',1756272316,'1',1756301116),(3381,'accesslib/dirtycontexts','/1/84/3508',1756272316,'1',1756301116),(3382,'accesslib/dirtycontexts','/1/84/3509',1756272316,'1',1756301116),(3383,'accesslib/dirtycontexts','/1/84/3510',1756272316,'1',1756301116),(3384,'accesslib/dirtycontexts','/1/84/3511',1756272316,'1',1756301116),(3385,'accesslib/dirtycontexts','/1/84/3512',1756272317,'1',1756301117),(3386,'accesslib/dirtycontexts','/1/84/3513',1756272317,'1',1756301117),(3387,'accesslib/dirtycontexts','/1/84/3514',1756272317,'1',1756301117),(3388,'accesslib/dirtycontexts','/1/84/3515',1756272317,'1',1756301117),(3389,'accesslib/dirtycontexts','/1/84/3516',1756272317,'1',1756301117),(3390,'accesslib/dirtycontexts','/1/84/3517',1756272318,'1',1756301118),(3391,'accesslib/dirtycontexts','/1/84/3518',1756272318,'1',1756301118),(3392,'accesslib/dirtycontexts','/1/84/3519',1756272318,'1',1756301118),(3393,'accesslib/dirtycontexts','/1/84/3520',1756272318,'1',1756301118),(3394,'accesslib/dirtycontexts','/1/84/3521',1756272318,'1',1756301118),(3395,'accesslib/dirtycontexts','/1/84/3522',1756272318,'1',1756301118),(3396,'accesslib/dirtycontexts','/1/84/3523',1756272319,'1',1756301119),(3397,'accesslib/dirtycontexts','/1/84/3524',1756272319,'1',1756301119),(3398,'accesslib/dirtycontexts','/1/84/3525',1756272319,'1',1756301119),(3399,'accesslib/dirtycontexts','/1/84/3526',1756272319,'1',1756301119),(3400,'accesslib/dirtycontexts','/1/84/3527',1756272319,'1',1756301119),(3401,'accesslib/dirtycontexts','/1/84/3528',1756272320,'1',1756301120),(3402,'accesslib/dirtycontexts','/1/84/3529',1756272320,'1',1756301120),(3403,'accesslib/dirtycontexts','/1/84/3530',1756272320,'1',1756301120),(3404,'accesslib/dirtycontexts','/1/84/3531',1756272320,'1',1756301120),(3405,'accesslib/dirtycontexts','/1/84/3532',1756272321,'1',1756301121),(3406,'accesslib/dirtycontexts','/1/84/3533',1756272321,'1',1756301121),(3407,'accesslib/dirtycontexts','/1/84/3534',1756272321,'1',1756301121),(3408,'accesslib/dirtycontexts','/1/84/3535',1756272321,'1',1756301121),(3409,'accesslib/dirtycontexts','/1/84/3536',1756272321,'1',1756301121),(3410,'accesslib/dirtycontexts','/1/84/3537',1756272322,'1',1756301122),(3411,'accesslib/dirtycontexts','/1/84/3538',1756272322,'1',1756301122),(3412,'accesslib/dirtycontexts','/1/84/3539',1756272322,'1',1756301122),(3413,'accesslib/dirtycontexts','/1/84/3540',1756272322,'1',1756301122),(3414,'accesslib/dirtycontexts','/1/84/3541',1756272322,'1',1756301122),(3415,'accesslib/dirtycontexts','/1/84/3542',1756272322,'1',1756301122),(3416,'accesslib/dirtycontexts','/1/84/3543',1756272323,'1',1756301123),(3417,'accesslib/dirtycontexts','/1/84/3544',1756272323,'1',1756301123),(3418,'accesslib/dirtycontexts','/1/84/3545',1756272323,'1',1756301123),(3419,'accesslib/dirtycontexts','/1/84/3546',1756272323,'1',1756301123),(3420,'accesslib/dirtycontexts','/1/84/3547',1756272323,'1',1756301123),(3421,'accesslib/dirtycontexts','/1/84/3548',1756272324,'1',1756301124),(3422,'accesslib/dirtycontexts','/1/84/3549',1756272324,'1',1756301124),(3423,'accesslib/dirtycontexts','/1/84/3550',1756272324,'1',1756301124),(3424,'accesslib/dirtycontexts','/1/84/3551',1756272324,'1',1756301124),(3425,'accesslib/dirtycontexts','/1/84/3302',1756272272,'1',1756301072),(3426,'accesslib/dirtycontexts','/1/84/3563',1756382220,'1',1756411020),(3427,'userpreferenceschanged','46',1756444762,'1',1756473562),(3428,'accesslib/dirtyusers','46',1756446862,'1',1756475662),(3429,'userpreferenceschanged','47',1756446624,'1',1756475424),(3430,'accesslib/dirtyusers','47',1756446853,'1',1756475653),(3431,'userpreferenceschanged','48',1756446910,'1',1756475710),(3432,'accesslib/dirtyusers','48',1758277180,'1',1758305980),(3433,'accesslib/dirtyusers','49',1758086723,'1',1758115523),(3434,'userpreferenceschanged','49',1757481266,'1',1757510066),(3435,'accesslib/dirtyusers','50',1758086673,'1',1758115473),(3436,'userpreferenceschanged','50',1757495845,'1',1757524645),(3437,'accesslib/dirtyusers','51',1758086659,'1',1758115459),(3438,'userpreferenceschanged','51',1757483547,'1',1757512347),(3439,'userpreferenceschanged','52',1758537828,'1',1758566628),(3440,'accesslib/dirtyusers','52',1758541739,'1',1758570539),(3441,'userpreferenceschanged','53',1757483993,'1',1757512793),(3442,'accesslib/dirtyusers','53',1758097488,'1',1758126288),(3443,'userpreferenceschanged','54',1757919276,'1',1757948076),(3444,'accesslib/dirtyusers','54',1758541755,'1',1758570555),(3445,'userpreferenceschanged','55',1757488713,'1',1757517513),(3446,'accesslib/dirtyusers','55',1758100824,'1',1758129624),(3447,'userpreferenceschanged','56',1757490833,'1',1757519633),(3448,'accesslib/dirtyusers','56',1758100601,'1',1758129401),(3449,'userpreferenceschanged','57',1757500815,'1',1757529615),(3450,'accesslib/dirtyusers','57',1758100679,'1',1758129479),(3451,'userpreferenceschanged','58',1757502168,'1',1757530968),(3452,'accesslib/dirtyusers','58',1758100538,'1',1758129338),(3453,'userpreferenceschanged','59',1757503727,'1',1757532527),(3454,'accesslib/dirtyusers','59',1758100694,'1',1758129494),(3455,'userpreferenceschanged','60',1757564924,'1',1757593724),(3456,'accesslib/dirtyusers','60',1758100628,'1',1758129428),(3457,'userpreferenceschanged','61',1757565014,'1',1757593814),(3458,'accesslib/dirtyusers','61',1758100556,'1',1758129356),(3459,'userpreferenceschanged','62',1757566505,'1',1757595305),(3460,'accesslib/dirtyusers','62',1758100638,'1',1758129438),(3461,'accesslib/dirtycontexts','/1/3/3613',1757564572,'1',1757593372),(3462,'userpreferenceschanged','63',1757567360,'1',1757596160),(3463,'accesslib/dirtyusers','63',1758542340,'1',1758571140),(3464,'userpreferenceschanged','64',1757656463,'1',1757685263),(3465,'accesslib/dirtyusers','64',1757913221,'1',1757942021),(3466,'userpreferenceschanged','65',1757658048,'1',1757686848),(3467,'accesslib/dirtyusers','65',1758100837,'1',1758129637),(3468,'accesslib/dirtyusers','66',1758100648,'1',1758129448),(3469,'userpreferenceschanged','66',1757664266,'1',1757693066),(3470,'accesslib/dirtyusers','67',1758100529,'1',1758129329),(3471,'userpreferenceschanged','67',1757664267,'1',1757693067),(3472,'accesslib/dirtyusers','68',1757674581,'1',1757703381),(3473,'userpreferenceschanged','68',1757674175,'1',1757702975),(3474,'accesslib/dirtyusers','69',1757674590,'1',1757703390),(3475,'userpreferenceschanged','69',1757674176,'1',1757702976),(3476,'accesslib/dirtyusers','70',1757674564,'1',1757703364),(3477,'userpreferenceschanged','70',1757674177,'1',1757702977),(3478,'accesslib/dirtyusers','71',1757674716,'1',1757703516),(3479,'userpreferenceschanged','71',1757674614,'1',1757703414),(3480,'accesslib/dirtyusers','72',1757674706,'1',1757703506),(3481,'userpreferenceschanged','72',1757674615,'1',1757703415),(3482,'accesslib/dirtyusers','73',1757674693,'1',1757703493),(3483,'userpreferenceschanged','73',1757674616,'1',1757703416),(3484,'accesslib/dirtyusers','74',1758086628,'1',1758115428),(3485,'userpreferenceschanged','74',1757674838,'1',1757703638),(3486,'accesslib/dirtyusers','75',1758086618,'1',1758115418),(3487,'userpreferenceschanged','75',1757674840,'1',1757703640),(3488,'accesslib/dirtyusers','76',1758086709,'1',1758115509),(3489,'userpreferenceschanged','76',1757674842,'1',1757703642),(3490,'userpreferenceschanged','77',1758085885,'1',1758114685),(3491,'accesslib/dirtyusers','77',1758100780,'1',1758129580),(3492,'userpreferenceschanged','78',1758001926,'1',1758030726),(3493,'accesslib/dirtyusers','78',1758100361,'1',1758129161),(3494,'userpreferenceschanged','79',1758086858,'1',1758115658),(3495,'accesslib/dirtyusers','79',1758100480,'1',1758129280),(3496,'userpreferenceschanged','80',1758087184,'1',1758115984),(3497,'accesslib/dirtyusers','80',1758100615,'1',1758129415),(3498,'userpreferenceschanged','81',1758276454,'1',1758305254),(3499,'accesslib/dirtyusers','81',1758539847,'1',1758568647),(3500,'userpreferenceschanged','82',1758276697,'1',1758305497),(3501,'accesslib/dirtyusers','82',1758277151,'1',1758305951),(3502,'userpreferenceschanged','83',1758366101,'1',1758394901),(3503,'accesslib/dirtyusers','83',1758539834,'1',1758568634),(3504,'userpreferenceschanged','84',1758432741,'1',1758461541),(3505,'accesslib/dirtyusers','84',1758539868,'1',1758568668),(3506,'userpreferenceschanged','85',1758524244,'1',1758553044),(3507,'accesslib/dirtyusers','85',1758524671,'1',1758553471),(3508,'userpreferenceschanged','86',1758525335,'1',1758554135),(3509,'accesslib/dirtyusers','86',1758526319,'1',1758555119),(3510,'userpreferenceschanged','87',1758527328,'1',1758556128),(3511,'accesslib/dirtyusers','87',1758541772,'1',1758570572),(3512,'accesslib/dirtyusers','88',1758544360,'1',1758573160),(3513,'accesslib/dirtyusers','89',1758547486,'1',1758576286),(3514,'userpreferenceschanged','89',1758547236,'1',1758576036);
/*!40000 ALTER TABLE `mdl_cache_flags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_capabilities`
--

DROP TABLE IF EXISTS `mdl_capabilities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_capabilities` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `captype` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contextlevel` bigint NOT NULL DEFAULT '0',
  `component` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `riskbitmask` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_capa_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=715 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='this defines all capabilities';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_capabilities`
--

LOCK TABLES `mdl_capabilities` WRITE;
/*!40000 ALTER TABLE `mdl_capabilities` DISABLE KEYS */;
INSERT INTO `mdl_capabilities` VALUES (1,'moodle/site:config','write',10,'moodle',62),(2,'moodle/site:configview','read',10,'moodle',0),(3,'moodle/site:readallmessages','read',10,'moodle',8),(4,'moodle/site:manageallmessaging','write',10,'moodle',8),(5,'moodle/site:deleteanymessage','write',10,'moodle',32),(6,'moodle/site:sendmessage','write',10,'moodle',16),(7,'moodle/site:senderrormessage','write',10,'moodle',16),(8,'moodle/site:deleteownmessage','write',10,'moodle',0),(9,'moodle/site:approvecourse','write',40,'moodle',4),(10,'moodle/backup:backupcourse','write',50,'moodle',28),(11,'moodle/backup:backupsection','write',50,'moodle',28),(12,'moodle/backup:backupactivity','write',70,'moodle',28),(13,'moodle/backup:backuptargetimport','read',50,'moodle',28),(14,'moodle/backup:downloadfile','write',50,'moodle',28),(15,'moodle/backup:configure','write',50,'moodle',28),(16,'moodle/backup:userinfo','read',50,'moodle',8),(17,'moodle/backup:anonymise','read',50,'moodle',8),(18,'moodle/restore:restorecourse','write',50,'moodle',28),(19,'moodle/restore:restoresection','write',50,'moodle',28),(20,'moodle/restore:restoreactivity','write',50,'moodle',28),(21,'moodle/restore:viewautomatedfilearea','write',50,'moodle',28),(22,'moodle/restore:restoretargetimport','write',50,'moodle',28),(23,'moodle/restore:uploadfile','write',50,'moodle',28),(24,'moodle/restore:configure','write',50,'moodle',28),(25,'moodle/restore:rolldates','write',50,'moodle',0),(26,'moodle/restore:userinfo','write',50,'moodle',30),(27,'moodle/restore:createuser','write',10,'moodle',24),(28,'moodle/site:manageblocks','write',80,'moodle',20),(29,'moodle/site:accessallgroups','read',70,'moodle',0),(30,'moodle/site:viewanonymousevents','read',70,'moodle',8),(31,'moodle/site:viewfullnames','read',70,'moodle',0),(32,'moodle/site:viewuseridentity','read',70,'moodle',0),(33,'moodle/site:viewreports','read',50,'moodle',8),(34,'moodle/site:trustcontent','write',70,'moodle',4),(35,'moodle/site:uploadusers','write',10,'moodle',24),(36,'moodle/filter:manage','write',50,'moodle',0),(37,'moodle/user:create','write',10,'moodle',24),(38,'moodle/user:delete','write',10,'moodle',40),(39,'moodle/user:update','write',10,'moodle',24),(40,'moodle/user:viewdetails','read',50,'moodle',0),(41,'moodle/user:viewalldetails','read',30,'moodle',8),(42,'moodle/user:viewlastip','read',30,'moodle',8),(43,'moodle/user:viewhiddendetails','read',50,'moodle',8),(44,'moodle/user:loginas','write',50,'moodle',30),(45,'moodle/user:managesyspages','write',10,'moodle',0),(46,'moodle/user:manageblocks','write',30,'moodle',0),(47,'moodle/user:manageownblocks','write',10,'moodle',0),(48,'moodle/user:manageownfiles','write',10,'moodle',0),(49,'moodle/user:ignoreuserquota','write',10,'moodle',0),(50,'moodle/my:configsyspages','write',10,'moodle',0),(51,'moodle/role:assign','write',50,'moodle',28),(52,'moodle/role:review','read',50,'moodle',8),(53,'moodle/role:override','write',50,'moodle',28),(54,'moodle/role:safeoverride','write',50,'moodle',16),(55,'moodle/role:manage','write',10,'moodle',28),(56,'moodle/role:switchroles','read',50,'moodle',12),(57,'moodle/category:manage','write',40,'moodle',4),(58,'moodle/category:viewcourselist','read',40,'moodle',0),(59,'moodle/category:viewhiddencategories','read',40,'moodle',0),(60,'moodle/cohort:manage','write',40,'moodle',0),(61,'moodle/cohort:assign','write',40,'moodle',0),(62,'moodle/cohort:view','read',50,'moodle',0),(63,'moodle/course:create','write',40,'moodle',4),(64,'moodle/course:creategroupconversations','write',50,'moodle',4),(65,'moodle/course:request','write',40,'moodle',0),(66,'moodle/course:delete','write',50,'moodle',32),(67,'moodle/course:update','write',50,'moodle',4),(68,'moodle/course:view','read',50,'moodle',0),(69,'moodle/course:enrolreview','read',50,'moodle',8),(70,'moodle/course:enrolconfig','write',50,'moodle',8),(71,'moodle/course:reviewotherusers','read',50,'moodle',0),(72,'moodle/course:bulkmessaging','write',50,'moodle',16),(73,'moodle/course:viewhiddenuserfields','read',50,'moodle',8),(74,'moodle/course:viewhiddencourses','read',50,'moodle',0),(75,'moodle/course:visibility','write',50,'moodle',0),(76,'moodle/course:managefiles','write',50,'moodle',4),(77,'moodle/course:ignoreavailabilityrestrictions','read',70,'moodle',0),(78,'moodle/course:ignorefilesizelimits','write',50,'moodle',0),(79,'moodle/course:manageactivities','write',70,'moodle',4),(80,'moodle/course:activityvisibility','write',70,'moodle',0),(81,'moodle/course:viewhiddenactivities','read',70,'moodle',0),(82,'moodle/course:viewparticipants','read',50,'moodle',0),(83,'moodle/course:changefullname','write',50,'moodle',4),(84,'moodle/course:changeshortname','write',50,'moodle',4),(85,'moodle/course:changelockedcustomfields','write',50,'moodle',16),(86,'moodle/course:configurecustomfields','write',10,'moodle',16),(87,'moodle/course:renameroles','write',50,'moodle',0),(88,'moodle/course:changeidnumber','write',50,'moodle',4),(89,'moodle/course:changecategory','write',50,'moodle',4),(90,'moodle/course:changesummary','write',50,'moodle',4),(91,'moodle/course:setforcedlanguage','write',50,'moodle',0),(92,'moodle/site:viewparticipants','read',10,'moodle',0),(93,'moodle/course:isincompletionreports','read',50,'moodle',0),(94,'moodle/course:viewscales','read',50,'moodle',0),(95,'moodle/course:managescales','write',50,'moodle',0),(96,'moodle/course:managegroups','write',50,'moodle',4),(97,'moodle/course:reset','write',50,'moodle',32),(98,'moodle/course:viewsuspendedusers','read',50,'moodle',0),(99,'moodle/course:tag','write',50,'moodle',16),(100,'moodle/blog:view','read',10,'moodle',0),(101,'moodle/blog:search','read',10,'moodle',0),(102,'moodle/blog:viewdrafts','read',10,'moodle',8),(103,'moodle/blog:create','write',10,'moodle',16),(104,'moodle/blog:manageentries','write',10,'moodle',16),(105,'moodle/blog:manageexternal','write',10,'moodle',16),(106,'moodle/calendar:manageownentries','write',50,'moodle',16),(107,'moodle/calendar:managegroupentries','write',50,'moodle',16),(108,'moodle/calendar:manageentries','write',50,'moodle',16),(109,'moodle/user:editprofile','write',30,'moodle',24),(110,'moodle/user:editownprofile','write',10,'moodle',16),(111,'moodle/user:changeownpassword','write',10,'moodle',0),(112,'moodle/user:readuserposts','read',30,'moodle',0),(113,'moodle/user:readuserblogs','read',30,'moodle',0),(114,'moodle/user:viewuseractivitiesreport','read',30,'moodle',8),(115,'moodle/user:editmessageprofile','write',30,'moodle',16),(116,'moodle/user:editownmessageprofile','write',10,'moodle',0),(117,'moodle/question:managecategory','write',50,'moodle',20),(118,'moodle/question:add','write',50,'moodle',20),(119,'moodle/question:editmine','write',50,'moodle',20),(120,'moodle/question:editall','write',50,'moodle',20),(121,'moodle/question:viewmine','read',50,'moodle',0),(122,'moodle/question:viewall','read',50,'moodle',0),(123,'moodle/question:usemine','read',50,'moodle',0),(124,'moodle/question:useall','read',50,'moodle',0),(125,'moodle/question:movemine','write',50,'moodle',0),(126,'moodle/question:moveall','write',50,'moodle',0),(127,'moodle/question:config','write',10,'moodle',2),(128,'moodle/question:flag','write',50,'moodle',0),(129,'moodle/question:tagmine','write',50,'moodle',0),(130,'moodle/question:tagall','write',50,'moodle',0),(131,'moodle/site:doclinks','read',10,'moodle',0),(132,'moodle/course:sectionvisibility','write',50,'moodle',0),(133,'moodle/course:useremail','write',50,'moodle',0),(134,'moodle/course:viewhiddensections','read',50,'moodle',0),(135,'moodle/course:setcurrentsection','write',50,'moodle',0),(136,'moodle/course:movesections','write',50,'moodle',0),(137,'moodle/site:mnetlogintoremote','read',10,'moodle',0),(138,'moodle/grade:viewall','read',50,'moodle',8),(139,'moodle/grade:view','read',50,'moodle',0),(140,'moodle/grade:viewhidden','read',50,'moodle',8),(141,'moodle/grade:import','write',50,'moodle',12),(142,'moodle/grade:export','read',50,'moodle',8),(143,'moodle/grade:manage','write',50,'moodle',12),(144,'moodle/grade:edit','write',50,'moodle',12),(145,'moodle/grade:managegradingforms','write',50,'moodle',12),(146,'moodle/grade:sharegradingforms','write',10,'moodle',4),(147,'moodle/grade:managesharedforms','write',10,'moodle',4),(148,'moodle/grade:manageoutcomes','write',50,'moodle',0),(149,'moodle/grade:manageletters','write',50,'moodle',0),(150,'moodle/grade:hide','write',50,'moodle',0),(151,'moodle/grade:lock','write',50,'moodle',0),(152,'moodle/grade:unlock','write',50,'moodle',0),(153,'moodle/my:manageblocks','write',10,'moodle',0),(154,'moodle/notes:view','read',50,'moodle',0),(155,'moodle/notes:manage','write',50,'moodle',16),(156,'moodle/tag:manage','write',10,'moodle',16),(157,'moodle/tag:edit','write',10,'moodle',16),(158,'moodle/tag:flag','write',10,'moodle',16),(159,'moodle/tag:editblocks','write',10,'moodle',0),(160,'moodle/block:view','read',80,'moodle',0),(161,'moodle/block:edit','write',80,'moodle',20),(162,'moodle/portfolio:export','read',10,'moodle',0),(163,'moodle/comment:view','read',50,'moodle',0),(164,'moodle/comment:post','write',50,'moodle',24),(165,'moodle/comment:delete','write',50,'moodle',32),(166,'moodle/webservice:createtoken','write',10,'moodle',62),(167,'moodle/webservice:managealltokens','write',10,'moodle',42),(168,'moodle/webservice:createmobiletoken','write',10,'moodle',24),(169,'moodle/rating:view','read',50,'moodle',0),(170,'moodle/rating:viewany','read',50,'moodle',8),(171,'moodle/rating:viewall','read',50,'moodle',8),(172,'moodle/rating:rate','write',50,'moodle',0),(173,'moodle/course:markcomplete','write',50,'moodle',0),(174,'moodle/course:overridecompletion','write',50,'moodle',0),(175,'moodle/badges:manageglobalsettings','write',10,'moodle',34),(176,'moodle/badges:viewbadges','read',50,'moodle',0),(177,'moodle/badges:manageownbadges','write',30,'moodle',0),(178,'moodle/badges:viewotherbadges','read',30,'moodle',0),(179,'moodle/badges:earnbadge','write',50,'moodle',0),(180,'moodle/badges:createbadge','write',50,'moodle',16),(181,'moodle/badges:deletebadge','write',50,'moodle',32),(182,'moodle/badges:configuredetails','write',50,'moodle',16),(183,'moodle/badges:configurecriteria','write',50,'moodle',4),(184,'moodle/badges:configuremessages','write',50,'moodle',16),(185,'moodle/badges:awardbadge','write',50,'moodle',16),(186,'moodle/badges:revokebadge','write',50,'moodle',16),(187,'moodle/badges:viewawarded','read',50,'moodle',8),(188,'moodle/site:forcelanguage','read',10,'moodle',0),(189,'moodle/search:query','read',10,'moodle',0),(190,'moodle/competency:competencymanage','write',40,'moodle',0),(191,'moodle/competency:competencyview','read',40,'moodle',0),(192,'moodle/competency:competencygrade','write',50,'moodle',0),(193,'moodle/competency:coursecompetencymanage','write',50,'moodle',0),(194,'moodle/competency:coursecompetencyconfigure','write',70,'moodle',0),(195,'moodle/competency:coursecompetencygradable','read',50,'moodle',0),(196,'moodle/competency:coursecompetencyview','read',50,'moodle',0),(197,'moodle/competency:evidencedelete','write',30,'moodle',0),(198,'moodle/competency:planmanage','write',30,'moodle',0),(199,'moodle/competency:planmanagedraft','write',30,'moodle',0),(200,'moodle/competency:planmanageown','write',30,'moodle',0),(201,'moodle/competency:planmanageowndraft','write',30,'moodle',0),(202,'moodle/competency:planview','read',30,'moodle',0),(203,'moodle/competency:planviewdraft','read',30,'moodle',0),(204,'moodle/competency:planviewown','read',30,'moodle',0),(205,'moodle/competency:planviewowndraft','read',30,'moodle',0),(206,'moodle/competency:planrequestreview','write',30,'moodle',0),(207,'moodle/competency:planrequestreviewown','write',30,'moodle',0),(208,'moodle/competency:planreview','write',30,'moodle',0),(209,'moodle/competency:plancomment','write',30,'moodle',0),(210,'moodle/competency:plancommentown','write',30,'moodle',0),(211,'moodle/competency:usercompetencyview','read',30,'moodle',0),(212,'moodle/competency:usercompetencyrequestreview','write',30,'moodle',0),(213,'moodle/competency:usercompetencyrequestreviewown','write',30,'moodle',0),(214,'moodle/competency:usercompetencyreview','write',30,'moodle',0),(215,'moodle/competency:usercompetencycomment','write',30,'moodle',0),(216,'moodle/competency:usercompetencycommentown','write',30,'moodle',0),(217,'moodle/competency:templatemanage','write',40,'moodle',0),(218,'moodle/analytics:listinsights','read',50,'moodle',8),(219,'moodle/analytics:managemodels','write',10,'moodle',2),(220,'moodle/competency:templateview','read',40,'moodle',0),(221,'moodle/competency:userevidencemanage','write',30,'moodle',0),(222,'moodle/competency:userevidencemanageown','write',30,'moodle',0),(223,'moodle/competency:userevidenceview','read',30,'moodle',0),(224,'moodle/site:maintenanceaccess','write',10,'moodle',0),(225,'moodle/site:messageanyuser','write',10,'moodle',16),(226,'moodle/site:managecontextlocks','write',70,'moodle',0),(227,'moodle/course:togglecompletion','write',70,'moodle',0),(228,'moodle/analytics:listowninsights','read',10,'moodle',0),(229,'moodle/h5p:setdisplayoptions','write',70,'moodle',0),(230,'moodle/h5p:deploy','write',70,'moodle',4),(231,'moodle/h5p:updatelibraries','write',70,'moodle',4),(232,'moodle/course:recommendactivity','write',10,'moodle',0),(233,'moodle/contentbank:access','read',50,'moodle',0),(234,'moodle/contentbank:upload','write',50,'moodle',16),(235,'moodle/contentbank:deleteanycontent','write',50,'moodle',32),(236,'moodle/contentbank:deleteowncontent','write',50,'moodle',0),(237,'moodle/contentbank:manageanycontent','write',50,'moodle',32),(238,'moodle/contentbank:manageowncontent','write',50,'moodle',0),(239,'moodle/contentbank:useeditor','write',50,'moodle',16),(240,'moodle/contentbank:downloadcontent','read',50,'moodle',0),(241,'moodle/course:downloadcoursecontent','read',50,'moodle',0),(242,'moodle/course:configuredownloadcontent','write',50,'moodle',0),(243,'moodle/payment:manageaccounts','write',50,'moodle',42),(244,'moodle/payment:viewpayments','read',50,'moodle',8),(245,'moodle/contentbank:viewunlistedcontent','read',50,'moodle',0),(246,'moodle/reportbuilder:view','read',10,'moodle',0),(247,'moodle/reportbuilder:edit','write',10,'moodle',0),(248,'moodle/reportbuilder:editall','write',10,'moodle',0),(249,'moodle/reportbuilder:scheduleviewas','read',10,'moodle',0),(250,'mod/assign:view','read',70,'mod_assign',0),(251,'mod/assign:submit','write',70,'mod_assign',0),(252,'mod/assign:grade','write',70,'mod_assign',4),(253,'mod/assign:exportownsubmission','read',70,'mod_assign',0),(254,'mod/assign:addinstance','write',50,'mod_assign',4),(255,'mod/assign:editothersubmission','write',70,'mod_assign',41),(256,'mod/assign:grantextension','write',70,'mod_assign',0),(257,'mod/assign:revealidentities','write',70,'mod_assign',0),(258,'mod/assign:reviewgrades','write',70,'mod_assign',0),(259,'mod/assign:releasegrades','write',70,'mod_assign',0),(260,'mod/assign:managegrades','write',70,'mod_assign',0),(261,'mod/assign:manageallocations','write',70,'mod_assign',0),(262,'mod/assign:viewgrades','read',70,'mod_assign',0),(263,'mod/assign:viewblinddetails','write',70,'mod_assign',8),(264,'mod/assign:receivegradernotifications','read',70,'mod_assign',0),(265,'mod/assign:manageoverrides','write',70,'mod_assign',0),(266,'mod/assign:showhiddengrader','read',70,'mod_assign',0),(267,'mod/assign:viewownsubmissionsummary','read',70,'mod_assign',0),(268,'mod/assignment:view','read',70,'mod_assignment',0),(269,'mod/assignment:addinstance','write',50,'mod_assignment',4),(270,'mod/assignment:submit','write',70,'mod_assignment',0),(271,'mod/assignment:grade','write',70,'mod_assignment',4),(272,'mod/assignment:exportownsubmission','read',70,'mod_assignment',0),(273,'mod/bigbluebuttonbn:addinstance','write',50,'mod_bigbluebuttonbn',4),(274,'mod/bigbluebuttonbn:addinstancewithmeeting','write',70,'mod_bigbluebuttonbn',0),(275,'mod/bigbluebuttonbn:addinstancewithrecording','write',70,'mod_bigbluebuttonbn',0),(276,'mod/bigbluebuttonbn:join','read',70,'mod_bigbluebuttonbn',0),(277,'mod/bigbluebuttonbn:view','read',70,'mod_bigbluebuttonbn',0),(278,'mod/bigbluebuttonbn:managerecordings','write',70,'mod_bigbluebuttonbn',0),(279,'mod/bigbluebuttonbn:publishrecordings','write',70,'mod_bigbluebuttonbn',0),(280,'mod/bigbluebuttonbn:unpublishrecordings','write',70,'mod_bigbluebuttonbn',0),(281,'mod/bigbluebuttonbn:protectrecordings','write',70,'mod_bigbluebuttonbn',0),(282,'mod/bigbluebuttonbn:unprotectrecordings','write',70,'mod_bigbluebuttonbn',0),(283,'mod/bigbluebuttonbn:deleterecordings','write',70,'mod_bigbluebuttonbn',0),(284,'mod/bigbluebuttonbn:importrecordings','write',70,'mod_bigbluebuttonbn',0),(285,'mod/book:addinstance','write',50,'mod_book',4),(286,'mod/book:read','read',70,'mod_book',0),(287,'mod/book:viewhiddenchapters','read',70,'mod_book',0),(288,'mod/book:edit','write',70,'mod_book',4),(289,'mod/chat:addinstance','write',50,'mod_chat',4),(290,'mod/chat:chat','write',70,'mod_chat',16),(291,'mod/chat:readlog','read',70,'mod_chat',0),(292,'mod/chat:deletelog','write',70,'mod_chat',0),(293,'mod/chat:exportparticipatedsession','read',70,'mod_chat',8),(294,'mod/chat:exportsession','read',70,'mod_chat',8),(295,'mod/chat:view','read',70,'mod_chat',0),(296,'mod/choice:addinstance','write',50,'mod_choice',4),(297,'mod/choice:choose','write',70,'mod_choice',0),(298,'mod/choice:readresponses','read',70,'mod_choice',0),(299,'mod/choice:deleteresponses','write',70,'mod_choice',0),(300,'mod/choice:downloadresponses','read',70,'mod_choice',0),(301,'mod/choice:view','read',70,'mod_choice',0),(302,'mod/data:addinstance','write',50,'mod_data',4),(303,'mod/data:viewentry','read',70,'mod_data',0),(304,'mod/data:writeentry','write',70,'mod_data',16),(305,'mod/data:comment','write',70,'mod_data',16),(306,'mod/data:rate','write',70,'mod_data',0),(307,'mod/data:viewrating','read',70,'mod_data',0),(308,'mod/data:viewanyrating','read',70,'mod_data',8),(309,'mod/data:viewallratings','read',70,'mod_data',8),(310,'mod/data:approve','write',70,'mod_data',16),(311,'mod/data:manageentries','write',70,'mod_data',16),(312,'mod/data:managecomments','write',70,'mod_data',16),(313,'mod/data:managetemplates','write',70,'mod_data',20),(314,'mod/data:viewalluserpresets','read',70,'mod_data',0),(315,'mod/data:manageuserpresets','write',70,'mod_data',20),(316,'mod/data:exportentry','read',70,'mod_data',8),(317,'mod/data:exportownentry','read',70,'mod_data',0),(318,'mod/data:exportallentries','read',70,'mod_data',8),(319,'mod/data:exportuserinfo','read',70,'mod_data',8),(320,'mod/data:view','read',70,'mod_data',0),(321,'mod/feedback:addinstance','write',50,'mod_feedback',4),(322,'mod/feedback:view','read',70,'mod_feedback',0),(323,'mod/feedback:complete','write',70,'mod_feedback',16),(324,'mod/feedback:viewanalysepage','read',70,'mod_feedback',8),(325,'mod/feedback:deletesubmissions','write',70,'mod_feedback',0),(326,'mod/feedback:mapcourse','write',70,'mod_feedback',0),(327,'mod/feedback:edititems','write',70,'mod_feedback',20),(328,'mod/feedback:createprivatetemplate','write',70,'mod_feedback',16),(329,'mod/feedback:createpublictemplate','write',70,'mod_feedback',16),(330,'mod/feedback:deletetemplate','write',70,'mod_feedback',0),(331,'mod/feedback:viewreports','read',70,'mod_feedback',8),(332,'mod/feedback:receivemail','read',70,'mod_feedback',8),(333,'mod/folder:addinstance','write',50,'mod_folder',4),(334,'mod/folder:view','read',70,'mod_folder',0),(335,'mod/folder:managefiles','write',70,'mod_folder',20),(336,'mod/forum:addinstance','write',50,'mod_forum',4),(337,'mod/forum:viewdiscussion','read',70,'mod_forum',0),(338,'mod/forum:viewhiddentimedposts','read',70,'mod_forum',0),(339,'mod/forum:startdiscussion','write',70,'mod_forum',16),(340,'mod/forum:replypost','write',70,'mod_forum',16),(341,'mod/forum:addnews','write',70,'mod_forum',16),(342,'mod/forum:replynews','write',70,'mod_forum',16),(343,'mod/forum:viewrating','read',70,'mod_forum',0),(344,'mod/forum:viewanyrating','read',70,'mod_forum',8),(345,'mod/forum:viewallratings','read',70,'mod_forum',8),(346,'mod/forum:rate','write',70,'mod_forum',0),(347,'mod/forum:postprivatereply','write',70,'mod_forum',0),(348,'mod/forum:readprivatereplies','read',70,'mod_forum',0),(349,'mod/forum:createattachment','write',70,'mod_forum',16),(350,'mod/forum:deleteownpost','write',70,'mod_forum',0),(351,'mod/forum:deleteanypost','write',70,'mod_forum',0),(352,'mod/forum:splitdiscussions','write',70,'mod_forum',0),(353,'mod/forum:movediscussions','write',70,'mod_forum',0),(354,'mod/forum:pindiscussions','write',70,'mod_forum',0),(355,'mod/forum:editanypost','write',70,'mod_forum',16),(356,'mod/forum:viewqandawithoutposting','read',70,'mod_forum',0),(357,'mod/forum:viewsubscribers','read',70,'mod_forum',0),(358,'mod/forum:managesubscriptions','write',70,'mod_forum',16),(359,'mod/forum:postwithoutthrottling','write',70,'mod_forum',16),(360,'mod/forum:exportdiscussion','read',70,'mod_forum',8),(361,'mod/forum:exportforum','read',70,'mod_forum',8),(362,'mod/forum:exportpost','read',70,'mod_forum',8),(363,'mod/forum:exportownpost','read',70,'mod_forum',8),(364,'mod/forum:addquestion','write',70,'mod_forum',16),(365,'mod/forum:allowforcesubscribe','read',70,'mod_forum',0),(366,'mod/forum:canposttomygroups','write',70,'mod_forum',0),(367,'mod/forum:canoverridediscussionlock','write',70,'mod_forum',0),(368,'mod/forum:canoverridecutoff','write',70,'mod_forum',0),(369,'mod/forum:cantogglefavourite','write',70,'mod_forum',0),(370,'mod/forum:grade','write',70,'mod_forum',0),(371,'mod/glossary:addinstance','write',50,'mod_glossary',4),(372,'mod/glossary:view','read',70,'mod_glossary',0),(373,'mod/glossary:write','write',70,'mod_glossary',16),(374,'mod/glossary:manageentries','write',70,'mod_glossary',16),(375,'mod/glossary:managecategories','write',70,'mod_glossary',16),(376,'mod/glossary:comment','write',70,'mod_glossary',16),(377,'mod/glossary:managecomments','write',70,'mod_glossary',16),(378,'mod/glossary:import','write',70,'mod_glossary',16),(379,'mod/glossary:export','read',70,'mod_glossary',0),(380,'mod/glossary:approve','write',70,'mod_glossary',16),(381,'mod/glossary:rate','write',70,'mod_glossary',0),(382,'mod/glossary:viewrating','read',70,'mod_glossary',0),(383,'mod/glossary:viewanyrating','read',70,'mod_glossary',8),(384,'mod/glossary:viewallratings','read',70,'mod_glossary',8),(385,'mod/glossary:exportentry','read',70,'mod_glossary',8),(386,'mod/glossary:exportownentry','read',70,'mod_glossary',0),(387,'mod/h5pactivity:view','read',70,'mod_h5pactivity',0),(388,'mod/h5pactivity:addinstance','write',50,'mod_h5pactivity',0),(389,'mod/h5pactivity:submit','write',70,'mod_h5pactivity',0),(390,'mod/h5pactivity:reviewattempts','read',70,'mod_h5pactivity',0),(391,'mod/imscp:view','read',70,'mod_imscp',0),(392,'mod/imscp:addinstance','write',50,'mod_imscp',4),(393,'mod/label:addinstance','write',50,'mod_label',4),(394,'mod/label:view','read',70,'mod_label',0),(395,'mod/lesson:addinstance','write',50,'mod_lesson',4),(396,'mod/lesson:edit','write',70,'mod_lesson',4),(397,'mod/lesson:grade','write',70,'mod_lesson',20),(398,'mod/lesson:viewreports','read',70,'mod_lesson',8),(399,'mod/lesson:manage','write',70,'mod_lesson',0),(400,'mod/lesson:manageoverrides','write',70,'mod_lesson',0),(401,'mod/lesson:view','read',70,'mod_lesson',0),(402,'mod/lti:view','read',70,'mod_lti',0),(403,'mod/lti:addinstance','write',50,'mod_lti',4),(404,'mod/lti:manage','write',70,'mod_lti',8),(405,'mod/lti:admin','write',70,'mod_lti',8),(406,'mod/lti:addcoursetool','write',50,'mod_lti',0),(407,'mod/lti:addpreconfiguredinstance','write',50,'mod_lti',0),(408,'mod/lti:addmanualinstance','write',50,'mod_lti',0),(409,'mod/lti:requesttooladd','write',50,'mod_lti',0),(410,'mod/page:view','read',70,'mod_page',0),(411,'mod/page:addinstance','write',50,'mod_page',4),(412,'mod/quiz:view','read',70,'mod_quiz',0),(413,'mod/quiz:addinstance','write',50,'mod_quiz',4),(414,'mod/quiz:attempt','write',70,'mod_quiz',16),(415,'mod/quiz:reviewmyattempts','read',70,'mod_quiz',0),(416,'mod/quiz:manage','write',70,'mod_quiz',16),(417,'mod/quiz:manageoverrides','write',70,'mod_quiz',0),(418,'mod/quiz:viewoverrides','read',70,'mod_quiz',0),(419,'mod/quiz:preview','write',70,'mod_quiz',0),(420,'mod/quiz:grade','write',70,'mod_quiz',20),(421,'mod/quiz:regrade','write',70,'mod_quiz',16),(422,'mod/quiz:viewreports','read',70,'mod_quiz',8),(423,'mod/quiz:deleteattempts','write',70,'mod_quiz',32),(424,'mod/quiz:ignoretimelimits','read',70,'mod_quiz',0),(425,'mod/quiz:emailconfirmsubmission','read',70,'mod_quiz',0),(426,'mod/quiz:emailnotifysubmission','read',70,'mod_quiz',0),(427,'mod/quiz:emailwarnoverdue','read',70,'mod_quiz',0),(428,'mod/quiz:emailnotifyattemptgraded','read',70,'mod_quiz',0),(429,'mod/resource:view','read',70,'mod_resource',0),(430,'mod/resource:addinstance','write',50,'mod_resource',4),(431,'mod/scorm:addinstance','write',50,'mod_scorm',4),(432,'mod/scorm:viewreport','read',70,'mod_scorm',0),(433,'mod/scorm:skipview','read',70,'mod_scorm',0),(434,'mod/scorm:savetrack','write',70,'mod_scorm',0),(435,'mod/scorm:viewscores','read',70,'mod_scorm',0),(436,'mod/scorm:deleteresponses','write',70,'mod_scorm',0),(437,'mod/scorm:deleteownresponses','write',70,'mod_scorm',0),(438,'mod/survey:addinstance','write',50,'mod_survey',4),(439,'mod/survey:participate','read',70,'mod_survey',0),(440,'mod/survey:readresponses','read',70,'mod_survey',0),(441,'mod/survey:download','read',70,'mod_survey',0),(442,'mod/url:view','read',70,'mod_url',0),(443,'mod/url:addinstance','write',50,'mod_url',4),(444,'mod/wiki:addinstance','write',50,'mod_wiki',4),(445,'mod/wiki:viewpage','read',70,'mod_wiki',0),(446,'mod/wiki:editpage','write',70,'mod_wiki',16),(447,'mod/wiki:createpage','write',70,'mod_wiki',16),(448,'mod/wiki:viewcomment','read',70,'mod_wiki',0),(449,'mod/wiki:editcomment','write',70,'mod_wiki',16),(450,'mod/wiki:managecomment','write',70,'mod_wiki',0),(451,'mod/wiki:managefiles','write',70,'mod_wiki',0),(452,'mod/wiki:overridelock','write',70,'mod_wiki',0),(453,'mod/wiki:managewiki','write',70,'mod_wiki',0),(454,'mod/workshop:view','read',70,'mod_workshop',0),(455,'mod/workshop:addinstance','write',50,'mod_workshop',4),(456,'mod/workshop:switchphase','write',70,'mod_workshop',0),(457,'mod/workshop:editdimensions','write',70,'mod_workshop',4),(458,'mod/workshop:submit','write',70,'mod_workshop',0),(459,'mod/workshop:peerassess','write',70,'mod_workshop',0),(460,'mod/workshop:manageexamples','write',70,'mod_workshop',0),(461,'mod/workshop:allocate','write',70,'mod_workshop',0),(462,'mod/workshop:publishsubmissions','write',70,'mod_workshop',0),(463,'mod/workshop:viewauthornames','read',70,'mod_workshop',0),(464,'mod/workshop:viewreviewernames','read',70,'mod_workshop',0),(465,'mod/workshop:viewallsubmissions','read',70,'mod_workshop',0),(466,'mod/workshop:viewpublishedsubmissions','read',70,'mod_workshop',0),(467,'mod/workshop:viewauthorpublished','read',70,'mod_workshop',0),(468,'mod/workshop:viewallassessments','read',70,'mod_workshop',0),(469,'mod/workshop:overridegrades','write',70,'mod_workshop',0),(470,'mod/workshop:ignoredeadlines','write',70,'mod_workshop',0),(471,'mod/workshop:deletesubmissions','write',70,'mod_workshop',0),(472,'mod/workshop:exportsubmissions','read',70,'mod_workshop',0),(473,'auth/oauth2:managelinkedlogins','write',30,'auth_oauth2',0),(474,'enrol/category:synchronised','write',10,'enrol_category',0),(475,'enrol/category:config','write',50,'enrol_category',0),(476,'enrol/cohort:config','write',50,'enrol_cohort',0),(477,'enrol/cohort:unenrol','write',50,'enrol_cohort',0),(478,'enrol/database:unenrol','write',50,'enrol_database',0),(479,'enrol/database:config','write',50,'enrol_database',0),(480,'enrol/fee:config','write',50,'enrol_fee',0),(481,'enrol/fee:manage','write',50,'enrol_fee',0),(482,'enrol/fee:unenrol','write',50,'enrol_fee',0),(483,'enrol/fee:unenrolself','write',50,'enrol_fee',0),(484,'enrol/flatfile:manage','write',50,'enrol_flatfile',0),(485,'enrol/flatfile:unenrol','write',50,'enrol_flatfile',0),(486,'enrol/guest:config','write',50,'enrol_guest',0),(487,'enrol/imsenterprise:config','write',50,'enrol_imsenterprise',0),(488,'enrol/ldap:manage','write',50,'enrol_ldap',0),(489,'enrol/lti:config','write',50,'enrol_lti',0),(490,'enrol/lti:unenrol','write',50,'enrol_lti',0),(491,'enrol/manual:config','write',50,'enrol_manual',0),(492,'enrol/manual:enrol','write',50,'enrol_manual',0),(493,'enrol/manual:manage','write',50,'enrol_manual',0),(494,'enrol/manual:unenrol','write',50,'enrol_manual',0),(495,'enrol/manual:unenrolself','write',50,'enrol_manual',0),(496,'enrol/meta:config','write',50,'enrol_meta',0),(497,'enrol/meta:selectaslinked','read',50,'enrol_meta',0),(498,'enrol/meta:unenrol','write',50,'enrol_meta',0),(499,'enrol/mnet:config','write',50,'enrol_mnet',0),(500,'enrol/paypal:config','write',50,'enrol_paypal',0),(501,'enrol/paypal:manage','write',50,'enrol_paypal',0),(502,'enrol/paypal:unenrol','write',50,'enrol_paypal',0),(503,'enrol/paypal:unenrolself','write',50,'enrol_paypal',0),(504,'enrol/self:config','write',50,'enrol_self',0),(505,'enrol/self:manage','write',50,'enrol_self',0),(506,'enrol/self:holdkey','write',50,'enrol_self',0),(507,'enrol/self:unenrolself','write',50,'enrol_self',0),(508,'enrol/self:unenrol','write',50,'enrol_self',0),(509,'enrol/self:enrolself','write',50,'enrol_self',0),(510,'message/airnotifier:managedevice','write',10,'message_airnotifier',0),(511,'block/accessreview:addinstance','write',80,'block_accessreview',0),(512,'block/accessreview:view','read',80,'block_accessreview',0),(513,'block/activity_modules:addinstance','write',80,'block_activity_modules',20),(514,'block/activity_results:addinstance','write',80,'block_activity_results',20),(515,'block/admin_bookmarks:myaddinstance','write',10,'block_admin_bookmarks',0),(516,'block/admin_bookmarks:addinstance','write',80,'block_admin_bookmarks',20),(517,'block/badges:addinstance','read',80,'block_badges',0),(518,'block/badges:myaddinstance','read',10,'block_badges',8),(519,'block/blog_menu:addinstance','write',80,'block_blog_menu',20),(520,'block/blog_recent:addinstance','write',80,'block_blog_recent',20),(521,'block/blog_tags:addinstance','write',80,'block_blog_tags',20),(522,'block/calendar_month:myaddinstance','write',10,'block_calendar_month',0),(523,'block/calendar_month:addinstance','write',80,'block_calendar_month',20),(524,'block/calendar_upcoming:myaddinstance','write',10,'block_calendar_upcoming',0),(525,'block/calendar_upcoming:addinstance','write',80,'block_calendar_upcoming',20),(526,'block/comments:myaddinstance','write',10,'block_comments',0),(527,'block/comments:addinstance','write',80,'block_comments',20),(528,'block/completionstatus:addinstance','write',80,'block_completionstatus',20),(529,'block/course_list:myaddinstance','write',10,'block_course_list',0),(530,'block/course_list:addinstance','write',80,'block_course_list',20),(531,'block/course_summary:addinstance','write',80,'block_course_summary',20),(532,'block/feedback:addinstance','write',80,'block_feedback',20),(533,'block/globalsearch:myaddinstance','write',10,'block_globalsearch',0),(534,'block/globalsearch:addinstance','write',80,'block_globalsearch',0),(535,'block/glossary_random:myaddinstance','write',10,'block_glossary_random',0),(536,'block/glossary_random:addinstance','write',80,'block_glossary_random',20),(537,'block/html:myaddinstance','write',10,'block_html',0),(538,'block/html:addinstance','write',80,'block_html',20),(539,'block/login:addinstance','write',80,'block_login',20),(540,'block/lp:addinstance','write',10,'block_lp',0),(541,'block/lp:myaddinstance','write',10,'block_lp',0),(542,'block/mentees:myaddinstance','write',10,'block_mentees',0),(543,'block/mentees:addinstance','write',80,'block_mentees',20),(544,'block/mnet_hosts:myaddinstance','write',10,'block_mnet_hosts',0),(545,'block/mnet_hosts:addinstance','write',80,'block_mnet_hosts',20),(546,'block/myoverview:myaddinstance','write',10,'block_myoverview',0),(547,'block/myprofile:myaddinstance','write',10,'block_myprofile',0),(548,'block/myprofile:addinstance','write',80,'block_myprofile',20),(549,'block/navigation:myaddinstance','write',10,'block_navigation',0),(550,'block/navigation:addinstance','write',80,'block_navigation',20),(551,'block/news_items:myaddinstance','write',10,'block_news_items',0),(552,'block/news_items:addinstance','write',80,'block_news_items',20),(553,'block/online_users:myaddinstance','write',10,'block_online_users',0),(554,'block/online_users:addinstance','write',80,'block_online_users',20),(555,'block/online_users:viewlist','read',80,'block_online_users',0),(556,'block/private_files:myaddinstance','write',10,'block_private_files',0),(557,'block/private_files:addinstance','write',80,'block_private_files',20),(558,'block/recent_activity:addinstance','write',80,'block_recent_activity',20),(559,'block/recent_activity:viewaddupdatemodule','read',50,'block_recent_activity',0),(560,'block/recent_activity:viewdeletemodule','read',50,'block_recent_activity',0),(561,'block/recentlyaccessedcourses:myaddinstance','write',10,'block_recentlyaccessedcourses',0),(562,'block/recentlyaccesseditems:myaddinstance','write',10,'block_recentlyaccesseditems',0),(563,'block/rss_client:myaddinstance','write',10,'block_rss_client',0),(564,'block/rss_client:addinstance','write',80,'block_rss_client',20),(565,'block/rss_client:manageownfeeds','write',80,'block_rss_client',0),(566,'block/rss_client:manageanyfeeds','write',80,'block_rss_client',16),(567,'block/search_forums:addinstance','write',80,'block_search_forums',20),(568,'block/section_links:addinstance','write',80,'block_section_links',20),(569,'block/selfcompletion:addinstance','write',80,'block_selfcompletion',20),(570,'block/settings:myaddinstance','write',10,'block_settings',0),(571,'block/settings:addinstance','write',80,'block_settings',20),(572,'block/site_main_menu:addinstance','write',80,'block_site_main_menu',20),(573,'block/social_activities:addinstance','write',80,'block_social_activities',20),(574,'block/starredcourses:myaddinstance','write',10,'block_starredcourses',0),(575,'block/tag_flickr:addinstance','write',80,'block_tag_flickr',20),(576,'block/tag_youtube:addinstance','write',80,'block_tag_youtube',20),(577,'block/tags:myaddinstance','write',10,'block_tags',0),(578,'block/tags:addinstance','write',80,'block_tags',20),(579,'block/timeline:myaddinstance','write',10,'block_timeline',0),(580,'report/completion:view','read',50,'report_completion',8),(581,'report/courseoverview:view','read',10,'report_courseoverview',8),(582,'report/log:view','read',50,'report_log',8),(583,'report/log:viewtoday','read',50,'report_log',8),(584,'report/loglive:view','read',50,'report_loglive',8),(585,'report/outline:view','read',50,'report_outline',8),(586,'report/outline:viewuserreport','read',50,'report_outline',8),(587,'report/participation:view','read',50,'report_participation',8),(588,'report/performance:view','read',10,'report_performance',2),(589,'report/progress:view','read',50,'report_progress',8),(590,'report/questioninstances:view','read',10,'report_questioninstances',0),(591,'report/security:view','read',10,'report_security',2),(592,'report/stats:view','read',50,'report_stats',8),(593,'report/status:view','read',10,'report_status',2),(594,'report/usersessions:manageownsessions','write',30,'report_usersessions',0),(595,'gradeexport/ods:view','read',50,'gradeexport_ods',8),(596,'gradeexport/ods:publish','read',50,'gradeexport_ods',8),(597,'gradeexport/txt:view','read',50,'gradeexport_txt',8),(598,'gradeexport/txt:publish','read',50,'gradeexport_txt',8),(599,'gradeexport/xls:view','read',50,'gradeexport_xls',8),(600,'gradeexport/xls:publish','read',50,'gradeexport_xls',8),(601,'gradeexport/xml:view','read',50,'gradeexport_xml',8),(602,'gradeexport/xml:publish','read',50,'gradeexport_xml',8),(603,'gradeimport/csv:view','write',50,'gradeimport_csv',0),(604,'gradeimport/direct:view','write',50,'gradeimport_direct',0),(605,'gradeimport/xml:view','write',50,'gradeimport_xml',0),(606,'gradeimport/xml:publish','write',50,'gradeimport_xml',0),(607,'gradereport/grader:view','read',50,'gradereport_grader',8),(608,'gradereport/history:view','read',50,'gradereport_history',8),(609,'gradereport/outcomes:view','read',50,'gradereport_outcomes',8),(610,'gradereport/overview:view','read',50,'gradereport_overview',8),(611,'gradereport/singleview:view','read',50,'gradereport_singleview',8),(612,'gradereport/user:view','read',50,'gradereport_user',8),(613,'webservice/rest:use','read',50,'webservice_rest',0),(614,'webservice/soap:use','read',50,'webservice_soap',0),(615,'webservice/xmlrpc:use','read',50,'webservice_xmlrpc',0),(616,'repository/areafiles:view','read',70,'repository_areafiles',0),(617,'repository/contentbank:view','read',70,'repository_contentbank',0),(618,'repository/contentbank:accesscoursecontent','read',50,'repository_contentbank',0),(619,'repository/contentbank:accesscoursecategorycontent','read',40,'repository_contentbank',0),(620,'repository/contentbank:accessgeneralcontent','read',40,'repository_contentbank',0),(621,'repository/coursefiles:view','read',70,'repository_coursefiles',0),(622,'repository/dropbox:view','read',70,'repository_dropbox',0),(623,'repository/equella:view','read',70,'repository_equella',0),(624,'repository/filesystem:view','read',70,'repository_filesystem',0),(625,'repository/flickr:view','read',70,'repository_flickr',0),(626,'repository/flickr_public:view','read',70,'repository_flickr_public',0),(627,'repository/googledocs:view','read',70,'repository_googledocs',0),(628,'repository/local:view','read',70,'repository_local',0),(629,'repository/merlot:view','read',70,'repository_merlot',0),(630,'repository/nextcloud:view','read',70,'repository_nextcloud',0),(631,'repository/onedrive:view','read',70,'repository_onedrive',0),(632,'repository/recent:view','read',70,'repository_recent',0),(633,'repository/s3:view','read',70,'repository_s3',0),(634,'repository/upload:view','read',70,'repository_upload',0),(635,'repository/url:view','read',70,'repository_url',0),(636,'repository/user:view','read',70,'repository_user',0),(637,'repository/webdav:view','read',70,'repository_webdav',0),(638,'repository/wikimedia:view','read',70,'repository_wikimedia',0),(639,'repository/youtube:view','read',70,'repository_youtube',0),(640,'moodle/question:commentmine','write',50,'qbank_comment',0),(641,'moodle/question:commentall','write',50,'qbank_comment',0),(642,'qbank/customfields:changelockedcustomfields','write',50,'qbank_customfields',16),(643,'qbank/customfields:configurecustomfields','write',10,'qbank_customfields',16),(644,'qbank/customfields:viewhiddencustomfields','read',50,'qbank_customfields',0),(645,'tool/brickfield:viewcoursetools','read',50,'tool_brickfield',8),(646,'tool/brickfield:viewsystemtools','read',10,'tool_brickfield',2),(647,'tool/customlang:view','read',10,'tool_customlang',2),(648,'tool/customlang:edit','write',10,'tool_customlang',6),(649,'tool/customlang:export','read',10,'tool_customlang',2),(650,'tool/dataprivacy:managedatarequests','write',10,'tool_dataprivacy',60),(651,'tool/dataprivacy:requestdeleteforotheruser','write',10,'tool_dataprivacy',60),(652,'tool/dataprivacy:managedataregistry','write',10,'tool_dataprivacy',60),(653,'tool/dataprivacy:makedatarequestsforchildren','write',30,'tool_dataprivacy',24),(654,'tool/dataprivacy:makedatadeletionrequestsforchildren','write',30,'tool_dataprivacy',24),(655,'tool/dataprivacy:downloadownrequest','read',30,'tool_dataprivacy',0),(656,'tool/dataprivacy:downloadallrequests','read',30,'tool_dataprivacy',8),(657,'tool/dataprivacy:requestdelete','write',30,'tool_dataprivacy',32),(658,'tool/lpmigrate:frameworksmigrate','write',10,'tool_lpmigrate',0),(659,'tool/monitor:subscribe','read',50,'tool_monitor',8),(660,'tool/monitor:managerules','write',50,'tool_monitor',4),(661,'tool/monitor:managetool','write',10,'tool_monitor',4),(662,'tool/policy:accept','write',10,'tool_policy',0),(663,'tool/policy:acceptbehalf','write',30,'tool_policy',8),(664,'tool/policy:managedocs','write',10,'tool_policy',0),(665,'tool/policy:viewacceptances','read',10,'tool_policy',0),(666,'tool/recyclebin:deleteitems','write',50,'tool_recyclebin',32),(667,'tool/recyclebin:restoreitems','write',50,'tool_recyclebin',0),(668,'tool/recyclebin:viewitems','read',50,'tool_recyclebin',0),(669,'tool/uploaduser:uploaduserpictures','write',10,'tool_uploaduser',16),(670,'tool/usertours:managetours','write',10,'tool_usertours',4),(671,'contenttype/h5p:access','read',50,'contenttype_h5p',0),(672,'contenttype/h5p:upload','write',50,'contenttype_h5p',16),(673,'contenttype/h5p:useeditor','write',50,'contenttype_h5p',16),(674,'booktool/exportimscp:export','read',70,'booktool_exportimscp',0),(675,'booktool/importhtml:import','write',70,'booktool_importhtml',4),(676,'booktool/print:print','read',70,'booktool_print',0),(677,'forumreport/summary:view','read',70,'forumreport_summary',0),(678,'forumreport/summary:viewall','read',70,'forumreport_summary',8),(679,'quiz/grading:viewstudentnames','read',70,'quiz_grading',0),(680,'quiz/grading:viewidnumber','read',70,'quiz_grading',0),(681,'quiz/statistics:view','read',70,'quiz_statistics',0),(682,'quizaccess/seb:managetemplates','write',10,'quizaccess_seb',0),(683,'quizaccess/seb:bypassseb','read',70,'quizaccess_seb',0),(684,'quizaccess/seb:manage_seb_requiresafeexambrowser','write',70,'quizaccess_seb',0),(685,'quizaccess/seb:manage_seb_templateid','read',70,'quizaccess_seb',0),(686,'quizaccess/seb:manage_filemanager_sebconfigfile','write',70,'quizaccess_seb',0),(687,'quizaccess/seb:manage_seb_showsebdownloadlink','write',70,'quizaccess_seb',0),(688,'quizaccess/seb:manage_seb_allowedbrowserexamkeys','write',70,'quizaccess_seb',0),(689,'quizaccess/seb:manage_seb_linkquitseb','write',70,'quizaccess_seb',0),(690,'quizaccess/seb:manage_seb_userconfirmquit','write',70,'quizaccess_seb',0),(691,'quizaccess/seb:manage_seb_allowuserquitseb','write',70,'quizaccess_seb',0),(692,'quizaccess/seb:manage_seb_quitpassword','write',70,'quizaccess_seb',0),(693,'quizaccess/seb:manage_seb_allowreloadinexam','write',70,'quizaccess_seb',0),(694,'quizaccess/seb:manage_seb_showsebtaskbar','write',70,'quizaccess_seb',0),(695,'quizaccess/seb:manage_seb_showreloadbutton','write',70,'quizaccess_seb',0),(696,'quizaccess/seb:manage_seb_showtime','write',70,'quizaccess_seb',0),(697,'quizaccess/seb:manage_seb_showkeyboardlayout','write',70,'quizaccess_seb',0),(698,'quizaccess/seb:manage_seb_showwificontrol','write',70,'quizaccess_seb',0),(699,'quizaccess/seb:manage_seb_enableaudiocontrol','write',70,'quizaccess_seb',0),(700,'quizaccess/seb:manage_seb_muteonstartup','write',70,'quizaccess_seb',0),(701,'quizaccess/seb:manage_seb_allowspellchecking','write',70,'quizaccess_seb',0),(702,'quizaccess/seb:manage_seb_activateurlfiltering','write',70,'quizaccess_seb',0),(703,'quizaccess/seb:manage_seb_filterembeddedcontent','write',70,'quizaccess_seb',0),(704,'quizaccess/seb:manage_seb_expressionsallowed','write',70,'quizaccess_seb',0),(705,'quizaccess/seb:manage_seb_regexallowed','write',70,'quizaccess_seb',0),(706,'quizaccess/seb:manage_seb_expressionsblocked','write',70,'quizaccess_seb',0),(707,'quizaccess/seb:manage_seb_regexblocked','write',70,'quizaccess_seb',0),(708,'atto/h5p:addembed','write',70,'atto_h5p',0),(709,'atto/recordrtc:recordaudio','write',70,'atto_recordrtc',0),(710,'atto/recordrtc:recordvideo','write',70,'atto_recordrtc',0),(711,'mod/lti:launch','read',70,'mod_lti',0),(714,'local/custompage:view','read',10,'local_custompage',0);
/*!40000 ALTER TABLE `mdl_capabilities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat`
--

DROP TABLE IF EXISTS `mdl_chat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_chat` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `keepdays` bigint NOT NULL DEFAULT '0',
  `studentlogs` smallint NOT NULL DEFAULT '0',
  `chattime` bigint NOT NULL DEFAULT '0',
  `schedule` smallint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_chat_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Each of these is a chat room';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat`
--

LOCK TABLES `mdl_chat` WRITE;
/*!40000 ALTER TABLE `mdl_chat` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat_messages`
--

DROP TABLE IF EXISTS `mdl_chat_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_chat_messages` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `chatid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_chatmess_use_ix` (`userid`),
  KEY `mdl_chatmess_gro_ix` (`groupid`),
  KEY `mdl_chatmess_timcha_ix` (`timestamp`,`chatid`),
  KEY `mdl_chatmess_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores all the actual chat messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat_messages`
--

LOCK TABLES `mdl_chat_messages` WRITE;
/*!40000 ALTER TABLE `mdl_chat_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat_messages_current`
--

DROP TABLE IF EXISTS `mdl_chat_messages_current`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_chat_messages_current` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `chatid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_chatmesscurr_use_ix` (`userid`),
  KEY `mdl_chatmesscurr_gro_ix` (`groupid`),
  KEY `mdl_chatmesscurr_timcha_ix` (`timestamp`,`chatid`),
  KEY `mdl_chatmesscurr_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores current session';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat_messages_current`
--

LOCK TABLES `mdl_chat_messages_current` WRITE;
/*!40000 ALTER TABLE `mdl_chat_messages_current` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat_messages_current` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat_users`
--

DROP TABLE IF EXISTS `mdl_chat_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_chat_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `chatid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `version` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `firstping` bigint NOT NULL DEFAULT '0',
  `lastping` bigint NOT NULL DEFAULT '0',
  `lastmessageping` bigint NOT NULL DEFAULT '0',
  `sid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `course` bigint NOT NULL DEFAULT '0',
  `lang` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_chatuser_use_ix` (`userid`),
  KEY `mdl_chatuser_las_ix` (`lastping`),
  KEY `mdl_chatuser_gro_ix` (`groupid`),
  KEY `mdl_chatuser_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Keeps track of which users are in which chat rooms';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat_users`
--

LOCK TABLES `mdl_chat_users` WRITE;
/*!40000 ALTER TABLE `mdl_chat_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_choice`
--

DROP TABLE IF EXISTS `mdl_choice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_choice` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `publish` tinyint NOT NULL DEFAULT '0',
  `showresults` tinyint NOT NULL DEFAULT '0',
  `display` smallint NOT NULL DEFAULT '0',
  `allowupdate` tinyint NOT NULL DEFAULT '0',
  `allowmultiple` tinyint NOT NULL DEFAULT '0',
  `showunanswered` tinyint NOT NULL DEFAULT '0',
  `includeinactive` tinyint NOT NULL DEFAULT '1',
  `limitanswers` tinyint NOT NULL DEFAULT '0',
  `timeopen` bigint NOT NULL DEFAULT '0',
  `timeclose` bigint NOT NULL DEFAULT '0',
  `showpreview` tinyint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  `showavailable` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_choi_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Available choices are stored here';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_choice`
--

LOCK TABLES `mdl_choice` WRITE;
/*!40000 ALTER TABLE `mdl_choice` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_choice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_choice_answers`
--

DROP TABLE IF EXISTS `mdl_choice_answers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_choice_answers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `choiceid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `optionid` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_choiansw_use_ix` (`userid`),
  KEY `mdl_choiansw_cho_ix` (`choiceid`),
  KEY `mdl_choiansw_opt_ix` (`optionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='choices performed by users';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_choice_answers`
--

LOCK TABLES `mdl_choice_answers` WRITE;
/*!40000 ALTER TABLE `mdl_choice_answers` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_choice_answers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_choice_options`
--

DROP TABLE IF EXISTS `mdl_choice_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_choice_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `choiceid` bigint NOT NULL DEFAULT '0',
  `text` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `maxanswers` bigint DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_choiopti_cho_ix` (`choiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='available options to choice';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_choice_options`
--

LOCK TABLES `mdl_choice_options` WRITE;
/*!40000 ALTER TABLE `mdl_choice_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_choice_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cohort`
--

DROP TABLE IF EXISTS `mdl_cohort`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_cohort` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `name` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `component` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `theme` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_coho_con_ix` (`contextid`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Each record represents one cohort (aka site-wide group).';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cohort`
--

LOCK TABLES `mdl_cohort` WRITE;
/*!40000 ALTER TABLE `mdl_cohort` DISABLE KEYS */;
INSERT INTO `mdl_cohort` VALUES (1,1,'test1 batch','1','',1,0,'',1755667585,1758546241,'');
/*!40000 ALTER TABLE `mdl_cohort` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cohort_members`
--

DROP TABLE IF EXISTS `mdl_cohort_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_cohort_members` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `cohortid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timeadded` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_cohomemb_cohuse_uix` (`cohortid`,`userid`),
  KEY `mdl_cohomemb_coh_ix` (`cohortid`),
  KEY `mdl_cohomemb_use_ix` (`userid`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a user to a cohort.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cohort_members`
--

LOCK TABLES `mdl_cohort_members` WRITE;
/*!40000 ALTER TABLE `mdl_cohort_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_cohort_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_comments`
--

DROP TABLE IF EXISTS `mdl_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_comments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `component` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commentarea` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `format` tinyint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_comm_concomite_ix` (`contextid`,`commentarea`,`itemid`),
  KEY `mdl_comm_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='moodle comments module';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_comments`
--

LOCK TABLES `mdl_comments` WRITE;
/*!40000 ALTER TABLE `mdl_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_company`
--

DROP TABLE IF EXISTS `mdl_company`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_company` (
  `id` int NOT NULL AUTO_INCREMENT,
  `com_name` varchar(255) DEFAULT NULL,
  `class_manager` varchar(255) DEFAULT NULL,
  `phone` varchar(25) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `zip` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_company`
--

LOCK TABLES `mdl_company` WRITE;
/*!40000 ALTER TABLE `mdl_company` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_company` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency`
--

DROP TABLE IF EXISTS `mdl_competency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `descriptionformat` smallint NOT NULL DEFAULT '0',
  `idnumber` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `competencyframeworkid` bigint NOT NULL,
  `parentid` bigint NOT NULL DEFAULT '0',
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortorder` bigint NOT NULL,
  `ruletype` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ruleoutcome` tinyint NOT NULL DEFAULT '0',
  `ruleconfig` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `scaleid` bigint DEFAULT NULL,
  `scaleconfiguration` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_comp_comidn_uix` (`competencyframeworkid`,`idnumber`),
  KEY `mdl_comp_rul_ix` (`ruleoutcome`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table contains the master record of each competency in ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency`
--

LOCK TABLES `mdl_competency` WRITE;
/*!40000 ALTER TABLE `mdl_competency` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_coursecomp`
--

DROP TABLE IF EXISTS `mdl_competency_coursecomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_coursecomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `ruleoutcome` tinyint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `sortorder` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compcour_coucom_uix` (`courseid`,`competencyid`),
  KEY `mdl_compcour_courul_ix` (`courseid`,`ruleoutcome`),
  KEY `mdl_compcour_cou2_ix` (`courseid`),
  KEY `mdl_compcour_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a competency to a course.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_coursecomp`
--

LOCK TABLES `mdl_competency_coursecomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_coursecomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_coursecomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_coursecompsetting`
--

DROP TABLE IF EXISTS `mdl_competency_coursecompsetting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_coursecompsetting` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `pushratingstouserplans` tinyint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table contains the course specific settings for compete';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_coursecompsetting`
--

LOCK TABLES `mdl_competency_coursecompsetting` WRITE;
/*!40000 ALTER TABLE `mdl_competency_coursecompsetting` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_coursecompsetting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_evidence`
--

DROP TABLE IF EXISTS `mdl_competency_evidence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_evidence` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `usercompetencyid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `action` tinyint NOT NULL,
  `actionuserid` bigint DEFAULT NULL,
  `descidentifier` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `desccomponent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `desca` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grade` bigint DEFAULT NULL,
  `note` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_compevid_use_ix` (`usercompetencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The evidence linked to a user competency';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_evidence`
--

LOCK TABLES `mdl_competency_evidence` WRITE;
/*!40000 ALTER TABLE `mdl_competency_evidence` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_evidence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_framework`
--

DROP TABLE IF EXISTS `mdl_competency_framework`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_framework` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contextid` bigint NOT NULL,
  `idnumber` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `descriptionformat` smallint NOT NULL DEFAULT '0',
  `scaleid` bigint DEFAULT NULL,
  `scaleconfiguration` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `visible` tinyint NOT NULL DEFAULT '1',
  `taxonomies` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compfram_idn_uix` (`idnumber`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='List of competency frameworks.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_framework`
--

LOCK TABLES `mdl_competency_framework` WRITE;
/*!40000 ALTER TABLE `mdl_competency_framework` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_framework` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_modulecomp`
--

DROP TABLE IF EXISTS `mdl_competency_modulecomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_modulecomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `cmid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `sortorder` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `ruleoutcome` tinyint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compmodu_cmicom_uix` (`cmid`,`competencyid`),
  KEY `mdl_compmodu_cmirul_ix` (`cmid`,`ruleoutcome`),
  KEY `mdl_compmodu_cmi_ix` (`cmid`),
  KEY `mdl_compmodu_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a competency to a module.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_modulecomp`
--

LOCK TABLES `mdl_competency_modulecomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_modulecomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_modulecomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_plan`
--

DROP TABLE IF EXISTS `mdl_competency_plan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_plan` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `descriptionformat` smallint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL,
  `templateid` bigint DEFAULT NULL,
  `origtemplateid` bigint DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `duedate` bigint DEFAULT '0',
  `reviewerid` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_compplan_usesta_ix` (`userid`,`status`),
  KEY `mdl_compplan_tem_ix` (`templateid`),
  KEY `mdl_compplan_stadue_ix` (`status`,`duedate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Learning plans';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_plan`
--

LOCK TABLES `mdl_competency_plan` WRITE;
/*!40000 ALTER TABLE `mdl_competency_plan` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_plan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_plancomp`
--

DROP TABLE IF EXISTS `mdl_competency_plancomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_plancomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `planid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `sortorder` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compplan_placom_uix` (`planid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Plan competencies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_plancomp`
--

LOCK TABLES `mdl_competency_plancomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_plancomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_plancomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_relatedcomp`
--

DROP TABLE IF EXISTS `mdl_competency_relatedcomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_relatedcomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `competencyid` bigint NOT NULL,
  `relatedcompetencyid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Related competencies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_relatedcomp`
--

LOCK TABLES `mdl_competency_relatedcomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_relatedcomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_relatedcomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_template`
--

DROP TABLE IF EXISTS `mdl_competency_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_template` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contextid` bigint NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `descriptionformat` smallint NOT NULL DEFAULT '0',
  `visible` tinyint NOT NULL DEFAULT '1',
  `duedate` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Learning plan templates.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_template`
--

LOCK TABLES `mdl_competency_template` WRITE;
/*!40000 ALTER TABLE `mdl_competency_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_templatecohort`
--

DROP TABLE IF EXISTS `mdl_competency_templatecohort`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_templatecohort` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `templateid` bigint NOT NULL,
  `cohortid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_comptemp_temcoh_uix` (`templateid`,`cohortid`),
  KEY `mdl_comptemp_tem2_ix` (`templateid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Default comment for the table, please edit me';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_templatecohort`
--

LOCK TABLES `mdl_competency_templatecohort` WRITE;
/*!40000 ALTER TABLE `mdl_competency_templatecohort` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_templatecohort` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_templatecomp`
--

DROP TABLE IF EXISTS `mdl_competency_templatecomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_templatecomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `templateid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `sortorder` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_comptemp_tem_ix` (`templateid`),
  KEY `mdl_comptemp_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a competency to a learning plan template.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_templatecomp`
--

LOCK TABLES `mdl_competency_templatecomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_templatecomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_templatecomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_usercomp`
--

DROP TABLE IF EXISTS `mdl_competency_usercomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_usercomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `status` tinyint NOT NULL DEFAULT '0',
  `reviewerid` bigint DEFAULT NULL,
  `proficiency` tinyint DEFAULT NULL,
  `grade` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compuser_usecom_uix` (`userid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='User competencies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_usercomp`
--

LOCK TABLES `mdl_competency_usercomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_usercomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_usercomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_usercompcourse`
--

DROP TABLE IF EXISTS `mdl_competency_usercompcourse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_usercompcourse` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `courseid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `proficiency` tinyint DEFAULT NULL,
  `grade` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compuser_usecoucom_uix` (`userid`,`courseid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='User competencies in a course';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_usercompcourse`
--

LOCK TABLES `mdl_competency_usercompcourse` WRITE;
/*!40000 ALTER TABLE `mdl_competency_usercompcourse` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_usercompcourse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_usercompplan`
--

DROP TABLE IF EXISTS `mdl_competency_usercompplan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_usercompplan` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `planid` bigint NOT NULL,
  `proficiency` tinyint DEFAULT NULL,
  `grade` bigint DEFAULT NULL,
  `sortorder` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compuser_usecompla_uix` (`userid`,`competencyid`,`planid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='User competencies plans';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_usercompplan`
--

LOCK TABLES `mdl_competency_usercompplan` WRITE;
/*!40000 ALTER TABLE `mdl_competency_usercompplan` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_usercompplan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_userevidence`
--

DROP TABLE IF EXISTS `mdl_competency_userevidence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_userevidence` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descriptionformat` tinyint(1) NOT NULL,
  `url` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_compuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The evidence of prior learning';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_userevidence`
--

LOCK TABLES `mdl_competency_userevidence` WRITE;
/*!40000 ALTER TABLE `mdl_competency_userevidence` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_userevidence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_userevidencecomp`
--

DROP TABLE IF EXISTS `mdl_competency_userevidencecomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_competency_userevidencecomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userevidenceid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compuser_usecom2_uix` (`userevidenceid`,`competencyid`),
  KEY `mdl_compuser_use2_ix` (`userevidenceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Relationship between user evidence and competencies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_userevidencecomp`
--

LOCK TABLES `mdl_competency_userevidencecomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_userevidencecomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_userevidencecomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_config`
--

DROP TABLE IF EXISTS `mdl_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_config` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_conf_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=598 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Moodle configuration variables';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_config`
--

LOCK TABLES `mdl_config` WRITE;
/*!40000 ALTER TABLE `mdl_config` DISABLE KEYS */;
INSERT INTO `mdl_config` VALUES (2,'rolesactive','1'),(3,'auth','email'),(4,'enrol_plugins_enabled','manual,guest,self,cohort'),(5,'theme','academi'),(6,'filter_multilang_converted','1'),(7,'siteidentifier','ntBsBlRrjdh7VERJzUARpJAzB9lSDjHflms.techgigs.in'),(8,'backup_version','2022041900'),(9,'backup_release','4.0'),(10,'mnet_dispatcher_mode','off'),(11,'sessiontimeout','28800'),(12,'stringfilters',''),(13,'filterall','0'),(14,'texteditors','atto,tinymce,textarea'),(15,'antiviruses',''),(16,'media_plugins_sortorder','videojs,youtube'),(17,'upgrade_extracreditweightsstepignored','1'),(18,'upgrade_calculatedgradeitemsignored','1'),(19,'upgrade_letterboundarycourses','1'),(20,'mnet_localhost_id','1'),(21,'mnet_all_hosts_id','2'),(22,'siteguest','1'),(23,'siteadmins','2'),(24,'themerev','1758539691'),(25,'jsrev','1758522880'),(26,'templaterev','1758522880'),(27,'gdversion','2'),(28,'licenses','unknown,allrightsreserved,public,cc,cc-nd,cc-nc-nd,cc-nc,cc-nc-sa,cc-sa'),(29,'sitedefaultlicense','unknown'),(30,'version','2022041912'),(31,'enableuserfeedback','0'),(32,'userfeedback_nextreminder','1'),(33,'userfeedback_remindafter','90'),(34,'enableoutcomes','0'),(35,'usecomments','1'),(36,'usetags','1'),(37,'enablenotes','1'),(38,'enableportfolios','0'),(39,'enablewebservices','1'),(40,'enablestats','0'),(41,'enablerssfeeds','0'),(42,'enableblogs','1'),(43,'enablecompletion','1'),(44,'completiondefault','1'),(45,'enableavailability','1'),(46,'enableplagiarism','0'),(47,'enablebadges','1'),(48,'enableglobalsearch','0'),(49,'allowstealth','0'),(50,'enableanalytics','1'),(51,'messaging','1'),(52,'enablecustomreports','1'),(53,'allowemojipicker','1'),(54,'userfiltersdefault','realname'),(55,'defaultpreference_maildisplay','2'),(56,'defaultpreference_mailformat','1'),(57,'defaultpreference_maildigest','0'),(58,'defaultpreference_autosubscribe','1'),(59,'defaultpreference_trackforums','0'),(60,'defaultpreference_core_contentbank_visibility','1'),(61,'enroladminnewcourse','1'),(62,'autologinguests','0'),(63,'hiddenuserfields',''),(64,'showuseridentity','email'),(65,'fullnamedisplay','language'),(66,'alternativefullnameformat','language'),(67,'maxusersperpage','100'),(68,'enablegravatar','0'),(69,'gravatardefaulturl','mm'),(70,'agedigitalconsentverification','0'),(71,'agedigitalconsentmap','*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13'),(72,'sitepolicy',''),(73,'sitepolicyguest',''),(74,'downloadcoursecontentallowed','0'),(75,'maxsizeperdownloadcoursefile','52428800'),(76,'enablecourserequests','1'),(77,'defaultrequestcategory','1'),(78,'lockrequestcategory','0'),(79,'courserequestnotify',''),(80,'activitychoosertabmode','0'),(81,'activitychooseractivefooter','hidden'),(82,'enableasyncbackup','0'),(83,'grade_profilereport','user'),(84,'grade_aggregationposition','1'),(85,'grade_includescalesinaggregation','1'),(86,'grade_hiddenasdate','0'),(87,'gradepublishing','0'),(88,'grade_export_exportfeedback','0'),(89,'grade_export_displaytype','1'),(90,'grade_export_decimalpoints','2'),(91,'grade_export_userprofilefields','firstname,lastname,idnumber,institution,department,email'),(92,'grade_export_customprofilefields',''),(93,'recovergradesdefault','0'),(94,'gradeexport',''),(95,'unlimitedgrades','0'),(96,'grade_report_showmin','1'),(97,'gradepointmax','100'),(98,'gradepointdefault','100'),(99,'grade_minmaxtouse','1'),(100,'grade_mygrades_report','overview'),(101,'gradereport_mygradeurl',''),(102,'grade_hideforcedsettings','1'),(103,'grade_aggregation','13'),(104,'grade_aggregation_flag','0'),(105,'grade_aggregations_visible','13'),(106,'grade_aggregateonlygraded','1'),(107,'grade_aggregateonlygraded_flag','2'),(108,'grade_aggregateoutcomes','0'),(109,'grade_aggregateoutcomes_flag','2'),(110,'grade_keephigh','0'),(111,'grade_keephigh_flag','3'),(112,'grade_droplow','0'),(113,'grade_droplow_flag','2'),(114,'grade_overridecat','1'),(115,'grade_displaytype','1'),(116,'grade_decimalpoints','2'),(117,'grade_item_advanced','iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime'),(118,'grade_report_studentsperpage','100'),(119,'grade_report_showonlyactiveenrol','1'),(120,'grade_report_quickgrading','1'),(121,'grade_report_showquickfeedback','0'),(122,'grade_report_meanselection','1'),(123,'grade_report_enableajax','0'),(124,'grade_report_showcalculations','1'),(125,'grade_report_showeyecons','0'),(126,'grade_report_showaverages','1'),(127,'grade_report_showlocks','0'),(128,'grade_report_showranges','0'),(129,'grade_report_showanalysisicon','1'),(130,'grade_report_showuserimage','1'),(131,'grade_report_showactivityicons','1'),(132,'grade_report_shownumberofgrades','0'),(133,'grade_report_averagesdisplaytype','inherit'),(134,'grade_report_rangesdisplaytype','inherit'),(135,'grade_report_averagesdecimalpoints','inherit'),(136,'grade_report_rangesdecimalpoints','inherit'),(137,'grade_report_historyperpage','50'),(138,'grade_report_overview_showrank','0'),(139,'grade_report_overview_showtotalsifcontainhidden','0'),(140,'grade_report_user_showrank','0'),(141,'grade_report_user_showpercentage','1'),(142,'grade_report_user_showgrade','1'),(143,'grade_report_user_showfeedback','1'),(144,'grade_report_user_showrange','1'),(145,'grade_report_user_showweight','1'),(146,'grade_report_user_showaverage','0'),(147,'grade_report_user_showlettergrade','0'),(148,'grade_report_user_rangedecimals','0'),(149,'grade_report_user_showhiddenitems','1'),(150,'grade_report_user_showtotalsifcontainhidden','0'),(151,'grade_report_user_showcontributiontocoursetotal','1'),(152,'badges_defaultissuername',''),(153,'badges_defaultissuercontact',''),(154,'badges_badgesalt','badges1753775869'),(155,'badges_allowcoursebadges','1'),(156,'badges_allowexternalbackpack','1'),(157,'rememberuserlicensepref','1'),(159,'forcetimezone','99'),(160,'country','0'),(161,'defaultcity',''),(162,'geoip2file','/var/www/Trainocatelms-back/geoip/GeoLite2-City.mmdb'),(163,'googlemapkey3',''),(164,'allcountrycodes',''),(165,'autolang','1'),(166,'lang','en'),(167,'autolangusercreation','1'),(168,'langmenu','1'),(169,'langlist',''),(170,'langrev','1758522880'),(171,'langcache','1'),(172,'langstringcache','1'),(173,'locale',''),(174,'latinexcelexport','0'),(175,'messagingallusers','0'),(176,'messagingdefaultpressenter','1'),(177,'messagingdeletereadnotificationsdelay','604800'),(178,'messagingdeleteallnotificationsdelay','2620800'),(179,'messagingallowemailoverride','0'),(180,'requiremodintro','0'),(182,'authloginviaemail','0'),(183,'allowaccountssameemail','0'),(184,'authpreventaccountcreation','0'),(185,'loginpageautofocus','0'),(186,'guestloginbutton','0'),(187,'limitconcurrentlogins','0'),(188,'alternateloginurl',''),(189,'forgottenpasswordurl',''),(190,'auth_instructions',''),(191,'allowemailaddresses',''),(192,'denyemailaddresses',''),(193,'verifychangedemail','1'),(194,'recaptchapublickey',''),(195,'recaptchaprivatekey',''),(196,'filteruploadedfiles','0'),(197,'filtermatchoneperpage','0'),(198,'filtermatchonepertext','0'),(199,'filternavigationwithsystemcontext','0'),(200,'media_default_width','640'),(201,'media_default_height','360'),(202,'portfolio_moderate_filesize_threshold','1048576'),(203,'portfolio_high_filesize_threshold','5242880'),(204,'portfolio_moderate_db_threshold','20'),(205,'portfolio_high_db_threshold','50'),(206,'repositorycacheexpire','120'),(207,'repositorygetfiletimeout','30'),(208,'repositorysyncfiletimeout','1'),(209,'repositorysyncimagetimeout','3'),(210,'repositoryallowexternallinks','1'),(211,'legacyfilesinnewcourses','0'),(212,'legacyfilesaddallowed','1'),(213,'searchengine','simpledb'),(214,'searchindexwhendisabled','0'),(215,'searchindextime','600'),(216,'searchallavailablecourses','0'),(217,'searchincludeallcourses','0'),(218,'searchenablecategories','0'),(219,'searchdefaultcategory','core-all'),(220,'searchhideallcategory','0'),(221,'searchmaxtopresults','3'),(222,'searchteacherroles',''),(223,'searchenginequeryonly',''),(224,'searchbannerenable','0'),(225,'searchbanner',''),(226,'allowbeforeblock','0'),(227,'allowedip',''),(228,'blockedip',''),(229,'protectusernames','1'),(230,'forcelogin','0'),(231,'forceloginforprofiles','1'),(232,'forceloginforprofileimage','0'),(233,'opentowebcrawlers','0'),(234,'allowindexing','0'),(235,'maxbytes','0'),(236,'userquota','104857600'),(237,'allowobjectembed','0'),(238,'enabletrusttext','0'),(239,'maxeditingtime','1800'),(240,'extendedusernamechars','0'),(241,'keeptagnamecase','1'),(242,'profilesforenrolledusersonly','1'),(243,'cronclionly','1'),(244,'cronremotepassword',''),(245,'lockoutthreshold','0'),(246,'lockoutwindow','1800'),(247,'lockoutduration','1800'),(248,'passwordpolicy','1'),(249,'minpasswordlength','8'),(250,'minpassworddigits','1'),(251,'minpasswordlower','1'),(252,'minpasswordupper','1'),(253,'minpasswordnonalphanum','1'),(254,'maxconsecutiveidentchars','0'),(255,'passwordpolicycheckonlogin','0'),(256,'passwordreuselimit','0'),(257,'pwresettime','1800'),(258,'passwordchangelogout','0'),(259,'passwordchangetokendeletion','0'),(260,'tokenduration','7257600'),(261,'groupenrolmentkeypolicy','1'),(262,'disableuserimages','0'),(263,'emailchangeconfirmation','1'),(264,'rememberusername','2'),(265,'strictformsrequired','0'),(266,'cookiesecure','1'),(267,'cookiehttponly','0'),(268,'allowframembedding','0'),(269,'curlsecurityblockedhosts','127.0.0.1\n192.168.0.0/16\n10.0.0.0/8\n172.16.0.0/12\n0.0.0.0\nlocalhost\n169.254.169.254\n0000::1'),(270,'curlsecurityallowedport','443\n80'),(271,'referrerpolicy','default'),(272,'displayloginfailures','0'),(273,'notifyloginfailures',''),(274,'notifyloginthreshold','10'),(275,'themelist',''),(276,'themedesignermode','0'),(277,'allowuserthemes','0'),(278,'allowcoursethemes','0'),(279,'allowcategorythemes','0'),(280,'allowcohortthemes','0'),(281,'allowthemechangeonurl','0'),(282,'allowuserblockhiding','1'),(283,'langmenuinsecurelayout','0'),(284,'logininfoinsecurelayout','0'),(285,'custommenuitems',''),(286,'customusermenuitems','profile,moodle|/user/profile.php\r\ngrades,grades|/grade/report/mygrades.php\r\ncalendar,core_calendar|/calendar/view.php?view=month\r\nprivatefiles,moodle|/user/files.php\r\nreports,core_reportbuilder|/reportbuilder/index.php'),(287,'enabledevicedetection','1'),(288,'devicedetectregex','[]'),(289,'calendartype','gregorian'),(290,'calendar_adminseesall','0'),(291,'calendar_site_timeformat','0'),(292,'calendar_startwday','1'),(293,'calendar_weekend','65'),(294,'calendar_lookahead','21'),(295,'calendar_maxevents','10'),(296,'enablecalendarexport','1'),(297,'calendar_customexport','1'),(298,'calendar_exportlookahead','365'),(299,'calendar_exportlookback','5'),(300,'calendar_exportsalt','RJ9nEX7qAMifp4vL4bWktt1EvjmUGmmfYNDRvDQVcBEFt2pTS9bpvN4LbTtO'),(301,'calendar_showicalsource','1'),(302,'useblogassociations','1'),(303,'bloglevel','4'),(304,'useexternalblogs','1'),(305,'externalblogcrontime','86400'),(306,'maxexternalblogsperuser','1'),(307,'blogusecomments','1'),(308,'blogshowcommentscount','1'),(309,'enabledashboard','1'),(310,'defaulthomepage','1'),(311,'navshowfullcoursenames','0'),(312,'navshowcategories','1'),(313,'navshowmycoursecategories','0'),(314,'navshowallcourses','0'),(315,'navsortmycoursessort','sortorder'),(316,'navsortmycourseshiddenlast','1'),(317,'navcourselimit','10'),(318,'usesitenameforsitepages','0'),(319,'linkadmincategories','1'),(320,'linkcoursesections','1'),(321,'navshowfrontpagemods','1'),(322,'navadduserpostslinks','1'),(323,'formatstringstriptags','1'),(324,'emoticons','[{\"text\":\":-)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":-D\",\"imagename\":\"s\\/biggrin\",\"imagecomponent\":\"core\",\"altidentifier\":\"biggrin\",\"altcomponent\":\"core_pix\"},{\"text\":\";-)\",\"imagename\":\"s\\/wink\",\"imagecomponent\":\"core\",\"altidentifier\":\"wink\",\"altcomponent\":\"core_pix\"},{\"text\":\":-\\/\",\"imagename\":\"s\\/mixed\",\"imagecomponent\":\"core\",\"altidentifier\":\"mixed\",\"altcomponent\":\"core_pix\"},{\"text\":\"V-.\",\"imagename\":\"s\\/thoughtful\",\"imagecomponent\":\"core\",\"altidentifier\":\"thoughtful\",\"altcomponent\":\"core_pix\"},{\"text\":\":-P\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\":-p\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\"B-)\",\"imagename\":\"s\\/cool\",\"imagecomponent\":\"core\",\"altidentifier\":\"cool\",\"altcomponent\":\"core_pix\"},{\"text\":\"^-)\",\"imagename\":\"s\\/approve\",\"imagecomponent\":\"core\",\"altidentifier\":\"approve\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-)\",\"imagename\":\"s\\/wideeyes\",\"imagecomponent\":\"core\",\"altidentifier\":\"wideeyes\",\"altcomponent\":\"core_pix\"},{\"text\":\":o)\",\"imagename\":\"s\\/clown\",\"imagecomponent\":\"core\",\"altidentifier\":\"clown\",\"altcomponent\":\"core_pix\"},{\"text\":\":-(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\":(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-.\",\"imagename\":\"s\\/shy\",\"imagecomponent\":\"core\",\"altidentifier\":\"shy\",\"altcomponent\":\"core_pix\"},{\"text\":\":-I\",\"imagename\":\"s\\/blush\",\"imagecomponent\":\"core\",\"altidentifier\":\"blush\",\"altcomponent\":\"core_pix\"},{\"text\":\":-X\",\"imagename\":\"s\\/kiss\",\"imagecomponent\":\"core\",\"altidentifier\":\"kiss\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-o\",\"imagename\":\"s\\/surprise\",\"imagecomponent\":\"core\",\"altidentifier\":\"surprise\",\"altcomponent\":\"core_pix\"},{\"text\":\"P-|\",\"imagename\":\"s\\/blackeye\",\"imagecomponent\":\"core\",\"altidentifier\":\"blackeye\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-[\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"(grr)\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"xx-P\",\"imagename\":\"s\\/dead\",\"imagecomponent\":\"core\",\"altidentifier\":\"dead\",\"altcomponent\":\"core_pix\"},{\"text\":\"|-.\",\"imagename\":\"s\\/sleepy\",\"imagecomponent\":\"core\",\"altidentifier\":\"sleepy\",\"altcomponent\":\"core_pix\"},{\"text\":\"}-]\",\"imagename\":\"s\\/evil\",\"imagecomponent\":\"core\",\"altidentifier\":\"evil\",\"altcomponent\":\"core_pix\"},{\"text\":\"(h)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(heart)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(y)\",\"imagename\":\"s\\/yes\",\"imagecomponent\":\"core\",\"altidentifier\":\"yes\",\"altcomponent\":\"core\"},{\"text\":\"(n)\",\"imagename\":\"s\\/no\",\"imagecomponent\":\"core\",\"altidentifier\":\"no\",\"altcomponent\":\"core\"},{\"text\":\"(martin)\",\"imagename\":\"s\\/martin\",\"imagecomponent\":\"core\",\"altidentifier\":\"martin\",\"altcomponent\":\"core_pix\"},{\"text\":\"( )\",\"imagename\":\"s\\/egg\",\"imagecomponent\":\"core\",\"altidentifier\":\"egg\",\"altcomponent\":\"core_pix\"}]'),(325,'docroot','https://docs.moodle.org'),(326,'doclang',''),(327,'doctonewwindow','0'),(328,'coursecontactduplicates','0'),(329,'courselistshortnames','0'),(330,'coursesperpage','20'),(331,'courseswithsummarieslimit','10'),(332,'courseoverviewfileslimit','1'),(333,'courseoverviewfilesext','web_image'),(334,'coursegraceperiodbefore','0'),(335,'coursegraceperiodafter','0'),(336,'useexternalyui','0'),(337,'yuicomboloading','1'),(338,'cachejs','1'),(339,'additionalhtmlhead','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n#header.navbar {\r\n    background-color: #000 !important;   \r\n}\r\n\r\n\r\n/* Hide the Home tab in the primary navigation */\r\n.primary-navigation li[data-key=\"home\"] {\r\n    display: none !important;\r\n}\r\n\r\n\r\n</style>\r\n\r\n'),(340,'additionalhtmltopofbody',''),(341,'additionalhtmlfooter',''),(342,'cachetemplates','0'),(343,'pathtophp',''),(344,'pathtodu',''),(345,'aspellpath',''),(346,'pathtodot',''),(347,'pathtogs','/usr/bin/gs'),(348,'pathtopdftoppm',''),(349,'pathtopython',''),(350,'supportname','Admin User'),(351,'supportpage',''),(352,'dbsessions','0'),(353,'sessiontimeoutwarning','1200'),(354,'sessioncookie',''),(355,'sessioncookiepath',''),(356,'sessioncookiedomain',''),(357,'statsfirstrun','none'),(358,'statsmaxruntime','0'),(359,'statsruntimedays','31'),(360,'statsuserthreshold','0'),(361,'slasharguments','1'),(362,'getremoteaddrconf','3'),(363,'reverseproxyignore',''),(364,'proxyhost',''),(365,'proxyport','0'),(366,'proxytype','HTTP'),(367,'proxyuser',''),(368,'proxypassword',''),(369,'proxybypass','localhost, 127.0.0.1'),(370,'maintenance_enabled','0'),(371,'maintenance_message',''),(372,'deleteunconfirmed','168'),(373,'deleteincompleteusers','0'),(374,'disablegradehistory','0'),(375,'gradehistorylifetime','0'),(376,'tempdatafoldercleanup','168'),(377,'filescleanupperiod','86400'),(378,'extramemorylimit','512M'),(379,'maxtimelimit','0'),(380,'curlcache','120'),(381,'curltimeoutkbitrate','56'),(382,'cron_enabled','1'),(383,'task_scheduled_concurrency_limit','3'),(384,'task_scheduled_max_runtime','1800'),(385,'task_adhoc_concurrency_limit','3'),(386,'task_adhoc_max_runtime','1800'),(387,'task_logmode','1'),(388,'task_logtostdout','1'),(389,'task_logretention','2419200'),(390,'task_logretainruns','20'),(391,'smtphosts','smtp.gmail.com:587'),(392,'smtpsecure','tls'),(393,'smtpauthtype','LOGIN'),(394,'smtpuser','charmiwebcare@gmail.com'),(395,'smtppass','owcqfprbqvmpyncf'),(396,'smtpmaxbulk','1'),(397,'noreplyaddress','noreply@lms.techgigs.in'),(398,'allowedemaildomains',''),(399,'divertallemailsto',''),(400,'divertallemailsexcept',''),(401,'emaildkimselector',''),(402,'sitemailcharset','0'),(403,'allowusermailcharset','0'),(404,'allowattachments','1'),(405,'mailnewline','LF'),(406,'emailfromvia','1'),(407,'emailsubjectprefix',''),(408,'emailheaders',''),(409,'updateautocheck','1'),(410,'updateminmaturity','200'),(411,'updatenotifybuilds','0'),(412,'enablewsdocumentation','0'),(413,'dndallowtextandlinks','0'),(414,'pathtosassc',''),(415,'contextlocking','0'),(416,'contextlockappliestoadmin','1'),(417,'forceclean','0'),(418,'enablecourserelativedates','0'),(419,'debug','0'),(420,'debugdisplay','0'),(421,'perfdebug','7'),(422,'debugstringids','0'),(423,'debugsqltrace','0'),(424,'debugvalidators','0'),(425,'debugpageinfo','0'),(426,'profilingenabled','0'),(427,'profilingincluded',''),(428,'profilingexcluded',''),(429,'profilingautofrec','0'),(430,'profilingallowme','0'),(431,'profilingallowall','0'),(432,'profilingslow','0'),(433,'profilinglifetime','1440'),(434,'profilingimportprefix','(I)'),(435,'allowguestmymoodle','1'),(436,'release','4.0.12 (Build: 20231211)'),(437,'localcachedirpurged','1758522882'),(438,'scheduledtaskreset','1758522882'),(439,'paygw_plugins_sortorder','paypal'),(440,'allversionshash','4387017889431daa31cc4c6b574e8fe2da530ae4'),(442,'registrationpending','0'),(443,'branch','400'),(444,'enableaccessibilitytools','1'),(445,'notloggedinroleid','6'),(446,'guestroleid','6'),(447,'defaultuserroleid','7'),(448,'creatornewroleid','3'),(449,'restorernewroleid','3'),(450,'sitepolicyhandler',''),(451,'gradebookroles','5'),(452,'h5plibraryhandler','h5plib_v124'),(453,'airnotifierurl','https://messages.moodle.net'),(454,'airnotifierport','443'),(455,'airnotifiermobileappname','com.moodle.moodlemobile'),(456,'airnotifierappname','commoodlemoodlemobile'),(457,'airnotifieraccesskey','20ea626a8d7f88826941fd1e7c2abfc9'),(458,'bigbluebuttonbn_default_dpa_accepted','0'),(459,'bigbluebuttonbn_server_url','https://test-moodle.blindsidenetworks.com/bigbluebutton/'),(460,'bigbluebuttonbn_shared_secret','0b21fcaf34673a8c3ec8ed877d76ae34'),(461,'bigbluebuttonbn_welcome_default',''),(462,'bigbluebuttonbn_welcome_editable','1'),(463,'bigbluebuttonbn_recording_default','1'),(464,'bigbluebuttonbn_recording_refresh_period','300'),(465,'bigbluebuttonbn_recording_editable','1'),(466,'bigbluebuttonbn_recording_all_from_start_default','0'),(467,'bigbluebuttonbn_recording_all_from_start_editable','0'),(468,'bigbluebuttonbn_recording_hide_button_default','0'),(469,'bigbluebuttonbn_recording_hide_button_editable','0'),(470,'bigbluebuttonbn_importrecordings_enabled','0'),(471,'bigbluebuttonbn_importrecordings_from_deleted_enabled','0'),(472,'bigbluebuttonbn_recordings_deleted_default','1'),(473,'bigbluebuttonbn_recordings_deleted_editable','0'),(474,'bigbluebuttonbn_recordings_imported_default','0'),(475,'bigbluebuttonbn_recordings_imported_editable','1'),(476,'bigbluebuttonbn_recordings_preview_default','1'),(477,'bigbluebuttonbn_recordings_preview_editable','0'),(478,'bigbluebuttonbn_recordings_asc_sort','0'),(479,'bigbluebuttonbn_recording_protect_editable','1'),(480,'bigbluebuttonbn_waitformoderator_default','0'),(481,'bigbluebuttonbn_waitformoderator_editable','1'),(482,'bigbluebuttonbn_waitformoderator_ping_interval','10'),(483,'bigbluebuttonbn_waitformoderator_cache_ttl','60'),(484,'bigbluebuttonbn_voicebridge_editable','0'),(485,'bigbluebuttonbn_preuploadpresentation_editable','0'),(486,'bigbluebuttonbn_userlimit_default','0'),(487,'bigbluebuttonbn_userlimit_editable','0'),(488,'bigbluebuttonbn_participant_moderator_default','0'),(489,'bigbluebuttonbn_muteonstart_default','0'),(490,'bigbluebuttonbn_muteonstart_editable','0'),(491,'bigbluebuttonbn_disablecam_default','0'),(492,'bigbluebuttonbn_disablecam_editable','1'),(493,'bigbluebuttonbn_disablemic_default','0'),(494,'bigbluebuttonbn_disablemic_editable','1'),(495,'bigbluebuttonbn_disableprivatechat_default','0'),(496,'bigbluebuttonbn_disableprivatechat_editable','1'),(497,'bigbluebuttonbn_disablepublicchat_default','0'),(498,'bigbluebuttonbn_disablepublicchat_editable','1'),(499,'bigbluebuttonbn_disablenote_default','0'),(500,'bigbluebuttonbn_disablenote_editable','1'),(501,'bigbluebuttonbn_hideuserlist_default','0'),(502,'bigbluebuttonbn_hideuserlist_editable','1'),(503,'bigbluebuttonbn_lockonjoin_default','1'),(504,'bigbluebuttonbn_lockonjoin_editable','0'),(505,'bigbluebuttonbn_recordingready_enabled','0'),(506,'bigbluebuttonbn_meetingevents_enabled','0'),(507,'chat_method','ajax'),(508,'chat_refresh_userlist','10'),(509,'chat_old_ping','35'),(510,'chat_refresh_room','5'),(511,'chat_normal_updatemode','jsupdate'),(512,'chat_serverhost','lms.techgigs.in'),(513,'chat_serverip','127.0.0.1'),(514,'chat_serverport','9111'),(515,'chat_servermax','100'),(516,'data_enablerssfeeds','0'),(517,'feedback_allowfullanonymous','0'),(518,'forum_displaymode','3'),(519,'forum_shortpost','300'),(520,'forum_longpost','600'),(521,'forum_manydiscussions','100'),(522,'forum_maxbytes','512000'),(523,'forum_maxattachments','9'),(524,'forum_subscription','0'),(525,'forum_trackingtype','1'),(526,'forum_trackreadposts','1'),(527,'forum_allowforcedreadtracking','0'),(528,'forum_oldpostdays','14'),(529,'forum_usermarksread','0'),(530,'forum_cleanreadtime','2'),(531,'digestmailtime','17'),(532,'forum_enablerssfeeds','0'),(533,'forum_enabletimedposts','1'),(534,'glossary_entbypage','10'),(535,'glossary_dupentries','0'),(536,'glossary_allowcomments','0'),(537,'glossary_linkbydefault','1'),(538,'glossary_defaultapproval','1'),(539,'glossary_enablerssfeeds','0'),(540,'glossary_linkentries','0'),(541,'glossary_casesensitive','0'),(542,'glossary_fullmatch','0'),(543,'block_course_list_adminview','all'),(544,'block_course_list_hideallcourseslink','0'),(545,'block_online_users_timetosee','5'),(546,'block_online_users_onlinestatushiding','1'),(547,'block_rss_client_num_entries','5'),(548,'block_rss_client_timeout','30'),(549,'block_html_allowcssclasses','0'),(550,'pathtounoconv','/usr/bin/unoconv'),(551,'filter_multilang_force_old','0'),(552,'logguests','1'),(553,'loglifetime','0'),(554,'profileroles','5,4,3'),(555,'coursecontact','3'),(556,'frontpage','6'),(557,'frontpageloggedin','6'),(558,'maxcategorydepth','2'),(559,'frontpagecourselimit','200'),(560,'commentsperpage','15'),(561,'defaultfrontpageroleid','8'),(562,'messageinbound_enabled','0'),(563,'messageinbound_mailbox',''),(564,'messageinbound_domain',''),(565,'messageinbound_host',''),(566,'messageinbound_hostssl','ssl'),(567,'messageinbound_hostuser',''),(568,'messageinbound_hostpass',''),(569,'mobilecssurl',''),(570,'webserviceprotocols','rest'),(571,'enablemobilewebservice','1'),(572,'timezone','Asia/Kolkata'),(573,'registerauth',''),(574,'supportemail','charmiwebcare@gmail.com');
/*!40000 ALTER TABLE `mdl_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_config_log`
--

DROP TABLE IF EXISTS `mdl_config_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_config_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `plugin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `oldvalue` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_conflog_tim_ix` (`timemodified`),
  KEY `mdl_conflog_use_ix` (`userid`)
) ENGINE=InnoDB AUTO_INCREMENT=1914 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Changes done in server configuration through admin UI';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_config_log`
--

LOCK TABLES `mdl_config_log` WRITE;
/*!40000 ALTER TABLE `mdl_config_log` DISABLE KEYS */;
INSERT INTO `mdl_config_log` VALUES (1,0,1753775884,NULL,'enableuserfeedback','0',NULL),(2,0,1753775885,NULL,'userfeedback_nextreminder','1',NULL),(3,0,1753775885,NULL,'userfeedback_remindafter','90',NULL),(4,0,1753775885,NULL,'enableoutcomes','0',NULL),(5,0,1753775885,NULL,'usecomments','1',NULL),(6,0,1753775885,NULL,'usetags','1',NULL),(7,0,1753775885,NULL,'enablenotes','1',NULL),(8,0,1753775885,NULL,'enableportfolios','0',NULL),(9,0,1753775885,NULL,'enablewebservices','0',NULL),(10,0,1753775885,NULL,'enablestats','0',NULL),(11,0,1753775885,NULL,'enablerssfeeds','0',NULL),(12,0,1753775885,NULL,'enableblogs','1',NULL),(13,0,1753775885,NULL,'enablecompletion','1',NULL),(14,0,1753775885,NULL,'completiondefault','1',NULL),(15,0,1753775885,NULL,'enableavailability','1',NULL),(16,0,1753775885,NULL,'enableplagiarism','0',NULL),(17,0,1753775885,NULL,'enablebadges','1',NULL),(18,0,1753775885,NULL,'enableglobalsearch','0',NULL),(19,0,1753775885,NULL,'allowstealth','0',NULL),(20,0,1753775885,NULL,'enableanalytics','1',NULL),(21,0,1753775885,'core_competency','enabled','1',NULL),(22,0,1753775885,NULL,'messaging','1',NULL),(23,0,1753775885,NULL,'enablecustomreports','1',NULL),(24,0,1753775885,NULL,'allowemojipicker','1',NULL),(25,0,1753775885,NULL,'userfiltersdefault','realname',NULL),(26,0,1753775885,NULL,'defaultpreference_maildisplay','2',NULL),(27,0,1753775885,NULL,'defaultpreference_mailformat','1',NULL),(28,0,1753775885,NULL,'defaultpreference_maildigest','0',NULL),(29,0,1753775885,NULL,'defaultpreference_autosubscribe','1',NULL),(30,0,1753775885,NULL,'defaultpreference_trackforums','0',NULL),(31,0,1753775885,NULL,'defaultpreference_core_contentbank_visibility','1',NULL),(32,0,1753775885,NULL,'enroladminnewcourse','1',NULL),(33,0,1753775885,NULL,'autologinguests','0',NULL),(34,0,1753775885,NULL,'hiddenuserfields','',NULL),(35,0,1753775885,NULL,'showuseridentity','email',NULL),(36,0,1753775885,NULL,'fullnamedisplay','language',NULL),(37,0,1753775885,NULL,'alternativefullnameformat','language',NULL),(38,0,1753775885,NULL,'maxusersperpage','100',NULL),(39,0,1753775885,NULL,'enablegravatar','0',NULL),(40,0,1753775885,NULL,'gravatardefaulturl','mm',NULL),(41,0,1753775885,NULL,'agedigitalconsentverification','0',NULL),(42,0,1753775885,NULL,'agedigitalconsentmap','*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13',NULL),(43,0,1753775885,NULL,'sitepolicy','',NULL),(44,0,1753775885,NULL,'sitepolicyguest','',NULL),(45,0,1753775885,'moodlecourse','visible','1',NULL),(46,0,1753775885,'moodlecourse','downloadcontentsitedefault','0',NULL),(47,0,1753775885,'moodlecourse','participantsperpage','20',NULL),(48,0,1753775885,'moodlecourse','format','topics',NULL),(49,0,1753775885,'moodlecourse','maxsections','52',NULL),(50,0,1753775885,'moodlecourse','numsections','4',NULL),(51,0,1753775885,'moodlecourse','hiddensections','1',NULL),(52,0,1753775885,'moodlecourse','coursedisplay','0',NULL),(53,0,1753775885,'moodlecourse','courseenddateenabled','1',NULL),(54,0,1753775885,'moodlecourse','courseduration','31536000',NULL),(55,0,1753775885,'moodlecourse','lang','',NULL),(56,0,1753775885,'moodlecourse','newsitems','5',NULL),(57,0,1753775885,'moodlecourse','showgrades','1',NULL),(58,0,1753775885,'moodlecourse','showreports','0',NULL),(59,0,1753775885,'moodlecourse','showactivitydates','1',NULL),(60,0,1753775885,'moodlecourse','maxbytes','0',NULL),(61,0,1753775886,'moodlecourse','enablecompletion','1',NULL),(62,0,1753775886,'moodlecourse','showcompletionconditions','1',NULL),(63,0,1753775886,'moodlecourse','groupmode','0',NULL),(64,0,1753775886,'moodlecourse','groupmodeforce','0',NULL),(65,0,1753775886,NULL,'downloadcoursecontentallowed','0',NULL),(66,0,1753775886,NULL,'maxsizeperdownloadcoursefile','52428800',NULL),(67,0,1753775886,NULL,'enablecourserequests','1',NULL),(68,0,1753775886,NULL,'defaultrequestcategory','1',NULL),(69,0,1753775886,NULL,'lockrequestcategory','0',NULL),(70,0,1753775886,NULL,'courserequestnotify','',NULL),(71,0,1753775886,NULL,'activitychoosertabmode','0',NULL),(72,0,1753775886,NULL,'activitychooseractivefooter','hidden',NULL),(73,0,1753775886,'backup','loglifetime','30',NULL),(74,0,1753775886,'backup','backup_general_users','1',NULL),(75,0,1753775886,'backup','backup_general_users_locked','',NULL),(76,0,1753775886,'backup','backup_general_anonymize','0',NULL),(77,0,1753775886,'backup','backup_general_anonymize_locked','',NULL),(78,0,1753775886,'backup','backup_general_role_assignments','1',NULL),(79,0,1753775886,'backup','backup_general_role_assignments_locked','',NULL),(80,0,1753775886,'backup','backup_general_activities','1',NULL),(81,0,1753775886,'backup','backup_general_activities_locked','',NULL),(82,0,1753775886,'backup','backup_general_blocks','1',NULL),(83,0,1753775886,'backup','backup_general_blocks_locked','',NULL),(84,0,1753775886,'backup','backup_general_files','1',NULL),(85,0,1753775886,'backup','backup_general_files_locked','',NULL),(86,0,1753775886,'backup','backup_general_filters','1',NULL),(87,0,1753775886,'backup','backup_general_filters_locked','',NULL),(88,0,1753775886,'backup','backup_general_comments','1',NULL),(89,0,1753775886,'backup','backup_general_comments_locked','',NULL),(90,0,1753775886,'backup','backup_general_badges','1',NULL),(91,0,1753775886,'backup','backup_general_badges_locked','',NULL),(92,0,1753775886,'backup','backup_general_calendarevents','1',NULL),(93,0,1753775886,'backup','backup_general_calendarevents_locked','',NULL),(94,0,1753775886,'backup','backup_general_userscompletion','1',NULL),(95,0,1753775886,'backup','backup_general_userscompletion_locked','',NULL),(96,0,1753775886,'backup','backup_general_logs','0',NULL),(97,0,1753775886,'backup','backup_general_logs_locked','',NULL),(98,0,1753775886,'backup','backup_general_histories','0',NULL),(99,0,1753775886,'backup','backup_general_histories_locked','',NULL),(100,0,1753775886,'backup','backup_general_questionbank','1',NULL),(101,0,1753775886,'backup','backup_general_questionbank_locked','',NULL),(102,0,1753775886,'backup','backup_general_groups','1',NULL),(103,0,1753775886,'backup','backup_general_groups_locked','',NULL),(104,0,1753775886,'backup','backup_general_competencies','1',NULL),(105,0,1753775886,'backup','backup_general_competencies_locked','',NULL),(106,0,1753775886,'backup','backup_general_contentbankcontent','1',NULL),(107,0,1753775886,'backup','backup_general_contentbankcontent_locked','',NULL),(108,0,1753775886,'backup','backup_general_legacyfiles','1',NULL),(109,0,1753775886,'backup','backup_general_legacyfiles_locked','',NULL),(110,0,1753775886,'backup','import_general_maxresults','10',NULL),(111,0,1753775886,'backup','import_general_duplicate_admin_allowed','0',NULL),(112,0,1753775886,'backup','backup_import_permissions','0',NULL),(113,0,1753775886,'backup','backup_import_permissions_locked','',NULL),(114,0,1753775886,'backup','backup_import_activities','1',NULL),(115,0,1753775886,'backup','backup_import_activities_locked','',NULL),(116,0,1753775886,'backup','backup_import_blocks','1',NULL),(117,0,1753775886,'backup','backup_import_blocks_locked','',NULL),(118,0,1753775886,'backup','backup_import_filters','1',NULL),(119,0,1753775886,'backup','backup_import_filters_locked','',NULL),(120,0,1753775887,'backup','backup_import_calendarevents','1',NULL),(121,0,1753775887,'backup','backup_import_calendarevents_locked','',NULL),(122,0,1753775887,'backup','backup_import_questionbank','1',NULL),(123,0,1753775887,'backup','backup_import_questionbank_locked','',NULL),(124,0,1753775887,'backup','backup_import_groups','1',NULL),(125,0,1753775887,'backup','backup_import_groups_locked','',NULL),(126,0,1753775887,'backup','backup_import_competencies','1',NULL),(127,0,1753775887,'backup','backup_import_competencies_locked','',NULL),(128,0,1753775887,'backup','backup_import_contentbankcontent','1',NULL),(129,0,1753775887,'backup','backup_import_contentbankcontent_locked','',NULL),(130,0,1753775887,'backup','backup_import_legacyfiles','1',NULL),(131,0,1753775887,'backup','backup_import_legacyfiles_locked','',NULL),(132,0,1753775887,'backup','backup_auto_active','0',NULL),(133,0,1753775887,'backup','backup_auto_weekdays','0000000',NULL),(134,0,1753775887,'backup','backup_auto_hour','0',NULL),(135,0,1753775887,'backup','backup_auto_minute','0',NULL),(136,0,1753775887,'backup','backup_auto_storage','0',NULL),(137,0,1753775887,'backup','backup_auto_destination','',NULL),(138,0,1753775887,'backup','backup_auto_max_kept','1',NULL),(139,0,1753775887,'backup','backup_auto_delete_days','0',NULL),(140,0,1753775887,'backup','backup_auto_min_kept','0',NULL),(141,0,1753775887,'backup','backup_shortname','0',NULL),(142,0,1753775887,'backup','backup_auto_skip_hidden','1',NULL),(143,0,1753775887,'backup','backup_auto_skip_modif_days','30',NULL),(144,0,1753775887,'backup','backup_auto_skip_modif_prev','0',NULL),(145,0,1753775887,'backup','backup_auto_users','1',NULL),(146,0,1753775887,'backup','backup_auto_role_assignments','1',NULL),(147,0,1753775887,'backup','backup_auto_activities','1',NULL),(148,0,1753775887,'backup','backup_auto_blocks','1',NULL),(149,0,1753775887,'backup','backup_auto_files','1',NULL),(150,0,1753775887,'backup','backup_auto_filters','1',NULL),(151,0,1753775887,'backup','backup_auto_comments','1',NULL),(152,0,1753775887,'backup','backup_auto_badges','1',NULL),(153,0,1753775887,'backup','backup_auto_calendarevents','1',NULL),(154,0,1753775887,'backup','backup_auto_userscompletion','1',NULL),(155,0,1753775887,'backup','backup_auto_logs','0',NULL),(156,0,1753775887,'backup','backup_auto_histories','0',NULL),(157,0,1753775887,'backup','backup_auto_questionbank','1',NULL),(158,0,1753775887,'backup','backup_auto_groups','1',NULL),(159,0,1753775887,'backup','backup_auto_competencies','1',NULL),(160,0,1753775887,'backup','backup_auto_contentbankcontent','1',NULL),(161,0,1753775887,'backup','backup_auto_legacyfiles','1',NULL),(162,0,1753775887,'restore','restore_general_users','1',NULL),(163,0,1753775887,'restore','restore_general_users_locked','',NULL),(164,0,1753775887,'restore','restore_general_enrolments','1',NULL),(165,0,1753775887,'restore','restore_general_enrolments_locked','',NULL),(166,0,1753775887,'restore','restore_general_role_assignments','1',NULL),(167,0,1753775887,'restore','restore_general_role_assignments_locked','',NULL),(168,0,1753775887,'restore','restore_general_permissions','1',NULL),(169,0,1753775887,'restore','restore_general_permissions_locked','',NULL),(170,0,1753775887,'restore','restore_general_activities','1',NULL),(171,0,1753775887,'restore','restore_general_activities_locked','',NULL),(172,0,1753775887,'restore','restore_general_blocks','1',NULL),(173,0,1753775887,'restore','restore_general_blocks_locked','',NULL),(174,0,1753775887,'restore','restore_general_filters','1',NULL),(175,0,1753775887,'restore','restore_general_filters_locked','',NULL),(176,0,1753775887,'restore','restore_general_comments','1',NULL),(177,0,1753775887,'restore','restore_general_comments_locked','',NULL),(178,0,1753775887,'restore','restore_general_badges','1',NULL),(179,0,1753775887,'restore','restore_general_badges_locked','',NULL),(180,0,1753775887,'restore','restore_general_calendarevents','1',NULL),(181,0,1753775888,'restore','restore_general_calendarevents_locked','',NULL),(182,0,1753775888,'restore','restore_general_userscompletion','1',NULL),(183,0,1753775888,'restore','restore_general_userscompletion_locked','',NULL),(184,0,1753775888,'restore','restore_general_logs','1',NULL),(185,0,1753775888,'restore','restore_general_logs_locked','',NULL),(186,0,1753775888,'restore','restore_general_histories','1',NULL),(187,0,1753775888,'restore','restore_general_histories_locked','',NULL),(188,0,1753775888,'restore','restore_general_groups','1',NULL),(189,0,1753775888,'restore','restore_general_groups_locked','',NULL),(190,0,1753775888,'restore','restore_general_competencies','1',NULL),(191,0,1753775888,'restore','restore_general_competencies_locked','',NULL),(192,0,1753775888,'restore','restore_general_contentbankcontent','1',NULL),(193,0,1753775888,'restore','restore_general_contentbankcontent_locked','',NULL),(194,0,1753775888,'restore','restore_general_legacyfiles','1',NULL),(195,0,1753775888,'restore','restore_general_legacyfiles_locked','',NULL),(196,0,1753775888,'restore','restore_merge_overwrite_conf','0',NULL),(197,0,1753775888,'restore','restore_merge_overwrite_conf_locked','',NULL),(198,0,1753775888,'restore','restore_merge_course_fullname','1',NULL),(199,0,1753775888,'restore','restore_merge_course_fullname_locked','',NULL),(200,0,1753775888,'restore','restore_merge_course_shortname','1',NULL),(201,0,1753775888,'restore','restore_merge_course_shortname_locked','',NULL),(202,0,1753775888,'restore','restore_merge_course_startdate','1',NULL),(203,0,1753775888,'restore','restore_merge_course_startdate_locked','',NULL),(204,0,1753775888,'restore','restore_replace_overwrite_conf','0',NULL),(205,0,1753775888,'restore','restore_replace_overwrite_conf_locked','',NULL),(206,0,1753775888,'restore','restore_replace_course_fullname','1',NULL),(207,0,1753775888,'restore','restore_replace_course_fullname_locked','',NULL),(208,0,1753775888,'restore','restore_replace_course_shortname','1',NULL),(209,0,1753775888,'restore','restore_replace_course_shortname_locked','',NULL),(210,0,1753775888,'restore','restore_replace_course_startdate','1',NULL),(211,0,1753775888,'restore','restore_replace_course_startdate_locked','',NULL),(212,0,1753775888,'restore','restore_replace_keep_roles_and_enrolments','0',NULL),(213,0,1753775888,'restore','restore_replace_keep_roles_and_enrolments_locked','',NULL),(214,0,1753775888,'restore','restore_replace_keep_groups_and_groupings','0',NULL),(215,0,1753775888,'restore','restore_replace_keep_groups_and_groupings_locked','',NULL),(216,0,1753775888,NULL,'enableasyncbackup','0',NULL),(217,0,1753775888,'backup','backup_async_message_users','0',NULL),(218,0,1753775888,'backup','backup_async_message_subject','Moodle {operation} completed successfully',NULL),(219,0,1753775888,'backup','backup_async_message','Your {operation} (ID: {backupid}) has completed successfully. You can access it here: <a href=\"{link}\">{link}</a>.',NULL),(220,0,1753775888,NULL,'grade_profilereport','user',NULL),(221,0,1753775888,NULL,'grade_aggregationposition','1',NULL),(222,0,1753775888,NULL,'grade_includescalesinaggregation','1',NULL),(223,0,1753775888,NULL,'grade_hiddenasdate','0',NULL),(224,0,1753775888,NULL,'gradepublishing','0',NULL),(225,0,1753775888,NULL,'grade_export_exportfeedback','0',NULL),(226,0,1753775888,NULL,'grade_export_displaytype','1',NULL),(227,0,1753775888,NULL,'grade_export_decimalpoints','2',NULL),(228,0,1753775888,NULL,'grade_export_userprofilefields','firstname,lastname,idnumber,institution,department,email',NULL),(229,0,1753775888,NULL,'grade_export_customprofilefields','',NULL),(230,0,1753775888,NULL,'recovergradesdefault','0',NULL),(231,0,1753775888,NULL,'gradeexport','',NULL),(232,0,1753775888,NULL,'unlimitedgrades','0',NULL),(233,0,1753775888,NULL,'grade_report_showmin','1',NULL),(234,0,1753775888,NULL,'gradepointmax','100',NULL),(235,0,1753775888,NULL,'gradepointdefault','100',NULL),(236,0,1753775888,NULL,'grade_minmaxtouse','1',NULL),(237,0,1753775888,NULL,'grade_mygrades_report','overview',NULL),(238,0,1753775888,NULL,'gradereport_mygradeurl','',NULL),(239,0,1753775888,NULL,'grade_hideforcedsettings','1',NULL),(240,0,1753775888,NULL,'grade_aggregation','13',NULL),(241,0,1753775888,NULL,'grade_aggregation_flag','0',NULL),(242,0,1753775889,NULL,'grade_aggregations_visible','13',NULL),(243,0,1753775889,NULL,'grade_aggregateonlygraded','1',NULL),(244,0,1753775889,NULL,'grade_aggregateonlygraded_flag','2',NULL),(245,0,1753775889,NULL,'grade_aggregateoutcomes','0',NULL),(246,0,1753775889,NULL,'grade_aggregateoutcomes_flag','2',NULL),(247,0,1753775889,NULL,'grade_keephigh','0',NULL),(248,0,1753775889,NULL,'grade_keephigh_flag','3',NULL),(249,0,1753775889,NULL,'grade_droplow','0',NULL),(250,0,1753775889,NULL,'grade_droplow_flag','2',NULL),(251,0,1753775889,NULL,'grade_overridecat','1',NULL),(252,0,1753775889,NULL,'grade_displaytype','1',NULL),(253,0,1753775889,NULL,'grade_decimalpoints','2',NULL),(254,0,1753775889,NULL,'grade_item_advanced','iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime',NULL),(255,0,1753775889,NULL,'grade_report_studentsperpage','100',NULL),(256,0,1753775889,NULL,'grade_report_showonlyactiveenrol','1',NULL),(257,0,1753775889,NULL,'grade_report_quickgrading','1',NULL),(258,0,1753775889,NULL,'grade_report_showquickfeedback','0',NULL),(259,0,1753775889,NULL,'grade_report_meanselection','1',NULL),(260,0,1753775889,NULL,'grade_report_enableajax','0',NULL),(261,0,1753775889,NULL,'grade_report_showcalculations','1',NULL),(262,0,1753775889,NULL,'grade_report_showeyecons','0',NULL),(263,0,1753775889,NULL,'grade_report_showaverages','1',NULL),(264,0,1753775889,NULL,'grade_report_showlocks','0',NULL),(265,0,1753775889,NULL,'grade_report_showranges','0',NULL),(266,0,1753775889,NULL,'grade_report_showanalysisicon','1',NULL),(267,0,1753775889,NULL,'grade_report_showuserimage','1',NULL),(268,0,1753775889,NULL,'grade_report_showactivityicons','1',NULL),(269,0,1753775889,NULL,'grade_report_shownumberofgrades','0',NULL),(270,0,1753775889,NULL,'grade_report_averagesdisplaytype','inherit',NULL),(271,0,1753775889,NULL,'grade_report_rangesdisplaytype','inherit',NULL),(272,0,1753775889,NULL,'grade_report_averagesdecimalpoints','inherit',NULL),(273,0,1753775889,NULL,'grade_report_rangesdecimalpoints','inherit',NULL),(274,0,1753775889,NULL,'grade_report_historyperpage','50',NULL),(275,0,1753775889,NULL,'grade_report_overview_showrank','0',NULL),(276,0,1753775889,NULL,'grade_report_overview_showtotalsifcontainhidden','0',NULL),(277,0,1753775889,NULL,'grade_report_user_showrank','0',NULL),(278,0,1753775889,NULL,'grade_report_user_showpercentage','1',NULL),(279,0,1753775889,NULL,'grade_report_user_showgrade','1',NULL),(280,0,1753775889,NULL,'grade_report_user_showfeedback','1',NULL),(281,0,1753775889,NULL,'grade_report_user_showrange','1',NULL),(282,0,1753775889,NULL,'grade_report_user_showweight','1',NULL),(283,0,1753775889,NULL,'grade_report_user_showaverage','0',NULL),(284,0,1753775889,NULL,'grade_report_user_showlettergrade','0',NULL),(285,0,1753775889,NULL,'grade_report_user_rangedecimals','0',NULL),(286,0,1753775889,NULL,'grade_report_user_showhiddenitems','1',NULL),(287,0,1753775889,NULL,'grade_report_user_showtotalsifcontainhidden','0',NULL),(288,0,1753775889,NULL,'grade_report_user_showcontributiontocoursetotal','1',NULL),(289,0,1753775889,'analytics','modeinstruction','',NULL),(290,0,1753775889,'analytics','percentonline','0',NULL),(291,0,1753775889,'analytics','typeinstitution','',NULL),(292,0,1753775889,'analytics','levelinstitution','',NULL),(293,0,1753775889,'analytics','predictionsprocessor','\\mlbackend_php\\processor',NULL),(294,0,1753775889,'analytics','defaulttimesplittingsevaluation','\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range',NULL),(295,0,1753775889,'analytics','modeloutputdir','',NULL),(296,0,1753775889,'analytics','onlycli','1',NULL),(297,0,1753775889,'analytics','modeltimelimit','1200',NULL),(298,0,1753775889,'analytics','calclifetime','35',NULL),(299,0,1753775889,NULL,'badges_defaultissuername','',NULL),(300,0,1753775889,NULL,'badges_defaultissuercontact','',NULL),(301,0,1753775889,NULL,'badges_badgesalt','badges1753775869',NULL),(302,0,1753775890,NULL,'badges_allowcoursebadges','1',NULL),(303,0,1753775890,NULL,'badges_allowexternalbackpack','1',NULL),(304,0,1753775890,NULL,'rememberuserlicensepref','1',NULL),(305,0,1753775890,NULL,'timezone','Europe/London',NULL),(306,0,1753775890,NULL,'forcetimezone','99',NULL),(307,0,1753775890,NULL,'country','0',NULL),(308,0,1753775890,NULL,'defaultcity','',NULL),(309,0,1753775890,NULL,'geoip2file','/var/www/Trainocatelms-back/geoip/GeoLite2-City.mmdb',NULL),(310,0,1753775890,NULL,'googlemapkey3','',NULL),(311,0,1753775890,NULL,'allcountrycodes','',NULL),(312,0,1753775890,NULL,'autolang','1',NULL),(313,0,1753775890,NULL,'lang','en',NULL),(314,0,1753775890,NULL,'autolangusercreation','1',NULL),(315,0,1753775890,NULL,'langmenu','1',NULL),(316,0,1753775890,NULL,'langlist','',NULL),(317,0,1753775890,NULL,'langcache','1',NULL),(318,0,1753775890,NULL,'langstringcache','1',NULL),(319,0,1753775890,NULL,'locale','',NULL),(320,0,1753775890,NULL,'latinexcelexport','0',NULL),(321,0,1753775890,NULL,'messagingallusers','0',NULL),(322,0,1753775890,NULL,'messagingdefaultpressenter','1',NULL),(323,0,1753775890,NULL,'messagingdeletereadnotificationsdelay','604800',NULL),(324,0,1753775890,NULL,'messagingdeleteallnotificationsdelay','2620800',NULL),(325,0,1753775890,NULL,'messagingallowemailoverride','0',NULL),(326,0,1753775891,NULL,'requiremodintro','0',NULL),(327,0,1753775891,'antivirus','notifyemail','',NULL),(328,0,1753775891,'antivirus','notifylevel','2',NULL),(329,0,1753775891,'antivirus','threshold','1200',NULL),(330,0,1753775891,'antivirus','enablequarantine','0',NULL),(331,0,1753775891,'antivirus','quarantinetime','2419200',NULL),(332,0,1753775891,NULL,'registerauth','',NULL),(333,0,1753775891,NULL,'authloginviaemail','0',NULL),(334,0,1753775891,NULL,'allowaccountssameemail','0',NULL),(335,0,1753775891,NULL,'authpreventaccountcreation','0',NULL),(336,0,1753775891,NULL,'loginpageautofocus','0',NULL),(337,0,1753775891,NULL,'guestloginbutton','1',NULL),(338,0,1753775891,NULL,'limitconcurrentlogins','0',NULL),(339,0,1753775891,NULL,'alternateloginurl','',NULL),(340,0,1753775891,NULL,'forgottenpasswordurl','',NULL),(341,0,1753775891,NULL,'auth_instructions','',NULL),(342,0,1753775891,NULL,'allowemailaddresses','',NULL),(343,0,1753775891,NULL,'denyemailaddresses','',NULL),(344,0,1753775891,NULL,'verifychangedemail','1',NULL),(345,0,1753775891,NULL,'recaptchapublickey','',NULL),(346,0,1753775891,NULL,'recaptchaprivatekey','',NULL),(347,0,1753775891,'cachestore_apcu','testperformance','0',NULL),(348,0,1753775891,'cachestore_memcached','testservers','',NULL),(349,0,1753775891,'cachestore_mongodb','testserver','',NULL),(350,0,1753775891,'cachestore_redis','test_server','',NULL),(351,0,1753775891,'cachestore_redis','test_password','',NULL),(352,0,1753775891,'cachestore_redis','test_ttl','0',NULL),(353,0,1753775891,NULL,'filteruploadedfiles','0',NULL),(354,0,1753775891,NULL,'filtermatchoneperpage','0',NULL),(355,0,1753775891,NULL,'filtermatchonepertext','0',NULL),(356,0,1753775891,NULL,'filternavigationwithsystemcontext','0',NULL),(357,0,1753775891,NULL,'media_default_width','640',NULL),(358,0,1753775891,NULL,'media_default_height','360',NULL),(359,0,1753775891,NULL,'portfolio_moderate_filesize_threshold','1048576',NULL),(360,0,1753775891,NULL,'portfolio_high_filesize_threshold','5242880',NULL),(361,0,1753775891,NULL,'portfolio_moderate_db_threshold','20',NULL),(362,0,1753775891,NULL,'portfolio_high_db_threshold','50',NULL),(363,0,1753775891,'question_preview','behaviour','deferredfeedback',NULL),(364,0,1753775891,'question_preview','correctness','1',NULL),(365,0,1753775891,'question_preview','marks','2',NULL),(366,0,1753775891,'question_preview','markdp','2',NULL),(367,0,1753775891,'question_preview','feedback','1',NULL),(368,0,1753775891,'question_preview','generalfeedback','1',NULL),(369,0,1753775891,'question_preview','rightanswer','1',NULL),(370,0,1753775891,'question_preview','history','0',NULL),(371,0,1753775891,NULL,'repositorycacheexpire','120',NULL),(372,0,1753775891,NULL,'repositorygetfiletimeout','30',NULL),(373,0,1753775891,NULL,'repositorysyncfiletimeout','1',NULL),(374,0,1753775891,NULL,'repositorysyncimagetimeout','3',NULL),(375,0,1753775891,NULL,'repositoryallowexternallinks','1',NULL),(376,0,1753775891,NULL,'legacyfilesinnewcourses','0',NULL),(377,0,1753775891,NULL,'legacyfilesaddallowed','1',NULL),(378,0,1753775891,NULL,'searchengine','simpledb',NULL),(379,0,1753775891,NULL,'searchindexwhendisabled','0',NULL),(380,0,1753775891,NULL,'searchindextime','600',NULL),(381,0,1753775891,NULL,'searchallavailablecourses','0',NULL),(382,0,1753775891,NULL,'searchincludeallcourses','0',NULL),(383,0,1753775891,NULL,'searchenablecategories','0',NULL),(384,0,1753775892,NULL,'searchdefaultcategory','core-all',NULL),(385,0,1753775892,NULL,'searchhideallcategory','0',NULL),(386,0,1753775892,NULL,'searchmaxtopresults','3',NULL),(387,0,1753775892,NULL,'searchteacherroles','',NULL),(388,0,1753775892,NULL,'searchenginequeryonly','',NULL),(389,0,1753775892,NULL,'searchbannerenable','0',NULL),(390,0,1753775892,NULL,'searchbanner','',NULL),(391,0,1753775892,NULL,'allowbeforeblock','0',NULL),(392,0,1753775892,NULL,'allowedip','',NULL),(393,0,1753775892,NULL,'blockedip','',NULL),(394,0,1753775892,NULL,'protectusernames','1',NULL),(395,0,1753775892,NULL,'forcelogin','0',NULL),(396,0,1753775892,NULL,'forceloginforprofiles','1',NULL),(397,0,1753775892,NULL,'forceloginforprofileimage','0',NULL),(398,0,1753775892,NULL,'opentowebcrawlers','0',NULL),(399,0,1753775892,NULL,'allowindexing','0',NULL),(400,0,1753775892,NULL,'maxbytes','0',NULL),(401,0,1753775892,NULL,'userquota','104857600',NULL),(402,0,1753775892,NULL,'allowobjectembed','0',NULL),(403,0,1753775892,NULL,'enabletrusttext','0',NULL),(404,0,1753775892,NULL,'maxeditingtime','1800',NULL),(405,0,1753775892,NULL,'extendedusernamechars','0',NULL),(406,0,1753775892,NULL,'keeptagnamecase','1',NULL),(407,0,1753775892,NULL,'profilesforenrolledusersonly','1',NULL),(408,0,1753775892,NULL,'cronclionly','1',NULL),(409,0,1753775892,NULL,'cronremotepassword','',NULL),(410,0,1753775892,'tool_task','enablerunnow','1',NULL),(411,0,1753775892,NULL,'lockoutthreshold','0',NULL),(412,0,1753775892,NULL,'lockoutwindow','1800',NULL),(413,0,1753775892,NULL,'lockoutduration','1800',NULL),(414,0,1753775892,NULL,'passwordpolicy','1',NULL),(415,0,1753775892,NULL,'minpasswordlength','8',NULL),(416,0,1753775892,NULL,'minpassworddigits','1',NULL),(417,0,1753775892,NULL,'minpasswordlower','1',NULL),(418,0,1753775892,NULL,'minpasswordupper','1',NULL),(419,0,1753775892,NULL,'minpasswordnonalphanum','1',NULL),(420,0,1753775892,NULL,'maxconsecutiveidentchars','0',NULL),(421,0,1753775892,NULL,'passwordpolicycheckonlogin','0',NULL),(422,0,1753775892,NULL,'passwordreuselimit','0',NULL),(423,0,1753775892,NULL,'pwresettime','1800',NULL),(424,0,1753775892,NULL,'passwordchangelogout','0',NULL),(425,0,1753775892,NULL,'passwordchangetokendeletion','0',NULL),(426,0,1753775892,NULL,'tokenduration','7257600',NULL),(427,0,1753775892,NULL,'groupenrolmentkeypolicy','1',NULL),(428,0,1753775892,NULL,'disableuserimages','0',NULL),(429,0,1753775892,NULL,'emailchangeconfirmation','1',NULL),(430,0,1753775892,NULL,'rememberusername','2',NULL),(431,0,1753775892,NULL,'strictformsrequired','0',NULL),(432,0,1753775892,'adminpresets','sensiblesettings','recaptchapublickey@@none, recaptchaprivatekey@@none, googlemapkey3@@none, secretphrase@@url, cronremotepassword@@none, smtpuser@@none, smtppass@none, proxypassword@@none, quizpassword@@quiz, allowedip@@none, blockedip@@none, dbpass@@logstore_database, messageinbound_hostpass@@none, bind_pw@@auth_cas, pass@@auth_db, bind_pw@@auth_ldap, dbpass@@enrol_database, bind_pw@@enrol_ldap, server_password@@search_solr, ssl_keypassword@@search_solr, alternateserver_password@@search_solr, alternatessl_keypassword@@search_solr, test_password@@cachestore_redis, password@@mlbackend_python, badges_badgesalt@@none, calendar_exportsalt@@none',NULL),(433,0,1753775892,NULL,'cookiesecure','1',NULL),(434,0,1753775892,NULL,'cookiehttponly','0',NULL),(435,0,1753775892,NULL,'allowframembedding','0',NULL),(436,0,1753775892,NULL,'curlsecurityblockedhosts','127.0.0.1\n192.168.0.0/16\n10.0.0.0/8\n172.16.0.0/12\n0.0.0.0\nlocalhost\n169.254.169.254\n0000::1',NULL),(437,0,1753775892,NULL,'curlsecurityallowedport','443\n80',NULL),(438,0,1753775892,NULL,'referrerpolicy','default',NULL),(439,0,1753775892,NULL,'displayloginfailures','0',NULL),(440,0,1753775892,NULL,'notifyloginfailures','',NULL),(441,0,1753775892,NULL,'notifyloginthreshold','10',NULL),(442,0,1753775892,NULL,'themelist','',NULL),(443,0,1753775892,NULL,'themedesignermode','0',NULL),(444,0,1753775893,NULL,'allowuserthemes','0',NULL),(445,0,1753775893,NULL,'allowcoursethemes','0',NULL),(446,0,1753775893,NULL,'allowcategorythemes','0',NULL),(447,0,1753775893,NULL,'allowcohortthemes','0',NULL),(448,0,1753775893,NULL,'allowthemechangeonurl','0',NULL),(449,0,1753775893,NULL,'allowuserblockhiding','1',NULL),(450,0,1753775893,NULL,'langmenuinsecurelayout','0',NULL),(451,0,1753775893,NULL,'logininfoinsecurelayout','0',NULL),(452,0,1753775893,NULL,'custommenuitems','',NULL),(453,0,1753775893,NULL,'customusermenuitems','profile,moodle|/user/profile.php\ngrades,grades|/grade/report/mygrades.php\ncalendar,core_calendar|/calendar/view.php?view=month\nprivatefiles,moodle|/user/files.php\nreports,core_reportbuilder|/reportbuilder/index.php',NULL),(454,0,1753775893,NULL,'enabledevicedetection','1',NULL),(455,0,1753775893,NULL,'devicedetectregex','[]',NULL),(456,0,1753775893,'theme_boost','unaddableblocks','navigation,settings,course_list,section_links',NULL),(457,0,1753775893,'theme_boost','preset','default.scss',NULL),(458,0,1753775893,'theme_boost','presetfiles','',NULL),(459,0,1753775893,'theme_boost','backgroundimage','',NULL),(460,0,1753775893,'theme_boost','loginbackgroundimage','',NULL),(461,0,1753775893,'theme_boost','brandcolor','',NULL),(462,0,1753775893,'theme_boost','scsspre','',NULL),(463,0,1753775893,'theme_boost','scss','',NULL),(464,0,1753775893,'theme_classic','navbardark','0',NULL),(465,0,1753775893,'theme_classic','unaddableblocks','',NULL),(466,0,1753775893,'theme_classic','preset','default.scss',NULL),(467,0,1753775893,'theme_classic','presetfiles','',NULL),(468,0,1753775893,'theme_classic','backgroundimage','',NULL),(469,0,1753775893,'theme_classic','loginbackgroundimage','',NULL),(470,0,1753775893,'theme_classic','brandcolor','',NULL),(471,0,1753775893,'theme_classic','scsspre','',NULL),(472,0,1753775893,'theme_classic','scss','',NULL),(473,0,1753775893,'core_admin','logo','',NULL),(474,0,1753775893,'core_admin','logocompact','',NULL),(475,0,1753775893,'core_admin','coursecolor1','#81ecec',NULL),(476,0,1753775893,'core_admin','coursecolor2','#74b9ff',NULL),(477,0,1753775893,'core_admin','coursecolor3','#a29bfe',NULL),(478,0,1753775893,'core_admin','coursecolor4','#dfe6e9',NULL),(479,0,1753775893,'core_admin','coursecolor5','#00b894',NULL),(480,0,1753775893,'core_admin','coursecolor6','#0984e3',NULL),(481,0,1753775893,'core_admin','coursecolor7','#b2bec3',NULL),(482,0,1753775893,'core_admin','coursecolor8','#fdcb6e',NULL),(483,0,1753775893,'core_admin','coursecolor9','#fd79a8',NULL),(484,0,1753775893,'core_admin','coursecolor10','#6c5ce7',NULL),(485,0,1753775893,NULL,'calendartype','gregorian',NULL),(486,0,1753775893,NULL,'calendar_adminseesall','0',NULL),(487,0,1753775893,NULL,'calendar_site_timeformat','0',NULL),(488,0,1753775893,NULL,'calendar_startwday','1',NULL),(489,0,1753775893,NULL,'calendar_weekend','65',NULL),(490,0,1753775893,NULL,'calendar_lookahead','21',NULL),(491,0,1753775893,NULL,'calendar_maxevents','10',NULL),(492,0,1753775893,NULL,'enablecalendarexport','1',NULL),(493,0,1753775893,NULL,'calendar_customexport','1',NULL),(494,0,1753775893,NULL,'calendar_exportlookahead','365',NULL),(495,0,1753775893,NULL,'calendar_exportlookback','5',NULL),(496,0,1753775893,NULL,'calendar_exportsalt','tPNQXiThAsSp5idzOg1GVydNpj1se9ERA0XyG49rtqtYbnwh8cGXCJWLHYfG',NULL),(497,0,1753775893,NULL,'calendar_showicalsource','1',NULL),(498,0,1753775893,NULL,'useblogassociations','1',NULL),(499,0,1753775893,NULL,'bloglevel','4',NULL),(500,0,1753775893,NULL,'useexternalblogs','1',NULL),(501,0,1753775893,NULL,'externalblogcrontime','86400',NULL),(502,0,1753775893,NULL,'maxexternalblogsperuser','1',NULL),(503,0,1753775893,NULL,'blogusecomments','1',NULL),(504,0,1753775893,NULL,'blogshowcommentscount','1',NULL),(505,0,1753775894,NULL,'enabledashboard','1',NULL),(506,0,1753775894,NULL,'defaulthomepage','3',NULL),(507,0,1753775894,NULL,'navshowfullcoursenames','0',NULL),(508,0,1753775894,NULL,'navshowcategories','1',NULL),(509,0,1753775894,NULL,'navshowmycoursecategories','0',NULL),(510,0,1753775894,NULL,'navshowallcourses','0',NULL),(511,0,1753775894,NULL,'navsortmycoursessort','sortorder',NULL),(512,0,1753775894,NULL,'navsortmycourseshiddenlast','1',NULL),(513,0,1753775894,NULL,'navcourselimit','10',NULL),(514,0,1753775894,NULL,'usesitenameforsitepages','0',NULL),(515,0,1753775894,NULL,'linkadmincategories','1',NULL),(516,0,1753775894,NULL,'linkcoursesections','1',NULL),(517,0,1753775894,NULL,'navshowfrontpagemods','1',NULL),(518,0,1753775894,NULL,'navadduserpostslinks','1',NULL),(519,0,1753775894,NULL,'formatstringstriptags','1',NULL),(520,0,1753775894,NULL,'emoticons','[{\"text\":\":-)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":-D\",\"imagename\":\"s\\/biggrin\",\"imagecomponent\":\"core\",\"altidentifier\":\"biggrin\",\"altcomponent\":\"core_pix\"},{\"text\":\";-)\",\"imagename\":\"s\\/wink\",\"imagecomponent\":\"core\",\"altidentifier\":\"wink\",\"altcomponent\":\"core_pix\"},{\"text\":\":-\\/\",\"imagename\":\"s\\/mixed\",\"imagecomponent\":\"core\",\"altidentifier\":\"mixed\",\"altcomponent\":\"core_pix\"},{\"text\":\"V-.\",\"imagename\":\"s\\/thoughtful\",\"imagecomponent\":\"core\",\"altidentifier\":\"thoughtful\",\"altcomponent\":\"core_pix\"},{\"text\":\":-P\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\":-p\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\"B-)\",\"imagename\":\"s\\/cool\",\"imagecomponent\":\"core\",\"altidentifier\":\"cool\",\"altcomponent\":\"core_pix\"},{\"text\":\"^-)\",\"imagename\":\"s\\/approve\",\"imagecomponent\":\"core\",\"altidentifier\":\"approve\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-)\",\"imagename\":\"s\\/wideeyes\",\"imagecomponent\":\"core\",\"altidentifier\":\"wideeyes\",\"altcomponent\":\"core_pix\"},{\"text\":\":o)\",\"imagename\":\"s\\/clown\",\"imagecomponent\":\"core\",\"altidentifier\":\"clown\",\"altcomponent\":\"core_pix\"},{\"text\":\":-(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\":(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-.\",\"imagename\":\"s\\/shy\",\"imagecomponent\":\"core\",\"altidentifier\":\"shy\",\"altcomponent\":\"core_pix\"},{\"text\":\":-I\",\"imagename\":\"s\\/blush\",\"imagecomponent\":\"core\",\"altidentifier\":\"blush\",\"altcomponent\":\"core_pix\"},{\"text\":\":-X\",\"imagename\":\"s\\/kiss\",\"imagecomponent\":\"core\",\"altidentifier\":\"kiss\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-o\",\"imagename\":\"s\\/surprise\",\"imagecomponent\":\"core\",\"altidentifier\":\"surprise\",\"altcomponent\":\"core_pix\"},{\"text\":\"P-|\",\"imagename\":\"s\\/blackeye\",\"imagecomponent\":\"core\",\"altidentifier\":\"blackeye\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-[\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"(grr)\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"xx-P\",\"imagename\":\"s\\/dead\",\"imagecomponent\":\"core\",\"altidentifier\":\"dead\",\"altcomponent\":\"core_pix\"},{\"text\":\"|-.\",\"imagename\":\"s\\/sleepy\",\"imagecomponent\":\"core\",\"altidentifier\":\"sleepy\",\"altcomponent\":\"core_pix\"},{\"text\":\"}-]\",\"imagename\":\"s\\/evil\",\"imagecomponent\":\"core\",\"altidentifier\":\"evil\",\"altcomponent\":\"core_pix\"},{\"text\":\"(h)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(heart)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(y)\",\"imagename\":\"s\\/yes\",\"imagecomponent\":\"core\",\"altidentifier\":\"yes\",\"altcomponent\":\"core\"},{\"text\":\"(n)\",\"imagename\":\"s\\/no\",\"imagecomponent\":\"core\",\"altidentifier\":\"no\",\"altcomponent\":\"core\"},{\"text\":\"(martin)\",\"imagename\":\"s\\/martin\",\"imagecomponent\":\"core\",\"altidentifier\":\"martin\",\"altcomponent\":\"core_pix\"},{\"text\":\"( )\",\"imagename\":\"s\\/egg\",\"imagecomponent\":\"core\",\"altidentifier\":\"egg\",\"altcomponent\":\"core_pix\"}]',NULL),(521,0,1753775894,NULL,'docroot','https://docs.moodle.org',NULL),(522,0,1753775894,NULL,'doclang','',NULL),(523,0,1753775894,NULL,'doctonewwindow','0',NULL),(524,0,1753775894,NULL,'coursecontactduplicates','0',NULL),(525,0,1753775894,NULL,'courselistshortnames','0',NULL),(526,0,1753775894,NULL,'coursesperpage','20',NULL),(527,0,1753775894,NULL,'courseswithsummarieslimit','10',NULL),(528,0,1753775894,NULL,'courseoverviewfileslimit','1',NULL),(529,0,1753775894,NULL,'courseoverviewfilesext','web_image',NULL),(530,0,1753775894,NULL,'coursegraceperiodbefore','0',NULL),(531,0,1753775894,NULL,'coursegraceperiodafter','0',NULL),(532,0,1753775894,NULL,'useexternalyui','0',NULL),(533,0,1753775894,NULL,'yuicomboloading','1',NULL),(534,0,1753775894,NULL,'cachejs','1',NULL),(535,0,1753775894,NULL,'additionalhtmlhead','',NULL),(536,0,1753775894,NULL,'additionalhtmltopofbody','',NULL),(537,0,1753775894,NULL,'additionalhtmlfooter','',NULL),(538,0,1753775894,NULL,'cachetemplates','1',NULL),(539,0,1753775894,NULL,'pathtophp','',NULL),(540,0,1753775894,NULL,'pathtodu','',NULL),(541,0,1753775894,NULL,'aspellpath','',NULL),(542,0,1753775894,NULL,'pathtodot','',NULL),(543,0,1753775894,NULL,'pathtogs','/usr/bin/gs',NULL),(544,0,1753775894,NULL,'pathtopdftoppm','',NULL),(545,0,1753775894,NULL,'pathtopython','',NULL),(546,0,1753775894,NULL,'supportname','Admin User',NULL),(547,0,1753775894,NULL,'supportpage','',NULL),(548,0,1753775894,NULL,'dbsessions','0',NULL),(549,0,1753775894,NULL,'sessiontimeoutwarning','1200',NULL),(550,0,1753775894,NULL,'sessioncookie','',NULL),(551,0,1753775894,NULL,'sessioncookiepath','',NULL),(552,0,1753775894,NULL,'sessioncookiedomain','',NULL),(553,0,1753775894,NULL,'statsfirstrun','none',NULL),(554,0,1753775894,NULL,'statsmaxruntime','0',NULL),(555,0,1753775894,NULL,'statsruntimedays','31',NULL),(556,0,1753775894,NULL,'statsuserthreshold','0',NULL),(557,0,1753775894,NULL,'slasharguments','1',NULL),(558,0,1753775894,NULL,'getremoteaddrconf','3',NULL),(559,0,1753775894,NULL,'reverseproxyignore','',NULL),(560,0,1753775894,NULL,'proxyhost','',NULL),(561,0,1753775894,NULL,'proxyport','0',NULL),(562,0,1753775894,NULL,'proxytype','HTTP',NULL),(563,0,1753775895,NULL,'proxyuser','',NULL),(564,0,1753775895,NULL,'proxypassword','',NULL),(565,0,1753775895,NULL,'proxybypass','localhost, 127.0.0.1',NULL),(566,0,1753775895,NULL,'maintenance_enabled','0',NULL),(567,0,1753775895,NULL,'maintenance_message','',NULL),(568,0,1753775895,NULL,'deleteunconfirmed','168',NULL),(569,0,1753775895,NULL,'deleteincompleteusers','0',NULL),(570,0,1753775895,NULL,'disablegradehistory','0',NULL),(571,0,1753775895,NULL,'gradehistorylifetime','0',NULL),(572,0,1753775895,NULL,'tempdatafoldercleanup','168',NULL),(573,0,1753775895,NULL,'filescleanupperiod','86400',NULL),(574,0,1753775895,NULL,'extramemorylimit','512M',NULL),(575,0,1753775895,NULL,'maxtimelimit','0',NULL),(576,0,1753775895,NULL,'curlcache','120',NULL),(577,0,1753775895,NULL,'curltimeoutkbitrate','56',NULL),(578,0,1753775895,NULL,'cron_enabled','1',NULL),(579,0,1753775895,NULL,'task_scheduled_concurrency_limit','3',NULL),(580,0,1753775895,NULL,'task_scheduled_max_runtime','1800',NULL),(581,0,1753775895,NULL,'task_adhoc_concurrency_limit','3',NULL),(582,0,1753775895,NULL,'task_adhoc_max_runtime','1800',NULL),(583,0,1753775895,NULL,'task_logmode','1',NULL),(584,0,1753775895,NULL,'task_logtostdout','1',NULL),(585,0,1753775895,NULL,'task_logretention','2419200',NULL),(586,0,1753775895,NULL,'task_logretainruns','20',NULL),(587,0,1753775895,NULL,'smtphosts','',NULL),(588,0,1753775895,NULL,'smtpsecure','',NULL),(589,0,1753775895,NULL,'smtpauthtype','LOGIN',NULL),(590,0,1753775895,NULL,'smtpuser','',NULL),(591,0,1753775895,NULL,'smtppass','',NULL),(592,0,1753775895,NULL,'smtpmaxbulk','1',NULL),(593,0,1753775895,NULL,'noreplyaddress','noreply@lms.techgigs.in',NULL),(594,0,1753775895,NULL,'allowedemaildomains','',NULL),(595,0,1753775895,NULL,'divertallemailsto','',NULL),(596,0,1753775895,NULL,'divertallemailsexcept','',NULL),(597,0,1753775895,NULL,'emaildkimselector','',NULL),(598,0,1753775895,NULL,'sitemailcharset','0',NULL),(599,0,1753775895,NULL,'allowusermailcharset','0',NULL),(600,0,1753775895,NULL,'allowattachments','1',NULL),(601,0,1753775895,NULL,'mailnewline','LF',NULL),(602,0,1753775895,NULL,'emailfromvia','1',NULL),(603,0,1753775895,NULL,'emailsubjectprefix','',NULL),(604,0,1753775895,NULL,'emailheaders','',NULL),(605,0,1753775895,NULL,'updateautocheck','1',NULL),(606,0,1753775895,NULL,'updateminmaturity','200',NULL),(607,0,1753775895,NULL,'updatenotifybuilds','0',NULL),(608,0,1753775895,NULL,'enablewsdocumentation','0',NULL),(609,0,1753775895,NULL,'dndallowtextandlinks','0',NULL),(610,0,1753775895,NULL,'pathtosassc','',NULL),(611,0,1753775895,NULL,'contextlocking','0',NULL),(612,0,1753775895,NULL,'contextlockappliestoadmin','1',NULL),(613,0,1753775895,NULL,'forceclean','0',NULL),(614,0,1753775895,NULL,'enablecourserelativedates','0',NULL),(615,0,1753775895,NULL,'debug','0',NULL),(616,0,1753775895,NULL,'debugdisplay','0',NULL),(617,0,1753775895,NULL,'perfdebug','7',NULL),(618,0,1753775895,NULL,'debugstringids','0',NULL),(619,0,1753775895,NULL,'debugsqltrace','0',NULL),(620,0,1753775895,NULL,'debugvalidators','0',NULL),(621,0,1753775896,NULL,'debugpageinfo','0',NULL),(622,0,1753775896,NULL,'profilingenabled','0',NULL),(623,0,1753775896,NULL,'profilingincluded','',NULL),(624,0,1753775896,NULL,'profilingexcluded','',NULL),(625,0,1753775896,NULL,'profilingautofrec','0',NULL),(626,0,1753775896,NULL,'profilingallowme','0',NULL),(627,0,1753775896,NULL,'profilingallowall','0',NULL),(628,0,1753775896,NULL,'profilingslow','0',NULL),(629,0,1753775896,NULL,'profilinglifetime','1440',NULL),(630,0,1753775896,NULL,'profilingimportprefix','(I)',NULL),(631,0,1753775897,'core_competency','pushcourseratingstouserplans','1',NULL),(632,0,1753775898,NULL,'calendar_exportsalt','7Y8JZTLdtiSUVxMO6NEYrkushONQM9GoEATJuRhYDsz7XGVdk6xjxfBS2LJP','tPNQXiThAsSp5idzOg1GVydNpj1se9ERA0XyG49rtqtYbnwh8cGXCJWLHYfG'),(633,0,1753775898,NULL,'defaulthomepage','1','3'),(634,0,1753775898,NULL,'allowguestmymoodle','1',NULL),(635,0,1753775900,NULL,'calendar_exportsalt','RJ9nEX7qAMifp4vL4bWktt1EvjmUGmmfYNDRvDQVcBEFt2pTS9bpvN4LbTtO','7Y8JZTLdtiSUVxMO6NEYrkushONQM9GoEATJuRhYDsz7XGVdk6xjxfBS2LJP'),(636,0,1753775940,'activitynames','filter_active','1',''),(637,0,1753775940,'core_filter','order','activitynames','activitynames'),(638,0,1753775940,'displayh5p','filter_active','1',''),(639,0,1753775940,'core_filter','order','displayh5p, activitynames','activitynames, displayh5p'),(640,0,1753775940,'emoticon','filter_active','1',''),(641,0,1753775940,'mathjaxloader','filter_active','1',''),(642,0,1753775940,'core_filter','order','displayh5p, activitynames, mathjaxloader, emoticon','displayh5p, activitynames, emoticon, mathjaxloader'),(643,0,1753775940,'mediaplugin','filter_active','1',''),(644,0,1753775941,'urltolink','filter_active','1',''),(645,0,1753775941,'core_filter','order','displayh5p, activitynames, mathjaxloader, emoticon, urltolink, mediaplugin','displayh5p, activitynames, mathjaxloader, emoticon, mediaplugin, urltolink'),(646,2,1753854990,NULL,'enableaccessibilitytools','1',NULL),(647,2,1753854990,'tool_moodlenet','enablemoodlenet','1',NULL),(648,2,1753854990,NULL,'notloggedinroleid','6',NULL),(649,2,1753854990,NULL,'guestroleid','6',NULL),(650,2,1753854990,NULL,'defaultuserroleid','7',NULL),(651,2,1753854990,NULL,'creatornewroleid','3',NULL),(652,2,1753854990,NULL,'restorernewroleid','3',NULL),(653,2,1753854990,'tool_dataprivacy','contactdataprotectionofficer','0',NULL),(654,2,1753854990,'tool_dataprivacy','automaticdataexportapproval','0',NULL),(655,2,1753854990,'tool_dataprivacy','automaticdatadeletionapproval','0',NULL),(656,2,1753854990,'tool_dataprivacy','automaticdeletionrequests','1',NULL),(657,2,1753854990,'tool_dataprivacy','privacyrequestexpiry','604800',NULL),(658,2,1753854990,'tool_dataprivacy','requireallenddatesforuserdeletion','1',NULL),(659,2,1753854990,'tool_dataprivacy','showdataretentionsummary','1',NULL),(660,2,1753854990,'tool_log','exportlog','1',NULL),(661,2,1753854990,NULL,'sitepolicyhandler','',NULL),(662,2,1753854990,NULL,'gradebookroles','5',NULL),(663,2,1753854990,'analytics','logstore','logstore_standard',NULL),(664,2,1753854990,NULL,'h5plibraryhandler','h5plib_v124',NULL),(665,2,1753854990,NULL,'airnotifierurl','https://messages.moodle.net',NULL),(666,2,1753854990,NULL,'airnotifierport','443',NULL),(667,2,1753854990,NULL,'airnotifiermobileappname','com.moodle.moodlemobile',NULL),(668,2,1753854990,NULL,'airnotifierappname','commoodlemoodlemobile',NULL),(669,2,1753854990,NULL,'airnotifieraccesskey','',NULL),(670,2,1753854990,'assign','feedback_plugin_for_gradebook','assignfeedback_comments',NULL),(671,2,1753854990,'assign','showrecentsubmissions','0',NULL),(672,2,1753854990,'assign','submissionreceipts','1',NULL),(673,2,1753854990,'assign','submissionstatement','This submission is my own work, except where I have acknowledged the use of the works of other people.',NULL),(674,2,1753854990,'assign','submissionstatementteamsubmission','This submission is the work of my group, except where we have acknowledged the use of the works of other people.',NULL),(675,2,1753854990,'assign','submissionstatementteamsubmissionallsubmit','This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.',NULL),(676,2,1753854990,'assign','maxperpage','-1',NULL),(677,2,1753854990,'assign','alwaysshowdescription','1',NULL),(678,2,1753854990,'assign','alwaysshowdescription_adv','',NULL),(679,2,1753854990,'assign','alwaysshowdescription_locked','',NULL),(680,2,1753854990,'assign','allowsubmissionsfromdate','0',NULL),(681,2,1753854990,'assign','allowsubmissionsfromdate_enabled','1',NULL),(682,2,1753854991,'assign','allowsubmissionsfromdate_adv','',NULL),(683,2,1753854991,'assign','duedate','604800',NULL),(684,2,1753854991,'assign','duedate_enabled','1',NULL),(685,2,1753854991,'assign','duedate_adv','',NULL),(686,2,1753854991,'assign','cutoffdate','1209600',NULL),(687,2,1753854991,'assign','cutoffdate_enabled','',NULL),(688,2,1753854991,'assign','cutoffdate_adv','',NULL),(689,2,1753854991,'assign','enabletimelimit','0',NULL),(690,2,1753854991,'assign','gradingduedate','1209600',NULL),(691,2,1753854991,'assign','gradingduedate_enabled','1',NULL),(692,2,1753854991,'assign','gradingduedate_adv','',NULL),(693,2,1753854991,'assign','submissiondrafts','0',NULL),(694,2,1753854991,'assign','submissiondrafts_adv','',NULL),(695,2,1753854991,'assign','submissiondrafts_locked','',NULL),(696,2,1753854991,'assign','requiresubmissionstatement','0',NULL),(697,2,1753854991,'assign','requiresubmissionstatement_adv','',NULL),(698,2,1753854991,'assign','requiresubmissionstatement_locked','',NULL),(699,2,1753854991,'assign','attemptreopenmethod','none',NULL),(700,2,1753854991,'assign','attemptreopenmethod_adv','',NULL),(701,2,1753854991,'assign','attemptreopenmethod_locked','',NULL),(702,2,1753854991,'assign','maxattempts','-1',NULL),(703,2,1753854991,'assign','maxattempts_adv','',NULL),(704,2,1753854991,'assign','maxattempts_locked','',NULL),(705,2,1753854991,'assign','teamsubmission','0',NULL),(706,2,1753854991,'assign','teamsubmission_adv','',NULL),(707,2,1753854991,'assign','teamsubmission_locked','',NULL),(708,2,1753854991,'assign','preventsubmissionnotingroup','0',NULL),(709,2,1753854991,'assign','preventsubmissionnotingroup_adv','',NULL),(710,2,1753854991,'assign','preventsubmissionnotingroup_locked','',NULL),(711,2,1753854991,'assign','requireallteammemberssubmit','0',NULL),(712,2,1753854991,'assign','requireallteammemberssubmit_adv','',NULL),(713,2,1753854991,'assign','requireallteammemberssubmit_locked','',NULL),(714,2,1753854991,'assign','teamsubmissiongroupingid','',NULL),(715,2,1753854991,'assign','teamsubmissiongroupingid_adv','',NULL),(716,2,1753854991,'assign','sendnotifications','0',NULL),(717,2,1753854991,'assign','sendnotifications_adv','',NULL),(718,2,1753854991,'assign','sendnotifications_locked','',NULL),(719,2,1753854991,'assign','sendlatenotifications','0',NULL),(720,2,1753854991,'assign','sendlatenotifications_adv','',NULL),(721,2,1753854991,'assign','sendlatenotifications_locked','',NULL),(722,2,1753854991,'assign','sendstudentnotifications','1',NULL),(723,2,1753854991,'assign','sendstudentnotifications_adv','',NULL),(724,2,1753854991,'assign','sendstudentnotifications_locked','',NULL),(725,2,1753854991,'assign','blindmarking','0',NULL),(726,2,1753854991,'assign','blindmarking_adv','',NULL),(727,2,1753854991,'assign','blindmarking_locked','',NULL),(728,2,1753854991,'assign','hidegrader','0',NULL),(729,2,1753854991,'assign','hidegrader_adv','',NULL),(730,2,1753854991,'assign','hidegrader_locked','',NULL),(731,2,1753854991,'assign','markingworkflow','0',NULL),(732,2,1753854991,'assign','markingworkflow_adv','',NULL),(733,2,1753854991,'assign','markingworkflow_locked','',NULL),(734,2,1753854991,'assign','markingallocation','0',NULL),(735,2,1753854991,'assign','markingallocation_adv','',NULL),(736,2,1753854991,'assign','markingallocation_locked','',NULL),(737,2,1753854991,'assignsubmission_file','default','1',NULL),(738,2,1753854991,'assignsubmission_file','maxfiles','20',NULL),(739,2,1753854991,'assignsubmission_file','filetypes','',NULL),(740,2,1753854991,'assignsubmission_file','maxbytes','0',NULL),(741,2,1753854991,'assignsubmission_onlinetext','default','0',NULL),(742,2,1753854991,'assignfeedback_comments','default','1',NULL),(743,2,1753854991,'assignfeedback_comments','inline','0',NULL),(744,2,1753854991,'assignfeedback_comments','inline_adv','',NULL),(745,2,1753854991,'assignfeedback_comments','inline_locked','',NULL),(746,2,1753854991,'assignfeedback_editpdf','default','1',NULL),(747,2,1753854991,'assignfeedback_editpdf','stamps','',NULL),(748,2,1753854991,'assignfeedback_file','default','0',NULL),(749,2,1753854992,'assignfeedback_offline','default','0',NULL),(750,2,1753854992,NULL,'bigbluebuttonbn_default_dpa_accepted','0',NULL),(751,2,1753854992,NULL,'bigbluebuttonbn_server_url','https://test-moodle.blindsidenetworks.com/bigbluebutton/',NULL),(752,2,1753854992,NULL,'bigbluebuttonbn_shared_secret','********',NULL),(753,2,1753854992,NULL,'bigbluebuttonbn_welcome_default','',NULL),(754,2,1753854992,NULL,'bigbluebuttonbn_welcome_editable','1',NULL),(755,2,1753854992,NULL,'bigbluebuttonbn_recording_default','1',NULL),(756,2,1753854992,NULL,'bigbluebuttonbn_recording_refresh_period','300',NULL),(757,2,1753854992,NULL,'bigbluebuttonbn_recording_editable','1',NULL),(758,2,1753854992,NULL,'bigbluebuttonbn_recording_all_from_start_default','0',NULL),(759,2,1753854992,NULL,'bigbluebuttonbn_recording_all_from_start_editable','0',NULL),(760,2,1753854992,NULL,'bigbluebuttonbn_recording_hide_button_default','0',NULL),(761,2,1753854992,NULL,'bigbluebuttonbn_recording_hide_button_editable','0',NULL),(762,2,1753854992,NULL,'bigbluebuttonbn_importrecordings_enabled','0',NULL),(763,2,1753854992,NULL,'bigbluebuttonbn_importrecordings_from_deleted_enabled','0',NULL),(764,2,1753854992,NULL,'bigbluebuttonbn_recordings_deleted_default','1',NULL),(765,2,1753854992,NULL,'bigbluebuttonbn_recordings_deleted_editable','0',NULL),(766,2,1753854992,NULL,'bigbluebuttonbn_recordings_imported_default','0',NULL),(767,2,1753854992,NULL,'bigbluebuttonbn_recordings_imported_editable','1',NULL),(768,2,1753854992,NULL,'bigbluebuttonbn_recordings_preview_default','1',NULL),(769,2,1753854992,NULL,'bigbluebuttonbn_recordings_preview_editable','0',NULL),(770,2,1753854992,NULL,'bigbluebuttonbn_recordings_asc_sort','0',NULL),(771,2,1753854992,NULL,'bigbluebuttonbn_recording_protect_editable','1',NULL),(772,2,1753854992,NULL,'bigbluebuttonbn_waitformoderator_default','0',NULL),(773,2,1753854992,NULL,'bigbluebuttonbn_waitformoderator_editable','1',NULL),(774,2,1753854992,NULL,'bigbluebuttonbn_waitformoderator_ping_interval','10',NULL),(775,2,1753854992,NULL,'bigbluebuttonbn_waitformoderator_cache_ttl','60',NULL),(776,2,1753854992,NULL,'bigbluebuttonbn_voicebridge_editable','0',NULL),(777,2,1753854992,NULL,'bigbluebuttonbn_preuploadpresentation_editable','0',NULL),(778,2,1753854992,'mod_bigbluebuttonbn','presentationdefault','',NULL),(779,2,1753854992,NULL,'bigbluebuttonbn_userlimit_default','0',NULL),(780,2,1753854992,NULL,'bigbluebuttonbn_userlimit_editable','0',NULL),(781,2,1753854992,NULL,'bigbluebuttonbn_participant_moderator_default','0',NULL),(782,2,1753854992,NULL,'bigbluebuttonbn_muteonstart_default','0',NULL),(783,2,1753854992,NULL,'bigbluebuttonbn_muteonstart_editable','0',NULL),(784,2,1753854992,NULL,'bigbluebuttonbn_disablecam_default','0',NULL),(785,2,1753854992,NULL,'bigbluebuttonbn_disablecam_editable','1',NULL),(786,2,1753854992,NULL,'bigbluebuttonbn_disablemic_default','0',NULL),(787,2,1753854992,NULL,'bigbluebuttonbn_disablemic_editable','1',NULL),(788,2,1753854992,NULL,'bigbluebuttonbn_disableprivatechat_default','0',NULL),(789,2,1753854992,NULL,'bigbluebuttonbn_disableprivatechat_editable','1',NULL),(790,2,1753854992,NULL,'bigbluebuttonbn_disablepublicchat_default','0',NULL),(791,2,1753854992,NULL,'bigbluebuttonbn_disablepublicchat_editable','1',NULL),(792,2,1753854992,NULL,'bigbluebuttonbn_disablenote_default','0',NULL),(793,2,1753854992,NULL,'bigbluebuttonbn_disablenote_editable','1',NULL),(794,2,1753854992,NULL,'bigbluebuttonbn_hideuserlist_default','0',NULL),(795,2,1753854992,NULL,'bigbluebuttonbn_hideuserlist_editable','1',NULL),(796,2,1753854992,NULL,'bigbluebuttonbn_lockonjoin_default','1',NULL),(797,2,1753854992,NULL,'bigbluebuttonbn_lockonjoin_editable','0',NULL),(798,2,1753854992,NULL,'bigbluebuttonbn_recordingready_enabled','0',NULL),(799,2,1753854992,NULL,'bigbluebuttonbn_meetingevents_enabled','0',NULL),(800,2,1753854992,'book','numberingoptions','0,1,2,3',NULL),(801,2,1753854992,'book','numbering','1',NULL),(802,2,1753854992,NULL,'chat_method','ajax',NULL),(803,2,1753854992,NULL,'chat_refresh_userlist','10',NULL),(804,2,1753854992,NULL,'chat_old_ping','35',NULL),(805,2,1753854992,NULL,'chat_refresh_room','5',NULL),(806,2,1753854992,NULL,'chat_normal_updatemode','jsupdate',NULL),(807,2,1753854992,NULL,'chat_serverhost','lms.techgigs.in',NULL),(808,2,1753854992,NULL,'chat_serverip','127.0.0.1',NULL),(809,2,1753854992,NULL,'chat_serverport','9111',NULL),(810,2,1753854992,NULL,'chat_servermax','100',NULL),(811,2,1753854992,NULL,'data_enablerssfeeds','0',NULL),(812,2,1753854993,NULL,'feedback_allowfullanonymous','0',NULL),(813,2,1753854993,'resource','framesize','130',NULL),(814,2,1753854993,'resource','displayoptions','0,1,4,5,6',NULL),(815,2,1753854993,'resource','printintro','1',NULL),(816,2,1753854993,'resource','display','0',NULL),(817,2,1753854993,'resource','showsize','0',NULL),(818,2,1753854993,'resource','showtype','0',NULL),(819,2,1753854993,'resource','showdate','0',NULL),(820,2,1753854993,'resource','popupwidth','620',NULL),(821,2,1753854993,'resource','popupheight','450',NULL),(822,2,1753854993,'resource','filterfiles','0',NULL),(823,2,1753854993,'folder','showexpanded','1',NULL),(824,2,1753854993,'folder','maxsizetodownload','0',NULL),(825,2,1753854993,NULL,'forum_displaymode','3',NULL),(826,2,1753854993,NULL,'forum_shortpost','300',NULL),(827,2,1753854993,NULL,'forum_longpost','600',NULL),(828,2,1753854993,NULL,'forum_manydiscussions','100',NULL),(829,2,1753854993,NULL,'forum_maxbytes','512000',NULL),(830,2,1753854993,NULL,'forum_maxattachments','9',NULL),(831,2,1753854993,NULL,'forum_subscription','0',NULL),(832,2,1753854993,NULL,'forum_trackingtype','1',NULL),(833,2,1753854993,NULL,'forum_trackreadposts','1',NULL),(834,2,1753854993,NULL,'forum_allowforcedreadtracking','0',NULL),(835,2,1753854993,NULL,'forum_oldpostdays','14',NULL),(836,2,1753854993,NULL,'forum_usermarksread','0',NULL),(837,2,1753854993,NULL,'forum_cleanreadtime','2',NULL),(838,2,1753854993,NULL,'digestmailtime','17',NULL),(839,2,1753854993,NULL,'forum_enablerssfeeds','0',NULL),(840,2,1753854993,NULL,'forum_enabletimedposts','1',NULL),(841,2,1753854993,NULL,'glossary_entbypage','10',NULL),(842,2,1753854993,NULL,'glossary_dupentries','0',NULL),(843,2,1753854993,NULL,'glossary_allowcomments','0',NULL),(844,2,1753854993,NULL,'glossary_linkbydefault','1',NULL),(845,2,1753854993,NULL,'glossary_defaultapproval','1',NULL),(846,2,1753854993,NULL,'glossary_enablerssfeeds','0',NULL),(847,2,1753854993,NULL,'glossary_linkentries','0',NULL),(848,2,1753854993,NULL,'glossary_casesensitive','0',NULL),(849,2,1753854993,NULL,'glossary_fullmatch','0',NULL),(850,2,1753854993,'imscp','keepold','1',NULL),(851,2,1753854993,'imscp','keepold_adv','',NULL),(852,2,1753854993,'label','dndmedia','1',NULL),(853,2,1753854993,'label','dndresizewidth','400',NULL),(854,2,1753854993,'label','dndresizeheight','400',NULL),(855,2,1753854993,'mod_lesson','mediafile','',NULL),(856,2,1753854993,'mod_lesson','mediafile_adv','1',NULL),(857,2,1753854993,'mod_lesson','mediawidth','640',NULL),(858,2,1753854993,'mod_lesson','mediaheight','480',NULL),(859,2,1753854993,'mod_lesson','mediaclose','0',NULL),(860,2,1753854993,'mod_lesson','progressbar','0',NULL),(861,2,1753854993,'mod_lesson','progressbar_adv','',NULL),(862,2,1753854993,'mod_lesson','ongoing','0',NULL),(863,2,1753854993,'mod_lesson','ongoing_adv','1',NULL),(864,2,1753854993,'mod_lesson','displayleftmenu','0',NULL),(865,2,1753854993,'mod_lesson','displayleftmenu_adv','',NULL),(866,2,1753854993,'mod_lesson','displayleftif','0',NULL),(867,2,1753854993,'mod_lesson','displayleftif_adv','1',NULL),(868,2,1753854993,'mod_lesson','slideshow','0',NULL),(869,2,1753854993,'mod_lesson','slideshow_adv','1',NULL),(870,2,1753854993,'mod_lesson','slideshowwidth','640',NULL),(871,2,1753854993,'mod_lesson','slideshowheight','480',NULL),(872,2,1753854993,'mod_lesson','slideshowbgcolor','#FFFFFF',NULL),(873,2,1753854993,'mod_lesson','maxanswers','5',NULL),(874,2,1753854993,'mod_lesson','maxanswers_adv','1',NULL),(875,2,1753854993,'mod_lesson','defaultfeedback','0',NULL),(876,2,1753854993,'mod_lesson','defaultfeedback_adv','1',NULL),(877,2,1753854993,'mod_lesson','activitylink','',NULL),(878,2,1753854993,'mod_lesson','activitylink_adv','1',NULL),(879,2,1753854993,'mod_lesson','timelimit','0',NULL),(880,2,1753854994,'mod_lesson','timelimit_adv','',NULL),(881,2,1753854994,'mod_lesson','password','0',NULL),(882,2,1753854994,'mod_lesson','password_adv','1',NULL),(883,2,1753854994,'mod_lesson','modattempts','0',NULL),(884,2,1753854994,'mod_lesson','modattempts_adv','',NULL),(885,2,1753854994,'mod_lesson','displayreview','0',NULL),(886,2,1753854994,'mod_lesson','displayreview_adv','',NULL),(887,2,1753854994,'mod_lesson','maximumnumberofattempts','1',NULL),(888,2,1753854994,'mod_lesson','maximumnumberofattempts_adv','',NULL),(889,2,1753854994,'mod_lesson','defaultnextpage','0',NULL),(890,2,1753854994,'mod_lesson','defaultnextpage_adv','1',NULL),(891,2,1753854994,'mod_lesson','numberofpagestoshow','1',NULL),(892,2,1753854994,'mod_lesson','numberofpagestoshow_adv','1',NULL),(893,2,1753854994,'mod_lesson','practice','0',NULL),(894,2,1753854994,'mod_lesson','practice_adv','',NULL),(895,2,1753854994,'mod_lesson','customscoring','1',NULL),(896,2,1753854994,'mod_lesson','customscoring_adv','1',NULL),(897,2,1753854994,'mod_lesson','retakesallowed','0',NULL),(898,2,1753854994,'mod_lesson','retakesallowed_adv','',NULL),(899,2,1753854994,'mod_lesson','handlingofretakes','0',NULL),(900,2,1753854994,'mod_lesson','handlingofretakes_adv','1',NULL),(901,2,1753854994,'mod_lesson','minimumnumberofquestions','0',NULL),(902,2,1753854994,'mod_lesson','minimumnumberofquestions_adv','1',NULL),(903,2,1753854994,'page','displayoptions','5',NULL),(904,2,1753854994,'page','printintro','0',NULL),(905,2,1753854994,'page','printlastmodified','1',NULL),(906,2,1753854994,'page','display','5',NULL),(907,2,1753854994,'page','popupwidth','620',NULL),(908,2,1753854994,'page','popupheight','450',NULL),(909,2,1753854994,'quiz','timelimit','0',NULL),(910,2,1753854994,'quiz','timelimit_adv','',NULL),(911,2,1753854994,'quiz','timelimit_locked','',NULL),(912,2,1753854994,'quiz','notifyattemptgradeddelay','18000',NULL),(913,2,1753854994,'quiz','overduehandling','autosubmit',NULL),(914,2,1753854994,'quiz','overduehandling_adv','',NULL),(915,2,1753854994,'quiz','overduehandling_locked','',NULL),(916,2,1753854994,'quiz','graceperiod','86400',NULL),(917,2,1753854994,'quiz','graceperiod_adv','',NULL),(918,2,1753854994,'quiz','graceperiod_locked','',NULL),(919,2,1753854994,'quiz','graceperiodmin','60',NULL),(920,2,1753854994,'quiz','attempts','0',NULL),(921,2,1753854994,'quiz','attempts_adv','',NULL),(922,2,1753854994,'quiz','attempts_locked','',NULL),(923,2,1753854994,'quiz','grademethod','1',NULL),(924,2,1753854994,'quiz','grademethod_adv','',NULL),(925,2,1753854994,'quiz','grademethod_locked','',NULL),(926,2,1753854994,'quiz','maximumgrade','10',NULL),(927,2,1753854994,'quiz','maximumgrade_locked','',NULL),(928,2,1753854994,'quiz','questionsperpage','1',NULL),(929,2,1753854994,'quiz','questionsperpage_adv','',NULL),(930,2,1753854994,'quiz','questionsperpage_locked','',NULL),(931,2,1753854994,'quiz','navmethod','free',NULL),(932,2,1753854994,'quiz','navmethod_adv','1',NULL),(933,2,1753854994,'quiz','navmethod_locked','',NULL),(934,2,1753854994,'quiz','shuffleanswers','1',NULL),(935,2,1753854994,'quiz','shuffleanswers_adv','',NULL),(936,2,1753854994,'quiz','shuffleanswers_locked','',NULL),(937,2,1753854994,'quiz','preferredbehaviour','deferredfeedback',NULL),(938,2,1753854994,'quiz','preferredbehaviour_locked','',NULL),(939,2,1753854994,'quiz','canredoquestions','0',NULL),(940,2,1753854994,'quiz','canredoquestions_adv','1',NULL),(941,2,1753854994,'quiz','canredoquestions_locked','',NULL),(942,2,1753854994,'quiz','attemptonlast','0',NULL),(943,2,1753854994,'quiz','attemptonlast_adv','1',NULL),(944,2,1753854994,'quiz','attemptonlast_locked','',NULL),(945,2,1753854994,'quiz','reviewattempt','69904',NULL),(946,2,1753854995,'quiz','reviewcorrectness','69904',NULL),(947,2,1753854995,'quiz','reviewmarks','69904',NULL),(948,2,1753854995,'quiz','reviewspecificfeedback','69904',NULL),(949,2,1753854995,'quiz','reviewgeneralfeedback','69904',NULL),(950,2,1753854995,'quiz','reviewrightanswer','69904',NULL),(951,2,1753854995,'quiz','reviewoverallfeedback','4368',NULL),(952,2,1753854995,'quiz','showuserpicture','0',NULL),(953,2,1753854995,'quiz','showuserpicture_adv','',NULL),(954,2,1753854995,'quiz','showuserpicture_locked','',NULL),(955,2,1753854995,'quiz','decimalpoints','2',NULL),(956,2,1753854995,'quiz','decimalpoints_adv','',NULL),(957,2,1753854995,'quiz','decimalpoints_locked','',NULL),(958,2,1753854995,'quiz','questiondecimalpoints','-1',NULL),(959,2,1753854995,'quiz','questiondecimalpoints_adv','',NULL),(960,2,1753854995,'quiz','questiondecimalpoints_locked','',NULL),(961,2,1753854995,'quiz','showblocks','0',NULL),(962,2,1753854995,'quiz','showblocks_adv','1',NULL),(963,2,1753854995,'quiz','showblocks_locked','',NULL),(964,2,1753854995,'quiz','quizpassword','',NULL),(965,2,1753854995,'quiz','quizpassword_adv','',NULL),(966,2,1753854995,'quiz','quizpassword_required','',NULL),(967,2,1753854995,'quiz','quizpassword_locked','',NULL),(968,2,1753854995,'quiz','subnet','',NULL),(969,2,1753854995,'quiz','subnet_adv','1',NULL),(970,2,1753854995,'quiz','subnet_locked','',NULL),(971,2,1753854995,'quiz','delay1','0',NULL),(972,2,1753854995,'quiz','delay1_adv','1',NULL),(973,2,1753854995,'quiz','delay1_locked','',NULL),(974,2,1753854995,'quiz','delay2','0',NULL),(975,2,1753854995,'quiz','delay2_adv','1',NULL),(976,2,1753854995,'quiz','delay2_locked','',NULL),(977,2,1753854995,'quiz','browsersecurity','-',NULL),(978,2,1753854995,'quiz','browsersecurity_adv','1',NULL),(979,2,1753854995,'quiz','browsersecurity_locked','',NULL),(980,2,1753854995,'quiz','initialnumfeedbacks','2',NULL),(981,2,1753854995,'quiz','autosaveperiod','60',NULL),(982,2,1753854995,'quizaccess_seb','autoreconfigureseb','1',NULL),(983,2,1753854995,'quizaccess_seb','showseblinks','seb,http',NULL),(984,2,1753854995,'quizaccess_seb','downloadlink','https://safeexambrowser.org/download_en.html',NULL),(985,2,1753854995,'quizaccess_seb','quizpasswordrequired','0',NULL),(986,2,1753854995,'quizaccess_seb','displayblocksbeforestart','0',NULL),(987,2,1753854995,'quizaccess_seb','displayblockswhenfinished','1',NULL),(988,2,1753854995,'scorm','displaycoursestructure','0',NULL),(989,2,1753854995,'scorm','displaycoursestructure_adv','',NULL),(990,2,1753854995,'scorm','popup','0',NULL),(991,2,1753854995,'scorm','popup_adv','',NULL),(992,2,1753854995,'scorm','framewidth','100',NULL),(993,2,1753854995,'scorm','framewidth_adv','1',NULL),(994,2,1753854995,'scorm','frameheight','500',NULL),(995,2,1753854995,'scorm','frameheight_adv','1',NULL),(996,2,1753854995,'scorm','winoptgrp_adv','1',NULL),(997,2,1753854995,'scorm','scrollbars','0',NULL),(998,2,1753854995,'scorm','directories','0',NULL),(999,2,1753854995,'scorm','location','0',NULL),(1000,2,1753854995,'scorm','menubar','0',NULL),(1001,2,1753854995,'scorm','toolbar','0',NULL),(1002,2,1753854995,'scorm','status','0',NULL),(1003,2,1753854995,'scorm','skipview','0',NULL),(1004,2,1753854995,'scorm','skipview_adv','1',NULL),(1005,2,1753854995,'scorm','hidebrowse','0',NULL),(1006,2,1753854995,'scorm','hidebrowse_adv','1',NULL),(1007,2,1753854995,'scorm','hidetoc','0',NULL),(1008,2,1753854995,'scorm','hidetoc_adv','1',NULL),(1009,2,1753854995,'scorm','nav','1',NULL),(1010,2,1753854995,'scorm','nav_adv','1',NULL),(1011,2,1753854995,'scorm','navpositionleft','-100',NULL),(1012,2,1753854995,'scorm','navpositionleft_adv','1',NULL),(1013,2,1753854995,'scorm','navpositiontop','-100',NULL),(1014,2,1753854995,'scorm','navpositiontop_adv','1',NULL),(1015,2,1753854996,'scorm','collapsetocwinsize','767',NULL),(1016,2,1753854996,'scorm','collapsetocwinsize_adv','1',NULL),(1017,2,1753854996,'scorm','displayattemptstatus','1',NULL),(1018,2,1753854996,'scorm','displayattemptstatus_adv','',NULL),(1019,2,1753854996,'scorm','grademethod','1',NULL),(1020,2,1753854996,'scorm','maxgrade','100',NULL),(1021,2,1753854996,'scorm','maxattempt','0',NULL),(1022,2,1753854996,'scorm','whatgrade','0',NULL),(1023,2,1753854996,'scorm','forcecompleted','0',NULL),(1024,2,1753854996,'scorm','forcenewattempt','0',NULL),(1025,2,1753854996,'scorm','autocommit','0',NULL),(1026,2,1753854996,'scorm','masteryoverride','1',NULL),(1027,2,1753854996,'scorm','lastattemptlock','0',NULL),(1028,2,1753854996,'scorm','auto','0',NULL),(1029,2,1753854996,'scorm','updatefreq','0',NULL),(1030,2,1753854996,'scorm','scormstandard','0',NULL),(1031,2,1753854996,'scorm','allowtypeexternal','0',NULL),(1032,2,1753854996,'scorm','allowtypelocalsync','0',NULL),(1033,2,1753854996,'scorm','allowtypeexternalaicc','0',NULL),(1034,2,1753854996,'scorm','allowaicchacp','0',NULL),(1035,2,1753854996,'scorm','aicchacptimeout','30',NULL),(1036,2,1753854996,'scorm','aicchacpkeepsessiondata','1',NULL),(1037,2,1753854996,'scorm','aiccuserid','1',NULL),(1038,2,1753854996,'scorm','forcejavascript','1',NULL),(1039,2,1753854996,'scorm','allowapidebug','0',NULL),(1040,2,1753854996,'scorm','apidebugmask','.*',NULL),(1041,2,1753854996,'scorm','protectpackagedownloads','0',NULL),(1042,2,1753854996,'url','framesize','130',NULL),(1043,2,1753854996,'url','secretphrase','',NULL),(1044,2,1753854996,'url','rolesinparams','0',NULL),(1045,2,1753854996,'url','displayoptions','0,1,5,6',NULL),(1046,2,1753854996,'url','printintro','1',NULL),(1047,2,1753854996,'url','display','0',NULL),(1048,2,1753854996,'url','popupwidth','620',NULL),(1049,2,1753854996,'url','popupheight','450',NULL),(1050,2,1753854996,'workshop','grade','80',NULL),(1051,2,1753854996,'workshop','gradinggrade','20',NULL),(1052,2,1753854996,'workshop','gradedecimals','0',NULL),(1053,2,1753854996,'workshop','maxbytes','0',NULL),(1054,2,1753854996,'workshop','strategy','accumulative',NULL),(1055,2,1753854996,'workshop','examplesmode','0',NULL),(1056,2,1753854996,'workshopallocation_random','numofreviews','5',NULL),(1057,2,1753854996,'workshopform_numerrors','grade0','No',NULL),(1058,2,1753854996,'workshopform_numerrors','grade1','Yes',NULL),(1059,2,1753854996,'workshopeval_best','comparison','5',NULL),(1060,2,1753854996,'tool_brickfield','analysistype','0',NULL),(1061,2,1753854996,'tool_brickfield','deletehistoricaldata','1',NULL),(1062,2,1753854996,'tool_brickfield','batch','1000',NULL),(1063,2,1753854996,'tool_brickfield','perpage','50',NULL),(1064,2,1753854996,'tool_recyclebin','coursebinenable','1',NULL),(1065,2,1753854996,'tool_recyclebin','coursebinexpiry','604800',NULL),(1066,2,1753854996,'tool_recyclebin','categorybinenable','1',NULL),(1067,2,1753854996,'tool_recyclebin','categorybinexpiry','604800',NULL),(1068,2,1753854996,'tool_recyclebin','autohide','1',NULL),(1069,2,1753854996,'antivirus_clamav','runningmethod','commandline',NULL),(1070,2,1753854996,'antivirus_clamav','pathtoclam','',NULL),(1071,2,1753854996,'antivirus_clamav','pathtounixsocket','',NULL),(1072,2,1753854996,'antivirus_clamav','tcpsockethost','',NULL),(1073,2,1753854996,'antivirus_clamav','tcpsocketport','3310',NULL),(1074,2,1753854996,'antivirus_clamav','clamfailureonupload','tryagain',NULL),(1075,2,1753854996,'antivirus_clamav','tries','1',NULL),(1076,2,1753854996,'auth_cas','field_map_firstname','',NULL),(1077,2,1753854996,'auth_cas','field_updatelocal_firstname','oncreate',NULL),(1078,2,1753854996,'auth_cas','field_updateremote_firstname','0',NULL),(1079,2,1753854996,'auth_cas','field_lock_firstname','unlocked',NULL),(1080,2,1753854996,'auth_cas','field_map_lastname','',NULL),(1081,2,1753854996,'auth_cas','field_updatelocal_lastname','oncreate',NULL),(1082,2,1753854996,'auth_cas','field_updateremote_lastname','0',NULL),(1083,2,1753854996,'auth_cas','field_lock_lastname','unlocked',NULL),(1084,2,1753854996,'auth_cas','field_map_email','',NULL),(1085,2,1753854996,'auth_cas','field_updatelocal_email','oncreate',NULL),(1086,2,1753854997,'auth_cas','field_updateremote_email','0',NULL),(1087,2,1753854997,'auth_cas','field_lock_email','unlocked',NULL),(1088,2,1753854997,'auth_cas','field_map_city','',NULL),(1089,2,1753854997,'auth_cas','field_updatelocal_city','oncreate',NULL),(1090,2,1753854997,'auth_cas','field_updateremote_city','0',NULL),(1091,2,1753854997,'auth_cas','field_lock_city','unlocked',NULL),(1092,2,1753854997,'auth_cas','field_map_country','',NULL),(1093,2,1753854997,'auth_cas','field_updatelocal_country','oncreate',NULL),(1094,2,1753854997,'auth_cas','field_updateremote_country','0',NULL),(1095,2,1753854997,'auth_cas','field_lock_country','unlocked',NULL),(1096,2,1753854997,'auth_cas','field_map_lang','',NULL),(1097,2,1753854997,'auth_cas','field_updatelocal_lang','oncreate',NULL),(1098,2,1753854997,'auth_cas','field_updateremote_lang','0',NULL),(1099,2,1753854997,'auth_cas','field_lock_lang','unlocked',NULL),(1100,2,1753854997,'auth_cas','field_map_description','',NULL),(1101,2,1753854997,'auth_cas','field_updatelocal_description','oncreate',NULL),(1102,2,1753854997,'auth_cas','field_updateremote_description','0',NULL),(1103,2,1753854997,'auth_cas','field_lock_description','unlocked',NULL),(1104,2,1753854997,'auth_cas','field_map_idnumber','',NULL),(1105,2,1753854997,'auth_cas','field_updatelocal_idnumber','oncreate',NULL),(1106,2,1753854997,'auth_cas','field_updateremote_idnumber','0',NULL),(1107,2,1753854997,'auth_cas','field_lock_idnumber','unlocked',NULL),(1108,2,1753854997,'auth_cas','field_map_institution','',NULL),(1109,2,1753854997,'auth_cas','field_updatelocal_institution','oncreate',NULL),(1110,2,1753854997,'auth_cas','field_updateremote_institution','0',NULL),(1111,2,1753854997,'auth_cas','field_lock_institution','unlocked',NULL),(1112,2,1753854997,'auth_cas','field_map_department','',NULL),(1113,2,1753854997,'auth_cas','field_updatelocal_department','oncreate',NULL),(1114,2,1753854997,'auth_cas','field_updateremote_department','0',NULL),(1115,2,1753854997,'auth_cas','field_lock_department','unlocked',NULL),(1116,2,1753854997,'auth_cas','field_map_phone1','',NULL),(1117,2,1753854997,'auth_cas','field_updatelocal_phone1','oncreate',NULL),(1118,2,1753854997,'auth_cas','field_updateremote_phone1','0',NULL),(1119,2,1753854997,'auth_cas','field_lock_phone1','unlocked',NULL),(1120,2,1753854997,'auth_cas','field_map_phone2','',NULL),(1121,2,1753854997,'auth_cas','field_updatelocal_phone2','oncreate',NULL),(1122,2,1753854997,'auth_cas','field_updateremote_phone2','0',NULL),(1123,2,1753854997,'auth_cas','field_lock_phone2','unlocked',NULL),(1124,2,1753854997,'auth_cas','field_map_address','',NULL),(1125,2,1753854997,'auth_cas','field_updatelocal_address','oncreate',NULL),(1126,2,1753854997,'auth_cas','field_updateremote_address','0',NULL),(1127,2,1753854997,'auth_cas','field_lock_address','unlocked',NULL),(1128,2,1753854997,'auth_cas','field_map_firstnamephonetic','',NULL),(1129,2,1753854997,'auth_cas','field_updatelocal_firstnamephonetic','oncreate',NULL),(1130,2,1753854997,'auth_cas','field_updateremote_firstnamephonetic','0',NULL),(1131,2,1753854997,'auth_cas','field_lock_firstnamephonetic','unlocked',NULL),(1132,2,1753854997,'auth_cas','field_map_lastnamephonetic','',NULL),(1133,2,1753854997,'auth_cas','field_updatelocal_lastnamephonetic','oncreate',NULL),(1134,2,1753854997,'auth_cas','field_updateremote_lastnamephonetic','0',NULL),(1135,2,1753854997,'auth_cas','field_lock_lastnamephonetic','unlocked',NULL),(1136,2,1753854997,'auth_cas','field_map_middlename','',NULL),(1137,2,1753854997,'auth_cas','field_updatelocal_middlename','oncreate',NULL),(1138,2,1753854997,'auth_cas','field_updateremote_middlename','0',NULL),(1139,2,1753854997,'auth_cas','field_lock_middlename','unlocked',NULL),(1140,2,1753854997,'auth_cas','field_map_alternatename','',NULL),(1141,2,1753854997,'auth_cas','field_updatelocal_alternatename','oncreate',NULL),(1142,2,1753854997,'auth_cas','field_updateremote_alternatename','0',NULL),(1143,2,1753854997,'auth_cas','field_lock_alternatename','unlocked',NULL),(1144,2,1753854997,'auth_email','recaptcha','0',NULL),(1145,2,1753854997,'auth_email','field_lock_firstname','unlocked',NULL),(1146,2,1753854997,'auth_email','field_lock_lastname','unlocked',NULL),(1147,2,1753854997,'auth_email','field_lock_email','unlocked',NULL),(1148,2,1753854997,'auth_email','field_lock_city','unlocked',NULL),(1149,2,1753854997,'auth_email','field_lock_country','unlocked',NULL),(1150,2,1753854997,'auth_email','field_lock_lang','unlocked',NULL),(1151,2,1753854997,'auth_email','field_lock_description','unlocked',NULL),(1152,2,1753854997,'auth_email','field_lock_idnumber','unlocked',NULL),(1153,2,1753854997,'auth_email','field_lock_institution','unlocked',NULL),(1154,2,1753854997,'auth_email','field_lock_department','unlocked',NULL),(1155,2,1753854997,'auth_email','field_lock_phone1','unlocked',NULL),(1156,2,1753854998,'auth_email','field_lock_phone2','unlocked',NULL),(1157,2,1753854998,'auth_email','field_lock_address','unlocked',NULL),(1158,2,1753854998,'auth_email','field_lock_firstnamephonetic','unlocked',NULL),(1159,2,1753854998,'auth_email','field_lock_lastnamephonetic','unlocked',NULL),(1160,2,1753854998,'auth_email','field_lock_middlename','unlocked',NULL),(1161,2,1753854998,'auth_email','field_lock_alternatename','unlocked',NULL),(1162,2,1753854998,'auth_db','host','127.0.0.1',NULL),(1163,2,1753854998,'auth_db','type','mysqli',NULL),(1164,2,1753854998,'auth_db','sybasequoting','0',NULL),(1165,2,1753854998,'auth_db','name','',NULL),(1166,2,1753854998,'auth_db','user','',NULL),(1167,2,1753854998,'auth_db','pass','',NULL),(1168,2,1753854998,'auth_db','table','',NULL),(1169,2,1753854998,'auth_db','fielduser','',NULL),(1170,2,1753854998,'auth_db','fieldpass','',NULL),(1171,2,1753854998,'auth_db','passtype','plaintext',NULL),(1172,2,1753854998,'auth_db','extencoding','utf-8',NULL),(1173,2,1753854998,'auth_db','setupsql','',NULL),(1174,2,1753854998,'auth_db','debugauthdb','0',NULL),(1175,2,1753854998,'auth_db','changepasswordurl','',NULL),(1176,2,1753854998,'auth_db','removeuser','0',NULL),(1177,2,1753854998,'auth_db','updateusers','0',NULL),(1178,2,1753854998,'auth_db','field_map_firstname','',NULL),(1179,2,1753854998,'auth_db','field_updatelocal_firstname','oncreate',NULL),(1180,2,1753854998,'auth_db','field_updateremote_firstname','0',NULL),(1181,2,1753854998,'auth_db','field_lock_firstname','unlocked',NULL),(1182,2,1753854998,'auth_db','field_map_lastname','',NULL),(1183,2,1753854998,'auth_db','field_updatelocal_lastname','oncreate',NULL),(1184,2,1753854998,'auth_db','field_updateremote_lastname','0',NULL),(1185,2,1753854998,'auth_db','field_lock_lastname','unlocked',NULL),(1186,2,1753854998,'auth_db','field_map_email','',NULL),(1187,2,1753854998,'auth_db','field_updatelocal_email','oncreate',NULL),(1188,2,1753854998,'auth_db','field_updateremote_email','0',NULL),(1189,2,1753854998,'auth_db','field_lock_email','unlocked',NULL),(1190,2,1753854998,'auth_db','field_map_city','',NULL),(1191,2,1753854998,'auth_db','field_updatelocal_city','oncreate',NULL),(1192,2,1753854998,'auth_db','field_updateremote_city','0',NULL),(1193,2,1753854998,'auth_db','field_lock_city','unlocked',NULL),(1194,2,1753854998,'auth_db','field_map_country','',NULL),(1195,2,1753854998,'auth_db','field_updatelocal_country','oncreate',NULL),(1196,2,1753854998,'auth_db','field_updateremote_country','0',NULL),(1197,2,1753854998,'auth_db','field_lock_country','unlocked',NULL),(1198,2,1753854998,'auth_db','field_map_lang','',NULL),(1199,2,1753854998,'auth_db','field_updatelocal_lang','oncreate',NULL),(1200,2,1753854998,'auth_db','field_updateremote_lang','0',NULL),(1201,2,1753854998,'auth_db','field_lock_lang','unlocked',NULL),(1202,2,1753854998,'auth_db','field_map_description','',NULL),(1203,2,1753854998,'auth_db','field_updatelocal_description','oncreate',NULL),(1204,2,1753854998,'auth_db','field_updateremote_description','0',NULL),(1205,2,1753854998,'auth_db','field_lock_description','unlocked',NULL),(1206,2,1753854998,'auth_db','field_map_idnumber','',NULL),(1207,2,1753854998,'auth_db','field_updatelocal_idnumber','oncreate',NULL),(1208,2,1753854998,'auth_db','field_updateremote_idnumber','0',NULL),(1209,2,1753854998,'auth_db','field_lock_idnumber','unlocked',NULL),(1210,2,1753854998,'auth_db','field_map_institution','',NULL),(1211,2,1753854998,'auth_db','field_updatelocal_institution','oncreate',NULL),(1212,2,1753854998,'auth_db','field_updateremote_institution','0',NULL),(1213,2,1753854998,'auth_db','field_lock_institution','unlocked',NULL),(1214,2,1753854998,'auth_db','field_map_department','',NULL),(1215,2,1753854998,'auth_db','field_updatelocal_department','oncreate',NULL),(1216,2,1753854998,'auth_db','field_updateremote_department','0',NULL),(1217,2,1753854998,'auth_db','field_lock_department','unlocked',NULL),(1218,2,1753854998,'auth_db','field_map_phone1','',NULL),(1219,2,1753854998,'auth_db','field_updatelocal_phone1','oncreate',NULL),(1220,2,1753854998,'auth_db','field_updateremote_phone1','0',NULL),(1221,2,1753854998,'auth_db','field_lock_phone1','unlocked',NULL),(1222,2,1753854998,'auth_db','field_map_phone2','',NULL),(1223,2,1753854998,'auth_db','field_updatelocal_phone2','oncreate',NULL),(1224,2,1753854998,'auth_db','field_updateremote_phone2','0',NULL),(1225,2,1753854998,'auth_db','field_lock_phone2','unlocked',NULL),(1226,2,1753854998,'auth_db','field_map_address','',NULL),(1227,2,1753854998,'auth_db','field_updatelocal_address','oncreate',NULL),(1228,2,1753854999,'auth_db','field_updateremote_address','0',NULL),(1229,2,1753854999,'auth_db','field_lock_address','unlocked',NULL),(1230,2,1753854999,'auth_db','field_map_firstnamephonetic','',NULL),(1231,2,1753854999,'auth_db','field_updatelocal_firstnamephonetic','oncreate',NULL),(1232,2,1753854999,'auth_db','field_updateremote_firstnamephonetic','0',NULL),(1233,2,1753854999,'auth_db','field_lock_firstnamephonetic','unlocked',NULL),(1234,2,1753854999,'auth_db','field_map_lastnamephonetic','',NULL),(1235,2,1753854999,'auth_db','field_updatelocal_lastnamephonetic','oncreate',NULL),(1236,2,1753854999,'auth_db','field_updateremote_lastnamephonetic','0',NULL),(1237,2,1753854999,'auth_db','field_lock_lastnamephonetic','unlocked',NULL),(1238,2,1753854999,'auth_db','field_map_middlename','',NULL),(1239,2,1753854999,'auth_db','field_updatelocal_middlename','oncreate',NULL),(1240,2,1753854999,'auth_db','field_updateremote_middlename','0',NULL),(1241,2,1753854999,'auth_db','field_lock_middlename','unlocked',NULL),(1242,2,1753854999,'auth_db','field_map_alternatename','',NULL),(1243,2,1753854999,'auth_db','field_updatelocal_alternatename','oncreate',NULL),(1244,2,1753854999,'auth_db','field_updateremote_alternatename','0',NULL),(1245,2,1753854999,'auth_db','field_lock_alternatename','unlocked',NULL),(1246,2,1753854999,'auth_ldap','field_map_firstname','',NULL),(1247,2,1753854999,'auth_ldap','field_updatelocal_firstname','oncreate',NULL),(1248,2,1753854999,'auth_ldap','field_updateremote_firstname','0',NULL),(1249,2,1753854999,'auth_ldap','field_lock_firstname','unlocked',NULL),(1250,2,1753854999,'auth_ldap','field_map_lastname','',NULL),(1251,2,1753854999,'auth_ldap','field_updatelocal_lastname','oncreate',NULL),(1252,2,1753854999,'auth_ldap','field_updateremote_lastname','0',NULL),(1253,2,1753854999,'auth_ldap','field_lock_lastname','unlocked',NULL),(1254,2,1753854999,'auth_ldap','field_map_email','',NULL),(1255,2,1753854999,'auth_ldap','field_updatelocal_email','oncreate',NULL),(1256,2,1753854999,'auth_ldap','field_updateremote_email','0',NULL),(1257,2,1753854999,'auth_ldap','field_lock_email','unlocked',NULL),(1258,2,1753854999,'auth_ldap','field_map_city','',NULL),(1259,2,1753854999,'auth_ldap','field_updatelocal_city','oncreate',NULL),(1260,2,1753854999,'auth_ldap','field_updateremote_city','0',NULL),(1261,2,1753854999,'auth_ldap','field_lock_city','unlocked',NULL),(1262,2,1753854999,'auth_ldap','field_map_country','',NULL),(1263,2,1753854999,'auth_ldap','field_updatelocal_country','oncreate',NULL),(1264,2,1753854999,'auth_ldap','field_updateremote_country','0',NULL),(1265,2,1753854999,'auth_ldap','field_lock_country','unlocked',NULL),(1266,2,1753854999,'auth_ldap','field_map_lang','',NULL),(1267,2,1753854999,'auth_ldap','field_updatelocal_lang','oncreate',NULL),(1268,2,1753854999,'auth_ldap','field_updateremote_lang','0',NULL),(1269,2,1753854999,'auth_ldap','field_lock_lang','unlocked',NULL),(1270,2,1753854999,'auth_ldap','field_map_description','',NULL),(1271,2,1753854999,'auth_ldap','field_updatelocal_description','oncreate',NULL),(1272,2,1753854999,'auth_ldap','field_updateremote_description','0',NULL),(1273,2,1753854999,'auth_ldap','field_lock_description','unlocked',NULL),(1274,2,1753854999,'auth_ldap','field_map_idnumber','',NULL),(1275,2,1753854999,'auth_ldap','field_updatelocal_idnumber','oncreate',NULL),(1276,2,1753854999,'auth_ldap','field_updateremote_idnumber','0',NULL),(1277,2,1753854999,'auth_ldap','field_lock_idnumber','unlocked',NULL),(1278,2,1753854999,'auth_ldap','field_map_institution','',NULL),(1279,2,1753854999,'auth_ldap','field_updatelocal_institution','oncreate',NULL),(1280,2,1753854999,'auth_ldap','field_updateremote_institution','0',NULL),(1281,2,1753854999,'auth_ldap','field_lock_institution','unlocked',NULL),(1282,2,1753854999,'auth_ldap','field_map_department','',NULL),(1283,2,1753854999,'auth_ldap','field_updatelocal_department','oncreate',NULL),(1284,2,1753854999,'auth_ldap','field_updateremote_department','0',NULL),(1285,2,1753854999,'auth_ldap','field_lock_department','unlocked',NULL),(1286,2,1753854999,'auth_ldap','field_map_phone1','',NULL),(1287,2,1753854999,'auth_ldap','field_updatelocal_phone1','oncreate',NULL),(1288,2,1753854999,'auth_ldap','field_updateremote_phone1','0',NULL),(1289,2,1753854999,'auth_ldap','field_lock_phone1','unlocked',NULL),(1290,2,1753854999,'auth_ldap','field_map_phone2','',NULL),(1291,2,1753854999,'auth_ldap','field_updatelocal_phone2','oncreate',NULL),(1292,2,1753854999,'auth_ldap','field_updateremote_phone2','0',NULL),(1293,2,1753854999,'auth_ldap','field_lock_phone2','unlocked',NULL),(1294,2,1753854999,'auth_ldap','field_map_address','',NULL),(1295,2,1753854999,'auth_ldap','field_updatelocal_address','oncreate',NULL),(1296,2,1753854999,'auth_ldap','field_updateremote_address','0',NULL),(1297,2,1753854999,'auth_ldap','field_lock_address','unlocked',NULL),(1298,2,1753854999,'auth_ldap','field_map_firstnamephonetic','',NULL),(1299,2,1753854999,'auth_ldap','field_updatelocal_firstnamephonetic','oncreate',NULL),(1300,2,1753855000,'auth_ldap','field_updateremote_firstnamephonetic','0',NULL),(1301,2,1753855000,'auth_ldap','field_lock_firstnamephonetic','unlocked',NULL),(1302,2,1753855000,'auth_ldap','field_map_lastnamephonetic','',NULL),(1303,2,1753855000,'auth_ldap','field_updatelocal_lastnamephonetic','oncreate',NULL),(1304,2,1753855000,'auth_ldap','field_updateremote_lastnamephonetic','0',NULL),(1305,2,1753855000,'auth_ldap','field_lock_lastnamephonetic','unlocked',NULL),(1306,2,1753855000,'auth_ldap','field_map_middlename','',NULL),(1307,2,1753855000,'auth_ldap','field_updatelocal_middlename','oncreate',NULL),(1308,2,1753855000,'auth_ldap','field_updateremote_middlename','0',NULL),(1309,2,1753855000,'auth_ldap','field_lock_middlename','unlocked',NULL),(1310,2,1753855000,'auth_ldap','field_map_alternatename','',NULL),(1311,2,1753855000,'auth_ldap','field_updatelocal_alternatename','oncreate',NULL),(1312,2,1753855000,'auth_ldap','field_updateremote_alternatename','0',NULL),(1313,2,1753855000,'auth_ldap','field_lock_alternatename','unlocked',NULL),(1314,2,1753855000,'auth_manual','expiration','0',NULL),(1315,2,1753855000,'auth_manual','expirationtime','30',NULL),(1316,2,1753855000,'auth_manual','expiration_warning','0',NULL),(1317,2,1753855000,'auth_manual','field_lock_firstname','unlocked',NULL),(1318,2,1753855000,'auth_manual','field_lock_lastname','unlocked',NULL),(1319,2,1753855000,'auth_manual','field_lock_email','unlocked',NULL),(1320,2,1753855000,'auth_manual','field_lock_city','unlocked',NULL),(1321,2,1753855000,'auth_manual','field_lock_country','unlocked',NULL),(1322,2,1753855000,'auth_manual','field_lock_lang','unlocked',NULL),(1323,2,1753855000,'auth_manual','field_lock_description','unlocked',NULL),(1324,2,1753855000,'auth_manual','field_lock_idnumber','unlocked',NULL),(1325,2,1753855000,'auth_manual','field_lock_institution','unlocked',NULL),(1326,2,1753855000,'auth_manual','field_lock_department','unlocked',NULL),(1327,2,1753855000,'auth_manual','field_lock_phone1','unlocked',NULL),(1328,2,1753855000,'auth_manual','field_lock_phone2','unlocked',NULL),(1329,2,1753855000,'auth_manual','field_lock_address','unlocked',NULL),(1330,2,1753855000,'auth_manual','field_lock_firstnamephonetic','unlocked',NULL),(1331,2,1753855000,'auth_manual','field_lock_lastnamephonetic','unlocked',NULL),(1332,2,1753855000,'auth_manual','field_lock_middlename','unlocked',NULL),(1333,2,1753855000,'auth_manual','field_lock_alternatename','unlocked',NULL),(1334,2,1753855000,'auth_mnet','rpc_negotiation_timeout','30',NULL),(1335,2,1753855000,'auth_none','field_lock_firstname','unlocked',NULL),(1336,2,1753855000,'auth_none','field_lock_lastname','unlocked',NULL),(1337,2,1753855000,'auth_none','field_lock_email','unlocked',NULL),(1338,2,1753855000,'auth_none','field_lock_city','unlocked',NULL),(1339,2,1753855000,'auth_none','field_lock_country','unlocked',NULL),(1340,2,1753855000,'auth_none','field_lock_lang','unlocked',NULL),(1341,2,1753855000,'auth_none','field_lock_description','unlocked',NULL),(1342,2,1753855000,'auth_none','field_lock_idnumber','unlocked',NULL),(1343,2,1753855000,'auth_none','field_lock_institution','unlocked',NULL),(1344,2,1753855000,'auth_none','field_lock_department','unlocked',NULL),(1345,2,1753855000,'auth_none','field_lock_phone1','unlocked',NULL),(1346,2,1753855000,'auth_none','field_lock_phone2','unlocked',NULL),(1347,2,1753855000,'auth_none','field_lock_address','unlocked',NULL),(1348,2,1753855000,'auth_none','field_lock_firstnamephonetic','unlocked',NULL),(1349,2,1753855000,'auth_none','field_lock_lastnamephonetic','unlocked',NULL),(1350,2,1753855000,'auth_none','field_lock_middlename','unlocked',NULL),(1351,2,1753855000,'auth_none','field_lock_alternatename','unlocked',NULL),(1352,2,1753855000,'auth_oauth2','field_lock_firstname','unlocked',NULL),(1353,2,1753855000,'auth_oauth2','field_lock_lastname','unlocked',NULL),(1354,2,1753855000,'auth_oauth2','field_lock_email','unlocked',NULL),(1355,2,1753855000,'auth_oauth2','field_lock_city','unlocked',NULL),(1356,2,1753855000,'auth_oauth2','field_lock_country','unlocked',NULL),(1357,2,1753855000,'auth_oauth2','field_lock_lang','unlocked',NULL),(1358,2,1753855000,'auth_oauth2','field_lock_description','unlocked',NULL),(1359,2,1753855000,'auth_oauth2','field_lock_idnumber','unlocked',NULL),(1360,2,1753855000,'auth_oauth2','field_lock_institution','unlocked',NULL),(1361,2,1753855000,'auth_oauth2','field_lock_department','unlocked',NULL),(1362,2,1753855000,'auth_oauth2','field_lock_phone1','unlocked',NULL),(1363,2,1753855000,'auth_oauth2','field_lock_phone2','unlocked',NULL),(1364,2,1753855000,'auth_oauth2','field_lock_address','unlocked',NULL),(1365,2,1753855000,'auth_oauth2','field_lock_firstnamephonetic','unlocked',NULL),(1366,2,1753855000,'auth_oauth2','field_lock_lastnamephonetic','unlocked',NULL),(1367,2,1753855000,'auth_oauth2','field_lock_middlename','unlocked',NULL),(1368,2,1753855000,'auth_oauth2','field_lock_alternatename','unlocked',NULL),(1369,2,1753855000,'auth_shibboleth','user_attribute','',NULL),(1370,2,1753855000,'auth_shibboleth','convert_data','',NULL),(1371,2,1753855000,'auth_shibboleth','alt_login','off',NULL),(1372,2,1753855001,'auth_shibboleth','organization_selection','urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai',NULL),(1373,2,1753855001,'auth_shibboleth','logout_handler','',NULL),(1374,2,1753855001,'auth_shibboleth','logout_return_url','',NULL),(1375,2,1753855001,'auth_shibboleth','login_name','Shibboleth Login',NULL),(1376,2,1753855001,'auth_shibboleth','auth_logo','',NULL),(1377,2,1753855001,'auth_shibboleth','auth_instructions','Use the <a href=\"https://lms.techgigs.in/Trainocate/auth/shibboleth/index.php\">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.',NULL),(1378,2,1753855001,'auth_shibboleth','changepasswordurl','',NULL),(1379,2,1753855001,'auth_shibboleth','field_map_firstname','',NULL),(1380,2,1753855001,'auth_shibboleth','field_updatelocal_firstname','oncreate',NULL),(1381,2,1753855001,'auth_shibboleth','field_lock_firstname','unlocked',NULL),(1382,2,1753855001,'auth_shibboleth','field_map_lastname','',NULL),(1383,2,1753855001,'auth_shibboleth','field_updatelocal_lastname','oncreate',NULL),(1384,2,1753855001,'auth_shibboleth','field_lock_lastname','unlocked',NULL),(1385,2,1753855001,'auth_shibboleth','field_map_email','',NULL),(1386,2,1753855001,'auth_shibboleth','field_updatelocal_email','oncreate',NULL),(1387,2,1753855001,'auth_shibboleth','field_lock_email','unlocked',NULL),(1388,2,1753855001,'auth_shibboleth','field_map_city','',NULL),(1389,2,1753855001,'auth_shibboleth','field_updatelocal_city','oncreate',NULL),(1390,2,1753855001,'auth_shibboleth','field_lock_city','unlocked',NULL),(1391,2,1753855001,'auth_shibboleth','field_map_country','',NULL),(1392,2,1753855001,'auth_shibboleth','field_updatelocal_country','oncreate',NULL),(1393,2,1753855001,'auth_shibboleth','field_lock_country','unlocked',NULL),(1394,2,1753855001,'auth_shibboleth','field_map_lang','',NULL),(1395,2,1753855001,'auth_shibboleth','field_updatelocal_lang','oncreate',NULL),(1396,2,1753855001,'auth_shibboleth','field_lock_lang','unlocked',NULL),(1397,2,1753855001,'auth_shibboleth','field_map_description','',NULL),(1398,2,1753855001,'auth_shibboleth','field_updatelocal_description','oncreate',NULL),(1399,2,1753855001,'auth_shibboleth','field_lock_description','unlocked',NULL),(1400,2,1753855001,'auth_shibboleth','field_map_idnumber','',NULL),(1401,2,1753855001,'auth_shibboleth','field_updatelocal_idnumber','oncreate',NULL),(1402,2,1753855001,'auth_shibboleth','field_lock_idnumber','unlocked',NULL),(1403,2,1753855001,'auth_shibboleth','field_map_institution','',NULL),(1404,2,1753855001,'auth_shibboleth','field_updatelocal_institution','oncreate',NULL),(1405,2,1753855001,'auth_shibboleth','field_lock_institution','unlocked',NULL),(1406,2,1753855001,'auth_shibboleth','field_map_department','',NULL),(1407,2,1753855001,'auth_shibboleth','field_updatelocal_department','oncreate',NULL),(1408,2,1753855001,'auth_shibboleth','field_lock_department','unlocked',NULL),(1409,2,1753855001,'auth_shibboleth','field_map_phone1','',NULL),(1410,2,1753855001,'auth_shibboleth','field_updatelocal_phone1','oncreate',NULL),(1411,2,1753855001,'auth_shibboleth','field_lock_phone1','unlocked',NULL),(1412,2,1753855001,'auth_shibboleth','field_map_phone2','',NULL),(1413,2,1753855001,'auth_shibboleth','field_updatelocal_phone2','oncreate',NULL),(1414,2,1753855001,'auth_shibboleth','field_lock_phone2','unlocked',NULL),(1415,2,1753855001,'auth_shibboleth','field_map_address','',NULL),(1416,2,1753855001,'auth_shibboleth','field_updatelocal_address','oncreate',NULL),(1417,2,1753855001,'auth_shibboleth','field_lock_address','unlocked',NULL),(1418,2,1753855001,'auth_shibboleth','field_map_firstnamephonetic','',NULL),(1419,2,1753855001,'auth_shibboleth','field_updatelocal_firstnamephonetic','oncreate',NULL),(1420,2,1753855001,'auth_shibboleth','field_lock_firstnamephonetic','unlocked',NULL),(1421,2,1753855001,'auth_shibboleth','field_map_lastnamephonetic','',NULL),(1422,2,1753855001,'auth_shibboleth','field_updatelocal_lastnamephonetic','oncreate',NULL),(1423,2,1753855001,'auth_shibboleth','field_lock_lastnamephonetic','unlocked',NULL),(1424,2,1753855001,'auth_shibboleth','field_map_middlename','',NULL),(1425,2,1753855001,'auth_shibboleth','field_updatelocal_middlename','oncreate',NULL),(1426,2,1753855001,'auth_shibboleth','field_lock_middlename','unlocked',NULL),(1427,2,1753855001,'auth_shibboleth','field_map_alternatename','',NULL),(1428,2,1753855001,'auth_shibboleth','field_updatelocal_alternatename','oncreate',NULL),(1429,2,1753855001,'auth_shibboleth','field_lock_alternatename','unlocked',NULL),(1430,2,1753855001,'block_accessreview','whattoshow','showboth',NULL),(1431,2,1753855001,'block_accessreview','errordisplay','showint',NULL),(1432,2,1753855001,'block_accessreview','toolpage','errors',NULL),(1433,2,1753855001,'block_activity_results','config_showbest','3',NULL),(1434,2,1753855001,'block_activity_results','config_showbest_locked','',NULL),(1435,2,1753855001,'block_activity_results','config_showworst','0',NULL),(1436,2,1753855001,'block_activity_results','config_showworst_locked','',NULL),(1437,2,1753855001,'block_activity_results','config_usegroups','0',NULL),(1438,2,1753855001,'block_activity_results','config_usegroups_locked','',NULL),(1439,2,1753855001,'block_activity_results','config_nameformat','1',NULL),(1440,2,1753855001,'block_activity_results','config_nameformat_locked','',NULL),(1441,2,1753855001,'block_activity_results','config_gradeformat','1',NULL),(1442,2,1753855001,'block_activity_results','config_gradeformat_locked','',NULL),(1443,2,1753855002,'block_activity_results','config_decimalpoints','2',NULL),(1444,2,1753855002,'block_activity_results','config_decimalpoints_locked','',NULL),(1445,2,1753855002,'block_myoverview','displaycategories','1',NULL),(1446,2,1753855002,'block_myoverview','layouts','card,list,summary',NULL),(1447,2,1753855002,'block_myoverview','displaygroupingallincludinghidden','0',NULL),(1448,2,1753855002,'block_myoverview','displaygroupingall','1',NULL),(1449,2,1753855002,'block_myoverview','displaygroupinginprogress','1',NULL),(1450,2,1753855002,'block_myoverview','displaygroupingpast','1',NULL),(1451,2,1753855002,'block_myoverview','displaygroupingfuture','1',NULL),(1452,2,1753855002,'block_myoverview','displaygroupingcustomfield','0',NULL),(1453,2,1753855002,'block_myoverview','customfiltergrouping','',NULL),(1454,2,1753855002,'block_myoverview','displaygroupingfavourites','1',NULL),(1455,2,1753855002,'block_myoverview','displaygroupinghidden','1',NULL),(1456,2,1753855002,NULL,'block_course_list_adminview','all',NULL),(1457,2,1753855002,NULL,'block_course_list_hideallcourseslink','0',NULL),(1458,2,1753855002,NULL,'block_online_users_timetosee','5',NULL),(1459,2,1753855002,NULL,'block_online_users_onlinestatushiding','1',NULL),(1460,2,1753855002,'block_recentlyaccessedcourses','displaycategories','1',NULL),(1461,2,1753855002,NULL,'block_rss_client_num_entries','5',NULL),(1462,2,1753855002,NULL,'block_rss_client_timeout','30',NULL),(1463,2,1753855002,'block_section_links','numsections1','22',NULL),(1464,2,1753855002,'block_section_links','incby1','2',NULL),(1465,2,1753855002,'block_section_links','numsections2','40',NULL),(1466,2,1753855002,'block_section_links','incby2','5',NULL),(1467,2,1753855002,'block_section_links','showsectionname','0',NULL),(1468,2,1753855002,'block_starredcourses','displaycategories','1',NULL),(1469,2,1753855002,NULL,'block_html_allowcssclasses','0',NULL),(1470,2,1753855002,'block_tag_youtube','apikey','',NULL),(1471,2,1753855002,'format_singleactivity','activitytype','forum',NULL),(1472,2,1753855002,'format_topics','indentation','1',NULL),(1473,2,1753855002,'format_weeks','indentation','1',NULL),(1474,2,1753855002,'fileconverter_googledrive','issuerid','',NULL),(1475,2,1753855002,NULL,'pathtounoconv','/usr/bin/unoconv',NULL),(1476,2,1753855002,'enrol_cohort','roleid','5',NULL),(1477,2,1753855002,'enrol_cohort','unenrolaction','0',NULL),(1478,2,1753855002,'enrol_meta','nosyncroleids','',NULL),(1479,2,1753855002,'enrol_meta','syncall','1',NULL),(1480,2,1753855002,'enrol_meta','unenrolaction','3',NULL),(1481,2,1753855002,'enrol_meta','coursesort','sortorder',NULL),(1482,2,1753855002,'enrol_fee','expiredaction','3',NULL),(1483,2,1753855002,'enrol_fee','status','1',NULL),(1484,2,1753855002,'enrol_fee','cost','0',NULL),(1485,2,1753855002,'enrol_fee','currency','USD',NULL),(1486,2,1753855002,'enrol_fee','roleid','5',NULL),(1487,2,1753855002,'enrol_fee','enrolperiod','0',NULL),(1488,2,1753855002,'enrol_database','dbtype','',NULL),(1489,2,1753855002,'enrol_database','dbhost','localhost',NULL),(1490,2,1753855002,'enrol_database','dbuser','',NULL),(1491,2,1753855002,'enrol_database','dbpass','',NULL),(1492,2,1753855002,'enrol_database','dbname','',NULL),(1493,2,1753855002,'enrol_database','dbencoding','utf-8',NULL),(1494,2,1753855002,'enrol_database','dbsetupsql','',NULL),(1495,2,1753855002,'enrol_database','dbsybasequoting','0',NULL),(1496,2,1753855002,'enrol_database','debugdb','0',NULL),(1497,2,1753855002,'enrol_database','localcoursefield','idnumber',NULL),(1498,2,1753855002,'enrol_database','localuserfield','idnumber',NULL),(1499,2,1753855002,'enrol_database','localrolefield','shortname',NULL),(1500,2,1753855002,'enrol_database','localcategoryfield','id',NULL),(1501,2,1753855002,'enrol_database','remoteenroltable','',NULL),(1502,2,1753855002,'enrol_database','remotecoursefield','',NULL),(1503,2,1753855002,'enrol_database','remoteuserfield','',NULL),(1504,2,1753855002,'enrol_database','remoterolefield','',NULL),(1505,2,1753855002,'enrol_database','remoteotheruserfield','',NULL),(1506,2,1753855002,'enrol_database','defaultrole','5',NULL),(1507,2,1753855002,'enrol_database','ignorehiddencourses','0',NULL),(1508,2,1753855002,'enrol_database','unenrolaction','0',NULL),(1509,2,1753855002,'enrol_database','newcoursetable','',NULL),(1510,2,1753855002,'enrol_database','newcoursefullname','fullname',NULL),(1511,2,1753855003,'enrol_database','newcourseshortname','shortname',NULL),(1512,2,1753855003,'enrol_database','newcourseidnumber','idnumber',NULL),(1513,2,1753855003,'enrol_database','newcoursecategory','',NULL),(1514,2,1753855003,'enrol_database','defaultcategory','1',NULL),(1515,2,1753855003,'enrol_database','templatecourse','',NULL),(1516,2,1753855003,'enrol_flatfile','location','',NULL),(1517,2,1753855003,'enrol_flatfile','encoding','UTF-8',NULL),(1518,2,1753855003,'enrol_flatfile','mailstudents','0',NULL),(1519,2,1753855003,'enrol_flatfile','mailteachers','0',NULL),(1520,2,1753855003,'enrol_flatfile','mailadmins','0',NULL),(1521,2,1753855003,'enrol_flatfile','unenrolaction','3',NULL),(1522,2,1753855003,'enrol_flatfile','expiredaction','3',NULL),(1523,2,1753855003,'enrol_guest','requirepassword','0',NULL),(1524,2,1753855003,'enrol_guest','usepasswordpolicy','0',NULL),(1525,2,1753855003,'enrol_guest','showhint','0',NULL),(1526,2,1753855003,'enrol_guest','defaultenrol','1',NULL),(1527,2,1753855003,'enrol_guest','status','1',NULL),(1528,2,1753855003,'enrol_guest','status_adv','',NULL),(1529,2,1753855003,'enrol_imsenterprise','imsfilelocation','',NULL),(1530,2,1753855003,'enrol_imsenterprise','logtolocation','',NULL),(1531,2,1753855003,'enrol_imsenterprise','mailadmins','0',NULL),(1532,2,1753855003,'enrol_imsenterprise','createnewusers','0',NULL),(1533,2,1753855003,'enrol_imsenterprise','imsupdateusers','0',NULL),(1534,2,1753855003,'enrol_imsenterprise','imsdeleteusers','0',NULL),(1535,2,1753855003,'enrol_imsenterprise','fixcaseusernames','0',NULL),(1536,2,1753855003,'enrol_imsenterprise','fixcasepersonalnames','0',NULL),(1537,2,1753855003,'enrol_imsenterprise','imssourcedidfallback','0',NULL),(1538,2,1753855003,'enrol_imsenterprise','imsrolemap01','5',NULL),(1539,2,1753855003,'enrol_imsenterprise','imsrolemap02','3',NULL),(1540,2,1753855003,'enrol_imsenterprise','imsrolemap03','3',NULL),(1541,2,1753855003,'enrol_imsenterprise','imsrolemap04','5',NULL),(1542,2,1753855003,'enrol_imsenterprise','imsrolemap05','0',NULL),(1543,2,1753855003,'enrol_imsenterprise','imsrolemap06','4',NULL),(1544,2,1753855003,'enrol_imsenterprise','imsrolemap07','0',NULL),(1545,2,1753855003,'enrol_imsenterprise','imsrolemap08','4',NULL),(1546,2,1753855003,'enrol_imsenterprise','truncatecoursecodes','0',NULL),(1547,2,1753855003,'enrol_imsenterprise','createnewcourses','0',NULL),(1548,2,1753855003,'enrol_imsenterprise','updatecourses','0',NULL),(1549,2,1753855003,'enrol_imsenterprise','createnewcategories','0',NULL),(1550,2,1753855003,'enrol_imsenterprise','nestedcategories','0',NULL),(1551,2,1753855003,'enrol_imsenterprise','categoryidnumber','0',NULL),(1552,2,1753855003,'enrol_imsenterprise','categoryseparator','',NULL),(1553,2,1753855003,'enrol_imsenterprise','imsunenrol','0',NULL),(1554,2,1753855003,'enrol_imsenterprise','imscoursemapshortname','coursecode',NULL),(1555,2,1753855003,'enrol_imsenterprise','imscoursemapfullname','short',NULL),(1556,2,1753855003,'enrol_imsenterprise','imscoursemapsummary','ignore',NULL),(1557,2,1753855003,'enrol_imsenterprise','imsrestricttarget','',NULL),(1558,2,1753855003,'enrol_imsenterprise','imscapitafix','0',NULL),(1559,2,1753855003,'enrol_manual','expiredaction','1',NULL),(1560,2,1753855003,'enrol_manual','expirynotifyhour','6',NULL),(1561,2,1753855003,'enrol_manual','defaultenrol','1',NULL),(1562,2,1753855003,'enrol_manual','status','0',NULL),(1563,2,1753855003,'enrol_manual','roleid','5',NULL),(1564,2,1753855003,'enrol_manual','enrolstart','4',NULL),(1565,2,1753855003,'enrol_manual','enrolperiod','0',NULL),(1566,2,1753855003,'enrol_manual','expirynotify','0',NULL),(1567,2,1753855003,'enrol_manual','expirythreshold','86400',NULL),(1568,2,1753855003,'enrol_mnet','roleid','5',NULL),(1569,2,1753855003,'enrol_mnet','roleid_adv','1',NULL),(1570,2,1753855003,'enrol_paypal','paypalbusiness','',NULL),(1571,2,1753855003,'enrol_paypal','mailstudents','0',NULL),(1572,2,1753855003,'enrol_paypal','mailteachers','0',NULL),(1573,2,1753855003,'enrol_paypal','mailadmins','0',NULL),(1574,2,1753855003,'enrol_paypal','expiredaction','3',NULL),(1575,2,1753855003,'enrol_paypal','status','1',NULL),(1576,2,1753855003,'enrol_paypal','cost','0',NULL),(1577,2,1753855003,'enrol_paypal','currency','USD',NULL),(1578,2,1753855003,'enrol_paypal','roleid','5',NULL),(1579,2,1753855003,'enrol_paypal','enrolperiod','0',NULL),(1580,2,1753855003,'enrol_lti','emaildisplay','2',NULL),(1581,2,1753855003,'enrol_lti','city','',NULL),(1582,2,1753855003,'enrol_lti','country','',NULL),(1583,2,1753855004,'enrol_lti','timezone','99',NULL),(1584,2,1753855004,'enrol_lti','lang','en',NULL),(1585,2,1753855004,'enrol_lti','institution','',NULL),(1586,2,1753855004,'enrol_self','requirepassword','0',NULL),(1587,2,1753855004,'enrol_self','usepasswordpolicy','0',NULL),(1588,2,1753855004,'enrol_self','showhint','0',NULL),(1589,2,1753855004,'enrol_self','expiredaction','1',NULL),(1590,2,1753855004,'enrol_self','expirynotifyhour','6',NULL),(1591,2,1753855004,'enrol_self','defaultenrol','1',NULL),(1592,2,1753855004,'enrol_self','status','1',NULL),(1593,2,1753855004,'enrol_self','newenrols','1',NULL),(1594,2,1753855004,'enrol_self','groupkey','0',NULL),(1595,2,1753855004,'enrol_self','roleid','5',NULL),(1596,2,1753855004,'enrol_self','enrolperiod','0',NULL),(1597,2,1753855004,'enrol_self','expirynotify','0',NULL),(1598,2,1753855004,'enrol_self','expirythreshold','86400',NULL),(1599,2,1753855004,'enrol_self','longtimenosee','0',NULL),(1600,2,1753855004,'enrol_self','maxenrolled','0',NULL),(1601,2,1753855004,'enrol_self','sendcoursewelcomemessage','1',NULL),(1602,2,1753855004,'filter_urltolink','formats','1,4,0',NULL),(1603,2,1753855004,'filter_urltolink','embedimages','1',NULL),(1604,2,1753855004,'filter_emoticon','formats','1,4,0',NULL),(1605,2,1753855004,'filter_displayh5p','allowedsources','',NULL),(1606,2,1753855004,'filter_mathjaxloader','httpsurl','https://cdn.jsdelivr.net/npm/mathjax@2.7.9/MathJax.js',NULL),(1607,2,1753855004,'filter_mathjaxloader','texfiltercompatibility','0',NULL),(1608,2,1753855004,'filter_mathjaxloader','mathjaxconfig','\nMathJax.Hub.Config({\n    config: [\"Accessible.js\", \"Safe.js\"],\n    errorSettings: { message: [\"!\"] },\n    skipStartupTypeset: true,\n    messageStyle: \"none\"\n});\n',NULL),(1609,2,1753855004,'filter_mathjaxloader','additionaldelimiters','',NULL),(1610,2,1753855004,NULL,'filter_multilang_force_old','0',NULL),(1611,2,1753855004,'filter_tex','latexpreamble','\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n',NULL),(1612,2,1753855004,'filter_tex','latexbackground','#FFFFFF',NULL),(1613,2,1753855004,'filter_tex','density','120',NULL),(1614,2,1753855004,'filter_tex','pathlatex','/usr/bin/latex',NULL),(1615,2,1753855004,'filter_tex','pathdvips','/usr/bin/dvips',NULL),(1616,2,1753855004,'filter_tex','pathconvert','/usr/bin/convert',NULL),(1617,2,1753855004,'filter_tex','pathdvisvgm','/usr/bin/dvisvgm',NULL),(1618,2,1753855004,'filter_tex','pathmimetex','',NULL),(1619,2,1753855004,'filter_tex','convertformat','gif',NULL),(1620,2,1753855004,'logstore_database','dbdriver','',NULL),(1621,2,1753855004,'logstore_database','dbhost','',NULL),(1622,2,1753855004,'logstore_database','dbuser','',NULL),(1623,2,1753855004,'logstore_database','dbpass','',NULL),(1624,2,1753855004,'logstore_database','dbname','',NULL),(1625,2,1753855004,'logstore_database','dbtable','',NULL),(1626,2,1753855004,'logstore_database','dbpersist','0',NULL),(1627,2,1753855004,'logstore_database','dbsocket','',NULL),(1628,2,1753855004,'logstore_database','dbport','',NULL),(1629,2,1753855004,'logstore_database','dbschema','',NULL),(1630,2,1753855004,'logstore_database','dbcollation','',NULL),(1631,2,1753855004,'logstore_database','dbhandlesoptions','0',NULL),(1632,2,1753855004,'logstore_database','buffersize','50',NULL),(1633,2,1753855004,'logstore_database','jsonformat','1',NULL),(1634,2,1753855004,'logstore_database','logguests','0',NULL),(1635,2,1753855004,'logstore_database','includelevels','1,2,0',NULL),(1636,2,1753855004,'logstore_database','includeactions','c,r,u,d',NULL),(1637,2,1753855004,'logstore_legacy','loglegacy','0',NULL),(1638,2,1753855004,NULL,'logguests','1',NULL),(1639,2,1753855004,NULL,'loglifetime','0',NULL),(1640,2,1753855004,'logstore_standard','logguests','1',NULL),(1641,2,1753855004,'logstore_standard','jsonformat','1',NULL),(1642,2,1753855004,'logstore_standard','loglifetime','0',NULL),(1643,2,1753855004,'logstore_standard','buffersize','50',NULL),(1644,2,1753855004,'mlbackend_python','useserver','0',NULL),(1645,2,1753855004,'mlbackend_python','host','',NULL),(1646,2,1753855004,'mlbackend_python','port','0',NULL),(1647,2,1753855004,'mlbackend_python','secure','0',NULL),(1648,2,1753855004,'mlbackend_python','username','default',NULL),(1649,2,1753855004,'mlbackend_python','password','',NULL),(1650,2,1753855004,'media_videojs','videoextensions','html_video,media_source,.f4v,.flv',NULL),(1651,2,1753855004,'media_videojs','audioextensions','html_audio',NULL),(1652,2,1753855004,'media_videojs','youtube','1',NULL),(1653,2,1753855004,'media_videojs','videocssclass','video-js',NULL),(1654,2,1753855004,'media_videojs','audiocssclass','video-js',NULL),(1655,2,1753855004,'media_videojs','limitsize','1',NULL),(1656,2,1753855005,'paygw_paypal','surcharge','0',NULL),(1657,2,1753855005,'qtype_multichoice','answerhowmany','1',NULL),(1658,2,1753855005,'qtype_multichoice','shuffleanswers','1',NULL),(1659,2,1753855005,'qtype_multichoice','answernumbering','abc',NULL),(1660,2,1753855005,'editor_atto','toolbar','collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist, indent\nlinks = link\nfiles = emojipicker, image, media, recordrtc, managefiles, h5p\naccessibility = accessibilitychecker, accessibilityhelper\nstyle2 = underline, strike, subscript, superscript\nalign = align\ninsert = equation, charmap, table, clear\nundo = undo\nother = html',NULL),(1661,2,1753855005,'editor_atto','autosavefrequency','60',NULL),(1662,2,1753855005,'atto_collapse','showgroups','6',NULL),(1663,2,1753855005,'atto_equation','librarygroup1','\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n',NULL),(1664,2,1753855005,'atto_equation','librarygroup2','\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n',NULL),(1665,2,1753855005,'atto_equation','librarygroup3','\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n',NULL),(1666,2,1753855005,'atto_equation','librarygroup4','\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\\\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n',NULL),(1667,2,1753855005,'atto_recordrtc','allowedtypes','both',NULL),(1668,2,1753855005,'atto_recordrtc','audiobitrate','128000',NULL),(1669,2,1753855005,'atto_recordrtc','videobitrate','2500000',NULL),(1670,2,1753855005,'atto_recordrtc','audiotimelimit','120',NULL),(1671,2,1753855005,'atto_recordrtc','videotimelimit','120',NULL),(1672,2,1753855005,'atto_table','allowborders','0',NULL),(1673,2,1753855005,'atto_table','allowbackgroundcolour','0',NULL),(1674,2,1753855005,'atto_table','allowwidth','0',NULL),(1675,2,1753855005,'editor_tinymce','customtoolbar','wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen',NULL),(1676,2,1753855005,'editor_tinymce','fontselectlist','Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings',NULL),(1677,2,1753855005,'editor_tinymce','customconfig','',NULL),(1678,2,1753855005,'tinymce_moodleemoticon','requireemoticon','1',NULL),(1679,2,1753855005,'tinymce_spellchecker','spellengine','',NULL),(1680,2,1753855005,'tinymce_spellchecker','spelllanguagelist','+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv',NULL),(1681,2,1753855005,NULL,'profileroles','5,4,3',NULL),(1682,2,1753855005,NULL,'coursecontact','3',NULL),(1683,2,1753855005,NULL,'frontpage','6',NULL),(1684,2,1753855005,NULL,'frontpageloggedin','6',NULL),(1685,2,1753855005,NULL,'maxcategorydepth','2',NULL),(1686,2,1753855005,NULL,'frontpagecourselimit','200',NULL),(1687,2,1753855005,NULL,'commentsperpage','15',NULL),(1688,2,1753855005,NULL,'defaultfrontpageroleid','8',NULL),(1689,2,1753855005,NULL,'messageinbound_enabled','0',NULL),(1690,2,1753855005,NULL,'messageinbound_mailbox','',NULL),(1691,2,1753855005,NULL,'messageinbound_domain','',NULL),(1692,2,1753855005,NULL,'messageinbound_host','',NULL),(1693,2,1753855005,NULL,'messageinbound_hostssl','ssl',NULL),(1694,2,1753855005,NULL,'messageinbound_hostuser','',NULL),(1695,2,1753855005,NULL,'messageinbound_hostpass','',NULL),(1696,2,1753855005,'tool_mobile','apppolicy','',NULL),(1697,2,1753855005,'tool_mobile','typeoflogin','1',NULL),(1698,2,1753855005,'tool_mobile','qrcodetype','2',NULL),(1699,2,1753855005,'tool_mobile','qrkeyttl','600',NULL),(1700,2,1753855005,'tool_mobile','forcedurlscheme','moodlemobile',NULL),(1701,2,1753855005,'tool_mobile','minimumversion','',NULL),(1702,2,1753855005,'tool_mobile','autologinmintimebetweenreq','360',NULL),(1703,2,1753855005,NULL,'mobilecssurl','',NULL),(1704,2,1753855005,'tool_mobile','enablesmartappbanners','0',NULL),(1705,2,1753855005,'tool_mobile','iosappid','633359593',NULL),(1706,2,1753855005,'tool_mobile','androidappid','com.moodle.moodlemobile',NULL),(1707,2,1753855005,'tool_mobile','setuplink','https://download.moodle.org/mobile',NULL),(1708,2,1753855005,'tool_mobile','forcelogout','0',NULL),(1709,2,1753855005,'tool_mobile','disabledfeatures','',NULL),(1710,2,1753855005,'tool_mobile','custommenuitems','',NULL),(1711,2,1753855005,'tool_mobile','filetypeexclusionlist','',NULL),(1712,2,1753855005,'tool_mobile','customlangstrings','',NULL),(1713,2,1753855005,NULL,'enablemobilewebservice','1',NULL),(1714,2,1753855006,'tool_moodlenet','defaultmoodlenetname','MoodleNet Central',NULL),(1715,2,1753855006,'tool_moodlenet','defaultmoodlenet','https://moodle.net',NULL),(1716,2,1753855071,NULL,'timezone','Asia/Kolkata',NULL),(1717,2,1753855071,NULL,'registerauth','',NULL),(1718,2,1753855119,NULL,'supportemail','charmiwebcare@gmail.com',NULL),(1719,2,1753856287,'theme_academi','logo','/logo.png',NULL),(1720,2,1753856287,'theme_academi','favicon','',NULL),(1721,2,1753856288,'theme_academi','primarycolor','',NULL),(1722,2,1753856288,'theme_academi','secondarycolor','',NULL),(1723,2,1753856288,'theme_academi','themestyleheader','1',NULL),(1724,2,1753856288,'theme_academi','pagesize','container',NULL),(1725,2,1753856288,'theme_academi','pagesizecustomval','0',NULL),(1726,2,1753856288,'theme_academi','fontsize','16',NULL),(1727,2,1753856288,'theme_academi','availablecoursetype','1',NULL),(1728,2,1753856288,'theme_academi','comboListboxType','1',NULL),(1729,2,1753856288,'theme_academi','loginbg','',NULL),(1730,2,1753856288,'theme_academi','backToTop_status','1',NULL),(1731,2,1753856288,'theme_academi','customcss','',NULL),(1732,2,1753856288,'theme_academi','preset','default.scss',NULL),(1733,2,1753856288,'theme_academi','presetfiles','',NULL),(1734,2,1753856288,'theme_academi','toggleslideshow','1',NULL),(1735,2,1753856288,'theme_academi','autoslideshow','1',NULL),(1736,2,1753856288,'theme_academi','slideinterval','3500',NULL),(1737,2,1753856288,'theme_academi','slideOverlay','0.4',NULL),(1738,2,1753856288,'theme_academi','numberofslides','3',NULL),(1739,2,1753856288,'theme_academi','pcoursestatus','1',NULL),(1740,2,1753856288,'theme_academi','promotedtitle','lang:promotedtitledefault',NULL),(1741,2,1753856288,'theme_academi','promotedcoursedesc','lang:description_default',NULL),(1742,2,1753856288,'theme_academi','promotedcourses','',NULL),(1743,2,1753856288,'theme_academi','sitefblockstatus','0',NULL),(1744,2,1753856288,'theme_academi','sitefeaturetitle','lang:sitefeaturesdefault',NULL),(1745,2,1753856288,'theme_academi','sitefeaturedesc','lang:description_default',NULL),(1746,2,1753856288,'theme_academi','numberofsitefeature','4',NULL),(1747,2,1753856288,'theme_academi','mspotstatus','0',NULL),(1748,2,1753856288,'theme_academi','mspottitle','lang:aboutus',NULL),(1749,2,1753856288,'theme_academi','mspotdesc','lang:description_default',NULL),(1750,2,1753856288,'theme_academi','mspotcontent','<p> Ipsum in aspernatur ut possimus sint. Quia omnis est occaecati possimus ea. Quas molestiae perspiciatis occaecati qui rerum. Deleniti quod porro sed quisquam saepe. Numquam mollitia recusandae non ad at et a. </p> <p> Ad vitae recusandae odit possimus. Quaerat cum ipsum corrupti. Odit qui asperiores ea corporis deserunt veritatis quidem expedita perferendis. Qui rerum eligendi ex doloribus quia sit. Porro rerum eum eum. </p> <p> Ad vitae recusandae odit possimus. Quaerat cum ipsum corrupti. Odit qui asperiores ea corporis deserunt veritatis quidem expedita perferendis.</p>',NULL),(1751,2,1753856288,'theme_academi','mspotmedia','/mspotmedia.png',NULL),(1752,2,1753856288,'theme_academi','jumbotronstatus','0',NULL),(1753,2,1753856288,'theme_academi','jumbotrontitle','lang:learnanytime',NULL),(1754,2,1753856288,'theme_academi','jumbotrondesc','lang:learnanytimedesc',NULL),(1755,2,1753856288,'theme_academi','jumbotronbtntext','lang:viewallcourses',NULL),(1756,2,1753856288,'theme_academi','jumbotronbtnlink','http://www.example.com/',NULL),(1757,2,1753856288,'theme_academi','jumbotronbtntarget','1',NULL),(1758,2,1753856288,'theme_academi','footerbgimg','',NULL),(1759,2,1753856288,'theme_academi','footerbgOverlay','0.4',NULL),(1760,2,1753856288,'theme_academi','copyright_footer','Copyright &copy; 2017 - Developed by <a href=\"http://lmsace.com\">LMSACE.com</a>. Powered by <a href=\"https://moodle.org\">Moodle</a>',NULL),(1761,2,1753856288,'theme_academi','footerb1_status','1',NULL),(1762,2,1753856288,'theme_academi','footerbtitle1','',NULL),(1763,2,1753856288,'theme_academi','footlogostatus','1',NULL),(1764,2,1753856288,'theme_academi','footerlogo','/footerlogo.png',NULL),(1765,2,1753856288,'theme_academi','footnote','<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and tronic typesetting, sheets taining Lorem Ipsum passages.<br><a href=\"#\">Read More &raquo;</a></p>',NULL),(1766,2,1753856288,'theme_academi','footerb2_status','1',NULL),(1767,2,1753856288,'theme_academi','footerbtitle2','lang:footerbtitle2default',NULL),(1768,2,1753856288,'theme_academi','infolink','Moodle community|https://moodle.org Moodle free\r\nsupport|https://moodle.org/support\r\nMoodle development|https://moodle.org/development\r\nMoodle Docs|http://docs.moodle.org|Moodle Docs\r\nMoodle.com|http://moodle.com/',NULL),(1769,2,1753856288,'theme_academi','footerb3_status','1',NULL),(1770,2,1753856288,'theme_academi','footerbtitle3','lang:footerbtitle3default',NULL),(1771,2,1753856288,'theme_academi','address','308 Negra Narrow Lane, Albeeze, New york, 87104',NULL),(1772,2,1753856288,'theme_academi','emailid','info@example.com',NULL),(1773,2,1753856288,'theme_academi','phoneno','(000) 123-456',NULL),(1774,2,1753856288,'theme_academi','footerb4_status','1',NULL),(1775,2,1753856288,'theme_academi','footerbtitle4','lang:footerbtitle4default',NULL),(1776,2,1753856288,'theme_academi','numofsocialmedia','4',NULL),(1777,2,1753856300,'theme_academi','slide1status','1',NULL),(1778,2,1753856300,'theme_academi','slide1image','/slide1image.jpg',NULL),(1779,2,1753856301,'theme_academi','slide1contentstatus','1',NULL),(1780,2,1753856301,'theme_academi','slide1caption','Bootstrap Based Slider - 01',NULL),(1781,2,1753856301,'theme_academi','slide1desc','Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.',NULL),(1782,2,1753856301,'theme_academi','slide1btntext','lang:knowmore',NULL),(1783,2,1753856301,'theme_academi','slide1btnurl','http://www.example.com/',NULL),(1784,2,1753856301,'theme_academi','slide1btntarget','1',NULL),(1785,2,1753856301,'theme_academi','slide1contFullwidth','50',NULL),(1786,2,1753856301,'theme_academi','slide1contentPosition','centerRight',NULL),(1787,2,1753856301,'theme_academi','slide2status','1',NULL),(1788,2,1753856301,'theme_academi','slide2image','',NULL),(1789,2,1753856301,'theme_academi','slide2contentstatus','1',NULL),(1790,2,1753856301,'theme_academi','slide2caption','Bootstrap Based Slider - 02',NULL),(1791,2,1753856301,'theme_academi','slide2desc','Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.',NULL),(1792,2,1753856301,'theme_academi','slide2btntext','lang:knowmore',NULL),(1793,2,1753856301,'theme_academi','slide2btnurl','http://www.example.com/',NULL),(1794,2,1753856301,'theme_academi','slide2btntarget','1',NULL),(1795,2,1753856301,'theme_academi','slide2contFullwidth','50',NULL),(1796,2,1753856301,'theme_academi','slide2contentPosition','centerRight',NULL),(1797,2,1753856301,'theme_academi','slide3status','1',NULL),(1798,2,1753856301,'theme_academi','slide3image','',NULL),(1799,2,1753856301,'theme_academi','slide3contentstatus','1',NULL),(1800,2,1753856301,'theme_academi','slide3caption','Bootstrap Based Slider - 03',NULL),(1801,2,1753856301,'theme_academi','slide3desc','Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.',NULL),(1802,2,1753856301,'theme_academi','slide3btntext','lang:knowmore',NULL),(1803,2,1753856301,'theme_academi','slide3btnurl','http://www.example.com/',NULL),(1804,2,1753856301,'theme_academi','slide3btntarget','1',NULL),(1805,2,1753856301,'theme_academi','slide3contFullwidth','50',NULL),(1806,2,1753856301,'theme_academi','slide3contentPosition','centerRight',NULL),(1807,2,1753856301,'theme_academi','sitefblock1status','1',NULL),(1808,2,1753856301,'theme_academi','sitefblock1title','lang:sb1_default_title',NULL),(1809,2,1753856301,'theme_academi','sitefblock1content','lang:sb_default_content',NULL),(1810,2,1753856301,'theme_academi','sitefblock1icon','lang:sitefblockicon1_default',NULL),(1811,2,1753856301,'theme_academi','sitefblock2status','1',NULL),(1812,2,1753856301,'theme_academi','sitefblock2title','lang:sb2_default_title',NULL),(1813,2,1753856301,'theme_academi','sitefblock2content','lang:sb_default_content',NULL),(1814,2,1753856301,'theme_academi','sitefblock2icon','lang:sitefblockicon2_default',NULL),(1815,2,1753856301,'theme_academi','sitefblock3status','1',NULL),(1816,2,1753856301,'theme_academi','sitefblock3title','lang:sb3_default_title',NULL),(1817,2,1753856301,'theme_academi','sitefblock3content','lang:sb_default_content',NULL),(1818,2,1753856301,'theme_academi','sitefblock3icon','lang:sitefblockicon3_default',NULL),(1819,2,1753856301,'theme_academi','sitefblock4status','1',NULL),(1820,2,1753856301,'theme_academi','sitefblock4title','lang:sb4_default_title',NULL),(1821,2,1753856301,'theme_academi','sitefblock4content','lang:sb_default_content',NULL),(1822,2,1753856301,'theme_academi','sitefblock4icon','lang:sitefblockicon4_default',NULL),(1823,2,1753856301,'theme_academi','socialmedia1_status','1',NULL),(1824,2,1753856301,'theme_academi','socialmedia1_icon','twitter',NULL),(1825,2,1753856301,'theme_academi','socialmedia1_url','https://twitter.com/yourtwittername',NULL),(1826,2,1753856301,'theme_academi','socialmedia1_iconcolor','#47caf6',NULL),(1827,2,1753856301,'theme_academi','socialmedia2_status','1',NULL),(1828,2,1753856301,'theme_academi','socialmedia2_icon','google-plus',NULL),(1829,2,1753856301,'theme_academi','socialmedia2_url','https://www.google.com/+yourgoogleplusid',NULL),(1830,2,1753856301,'theme_academi','socialmedia2_iconcolor','#e84c3d',NULL),(1831,2,1753856301,'theme_academi','socialmedia3_status','1',NULL),(1832,2,1753856301,'theme_academi','socialmedia3_icon','pinterest-p',NULL),(1833,2,1753856301,'theme_academi','socialmedia3_url','https://in.pinterest.com/yourpinterestname/',NULL),(1834,2,1753856301,'theme_academi','socialmedia3_iconcolor','#cd2129',NULL),(1835,2,1753856301,'theme_academi','socialmedia4_status','1',NULL),(1836,2,1753856301,'theme_academi','socialmedia4_icon','facebook-f',NULL),(1837,2,1753856301,'theme_academi','socialmedia4_url','https://www.facebook.com/yourfacebookid',NULL),(1838,2,1753856301,'theme_academi','socialmedia4_iconcolor','#3598dc',NULL),(1839,2,1753964306,NULL,'guestloginbutton','0','1'),(1840,2,1753964482,NULL,'allowuserblockhiding','0','1'),(1841,2,1753964482,NULL,'customusermenuitems','profile,moodle|/user/profile.php\r\ngrades,grades|/grade/report/mygrades.php\r\ncalendar,core_calendar|/calendar/view.php?view=month\r\nprivatefiles,moodle|/user/files.php\r\nreports,core_reportbuilder|/reportbuilder/index.php','profile,moodle|/user/profile.php\ngrades,grades|/grade/report/mygrades.php\ncalendar,core_calendar|/calendar/view.php?view=month\nprivatefiles,moodle|/user/files.php\nreports,core_reportbuilder|/reportbuilder/index.php'),(1842,2,1753964507,NULL,'allowuserblockhiding','1','0'),(1843,2,1754125241,'theme_academi','footnote','<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and tronic typesetting, sheets taining Lorem Ipsum passages.<br><a href=\"#\">Read More »</a></p>','<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and tronic typesetting, sheets taining Lorem Ipsum passages.<br><a href=\"#\">Read More &raquo;</a></p>'),(1844,2,1754125241,'theme_academi','infolink','community|https://moodle.org Moodle free\r\nsupport|https://moodle.org/support\r\ndevelopment|https://moodle.org/development\r\n Docs|http://docs.moodle.org|Moodle Docs\r\nMoodle.com|http://moodle.com/','Moodle community|https://moodle.org Moodle free\r\nsupport|https://moodle.org/support\r\nMoodle development|https://moodle.org/development\r\nMoodle Docs|http://docs.moodle.org|Moodle Docs\r\nMoodle.com|http://moodle.com/'),(1845,2,1754134483,NULL,'debug','32767','0'),(1846,2,1754134483,NULL,'debugdisplay','1','0'),(1847,2,1754308172,NULL,'cachetemplates','0','1'),(1848,2,1754308281,'theme_academi','primarycolor','#04ACCD',''),(1849,2,1754308281,'theme_academi','secondarycolor','#19DEFA',''),(1850,2,1754308391,'theme_academi','primarycolor','#025F91','#04ACCD'),(1851,2,1754308391,'theme_academi','secondarycolor','#0384AA','#19DEFA'),(1852,2,1754568747,NULL,'additionalhtmlhead','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n</style>\r\n',''),(1853,2,1755000170,'theme_academi','primarycolor','#FF4B00','#025F91'),(1854,2,1755000170,'theme_academi','secondarycolor','#FFAD51','#0384AA'),(1855,2,1755000343,'theme_academi','secondarycolor','#f16521','#FFAD51'),(1856,2,1755681939,NULL,'smtphosts','smtp.gmail.com:465',''),(1857,2,1755681939,NULL,'smtpsecure','ssl',''),(1858,2,1755681939,NULL,'smtpuser','charmiwebcare@gmail.com',''),(1859,2,1755681939,NULL,'smtppass','********',''),(1860,2,1755682595,NULL,'smtphosts','smtp.gmail.com:587','smtp.gmail.com:465'),(1861,2,1755682678,NULL,'smtphosts','smtp.gmail.com:465','smtp.gmail.com:587'),(1862,2,1755757842,NULL,'debug','0','32767'),(1863,2,1755776390,'tool_dataprivacy','dporoles','',NULL),(1864,2,1755778817,'calendar_month','block_visibility','0','1'),(1865,14,1756726188,'local_enrollmentmailer_v2','enableenrollmentmail','0',NULL),(1866,14,1756726188,'local_enrollmentmailer_v2','enrollmentmailsubject','Course Enrollment Notification',NULL),(1867,14,1756726188,'local_enrollmentmailer_v2','enrollmentmailbody','Hello [[user_name]],<br>You have been enrolled in:<br>[[enrollments]]<br><br>Login: [[login_url]]',NULL),(1868,14,1756726188,'local_enrollmentmailer_v2','enableremindermail','0',NULL),(1869,14,1756726188,'local_enrollmentmailer_v2','remindermailsubject','Course Reminder',NULL),(1870,14,1756726188,'local_enrollmentmailer_v2','remindermailbody','Hello [[user_name]],<br>This is a reminder for your courses:<br>[[enrollments]]',NULL),(1871,14,1756726622,'local_enrollmentmailer','enable_enrollment','1',NULL),(1872,14,1756726622,'local_enrollmentmailer','enrollment_subject','',NULL),(1873,14,1756726622,'local_enrollmentmailer','enrollment_body','',NULL),(1874,14,1756726622,'local_enrollmentmailer','enable_reminder','0',NULL),(1875,14,1756726622,'local_enrollmentmailer','reminder_subject','',NULL),(1876,14,1756726622,'local_enrollmentmailer','reminder_body','',NULL),(1877,2,1756808248,'local_enrollmentmailer','enrollment_subject','Welcome to [[enrollments]]',''),(1878,2,1756808248,'local_enrollmentmailer','enrollment_body','<p dir=\"ltr\">Hello [[user_name]],&lt;br&gt;&lt;br&gt;</p><p dir=\"ltr\">You have been successfully enrolled in the course: &lt;b&gt;[[enrollments]]&lt;/b&gt;.&lt;br&gt;</p><p dir=\"ltr\">You can access your course &lt;a href=\"[[course_link]]\"&gt;here&lt;/a&gt;.&lt;br&gt;&lt;br&gt;</p><p dir=\"ltr\">Thank you,&lt;br&gt;</p><p dir=\"ltr\">[[site_name]] Team</p><p><br></p>',''),(1879,2,1756882610,NULL,'smtphosts','smtp.gmail.com:587','smtp.gmail.com:465'),(1880,2,1756882611,NULL,'smtpsecure','tls','ssl'),(1881,2,1756885067,'theme_academi','loginbg','/images (7).jpeg',''),(1882,2,1756885192,'theme_academi','loginbg','/Mountain_GettyImages-516017101.jpg','/images (7).jpeg'),(1883,2,1756896609,NULL,'additionalhtmltopofbody','<script>\r\ndocument.addEventListener(\'DOMContentLoaded\', function () {\r\n    // Get the logged-in user ID from Moodle\'s body data attributes\r\n    let userId = document.body.getAttribute(\'data-userid\');\r\n    \r\n    // If not found, try to fetch from PHP via embedded data\r\n    if (!userId && typeof M !== \"undefined\" && M.cfg && M.cfg.userid) {\r\n        userId = M.cfg.userid;\r\n    }\r\n\r\n    if (userId) {\r\n        // Find the Profile link in the user menu\r\n        const profileLink = document.querySelector(\'a[href*=\"/user/profile.php\"]\');\r\n        if (profileLink) {\r\n            // Change the link to the edit profile page\r\n            profileLink.href = M.cfg.wwwroot + \"/user/edit.php?id=\" + userId + \"&returnto=profile\";\r\n        }\r\n    }\r\n});\r\n</script>\r\n',''),(1884,2,1756896655,NULL,'additionalhtmlhead','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n</style>\r\n<script>\r\ndocument.addEventListener(\'DOMContentLoaded\', function () {\r\n    // Get the logged-in user ID from Moodle\'s body data attributes\r\n    let userId = document.body.getAttribute(\'data-userid\');\r\n    \r\n    // If not found, try to fetch from PHP via embedded data\r\n    if (!userId && typeof M !== \"undefined\" && M.cfg && M.cfg.userid) {\r\n        userId = M.cfg.userid;\r\n    }\r\n\r\n    if (userId) {\r\n        // Find the Profile link in the user menu\r\n        const profileLink = document.querySelector(\'a[href*=\"/user/profile.php\"]\');\r\n        if (profileLink) {\r\n            // Change the link to the edit profile page\r\n            profileLink.href = M.cfg.wwwroot + \"/user/edit.php?id=\" + userId + \"&returnto=profile\";\r\n        }\r\n    }\r\n});\r\n</script>\r\n','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n</style>\r\n'),(1885,2,1756896655,NULL,'additionalhtmltopofbody','','<script>\r\ndocument.addEventListener(\'DOMContentLoaded\', function () {\r\n    // Get the logged-in user ID from Moodle\'s body data attributes\r\n    let userId = document.body.getAttribute(\'data-userid\');\r\n    \r\n    // If not found, try to fetch from PHP via embedded data\r\n    if (!userId && typeof M !== \"undefined\" && M.cfg && M.cfg.userid) {\r\n        userId = M.cfg.userid;\r\n    }\r\n\r\n    if (userId) {\r\n        // Find the Profile link in the user menu\r\n        const profileLink = document.querySelector(\'a[href*=\"/user/profile.php\"]\');\r\n        if (profileLink) {\r\n            // Change the link to the edit profile page\r\n            profileLink.href = M.cfg.wwwroot + \"/user/edit.php?id=\" + userId + \"&returnto=profile\";\r\n        }\r\n    }\r\n});\r\n</script>\r\n'),(1886,2,1756896729,NULL,'additionalhtmlhead','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n</style>\r\n\r\n','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n</style>\r\n<script>\r\ndocument.addEventListener(\'DOMContentLoaded\', function () {\r\n    // Get the logged-in user ID from Moodle\'s body data attributes\r\n    let userId = document.body.getAttribute(\'data-userid\');\r\n    \r\n    // If not found, try to fetch from PHP via embedded data\r\n    if (!userId && typeof M !== \"undefined\" && M.cfg && M.cfg.userid) {\r\n        userId = M.cfg.userid;\r\n    }\r\n\r\n    if (userId) {\r\n        // Find the Profile link in the user menu\r\n        const profileLink = document.querySelector(\'a[href*=\"/user/profile.php\"]\');\r\n        if (profileLink) {\r\n            // Change the link to the edit profile page\r\n            profileLink.href = M.cfg.wwwroot + \"/user/edit.php?id=\" + userId + \"&returnto=profile\";\r\n        }\r\n    }\r\n});\r\n</script>\r\n'),(1887,52,1756984478,NULL,'debug','32767','0'),(1888,52,1756985134,NULL,'debug','30719','32767'),(1889,52,1756986369,NULL,'debug','0','30719'),(1890,52,1756986369,NULL,'debugdisplay','0','1'),(1891,2,1758018381,'book','mod_visibility','0','1'),(1892,2,1758018388,'choice','mod_visibility','0','1'),(1893,2,1758018393,'chat','mod_visibility','0','1'),(1894,2,1758018403,'glossary','mod_visibility','0','1'),(1895,2,1758018410,'lesson','mod_visibility','0','1'),(1896,2,1758018420,'survey','mod_visibility','0','1'),(1897,2,1758018427,'data','mod_visibility','0','1'),(1898,2,1758018432,'feedback','mod_visibility','0','1'),(1899,2,1758018449,'url','mod_visibility','0','1'),(1900,2,1758018453,'wiki','mod_visibility','0','1'),(1901,2,1758018457,'workshop','mod_visibility','0','1'),(1902,2,1758018503,'h5pactivity','mod_visibility','0','1'),(1903,2,1758018509,'imscp','mod_visibility','0','1'),(1904,2,1758018516,'label','mod_visibility','0','1'),(1905,2,1758538626,'theme_academi','primarycolor','#000','#FF4B00'),(1906,2,1758538645,'theme_academi','primarycolor','#FF4B00','#000'),(1907,2,1758538704,'theme_academi','primarycolor','#000','#FF4B00'),(1908,2,1758538822,'theme_academi','primarycolor','#FF4B00','#000'),(1909,2,1758539198,NULL,'additionalhtmlhead','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n#header.navbar {\r\n    background-color: #000 !important;   \r\n}\r\n</style>\r\n\r\n','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n</style>\r\n\r\n'),(1910,2,1758539691,'theme_academi','favicon','/sitelogo-removebg-preview.png',''),(1911,2,1758540635,NULL,'additionalhtmlhead','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n#header.navbar {\r\n    background-color: #000 !important;   \r\n}\r\n\r\n/* Hide the Home link in the primary nav */\r\n.primary-navigation a[href*=\"/?redirect=0\"],\r\n.primary-navigation a[href$=\"/\"] {\r\n    display: none !important;\r\n}\r\n\r\n</style>\r\n\r\n','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n#header.navbar {\r\n    background-color: #000 !important;   \r\n}\r\n</style>\r\n\r\n'),(1912,2,1758540656,NULL,'additionalhtmlhead','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n#header.navbar {\r\n    background-color: #000 !important;   \r\n}\r\n\r\n/* Hide the Home link in the primary nav */\r\n.primary-navigation a[href*=\"/?redirect=0\"],\r\n {\r\n    display: none !important;\r\n}\r\n\r\n</style>\r\n\r\n','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n#header.navbar {\r\n    background-color: #000 !important;   \r\n}\r\n\r\n/* Hide the Home link in the primary nav */\r\n.primary-navigation a[href*=\"/?redirect=0\"],\r\n.primary-navigation a[href$=\"/\"] {\r\n    display: none !important;\r\n}\r\n\r\n</style>\r\n\r\n'),(1913,2,1758540743,NULL,'additionalhtmlhead','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n#header.navbar {\r\n    background-color: #000 !important;   \r\n}\r\n\r\n\r\n/* Hide the Home tab in the primary navigation */\r\n.primary-navigation li[data-key=\"home\"] {\r\n    display: none !important;\r\n}\r\n\r\n\r\n</style>\r\n\r\n','<style>\r\n/* Hide forgot password link */\r\n.loginbox .forgetpass {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide sign-up / Create new account link */\r\n.loginbox .signup {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide guest login button */\r\n.loginbox .guestlogin {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide social logins (Google, Facebook, etc.) */\r\n.loginbox .potentialidps {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide remember username checkbox */\r\n.loginbox .rememberusername,\r\n.loginbox label[for=\"rememberusername\"] {\r\n    display: none !important;\r\n}\r\n\r\n/* Hide login errors/info */\r\n.loginbox .logininfo,\r\n.loginbox .loginerrors {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide footer */\r\n#page-footer {\r\n    display: none !important;\r\n}\r\n\r\n/* Optional: Hide header/logo */\r\n#page-header, .logo {\r\n    display: none !important;\r\n}\r\n#header.navbar {\r\n    background-color: #000 !important;   \r\n}\r\n\r\n/* Hide the Home link in the primary nav */\r\n.primary-navigation a[href*=\"/?redirect=0\"],\r\n {\r\n    display: none !important;\r\n}\r\n\r\n</style>\r\n\r\n');
/*!40000 ALTER TABLE `mdl_config_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_config_plugins`
--

DROP TABLE IF EXISTS `mdl_config_plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_config_plugins` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `plugin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'core',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_confplug_plunam_uix` (`plugin`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2087 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Moodle modules and plugins configuration variables';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_config_plugins`
--

LOCK TABLES `mdl_config_plugins` WRITE;
/*!40000 ALTER TABLE `mdl_config_plugins` DISABLE KEYS */;
INSERT INTO `mdl_config_plugins` VALUES (1,'question','multichoice_sortorder','1'),(2,'question','truefalse_sortorder','2'),(3,'question','match_sortorder','3'),(4,'question','shortanswer_sortorder','4'),(5,'question','numerical_sortorder','5'),(6,'question','essay_sortorder','6'),(7,'core_competency','enabled','1'),(8,'moodlecourse','visible','1'),(9,'moodlecourse','downloadcontentsitedefault','0'),(10,'moodlecourse','participantsperpage','20'),(11,'moodlecourse','format','topics'),(12,'moodlecourse','maxsections','52'),(13,'moodlecourse','numsections','4'),(14,'moodlecourse','hiddensections','1'),(15,'moodlecourse','coursedisplay','0'),(16,'moodlecourse','courseenddateenabled','1'),(17,'moodlecourse','courseduration','31536000'),(18,'moodlecourse','lang',''),(19,'moodlecourse','newsitems','5'),(20,'moodlecourse','showgrades','1'),(21,'moodlecourse','showreports','0'),(22,'moodlecourse','showactivitydates','1'),(23,'moodlecourse','maxbytes','0'),(24,'moodlecourse','enablecompletion','1'),(25,'moodlecourse','showcompletionconditions','1'),(26,'moodlecourse','groupmode','0'),(27,'moodlecourse','groupmodeforce','0'),(28,'backup','loglifetime','30'),(29,'backup','backup_general_users','1'),(30,'backup','backup_general_users_locked',''),(31,'backup','backup_general_anonymize','0'),(32,'backup','backup_general_anonymize_locked',''),(33,'backup','backup_general_role_assignments','1'),(34,'backup','backup_general_role_assignments_locked',''),(35,'backup','backup_general_activities','1'),(36,'backup','backup_general_activities_locked',''),(37,'backup','backup_general_blocks','1'),(38,'backup','backup_general_blocks_locked',''),(39,'backup','backup_general_files','1'),(40,'backup','backup_general_files_locked',''),(41,'backup','backup_general_filters','1'),(42,'backup','backup_general_filters_locked',''),(43,'backup','backup_general_comments','1'),(44,'backup','backup_general_comments_locked',''),(45,'backup','backup_general_badges','1'),(46,'backup','backup_general_badges_locked',''),(47,'backup','backup_general_calendarevents','1'),(48,'backup','backup_general_calendarevents_locked',''),(49,'backup','backup_general_userscompletion','1'),(50,'backup','backup_general_userscompletion_locked',''),(51,'backup','backup_general_logs','0'),(52,'backup','backup_general_logs_locked',''),(53,'backup','backup_general_histories','0'),(54,'backup','backup_general_histories_locked',''),(55,'backup','backup_general_questionbank','1'),(56,'backup','backup_general_questionbank_locked',''),(57,'backup','backup_general_groups','1'),(58,'backup','backup_general_groups_locked',''),(59,'backup','backup_general_competencies','1'),(60,'backup','backup_general_competencies_locked',''),(61,'backup','backup_general_contentbankcontent','1'),(62,'backup','backup_general_contentbankcontent_locked',''),(63,'backup','backup_general_legacyfiles','1'),(64,'backup','backup_general_legacyfiles_locked',''),(65,'backup','import_general_maxresults','10'),(66,'backup','import_general_duplicate_admin_allowed','0'),(67,'backup','backup_import_permissions','0'),(68,'backup','backup_import_permissions_locked',''),(69,'backup','backup_import_activities','1'),(70,'backup','backup_import_activities_locked',''),(71,'backup','backup_import_blocks','1'),(72,'backup','backup_import_blocks_locked',''),(73,'backup','backup_import_filters','1'),(74,'backup','backup_import_filters_locked',''),(75,'backup','backup_import_calendarevents','1'),(76,'backup','backup_import_calendarevents_locked',''),(77,'backup','backup_import_questionbank','1'),(78,'backup','backup_import_questionbank_locked',''),(79,'backup','backup_import_groups','1'),(80,'backup','backup_import_groups_locked',''),(81,'backup','backup_import_competencies','1'),(82,'backup','backup_import_competencies_locked',''),(83,'backup','backup_import_contentbankcontent','1'),(84,'backup','backup_import_contentbankcontent_locked',''),(85,'backup','backup_import_legacyfiles','1'),(86,'backup','backup_import_legacyfiles_locked',''),(87,'backup','backup_auto_active','0'),(88,'backup','backup_auto_weekdays','0000000'),(89,'backup','backup_auto_hour','0'),(90,'backup','backup_auto_minute','0'),(91,'backup','backup_auto_storage','0'),(92,'backup','backup_auto_destination',''),(93,'backup','backup_auto_max_kept','1'),(94,'backup','backup_auto_delete_days','0'),(95,'backup','backup_auto_min_kept','0'),(96,'backup','backup_shortname','0'),(97,'backup','backup_auto_skip_hidden','1'),(98,'backup','backup_auto_skip_modif_days','30'),(99,'backup','backup_auto_skip_modif_prev','0'),(100,'backup','backup_auto_users','1'),(101,'backup','backup_auto_role_assignments','1'),(102,'backup','backup_auto_activities','1'),(103,'backup','backup_auto_blocks','1'),(104,'backup','backup_auto_files','1'),(105,'backup','backup_auto_filters','1'),(106,'backup','backup_auto_comments','1'),(107,'backup','backup_auto_badges','1'),(108,'backup','backup_auto_calendarevents','1'),(109,'backup','backup_auto_userscompletion','1'),(110,'backup','backup_auto_logs','0'),(111,'backup','backup_auto_histories','0'),(112,'backup','backup_auto_questionbank','1'),(113,'backup','backup_auto_groups','1'),(114,'backup','backup_auto_competencies','1'),(115,'backup','backup_auto_contentbankcontent','1'),(116,'backup','backup_auto_legacyfiles','1'),(117,'restore','restore_general_users','1'),(118,'restore','restore_general_users_locked',''),(119,'restore','restore_general_enrolments','1'),(120,'restore','restore_general_enrolments_locked',''),(121,'restore','restore_general_role_assignments','1'),(122,'restore','restore_general_role_assignments_locked',''),(123,'restore','restore_general_permissions','1'),(124,'restore','restore_general_permissions_locked',''),(125,'restore','restore_general_activities','1'),(126,'restore','restore_general_activities_locked',''),(127,'restore','restore_general_blocks','1'),(128,'restore','restore_general_blocks_locked',''),(129,'restore','restore_general_filters','1'),(130,'restore','restore_general_filters_locked',''),(131,'restore','restore_general_comments','1'),(132,'restore','restore_general_comments_locked',''),(133,'restore','restore_general_badges','1'),(134,'restore','restore_general_badges_locked',''),(135,'restore','restore_general_calendarevents','1'),(136,'restore','restore_general_calendarevents_locked',''),(137,'restore','restore_general_userscompletion','1'),(138,'restore','restore_general_userscompletion_locked',''),(139,'restore','restore_general_logs','1'),(140,'restore','restore_general_logs_locked',''),(141,'restore','restore_general_histories','1'),(142,'restore','restore_general_histories_locked',''),(143,'restore','restore_general_groups','1'),(144,'restore','restore_general_groups_locked',''),(145,'restore','restore_general_competencies','1'),(146,'restore','restore_general_competencies_locked',''),(147,'restore','restore_general_contentbankcontent','1'),(148,'restore','restore_general_contentbankcontent_locked',''),(149,'restore','restore_general_legacyfiles','1'),(150,'restore','restore_general_legacyfiles_locked',''),(151,'restore','restore_merge_overwrite_conf','0'),(152,'restore','restore_merge_overwrite_conf_locked',''),(153,'restore','restore_merge_course_fullname','1'),(154,'restore','restore_merge_course_fullname_locked',''),(155,'restore','restore_merge_course_shortname','1'),(156,'restore','restore_merge_course_shortname_locked',''),(157,'restore','restore_merge_course_startdate','1'),(158,'restore','restore_merge_course_startdate_locked',''),(159,'restore','restore_replace_overwrite_conf','0'),(160,'restore','restore_replace_overwrite_conf_locked',''),(161,'restore','restore_replace_course_fullname','1'),(162,'restore','restore_replace_course_fullname_locked',''),(163,'restore','restore_replace_course_shortname','1'),(164,'restore','restore_replace_course_shortname_locked',''),(165,'restore','restore_replace_course_startdate','1'),(166,'restore','restore_replace_course_startdate_locked',''),(167,'restore','restore_replace_keep_roles_and_enrolments','0'),(168,'restore','restore_replace_keep_roles_and_enrolments_locked',''),(169,'restore','restore_replace_keep_groups_and_groupings','0'),(170,'restore','restore_replace_keep_groups_and_groupings_locked',''),(171,'backup','backup_async_message_users','0'),(172,'backup','backup_async_message_subject','Moodle {operation} completed successfully'),(173,'backup','backup_async_message','Your {operation} (ID: {backupid}) has completed successfully. You can access it here: <a href=\"{link}\">{link}</a>.'),(174,'analytics','modeinstruction',''),(175,'analytics','percentonline','0'),(176,'analytics','typeinstitution',''),(177,'analytics','levelinstitution',''),(178,'analytics','predictionsprocessor','\\mlbackend_php\\processor'),(179,'analytics','defaulttimesplittingsevaluation','\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range'),(180,'analytics','modeloutputdir',''),(181,'analytics','onlycli','1'),(182,'analytics','modeltimelimit','1200'),(183,'analytics','calclifetime','35'),(184,'antivirus','notifyemail',''),(185,'antivirus','notifylevel','2'),(186,'antivirus','threshold','1200'),(187,'antivirus','enablequarantine','0'),(188,'antivirus','quarantinetime','2419200'),(189,'cachestore_apcu','testperformance','0'),(190,'cachestore_memcached','testservers',''),(191,'cachestore_mongodb','testserver',''),(192,'cachestore_redis','test_server',''),(193,'cachestore_redis','test_password',''),(194,'cachestore_redis','test_ttl','0'),(195,'question_preview','behaviour','deferredfeedback'),(196,'question_preview','correctness','1'),(197,'question_preview','marks','2'),(198,'question_preview','markdp','2'),(199,'question_preview','feedback','1'),(200,'question_preview','generalfeedback','1'),(201,'question_preview','rightanswer','1'),(202,'question_preview','history','0'),(203,'tool_task','enablerunnow','1'),(204,'adminpresets','sensiblesettings','recaptchapublickey@@none, recaptchaprivatekey@@none, googlemapkey3@@none, secretphrase@@url, cronremotepassword@@none, smtpuser@@none, smtppass@none, proxypassword@@none, quizpassword@@quiz, allowedip@@none, blockedip@@none, dbpass@@logstore_database, messageinbound_hostpass@@none, bind_pw@@auth_cas, pass@@auth_db, bind_pw@@auth_ldap, dbpass@@enrol_database, bind_pw@@enrol_ldap, server_password@@search_solr, ssl_keypassword@@search_solr, alternateserver_password@@search_solr, alternatessl_keypassword@@search_solr, test_password@@cachestore_redis, password@@mlbackend_python, badges_badgesalt@@none, calendar_exportsalt@@none'),(205,'theme_boost','unaddableblocks','navigation,settings,course_list,section_links'),(206,'theme_boost','preset','default.scss'),(207,'theme_boost','presetfiles',''),(208,'theme_boost','backgroundimage',''),(209,'theme_boost','loginbackgroundimage',''),(210,'theme_boost','brandcolor',''),(211,'theme_boost','scsspre',''),(212,'theme_boost','scss',''),(213,'theme_classic','navbardark','0'),(214,'theme_classic','unaddableblocks',''),(215,'theme_classic','preset','default.scss'),(216,'theme_classic','presetfiles',''),(217,'theme_classic','backgroundimage',''),(218,'theme_classic','loginbackgroundimage',''),(219,'theme_classic','brandcolor',''),(220,'theme_classic','scsspre',''),(221,'theme_classic','scss',''),(222,'core_admin','logo',''),(223,'core_admin','logocompact',''),(224,'core_admin','coursecolor1','#81ecec'),(225,'core_admin','coursecolor2','#74b9ff'),(226,'core_admin','coursecolor3','#a29bfe'),(227,'core_admin','coursecolor4','#dfe6e9'),(228,'core_admin','coursecolor5','#00b894'),(229,'core_admin','coursecolor6','#0984e3'),(230,'core_admin','coursecolor7','#b2bec3'),(231,'core_admin','coursecolor8','#fdcb6e'),(232,'core_admin','coursecolor9','#fd79a8'),(233,'core_admin','coursecolor10','#6c5ce7'),(234,'core_competency','pushcourseratingstouserplans','1'),(235,'antivirus_clamav','version','2022041900'),(236,'availability_completion','version','2022041900'),(237,'availability_date','version','2022041900'),(238,'availability_grade','version','2022041900'),(239,'availability_group','version','2022041900'),(240,'availability_grouping','version','2022041900'),(241,'availability_profile','version','2022041900'),(242,'qtype_calculated','version','2022041900'),(243,'qtype_calculatedmulti','version','2022041900'),(244,'qtype_calculatedsimple','version','2022041900'),(245,'qtype_ddimageortext','version','2022041900'),(246,'qtype_ddmarker','version','2022041900'),(247,'qtype_ddwtos','version','2022041900'),(248,'qtype_description','version','2022041900'),(249,'qtype_essay','version','2022041900'),(250,'qtype_gapselect','version','2022041900'),(251,'qtype_match','version','2022041900'),(252,'qtype_missingtype','version','2022041900'),(253,'qtype_multianswer','version','2022041900'),(254,'qtype_multichoice','version','2022041900'),(255,'qtype_numerical','version','2022041900'),(256,'qtype_random','version','2022041900'),(257,'qtype_randomsamatch','version','2022041900'),(258,'qtype_shortanswer','version','2022041900'),(259,'qtype_truefalse','version','2022041900'),(260,'mod_assign','version','2022041902'),(261,'mod_assignment','version','2022041900'),(263,'mod_bigbluebuttonbn','version','2022041901'),(265,'mod_book','version','2022041900'),(266,'mod_chat','version','2022041900'),(267,'mod_choice','version','2022041900'),(268,'mod_data','version','2022041900'),(269,'mod_feedback','version','2022041900'),(271,'mod_folder','version','2022041900'),(273,'mod_forum','version','2022041901'),(274,'mod_glossary','version','2022041900'),(275,'mod_h5pactivity','version','2022041900'),(276,'mod_imscp','version','2022041900'),(278,'mod_label','version','2022041902'),(279,'mod_lesson','version','2022041900'),(284,'mod_page','version','2022041900'),(286,'mod_quiz','version','2022041900'),(287,'mod_resource','version','2022041900'),(288,'mod_scorm','version','2022041900'),(289,'mod_survey','version','2022041900'),(291,'mod_url','version','2022041900'),(293,'mod_wiki','version','2022041900'),(295,'mod_workshop','version','2022041900'),(296,'auth_cas','version','2022041900'),(298,'auth_db','version','2022041900'),(300,'auth_email','version','2022041900'),(301,'auth_ldap','version','2022041900'),(303,'auth_lti','version','2022041900'),(304,'auth_manual','version','2022041900'),(305,'auth_mnet','version','2022041900'),(307,'auth_nologin','version','2022041900'),(308,'auth_none','version','2022041900'),(309,'auth_oauth2','version','2022041900'),(310,'auth_shibboleth','version','2022041900'),(312,'auth_webservice','version','2022041900'),(313,'calendartype_gregorian','version','2022041900'),(314,'customfield_checkbox','version','2022041900'),(315,'customfield_date','version','2022041900'),(316,'customfield_select','version','2022041900'),(317,'customfield_text','version','2022041900'),(318,'customfield_textarea','version','2022041900'),(319,'enrol_category','version','2022041900'),(321,'enrol_cohort','version','2022041900'),(322,'enrol_database','version','2022041900'),(324,'enrol_fee','version','2022041900'),(325,'enrol_flatfile','version','2022041900'),(327,'enrol_flatfile','map_1','manager'),(328,'enrol_flatfile','map_2','coursecreator'),(329,'enrol_flatfile','map_3','editingteacher'),(330,'enrol_flatfile','map_4','teacher'),(331,'enrol_flatfile','map_5','student'),(332,'enrol_flatfile','map_6','guest'),(333,'enrol_flatfile','map_7','user'),(334,'enrol_flatfile','map_8','frontpage'),(335,'enrol_guest','version','2022041900'),(336,'enrol_imsenterprise','version','2022041900'),(338,'enrol_ldap','version','2022041900'),(340,'enrol_lti','version','2022041903'),(342,'enrol_lti','lti_13_kid','b6b0cc9aa73c7c233d92'),(343,'enrol_lti','lti_13_privatekey','-----BEGIN PRIVATE KEY-----\nMIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCijNX/H/m2HFpE\nfSTSzbATSpPZTdDXRW/7oaR/XImCfWPravzPkEnUZuGP69hm/Vae/o7/UTTdFthu\nrjr2Rc5eAR/hUu86T4nVzq9ewngooM42jGTojwy1QdpaSQgNu6VgwF8Tq2oSv6bI\n4/pb5qkT6V05hCPVnrEeOTq2iW26rsE66qJIEKCaVCILqzTGhd4UcnyoHyzHBWO4\npARxKAEUnKh4DL281M6JBzoFfWZf1nhG4UEKHmuehYGmjbxi4jGY/VOjGR31CBpb\nmXi0RylUa2tV96HguJzwgVhllEZWrW0+yLLWubT+Mrr5u5uaKOGkvf6hPjjGXTOz\nswpMI2kRAgMBAAECgf9NWFY7Hyviy3roO+PZqqWtiD7xl2VYCWJPiYqMT6veu2tg\nCXhiC3YV6x5JLR+7YbBl1xqTwkA1Mzmo8J59sJmRgVd6D8xlIpOjeMVZgY9LRbjZ\nm9QoFGknlj4f18BNSIxYjTCwW1ANu8PQsyndsNOi9de2Fno2m1wL1Y9qa9oaiWm1\ndq/vU4/CNu+sZxRbEYAH/M7n9vsuSUpJQ87Y2m51W8wfGtazGoksLGs6gta/AzLF\nI3JC5vDpdZ5iuMAqNtYgsVfMsNHJuxfP5Arhre6B5HORxv6zkjDt/OdzXzlJKVLy\nUqYi2MBmOrxWzWR+vJjjoirNYTZ96/JEg7YqyEECgYEA4RyhSowYKpNs2a53o0j4\nIq4RZJE5UY9LXU2Hg4cZqx8ByzJNm9wOM9cb3rq0gUa4lemPEmpH+vnW5+oOp4Ie\nC7XDnYdmvYTlgzr/gpp395V7K0w1OAkmZjadFfkPXhs8Mdz0bGW/sUDo83GWHaLp\nkEHNgneXPeSgsQSM0IiaItECgYEAuNqjZ3Ji3JA9brDQyY8bPE6hh7J/pAH30f0w\nAg7jllKEIPWQ+yWXvjxQ1DVCYf8HJWpnqaWKnr5fdrqZU+bANGfTtumU94jausOj\n2v7xFLgVgi/lN5Rxu8gYXEwnBQ9rOMp3/5lPXXWcgiqtWJAhC4G3OsEhf0oB/iYa\nUQZn8kECgYEAgrUh/ewMWCRTzq1b8CZ9VX2mwbMFChNe2iUbK0a1o8OUQgzKPVZv\ntLAREaltB6ctpHYBydqGQvbwTqZ7rc2CbqAynfQxtpdEwIbwN0BDqjFUXBaazBec\nATtyyIBd6PF9aSJ3lb0aqewblsb8N+cRIN7kWf3ghmKK313Z+XdnsBECgYBvedqE\n7eRUot+JOzQN+TExgzHCRZDX9R/gENG8zAHPi1+HCNAvxJHn9TPBZYTs2AEVPT/a\nfKxF4wRq80i34jYS5HI2olJlnLBbZNQRoyD7n6/I3N1cUTbtSVP3hS0azhuZGfCX\nwXqtH9oMXXRALlrfN5Cp7AIpYxYkkBHavwQ8gQKBgQCJ7Ha34SearhbSUr1BNcpK\n1uRtK2pJcgX/ZCyZ4bTglEJzXyg+41TV18KZheyFztJ2LEYM7GKtwXMwxkvpe30s\njHuMkfDejqtzKCsWz/tPjX0UmbydaOpVObUl4496HnTR78OO6rD3FT8WHcpM9tzr\nL/3z4oBFFkF5PCmVnXr/pw==\n-----END PRIVATE KEY-----\n'),(344,'enrol_manual','version','2022041900'),(346,'enrol_meta','version','2022041900'),(348,'enrol_mnet','version','2022041900'),(349,'enrol_paypal','version','2022041900'),(350,'enrol_self','version','2022041900'),(352,'message_airnotifier','version','2022041900'),(354,'message','airnotifier_provider_enrol_flatfile_flatfile_enrolment_locked','0'),(355,'message','airnotifier_provider_enrol_imsenterprise_imsenterprise_enrolment_locked','0'),(356,'message','airnotifier_provider_enrol_manual_expiry_notification_locked','0'),(357,'message','airnotifier_provider_enrol_paypal_paypal_enrolment_locked','0'),(358,'message','airnotifier_provider_enrol_self_expiry_notification_locked','0'),(359,'message','airnotifier_provider_mod_assign_assign_notification_locked','0'),(360,'message','airnotifier_provider_mod_assignment_assignment_updates_locked','0'),(361,'message','airnotifier_provider_mod_bigbluebuttonbn_recording_ready_locked','0'),(362,'message','airnotifier_provider_mod_bigbluebuttonbn_instance_updated_locked','0'),(363,'message','airnotifier_provider_mod_feedback_submission_locked','0'),(364,'message','airnotifier_provider_mod_feedback_message_locked','0'),(365,'message','airnotifier_provider_mod_forum_posts_locked','0'),(366,'message','message_provider_mod_forum_posts_enabled','email,airnotifier'),(367,'message','airnotifier_provider_mod_forum_digests_locked','0'),(368,'message','airnotifier_provider_mod_lesson_graded_essay_locked','0'),(369,'message','message_provider_mod_lesson_graded_essay_enabled','email,airnotifier'),(370,'message','airnotifier_provider_mod_quiz_submission_locked','0'),(371,'message','airnotifier_provider_mod_quiz_confirmation_locked','0'),(372,'message','message_provider_mod_quiz_confirmation_enabled','email,airnotifier'),(373,'message','airnotifier_provider_mod_quiz_attempt_overdue_locked','0'),(374,'message','message_provider_mod_quiz_attempt_overdue_enabled','email,airnotifier'),(375,'message','airnotifier_provider_mod_quiz_attempt_grading_complete_locked','0'),(376,'message','message_provider_mod_quiz_attempt_grading_complete_enabled','email,airnotifier'),(377,'message','airnotifier_provider_moodle_newlogin_locked','0'),(378,'message','message_provider_moodle_newlogin_enabled','email,airnotifier'),(379,'message','airnotifier_provider_moodle_notices_locked','0'),(380,'message','airnotifier_provider_moodle_errors_locked','0'),(381,'message','airnotifier_provider_moodle_availableupdate_locked','0'),(382,'message','airnotifier_provider_moodle_instantmessage_locked','0'),(383,'message','airnotifier_provider_moodle_backup_locked','0'),(384,'message','airnotifier_provider_moodle_courserequested_locked','0'),(385,'message','airnotifier_provider_moodle_courserequestapproved_locked','0'),(386,'message','message_provider_moodle_courserequestapproved_enabled','email,airnotifier'),(387,'message','airnotifier_provider_moodle_courserequestrejected_locked','0'),(388,'message','message_provider_moodle_courserequestrejected_enabled','email,airnotifier'),(389,'message','airnotifier_provider_moodle_coursecompleted_locked','0'),(390,'message','message_provider_moodle_coursecompleted_enabled','email,airnotifier'),(391,'message','airnotifier_provider_moodle_coursecontentupdated_locked','0'),(392,'message','message_provider_moodle_coursecontentupdated_enabled','popup,email,airnotifier'),(393,'message','airnotifier_provider_moodle_badgerecipientnotice_locked','0'),(394,'message','message_provider_moodle_badgerecipientnotice_enabled','popup,email,airnotifier'),(395,'message','airnotifier_provider_moodle_badgecreatornotice_locked','0'),(396,'message','airnotifier_provider_moodle_competencyplancomment_locked','0'),(397,'message','airnotifier_provider_moodle_competencyusercompcomment_locked','0'),(398,'message','airnotifier_provider_moodle_insights_locked','0'),(399,'message','message_provider_moodle_insights_enabled','popup,email,airnotifier'),(400,'message','airnotifier_provider_moodle_messagecontactrequests_locked','0'),(401,'message','message_provider_moodle_messagecontactrequests_enabled','email,airnotifier'),(402,'message','airnotifier_provider_moodle_asyncbackupnotification_locked','0'),(403,'message','airnotifier_provider_moodle_gradenotifications_locked','0'),(404,'message','airnotifier_provider_moodle_infected_locked','0'),(405,'message','airnotifier_provider_moodle_reportbuilderschedule_locked','0'),(406,'message_email','version','2022041900'),(408,'message','email_provider_enrol_flatfile_flatfile_enrolment_locked','0'),(409,'message','message_provider_enrol_flatfile_flatfile_enrolment_enabled','email'),(410,'message','email_provider_enrol_imsenterprise_imsenterprise_enrolment_locked','0'),(411,'message','message_provider_enrol_imsenterprise_imsenterprise_enrolment_enabled','email'),(412,'message','email_provider_enrol_manual_expiry_notification_locked','0'),(413,'message','message_provider_enrol_manual_expiry_notification_enabled','email'),(414,'message','email_provider_enrol_paypal_paypal_enrolment_locked','0'),(415,'message','message_provider_enrol_paypal_paypal_enrolment_enabled','email'),(416,'message','email_provider_enrol_self_expiry_notification_locked','0'),(417,'message','message_provider_enrol_self_expiry_notification_enabled','email'),(418,'message','email_provider_mod_assign_assign_notification_locked','0'),(419,'message','message_provider_mod_assign_assign_notification_enabled','email'),(420,'message','email_provider_mod_assignment_assignment_updates_locked','0'),(421,'message','message_provider_mod_assignment_assignment_updates_enabled','email'),(422,'message','email_provider_mod_bigbluebuttonbn_recording_ready_locked','0'),(423,'message','message_provider_mod_bigbluebuttonbn_recording_ready_enabled','email'),(424,'message','email_provider_mod_bigbluebuttonbn_instance_updated_locked','0'),(425,'message','message_provider_mod_bigbluebuttonbn_instance_updated_enabled','email'),(426,'message','email_provider_mod_feedback_submission_locked','0'),(427,'message','message_provider_mod_feedback_submission_enabled','email'),(428,'message','email_provider_mod_feedback_message_locked','0'),(429,'message','message_provider_mod_feedback_message_enabled','email'),(430,'message','email_provider_mod_forum_posts_locked','0'),(431,'message','email_provider_mod_forum_digests_locked','0'),(432,'message','message_provider_mod_forum_digests_enabled','email'),(433,'message','email_provider_mod_lesson_graded_essay_locked','0'),(434,'message','email_provider_mod_quiz_submission_locked','0'),(435,'message','message_provider_mod_quiz_submission_enabled','email'),(436,'message','email_provider_mod_quiz_confirmation_locked','0'),(437,'message','email_provider_mod_quiz_attempt_overdue_locked','0'),(438,'message','email_provider_mod_quiz_attempt_grading_complete_locked','0'),(439,'message','email_provider_moodle_newlogin_locked','0'),(440,'message','email_provider_moodle_notices_locked','0'),(441,'message','message_provider_moodle_notices_enabled','email'),(442,'message','email_provider_moodle_errors_locked','0'),(443,'message','message_provider_moodle_errors_enabled','email'),(444,'message','email_provider_moodle_availableupdate_locked','0'),(445,'message','message_provider_moodle_availableupdate_enabled','email'),(446,'message','email_provider_moodle_instantmessage_locked','0'),(447,'message','message_provider_moodle_instantmessage_enabled','popup,email'),(448,'message','email_provider_moodle_backup_locked','0'),(449,'message','message_provider_moodle_backup_enabled','email'),(450,'message','email_provider_moodle_courserequested_locked','0'),(451,'message','message_provider_moodle_courserequested_enabled','email'),(452,'message','email_provider_moodle_courserequestapproved_locked','0'),(453,'message','email_provider_moodle_courserequestrejected_locked','0'),(454,'message','email_provider_moodle_coursecompleted_locked','0'),(455,'message','email_provider_moodle_coursecontentupdated_locked','0'),(456,'message','email_provider_moodle_badgerecipientnotice_locked','0'),(457,'message','email_provider_moodle_badgecreatornotice_locked','0'),(458,'message','message_provider_moodle_badgecreatornotice_enabled','email'),(459,'message','email_provider_moodle_competencyplancomment_locked','0'),(460,'message','message_provider_moodle_competencyplancomment_enabled','email'),(461,'message','email_provider_moodle_competencyusercompcomment_locked','0'),(462,'message','message_provider_moodle_competencyusercompcomment_enabled','email'),(463,'message','email_provider_moodle_insights_locked','0'),(464,'message','email_provider_moodle_messagecontactrequests_locked','0'),(465,'message','email_provider_moodle_asyncbackupnotification_locked','0'),(466,'message','message_provider_moodle_asyncbackupnotification_enabled','popup,email'),(467,'message','email_provider_moodle_gradenotifications_locked','0'),(468,'message','message_provider_moodle_gradenotifications_enabled','popup,email'),(469,'message','email_provider_moodle_infected_locked','0'),(470,'message','message_provider_moodle_infected_enabled','email'),(471,'message','email_provider_moodle_reportbuilderschedule_locked','1'),(472,'message','message_provider_moodle_reportbuilderschedule_enabled','email'),(473,'message_popup','version','2022041900'),(475,'message','popup_provider_enrol_flatfile_flatfile_enrolment_locked','0'),(476,'message','popup_provider_enrol_imsenterprise_imsenterprise_enrolment_locked','0'),(477,'message','popup_provider_enrol_manual_expiry_notification_locked','0'),(478,'message','popup_provider_enrol_paypal_paypal_enrolment_locked','0'),(479,'message','popup_provider_enrol_self_expiry_notification_locked','0'),(480,'message','popup_provider_mod_assign_assign_notification_locked','0'),(481,'message','popup_provider_mod_assignment_assignment_updates_locked','0'),(482,'message','popup_provider_mod_bigbluebuttonbn_recording_ready_locked','0'),(483,'message','popup_provider_mod_bigbluebuttonbn_instance_updated_locked','0'),(484,'message','popup_provider_mod_feedback_submission_locked','0'),(485,'message','popup_provider_mod_feedback_message_locked','0'),(486,'message','popup_provider_mod_forum_posts_locked','0'),(487,'message','popup_provider_mod_forum_digests_locked','0'),(488,'message','popup_provider_mod_lesson_graded_essay_locked','0'),(489,'message','popup_provider_mod_quiz_submission_locked','0'),(490,'message','popup_provider_mod_quiz_confirmation_locked','0'),(491,'message','popup_provider_mod_quiz_attempt_overdue_locked','0'),(492,'message','popup_provider_mod_quiz_attempt_grading_complete_locked','0'),(493,'message','popup_provider_moodle_newlogin_locked','0'),(494,'message','popup_provider_moodle_notices_locked','0'),(495,'message','popup_provider_moodle_errors_locked','0'),(496,'message','popup_provider_moodle_availableupdate_locked','0'),(497,'message','popup_provider_moodle_instantmessage_locked','0'),(498,'message','popup_provider_moodle_backup_locked','0'),(499,'message','popup_provider_moodle_courserequested_locked','0'),(500,'message','popup_provider_moodle_courserequestapproved_locked','0'),(501,'message','popup_provider_moodle_courserequestrejected_locked','0'),(502,'message','popup_provider_moodle_coursecompleted_locked','0'),(503,'message','popup_provider_moodle_coursecontentupdated_locked','0'),(504,'message','popup_provider_moodle_badgerecipientnotice_locked','0'),(505,'message','popup_provider_moodle_badgecreatornotice_locked','0'),(506,'message','popup_provider_moodle_competencyplancomment_locked','0'),(507,'message','popup_provider_moodle_competencyusercompcomment_locked','0'),(508,'message','popup_provider_moodle_insights_locked','0'),(509,'message','popup_provider_moodle_messagecontactrequests_locked','0'),(510,'message','popup_provider_moodle_asyncbackupnotification_locked','0'),(511,'message','popup_provider_moodle_gradenotifications_locked','0'),(512,'message','popup_provider_moodle_infected_locked','0'),(513,'message','popup_provider_moodle_reportbuilderschedule_locked','0'),(514,'block_accessreview','version','2022041900'),(515,'block_activity_modules','version','2022041900'),(516,'block_activity_results','version','2022041900'),(517,'block_admin_bookmarks','version','2022041900'),(518,'block_badges','version','2022041900'),(519,'block_blog_menu','version','2022041900'),(520,'block_blog_recent','version','2022041900'),(521,'block_blog_tags','version','2022041900'),(522,'block_calendar_month','version','2022041901'),(523,'block_calendar_upcoming','version','2022041900'),(524,'block_comments','version','2022041900'),(525,'block_completionstatus','version','2022041900'),(526,'block_course_list','version','2022041900'),(527,'block_course_summary','version','2022041900'),(529,'block_feedback','version','2022041900'),(531,'block_globalsearch','version','2022041900'),(532,'block_glossary_random','version','2022041900'),(534,'block_login','version','2022041900'),(535,'block_lp','version','2022041900'),(536,'block_mentees','version','2022041900'),(537,'block_mnet_hosts','version','2022041900'),(538,'block_myoverview','version','2022041901'),(539,'block_myprofile','version','2022041900'),(540,'block_navigation','version','2022041900'),(541,'block_news_items','version','2022041900'),(542,'block_online_users','version','2022041900'),(543,'block_private_files','version','2022041900'),(544,'block_recent_activity','version','2022041900'),(545,'block_recentlyaccessedcourses','version','2022041900'),(547,'block_recentlyaccesseditems','version','2022041901'),(548,'block_rss_client','version','2022041900'),(550,'block_search_forums','version','2022041900'),(551,'block_section_links','version','2022041900'),(552,'block_selfcompletion','version','2022041900'),(554,'block_settings','version','2022041900'),(555,'block_site_main_menu','version','2022041900'),(556,'block_social_activities','version','2022041900'),(557,'block_starredcourses','version','2022041900'),(558,'block_tag_flickr','version','2022041900'),(559,'block_tag_youtube','version','2022041900'),(561,'block_tags','version','2022041900'),(562,'block_timeline','version','2022041901'),(564,'media_html5audio','version','2022041900'),(565,'media_html5video','version','2022041900'),(566,'media_videojs','version','2022041900'),(567,'media_vimeo','version','2022041900'),(568,'media_youtube','version','2022041900'),(569,'filter_activitynames','version','2022041900'),(571,'filter_algebra','version','2022041900'),(572,'filter_data','version','2022041900'),(574,'filter_displayh5p','version','2022041900'),(576,'filter_emailprotect','version','2022041900'),(577,'filter_emoticon','version','2022041900'),(579,'filter_glossary','version','2022041900'),(581,'filter_mathjaxloader','version','2022041900'),(583,'filter_mediaplugin','version','2022041900'),(585,'filter_multilang','version','2022041900'),(586,'filter_tex','version','2022041900'),(588,'filter_tidy','version','2022041900'),(589,'filter_urltolink','version','2022041900'),(591,'editor_atto','version','2022041900'),(593,'editor_textarea','version','2022041900'),(594,'editor_tinymce','version','2022041900'),(595,'format_singleactivity','version','2022041900'),(596,'format_social','version','2022041900'),(597,'format_topics','version','2022041901'),(598,'format_weeks','version','2022041901'),(599,'dataformat_csv','version','2022041900'),(600,'dataformat_excel','version','2022041900'),(601,'dataformat_html','version','2022041900'),(602,'dataformat_json','version','2022041900'),(603,'dataformat_ods','version','2022041900'),(604,'dataformat_pdf','version','2022041900'),(605,'profilefield_checkbox','version','2022041900'),(606,'profilefield_datetime','version','2022041900'),(607,'profilefield_menu','version','2022041900'),(608,'profilefield_social','version','2022041900'),(609,'profilefield_text','version','2022041900'),(610,'profilefield_textarea','version','2022041900'),(611,'report_backups','version','2022041900'),(612,'report_competency','version','2022041900'),(613,'report_completion','version','2022041900'),(615,'report_configlog','version','2022041900'),(616,'report_courseoverview','version','2022041900'),(617,'report_eventlist','version','2022041900'),(618,'report_infectedfiles','version','2022041900'),(619,'report_insights','version','2022041900'),(620,'report_log','version','2022041900'),(622,'report_loglive','version','2022041900'),(623,'report_outline','version','2022041900'),(625,'report_participation','version','2022041900'),(627,'report_performance','version','2022041900'),(628,'report_progress','version','2022041900'),(630,'report_questioninstances','version','2022041900'),(631,'report_security','version','2022041900'),(632,'report_stats','version','2022041900'),(634,'report_status','version','2022041900'),(635,'report_usersessions','version','2022041900'),(636,'gradeexport_ods','version','2022041900'),(637,'gradeexport_txt','version','2022041900'),(638,'gradeexport_xls','version','2022041900'),(639,'gradeexport_xml','version','2022041900'),(640,'gradeimport_csv','version','2022041900'),(641,'gradeimport_direct','version','2022041900'),(642,'gradeimport_xml','version','2022041900'),(643,'gradereport_grader','version','2022041900'),(644,'gradereport_history','version','2022041900'),(645,'gradereport_outcomes','version','2022041900'),(646,'gradereport_overview','version','2022041900'),(647,'gradereport_singleview','version','2022041900'),(648,'gradereport_user','version','2022041900'),(649,'gradingform_guide','version','2022041900'),(650,'gradingform_rubric','version','2022041900'),(651,'mlbackend_php','version','2022041900'),(652,'mlbackend_python','version','2022041900'),(653,'mnetservice_enrol','version','2022041900'),(654,'webservice_rest','version','2022041900'),(655,'webservice_soap','version','2022041900'),(656,'webservice_xmlrpc','version','2022041900'),(657,'repository_areafiles','version','2022041900'),(659,'areafiles','enablecourseinstances','0'),(660,'areafiles','enableuserinstances','0'),(661,'repository_contentbank','version','2022041900'),(663,'contentbank','enablecourseinstances','0'),(664,'contentbank','enableuserinstances','0'),(665,'repository_coursefiles','version','2022041900'),(666,'repository_dropbox','version','2022041900'),(667,'repository_equella','version','2022041900'),(668,'repository_filesystem','version','2022041900'),(669,'repository_flickr','version','2022041900'),(670,'repository_flickr_public','version','2022041900'),(671,'repository_googledocs','version','2022041900'),(672,'repository_local','version','2022041900'),(674,'local','enablecourseinstances','0'),(675,'local','enableuserinstances','0'),(676,'repository_merlot','version','2022041900'),(677,'repository_nextcloud','version','2022041900'),(678,'repository_onedrive','version','2022041900'),(679,'repository_recent','version','2022041900'),(681,'recent','enablecourseinstances','0'),(682,'recent','enableuserinstances','0'),(683,'repository_s3','version','2022041900'),(684,'repository_upload','version','2022041900'),(686,'upload','enablecourseinstances','0'),(687,'upload','enableuserinstances','0'),(688,'repository_url','version','2022041900'),(690,'url','enablecourseinstances','0'),(691,'url','enableuserinstances','0'),(692,'repository_user','version','2022041900'),(694,'user','enablecourseinstances','0'),(695,'user','enableuserinstances','0'),(696,'repository_webdav','version','2022041900'),(697,'repository_wikimedia','version','2022041900'),(699,'wikimedia','enablecourseinstances','0'),(700,'wikimedia','enableuserinstances','0'),(701,'repository_youtube','version','2022041900'),(703,'portfolio_download','version','2022041900'),(704,'portfolio_flickr','version','2022041900'),(705,'portfolio_googledocs','version','2022041900'),(706,'portfolio_mahara','version','2022041900'),(707,'search_simpledb','version','2022041900'),(709,'search_solr','version','2022041900'),(710,'qbank_bulkmove','version','2022041900'),(711,'qbank_columnsortorder','version','2022041900'),(712,'qbank_comment','version','2022041900'),(713,'qbank_customfields','version','2022041900'),(714,'qbank_deletequestion','version','2022041900'),(715,'qbank_editquestion','version','2022041900'),(716,'qbank_exportquestions','version','2022041900'),(717,'qbank_exporttoxml','version','2022041900'),(718,'qbank_history','version','2022041900'),(719,'qbank_importquestions','version','2022041900'),(720,'qbank_managecategories','version','2022041900'),(721,'qbank_previewquestion','version','2022041900'),(722,'qbank_statistics','version','2022041900'),(723,'qbank_tagquestion','version','2022041900'),(724,'qbank_usage','version','2022041900'),(725,'qbank_viewcreator','version','2022041900'),(726,'qbank_viewquestionname','version','2022041900'),(727,'qbank_viewquestiontext','version','2022041900'),(728,'qbank_viewquestiontype','version','2022041900'),(729,'qbehaviour_adaptive','version','2022041900'),(730,'qbehaviour_adaptivenopenalty','version','2022041900'),(731,'qbehaviour_deferredcbm','version','2022041900'),(732,'qbehaviour_deferredfeedback','version','2022041900'),(733,'qbehaviour_immediatecbm','version','2022041900'),(734,'qbehaviour_immediatefeedback','version','2022041900'),(735,'qbehaviour_informationitem','version','2022041900'),(736,'qbehaviour_interactive','version','2022041900'),(737,'qbehaviour_interactivecountback','version','2022041900'),(738,'qbehaviour_manualgraded','version','2022041900'),(740,'question','disabledbehaviours','manualgraded'),(741,'qbehaviour_missing','version','2022041900'),(742,'qformat_aiken','version','2022041900'),(743,'qformat_blackboard_six','version','2022041900'),(744,'qformat_gift','version','2022041900'),(745,'qformat_missingword','version','2022041900'),(746,'qformat_multianswer','version','2022041900'),(747,'qformat_xhtml','version','2022041900'),(748,'qformat_xml','version','2022041900'),(749,'tool_admin_presets','version','2022041900'),(750,'tool_analytics','version','2022041900'),(751,'tool_availabilityconditions','version','2022041900'),(752,'tool_behat','version','2022041901'),(753,'tool_brickfield','version','2022041900'),(755,'tool_capability','version','2022041900'),(756,'tool_cohortroles','version','2022041901'),(757,'tool_componentlibrary','version','2022041900'),(758,'tool_customlang','version','2022041900'),(760,'tool_dataprivacy','version','2022041900'),(761,'message','airnotifier_provider_tool_dataprivacy_contactdataprotectionofficer_locked','0'),(762,'message','email_provider_tool_dataprivacy_contactdataprotectionofficer_locked','0'),(763,'message','popup_provider_tool_dataprivacy_contactdataprotectionofficer_locked','0'),(764,'message','message_provider_tool_dataprivacy_contactdataprotectionofficer_enabled','email,popup'),(765,'message','airnotifier_provider_tool_dataprivacy_datarequestprocessingresults_locked','0'),(766,'message','email_provider_tool_dataprivacy_datarequestprocessingresults_locked','0'),(767,'message','popup_provider_tool_dataprivacy_datarequestprocessingresults_locked','0'),(768,'message','message_provider_tool_dataprivacy_datarequestprocessingresults_enabled','email,popup'),(769,'message','airnotifier_provider_tool_dataprivacy_notifyexceptions_locked','0'),(770,'message','email_provider_tool_dataprivacy_notifyexceptions_locked','0'),(771,'message','popup_provider_tool_dataprivacy_notifyexceptions_locked','0'),(772,'message','message_provider_tool_dataprivacy_notifyexceptions_enabled','email'),(773,'tool_dbtransfer','version','2022041900'),(774,'tool_filetypes','version','2022041900'),(775,'tool_generator','version','2022041900'),(776,'tool_httpsreplace','version','2022041900'),(777,'tool_innodb','version','2022041900'),(778,'tool_installaddon','version','2022041900'),(779,'tool_langimport','version','2022041900'),(780,'tool_licensemanager','version','2022041900'),(781,'tool_log','version','2022041900'),(783,'tool_log','enabled_stores','logstore_standard'),(784,'tool_lp','version','2022041900'),(785,'tool_lpimportcsv','version','2022041900'),(786,'tool_lpmigrate','version','2022041900'),(787,'tool_messageinbound','version','2022041900'),(788,'message','airnotifier_provider_tool_messageinbound_invalidrecipienthandler_locked','0'),(789,'message','email_provider_tool_messageinbound_invalidrecipienthandler_locked','0'),(790,'message','popup_provider_tool_messageinbound_invalidrecipienthandler_locked','0'),(791,'message','message_provider_tool_messageinbound_invalidrecipienthandler_enabled','email'),(792,'message','airnotifier_provider_tool_messageinbound_messageprocessingerror_locked','0'),(793,'message','email_provider_tool_messageinbound_messageprocessingerror_locked','0'),(794,'message','popup_provider_tool_messageinbound_messageprocessingerror_locked','0'),(795,'message','message_provider_tool_messageinbound_messageprocessingerror_enabled','email'),(796,'message','airnotifier_provider_tool_messageinbound_messageprocessingsuccess_locked','0'),(797,'message','email_provider_tool_messageinbound_messageprocessingsuccess_locked','0'),(798,'message','popup_provider_tool_messageinbound_messageprocessingsuccess_locked','0'),(799,'message','message_provider_tool_messageinbound_messageprocessingsuccess_enabled','email'),(800,'tool_mobile','version','2022041900'),(801,'tool_monitor','version','2022041900'),(802,'message','airnotifier_provider_tool_monitor_notification_locked','0'),(803,'message','email_provider_tool_monitor_notification_locked','0'),(804,'message','popup_provider_tool_monitor_notification_locked','0'),(805,'message','message_provider_tool_monitor_notification_enabled','email'),(806,'tool_moodlenet','version','2022041900'),(808,'tool_multilangupgrade','version','2022041900'),(809,'tool_oauth2','version','2022041900'),(810,'tool_phpunit','version','2022041900'),(811,'tool_policy','version','2022041900'),(812,'tool_profiling','version','2022041900'),(813,'tool_recyclebin','version','2022041900'),(814,'tool_replace','version','2022041900'),(815,'tool_spamcleaner','version','2022041900'),(816,'tool_task','version','2022041900'),(817,'tool_templatelibrary','version','2022041900'),(818,'tool_unsuproles','version','2022041900'),(820,'tool_uploadcourse','version','2022041900'),(821,'tool_uploaduser','version','2022041900'),(822,'tool_usertours','version','2022041900'),(824,'tool_xmldb','version','2022041900'),(825,'cachestore_apcu','version','2022041900'),(826,'cachestore_file','version','2022041900'),(827,'cachestore_memcached','version','2022041900'),(828,'cachestore_mongodb','version','2022041900'),(829,'cachestore_redis','version','2022041900'),(830,'cachestore_session','version','2022041900'),(831,'cachestore_static','version','2022041900'),(832,'cachelock_file','version','2022041900'),(833,'fileconverter_googledrive','version','2022041900'),(834,'fileconverter_unoconv','version','2022041900'),(836,'contenttype_h5p','version','2022041900'),(837,'theme_boost','version','2022041900'),(838,'theme_classic','version','2022041900'),(839,'h5plib_v124','version','2022041900'),(840,'paygw_paypal','version','2022041900'),(842,'assignsubmission_comments','version','2022041900'),(844,'assignsubmission_file','sortorder','1'),(845,'assignsubmission_comments','sortorder','2'),(846,'assignsubmission_onlinetext','sortorder','0'),(847,'assignsubmission_file','version','2022041900'),(848,'assignsubmission_onlinetext','version','2022041900'),(850,'assignfeedback_comments','version','2022041900'),(852,'assignfeedback_comments','sortorder','0'),(853,'assignfeedback_editpdf','sortorder','1'),(854,'assignfeedback_file','sortorder','3'),(855,'assignfeedback_offline','sortorder','2'),(856,'assignfeedback_editpdf','version','2022041902'),(858,'assignfeedback_file','version','2022041900'),(860,'assignfeedback_offline','version','2022041900'),(861,'assignment_offline','version','2022041900'),(862,'assignment_online','version','2022041900'),(863,'assignment_upload','version','2022041900'),(864,'assignment_uploadsingle','version','2022041900'),(865,'booktool_exportimscp','version','2022041900'),(866,'booktool_importhtml','version','2022041900'),(867,'booktool_print','version','2022041900'),(868,'datafield_checkbox','version','2022041900'),(869,'datafield_date','version','2022041900'),(870,'datafield_file','version','2022041900'),(871,'datafield_latlong','version','2022041900'),(872,'datafield_menu','version','2022041900'),(873,'datafield_multimenu','version','2022041900'),(874,'datafield_number','version','2022041900'),(875,'datafield_picture','version','2022041900'),(876,'datafield_radiobutton','version','2022041900'),(877,'datafield_text','version','2022041900'),(878,'datafield_textarea','version','2022041900'),(879,'datafield_url','version','2022041900'),(880,'datapreset_imagegallery','version','2022041900'),(881,'forumreport_summary','version','2022041900'),(882,'ltiservice_basicoutcomes','version','2022041900'),(883,'ltiservice_gradebookservices','version','2022041900'),(884,'ltiservice_memberships','version','2022041900'),(885,'ltiservice_profile','version','2022041900'),(886,'ltiservice_toolproxy','version','2022041900'),(887,'ltiservice_toolsettings','version','2022041900'),(888,'quiz_grading','version','2022041900'),(890,'quiz_overview','version','2022041900'),(892,'quiz_responses','version','2022041900'),(894,'quiz_statistics','version','2022041901'),(896,'quizaccess_delaybetweenattempts','version','2022041900'),(897,'quizaccess_ipaddress','version','2022041900'),(898,'quizaccess_numattempts','version','2022041900'),(899,'quizaccess_offlineattempts','version','2022041900'),(900,'quizaccess_openclosedate','version','2022041900'),(901,'quizaccess_password','version','2022041900'),(902,'quizaccess_seb','version','2022041901'),(904,'quizaccess_securewindow','version','2022041900'),(905,'quizaccess_timelimit','version','2022041900'),(906,'scormreport_basic','version','2022041900'),(907,'scormreport_graphs','version','2022041900'),(908,'scormreport_interactions','version','2022041900'),(909,'scormreport_objectives','version','2022041900'),(910,'workshopform_accumulative','version','2022041900'),(912,'workshopform_comments','version','2022041900'),(914,'workshopform_numerrors','version','2022041900'),(916,'workshopform_rubric','version','2022041900'),(918,'workshopallocation_manual','version','2022041900'),(919,'workshopallocation_random','version','2022041900'),(920,'workshopallocation_scheduled','version','2022041900'),(921,'workshopeval_best','version','2022041900'),(922,'atto_accessibilitychecker','version','2022041900'),(923,'atto_accessibilityhelper','version','2022041900'),(924,'atto_align','version','2022041900'),(925,'atto_backcolor','version','2022041900'),(926,'atto_bold','version','2022041900'),(927,'atto_charmap','version','2022041900'),(928,'atto_clear','version','2022041900'),(929,'atto_collapse','version','2022041900'),(930,'atto_emojipicker','version','2022041900'),(931,'atto_emoticon','version','2022041900'),(932,'atto_equation','version','2022041901'),(933,'atto_fontcolor','version','2022041900'),(934,'atto_h5p','version','2022041900'),(935,'atto_html','version','2022041900'),(936,'atto_image','version','2022041900'),(937,'atto_indent','version','2022041900'),(938,'atto_italic','version','2022041900'),(939,'atto_link','version','2022041900'),(940,'atto_managefiles','version','2022041900'),(941,'atto_media','version','2022041900'),(942,'atto_noautolink','version','2022041900'),(943,'atto_orderedlist','version','2022041900'),(944,'atto_recordrtc','version','2022041900'),(945,'atto_rtl','version','2022041900'),(946,'atto_strike','version','2022041900'),(947,'atto_subscript','version','2022041900'),(948,'atto_superscript','version','2022041900'),(949,'atto_table','version','2022041900'),(950,'atto_title','version','2022041900'),(951,'atto_underline','version','2022041900'),(952,'atto_undo','version','2022041900'),(953,'atto_unorderedlist','version','2022041900'),(954,'tinymce_ctrlhelp','version','2022041900'),(955,'tinymce_managefiles','version','2022041900'),(956,'tinymce_moodleemoticon','version','2022041900'),(957,'tinymce_moodleimage','version','2022041900'),(958,'tinymce_moodlemedia','version','2022041900'),(959,'tinymce_moodlenolink','version','2022041900'),(960,'tinymce_pdw','version','2022041900'),(961,'tinymce_spellchecker','version','2022041900'),(963,'tinymce_wrap','version','2022041900'),(964,'logstore_database','version','2022041900'),(965,'logstore_legacy','version','2022041900'),(966,'logstore_standard','version','2022041900'),(967,'tool_moodlenet','enablemoodlenet','1'),(968,'tool_dataprivacy','contactdataprotectionofficer','0'),(969,'tool_dataprivacy','automaticdataexportapproval','0'),(970,'tool_dataprivacy','automaticdatadeletionapproval','0'),(971,'tool_dataprivacy','automaticdeletionrequests','1'),(972,'tool_dataprivacy','privacyrequestexpiry','604800'),(973,'tool_dataprivacy','requireallenddatesforuserdeletion','1'),(974,'tool_dataprivacy','showdataretentionsummary','1'),(975,'tool_log','exportlog','1'),(976,'analytics','logstore','logstore_standard'),(977,'assign','feedback_plugin_for_gradebook','assignfeedback_comments'),(978,'assign','showrecentsubmissions','0'),(979,'assign','submissionreceipts','1'),(980,'assign','submissionstatement','This submission is my own work, except where I have acknowledged the use of the works of other people.'),(981,'assign','submissionstatementteamsubmission','This submission is the work of my group, except where we have acknowledged the use of the works of other people.'),(982,'assign','submissionstatementteamsubmissionallsubmit','This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.'),(983,'assign','maxperpage','-1'),(984,'assign','alwaysshowdescription','1'),(985,'assign','alwaysshowdescription_adv',''),(986,'assign','alwaysshowdescription_locked',''),(987,'assign','allowsubmissionsfromdate','0'),(988,'assign','allowsubmissionsfromdate_enabled','1'),(989,'assign','allowsubmissionsfromdate_adv',''),(990,'assign','duedate','604800'),(991,'assign','duedate_enabled','1'),(992,'assign','duedate_adv',''),(993,'assign','cutoffdate','1209600'),(994,'assign','cutoffdate_enabled',''),(995,'assign','cutoffdate_adv',''),(996,'assign','enabletimelimit','0'),(997,'assign','gradingduedate','1209600'),(998,'assign','gradingduedate_enabled','1'),(999,'assign','gradingduedate_adv',''),(1000,'assign','submissiondrafts','0'),(1001,'assign','submissiondrafts_adv',''),(1002,'assign','submissiondrafts_locked',''),(1003,'assign','requiresubmissionstatement','0'),(1004,'assign','requiresubmissionstatement_adv',''),(1005,'assign','requiresubmissionstatement_locked',''),(1006,'assign','attemptreopenmethod','none'),(1007,'assign','attemptreopenmethod_adv',''),(1008,'assign','attemptreopenmethod_locked',''),(1009,'assign','maxattempts','-1'),(1010,'assign','maxattempts_adv',''),(1011,'assign','maxattempts_locked',''),(1012,'assign','teamsubmission','0'),(1013,'assign','teamsubmission_adv',''),(1014,'assign','teamsubmission_locked',''),(1015,'assign','preventsubmissionnotingroup','0'),(1016,'assign','preventsubmissionnotingroup_adv',''),(1017,'assign','preventsubmissionnotingroup_locked',''),(1018,'assign','requireallteammemberssubmit','0'),(1019,'assign','requireallteammemberssubmit_adv',''),(1020,'assign','requireallteammemberssubmit_locked',''),(1021,'assign','teamsubmissiongroupingid',''),(1022,'assign','teamsubmissiongroupingid_adv',''),(1023,'assign','sendnotifications','0'),(1024,'assign','sendnotifications_adv',''),(1025,'assign','sendnotifications_locked',''),(1026,'assign','sendlatenotifications','0'),(1027,'assign','sendlatenotifications_adv',''),(1028,'assign','sendlatenotifications_locked',''),(1029,'assign','sendstudentnotifications','1'),(1030,'assign','sendstudentnotifications_adv',''),(1031,'assign','sendstudentnotifications_locked',''),(1032,'assign','blindmarking','0'),(1033,'assign','blindmarking_adv',''),(1034,'assign','blindmarking_locked',''),(1035,'assign','hidegrader','0'),(1036,'assign','hidegrader_adv',''),(1037,'assign','hidegrader_locked',''),(1038,'assign','markingworkflow','0'),(1039,'assign','markingworkflow_adv',''),(1040,'assign','markingworkflow_locked',''),(1041,'assign','markingallocation','0'),(1042,'assign','markingallocation_adv',''),(1043,'assign','markingallocation_locked',''),(1044,'assignsubmission_file','default','1'),(1045,'assignsubmission_file','maxfiles','20'),(1046,'assignsubmission_file','filetypes',''),(1047,'assignsubmission_file','maxbytes','0'),(1048,'assignsubmission_onlinetext','default','0'),(1049,'assignfeedback_comments','default','1'),(1050,'assignfeedback_comments','inline','0'),(1051,'assignfeedback_comments','inline_adv',''),(1052,'assignfeedback_comments','inline_locked',''),(1053,'assignfeedback_editpdf','default','1'),(1054,'assignfeedback_editpdf','stamps',''),(1055,'assignfeedback_file','default','0'),(1056,'assignfeedback_offline','default','0'),(1057,'mod_bigbluebuttonbn','presentationdefault',''),(1058,'book','numberingoptions','0,1,2,3'),(1059,'book','numbering','1'),(1060,'resource','framesize','130'),(1061,'resource','displayoptions','0,1,4,5,6'),(1062,'resource','printintro','1'),(1063,'resource','display','0'),(1064,'resource','showsize','0'),(1065,'resource','showtype','0'),(1066,'resource','showdate','0'),(1067,'resource','popupwidth','620'),(1068,'resource','popupheight','450'),(1069,'resource','filterfiles','0'),(1070,'folder','showexpanded','1'),(1071,'folder','maxsizetodownload','0'),(1072,'imscp','keepold','1'),(1073,'imscp','keepold_adv',''),(1074,'label','dndmedia','1'),(1075,'label','dndresizewidth','400'),(1076,'label','dndresizeheight','400'),(1077,'mod_lesson','mediafile',''),(1078,'mod_lesson','mediafile_adv','1'),(1079,'mod_lesson','mediawidth','640'),(1080,'mod_lesson','mediaheight','480'),(1081,'mod_lesson','mediaclose','0'),(1082,'mod_lesson','progressbar','0'),(1083,'mod_lesson','progressbar_adv',''),(1084,'mod_lesson','ongoing','0'),(1085,'mod_lesson','ongoing_adv','1'),(1086,'mod_lesson','displayleftmenu','0'),(1087,'mod_lesson','displayleftmenu_adv',''),(1088,'mod_lesson','displayleftif','0'),(1089,'mod_lesson','displayleftif_adv','1'),(1090,'mod_lesson','slideshow','0'),(1091,'mod_lesson','slideshow_adv','1'),(1092,'mod_lesson','slideshowwidth','640'),(1093,'mod_lesson','slideshowheight','480'),(1094,'mod_lesson','slideshowbgcolor','#FFFFFF'),(1095,'mod_lesson','maxanswers','5'),(1096,'mod_lesson','maxanswers_adv','1'),(1097,'mod_lesson','defaultfeedback','0'),(1098,'mod_lesson','defaultfeedback_adv','1'),(1099,'mod_lesson','activitylink',''),(1100,'mod_lesson','activitylink_adv','1'),(1101,'mod_lesson','timelimit','0'),(1102,'mod_lesson','timelimit_adv',''),(1103,'mod_lesson','password','0'),(1104,'mod_lesson','password_adv','1'),(1105,'mod_lesson','modattempts','0'),(1106,'mod_lesson','modattempts_adv',''),(1107,'mod_lesson','displayreview','0'),(1108,'mod_lesson','displayreview_adv',''),(1109,'mod_lesson','maximumnumberofattempts','1'),(1110,'mod_lesson','maximumnumberofattempts_adv',''),(1111,'mod_lesson','defaultnextpage','0'),(1112,'mod_lesson','defaultnextpage_adv','1'),(1113,'mod_lesson','numberofpagestoshow','1'),(1114,'mod_lesson','numberofpagestoshow_adv','1'),(1115,'mod_lesson','practice','0'),(1116,'mod_lesson','practice_adv',''),(1117,'mod_lesson','customscoring','1'),(1118,'mod_lesson','customscoring_adv','1'),(1119,'mod_lesson','retakesallowed','0'),(1120,'mod_lesson','retakesallowed_adv',''),(1121,'mod_lesson','handlingofretakes','0'),(1122,'mod_lesson','handlingofretakes_adv','1'),(1123,'mod_lesson','minimumnumberofquestions','0'),(1124,'mod_lesson','minimumnumberofquestions_adv','1'),(1125,'page','displayoptions','5'),(1126,'page','printintro','0'),(1127,'page','printlastmodified','1'),(1128,'page','display','5'),(1129,'page','popupwidth','620'),(1130,'page','popupheight','450'),(1131,'quiz','timelimit','0'),(1132,'quiz','timelimit_adv',''),(1133,'quiz','timelimit_locked',''),(1134,'quiz','notifyattemptgradeddelay','18000'),(1135,'quiz','overduehandling','autosubmit'),(1136,'quiz','overduehandling_adv',''),(1137,'quiz','overduehandling_locked',''),(1138,'quiz','graceperiod','86400'),(1139,'quiz','graceperiod_adv',''),(1140,'quiz','graceperiod_locked',''),(1141,'quiz','graceperiodmin','60'),(1142,'quiz','attempts','0'),(1143,'quiz','attempts_adv',''),(1144,'quiz','attempts_locked',''),(1145,'quiz','grademethod','1'),(1146,'quiz','grademethod_adv',''),(1147,'quiz','grademethod_locked',''),(1148,'quiz','maximumgrade','10'),(1149,'quiz','maximumgrade_locked',''),(1150,'quiz','questionsperpage','1'),(1151,'quiz','questionsperpage_adv',''),(1152,'quiz','questionsperpage_locked',''),(1153,'quiz','navmethod','free'),(1154,'quiz','navmethod_adv','1'),(1155,'quiz','navmethod_locked',''),(1156,'quiz','shuffleanswers','1'),(1157,'quiz','shuffleanswers_adv',''),(1158,'quiz','shuffleanswers_locked',''),(1159,'quiz','preferredbehaviour','deferredfeedback'),(1160,'quiz','preferredbehaviour_locked',''),(1161,'quiz','canredoquestions','0'),(1162,'quiz','canredoquestions_adv','1'),(1163,'quiz','canredoquestions_locked',''),(1164,'quiz','attemptonlast','0'),(1165,'quiz','attemptonlast_adv','1'),(1166,'quiz','attemptonlast_locked',''),(1167,'quiz','reviewattempt','69904'),(1168,'quiz','reviewcorrectness','69904'),(1169,'quiz','reviewmarks','69904'),(1170,'quiz','reviewspecificfeedback','69904'),(1171,'quiz','reviewgeneralfeedback','69904'),(1172,'quiz','reviewrightanswer','69904'),(1173,'quiz','reviewoverallfeedback','4368'),(1174,'quiz','showuserpicture','0'),(1175,'quiz','showuserpicture_adv',''),(1176,'quiz','showuserpicture_locked',''),(1177,'quiz','decimalpoints','2'),(1178,'quiz','decimalpoints_adv',''),(1179,'quiz','decimalpoints_locked',''),(1180,'quiz','questiondecimalpoints','-1'),(1181,'quiz','questiondecimalpoints_adv',''),(1182,'quiz','questiondecimalpoints_locked',''),(1183,'quiz','showblocks','0'),(1184,'quiz','showblocks_adv','1'),(1185,'quiz','showblocks_locked',''),(1186,'quiz','quizpassword',''),(1187,'quiz','quizpassword_adv',''),(1188,'quiz','quizpassword_required',''),(1189,'quiz','quizpassword_locked',''),(1190,'quiz','subnet',''),(1191,'quiz','subnet_adv','1'),(1192,'quiz','subnet_locked',''),(1193,'quiz','delay1','0'),(1194,'quiz','delay1_adv','1'),(1195,'quiz','delay1_locked',''),(1196,'quiz','delay2','0'),(1197,'quiz','delay2_adv','1'),(1198,'quiz','delay2_locked',''),(1199,'quiz','browsersecurity','-'),(1200,'quiz','browsersecurity_adv','1'),(1201,'quiz','browsersecurity_locked',''),(1202,'quiz','initialnumfeedbacks','2'),(1203,'quiz','autosaveperiod','60'),(1204,'quizaccess_seb','autoreconfigureseb','1'),(1205,'quizaccess_seb','showseblinks','seb,http'),(1206,'quizaccess_seb','downloadlink','https://safeexambrowser.org/download_en.html'),(1207,'quizaccess_seb','quizpasswordrequired','0'),(1208,'quizaccess_seb','displayblocksbeforestart','0'),(1209,'quizaccess_seb','displayblockswhenfinished','1'),(1210,'scorm','displaycoursestructure','0'),(1211,'scorm','displaycoursestructure_adv',''),(1212,'scorm','popup','0'),(1213,'scorm','popup_adv',''),(1214,'scorm','framewidth','100'),(1215,'scorm','framewidth_adv','1'),(1216,'scorm','frameheight','500'),(1217,'scorm','frameheight_adv','1'),(1218,'scorm','winoptgrp_adv','1'),(1219,'scorm','scrollbars','0'),(1220,'scorm','directories','0'),(1221,'scorm','location','0'),(1222,'scorm','menubar','0'),(1223,'scorm','toolbar','0'),(1224,'scorm','status','0'),(1225,'scorm','skipview','0'),(1226,'scorm','skipview_adv','1'),(1227,'scorm','hidebrowse','0'),(1228,'scorm','hidebrowse_adv','1'),(1229,'scorm','hidetoc','0'),(1230,'scorm','hidetoc_adv','1'),(1231,'scorm','nav','1'),(1232,'scorm','nav_adv','1'),(1233,'scorm','navpositionleft','-100'),(1234,'scorm','navpositionleft_adv','1'),(1235,'scorm','navpositiontop','-100'),(1236,'scorm','navpositiontop_adv','1'),(1237,'scorm','collapsetocwinsize','767'),(1238,'scorm','collapsetocwinsize_adv','1'),(1239,'scorm','displayattemptstatus','1'),(1240,'scorm','displayattemptstatus_adv',''),(1241,'scorm','grademethod','1'),(1242,'scorm','maxgrade','100'),(1243,'scorm','maxattempt','0'),(1244,'scorm','whatgrade','0'),(1245,'scorm','forcecompleted','0'),(1246,'scorm','forcenewattempt','0'),(1247,'scorm','autocommit','0'),(1248,'scorm','masteryoverride','1'),(1249,'scorm','lastattemptlock','0'),(1250,'scorm','auto','0'),(1251,'scorm','updatefreq','0'),(1252,'scorm','scormstandard','0'),(1253,'scorm','allowtypeexternal','0'),(1254,'scorm','allowtypelocalsync','0'),(1255,'scorm','allowtypeexternalaicc','0'),(1256,'scorm','allowaicchacp','0'),(1257,'scorm','aicchacptimeout','30'),(1258,'scorm','aicchacpkeepsessiondata','1'),(1259,'scorm','aiccuserid','1'),(1260,'scorm','forcejavascript','1'),(1261,'scorm','allowapidebug','0'),(1262,'scorm','apidebugmask','.*'),(1263,'scorm','protectpackagedownloads','0'),(1264,'url','framesize','130'),(1265,'url','secretphrase',''),(1266,'url','rolesinparams','0'),(1267,'url','displayoptions','0,1,5,6'),(1268,'url','printintro','1'),(1269,'url','display','0'),(1270,'url','popupwidth','620'),(1271,'url','popupheight','450'),(1272,'workshop','grade','80'),(1273,'workshop','gradinggrade','20'),(1274,'workshop','gradedecimals','0'),(1275,'workshop','maxbytes','0'),(1276,'workshop','strategy','accumulative'),(1277,'workshop','examplesmode','0'),(1278,'workshopallocation_random','numofreviews','5'),(1279,'workshopform_numerrors','grade0','No'),(1280,'workshopform_numerrors','grade1','Yes'),(1281,'workshopeval_best','comparison','5'),(1282,'tool_brickfield','analysistype','0'),(1283,'tool_brickfield','deletehistoricaldata','1'),(1284,'tool_brickfield','batch','1000'),(1285,'tool_brickfield','perpage','50'),(1286,'tool_recyclebin','coursebinenable','1'),(1287,'tool_recyclebin','coursebinexpiry','604800'),(1288,'tool_recyclebin','categorybinenable','1'),(1289,'tool_recyclebin','categorybinexpiry','604800'),(1290,'tool_recyclebin','autohide','1'),(1291,'antivirus_clamav','runningmethod','commandline'),(1292,'antivirus_clamav','pathtoclam',''),(1293,'antivirus_clamav','pathtounixsocket',''),(1294,'antivirus_clamav','tcpsockethost',''),(1295,'antivirus_clamav','tcpsocketport','3310'),(1296,'antivirus_clamav','clamfailureonupload','tryagain'),(1297,'antivirus_clamav','tries','1'),(1298,'auth_cas','field_map_firstname',''),(1299,'auth_cas','field_updatelocal_firstname','oncreate'),(1300,'auth_cas','field_updateremote_firstname','0'),(1301,'auth_cas','field_lock_firstname','unlocked'),(1302,'auth_cas','field_map_lastname',''),(1303,'auth_cas','field_updatelocal_lastname','oncreate'),(1304,'auth_cas','field_updateremote_lastname','0'),(1305,'auth_cas','field_lock_lastname','unlocked'),(1306,'auth_cas','field_map_email',''),(1307,'auth_cas','field_updatelocal_email','oncreate'),(1308,'auth_cas','field_updateremote_email','0'),(1309,'auth_cas','field_lock_email','unlocked'),(1310,'auth_cas','field_map_city',''),(1311,'auth_cas','field_updatelocal_city','oncreate'),(1312,'auth_cas','field_updateremote_city','0'),(1313,'auth_cas','field_lock_city','unlocked'),(1314,'auth_cas','field_map_country',''),(1315,'auth_cas','field_updatelocal_country','oncreate'),(1316,'auth_cas','field_updateremote_country','0'),(1317,'auth_cas','field_lock_country','unlocked'),(1318,'auth_cas','field_map_lang',''),(1319,'auth_cas','field_updatelocal_lang','oncreate'),(1320,'auth_cas','field_updateremote_lang','0'),(1321,'auth_cas','field_lock_lang','unlocked'),(1322,'auth_cas','field_map_description',''),(1323,'auth_cas','field_updatelocal_description','oncreate'),(1324,'auth_cas','field_updateremote_description','0'),(1325,'auth_cas','field_lock_description','unlocked'),(1326,'auth_cas','field_map_idnumber',''),(1327,'auth_cas','field_updatelocal_idnumber','oncreate'),(1328,'auth_cas','field_updateremote_idnumber','0'),(1329,'auth_cas','field_lock_idnumber','unlocked'),(1330,'auth_cas','field_map_institution',''),(1331,'auth_cas','field_updatelocal_institution','oncreate'),(1332,'auth_cas','field_updateremote_institution','0'),(1333,'auth_cas','field_lock_institution','unlocked'),(1334,'auth_cas','field_map_department',''),(1335,'auth_cas','field_updatelocal_department','oncreate'),(1336,'auth_cas','field_updateremote_department','0'),(1337,'auth_cas','field_lock_department','unlocked'),(1338,'auth_cas','field_map_phone1',''),(1339,'auth_cas','field_updatelocal_phone1','oncreate'),(1340,'auth_cas','field_updateremote_phone1','0'),(1341,'auth_cas','field_lock_phone1','unlocked'),(1342,'auth_cas','field_map_phone2',''),(1343,'auth_cas','field_updatelocal_phone2','oncreate'),(1344,'auth_cas','field_updateremote_phone2','0'),(1345,'auth_cas','field_lock_phone2','unlocked'),(1346,'auth_cas','field_map_address',''),(1347,'auth_cas','field_updatelocal_address','oncreate'),(1348,'auth_cas','field_updateremote_address','0'),(1349,'auth_cas','field_lock_address','unlocked'),(1350,'auth_cas','field_map_firstnamephonetic',''),(1351,'auth_cas','field_updatelocal_firstnamephonetic','oncreate'),(1352,'auth_cas','field_updateremote_firstnamephonetic','0'),(1353,'auth_cas','field_lock_firstnamephonetic','unlocked'),(1354,'auth_cas','field_map_lastnamephonetic',''),(1355,'auth_cas','field_updatelocal_lastnamephonetic','oncreate'),(1356,'auth_cas','field_updateremote_lastnamephonetic','0'),(1357,'auth_cas','field_lock_lastnamephonetic','unlocked'),(1358,'auth_cas','field_map_middlename',''),(1359,'auth_cas','field_updatelocal_middlename','oncreate'),(1360,'auth_cas','field_updateremote_middlename','0'),(1361,'auth_cas','field_lock_middlename','unlocked'),(1362,'auth_cas','field_map_alternatename',''),(1363,'auth_cas','field_updatelocal_alternatename','oncreate'),(1364,'auth_cas','field_updateremote_alternatename','0'),(1365,'auth_cas','field_lock_alternatename','unlocked'),(1366,'auth_email','recaptcha','0'),(1367,'auth_email','field_lock_firstname','unlocked'),(1368,'auth_email','field_lock_lastname','unlocked'),(1369,'auth_email','field_lock_email','unlocked'),(1370,'auth_email','field_lock_city','unlocked'),(1371,'auth_email','field_lock_country','unlocked'),(1372,'auth_email','field_lock_lang','unlocked'),(1373,'auth_email','field_lock_description','unlocked'),(1374,'auth_email','field_lock_idnumber','unlocked'),(1375,'auth_email','field_lock_institution','unlocked'),(1376,'auth_email','field_lock_department','unlocked'),(1377,'auth_email','field_lock_phone1','unlocked'),(1378,'auth_email','field_lock_phone2','unlocked'),(1379,'auth_email','field_lock_address','unlocked'),(1380,'auth_email','field_lock_firstnamephonetic','unlocked'),(1381,'auth_email','field_lock_lastnamephonetic','unlocked'),(1382,'auth_email','field_lock_middlename','unlocked'),(1383,'auth_email','field_lock_alternatename','unlocked'),(1384,'auth_db','host','127.0.0.1'),(1385,'auth_db','type','mysqli'),(1386,'auth_db','sybasequoting','0'),(1387,'auth_db','name',''),(1388,'auth_db','user',''),(1389,'auth_db','pass',''),(1390,'auth_db','table',''),(1391,'auth_db','fielduser',''),(1392,'auth_db','fieldpass',''),(1393,'auth_db','passtype','plaintext'),(1394,'auth_db','extencoding','utf-8'),(1395,'auth_db','setupsql',''),(1396,'auth_db','debugauthdb','0'),(1397,'auth_db','changepasswordurl',''),(1398,'auth_db','removeuser','0'),(1399,'auth_db','updateusers','0'),(1400,'auth_db','field_map_firstname',''),(1401,'auth_db','field_updatelocal_firstname','oncreate'),(1402,'auth_db','field_updateremote_firstname','0'),(1403,'auth_db','field_lock_firstname','unlocked'),(1404,'auth_db','field_map_lastname',''),(1405,'auth_db','field_updatelocal_lastname','oncreate'),(1406,'auth_db','field_updateremote_lastname','0'),(1407,'auth_db','field_lock_lastname','unlocked'),(1408,'auth_db','field_map_email',''),(1409,'auth_db','field_updatelocal_email','oncreate'),(1410,'auth_db','field_updateremote_email','0'),(1411,'auth_db','field_lock_email','unlocked'),(1412,'auth_db','field_map_city',''),(1413,'auth_db','field_updatelocal_city','oncreate'),(1414,'auth_db','field_updateremote_city','0'),(1415,'auth_db','field_lock_city','unlocked'),(1416,'auth_db','field_map_country',''),(1417,'auth_db','field_updatelocal_country','oncreate'),(1418,'auth_db','field_updateremote_country','0'),(1419,'auth_db','field_lock_country','unlocked'),(1420,'auth_db','field_map_lang',''),(1421,'auth_db','field_updatelocal_lang','oncreate'),(1422,'auth_db','field_updateremote_lang','0'),(1423,'auth_db','field_lock_lang','unlocked'),(1424,'auth_db','field_map_description',''),(1425,'auth_db','field_updatelocal_description','oncreate'),(1426,'auth_db','field_updateremote_description','0'),(1427,'auth_db','field_lock_description','unlocked'),(1428,'auth_db','field_map_idnumber',''),(1429,'auth_db','field_updatelocal_idnumber','oncreate'),(1430,'auth_db','field_updateremote_idnumber','0'),(1431,'auth_db','field_lock_idnumber','unlocked'),(1432,'auth_db','field_map_institution',''),(1433,'auth_db','field_updatelocal_institution','oncreate'),(1434,'auth_db','field_updateremote_institution','0'),(1435,'auth_db','field_lock_institution','unlocked'),(1436,'auth_db','field_map_department',''),(1437,'auth_db','field_updatelocal_department','oncreate'),(1438,'auth_db','field_updateremote_department','0'),(1439,'auth_db','field_lock_department','unlocked'),(1440,'auth_db','field_map_phone1',''),(1441,'auth_db','field_updatelocal_phone1','oncreate'),(1442,'auth_db','field_updateremote_phone1','0'),(1443,'auth_db','field_lock_phone1','unlocked'),(1444,'auth_db','field_map_phone2',''),(1445,'auth_db','field_updatelocal_phone2','oncreate'),(1446,'auth_db','field_updateremote_phone2','0'),(1447,'auth_db','field_lock_phone2','unlocked'),(1448,'auth_db','field_map_address',''),(1449,'auth_db','field_updatelocal_address','oncreate'),(1450,'auth_db','field_updateremote_address','0'),(1451,'auth_db','field_lock_address','unlocked'),(1452,'auth_db','field_map_firstnamephonetic',''),(1453,'auth_db','field_updatelocal_firstnamephonetic','oncreate'),(1454,'auth_db','field_updateremote_firstnamephonetic','0'),(1455,'auth_db','field_lock_firstnamephonetic','unlocked'),(1456,'auth_db','field_map_lastnamephonetic',''),(1457,'auth_db','field_updatelocal_lastnamephonetic','oncreate'),(1458,'auth_db','field_updateremote_lastnamephonetic','0'),(1459,'auth_db','field_lock_lastnamephonetic','unlocked'),(1460,'auth_db','field_map_middlename',''),(1461,'auth_db','field_updatelocal_middlename','oncreate'),(1462,'auth_db','field_updateremote_middlename','0'),(1463,'auth_db','field_lock_middlename','unlocked'),(1464,'auth_db','field_map_alternatename',''),(1465,'auth_db','field_updatelocal_alternatename','oncreate'),(1466,'auth_db','field_updateremote_alternatename','0'),(1467,'auth_db','field_lock_alternatename','unlocked'),(1468,'auth_ldap','field_map_firstname',''),(1469,'auth_ldap','field_updatelocal_firstname','oncreate'),(1470,'auth_ldap','field_updateremote_firstname','0'),(1471,'auth_ldap','field_lock_firstname','unlocked'),(1472,'auth_ldap','field_map_lastname',''),(1473,'auth_ldap','field_updatelocal_lastname','oncreate'),(1474,'auth_ldap','field_updateremote_lastname','0'),(1475,'auth_ldap','field_lock_lastname','unlocked'),(1476,'auth_ldap','field_map_email',''),(1477,'auth_ldap','field_updatelocal_email','oncreate'),(1478,'auth_ldap','field_updateremote_email','0'),(1479,'auth_ldap','field_lock_email','unlocked'),(1480,'auth_ldap','field_map_city',''),(1481,'auth_ldap','field_updatelocal_city','oncreate'),(1482,'auth_ldap','field_updateremote_city','0'),(1483,'auth_ldap','field_lock_city','unlocked'),(1484,'auth_ldap','field_map_country',''),(1485,'auth_ldap','field_updatelocal_country','oncreate'),(1486,'auth_ldap','field_updateremote_country','0'),(1487,'auth_ldap','field_lock_country','unlocked'),(1488,'auth_ldap','field_map_lang',''),(1489,'auth_ldap','field_updatelocal_lang','oncreate'),(1490,'auth_ldap','field_updateremote_lang','0'),(1491,'auth_ldap','field_lock_lang','unlocked'),(1492,'auth_ldap','field_map_description',''),(1493,'auth_ldap','field_updatelocal_description','oncreate'),(1494,'auth_ldap','field_updateremote_description','0'),(1495,'auth_ldap','field_lock_description','unlocked'),(1496,'auth_ldap','field_map_idnumber',''),(1497,'auth_ldap','field_updatelocal_idnumber','oncreate'),(1498,'auth_ldap','field_updateremote_idnumber','0'),(1499,'auth_ldap','field_lock_idnumber','unlocked'),(1500,'auth_ldap','field_map_institution',''),(1501,'auth_ldap','field_updatelocal_institution','oncreate'),(1502,'auth_ldap','field_updateremote_institution','0'),(1503,'auth_ldap','field_lock_institution','unlocked'),(1504,'auth_ldap','field_map_department',''),(1505,'auth_ldap','field_updatelocal_department','oncreate'),(1506,'auth_ldap','field_updateremote_department','0'),(1507,'auth_ldap','field_lock_department','unlocked'),(1508,'auth_ldap','field_map_phone1',''),(1509,'auth_ldap','field_updatelocal_phone1','oncreate'),(1510,'auth_ldap','field_updateremote_phone1','0'),(1511,'auth_ldap','field_lock_phone1','unlocked'),(1512,'auth_ldap','field_map_phone2',''),(1513,'auth_ldap','field_updatelocal_phone2','oncreate'),(1514,'auth_ldap','field_updateremote_phone2','0'),(1515,'auth_ldap','field_lock_phone2','unlocked'),(1516,'auth_ldap','field_map_address',''),(1517,'auth_ldap','field_updatelocal_address','oncreate'),(1518,'auth_ldap','field_updateremote_address','0'),(1519,'auth_ldap','field_lock_address','unlocked'),(1520,'auth_ldap','field_map_firstnamephonetic',''),(1521,'auth_ldap','field_updatelocal_firstnamephonetic','oncreate'),(1522,'auth_ldap','field_updateremote_firstnamephonetic','0'),(1523,'auth_ldap','field_lock_firstnamephonetic','unlocked'),(1524,'auth_ldap','field_map_lastnamephonetic',''),(1525,'auth_ldap','field_updatelocal_lastnamephonetic','oncreate'),(1526,'auth_ldap','field_updateremote_lastnamephonetic','0'),(1527,'auth_ldap','field_lock_lastnamephonetic','unlocked'),(1528,'auth_ldap','field_map_middlename',''),(1529,'auth_ldap','field_updatelocal_middlename','oncreate'),(1530,'auth_ldap','field_updateremote_middlename','0'),(1531,'auth_ldap','field_lock_middlename','unlocked'),(1532,'auth_ldap','field_map_alternatename',''),(1533,'auth_ldap','field_updatelocal_alternatename','oncreate'),(1534,'auth_ldap','field_updateremote_alternatename','0'),(1535,'auth_ldap','field_lock_alternatename','unlocked'),(1536,'auth_manual','expiration','0'),(1537,'auth_manual','expirationtime','30'),(1538,'auth_manual','expiration_warning','0'),(1539,'auth_manual','field_lock_firstname','unlocked'),(1540,'auth_manual','field_lock_lastname','unlocked'),(1541,'auth_manual','field_lock_email','unlocked'),(1542,'auth_manual','field_lock_city','unlocked'),(1543,'auth_manual','field_lock_country','unlocked'),(1544,'auth_manual','field_lock_lang','unlocked'),(1545,'auth_manual','field_lock_description','unlocked'),(1546,'auth_manual','field_lock_idnumber','unlocked'),(1547,'auth_manual','field_lock_institution','unlocked'),(1548,'auth_manual','field_lock_department','unlocked'),(1549,'auth_manual','field_lock_phone1','unlocked'),(1550,'auth_manual','field_lock_phone2','unlocked'),(1551,'auth_manual','field_lock_address','unlocked'),(1552,'auth_manual','field_lock_firstnamephonetic','unlocked'),(1553,'auth_manual','field_lock_lastnamephonetic','unlocked'),(1554,'auth_manual','field_lock_middlename','unlocked'),(1555,'auth_manual','field_lock_alternatename','unlocked'),(1556,'auth_mnet','rpc_negotiation_timeout','30'),(1557,'auth_none','field_lock_firstname','unlocked'),(1558,'auth_none','field_lock_lastname','unlocked'),(1559,'auth_none','field_lock_email','unlocked'),(1560,'auth_none','field_lock_city','unlocked'),(1561,'auth_none','field_lock_country','unlocked'),(1562,'auth_none','field_lock_lang','unlocked'),(1563,'auth_none','field_lock_description','unlocked'),(1564,'auth_none','field_lock_idnumber','unlocked'),(1565,'auth_none','field_lock_institution','unlocked'),(1566,'auth_none','field_lock_department','unlocked'),(1567,'auth_none','field_lock_phone1','unlocked'),(1568,'auth_none','field_lock_phone2','unlocked'),(1569,'auth_none','field_lock_address','unlocked'),(1570,'auth_none','field_lock_firstnamephonetic','unlocked'),(1571,'auth_none','field_lock_lastnamephonetic','unlocked'),(1572,'auth_none','field_lock_middlename','unlocked'),(1573,'auth_none','field_lock_alternatename','unlocked'),(1574,'auth_oauth2','field_lock_firstname','unlocked'),(1575,'auth_oauth2','field_lock_lastname','unlocked'),(1576,'auth_oauth2','field_lock_email','unlocked'),(1577,'auth_oauth2','field_lock_city','unlocked'),(1578,'auth_oauth2','field_lock_country','unlocked'),(1579,'auth_oauth2','field_lock_lang','unlocked'),(1580,'auth_oauth2','field_lock_description','unlocked'),(1581,'auth_oauth2','field_lock_idnumber','unlocked'),(1582,'auth_oauth2','field_lock_institution','unlocked'),(1583,'auth_oauth2','field_lock_department','unlocked'),(1584,'auth_oauth2','field_lock_phone1','unlocked'),(1585,'auth_oauth2','field_lock_phone2','unlocked'),(1586,'auth_oauth2','field_lock_address','unlocked'),(1587,'auth_oauth2','field_lock_firstnamephonetic','unlocked'),(1588,'auth_oauth2','field_lock_lastnamephonetic','unlocked'),(1589,'auth_oauth2','field_lock_middlename','unlocked'),(1590,'auth_oauth2','field_lock_alternatename','unlocked'),(1591,'auth_shibboleth','user_attribute',''),(1592,'auth_shibboleth','convert_data',''),(1593,'auth_shibboleth','alt_login','off'),(1594,'auth_shibboleth','organization_selection','urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai'),(1595,'auth_shibboleth','logout_handler',''),(1596,'auth_shibboleth','logout_return_url',''),(1597,'auth_shibboleth','login_name','Shibboleth Login'),(1598,'auth_shibboleth','auth_logo',''),(1599,'auth_shibboleth','auth_instructions','Use the <a href=\"https://lms.techgigs.in/Trainocate/auth/shibboleth/index.php\">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.'),(1600,'auth_shibboleth','changepasswordurl',''),(1601,'auth_shibboleth','field_map_firstname',''),(1602,'auth_shibboleth','field_updatelocal_firstname','oncreate'),(1603,'auth_shibboleth','field_lock_firstname','unlocked'),(1604,'auth_shibboleth','field_map_lastname',''),(1605,'auth_shibboleth','field_updatelocal_lastname','oncreate'),(1606,'auth_shibboleth','field_lock_lastname','unlocked'),(1607,'auth_shibboleth','field_map_email',''),(1608,'auth_shibboleth','field_updatelocal_email','oncreate'),(1609,'auth_shibboleth','field_lock_email','unlocked'),(1610,'auth_shibboleth','field_map_city',''),(1611,'auth_shibboleth','field_updatelocal_city','oncreate'),(1612,'auth_shibboleth','field_lock_city','unlocked'),(1613,'auth_shibboleth','field_map_country',''),(1614,'auth_shibboleth','field_updatelocal_country','oncreate'),(1615,'auth_shibboleth','field_lock_country','unlocked'),(1616,'auth_shibboleth','field_map_lang',''),(1617,'auth_shibboleth','field_updatelocal_lang','oncreate'),(1618,'auth_shibboleth','field_lock_lang','unlocked'),(1619,'auth_shibboleth','field_map_description',''),(1620,'auth_shibboleth','field_updatelocal_description','oncreate'),(1621,'auth_shibboleth','field_lock_description','unlocked'),(1622,'auth_shibboleth','field_map_idnumber',''),(1623,'auth_shibboleth','field_updatelocal_idnumber','oncreate'),(1624,'auth_shibboleth','field_lock_idnumber','unlocked'),(1625,'auth_shibboleth','field_map_institution',''),(1626,'auth_shibboleth','field_updatelocal_institution','oncreate'),(1627,'auth_shibboleth','field_lock_institution','unlocked'),(1628,'auth_shibboleth','field_map_department',''),(1629,'auth_shibboleth','field_updatelocal_department','oncreate'),(1630,'auth_shibboleth','field_lock_department','unlocked'),(1631,'auth_shibboleth','field_map_phone1',''),(1632,'auth_shibboleth','field_updatelocal_phone1','oncreate'),(1633,'auth_shibboleth','field_lock_phone1','unlocked'),(1634,'auth_shibboleth','field_map_phone2',''),(1635,'auth_shibboleth','field_updatelocal_phone2','oncreate'),(1636,'auth_shibboleth','field_lock_phone2','unlocked'),(1637,'auth_shibboleth','field_map_address',''),(1638,'auth_shibboleth','field_updatelocal_address','oncreate'),(1639,'auth_shibboleth','field_lock_address','unlocked'),(1640,'auth_shibboleth','field_map_firstnamephonetic',''),(1641,'auth_shibboleth','field_updatelocal_firstnamephonetic','oncreate'),(1642,'auth_shibboleth','field_lock_firstnamephonetic','unlocked'),(1643,'auth_shibboleth','field_map_lastnamephonetic',''),(1644,'auth_shibboleth','field_updatelocal_lastnamephonetic','oncreate'),(1645,'auth_shibboleth','field_lock_lastnamephonetic','unlocked'),(1646,'auth_shibboleth','field_map_middlename',''),(1647,'auth_shibboleth','field_updatelocal_middlename','oncreate'),(1648,'auth_shibboleth','field_lock_middlename','unlocked'),(1649,'auth_shibboleth','field_map_alternatename',''),(1650,'auth_shibboleth','field_updatelocal_alternatename','oncreate'),(1651,'auth_shibboleth','field_lock_alternatename','unlocked'),(1652,'block_accessreview','whattoshow','showboth'),(1653,'block_accessreview','errordisplay','showint'),(1654,'block_accessreview','toolpage','errors'),(1655,'block_activity_results','config_showbest','3'),(1656,'block_activity_results','config_showbest_locked',''),(1657,'block_activity_results','config_showworst','0'),(1658,'block_activity_results','config_showworst_locked',''),(1659,'block_activity_results','config_usegroups','0'),(1660,'block_activity_results','config_usegroups_locked',''),(1661,'block_activity_results','config_nameformat','1'),(1662,'block_activity_results','config_nameformat_locked',''),(1663,'block_activity_results','config_gradeformat','1'),(1664,'block_activity_results','config_gradeformat_locked',''),(1665,'block_activity_results','config_decimalpoints','2'),(1666,'block_activity_results','config_decimalpoints_locked',''),(1667,'block_myoverview','displaycategories','1'),(1668,'block_myoverview','layouts','card,list,summary'),(1669,'block_myoverview','displaygroupingallincludinghidden','0'),(1670,'block_myoverview','displaygroupingall','1'),(1671,'block_myoverview','displaygroupinginprogress','1'),(1672,'block_myoverview','displaygroupingpast','1'),(1673,'block_myoverview','displaygroupingfuture','1'),(1674,'block_myoverview','displaygroupingcustomfield','0'),(1675,'block_myoverview','customfiltergrouping',''),(1676,'block_myoverview','displaygroupingfavourites','1'),(1677,'block_myoverview','displaygroupinghidden','1'),(1678,'block_recentlyaccessedcourses','displaycategories','1'),(1679,'block_section_links','numsections1','22'),(1680,'block_section_links','incby1','2'),(1681,'block_section_links','numsections2','40'),(1682,'block_section_links','incby2','5'),(1683,'block_section_links','showsectionname','0'),(1684,'block_starredcourses','displaycategories','1'),(1685,'block_tag_youtube','apikey',''),(1686,'format_singleactivity','activitytype','forum'),(1687,'format_topics','indentation','1'),(1688,'format_weeks','indentation','1'),(1689,'fileconverter_googledrive','issuerid',''),(1690,'enrol_cohort','roleid','5'),(1691,'enrol_cohort','unenrolaction','0'),(1692,'enrol_meta','nosyncroleids',''),(1693,'enrol_meta','syncall','1'),(1694,'enrol_meta','unenrolaction','3'),(1695,'enrol_meta','coursesort','sortorder'),(1696,'enrol_fee','expiredaction','3'),(1697,'enrol_fee','status','1'),(1698,'enrol_fee','cost','0'),(1699,'enrol_fee','currency','USD'),(1700,'enrol_fee','roleid','5'),(1701,'enrol_fee','enrolperiod','0'),(1702,'enrol_database','dbtype',''),(1703,'enrol_database','dbhost','localhost'),(1704,'enrol_database','dbuser',''),(1705,'enrol_database','dbpass',''),(1706,'enrol_database','dbname',''),(1707,'enrol_database','dbencoding','utf-8'),(1708,'enrol_database','dbsetupsql',''),(1709,'enrol_database','dbsybasequoting','0'),(1710,'enrol_database','debugdb','0'),(1711,'enrol_database','localcoursefield','idnumber'),(1712,'enrol_database','localuserfield','idnumber'),(1713,'enrol_database','localrolefield','shortname'),(1714,'enrol_database','localcategoryfield','id'),(1715,'enrol_database','remoteenroltable',''),(1716,'enrol_database','remotecoursefield',''),(1717,'enrol_database','remoteuserfield',''),(1718,'enrol_database','remoterolefield',''),(1719,'enrol_database','remoteotheruserfield',''),(1720,'enrol_database','defaultrole','5'),(1721,'enrol_database','ignorehiddencourses','0'),(1722,'enrol_database','unenrolaction','0'),(1723,'enrol_database','newcoursetable',''),(1724,'enrol_database','newcoursefullname','fullname'),(1725,'enrol_database','newcourseshortname','shortname'),(1726,'enrol_database','newcourseidnumber','idnumber'),(1727,'enrol_database','newcoursecategory',''),(1728,'enrol_database','defaultcategory','1'),(1729,'enrol_database','templatecourse',''),(1730,'enrol_flatfile','location',''),(1731,'enrol_flatfile','encoding','UTF-8'),(1732,'enrol_flatfile','mailstudents','0'),(1733,'enrol_flatfile','mailteachers','0'),(1734,'enrol_flatfile','mailadmins','0'),(1735,'enrol_flatfile','unenrolaction','3'),(1736,'enrol_flatfile','expiredaction','3'),(1737,'enrol_guest','requirepassword','0'),(1738,'enrol_guest','usepasswordpolicy','0'),(1739,'enrol_guest','showhint','0'),(1740,'enrol_guest','defaultenrol','1'),(1741,'enrol_guest','status','1'),(1742,'enrol_guest','status_adv',''),(1743,'enrol_imsenterprise','imsfilelocation',''),(1744,'enrol_imsenterprise','logtolocation',''),(1745,'enrol_imsenterprise','mailadmins','0'),(1746,'enrol_imsenterprise','createnewusers','0'),(1747,'enrol_imsenterprise','imsupdateusers','0'),(1748,'enrol_imsenterprise','imsdeleteusers','0'),(1749,'enrol_imsenterprise','fixcaseusernames','0'),(1750,'enrol_imsenterprise','fixcasepersonalnames','0'),(1751,'enrol_imsenterprise','imssourcedidfallback','0'),(1752,'enrol_imsenterprise','imsrolemap01','5'),(1753,'enrol_imsenterprise','imsrolemap02','3'),(1754,'enrol_imsenterprise','imsrolemap03','3'),(1755,'enrol_imsenterprise','imsrolemap04','5'),(1756,'enrol_imsenterprise','imsrolemap05','0'),(1757,'enrol_imsenterprise','imsrolemap06','4'),(1758,'enrol_imsenterprise','imsrolemap07','0'),(1759,'enrol_imsenterprise','imsrolemap08','4'),(1760,'enrol_imsenterprise','truncatecoursecodes','0'),(1761,'enrol_imsenterprise','createnewcourses','0'),(1762,'enrol_imsenterprise','updatecourses','0'),(1763,'enrol_imsenterprise','createnewcategories','0'),(1764,'enrol_imsenterprise','nestedcategories','0'),(1765,'enrol_imsenterprise','categoryidnumber','0'),(1766,'enrol_imsenterprise','categoryseparator',''),(1767,'enrol_imsenterprise','imsunenrol','0'),(1768,'enrol_imsenterprise','imscoursemapshortname','coursecode'),(1769,'enrol_imsenterprise','imscoursemapfullname','short'),(1770,'enrol_imsenterprise','imscoursemapsummary','ignore'),(1771,'enrol_imsenterprise','imsrestricttarget',''),(1772,'enrol_imsenterprise','imscapitafix','0'),(1773,'enrol_manual','expiredaction','1'),(1774,'enrol_manual','expirynotifyhour','6'),(1775,'enrol_manual','defaultenrol','1'),(1776,'enrol_manual','status','0'),(1777,'enrol_manual','roleid','5'),(1778,'enrol_manual','enrolstart','4'),(1779,'enrol_manual','enrolperiod','0'),(1780,'enrol_manual','expirynotify','0'),(1781,'enrol_manual','expirythreshold','86400'),(1782,'enrol_mnet','roleid','5'),(1783,'enrol_mnet','roleid_adv','1'),(1784,'enrol_paypal','paypalbusiness',''),(1785,'enrol_paypal','mailstudents','0'),(1786,'enrol_paypal','mailteachers','0'),(1787,'enrol_paypal','mailadmins','0'),(1788,'enrol_paypal','expiredaction','3'),(1789,'enrol_paypal','status','1'),(1790,'enrol_paypal','cost','0'),(1791,'enrol_paypal','currency','USD'),(1792,'enrol_paypal','roleid','5'),(1793,'enrol_paypal','enrolperiod','0'),(1794,'enrol_lti','emaildisplay','2'),(1795,'enrol_lti','city',''),(1796,'enrol_lti','country',''),(1797,'enrol_lti','timezone','99'),(1798,'enrol_lti','lang','en'),(1799,'enrol_lti','institution',''),(1800,'enrol_self','requirepassword','0'),(1801,'enrol_self','usepasswordpolicy','0'),(1802,'enrol_self','showhint','0'),(1803,'enrol_self','expiredaction','1'),(1804,'enrol_self','expirynotifyhour','6'),(1805,'enrol_self','defaultenrol','1'),(1806,'enrol_self','status','1'),(1807,'enrol_self','newenrols','1'),(1808,'enrol_self','groupkey','0'),(1809,'enrol_self','roleid','5'),(1810,'enrol_self','enrolperiod','0'),(1811,'enrol_self','expirynotify','0'),(1812,'enrol_self','expirythreshold','86400'),(1813,'enrol_self','longtimenosee','0'),(1814,'enrol_self','maxenrolled','0'),(1815,'enrol_self','sendcoursewelcomemessage','1'),(1816,'filter_urltolink','formats','1,4,0'),(1817,'filter_urltolink','embedimages','1'),(1818,'filter_emoticon','formats','1,4,0'),(1819,'filter_displayh5p','allowedsources',''),(1820,'filter_mathjaxloader','httpsurl','https://cdn.jsdelivr.net/npm/mathjax@2.7.9/MathJax.js'),(1821,'filter_mathjaxloader','texfiltercompatibility','0'),(1822,'filter_mathjaxloader','mathjaxconfig','\nMathJax.Hub.Config({\n    config: [\"Accessible.js\", \"Safe.js\"],\n    errorSettings: { message: [\"!\"] },\n    skipStartupTypeset: true,\n    messageStyle: \"none\"\n});\n'),(1823,'filter_mathjaxloader','additionaldelimiters',''),(1824,'filter_tex','latexpreamble','\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n'),(1825,'filter_tex','latexbackground','#FFFFFF'),(1826,'filter_tex','density','120'),(1827,'filter_tex','pathlatex','/usr/bin/latex'),(1828,'filter_tex','pathdvips','/usr/bin/dvips'),(1829,'filter_tex','pathconvert','/usr/bin/convert'),(1830,'filter_tex','pathdvisvgm','/usr/bin/dvisvgm'),(1831,'filter_tex','pathmimetex',''),(1832,'filter_tex','convertformat','gif'),(1833,'logstore_database','dbdriver',''),(1834,'logstore_database','dbhost',''),(1835,'logstore_database','dbuser',''),(1836,'logstore_database','dbpass',''),(1837,'logstore_database','dbname',''),(1838,'logstore_database','dbtable',''),(1839,'logstore_database','dbpersist','0'),(1840,'logstore_database','dbsocket',''),(1841,'logstore_database','dbport',''),(1842,'logstore_database','dbschema',''),(1843,'logstore_database','dbcollation',''),(1844,'logstore_database','dbhandlesoptions','0'),(1845,'logstore_database','buffersize','50'),(1846,'logstore_database','jsonformat','1'),(1847,'logstore_database','logguests','0'),(1848,'logstore_database','includelevels','1,2,0'),(1849,'logstore_database','includeactions','c,r,u,d'),(1850,'logstore_legacy','loglegacy','0'),(1851,'logstore_standard','logguests','1'),(1852,'logstore_standard','jsonformat','1'),(1853,'logstore_standard','loglifetime','0'),(1854,'logstore_standard','buffersize','50'),(1855,'mlbackend_python','useserver','0'),(1856,'mlbackend_python','host',''),(1857,'mlbackend_python','port','0'),(1858,'mlbackend_python','secure','0'),(1859,'mlbackend_python','username','default'),(1860,'mlbackend_python','password',''),(1861,'media_videojs','videoextensions','html_video,media_source,.f4v,.flv'),(1862,'media_videojs','audioextensions','html_audio'),(1863,'media_videojs','youtube','1'),(1864,'media_videojs','videocssclass','video-js'),(1865,'media_videojs','audiocssclass','video-js'),(1866,'media_videojs','limitsize','1'),(1867,'paygw_paypal','surcharge','0'),(1868,'qtype_multichoice','answerhowmany','1'),(1869,'qtype_multichoice','shuffleanswers','1'),(1870,'qtype_multichoice','answernumbering','abc'),(1871,'editor_atto','toolbar','collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist, indent\nlinks = link\nfiles = emojipicker, image, media, recordrtc, managefiles, h5p\naccessibility = accessibilitychecker, accessibilityhelper\nstyle2 = underline, strike, subscript, superscript\nalign = align\ninsert = equation, charmap, table, clear\nundo = undo\nother = html'),(1872,'editor_atto','autosavefrequency','60'),(1873,'atto_collapse','showgroups','6'),(1874,'atto_equation','librarygroup1','\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n'),(1875,'atto_equation','librarygroup2','\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n'),(1876,'atto_equation','librarygroup3','\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n'),(1877,'atto_equation','librarygroup4','\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\\\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n'),(1878,'atto_recordrtc','allowedtypes','both'),(1879,'atto_recordrtc','audiobitrate','128000'),(1880,'atto_recordrtc','videobitrate','2500000'),(1881,'atto_recordrtc','audiotimelimit','120'),(1882,'atto_recordrtc','videotimelimit','120'),(1883,'atto_table','allowborders','0'),(1884,'atto_table','allowbackgroundcolour','0'),(1885,'atto_table','allowwidth','0'),(1886,'editor_tinymce','customtoolbar','wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen'),(1887,'editor_tinymce','fontselectlist','Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings'),(1888,'editor_tinymce','customconfig',''),(1889,'tinymce_moodleemoticon','requireemoticon','1'),(1890,'tinymce_spellchecker','spellengine',''),(1891,'tinymce_spellchecker','spelllanguagelist','+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv'),(1892,'tool_mobile','apppolicy',''),(1893,'tool_mobile','typeoflogin','1'),(1894,'tool_mobile','qrcodetype','2'),(1895,'tool_mobile','qrkeyttl','600'),(1896,'tool_mobile','forcedurlscheme','moodlemobile'),(1897,'tool_mobile','minimumversion',''),(1898,'tool_mobile','autologinmintimebetweenreq','360'),(1899,'tool_mobile','enablesmartappbanners','0'),(1900,'tool_mobile','iosappid','633359593'),(1901,'tool_mobile','androidappid','com.moodle.moodlemobile'),(1902,'tool_mobile','setuplink','https://download.moodle.org/mobile'),(1903,'tool_mobile','forcelogout','0'),(1904,'tool_mobile','disabledfeatures',''),(1905,'tool_mobile','custommenuitems',''),(1906,'tool_mobile','filetypeexclusionlist',''),(1907,'tool_mobile','customlangstrings',''),(1908,'tool_moodlenet','defaultmoodlenetname','MoodleNet Central'),(1909,'tool_moodlenet','defaultmoodlenet','https://moodle.net'),(1910,'hub','site_policyagreed','1'),(1911,'hub','site_language','en'),(1912,'hub','site_countrycode','IN'),(1913,'hub','site_privacy','notdisplayed'),(1914,'hub','site_contactemail','charmiwebcare@gmail.com'),(1915,'hub','site_contactable','0'),(1916,'hub','site_emailalert','0'),(1917,'hub','site_commnews','0'),(1918,'hub','site_contactname','Admin User'),(1919,'hub','site_name','Learning Management System'),(1920,'hub','site_description',''),(1921,'hub','site_imageurl',''),(1922,'hub','site_contactphone',''),(1923,'hub','site_regioncode','-'),(1924,'hub','site_geolocation',''),(1925,'hub','site_street',''),(1926,'hub','site_regupdateversion','2020022600'),(1927,'theme_academi','version','2024041700'),(1929,'theme_academi','logo','/logo.png'),(1930,'theme_academi','favicon','/sitelogo-removebg-preview.png'),(1931,'theme_academi','primarycolor','#FF4B00'),(1932,'theme_academi','secondarycolor','#f16521'),(1933,'theme_academi','themestyleheader','1'),(1934,'theme_academi','pagesize','container'),(1935,'theme_academi','pagesizecustomval','0'),(1936,'theme_academi','fontsize','16'),(1937,'theme_academi','availablecoursetype','1'),(1938,'theme_academi','comboListboxType','1'),(1939,'theme_academi','loginbg','/Mountain_GettyImages-516017101.jpg'),(1940,'theme_academi','backToTop_status','1'),(1941,'theme_academi','customcss',''),(1942,'theme_academi','preset','default.scss'),(1943,'theme_academi','presetfiles',''),(1944,'theme_academi','toggleslideshow','1'),(1945,'theme_academi','autoslideshow','1'),(1946,'theme_academi','slideinterval','3500'),(1947,'theme_academi','slideOverlay','0.4'),(1948,'theme_academi','numberofslides','3'),(1949,'theme_academi','pcoursestatus','1'),(1950,'theme_academi','promotedtitle','lang:promotedtitledefault'),(1951,'theme_academi','promotedcoursedesc','lang:description_default'),(1952,'theme_academi','promotedcourses',''),(1953,'theme_academi','sitefblockstatus','0'),(1954,'theme_academi','sitefeaturetitle','lang:sitefeaturesdefault'),(1955,'theme_academi','sitefeaturedesc','lang:description_default'),(1956,'theme_academi','numberofsitefeature','4'),(1957,'theme_academi','mspotstatus','0'),(1958,'theme_academi','mspottitle','lang:aboutus'),(1959,'theme_academi','mspotdesc','lang:description_default'),(1960,'theme_academi','mspotcontent','<p> Ipsum in aspernatur ut possimus sint. Quia omnis est occaecati possimus ea. Quas molestiae perspiciatis occaecati qui rerum. Deleniti quod porro sed quisquam saepe. Numquam mollitia recusandae non ad at et a. </p> <p> Ad vitae recusandae odit possimus. Quaerat cum ipsum corrupti. Odit qui asperiores ea corporis deserunt veritatis quidem expedita perferendis. Qui rerum eligendi ex doloribus quia sit. Porro rerum eum eum. </p> <p> Ad vitae recusandae odit possimus. Quaerat cum ipsum corrupti. Odit qui asperiores ea corporis deserunt veritatis quidem expedita perferendis.</p>'),(1961,'theme_academi','mspotmedia','/mspotmedia.png'),(1962,'theme_academi','jumbotronstatus','0'),(1963,'theme_academi','jumbotrontitle','lang:learnanytime'),(1964,'theme_academi','jumbotrondesc','lang:learnanytimedesc'),(1965,'theme_academi','jumbotronbtntext','lang:viewallcourses'),(1966,'theme_academi','jumbotronbtnlink','http://www.example.com/'),(1967,'theme_academi','jumbotronbtntarget','1'),(1968,'theme_academi','footerbgimg',''),(1969,'theme_academi','footerbgOverlay','0.4'),(1970,'theme_academi','copyright_footer','Copyright &copy; 2017 - Developed by <a href=\"http://lmsace.com\">LMSACE.com</a>. Powered by <a href=\"https://moodle.org\">Moodle</a>'),(1971,'theme_academi','footerb1_status','1'),(1972,'theme_academi','footerbtitle1',''),(1973,'theme_academi','footlogostatus','1'),(1974,'theme_academi','footerlogo','/footerlogo.png'),(1975,'theme_academi','footnote','<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and tronic typesetting, sheets taining Lorem Ipsum passages.<br><a href=\"#\">Read More »</a></p>'),(1976,'theme_academi','footerb2_status','1'),(1977,'theme_academi','footerbtitle2','lang:footerbtitle2default'),(1978,'theme_academi','infolink','community|https://moodle.org Moodle free\r\nsupport|https://moodle.org/support\r\ndevelopment|https://moodle.org/development\r\n Docs|http://docs.moodle.org|Moodle Docs\r\nMoodle.com|http://moodle.com/'),(1979,'theme_academi','footerb3_status','1'),(1980,'theme_academi','footerbtitle3','lang:footerbtitle3default'),(1981,'theme_academi','address','308 Negra Narrow Lane, Albeeze, New york, 87104'),(1982,'theme_academi','emailid','info@example.com'),(1983,'theme_academi','phoneno','(000) 123-456'),(1984,'theme_academi','footerb4_status','1'),(1985,'theme_academi','footerbtitle4','lang:footerbtitle4default'),(1986,'theme_academi','numofsocialmedia','4'),(1987,'theme_academi','slide1status','1'),(1988,'theme_academi','slide1image','/slide1image.jpg'),(1989,'theme_academi','slide1contentstatus','1'),(1990,'theme_academi','slide1caption','Bootstrap Based Slider - 01'),(1991,'theme_academi','slide1desc','Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.'),(1992,'theme_academi','slide1btntext','lang:knowmore'),(1993,'theme_academi','slide1btnurl','http://www.example.com/'),(1994,'theme_academi','slide1btntarget','1'),(1995,'theme_academi','slide1contFullwidth','50'),(1996,'theme_academi','slide1contentPosition','centerRight'),(1997,'theme_academi','slide2status','1'),(1998,'theme_academi','slide2image',''),(1999,'theme_academi','slide2contentstatus','1'),(2000,'theme_academi','slide2caption','Bootstrap Based Slider - 02'),(2001,'theme_academi','slide2desc','Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.'),(2002,'theme_academi','slide2btntext','lang:knowmore'),(2003,'theme_academi','slide2btnurl','http://www.example.com/'),(2004,'theme_academi','slide2btntarget','1'),(2005,'theme_academi','slide2contFullwidth','50'),(2006,'theme_academi','slide2contentPosition','centerRight'),(2007,'theme_academi','slide3status','1'),(2008,'theme_academi','slide3image',''),(2009,'theme_academi','slide3contentstatus','1'),(2010,'theme_academi','slide3caption','Bootstrap Based Slider - 03'),(2011,'theme_academi','slide3desc','Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.'),(2012,'theme_academi','slide3btntext','lang:knowmore'),(2013,'theme_academi','slide3btnurl','http://www.example.com/'),(2014,'theme_academi','slide3btntarget','1'),(2015,'theme_academi','slide3contFullwidth','50'),(2016,'theme_academi','slide3contentPosition','centerRight'),(2017,'theme_academi','sitefblock1status','1'),(2018,'theme_academi','sitefblock1title','lang:sb1_default_title'),(2019,'theme_academi','sitefblock1content','lang:sb_default_content'),(2020,'theme_academi','sitefblock1icon','lang:sitefblockicon1_default'),(2021,'theme_academi','sitefblock2status','1'),(2022,'theme_academi','sitefblock2title','lang:sb2_default_title'),(2023,'theme_academi','sitefblock2content','lang:sb_default_content'),(2024,'theme_academi','sitefblock2icon','lang:sitefblockicon2_default'),(2025,'theme_academi','sitefblock3status','1'),(2026,'theme_academi','sitefblock3title','lang:sb3_default_title'),(2027,'theme_academi','sitefblock3content','lang:sb_default_content'),(2028,'theme_academi','sitefblock3icon','lang:sitefblockicon3_default'),(2029,'theme_academi','sitefblock4status','1'),(2030,'theme_academi','sitefblock4title','lang:sb4_default_title'),(2031,'theme_academi','sitefblock4content','lang:sb_default_content'),(2032,'theme_academi','sitefblock4icon','lang:sitefblockicon4_default'),(2033,'theme_academi','socialmedia1_status','1'),(2034,'theme_academi','socialmedia1_icon','twitter'),(2035,'theme_academi','socialmedia1_url','https://twitter.com/yourtwittername'),(2036,'theme_academi','socialmedia1_iconcolor','#47caf6'),(2037,'theme_academi','socialmedia2_status','1'),(2038,'theme_academi','socialmedia2_icon','google-plus'),(2039,'theme_academi','socialmedia2_url','https://www.google.com/+yourgoogleplusid'),(2040,'theme_academi','socialmedia2_iconcolor','#e84c3d'),(2041,'theme_academi','socialmedia3_status','1'),(2042,'theme_academi','socialmedia3_icon','pinterest-p'),(2043,'theme_academi','socialmedia3_url','https://in.pinterest.com/yourpinterestname/'),(2044,'theme_academi','socialmedia3_iconcolor','#cd2129'),(2045,'theme_academi','socialmedia4_status','1'),(2046,'theme_academi','socialmedia4_icon','facebook-f'),(2047,'theme_academi','socialmedia4_url','https://www.facebook.com/yourfacebookid'),(2048,'theme_academi','socialmedia4_iconcolor','#3598dc'),(2049,'enrol_ldap','objectclass','(objectClass=*)'),(2050,'tool_brickfield','bfregstatus','0'),(2051,'tool_brickfield','bfregvalidationchecktime','1753939549'),(2052,'tool_brickfield','bfregvalidationtime','1753939549'),(2053,'tool_brickfield','bfsummarytime','1753939549'),(2054,'tool_brickfield','key',''),(2055,'tool_brickfield','hash',''),(2056,'tool_brickfield','id','0'),(2057,'core_plugin','recentfetch','1753962901'),(2058,'core_plugin','recentresponse','{\"status\":\"OK\",\"provider\":\"https:\\/\\/download.moodle.org\\/api\\/1.3\\/updates.php\",\"apiver\":\"1.3\",\"timegenerated\":1753962901,\"ticket\":\"JUM5JTkxZyVGOTglODR4JTdCJUIzJTk2JThBJUQ3JUIzMiUxMSVFMyUxQSVDOCU5OSVBM1dvJUNFcCU3QiVFQiVBRUJsJUE4eSU1RSU4Q0UlMUIlODUlN0IlOEQlODlM\",\"forbranch\":\"4.0\",\"forversion\":\"2022041912\",\"updates\":{\"core\":[{\"version\":2022041912,\"release\":\"4.0.12 (Build: 20231211)\",\"branch\":\"4.00\",\"maturity\":200,\"date\":1702002088,\"url\":\"https:\\/\\/download.moodle.org\",\"download\":\"https:\\/\\/download.moodle.org\\/download.php\\/direct\\/stable400\\/moodle-4.0.12.zip\",\"norelease_index_info\":{\"version\":\"4.0.11+\",\"branch\":\"MOODLE_400_STABLE\",\"githash\":\"182db06\",\"date\":1701962538,\"zip\":{\"size\":82094758,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":62206690,\"md5\":true,\"sha256\":true}},\"release_index_info\":{\"version\":\"4.0.12\",\"branch\":\"MOODLE_400_STABLE\",\"githash\":\"b5f4e0c\",\"date\":1702002088,\"zip\":{\"size\":82094753,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":62217661,\"md5\":true,\"sha256\":true}},\"windows\":{\"size\":210675977}},{\"version\":2025041401.0699999,\"release\":\"5.0.1+ (Build: 20250725)\",\"branch\":\"5.00\",\"maturity\":200,\"date\":1749184325,\"url\":\"https:\\/\\/download.moodle.org\",\"download\":\"https:\\/\\/download.moodle.org\\/download.php\\/direct\\/stable500\\/moodle-latest-500.zip\",\"norelease_index_info\":{\"version\":\"5.0.1+\",\"branch\":\"MOODLE_500_STABLE\",\"githash\":\"5780da5\",\"date\":1753416851,\"zip\":{\"size\":97410751,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":74212925,\"md5\":true,\"sha256\":true}},\"release_index_info\":{\"version\":\"5.0.1\",\"branch\":\"MOODLE_500_STABLE\",\"githash\":\"ffb6475\",\"date\":1749184325,\"zip\":{\"size\":97338564,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":74150641,\"md5\":true,\"sha256\":true}},\"windows\":{\"size\":240019322}},{\"version\":2024080500,\"release\":\"4.5dev (Build: 20240802)\",\"branch\":\"4.05\",\"maturity\":50,\"date\":1749184343,\"url\":\"https:\\/\\/download.moodle.org\",\"download\":\"https:\\/\\/download.moodle.org\\/download.php\\/direct\\/stable405\\/moodle-latest-405.zip\",\"norelease_index_info\":{\"version\":\"4.5.5+\",\"branch\":\"MOODLE_405_STABLE\",\"githash\":\"51662cb\",\"date\":1753416876,\"zip\":{\"size\":97821035,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":74415360,\"md5\":true,\"sha256\":true}},\"release_index_info\":{\"version\":\"4.5.5\",\"branch\":\"MOODLE_405_STABLE\",\"githash\":\"812ef23\",\"date\":1749184343,\"zip\":{\"size\":97771835,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":74387794,\"md5\":true,\"sha256\":true}},\"windows\":{\"size\":240441795}},{\"version\":2022112819.0599999,\"release\":\"4.1.19+ (Build: 20250725)\",\"branch\":\"4.01\",\"maturity\":200,\"date\":1749183976,\"url\":\"https:\\/\\/download.moodle.org\",\"download\":\"https:\\/\\/download.moodle.org\\/download.php\\/direct\\/stable401\\/moodle-latest-401.zip\",\"norelease_index_info\":{\"version\":\"4.1.19+\",\"branch\":\"MOODLE_401_STABLE\",\"githash\":\"206a64a\",\"date\":1753416896,\"zip\":{\"size\":85921044,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":65157374,\"md5\":true,\"sha256\":true}},\"release_index_info\":{\"version\":\"4.1.19\",\"branch\":\"MOODLE_401_STABLE\",\"githash\":\"a0a0458\",\"date\":1749183976,\"zip\":{\"size\":85905926,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":65154885,\"md5\":true,\"sha256\":true}},\"windows\":{\"size\":218112560}},{\"version\":2023100912,\"release\":\"4.3.12 (Build: 20250414)\",\"branch\":\"4.03\",\"maturity\":200,\"date\":1744509120,\"url\":\"https:\\/\\/download.moodle.org\",\"download\":\"https:\\/\\/download.moodle.org\\/download.php\\/direct\\/stable403\\/moodle-4.3.12.zip\",\"norelease_index_info\":{\"version\":\"4.3.11+\",\"branch\":\"MOODLE_403_STABLE\",\"githash\":\"75b6858\",\"date\":1744383746,\"zip\":{\"size\":89141921,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":68244862,\"md5\":true,\"sha256\":true}},\"release_index_info\":{\"version\":\"4.3.12\",\"branch\":\"MOODLE_403_STABLE\",\"githash\":\"73fc31d\",\"date\":1744509120,\"zip\":{\"size\":89141919,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":68246296,\"md5\":true,\"sha256\":true}},\"windows\":{\"size\":231752897}},{\"version\":2024100705.0699999,\"release\":\"4.5.5+ (Build: 20250725)\",\"branch\":\"4.05\",\"maturity\":200,\"date\":1749184343,\"url\":\"https:\\/\\/download.moodle.org\",\"download\":\"https:\\/\\/download.moodle.org\\/download.php\\/direct\\/stable405\\/moodle-latest-405.zip\",\"norelease_index_info\":{\"version\":\"4.5.5+\",\"branch\":\"MOODLE_405_STABLE\",\"githash\":\"51662cb\",\"date\":1753416876,\"zip\":{\"size\":97821035,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":74415360,\"md5\":true,\"sha256\":true}},\"release_index_info\":{\"version\":\"4.5.5\",\"branch\":\"MOODLE_405_STABLE\",\"githash\":\"812ef23\",\"date\":1749184343,\"zip\":{\"size\":97771835,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":74387794,\"md5\":true,\"sha256\":true}},\"windows\":{\"size\":240441795}},{\"version\":2024042209.0599999,\"release\":\"4.4.9+ (Build: 20250725)\",\"branch\":\"4.04\",\"maturity\":200,\"date\":1749183966,\"url\":\"https:\\/\\/download.moodle.org\",\"download\":\"https:\\/\\/download.moodle.org\\/download.php\\/direct\\/stable404\\/moodle-latest-404.zip\",\"norelease_index_info\":{\"version\":\"4.4.9+\",\"branch\":\"MOODLE_404_STABLE\",\"githash\":\"4ad38cc\",\"date\":1753416887,\"zip\":{\"size\":95040277,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":72703041,\"md5\":true,\"sha256\":true}},\"release_index_info\":{\"version\":\"4.4.9\",\"branch\":\"MOODLE_404_STABLE\",\"githash\":\"662befa\",\"date\":1749183966,\"zip\":{\"size\":95023874,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":72699015,\"md5\":true,\"sha256\":true}},\"windows\":{\"size\":237646828}},{\"version\":2023042411,\"release\":\"4.2.11 (Build: 20241007)\",\"branch\":\"4.02\",\"maturity\":200,\"date\":1728110785,\"url\":\"https:\\/\\/download.moodle.org\",\"download\":\"https:\\/\\/download.moodle.org\\/download.php\\/direct\\/stable402\\/moodle-4.2.11.zip\",\"norelease_index_info\":{\"version\":\"4.2.10+\",\"branch\":\"MOODLE_402_STABLE\",\"githash\":\"6d55f45\",\"date\":1728049699,\"zip\":{\"size\":85822857,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":65432192,\"md5\":true,\"sha256\":true}},\"release_index_info\":{\"version\":\"4.2.11\",\"branch\":\"MOODLE_402_STABLE\",\"githash\":\"823f673\",\"date\":1728110785,\"zip\":{\"size\":85822989,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":65432558,\"md5\":true,\"sha256\":true}},\"windows\":{\"size\":226205713}},{\"version\":2025072500,\"release\":\"5.1dev (Build: 20250725)\",\"branch\":\"5.01\",\"maturity\":50,\"date\":1753416822,\"url\":\"https:\\/\\/download.moodle.org\",\"download\":\"https:\\/\\/download.moodle.org\\/download.php\\/direct\\/moodle\\/moodle-latest.zip\",\"norelease_index_info\":{\"version\":\"5.1dev\",\"branch\":\"main\",\"githash\":\"a1e5573\",\"date\":1753416822,\"zip\":{\"size\":98125099,\"md5\":true,\"sha256\":true},\"tgz\":{\"size\":74314272,\"md5\":true,\"sha256\":true}},\"windows\":{\"size\":240129287}}],\"theme_academi\":[{\"version\":\"2024041700\",\"release\":\"v4.3.3\",\"maturity\":200,\"url\":\"https:\\/\\/moodle.org\\/plugins\\/pluginversion.php?id=31699\",\"download\":\"https:\\/\\/moodle.org\\/plugins\\/download.php\\/31699\\/theme_academi_moodle43_2024041700.zip\",\"downloadmd5\":\"f32baec4dcf34a5373026cda0cfdeb5f\"}]}}'),(2059,'block_html','version','2022041900'),(2060,'ltiservice_platform','9XzBb1UywunQdea','{\"clientid\":\"9XzBb1UywunQdea\",\"issuer\":\"https://global.prod.integration.skillbuilder.aws/\",\"deploymentid\":\"1\",\"authrequesturl\":\"https://lms.techgigs.in/Trainocate/mod/lti/auth.php\",\"accesstokenurl\":\"https://lms.techgigs.in/Trainocate/mod/lti/token.php\",\"keyseturl\":\"https://lms.techgigs.in/Trainocate/mod/lti/certs.php\"}'),(2061,'mod_lti','version','2022041900'),(2062,'mod_lti','kid','61ef2983180c3bc83f20'),(2063,'mod_lti','privatekey','-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC0E2Hfz10P1ovs\nX3B3uLX/dVI4HCTFf0H6PFYHGTsoUb0ffXYrCByqNKmCbMlc9rDeGBs3vKiPMB6d\nSEerRgSyBnr24qgfL7xJI6A+Roq2Et5U2lVNKPQ5Aby86Td5X0IOtNfQGgTSpniv\n4xUf7m/ZQ8rE0XAzpBf7Wfo/eXd27YvJ1zr6nsYwdKXz0AOyEHnrhXC6PyW7IV29\nfPiVK+wMVDfuWsPI3l4Hz2OUYPil3rNWJd10BYHSKwkKOV4f849bOmYzwc5mkR9p\n4BpzkV3z33KzyOkZ38W8+AUWzzpBt5qDQw4D/OlFnFTcCp7K2qZ2qDWb5W1IzKbj\n0bRpV8j/AgMBAAECggEAMCvVLVVf7Do08RTw1Z38VauRRIBG1+w8fo/AZaK6wATp\npjBeOZGwdVmkFMc8MJmvY6IoOcdGghNZxTJONcODwwnXwA6O8dTHtfsJRU+CkMVI\nY4OKeRshBdTwo8pxdA7m8V8wMjOboaw1sbt57bJPilvHtNHgBXh6j9sYhf1c11uu\nZ+LxVxyFAYfHG46jMUw2fXF1eMU2Q1BagXRZ/g8Hg4uI431OHcPiQwqgAl+XgVmv\njg22Y/8dMeKlK8uLlboMktJPnPVh1z3CHZReQvSdFpYkrLxggvCCsfUUS1DkI6QF\nIDPJSiUxy5p0Nrn7x52qMFcn3zJSlCH7DxL8q3g54QKBgQDfetzaEn9VwgBii2ph\nYtk+KgqaXDjG+Y/EvL2CTFZCk+TeKPg5RS69IOxxWSBRGwechcJLSMLAJZBCjyEG\nI0kYIZv9NfR6aNseRIX7jxYRU239yemH1S7GT1B5GlLPa5oa7joSus9Iel8Qnsn8\nh1KgVHX0UQ2WYit0B6FJGB653wKBgQDOR50HtTbHe3XtC4P9EEgB2v2je3XdjCMk\nLD4udQkRe0CjkDcVR2aHcaObqWzi9bvDJ23lRlzPwDfBoj2cSQMRaZqFAl9lz7R7\nCnZQDb4CXScIRjlXThDUowWW1Hr3Dew/jiEmA11sGOIi6CtbtD9JF6Bjw2HVmDqo\nmtfeDE8U4QKBgQDJkiAx8g04ZMvEFsvVGzunfnQh1py/m8m5QiQMqp4DXzJHz9xU\ni7okjNW3RxSHE0JCQ8OD9BT1CuybnE3FI36CbY4tTcU9w+Yf3t6aj+zvo7jJ+JzT\nD84owNFs6flXbU6Ki+WFj0n3raihbRfy1nwIcSYTQChpRBK9jUREkaTlMQKBgBGu\nzeVFQYbkLH2/iPb+mE2gajHDeZ0eUDzflg0Bd1+KQ0ZCLJakYkOmGDJV2cGy8v+N\nt7v5xicBAUaWE9X75Elv1hEk3OyrW3tYsD+4jdtCBQCOlIfJZ2Py/Z2qZUgcZ24j\nTvAlRbLohyoa4OyhjPNFFTi4HQDkZdLiQzMDtxvBAoGAdMnvi3CwuvUpxv/qHiFn\n/zNKibdlsiE6L3oI1YNsyc7DxFUcILQdBS6gp93jR8xX9jxsyfdwlL4tabHD6zMN\nddchLI0Bm+7T043lXvxHh95KCcafhaDxBEN67Q0+0DN9VrG3aJ7EaXcxCRUDzCAR\nuRhJTOvsFOatW+CGNr1kJdo=\n-----END PRIVATE KEY-----\n'),(2064,'theme_boost','themerev','1754980029'),(2066,'tool_dataprivacy','dporoles',''),(2068,'backup','backup_encryptkey','UyEMCq2hcPKsLHpuKJ555GUxZNYoQjQv6A2tK2KJ2Rs='),(2069,'local_welcome','version','2025082900'),(2070,'local_custompage','version','2025082901'),(2071,'local_enrollmentmailer_v2','version','2025090100'),(2072,'local_enrollmentmailer_v2','enableenrollmentmail','0'),(2073,'local_enrollmentmailer_v2','enrollmentmailsubject','Course Enrollment Notification'),(2074,'local_enrollmentmailer_v2','enrollmentmailbody','Hello [[user_name]],<br>You have been enrolled in:<br>[[enrollments]]<br><br>Login: [[login_url]]'),(2075,'local_enrollmentmailer_v2','enableremindermail','0'),(2076,'local_enrollmentmailer_v2','remindermailsubject','Course Reminder'),(2077,'local_enrollmentmailer_v2','remindermailbody','Hello [[user_name]],<br>This is a reminder for your courses:<br>[[enrollments]]'),(2078,'local_enrollmentmailer','enable_enrollment','1'),(2079,'local_enrollmentmailer','enrollment_subject','Welcome to [[enrollments]]'),(2080,'local_enrollmentmailer','enrollment_body','<p dir=\"ltr\">Hello [[user_name]],&lt;br&gt;&lt;br&gt;</p><p dir=\"ltr\">You have been successfully enrolled in the course: &lt;b&gt;[[enrollments]]&lt;/b&gt;.&lt;br&gt;</p><p dir=\"ltr\">You can access your course &lt;a href=\"[[course_link]]\"&gt;here&lt;/a&gt;.&lt;br&gt;&lt;br&gt;</p><p dir=\"ltr\">Thank you,&lt;br&gt;</p><p dir=\"ltr\">[[site_name]] Team</p><p><br></p>'),(2081,'local_enrollmentmailer','enable_reminder','0'),(2082,'local_enrollmentmailer','reminder_subject',''),(2083,'local_enrollmentmailer','reminder_body',''),(2084,'local_enrolnotify','version','2025090300'),(2086,'local_ltiprogress','version','2025090904');
/*!40000 ALTER TABLE `mdl_config_plugins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_contentbank_content`
--

DROP TABLE IF EXISTS `mdl_contentbank_content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_contentbank_content` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contenttype` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contextid` bigint NOT NULL,
  `visibility` tinyint(1) NOT NULL DEFAULT '1',
  `instanceid` bigint DEFAULT NULL,
  `configdata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `usercreated` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_contcont_nam_ix` (`name`),
  KEY `mdl_contcont_conconins_ix` (`contextid`,`contenttype`,`instanceid`),
  KEY `mdl_contcont_con_ix` (`contextid`),
  KEY `mdl_contcont_use_ix` (`usermodified`),
  KEY `mdl_contcont_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table stores content data in the content bank.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_contentbank_content`
--

LOCK TABLES `mdl_contentbank_content` WRITE;
/*!40000 ALTER TABLE `mdl_contentbank_content` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_contentbank_content` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_context`
--

DROP TABLE IF EXISTS `mdl_context`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_context` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextlevel` bigint NOT NULL DEFAULT '0',
  `instanceid` bigint NOT NULL DEFAULT '0',
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `depth` tinyint NOT NULL DEFAULT '0',
  `locked` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_cont_conins_uix` (`contextlevel`,`instanceid`),
  KEY `mdl_cont_ins_ix` (`instanceid`),
  KEY `mdl_cont_pat_ix` (`path`)
) ENGINE=InnoDB AUTO_INCREMENT=3691 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='one of these must be set';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_context`
--

LOCK TABLES `mdl_context` WRITE;
/*!40000 ALTER TABLE `mdl_context` DISABLE KEYS */;
INSERT INTO `mdl_context` VALUES (1,10,0,'/1',1,0),(2,50,1,'/1/2',2,0),(3,40,1,'/1/3',2,0),(4,30,1,'/1/4',2,0),(5,30,2,'/1/5',2,0),(6,80,1,'/1/6',2,0),(7,80,2,'/1/7',2,0),(8,80,3,'/1/8',2,0),(9,80,4,'/1/9',2,0),(10,80,5,'/1/10',2,0),(16,80,11,'/1/5/16',3,0),(19,30,3,'/1/19',2,0),(25,30,4,'/1/25',2,0),(32,70,4,'/1/2/32',3,0),(34,80,22,'/1/5/34',3,0),(35,30,5,'/1/35',2,0),(36,30,6,'/1/36',2,0),(48,30,7,'/1/48',2,0),(49,30,8,'/1/49',2,0),(51,30,9,'/1/51',2,0),(52,30,10,'/1/52',2,0),(53,30,11,'/1/53',2,0),(54,30,12,'/1/54',2,0),(59,80,23,'/1/5/59',3,0),(61,30,13,'/1/61',2,0),(75,30,14,'/1/75',2,0),(82,40,5,'/1/3/82',3,0),(83,40,6,'/1/83',2,0),(84,40,7,'/1/84',2,0),(96,30,15,'/1/96',2,0),(97,30,16,'/1/97',2,0),(98,30,17,'/1/98',2,0),(99,30,18,'/1/99',2,0),(105,30,19,'/1/105',2,0),(106,30,20,'/1/106',2,0),(107,30,21,'/1/107',2,0),(108,30,22,'/1/108',2,0),(109,30,23,'/1/109',2,0),(110,30,24,'/1/110',2,0),(111,30,25,'/1/111',2,0),(112,30,26,'/1/112',2,0),(113,30,27,'/1/113',2,0),(114,30,28,'/1/114',2,0),(115,30,29,'/1/115',2,0),(116,30,30,'/1/116',2,0),(117,30,31,'/1/117',2,0),(118,30,32,'/1/118',2,0),(119,30,33,'/1/119',2,0),(120,30,34,'/1/120',2,0),(121,30,35,'/1/121',2,0),(122,30,36,'/1/122',2,0),(123,30,37,'/1/123',2,0),(124,30,38,'/1/124',2,0),(125,30,39,'/1/125',2,0),(126,30,40,'/1/126',2,0),(127,30,41,'/1/127',2,0),(128,30,42,'/1/128',2,0),(129,30,43,'/1/129',2,0),(130,30,44,'/1/130',2,0),(132,30,45,'/1/132',2,0),(140,80,38,'/1/140',2,0),(200,50,60,'/1/84/200',3,0),(201,50,61,'/1/84/201',3,0),(202,50,62,'/1/84/202',3,0),(203,50,63,'/1/84/203',3,0),(204,50,64,'/1/84/204',3,0),(205,50,65,'/1/84/205',3,0),(206,50,66,'/1/84/206',3,0),(207,50,67,'/1/84/207',3,0),(208,50,68,'/1/84/208',3,0),(209,50,69,'/1/84/209',3,0),(210,50,70,'/1/84/210',3,0),(211,50,71,'/1/84/211',3,0),(212,50,72,'/1/84/212',3,0),(213,50,73,'/1/84/213',3,0),(214,50,74,'/1/84/214',3,0),(215,50,75,'/1/84/215',3,0),(216,50,76,'/1/84/216',3,0),(217,50,77,'/1/84/217',3,0),(218,50,78,'/1/84/218',3,0),(219,50,79,'/1/84/219',3,0),(220,50,80,'/1/84/220',3,0),(221,50,81,'/1/84/221',3,0),(222,50,82,'/1/84/222',3,0),(223,50,83,'/1/84/223',3,0),(224,50,84,'/1/84/224',3,0),(225,50,85,'/1/84/225',3,0),(226,50,86,'/1/84/226',3,0),(227,50,87,'/1/84/227',3,0),(228,50,88,'/1/84/228',3,0),(229,50,89,'/1/84/229',3,0),(230,50,90,'/1/84/230',3,0),(231,50,91,'/1/84/231',3,0),(232,50,92,'/1/84/232',3,0),(233,50,93,'/1/84/233',3,0),(234,50,94,'/1/84/234',3,0),(235,50,95,'/1/84/235',3,0),(236,50,96,'/1/84/236',3,0),(237,50,97,'/1/84/237',3,0),(238,50,98,'/1/84/238',3,0),(239,50,99,'/1/84/239',3,0),(240,50,100,'/1/84/240',3,0),(241,50,101,'/1/84/241',3,0),(242,50,102,'/1/84/242',3,0),(243,50,103,'/1/84/243',3,0),(244,50,104,'/1/84/244',3,0),(245,50,105,'/1/84/245',3,0),(246,50,106,'/1/84/246',3,0),(247,50,107,'/1/84/247',3,0),(248,50,108,'/1/84/248',3,0),(249,50,109,'/1/84/249',3,0),(250,50,110,'/1/84/250',3,0),(251,50,111,'/1/84/251',3,0),(252,50,112,'/1/84/252',3,0),(253,50,113,'/1/84/253',3,0),(254,50,114,'/1/84/254',3,0),(255,50,115,'/1/84/255',3,0),(256,50,116,'/1/84/256',3,0),(257,50,117,'/1/84/257',3,0),(258,50,118,'/1/84/258',3,0),(259,50,119,'/1/84/259',3,0),(260,50,120,'/1/84/260',3,0),(261,50,121,'/1/84/261',3,0),(262,50,122,'/1/84/262',3,0),(263,50,123,'/1/84/263',3,0),(264,50,124,'/1/84/264',3,0),(265,50,125,'/1/84/265',3,0),(266,50,126,'/1/84/266',3,0),(267,50,127,'/1/84/267',3,0),(268,50,128,'/1/84/268',3,0),(269,50,129,'/1/84/269',3,0),(270,50,130,'/1/84/270',3,0),(271,50,131,'/1/84/271',3,0),(272,50,132,'/1/84/272',3,0),(273,50,133,'/1/84/273',3,0),(274,50,134,'/1/84/274',3,0),(275,50,135,'/1/84/275',3,0),(276,50,136,'/1/84/276',3,0),(277,50,137,'/1/84/277',3,0),(278,50,138,'/1/84/278',3,0),(279,50,139,'/1/84/279',3,0),(280,50,140,'/1/84/280',3,0),(281,50,141,'/1/84/281',3,0),(282,50,142,'/1/84/282',3,0),(283,50,143,'/1/84/283',3,0),(284,50,144,'/1/84/284',3,0),(285,50,145,'/1/84/285',3,0),(286,50,146,'/1/84/286',3,0),(287,50,147,'/1/84/287',3,0),(288,50,148,'/1/84/288',3,0),(289,50,149,'/1/84/289',3,0),(290,50,150,'/1/84/290',3,0),(291,50,151,'/1/84/291',3,0),(292,50,152,'/1/84/292',3,0),(293,50,153,'/1/84/293',3,0),(294,50,154,'/1/84/294',3,0),(295,50,155,'/1/84/295',3,0),(296,50,156,'/1/84/296',3,0),(297,50,157,'/1/84/297',3,0),(298,50,158,'/1/84/298',3,0),(299,50,159,'/1/84/299',3,0),(300,50,160,'/1/84/300',3,0),(301,50,161,'/1/84/301',3,0),(302,50,162,'/1/84/302',3,0),(303,50,163,'/1/84/303',3,0),(304,50,164,'/1/84/304',3,0),(305,50,165,'/1/84/305',3,0),(306,50,166,'/1/84/306',3,0),(307,50,167,'/1/84/307',3,0),(308,50,168,'/1/84/308',3,0),(309,50,169,'/1/84/309',3,0),(310,50,170,'/1/84/310',3,0),(311,50,171,'/1/84/311',3,0),(312,50,172,'/1/84/312',3,0),(313,50,173,'/1/84/313',3,0),(314,50,174,'/1/84/314',3,0),(315,50,175,'/1/84/315',3,0),(316,50,176,'/1/84/316',3,0),(317,50,177,'/1/84/317',3,0),(318,50,178,'/1/84/318',3,0),(319,50,179,'/1/84/319',3,0),(320,50,180,'/1/84/320',3,0),(321,50,181,'/1/84/321',3,0),(322,50,182,'/1/84/322',3,0),(323,50,183,'/1/84/323',3,0),(324,50,184,'/1/84/324',3,0),(325,50,185,'/1/84/325',3,0),(326,50,186,'/1/84/326',3,0),(327,50,187,'/1/84/327',3,0),(328,50,188,'/1/84/328',3,0),(329,50,189,'/1/84/329',3,0),(330,50,190,'/1/84/330',3,0),(331,50,191,'/1/84/331',3,0),(332,50,192,'/1/84/332',3,0),(333,50,193,'/1/84/333',3,0),(334,50,194,'/1/84/334',3,0),(335,50,195,'/1/84/335',3,0),(336,50,196,'/1/84/336',3,0),(337,50,197,'/1/84/337',3,0),(338,50,198,'/1/84/338',3,0),(339,50,199,'/1/84/339',3,0),(340,50,200,'/1/84/340',3,0),(341,50,201,'/1/84/341',3,0),(342,50,202,'/1/84/342',3,0),(343,50,203,'/1/84/343',3,0),(344,50,204,'/1/84/344',3,0),(345,50,205,'/1/84/345',3,0),(346,50,206,'/1/84/346',3,0),(347,50,207,'/1/84/347',3,0),(348,50,208,'/1/84/348',3,0),(349,50,209,'/1/84/349',3,0),(350,50,210,'/1/84/350',3,0),(351,50,211,'/1/84/351',3,0),(352,50,212,'/1/84/352',3,0),(353,50,213,'/1/84/353',3,0),(354,50,214,'/1/84/354',3,0),(355,50,215,'/1/84/355',3,0),(356,50,216,'/1/84/356',3,0),(357,50,217,'/1/84/357',3,0),(358,50,218,'/1/84/358',3,0),(359,50,219,'/1/84/359',3,0),(360,50,220,'/1/84/360',3,0),(361,50,221,'/1/84/361',3,0),(362,50,222,'/1/84/362',3,0),(363,50,223,'/1/84/363',3,0),(364,50,224,'/1/84/364',3,0),(365,50,225,'/1/84/365',3,0),(366,50,226,'/1/84/366',3,0),(367,50,227,'/1/84/367',3,0),(368,50,228,'/1/84/368',3,0),(369,50,229,'/1/84/369',3,0),(370,50,230,'/1/84/370',3,0),(371,50,231,'/1/84/371',3,0),(372,50,232,'/1/84/372',3,0),(373,50,233,'/1/84/373',3,0),(374,50,234,'/1/84/374',3,0),(375,50,235,'/1/84/375',3,0),(376,50,236,'/1/84/376',3,0),(377,50,237,'/1/84/377',3,0),(378,50,238,'/1/84/378',3,0),(379,50,239,'/1/84/379',3,0),(380,50,240,'/1/84/380',3,0),(381,50,241,'/1/84/381',3,0),(382,50,242,'/1/84/382',3,0),(383,50,243,'/1/84/383',3,0),(384,50,244,'/1/84/384',3,0),(385,50,245,'/1/84/385',3,0),(386,50,246,'/1/84/386',3,0),(387,50,247,'/1/84/387',3,0),(388,50,248,'/1/84/388',3,0),(389,50,249,'/1/84/389',3,0),(390,50,250,'/1/84/390',3,0),(391,50,251,'/1/84/391',3,0),(392,50,252,'/1/84/392',3,0),(393,50,253,'/1/84/393',3,0),(394,50,254,'/1/84/394',3,0),(395,50,255,'/1/84/395',3,0),(396,50,256,'/1/84/396',3,0),(397,50,257,'/1/84/397',3,0),(398,50,258,'/1/84/398',3,0),(399,50,259,'/1/84/399',3,0),(400,50,260,'/1/84/400',3,0),(401,50,261,'/1/84/401',3,0),(402,50,262,'/1/84/402',3,0),(403,50,263,'/1/84/403',3,0),(404,50,264,'/1/84/404',3,0),(405,50,265,'/1/84/405',3,0),(406,50,266,'/1/84/406',3,0),(407,50,267,'/1/84/407',3,0),(408,50,268,'/1/84/408',3,0),(409,50,269,'/1/84/409',3,0),(410,50,270,'/1/84/410',3,0),(411,50,271,'/1/84/411',3,0),(412,50,272,'/1/84/412',3,0),(413,50,273,'/1/84/413',3,0),(414,50,274,'/1/84/414',3,0),(415,50,275,'/1/84/415',3,0),(416,50,276,'/1/84/416',3,0),(417,50,277,'/1/84/417',3,0),(418,50,278,'/1/84/418',3,0),(419,50,279,'/1/84/419',3,0),(420,50,280,'/1/84/420',3,0),(421,50,281,'/1/84/421',3,0),(422,50,282,'/1/84/422',3,0),(423,50,283,'/1/84/423',3,0),(424,50,284,'/1/84/424',3,0),(425,50,285,'/1/84/425',3,0),(426,50,286,'/1/84/426',3,0),(427,50,287,'/1/84/427',3,0),(428,50,288,'/1/84/428',3,0),(429,50,289,'/1/84/429',3,0),(430,50,290,'/1/84/430',3,0),(431,50,291,'/1/84/431',3,0),(432,50,292,'/1/84/432',3,0),(433,50,293,'/1/84/433',3,0),(434,50,294,'/1/84/434',3,0),(435,50,295,'/1/84/435',3,0),(436,50,296,'/1/84/436',3,0),(437,50,297,'/1/84/437',3,0),(438,50,298,'/1/84/438',3,0),(439,50,299,'/1/84/439',3,0),(440,50,300,'/1/84/440',3,0),(441,50,301,'/1/84/441',3,0),(442,50,302,'/1/84/442',3,0),(443,50,303,'/1/84/443',3,0),(444,50,304,'/1/84/444',3,0),(445,50,305,'/1/84/445',3,0),(446,50,306,'/1/84/446',3,0),(447,50,307,'/1/84/447',3,0),(448,50,308,'/1/84/448',3,0),(449,50,309,'/1/84/449',3,0),(450,50,310,'/1/84/450',3,0),(451,50,311,'/1/84/451',3,0),(452,50,312,'/1/84/452',3,0),(453,50,313,'/1/84/453',3,0),(454,50,314,'/1/84/454',3,0),(455,50,315,'/1/84/455',3,0),(456,50,316,'/1/84/456',3,0),(457,50,317,'/1/84/457',3,0),(458,50,318,'/1/84/458',3,0),(459,50,319,'/1/84/459',3,0),(460,50,320,'/1/84/460',3,0),(461,50,321,'/1/84/461',3,0),(462,50,322,'/1/84/462',3,0),(463,50,323,'/1/84/463',3,0),(464,50,324,'/1/84/464',3,0),(465,50,325,'/1/84/465',3,0),(466,50,326,'/1/84/466',3,0),(467,50,327,'/1/84/467',3,0),(468,50,328,'/1/84/468',3,0),(469,50,329,'/1/84/469',3,0),(470,50,330,'/1/84/470',3,0),(471,50,331,'/1/84/471',3,0),(472,50,332,'/1/84/472',3,0),(473,50,333,'/1/84/473',3,0),(474,50,334,'/1/84/474',3,0),(475,50,335,'/1/84/475',3,0),(476,50,336,'/1/84/476',3,0),(477,50,337,'/1/84/477',3,0),(478,50,338,'/1/84/478',3,0),(479,50,339,'/1/84/479',3,0),(480,50,340,'/1/84/480',3,0),(481,50,341,'/1/84/481',3,0),(482,50,342,'/1/84/482',3,0),(483,50,343,'/1/84/483',3,0),(484,50,344,'/1/84/484',3,0),(485,50,345,'/1/84/485',3,0),(486,50,346,'/1/84/486',3,0),(487,50,347,'/1/84/487',3,0),(488,50,348,'/1/84/488',3,0),(489,50,349,'/1/84/489',3,0),(490,50,350,'/1/84/490',3,0),(491,50,351,'/1/84/491',3,0),(492,50,352,'/1/84/492',3,0),(493,50,353,'/1/84/493',3,0),(494,50,354,'/1/84/494',3,0),(495,50,355,'/1/84/495',3,0),(496,50,356,'/1/84/496',3,0),(497,50,357,'/1/84/497',3,0),(498,50,358,'/1/84/498',3,0),(499,50,359,'/1/84/499',3,0),(500,50,360,'/1/84/500',3,0),(501,50,361,'/1/84/501',3,0),(502,50,362,'/1/84/502',3,0),(503,50,363,'/1/84/503',3,0),(504,50,364,'/1/84/504',3,0),(505,50,365,'/1/84/505',3,0),(506,50,366,'/1/84/506',3,0),(507,50,367,'/1/84/507',3,0),(508,50,368,'/1/84/508',3,0),(509,50,369,'/1/84/509',3,0),(510,50,370,'/1/84/510',3,0),(511,50,371,'/1/84/511',3,0),(512,50,372,'/1/84/512',3,0),(513,50,373,'/1/84/513',3,0),(514,50,374,'/1/84/514',3,0),(515,50,375,'/1/84/515',3,0),(516,50,376,'/1/84/516',3,0),(517,50,377,'/1/84/517',3,0),(518,50,378,'/1/84/518',3,0),(519,50,379,'/1/84/519',3,0),(520,50,380,'/1/84/520',3,0),(521,50,381,'/1/84/521',3,0),(522,50,382,'/1/84/522',3,0),(523,50,383,'/1/84/523',3,0),(524,50,384,'/1/84/524',3,0),(525,50,385,'/1/84/525',3,0),(526,50,386,'/1/84/526',3,0),(527,50,387,'/1/84/527',3,0),(528,50,388,'/1/84/528',3,0),(529,50,389,'/1/84/529',3,0),(530,50,390,'/1/84/530',3,0),(531,50,391,'/1/84/531',3,0),(532,50,392,'/1/84/532',3,0),(533,50,393,'/1/84/533',3,0),(534,50,394,'/1/84/534',3,0),(535,50,395,'/1/84/535',3,0),(536,50,396,'/1/84/536',3,0),(537,50,397,'/1/84/537',3,0),(538,50,398,'/1/84/538',3,0),(539,50,399,'/1/84/539',3,0),(540,50,400,'/1/84/540',3,0),(541,50,401,'/1/84/541',3,0),(542,50,402,'/1/84/542',3,0),(543,50,403,'/1/84/543',3,0),(544,50,404,'/1/84/544',3,0),(545,50,405,'/1/84/545',3,0),(546,50,406,'/1/84/546',3,0),(547,50,407,'/1/84/547',3,0),(548,50,408,'/1/84/548',3,0),(549,50,409,'/1/84/549',3,0),(550,50,410,'/1/84/550',3,0),(551,50,411,'/1/84/551',3,0),(552,50,412,'/1/84/552',3,0),(553,50,413,'/1/84/553',3,0),(554,50,414,'/1/84/554',3,0),(555,50,415,'/1/84/555',3,0),(556,50,416,'/1/84/556',3,0),(557,50,417,'/1/84/557',3,0),(558,50,418,'/1/84/558',3,0),(559,50,419,'/1/84/559',3,0),(560,50,420,'/1/84/560',3,0),(561,50,421,'/1/84/561',3,0),(562,50,422,'/1/84/562',3,0),(563,50,423,'/1/84/563',3,0),(564,50,424,'/1/84/564',3,0),(565,50,425,'/1/84/565',3,0),(566,50,426,'/1/84/566',3,0),(567,50,427,'/1/84/567',3,0),(568,50,428,'/1/84/568',3,0),(569,50,429,'/1/84/569',3,0),(570,50,430,'/1/84/570',3,0),(571,50,431,'/1/84/571',3,0),(572,50,432,'/1/84/572',3,0),(573,50,433,'/1/84/573',3,0),(574,50,434,'/1/84/574',3,0),(575,50,435,'/1/84/575',3,0),(576,50,436,'/1/84/576',3,0),(577,50,437,'/1/84/577',3,0),(578,50,438,'/1/84/578',3,0),(579,50,439,'/1/84/579',3,0),(580,50,440,'/1/84/580',3,0),(581,50,441,'/1/84/581',3,0),(582,50,442,'/1/84/582',3,0),(583,50,443,'/1/84/583',3,0),(584,50,444,'/1/84/584',3,0),(585,50,445,'/1/84/585',3,0),(586,50,446,'/1/84/586',3,0),(587,50,447,'/1/84/587',3,0),(588,50,448,'/1/84/588',3,0),(589,50,449,'/1/84/589',3,0),(590,50,450,'/1/84/590',3,0),(591,50,451,'/1/84/591',3,0),(592,50,452,'/1/84/592',3,0),(593,50,453,'/1/84/593',3,0),(594,50,454,'/1/84/594',3,0),(595,50,455,'/1/84/595',3,0),(596,50,456,'/1/84/596',3,0),(597,50,457,'/1/84/597',3,0),(598,50,458,'/1/84/598',3,0),(599,50,459,'/1/84/599',3,0),(600,50,460,'/1/84/600',3,0),(601,50,461,'/1/84/601',3,0),(602,50,462,'/1/84/602',3,0),(603,50,463,'/1/84/603',3,0),(604,50,464,'/1/84/604',3,0),(605,50,465,'/1/84/605',3,0),(606,50,466,'/1/84/606',3,0),(607,50,467,'/1/84/607',3,0),(608,50,468,'/1/84/608',3,0),(609,50,469,'/1/84/609',3,0),(610,50,470,'/1/84/610',3,0),(611,50,471,'/1/84/611',3,0),(612,50,472,'/1/84/612',3,0),(613,50,473,'/1/84/613',3,0),(614,50,474,'/1/84/614',3,0),(615,50,475,'/1/84/615',3,0),(616,50,476,'/1/84/616',3,0),(617,50,477,'/1/84/617',3,0),(618,50,478,'/1/84/618',3,0),(619,50,479,'/1/84/619',3,0),(620,50,480,'/1/84/620',3,0),(621,50,481,'/1/84/621',3,0),(622,50,482,'/1/84/622',3,0),(623,50,483,'/1/84/623',3,0),(624,50,484,'/1/84/624',3,0),(625,50,485,'/1/84/625',3,0),(626,50,486,'/1/84/626',3,0),(627,50,487,'/1/84/627',3,0),(628,50,488,'/1/84/628',3,0),(629,50,489,'/1/84/629',3,0),(630,50,490,'/1/84/630',3,0),(631,50,491,'/1/84/631',3,0),(632,50,492,'/1/84/632',3,0),(633,50,493,'/1/84/633',3,0),(634,50,494,'/1/84/634',3,0),(635,50,495,'/1/84/635',3,0),(636,50,496,'/1/84/636',3,0),(637,50,497,'/1/84/637',3,0),(638,50,498,'/1/84/638',3,0),(639,50,499,'/1/84/639',3,0),(640,50,500,'/1/84/640',3,0),(641,50,501,'/1/84/641',3,0),(642,50,502,'/1/84/642',3,0),(643,50,503,'/1/84/643',3,0),(644,50,504,'/1/84/644',3,0),(645,50,505,'/1/84/645',3,0),(646,50,506,'/1/84/646',3,0),(647,50,507,'/1/84/647',3,0),(648,50,508,'/1/84/648',3,0),(649,50,509,'/1/84/649',3,0),(650,50,510,'/1/84/650',3,0),(651,50,511,'/1/84/651',3,0),(652,50,512,'/1/84/652',3,0),(653,50,513,'/1/84/653',3,0),(654,50,514,'/1/84/654',3,0),(655,50,515,'/1/84/655',3,0),(656,50,516,'/1/84/656',3,0),(657,50,517,'/1/84/657',3,0),(658,50,518,'/1/84/658',3,0),(659,50,519,'/1/84/659',3,0),(660,50,520,'/1/84/660',3,0),(661,50,521,'/1/84/661',3,0),(662,50,522,'/1/84/662',3,0),(663,50,523,'/1/84/663',3,0),(664,50,524,'/1/84/664',3,0),(665,50,525,'/1/84/665',3,0),(666,50,526,'/1/84/666',3,0),(667,50,527,'/1/84/667',3,0),(668,50,528,'/1/84/668',3,0),(669,50,529,'/1/84/669',3,0),(670,50,530,'/1/84/670',3,0),(671,50,531,'/1/84/671',3,0),(672,50,532,'/1/84/672',3,0),(673,50,533,'/1/84/673',3,0),(674,50,534,'/1/84/674',3,0),(675,50,535,'/1/84/675',3,0),(676,50,536,'/1/84/676',3,0),(677,50,537,'/1/84/677',3,0),(678,50,538,'/1/84/678',3,0),(679,50,539,'/1/84/679',3,0),(680,50,540,'/1/84/680',3,0),(681,50,541,'/1/84/681',3,0),(682,50,542,'/1/84/682',3,0),(683,50,543,'/1/84/683',3,0),(684,50,544,'/1/84/684',3,0),(685,50,545,'/1/84/685',3,0),(686,50,546,'/1/84/686',3,0),(687,50,547,'/1/84/687',3,0),(688,50,548,'/1/84/688',3,0),(689,50,549,'/1/84/689',3,0),(690,50,550,'/1/84/690',3,0),(691,50,551,'/1/84/691',3,0),(692,50,552,'/1/84/692',3,0),(693,50,553,'/1/84/693',3,0),(694,50,554,'/1/84/694',3,0),(695,50,555,'/1/84/695',3,0),(696,50,556,'/1/84/696',3,0),(697,50,557,'/1/84/697',3,0),(698,50,558,'/1/84/698',3,0),(699,50,559,'/1/84/699',3,0),(700,50,560,'/1/84/700',3,0),(701,50,561,'/1/84/701',3,0),(702,50,562,'/1/84/702',3,0),(703,50,563,'/1/84/703',3,0),(704,50,564,'/1/84/704',3,0),(705,50,565,'/1/84/705',3,0),(706,50,566,'/1/84/706',3,0),(707,50,567,'/1/84/707',3,0),(708,50,568,'/1/84/708',3,0),(709,50,569,'/1/84/709',3,0),(710,50,570,'/1/84/710',3,0),(711,50,571,'/1/84/711',3,0),(712,50,572,'/1/84/712',3,0),(713,50,573,'/1/84/713',3,0),(714,50,574,'/1/84/714',3,0),(715,50,575,'/1/84/715',3,0),(716,50,576,'/1/84/716',3,0),(717,50,577,'/1/84/717',3,0),(718,50,578,'/1/84/718',3,0),(719,50,579,'/1/84/719',3,0),(720,50,580,'/1/84/720',3,0),(721,50,581,'/1/84/721',3,0),(722,50,582,'/1/84/722',3,0),(723,50,583,'/1/84/723',3,0),(724,50,584,'/1/84/724',3,0),(725,50,585,'/1/84/725',3,0),(726,50,586,'/1/84/726',3,0),(727,50,587,'/1/84/727',3,0),(728,50,588,'/1/84/728',3,0),(729,50,589,'/1/84/729',3,0),(730,50,590,'/1/84/730',3,0),(731,50,591,'/1/84/731',3,0),(732,50,592,'/1/84/732',3,0),(733,50,593,'/1/84/733',3,0),(734,50,594,'/1/84/734',3,0),(735,50,595,'/1/84/735',3,0),(736,50,596,'/1/84/736',3,0),(737,50,597,'/1/84/737',3,0),(738,50,598,'/1/84/738',3,0),(739,50,599,'/1/84/739',3,0),(740,50,600,'/1/84/740',3,0),(741,50,601,'/1/84/741',3,0),(742,50,602,'/1/84/742',3,0),(743,50,603,'/1/84/743',3,0),(744,50,604,'/1/84/744',3,0),(745,50,605,'/1/84/745',3,0),(746,50,606,'/1/84/746',3,0),(747,50,607,'/1/84/747',3,0),(748,50,608,'/1/84/748',3,0),(749,50,609,'/1/84/749',3,0),(750,50,610,'/1/84/750',3,0),(751,50,611,'/1/84/751',3,0),(752,50,612,'/1/84/752',3,0),(753,50,613,'/1/84/753',3,0),(754,50,614,'/1/84/754',3,0),(755,50,615,'/1/84/755',3,0),(756,50,616,'/1/84/756',3,0),(757,50,617,'/1/84/757',3,0),(758,50,618,'/1/84/758',3,0),(759,50,619,'/1/84/759',3,0),(760,50,620,'/1/84/760',3,0),(761,50,621,'/1/84/761',3,0),(762,50,622,'/1/84/762',3,0),(763,50,623,'/1/84/763',3,0),(764,50,624,'/1/84/764',3,0),(765,50,625,'/1/84/765',3,0),(766,50,626,'/1/84/766',3,0),(767,50,627,'/1/84/767',3,0),(768,50,628,'/1/84/768',3,0),(769,50,629,'/1/84/769',3,0),(770,50,630,'/1/84/770',3,0),(771,50,631,'/1/84/771',3,0),(772,50,632,'/1/84/772',3,0),(773,50,633,'/1/84/773',3,0),(774,50,634,'/1/84/774',3,0),(775,50,635,'/1/84/775',3,0),(776,50,636,'/1/84/776',3,0),(777,50,637,'/1/84/777',3,0),(778,50,638,'/1/84/778',3,0),(779,50,639,'/1/84/779',3,0),(780,50,640,'/1/84/780',3,0),(781,50,641,'/1/84/781',3,0),(782,50,642,'/1/84/782',3,0),(783,50,643,'/1/84/783',3,0),(784,50,644,'/1/84/784',3,0),(785,50,645,'/1/84/785',3,0),(786,50,646,'/1/84/786',3,0),(787,50,647,'/1/84/787',3,0),(788,50,648,'/1/84/788',3,0),(789,50,649,'/1/84/789',3,0),(790,50,650,'/1/84/790',3,0),(791,50,651,'/1/84/791',3,0),(792,50,652,'/1/84/792',3,0),(793,50,653,'/1/84/793',3,0),(794,50,654,'/1/84/794',3,0),(795,50,655,'/1/84/795',3,0),(796,50,656,'/1/84/796',3,0),(797,50,657,'/1/84/797',3,0),(798,50,658,'/1/84/798',3,0),(799,50,659,'/1/84/799',3,0),(800,50,660,'/1/84/800',3,0),(801,50,661,'/1/84/801',3,0),(802,50,662,'/1/84/802',3,0),(803,50,663,'/1/84/803',3,0),(804,50,664,'/1/84/804',3,0),(805,50,665,'/1/84/805',3,0),(806,50,666,'/1/84/806',3,0),(807,50,667,'/1/84/807',3,0),(808,50,668,'/1/84/808',3,0),(809,50,669,'/1/84/809',3,0),(810,50,670,'/1/84/810',3,0),(811,50,671,'/1/84/811',3,0),(812,50,672,'/1/84/812',3,0),(813,50,673,'/1/84/813',3,0),(814,50,674,'/1/84/814',3,0),(815,50,675,'/1/84/815',3,0),(816,50,676,'/1/84/816',3,0),(817,50,677,'/1/84/817',3,0),(818,50,678,'/1/84/818',3,0),(819,50,679,'/1/84/819',3,0),(820,50,680,'/1/84/820',3,0),(821,50,681,'/1/84/821',3,0),(822,50,682,'/1/84/822',3,0),(823,50,683,'/1/84/823',3,0),(824,50,684,'/1/84/824',3,0),(825,50,685,'/1/84/825',3,0),(826,50,686,'/1/84/826',3,0),(827,50,687,'/1/84/827',3,0),(828,50,688,'/1/84/828',3,0),(829,50,689,'/1/84/829',3,0),(830,50,690,'/1/84/830',3,0),(831,50,691,'/1/84/831',3,0),(832,50,692,'/1/84/832',3,0),(833,50,693,'/1/84/833',3,0),(834,50,694,'/1/84/834',3,0),(835,50,695,'/1/84/835',3,0),(836,50,696,'/1/84/836',3,0),(837,50,697,'/1/84/837',3,0),(838,50,698,'/1/84/838',3,0),(839,50,699,'/1/84/839',3,0),(840,50,700,'/1/84/840',3,0),(841,50,701,'/1/84/841',3,0),(842,50,702,'/1/84/842',3,0),(843,50,703,'/1/84/843',3,0),(844,50,704,'/1/84/844',3,0),(845,50,705,'/1/84/845',3,0),(846,50,706,'/1/84/846',3,0),(847,50,707,'/1/84/847',3,0),(848,50,708,'/1/84/848',3,0),(849,50,709,'/1/84/849',3,0),(850,50,710,'/1/84/850',3,0),(851,50,711,'/1/84/851',3,0),(852,50,712,'/1/84/852',3,0),(853,50,713,'/1/84/853',3,0),(854,50,714,'/1/84/854',3,0),(855,50,715,'/1/84/855',3,0),(856,50,716,'/1/84/856',3,0),(857,50,717,'/1/84/857',3,0),(858,50,718,'/1/84/858',3,0),(859,50,719,'/1/84/859',3,0),(860,50,720,'/1/84/860',3,0),(861,50,721,'/1/84/861',3,0),(862,50,722,'/1/84/862',3,0),(863,50,723,'/1/84/863',3,0),(864,50,724,'/1/84/864',3,0),(865,50,725,'/1/84/865',3,0),(866,50,726,'/1/84/866',3,0),(867,50,727,'/1/84/867',3,0),(868,50,728,'/1/84/868',3,0),(869,50,729,'/1/84/869',3,0),(870,50,730,'/1/84/870',3,0),(871,50,731,'/1/84/871',3,0),(872,50,732,'/1/84/872',3,0),(873,50,733,'/1/84/873',3,0),(874,50,734,'/1/84/874',3,0),(875,50,735,'/1/84/875',3,0),(876,50,736,'/1/84/876',3,0),(877,50,737,'/1/84/877',3,0),(878,50,738,'/1/84/878',3,0),(879,50,739,'/1/84/879',3,0),(880,50,740,'/1/84/880',3,0),(881,50,741,'/1/84/881',3,0),(882,50,742,'/1/84/882',3,0),(883,50,743,'/1/84/883',3,0),(884,50,744,'/1/84/884',3,0),(885,50,745,'/1/84/885',3,0),(886,50,746,'/1/84/886',3,0),(887,50,747,'/1/84/887',3,0),(888,50,748,'/1/84/888',3,0),(889,50,749,'/1/84/889',3,0),(890,50,750,'/1/84/890',3,0),(891,50,751,'/1/84/891',3,0),(892,50,752,'/1/84/892',3,0),(893,50,753,'/1/84/893',3,0),(894,50,754,'/1/84/894',3,0),(895,50,755,'/1/84/895',3,0),(896,50,756,'/1/84/896',3,0),(897,50,757,'/1/84/897',3,0),(898,50,758,'/1/84/898',3,0),(899,50,759,'/1/84/899',3,0),(900,50,760,'/1/84/900',3,0),(901,50,761,'/1/84/901',3,0),(902,50,762,'/1/84/902',3,0),(903,50,763,'/1/84/903',3,0),(904,50,764,'/1/84/904',3,0),(905,50,765,'/1/84/905',3,0),(906,50,766,'/1/84/906',3,0),(907,50,767,'/1/84/907',3,0),(908,50,768,'/1/84/908',3,0),(909,50,769,'/1/84/909',3,0),(910,50,770,'/1/84/910',3,0),(911,50,771,'/1/84/911',3,0),(912,50,772,'/1/84/912',3,0),(913,50,773,'/1/84/913',3,0),(914,50,774,'/1/84/914',3,0),(915,50,775,'/1/84/915',3,0),(916,50,776,'/1/84/916',3,0),(917,50,777,'/1/84/917',3,0),(918,50,778,'/1/84/918',3,0),(919,50,779,'/1/84/919',3,0),(920,50,780,'/1/84/920',3,0),(921,50,781,'/1/84/921',3,0),(922,50,782,'/1/84/922',3,0),(923,50,783,'/1/84/923',3,0),(924,50,784,'/1/84/924',3,0),(925,50,785,'/1/84/925',3,0),(926,50,786,'/1/84/926',3,0),(927,50,787,'/1/84/927',3,0),(928,50,788,'/1/84/928',3,0),(929,50,789,'/1/84/929',3,0),(930,50,790,'/1/84/930',3,0),(931,50,791,'/1/84/931',3,0),(932,50,792,'/1/84/932',3,0),(933,50,793,'/1/84/933',3,0),(934,50,794,'/1/84/934',3,0),(935,50,795,'/1/84/935',3,0),(936,50,796,'/1/84/936',3,0),(937,50,797,'/1/84/937',3,0),(938,50,798,'/1/84/938',3,0),(939,50,799,'/1/84/939',3,0),(940,50,800,'/1/84/940',3,0),(941,50,801,'/1/84/941',3,0),(942,50,802,'/1/84/942',3,0),(943,50,803,'/1/84/943',3,0),(944,50,804,'/1/84/944',3,0),(945,50,805,'/1/84/945',3,0),(946,50,806,'/1/84/946',3,0),(947,50,807,'/1/84/947',3,0),(948,50,808,'/1/84/948',3,0),(949,50,809,'/1/84/949',3,0),(950,50,810,'/1/84/950',3,0),(951,50,811,'/1/84/951',3,0),(952,50,812,'/1/84/952',3,0),(953,50,813,'/1/84/953',3,0),(954,50,814,'/1/84/954',3,0),(955,50,815,'/1/84/955',3,0),(956,50,816,'/1/84/956',3,0),(957,50,817,'/1/84/957',3,0),(958,50,818,'/1/84/958',3,0),(959,50,819,'/1/84/959',3,0),(960,50,820,'/1/84/960',3,0),(961,50,821,'/1/84/961',3,0),(962,50,822,'/1/84/962',3,0),(963,50,823,'/1/84/963',3,0),(964,50,824,'/1/84/964',3,0),(965,50,825,'/1/84/965',3,0),(966,50,826,'/1/84/966',3,0),(967,50,827,'/1/84/967',3,0),(968,50,828,'/1/84/968',3,0),(969,50,829,'/1/84/969',3,0),(970,50,830,'/1/84/970',3,0),(971,50,831,'/1/84/971',3,0),(972,50,832,'/1/84/972',3,0),(973,50,833,'/1/84/973',3,0),(974,50,834,'/1/84/974',3,0),(975,50,835,'/1/84/975',3,0),(976,50,836,'/1/84/976',3,0),(977,50,837,'/1/84/977',3,0),(978,50,838,'/1/84/978',3,0),(979,50,839,'/1/84/979',3,0),(980,50,840,'/1/84/980',3,0),(981,50,841,'/1/84/981',3,0),(982,50,842,'/1/84/982',3,0),(983,50,843,'/1/84/983',3,0),(984,50,844,'/1/84/984',3,0),(985,50,845,'/1/84/985',3,0),(986,50,846,'/1/84/986',3,0),(987,50,847,'/1/84/987',3,0),(988,50,848,'/1/84/988',3,0),(989,50,849,'/1/84/989',3,0),(990,50,850,'/1/84/990',3,0),(991,50,851,'/1/84/991',3,0),(992,50,852,'/1/84/992',3,0),(993,50,853,'/1/84/993',3,0),(994,50,854,'/1/84/994',3,0),(995,50,855,'/1/84/995',3,0),(996,50,856,'/1/84/996',3,0),(997,50,857,'/1/84/997',3,0),(998,50,858,'/1/84/998',3,0),(999,50,859,'/1/84/999',3,0),(1000,50,860,'/1/84/1000',3,0),(1001,50,861,'/1/84/1001',3,0),(1002,50,862,'/1/84/1002',3,0),(1003,50,863,'/1/84/1003',3,0),(1004,50,864,'/1/84/1004',3,0),(1005,50,865,'/1/84/1005',3,0),(1006,50,866,'/1/84/1006',3,0),(1007,50,867,'/1/84/1007',3,0),(1008,50,868,'/1/84/1008',3,0),(1009,50,869,'/1/84/1009',3,0),(1010,50,870,'/1/84/1010',3,0),(1011,50,871,'/1/84/1011',3,0),(1012,50,872,'/1/84/1012',3,0),(1013,50,873,'/1/84/1013',3,0),(1014,50,874,'/1/84/1014',3,0),(1015,50,875,'/1/84/1015',3,0),(1016,50,876,'/1/84/1016',3,0),(1017,50,877,'/1/84/1017',3,0),(1018,50,878,'/1/84/1018',3,0),(1019,50,879,'/1/84/1019',3,0),(1020,50,880,'/1/84/1020',3,0),(1021,50,881,'/1/84/1021',3,0),(1022,50,882,'/1/84/1022',3,0),(1023,50,883,'/1/84/1023',3,0),(1024,50,884,'/1/84/1024',3,0),(1025,50,885,'/1/84/1025',3,0),(1026,50,886,'/1/84/1026',3,0),(1027,50,887,'/1/84/1027',3,0),(1028,50,888,'/1/84/1028',3,0),(1029,50,889,'/1/84/1029',3,0),(1030,50,890,'/1/84/1030',3,0),(1031,50,891,'/1/84/1031',3,0),(1032,50,892,'/1/84/1032',3,0),(1033,50,893,'/1/84/1033',3,0),(1034,50,894,'/1/84/1034',3,0),(1035,50,895,'/1/84/1035',3,0),(1036,50,896,'/1/84/1036',3,0),(1037,50,897,'/1/84/1037',3,0),(1038,50,898,'/1/84/1038',3,0),(1039,50,899,'/1/84/1039',3,0),(1040,50,900,'/1/84/1040',3,0),(1041,50,901,'/1/84/1041',3,0),(1042,50,902,'/1/84/1042',3,0),(1043,50,903,'/1/84/1043',3,0),(1044,50,904,'/1/84/1044',3,0),(1045,50,905,'/1/84/1045',3,0),(1046,50,906,'/1/84/1046',3,0),(1047,50,907,'/1/84/1047',3,0),(1048,50,908,'/1/84/1048',3,0),(1049,50,909,'/1/84/1049',3,0),(1050,50,910,'/1/84/1050',3,0),(1051,50,911,'/1/84/1051',3,0),(1052,50,912,'/1/84/1052',3,0),(1053,50,913,'/1/84/1053',3,0),(1054,50,914,'/1/84/1054',3,0),(1055,50,915,'/1/84/1055',3,0),(1056,50,916,'/1/84/1056',3,0),(1057,50,917,'/1/84/1057',3,0),(1058,50,918,'/1/84/1058',3,0),(1059,50,919,'/1/84/1059',3,0),(1060,50,920,'/1/84/1060',3,0),(1061,50,921,'/1/84/1061',3,0),(1062,50,922,'/1/84/1062',3,0),(1063,50,923,'/1/84/1063',3,0),(1064,50,924,'/1/84/1064',3,0),(1065,50,925,'/1/84/1065',3,0),(1066,50,926,'/1/84/1066',3,0),(1067,50,927,'/1/84/1067',3,0),(1068,50,928,'/1/84/1068',3,0),(1069,50,929,'/1/84/1069',3,0),(1070,50,930,'/1/84/1070',3,0),(1071,50,931,'/1/84/1071',3,0),(1072,50,932,'/1/84/1072',3,0),(1073,50,933,'/1/84/1073',3,0),(1074,50,934,'/1/84/1074',3,0),(1075,50,935,'/1/84/1075',3,0),(1076,50,936,'/1/84/1076',3,0),(1077,50,937,'/1/84/1077',3,0),(1078,50,938,'/1/84/1078',3,0),(1079,50,939,'/1/84/1079',3,0),(1080,50,940,'/1/84/1080',3,0),(1081,50,941,'/1/84/1081',3,0),(1082,50,942,'/1/84/1082',3,0),(1083,50,943,'/1/84/1083',3,0),(1084,50,944,'/1/84/1084',3,0),(1085,50,945,'/1/84/1085',3,0),(1086,50,946,'/1/84/1086',3,0),(1087,50,947,'/1/84/1087',3,0),(1088,50,948,'/1/84/1088',3,0),(1089,50,949,'/1/84/1089',3,0),(1090,50,950,'/1/84/1090',3,0),(1091,50,951,'/1/84/1091',3,0),(1092,50,952,'/1/84/1092',3,0),(1093,50,953,'/1/84/1093',3,0),(1094,50,954,'/1/84/1094',3,0),(1095,50,955,'/1/84/1095',3,0),(1096,50,956,'/1/84/1096',3,0),(1097,50,957,'/1/84/1097',3,0),(1098,50,958,'/1/84/1098',3,0),(1099,50,959,'/1/84/1099',3,0),(1100,50,960,'/1/84/1100',3,0),(1101,50,961,'/1/84/1101',3,0),(1102,50,962,'/1/84/1102',3,0),(1103,50,963,'/1/84/1103',3,0),(1104,50,964,'/1/84/1104',3,0),(1105,50,965,'/1/84/1105',3,0),(1106,50,966,'/1/84/1106',3,0),(1107,50,967,'/1/84/1107',3,0),(1108,50,968,'/1/84/1108',3,0),(1109,50,969,'/1/84/1109',3,0),(1110,50,970,'/1/84/1110',3,0),(1111,50,971,'/1/84/1111',3,0),(1112,50,972,'/1/84/1112',3,0),(1113,50,973,'/1/84/1113',3,0),(1114,50,974,'/1/84/1114',3,0),(1115,50,975,'/1/84/1115',3,0),(1116,50,976,'/1/84/1116',3,0),(1117,50,977,'/1/84/1117',3,0),(1118,50,978,'/1/84/1118',3,0),(1119,50,979,'/1/84/1119',3,0),(1120,50,980,'/1/84/1120',3,0),(1121,50,981,'/1/84/1121',3,0),(1122,50,982,'/1/84/1122',3,0),(1123,50,983,'/1/84/1123',3,0),(1124,50,984,'/1/84/1124',3,0),(1125,50,985,'/1/84/1125',3,0),(1126,50,986,'/1/84/1126',3,0),(1127,50,987,'/1/84/1127',3,0),(1128,50,988,'/1/84/1128',3,0),(1129,50,989,'/1/84/1129',3,0),(1130,50,990,'/1/84/1130',3,0),(1131,50,991,'/1/84/1131',3,0),(1132,50,992,'/1/84/1132',3,0),(1133,50,993,'/1/84/1133',3,0),(1134,50,994,'/1/84/1134',3,0),(1135,50,995,'/1/84/1135',3,0),(1136,50,996,'/1/84/1136',3,0),(1137,50,997,'/1/84/1137',3,0),(1138,50,998,'/1/84/1138',3,0),(1139,50,999,'/1/84/1139',3,0),(1140,50,1000,'/1/84/1140',3,0),(1141,50,1001,'/1/84/1141',3,0),(1142,50,1002,'/1/84/1142',3,0),(1143,50,1003,'/1/84/1143',3,0),(1144,50,1004,'/1/84/1144',3,0),(1145,50,1005,'/1/84/1145',3,0),(1146,50,1006,'/1/84/1146',3,0),(1147,50,1007,'/1/84/1147',3,0),(1148,50,1008,'/1/84/1148',3,0),(1149,50,1009,'/1/84/1149',3,0),(1150,50,1010,'/1/84/1150',3,0),(1151,50,1011,'/1/84/1151',3,0),(1152,50,1012,'/1/84/1152',3,0),(1153,50,1013,'/1/84/1153',3,0),(1154,50,1014,'/1/84/1154',3,0),(1155,50,1015,'/1/84/1155',3,0),(1156,50,1016,'/1/84/1156',3,0),(1157,50,1017,'/1/84/1157',3,0),(1158,50,1018,'/1/84/1158',3,0),(1159,50,1019,'/1/84/1159',3,0),(1160,50,1020,'/1/84/1160',3,0),(1161,50,1021,'/1/84/1161',3,0),(1162,50,1022,'/1/84/1162',3,0),(1163,50,1023,'/1/84/1163',3,0),(1164,50,1024,'/1/84/1164',3,0),(1165,50,1025,'/1/84/1165',3,0),(1166,50,1026,'/1/84/1166',3,0),(1167,50,1027,'/1/84/1167',3,0),(1168,50,1028,'/1/84/1168',3,0),(1169,50,1029,'/1/84/1169',3,0),(1170,50,1030,'/1/84/1170',3,0),(1171,50,1031,'/1/84/1171',3,0),(1172,50,1032,'/1/84/1172',3,0),(1173,50,1033,'/1/84/1173',3,0),(1174,50,1034,'/1/84/1174',3,0),(1175,50,1035,'/1/84/1175',3,0),(1176,50,1036,'/1/84/1176',3,0),(1177,50,1037,'/1/84/1177',3,0),(1178,50,1038,'/1/84/1178',3,0),(1179,50,1039,'/1/84/1179',3,0),(1180,50,1040,'/1/84/1180',3,0),(1181,50,1041,'/1/84/1181',3,0),(1182,50,1042,'/1/84/1182',3,0),(1183,50,1043,'/1/84/1183',3,0),(1184,50,1044,'/1/84/1184',3,0),(1185,50,1045,'/1/84/1185',3,0),(1186,50,1046,'/1/84/1186',3,0),(1187,50,1047,'/1/84/1187',3,0),(1188,50,1048,'/1/84/1188',3,0),(1189,50,1049,'/1/84/1189',3,0),(1190,50,1050,'/1/84/1190',3,0),(1191,50,1051,'/1/84/1191',3,0),(1192,50,1052,'/1/84/1192',3,0),(1193,50,1053,'/1/84/1193',3,0),(1194,50,1054,'/1/84/1194',3,0),(1195,50,1055,'/1/84/1195',3,0),(1196,50,1056,'/1/84/1196',3,0),(1197,50,1057,'/1/84/1197',3,0),(1198,50,1058,'/1/84/1198',3,0),(1199,50,1059,'/1/84/1199',3,0),(1200,50,1060,'/1/84/1200',3,0),(1201,50,1061,'/1/84/1201',3,0),(1202,50,1062,'/1/84/1202',3,0),(1203,50,1063,'/1/84/1203',3,0),(1204,50,1064,'/1/84/1204',3,0),(1205,50,1065,'/1/84/1205',3,0),(1206,50,1066,'/1/84/1206',3,0),(1207,50,1067,'/1/84/1207',3,0),(1208,50,1068,'/1/84/1208',3,0),(1209,50,1069,'/1/84/1209',3,0),(1210,50,1070,'/1/84/1210',3,0),(1211,50,1071,'/1/84/1211',3,0),(1212,50,1072,'/1/84/1212',3,0),(1213,50,1073,'/1/84/1213',3,0),(1214,50,1074,'/1/84/1214',3,0),(1215,50,1075,'/1/84/1215',3,0),(1216,50,1076,'/1/84/1216',3,0),(1217,50,1077,'/1/84/1217',3,0),(1218,50,1078,'/1/84/1218',3,0),(1219,50,1079,'/1/84/1219',3,0),(1220,50,1080,'/1/84/1220',3,0),(1221,50,1081,'/1/84/1221',3,0),(1222,50,1082,'/1/84/1222',3,0),(1223,50,1083,'/1/84/1223',3,0),(1224,50,1084,'/1/84/1224',3,0),(1225,50,1085,'/1/84/1225',3,0),(1226,50,1086,'/1/84/1226',3,0),(1227,50,1087,'/1/84/1227',3,0),(1228,50,1088,'/1/84/1228',3,0),(1229,50,1089,'/1/84/1229',3,0),(1230,50,1090,'/1/84/1230',3,0),(1231,50,1091,'/1/84/1231',3,0),(1232,50,1092,'/1/84/1232',3,0),(1233,50,1093,'/1/84/1233',3,0),(1234,50,1094,'/1/84/1234',3,0),(1235,50,1095,'/1/84/1235',3,0),(1236,50,1096,'/1/84/1236',3,0),(1237,50,1097,'/1/84/1237',3,0),(1238,50,1098,'/1/84/1238',3,0),(1239,50,1099,'/1/84/1239',3,0),(1240,50,1100,'/1/84/1240',3,0),(1241,50,1101,'/1/84/1241',3,0),(1242,50,1102,'/1/84/1242',3,0),(1243,50,1103,'/1/84/1243',3,0),(1244,50,1104,'/1/84/1244',3,0),(1245,50,1105,'/1/84/1245',3,0),(1246,50,1106,'/1/84/1246',3,0),(1247,50,1107,'/1/84/1247',3,0),(1248,50,1108,'/1/84/1248',3,0),(1249,50,1109,'/1/84/1249',3,0),(1250,50,1110,'/1/84/1250',3,0),(1251,50,1111,'/1/84/1251',3,0),(1252,50,1112,'/1/84/1252',3,0),(1253,50,1113,'/1/84/1253',3,0),(1254,50,1114,'/1/84/1254',3,0),(1255,50,1115,'/1/84/1255',3,0),(1256,50,1116,'/1/84/1256',3,0),(1257,50,1117,'/1/84/1257',3,0),(1258,50,1118,'/1/84/1258',3,0),(1259,50,1119,'/1/84/1259',3,0),(1260,50,1120,'/1/84/1260',3,0),(1261,50,1121,'/1/84/1261',3,0),(1262,50,1122,'/1/84/1262',3,0),(1263,50,1123,'/1/84/1263',3,0),(1264,50,1124,'/1/84/1264',3,0),(1265,50,1125,'/1/84/1265',3,0),(1266,50,1126,'/1/84/1266',3,0),(1267,50,1127,'/1/84/1267',3,0),(1268,50,1128,'/1/84/1268',3,0),(1269,50,1129,'/1/84/1269',3,0),(1270,50,1130,'/1/84/1270',3,0),(1271,50,1131,'/1/84/1271',3,0),(1272,50,1132,'/1/84/1272',3,0),(1273,50,1133,'/1/84/1273',3,0),(1274,50,1134,'/1/84/1274',3,0),(1275,50,1135,'/1/84/1275',3,0),(1276,50,1136,'/1/84/1276',3,0),(1277,50,1137,'/1/84/1277',3,0),(1278,50,1138,'/1/84/1278',3,0),(1279,50,1139,'/1/84/1279',3,0),(1280,50,1140,'/1/84/1280',3,0),(1281,50,1141,'/1/84/1281',3,0),(1282,50,1142,'/1/84/1282',3,0),(1283,50,1143,'/1/84/1283',3,0),(1284,50,1144,'/1/84/1284',3,0),(1285,50,1145,'/1/84/1285',3,0),(1286,50,1146,'/1/84/1286',3,0),(1287,50,1147,'/1/84/1287',3,0),(1288,50,1148,'/1/84/1288',3,0),(1289,50,1149,'/1/84/1289',3,0),(1290,50,1150,'/1/84/1290',3,0),(1291,50,1151,'/1/84/1291',3,0),(1292,50,1152,'/1/84/1292',3,0),(1293,50,1153,'/1/84/1293',3,0),(1294,50,1154,'/1/84/1294',3,0),(1295,50,1155,'/1/84/1295',3,0),(1296,50,1156,'/1/84/1296',3,0),(1297,50,1157,'/1/84/1297',3,0),(1298,50,1158,'/1/84/1298',3,0),(1299,50,1159,'/1/84/1299',3,0),(1300,50,1160,'/1/84/1300',3,0),(1301,50,1161,'/1/84/1301',3,0),(1302,50,1162,'/1/84/1302',3,0),(1303,50,1163,'/1/84/1303',3,0),(1304,50,1164,'/1/84/1304',3,0),(1305,50,1165,'/1/84/1305',3,0),(1306,50,1166,'/1/84/1306',3,0),(1307,50,1167,'/1/84/1307',3,0),(1308,50,1168,'/1/84/1308',3,0),(1309,50,1169,'/1/84/1309',3,0),(1310,50,1170,'/1/84/1310',3,0),(1311,50,1171,'/1/84/1311',3,0),(1312,50,1172,'/1/84/1312',3,0),(1313,50,1173,'/1/84/1313',3,0),(1314,50,1174,'/1/84/1314',3,0),(1315,50,1175,'/1/84/1315',3,0),(1316,50,1176,'/1/84/1316',3,0),(1317,50,1177,'/1/84/1317',3,0),(1318,50,1178,'/1/84/1318',3,0),(1319,50,1179,'/1/84/1319',3,0),(1320,50,1180,'/1/84/1320',3,0),(1321,50,1181,'/1/84/1321',3,0),(1322,50,1182,'/1/84/1322',3,0),(1323,50,1183,'/1/84/1323',3,0),(1324,50,1184,'/1/84/1324',3,0),(1325,50,1185,'/1/84/1325',3,0),(1326,50,1186,'/1/84/1326',3,0),(1327,50,1187,'/1/84/1327',3,0),(1328,50,1188,'/1/84/1328',3,0),(1329,50,1189,'/1/84/1329',3,0),(1330,50,1190,'/1/84/1330',3,0),(1331,50,1191,'/1/84/1331',3,0),(1332,50,1192,'/1/84/1332',3,0),(1333,50,1193,'/1/84/1333',3,0),(1334,50,1194,'/1/84/1334',3,0),(1335,50,1195,'/1/84/1335',3,0),(1336,50,1196,'/1/84/1336',3,0),(1337,50,1197,'/1/84/1337',3,0),(1338,50,1198,'/1/84/1338',3,0),(1339,50,1199,'/1/84/1339',3,0),(1340,50,1200,'/1/84/1340',3,0),(1341,50,1201,'/1/84/1341',3,0),(1342,50,1202,'/1/84/1342',3,0),(1343,50,1203,'/1/84/1343',3,0),(1344,50,1204,'/1/84/1344',3,0),(1345,50,1205,'/1/84/1345',3,0),(1346,50,1206,'/1/84/1346',3,0),(1347,50,1207,'/1/84/1347',3,0),(1348,50,1208,'/1/84/1348',3,0),(1349,50,1209,'/1/84/1349',3,0),(1350,50,1210,'/1/84/1350',3,0),(1351,50,1211,'/1/84/1351',3,0),(1352,50,1212,'/1/84/1352',3,0),(1353,50,1213,'/1/84/1353',3,0),(1354,50,1214,'/1/84/1354',3,0),(1355,50,1215,'/1/84/1355',3,0),(1356,50,1216,'/1/84/1356',3,0),(1357,50,1217,'/1/84/1357',3,0),(1358,50,1218,'/1/84/1358',3,0),(1359,50,1219,'/1/84/1359',3,0),(1360,50,1220,'/1/84/1360',3,0),(1361,50,1221,'/1/84/1361',3,0),(1362,50,1222,'/1/84/1362',3,0),(1363,50,1223,'/1/84/1363',3,0),(1364,50,1224,'/1/84/1364',3,0),(1365,50,1225,'/1/84/1365',3,0),(1366,50,1226,'/1/84/1366',3,0),(1367,50,1227,'/1/84/1367',3,0),(1368,50,1228,'/1/84/1368',3,0),(1369,50,1229,'/1/84/1369',3,0),(1370,50,1230,'/1/84/1370',3,0),(1371,50,1231,'/1/84/1371',3,0),(1372,50,1232,'/1/84/1372',3,0),(1373,50,1233,'/1/84/1373',3,0),(1374,50,1234,'/1/84/1374',3,0),(1375,50,1235,'/1/84/1375',3,0),(1376,50,1236,'/1/84/1376',3,0),(1377,50,1237,'/1/84/1377',3,0),(1378,50,1238,'/1/84/1378',3,0),(1379,50,1239,'/1/84/1379',3,0),(1380,50,1240,'/1/84/1380',3,0),(1381,50,1241,'/1/84/1381',3,0),(1382,50,1242,'/1/84/1382',3,0),(1383,50,1243,'/1/84/1383',3,0),(1384,50,1244,'/1/84/1384',3,0),(1385,50,1245,'/1/84/1385',3,0),(1386,50,1246,'/1/84/1386',3,0),(1387,50,1247,'/1/84/1387',3,0),(1388,50,1248,'/1/84/1388',3,0),(1389,50,1249,'/1/84/1389',3,0),(1390,50,1250,'/1/84/1390',3,0),(1391,50,1251,'/1/84/1391',3,0),(1392,50,1252,'/1/84/1392',3,0),(1393,50,1253,'/1/84/1393',3,0),(1394,50,1254,'/1/84/1394',3,0),(1395,50,1255,'/1/84/1395',3,0),(1396,50,1256,'/1/84/1396',3,0),(1397,50,1257,'/1/84/1397',3,0),(1398,50,1258,'/1/84/1398',3,0),(1399,50,1259,'/1/84/1399',3,0),(1400,50,1260,'/1/84/1400',3,0),(1401,50,1261,'/1/84/1401',3,0),(1402,50,1262,'/1/84/1402',3,0),(1403,50,1263,'/1/84/1403',3,0),(1404,50,1264,'/1/84/1404',3,0),(1405,50,1265,'/1/84/1405',3,0),(1406,50,1266,'/1/84/1406',3,0),(1407,50,1267,'/1/84/1407',3,0),(1408,50,1268,'/1/84/1408',3,0),(1409,50,1269,'/1/84/1409',3,0),(1410,50,1270,'/1/84/1410',3,0),(1411,50,1271,'/1/84/1411',3,0),(1412,50,1272,'/1/84/1412',3,0),(1413,50,1273,'/1/84/1413',3,0),(1414,50,1274,'/1/84/1414',3,0),(1415,50,1275,'/1/84/1415',3,0),(1416,50,1276,'/1/84/1416',3,0),(1417,50,1277,'/1/84/1417',3,0),(1418,50,1278,'/1/84/1418',3,0),(1419,50,1279,'/1/84/1419',3,0),(1420,50,1280,'/1/84/1420',3,0),(1421,50,1281,'/1/84/1421',3,0),(1422,50,1282,'/1/84/1422',3,0),(1423,50,1283,'/1/84/1423',3,0),(1424,50,1284,'/1/84/1424',3,0),(1425,50,1285,'/1/84/1425',3,0),(1426,50,1286,'/1/84/1426',3,0),(1427,50,1287,'/1/84/1427',3,0),(1428,50,1288,'/1/84/1428',3,0),(1429,50,1289,'/1/84/1429',3,0),(1430,50,1290,'/1/84/1430',3,0),(1431,50,1291,'/1/84/1431',3,0),(1432,50,1292,'/1/84/1432',3,0),(1433,50,1293,'/1/84/1433',3,0),(1434,50,1294,'/1/84/1434',3,0),(1435,50,1295,'/1/84/1435',3,0),(1436,50,1296,'/1/84/1436',3,0),(1437,50,1297,'/1/84/1437',3,0),(1438,50,1298,'/1/84/1438',3,0),(1439,50,1299,'/1/84/1439',3,0),(1440,50,1300,'/1/84/1440',3,0),(1441,50,1301,'/1/84/1441',3,0),(1442,50,1302,'/1/84/1442',3,0),(1443,50,1303,'/1/84/1443',3,0),(1444,50,1304,'/1/84/1444',3,0),(1445,50,1305,'/1/84/1445',3,0),(1446,50,1306,'/1/84/1446',3,0),(1447,50,1307,'/1/84/1447',3,0),(1448,50,1308,'/1/84/1448',3,0),(1449,50,1309,'/1/84/1449',3,0),(1450,50,1310,'/1/84/1450',3,0),(1451,50,1311,'/1/84/1451',3,0),(1452,50,1312,'/1/84/1452',3,0),(1453,50,1313,'/1/84/1453',3,0),(1454,50,1314,'/1/84/1454',3,0),(1455,50,1315,'/1/84/1455',3,0),(1456,50,1316,'/1/84/1456',3,0),(1457,50,1317,'/1/84/1457',3,0),(1458,50,1318,'/1/84/1458',3,0),(1459,50,1319,'/1/84/1459',3,0),(1460,50,1320,'/1/84/1460',3,0),(1461,50,1321,'/1/84/1461',3,0),(1462,50,1322,'/1/84/1462',3,0),(1463,50,1323,'/1/84/1463',3,0),(1464,50,1324,'/1/84/1464',3,0),(1465,50,1325,'/1/84/1465',3,0),(1466,50,1326,'/1/84/1466',3,0),(1467,50,1327,'/1/84/1467',3,0),(1468,50,1328,'/1/84/1468',3,0),(1469,50,1329,'/1/84/1469',3,0),(1470,50,1330,'/1/84/1470',3,0),(1471,50,1331,'/1/84/1471',3,0),(1472,50,1332,'/1/84/1472',3,0),(1473,50,1333,'/1/84/1473',3,0),(1474,50,1334,'/1/84/1474',3,0),(1475,50,1335,'/1/84/1475',3,0),(1476,50,1336,'/1/84/1476',3,0),(1477,50,1337,'/1/84/1477',3,0),(1478,50,1338,'/1/84/1478',3,0),(1479,50,1339,'/1/84/1479',3,0),(1480,50,1340,'/1/84/1480',3,0),(1481,50,1341,'/1/84/1481',3,0),(1482,50,1342,'/1/84/1482',3,0),(1483,50,1343,'/1/84/1483',3,0),(1484,50,1344,'/1/84/1484',3,0),(1485,50,1345,'/1/84/1485',3,0),(1486,50,1346,'/1/84/1486',3,0),(1487,50,1347,'/1/84/1487',3,0),(1488,50,1348,'/1/84/1488',3,0),(1489,50,1349,'/1/84/1489',3,0),(1490,50,1350,'/1/84/1490',3,0),(1491,50,1351,'/1/84/1491',3,0),(1492,50,1352,'/1/84/1492',3,0),(1493,50,1353,'/1/84/1493',3,0),(1494,50,1354,'/1/84/1494',3,0),(1495,50,1355,'/1/84/1495',3,0),(1496,50,1356,'/1/84/1496',3,0),(1497,50,1357,'/1/84/1497',3,0),(1498,50,1358,'/1/84/1498',3,0),(1499,50,1359,'/1/84/1499',3,0),(1500,50,1360,'/1/84/1500',3,0),(1501,50,1361,'/1/84/1501',3,0),(1502,50,1362,'/1/84/1502',3,0),(1503,50,1363,'/1/84/1503',3,0),(1504,50,1364,'/1/84/1504',3,0),(1505,50,1365,'/1/84/1505',3,0),(1506,50,1366,'/1/84/1506',3,0),(1507,50,1367,'/1/84/1507',3,0),(1508,50,1368,'/1/84/1508',3,0),(1509,50,1369,'/1/84/1509',3,0),(1510,50,1370,'/1/84/1510',3,0),(1511,50,1371,'/1/84/1511',3,0),(1512,50,1372,'/1/84/1512',3,0),(1513,50,1373,'/1/84/1513',3,0),(1514,50,1374,'/1/84/1514',3,0),(1515,50,1375,'/1/84/1515',3,0),(1516,50,1376,'/1/84/1516',3,0),(1517,50,1377,'/1/84/1517',3,0),(1518,50,1378,'/1/84/1518',3,0),(1519,50,1379,'/1/84/1519',3,0),(1520,50,1380,'/1/84/1520',3,0),(1521,50,1381,'/1/84/1521',3,0),(1522,50,1382,'/1/84/1522',3,0),(1523,50,1383,'/1/84/1523',3,0),(1524,50,1384,'/1/84/1524',3,0),(1525,50,1385,'/1/84/1525',3,0),(1526,50,1386,'/1/84/1526',3,0),(1527,50,1387,'/1/84/1527',3,0),(1528,50,1388,'/1/84/1528',3,0),(1529,50,1389,'/1/84/1529',3,0),(1530,50,1390,'/1/84/1530',3,0),(1531,50,1391,'/1/84/1531',3,0),(1532,50,1392,'/1/84/1532',3,0),(1533,50,1393,'/1/84/1533',3,0),(1534,50,1394,'/1/84/1534',3,0),(1535,50,1395,'/1/84/1535',3,0),(1536,50,1396,'/1/84/1536',3,0),(1537,50,1397,'/1/84/1537',3,0),(1538,50,1398,'/1/84/1538',3,0),(1539,50,1399,'/1/84/1539',3,0),(1540,50,1400,'/1/84/1540',3,0),(1541,50,1401,'/1/84/1541',3,0),(1542,50,1402,'/1/84/1542',3,0),(1543,50,1403,'/1/84/1543',3,0),(1544,50,1404,'/1/84/1544',3,0),(1545,50,1405,'/1/84/1545',3,0),(1546,50,1406,'/1/84/1546',3,0),(1547,50,1407,'/1/84/1547',3,0),(1548,50,1408,'/1/84/1548',3,0),(1549,50,1409,'/1/84/1549',3,0),(1550,50,1410,'/1/84/1550',3,0),(1551,50,1411,'/1/84/1551',3,0),(1552,50,1412,'/1/84/1552',3,0),(1553,50,1413,'/1/84/1553',3,0),(1554,50,1414,'/1/84/1554',3,0),(1555,50,1415,'/1/84/1555',3,0),(1556,50,1416,'/1/84/1556',3,0),(1557,50,1417,'/1/84/1557',3,0),(1558,50,1418,'/1/84/1558',3,0),(1559,50,1419,'/1/84/1559',3,0),(1560,50,1420,'/1/84/1560',3,0),(1561,50,1421,'/1/84/1561',3,0),(1562,50,1422,'/1/84/1562',3,0),(1563,50,1423,'/1/84/1563',3,0),(1564,50,1424,'/1/84/1564',3,0),(1565,50,1425,'/1/84/1565',3,0),(1566,50,1426,'/1/84/1566',3,0),(1567,50,1427,'/1/84/1567',3,0),(1568,50,1428,'/1/84/1568',3,0),(1569,50,1429,'/1/84/1569',3,0),(1570,50,1430,'/1/84/1570',3,0),(1571,50,1431,'/1/84/1571',3,0),(1572,50,1432,'/1/84/1572',3,0),(1573,50,1433,'/1/84/1573',3,0),(1574,50,1434,'/1/84/1574',3,0),(1575,50,1435,'/1/84/1575',3,0),(1576,50,1436,'/1/84/1576',3,0),(1577,50,1437,'/1/84/1577',3,0),(1578,50,1438,'/1/84/1578',3,0),(1579,50,1439,'/1/84/1579',3,0),(1580,50,1440,'/1/84/1580',3,0),(1581,50,1441,'/1/84/1581',3,0),(1582,50,1442,'/1/84/1582',3,0),(1583,50,1443,'/1/84/1583',3,0),(1584,50,1444,'/1/84/1584',3,0),(1585,50,1445,'/1/84/1585',3,0),(1586,50,1446,'/1/84/1586',3,0),(1587,50,1447,'/1/84/1587',3,0),(1588,50,1448,'/1/84/1588',3,0),(1589,50,1449,'/1/84/1589',3,0),(1590,50,1450,'/1/84/1590',3,0),(1591,50,1451,'/1/84/1591',3,0),(1592,50,1452,'/1/84/1592',3,0),(1593,50,1453,'/1/84/1593',3,0),(1594,50,1454,'/1/84/1594',3,0),(1595,50,1455,'/1/84/1595',3,0),(1596,50,1456,'/1/84/1596',3,0),(1597,50,1457,'/1/84/1597',3,0),(1598,50,1458,'/1/84/1598',3,0),(1599,50,1459,'/1/84/1599',3,0),(1600,50,1460,'/1/84/1600',3,0),(1601,50,1461,'/1/84/1601',3,0),(1602,50,1462,'/1/84/1602',3,0),(1603,50,1463,'/1/84/1603',3,0),(1604,50,1464,'/1/84/1604',3,0),(1605,50,1465,'/1/84/1605',3,0),(1606,50,1466,'/1/84/1606',3,0),(1607,50,1467,'/1/84/1607',3,0),(1608,50,1468,'/1/84/1608',3,0),(1609,50,1469,'/1/84/1609',3,0),(1610,50,1470,'/1/84/1610',3,0),(1611,50,1471,'/1/84/1611',3,0),(1612,50,1472,'/1/84/1612',3,0),(1613,50,1473,'/1/84/1613',3,0),(1614,50,1474,'/1/84/1614',3,0),(1615,50,1475,'/1/84/1615',3,0),(1616,50,1476,'/1/84/1616',3,0),(1617,50,1477,'/1/84/1617',3,0),(1618,50,1478,'/1/84/1618',3,0),(1619,50,1479,'/1/84/1619',3,0),(1620,50,1480,'/1/84/1620',3,0),(1621,50,1481,'/1/84/1621',3,0),(1622,50,1482,'/1/84/1622',3,0),(1623,50,1483,'/1/84/1623',3,0),(1624,50,1484,'/1/84/1624',3,0),(1625,50,1485,'/1/84/1625',3,0),(1626,50,1486,'/1/84/1626',3,0),(1627,50,1487,'/1/84/1627',3,0),(1628,50,1488,'/1/84/1628',3,0),(1629,50,1489,'/1/84/1629',3,0),(1630,50,1490,'/1/84/1630',3,0),(1631,50,1491,'/1/84/1631',3,0),(1632,50,1492,'/1/84/1632',3,0),(1633,50,1493,'/1/84/1633',3,0),(1634,50,1494,'/1/84/1634',3,0),(1635,50,1495,'/1/84/1635',3,0),(1636,50,1496,'/1/84/1636',3,0),(1637,50,1497,'/1/84/1637',3,0),(1638,50,1498,'/1/84/1638',3,0),(1639,50,1499,'/1/84/1639',3,0),(1640,50,1500,'/1/84/1640',3,0),(1641,50,1501,'/1/84/1641',3,0),(1642,50,1502,'/1/84/1642',3,0),(1643,50,1503,'/1/84/1643',3,0),(1644,50,1504,'/1/84/1644',3,0),(1645,50,1505,'/1/84/1645',3,0),(1646,50,1506,'/1/84/1646',3,0),(1647,50,1507,'/1/84/1647',3,0),(1648,50,1508,'/1/84/1648',3,0),(1649,50,1509,'/1/84/1649',3,0),(1650,50,1510,'/1/84/1650',3,0),(1651,50,1511,'/1/84/1651',3,0),(1652,50,1512,'/1/84/1652',3,0),(1653,50,1513,'/1/84/1653',3,0),(1654,50,1514,'/1/84/1654',3,0),(1655,50,1515,'/1/84/1655',3,0),(1656,50,1516,'/1/84/1656',3,0),(1657,50,1517,'/1/84/1657',3,0),(1658,50,1518,'/1/84/1658',3,0),(1659,50,1519,'/1/84/1659',3,0),(1660,50,1520,'/1/84/1660',3,0),(1661,50,1521,'/1/84/1661',3,0),(1662,50,1522,'/1/84/1662',3,0),(1663,50,1523,'/1/84/1663',3,0),(1664,50,1524,'/1/84/1664',3,0),(1665,50,1525,'/1/84/1665',3,0),(1666,50,1526,'/1/84/1666',3,0),(1667,50,1527,'/1/84/1667',3,0),(1668,50,1528,'/1/84/1668',3,0),(1669,50,1529,'/1/84/1669',3,0),(1670,50,1530,'/1/84/1670',3,0),(1671,50,1531,'/1/84/1671',3,0),(1672,50,1532,'/1/84/1672',3,0),(1673,50,1533,'/1/84/1673',3,0),(1674,50,1534,'/1/84/1674',3,0),(1675,50,1535,'/1/84/1675',3,0),(1676,50,1536,'/1/84/1676',3,0),(1677,50,1537,'/1/84/1677',3,0),(1678,50,1538,'/1/84/1678',3,0),(1679,50,1539,'/1/84/1679',3,0),(1680,50,1540,'/1/84/1680',3,0),(1681,50,1541,'/1/84/1681',3,0),(1682,50,1542,'/1/84/1682',3,0),(1683,50,1543,'/1/84/1683',3,0),(1684,50,1544,'/1/84/1684',3,0),(1685,50,1545,'/1/84/1685',3,0),(1686,50,1546,'/1/84/1686',3,0),(1687,50,1547,'/1/84/1687',3,0),(1688,50,1548,'/1/84/1688',3,0),(1689,50,1549,'/1/84/1689',3,0),(1690,50,1550,'/1/84/1690',3,0),(1691,50,1551,'/1/84/1691',3,0),(1692,50,1552,'/1/84/1692',3,0),(1693,50,1553,'/1/84/1693',3,0),(1694,50,1554,'/1/84/1694',3,0),(1695,50,1555,'/1/84/1695',3,0),(1696,50,1556,'/1/84/1696',3,0),(1697,50,1557,'/1/84/1697',3,0),(1698,50,1558,'/1/84/1698',3,0),(1699,50,1559,'/1/84/1699',3,0),(1700,50,1560,'/1/84/1700',3,0),(1701,50,1561,'/1/84/1701',3,0),(1702,50,1562,'/1/84/1702',3,0),(1703,50,1563,'/1/84/1703',3,0),(1704,50,1564,'/1/84/1704',3,0),(1705,50,1565,'/1/84/1705',3,0),(1706,50,1566,'/1/84/1706',3,0),(1707,50,1567,'/1/84/1707',3,0),(1708,50,1568,'/1/84/1708',3,0),(1709,50,1569,'/1/84/1709',3,0),(1710,50,1570,'/1/84/1710',3,0),(1711,50,1571,'/1/84/1711',3,0),(1712,50,1572,'/1/84/1712',3,0),(1713,50,1573,'/1/84/1713',3,0),(1714,50,1574,'/1/84/1714',3,0),(1715,50,1575,'/1/84/1715',3,0),(1716,50,1576,'/1/84/1716',3,0),(1717,50,1577,'/1/84/1717',3,0),(1718,50,1578,'/1/84/1718',3,0),(1719,50,1579,'/1/84/1719',3,0),(1720,50,1580,'/1/84/1720',3,0),(1721,50,1581,'/1/84/1721',3,0),(1722,50,1582,'/1/84/1722',3,0),(1723,50,1583,'/1/84/1723',3,0),(1724,50,1584,'/1/84/1724',3,0),(1725,50,1585,'/1/84/1725',3,0),(1726,50,1586,'/1/84/1726',3,0),(1727,50,1587,'/1/84/1727',3,0),(1728,50,1588,'/1/84/1728',3,0),(1729,50,1589,'/1/84/1729',3,0),(1730,50,1590,'/1/84/1730',3,0),(1731,50,1591,'/1/84/1731',3,0),(1732,50,1592,'/1/84/1732',3,0),(1733,50,1593,'/1/84/1733',3,0),(1734,50,1594,'/1/84/1734',3,0),(1735,50,1595,'/1/84/1735',3,0),(1736,50,1596,'/1/84/1736',3,0),(1737,50,1597,'/1/84/1737',3,0),(1738,50,1598,'/1/84/1738',3,0),(1739,50,1599,'/1/84/1739',3,0),(1740,50,1600,'/1/84/1740',3,0),(1741,50,1601,'/1/84/1741',3,0),(1742,50,1602,'/1/84/1742',3,0),(1743,50,1603,'/1/84/1743',3,0),(1744,50,1604,'/1/84/1744',3,0),(1745,50,1605,'/1/84/1745',3,0),(1746,50,1606,'/1/84/1746',3,0),(1747,50,1607,'/1/84/1747',3,0),(1748,50,1608,'/1/84/1748',3,0),(1749,50,1609,'/1/84/1749',3,0),(1750,50,1610,'/1/84/1750',3,0),(1751,50,1611,'/1/84/1751',3,0),(1752,50,1612,'/1/84/1752',3,0),(1753,50,1613,'/1/84/1753',3,0),(1754,50,1614,'/1/84/1754',3,0),(1755,50,1615,'/1/84/1755',3,0),(1756,50,1616,'/1/84/1756',3,0),(1757,50,1617,'/1/84/1757',3,0),(1758,50,1618,'/1/84/1758',3,0),(1759,50,1619,'/1/84/1759',3,0),(1760,50,1620,'/1/84/1760',3,0),(1761,50,1621,'/1/84/1761',3,0),(1762,50,1622,'/1/84/1762',3,0),(1763,50,1623,'/1/84/1763',3,0),(1764,50,1624,'/1/84/1764',3,0),(1765,50,1625,'/1/84/1765',3,0),(1766,50,1626,'/1/84/1766',3,0),(1767,50,1627,'/1/84/1767',3,0),(1768,50,1628,'/1/84/1768',3,0),(1769,50,1629,'/1/84/1769',3,0),(1770,50,1630,'/1/84/1770',3,0),(1771,50,1631,'/1/84/1771',3,0),(1772,50,1632,'/1/84/1772',3,0),(1773,50,1633,'/1/84/1773',3,0),(1774,50,1634,'/1/84/1774',3,0),(1775,50,1635,'/1/84/1775',3,0),(1776,50,1636,'/1/84/1776',3,0),(1777,50,1637,'/1/84/1777',3,0),(1778,50,1638,'/1/84/1778',3,0),(1779,50,1639,'/1/84/1779',3,0),(1780,50,1640,'/1/84/1780',3,0),(1781,50,1641,'/1/84/1781',3,0),(1782,50,1642,'/1/84/1782',3,0),(1783,50,1643,'/1/84/1783',3,0),(1784,50,1644,'/1/84/1784',3,0),(1785,50,1645,'/1/84/1785',3,0),(1786,50,1646,'/1/84/1786',3,0),(1787,50,1647,'/1/84/1787',3,0),(1788,50,1648,'/1/84/1788',3,0),(1789,50,1649,'/1/84/1789',3,0),(1790,50,1650,'/1/84/1790',3,0),(1791,50,1651,'/1/84/1791',3,0),(1792,50,1652,'/1/84/1792',3,0),(1793,50,1653,'/1/84/1793',3,0),(1794,50,1654,'/1/84/1794',3,0),(1795,50,1655,'/1/84/1795',3,0),(1796,50,1656,'/1/84/1796',3,0),(1797,50,1657,'/1/84/1797',3,0),(1798,50,1658,'/1/84/1798',3,0),(1799,50,1659,'/1/84/1799',3,0),(1800,50,1660,'/1/84/1800',3,0),(1801,50,1661,'/1/84/1801',3,0),(1802,50,1662,'/1/84/1802',3,0),(1803,50,1663,'/1/84/1803',3,0),(1804,50,1664,'/1/84/1804',3,0),(1805,50,1665,'/1/84/1805',3,0),(1806,50,1666,'/1/84/1806',3,0),(1807,50,1667,'/1/84/1807',3,0),(1808,50,1668,'/1/84/1808',3,0),(1809,50,1669,'/1/84/1809',3,0),(1810,50,1670,'/1/84/1810',3,0),(1811,50,1671,'/1/84/1811',3,0),(1812,50,1672,'/1/84/1812',3,0),(1813,50,1673,'/1/84/1813',3,0),(1814,50,1674,'/1/84/1814',3,0),(1815,50,1675,'/1/84/1815',3,0),(1816,50,1676,'/1/84/1816',3,0),(1817,50,1677,'/1/84/1817',3,0),(1818,50,1678,'/1/84/1818',3,0),(1819,50,1679,'/1/84/1819',3,0),(1820,50,1680,'/1/84/1820',3,0),(1821,50,1681,'/1/84/1821',3,0),(1822,50,1682,'/1/84/1822',3,0),(1823,50,1683,'/1/84/1823',3,0),(1824,50,1684,'/1/84/1824',3,0),(1825,50,1685,'/1/84/1825',3,0),(1826,50,1686,'/1/84/1826',3,0),(1827,50,1687,'/1/84/1827',3,0),(1828,50,1688,'/1/84/1828',3,0),(1829,50,1689,'/1/84/1829',3,0),(1830,50,1690,'/1/84/1830',3,0),(1831,50,1691,'/1/84/1831',3,0),(1832,50,1692,'/1/84/1832',3,0),(1833,50,1693,'/1/84/1833',3,0),(1834,50,1694,'/1/84/1834',3,0),(1835,50,1695,'/1/84/1835',3,0),(1836,50,1696,'/1/84/1836',3,0),(1837,50,1697,'/1/84/1837',3,0),(1838,50,1698,'/1/84/1838',3,0),(1839,50,1699,'/1/84/1839',3,0),(1840,50,1700,'/1/84/1840',3,0),(1841,50,1701,'/1/84/1841',3,0),(1842,50,1702,'/1/84/1842',3,0),(1843,50,1703,'/1/84/1843',3,0),(1844,50,1704,'/1/84/1844',3,0),(1845,50,1705,'/1/84/1845',3,0),(1846,50,1706,'/1/84/1846',3,0),(1847,50,1707,'/1/84/1847',3,0),(1848,50,1708,'/1/84/1848',3,0),(1849,50,1709,'/1/84/1849',3,0),(1850,50,1710,'/1/84/1850',3,0),(1851,50,1711,'/1/84/1851',3,0),(1852,50,1712,'/1/84/1852',3,0),(1853,50,1713,'/1/84/1853',3,0),(1854,50,1714,'/1/84/1854',3,0),(1855,50,1715,'/1/84/1855',3,0),(1856,50,1716,'/1/84/1856',3,0),(1857,50,1717,'/1/84/1857',3,0),(1858,50,1718,'/1/84/1858',3,0),(1859,50,1719,'/1/84/1859',3,0),(1860,50,1720,'/1/84/1860',3,0),(1861,50,1721,'/1/84/1861',3,0),(1862,50,1722,'/1/84/1862',3,0),(1863,50,1723,'/1/84/1863',3,0),(1864,50,1724,'/1/84/1864',3,0),(1865,50,1725,'/1/84/1865',3,0),(1866,50,1726,'/1/84/1866',3,0),(1867,50,1727,'/1/84/1867',3,0),(1868,50,1728,'/1/84/1868',3,0),(1869,50,1729,'/1/84/1869',3,0),(1870,50,1730,'/1/84/1870',3,0),(1871,50,1731,'/1/84/1871',3,0),(1872,50,1732,'/1/84/1872',3,0),(1873,50,1733,'/1/84/1873',3,0),(1874,50,1734,'/1/84/1874',3,0),(1875,50,1735,'/1/84/1875',3,0),(1876,50,1736,'/1/84/1876',3,0),(1877,50,1737,'/1/84/1877',3,0),(1878,50,1738,'/1/84/1878',3,0),(1879,50,1739,'/1/84/1879',3,0),(1880,50,1740,'/1/84/1880',3,0),(1881,50,1741,'/1/84/1881',3,0),(1882,50,1742,'/1/84/1882',3,0),(1883,50,1743,'/1/84/1883',3,0),(1884,50,1744,'/1/84/1884',3,0),(1885,50,1745,'/1/84/1885',3,0),(1886,50,1746,'/1/84/1886',3,0),(1887,50,1747,'/1/84/1887',3,0),(1888,50,1748,'/1/84/1888',3,0),(1889,50,1749,'/1/84/1889',3,0),(1890,50,1750,'/1/84/1890',3,0),(1891,50,1751,'/1/84/1891',3,0),(1892,50,1752,'/1/84/1892',3,0),(1893,50,1753,'/1/84/1893',3,0),(1894,50,1754,'/1/84/1894',3,0),(1895,50,1755,'/1/84/1895',3,0),(1896,50,1756,'/1/84/1896',3,0),(1897,50,1757,'/1/84/1897',3,0),(1898,50,1758,'/1/84/1898',3,0),(1899,50,1759,'/1/84/1899',3,0),(1900,50,1760,'/1/84/1900',3,0),(1901,50,1761,'/1/84/1901',3,0),(1902,50,1762,'/1/84/1902',3,0),(1903,50,1763,'/1/84/1903',3,0),(1904,50,1764,'/1/84/1904',3,0),(1905,50,1765,'/1/84/1905',3,0),(1906,50,1766,'/1/84/1906',3,0),(1907,50,1767,'/1/84/1907',3,0),(1908,50,1768,'/1/84/1908',3,0),(1909,50,1769,'/1/84/1909',3,0),(1910,50,1770,'/1/84/1910',3,0),(1911,50,1771,'/1/84/1911',3,0),(1912,50,1772,'/1/84/1912',3,0),(1913,50,1773,'/1/84/1913',3,0),(1914,50,1774,'/1/84/1914',3,0),(1915,50,1775,'/1/84/1915',3,0),(1916,50,1776,'/1/84/1916',3,0),(1917,50,1777,'/1/84/1917',3,0),(1918,50,1778,'/1/84/1918',3,0),(1919,50,1779,'/1/84/1919',3,0),(1920,50,1780,'/1/84/1920',3,0),(1921,50,1781,'/1/84/1921',3,0),(1922,50,1782,'/1/84/1922',3,0),(1923,50,1783,'/1/84/1923',3,0),(1924,50,1784,'/1/84/1924',3,0),(1925,50,1785,'/1/84/1925',3,0),(1926,50,1786,'/1/84/1926',3,0),(1927,50,1787,'/1/84/1927',3,0),(1928,50,1788,'/1/84/1928',3,0),(1929,50,1789,'/1/84/1929',3,0),(1930,50,1790,'/1/84/1930',3,0),(1931,50,1791,'/1/84/1931',3,0),(1932,50,1792,'/1/84/1932',3,0),(1933,50,1793,'/1/84/1933',3,0),(1934,50,1794,'/1/84/1934',3,0),(1935,50,1795,'/1/84/1935',3,0),(1936,50,1796,'/1/84/1936',3,0),(1937,50,1797,'/1/84/1937',3,0),(1938,50,1798,'/1/84/1938',3,0),(1939,50,1799,'/1/84/1939',3,0),(1940,50,1800,'/1/84/1940',3,0),(1941,50,1801,'/1/84/1941',3,0),(1942,50,1802,'/1/84/1942',3,0),(1943,50,1803,'/1/84/1943',3,0),(1944,50,1804,'/1/84/1944',3,0),(1945,50,1805,'/1/84/1945',3,0),(1946,50,1806,'/1/84/1946',3,0),(1947,50,1807,'/1/84/1947',3,0),(1948,50,1808,'/1/84/1948',3,0),(1949,50,1809,'/1/84/1949',3,0),(1950,50,1810,'/1/84/1950',3,0),(1951,50,1811,'/1/84/1951',3,0),(1952,50,1812,'/1/84/1952',3,0),(1953,50,1813,'/1/84/1953',3,0),(1954,50,1814,'/1/84/1954',3,0),(1955,50,1815,'/1/84/1955',3,0),(1956,50,1816,'/1/84/1956',3,0),(1957,50,1817,'/1/84/1957',3,0),(1958,50,1818,'/1/84/1958',3,0),(1959,50,1819,'/1/84/1959',3,0),(1960,50,1820,'/1/84/1960',3,0),(1961,50,1821,'/1/84/1961',3,0),(1962,50,1822,'/1/84/1962',3,0),(1963,50,1823,'/1/84/1963',3,0),(1964,50,1824,'/1/84/1964',3,0),(1965,50,1825,'/1/84/1965',3,0),(1966,50,1826,'/1/84/1966',3,0),(1967,50,1827,'/1/84/1967',3,0),(1968,50,1828,'/1/84/1968',3,0),(1969,50,1829,'/1/84/1969',3,0),(1970,50,1830,'/1/84/1970',3,0),(1971,50,1831,'/1/84/1971',3,0),(1972,50,1832,'/1/84/1972',3,0),(1973,50,1833,'/1/84/1973',3,0),(1974,50,1834,'/1/84/1974',3,0),(1975,50,1835,'/1/84/1975',3,0),(1976,50,1836,'/1/84/1976',3,0),(1977,50,1837,'/1/84/1977',3,0),(1978,50,1838,'/1/84/1978',3,0),(1979,50,1839,'/1/84/1979',3,0),(1980,50,1840,'/1/84/1980',3,0),(1981,50,1841,'/1/84/1981',3,0),(1982,50,1842,'/1/84/1982',3,0),(1983,50,1843,'/1/84/1983',3,0),(1984,50,1844,'/1/84/1984',3,0),(1985,50,1845,'/1/84/1985',3,0),(1986,50,1846,'/1/84/1986',3,0),(1987,50,1847,'/1/84/1987',3,0),(1988,50,1848,'/1/84/1988',3,0),(1989,50,1849,'/1/84/1989',3,0),(1990,50,1850,'/1/84/1990',3,0),(1991,50,1851,'/1/84/1991',3,0),(1992,50,1852,'/1/84/1992',3,0),(1993,50,1853,'/1/84/1993',3,0),(1994,50,1854,'/1/84/1994',3,0),(1995,50,1855,'/1/84/1995',3,0),(1996,50,1856,'/1/84/1996',3,0),(1997,50,1857,'/1/84/1997',3,0),(1998,50,1858,'/1/84/1998',3,0),(1999,50,1859,'/1/84/1999',3,0),(2000,50,1860,'/1/84/2000',3,0),(2001,50,1861,'/1/84/2001',3,0),(2002,50,1862,'/1/84/2002',3,0),(2003,50,1863,'/1/84/2003',3,0),(2004,50,1864,'/1/84/2004',3,0),(2005,50,1865,'/1/84/2005',3,0),(2006,50,1866,'/1/84/2006',3,0),(2007,50,1867,'/1/84/2007',3,0),(2008,50,1868,'/1/84/2008',3,0),(2009,50,1869,'/1/84/2009',3,0),(2010,50,1870,'/1/84/2010',3,0),(2011,50,1871,'/1/84/2011',3,0),(2012,50,1872,'/1/84/2012',3,0),(2013,50,1873,'/1/84/2013',3,0),(2014,50,1874,'/1/84/2014',3,0),(2015,50,1875,'/1/84/2015',3,0),(2016,50,1876,'/1/84/2016',3,0),(2017,50,1877,'/1/84/2017',3,0),(2018,50,1878,'/1/84/2018',3,0),(2019,50,1879,'/1/84/2019',3,0),(2020,50,1880,'/1/84/2020',3,0),(2021,50,1881,'/1/84/2021',3,0),(2022,50,1882,'/1/84/2022',3,0),(2023,50,1883,'/1/84/2023',3,0),(2024,50,1884,'/1/84/2024',3,0),(2025,50,1885,'/1/84/2025',3,0),(2026,50,1886,'/1/84/2026',3,0),(2027,50,1887,'/1/84/2027',3,0),(2028,50,1888,'/1/84/2028',3,0),(2029,50,1889,'/1/84/2029',3,0),(2030,50,1890,'/1/84/2030',3,0),(2031,50,1891,'/1/84/2031',3,0),(2032,50,1892,'/1/84/2032',3,0),(2033,50,1893,'/1/84/2033',3,0),(2034,50,1894,'/1/84/2034',3,0),(2035,50,1895,'/1/84/2035',3,0),(2036,50,1896,'/1/84/2036',3,0),(2037,50,1897,'/1/84/2037',3,0),(2038,50,1898,'/1/84/2038',3,0),(2039,50,1899,'/1/84/2039',3,0),(2040,50,1900,'/1/84/2040',3,0),(2041,50,1901,'/1/84/2041',3,0),(2042,50,1902,'/1/84/2042',3,0),(2043,50,1903,'/1/84/2043',3,0),(2044,50,1904,'/1/84/2044',3,0),(2045,50,1905,'/1/84/2045',3,0),(2046,50,1906,'/1/84/2046',3,0),(2047,50,1907,'/1/84/2047',3,0),(2048,50,1908,'/1/84/2048',3,0),(2049,50,1909,'/1/84/2049',3,0),(2050,50,1910,'/1/84/2050',3,0),(2051,50,1911,'/1/84/2051',3,0),(2052,50,1912,'/1/84/2052',3,0),(2053,50,1913,'/1/84/2053',3,0),(2054,50,1914,'/1/84/2054',3,0),(2055,50,1915,'/1/84/2055',3,0),(2056,50,1916,'/1/84/2056',3,0),(2057,50,1917,'/1/84/2057',3,0),(2058,50,1918,'/1/84/2058',3,0),(2059,50,1919,'/1/84/2059',3,0),(2060,50,1920,'/1/84/2060',3,0),(2061,50,1921,'/1/84/2061',3,0),(2062,50,1922,'/1/84/2062',3,0),(2063,50,1923,'/1/84/2063',3,0),(2064,50,1924,'/1/84/2064',3,0),(2065,50,1925,'/1/84/2065',3,0),(2066,50,1926,'/1/84/2066',3,0),(2067,50,1927,'/1/84/2067',3,0),(2068,50,1928,'/1/84/2068',3,0),(2069,50,1929,'/1/84/2069',3,0),(2070,50,1930,'/1/84/2070',3,0),(2071,50,1931,'/1/84/2071',3,0),(2072,50,1932,'/1/84/2072',3,0),(2073,50,1933,'/1/84/2073',3,0),(2074,50,1934,'/1/84/2074',3,0),(2075,50,1935,'/1/84/2075',3,0),(2076,50,1936,'/1/84/2076',3,0),(2077,50,1937,'/1/84/2077',3,0),(2078,50,1938,'/1/84/2078',3,0),(2079,50,1939,'/1/84/2079',3,0),(2080,50,1940,'/1/84/2080',3,0),(2081,50,1941,'/1/84/2081',3,0),(2082,50,1942,'/1/84/2082',3,0),(2083,50,1943,'/1/84/2083',3,0),(2084,50,1944,'/1/84/2084',3,0),(2085,50,1945,'/1/84/2085',3,0),(2086,50,1946,'/1/84/2086',3,0),(2087,50,1947,'/1/84/2087',3,0),(2088,50,1948,'/1/84/2088',3,0),(2089,50,1949,'/1/84/2089',3,0),(2090,50,1950,'/1/84/2090',3,0),(2091,50,1951,'/1/84/2091',3,0),(2092,50,1952,'/1/84/2092',3,0),(2093,50,1953,'/1/84/2093',3,0),(2094,50,1954,'/1/84/2094',3,0),(2095,50,1955,'/1/84/2095',3,0),(2096,50,1956,'/1/84/2096',3,0),(2097,50,1957,'/1/84/2097',3,0),(2098,50,1958,'/1/84/2098',3,0),(2099,50,1959,'/1/84/2099',3,0),(2100,50,1960,'/1/84/2100',3,0),(2101,50,1961,'/1/84/2101',3,0),(2102,50,1962,'/1/84/2102',3,0),(2103,50,1963,'/1/84/2103',3,0),(2104,50,1964,'/1/84/2104',3,0),(2105,50,1965,'/1/84/2105',3,0),(2106,50,1966,'/1/84/2106',3,0),(2107,50,1967,'/1/84/2107',3,0),(2108,50,1968,'/1/84/2108',3,0),(2109,50,1969,'/1/84/2109',3,0),(2110,50,1970,'/1/84/2110',3,0),(2111,50,1971,'/1/84/2111',3,0),(2112,50,1972,'/1/84/2112',3,0),(2113,50,1973,'/1/84/2113',3,0),(2114,50,1974,'/1/84/2114',3,0),(2115,50,1975,'/1/84/2115',3,0),(2116,50,1976,'/1/84/2116',3,0),(2117,50,1977,'/1/84/2117',3,0),(2118,50,1978,'/1/84/2118',3,0),(2119,50,1979,'/1/84/2119',3,0),(2120,50,1980,'/1/84/2120',3,0),(2121,50,1981,'/1/84/2121',3,0),(2122,50,1982,'/1/84/2122',3,0),(2123,50,1983,'/1/84/2123',3,0),(2124,50,1984,'/1/84/2124',3,0),(2125,50,1985,'/1/84/2125',3,0),(2126,50,1986,'/1/84/2126',3,0),(2127,50,1987,'/1/84/2127',3,0),(2128,50,1988,'/1/84/2128',3,0),(2129,50,1989,'/1/84/2129',3,0),(2130,50,1990,'/1/84/2130',3,0),(2131,50,1991,'/1/84/2131',3,0),(2132,50,1992,'/1/84/2132',3,0),(2133,50,1993,'/1/84/2133',3,0),(2134,50,1994,'/1/84/2134',3,0),(2135,50,1995,'/1/84/2135',3,0),(2136,50,1996,'/1/84/2136',3,0),(2137,50,1997,'/1/84/2137',3,0),(2138,50,1998,'/1/84/2138',3,0),(2139,50,1999,'/1/84/2139',3,0),(2140,50,2000,'/1/84/2140',3,0),(2141,50,2001,'/1/84/2141',3,0),(2142,50,2002,'/1/84/2142',3,0),(2143,50,2003,'/1/84/2143',3,0),(2144,50,2004,'/1/84/2144',3,0),(2145,50,2005,'/1/84/2145',3,0),(2146,50,2006,'/1/84/2146',3,0),(2147,50,2007,'/1/84/2147',3,0),(2148,50,2008,'/1/84/2148',3,0),(2149,50,2009,'/1/84/2149',3,0),(2150,50,2010,'/1/84/2150',3,0),(2151,50,2011,'/1/84/2151',3,0),(2152,50,2012,'/1/84/2152',3,0),(2153,50,2013,'/1/84/2153',3,0),(2154,50,2014,'/1/84/2154',3,0),(2155,50,2015,'/1/84/2155',3,0),(2156,50,2016,'/1/84/2156',3,0),(2157,50,2017,'/1/84/2157',3,0),(2158,50,2018,'/1/84/2158',3,0),(2159,50,2019,'/1/84/2159',3,0),(2160,50,2020,'/1/84/2160',3,0),(2161,50,2021,'/1/84/2161',3,0),(2162,50,2022,'/1/84/2162',3,0),(2163,50,2023,'/1/84/2163',3,0),(2164,50,2024,'/1/84/2164',3,0),(2165,50,2025,'/1/84/2165',3,0),(2166,50,2026,'/1/84/2166',3,0),(2167,50,2027,'/1/84/2167',3,0),(2168,50,2028,'/1/84/2168',3,0),(2169,50,2029,'/1/84/2169',3,0),(2170,50,2030,'/1/84/2170',3,0),(2171,50,2031,'/1/84/2171',3,0),(2172,50,2032,'/1/84/2172',3,0),(2173,50,2033,'/1/84/2173',3,0),(2174,50,2034,'/1/84/2174',3,0),(2175,50,2035,'/1/84/2175',3,0),(2176,50,2036,'/1/84/2176',3,0),(2177,50,2037,'/1/84/2177',3,0),(2178,50,2038,'/1/84/2178',3,0),(2179,50,2039,'/1/84/2179',3,0),(2180,50,2040,'/1/84/2180',3,0),(2181,50,2041,'/1/84/2181',3,0),(2182,50,2042,'/1/84/2182',3,0),(2183,50,2043,'/1/84/2183',3,0),(2184,50,2044,'/1/84/2184',3,0),(2185,50,2045,'/1/84/2185',3,0),(2186,50,2046,'/1/84/2186',3,0),(2187,50,2047,'/1/84/2187',3,0),(2188,50,2048,'/1/84/2188',3,0),(2189,50,2049,'/1/84/2189',3,0),(2190,50,2050,'/1/84/2190',3,0),(2191,50,2051,'/1/84/2191',3,0),(2192,50,2052,'/1/84/2192',3,0),(2193,50,2053,'/1/84/2193',3,0),(2194,50,2054,'/1/84/2194',3,0),(2195,50,2055,'/1/84/2195',3,0),(2196,50,2056,'/1/84/2196',3,0),(2197,50,2057,'/1/84/2197',3,0),(2198,50,2058,'/1/84/2198',3,0),(2199,50,2059,'/1/84/2199',3,0),(2200,50,2060,'/1/84/2200',3,0),(2201,50,2061,'/1/84/2201',3,0),(2202,50,2062,'/1/84/2202',3,0),(2203,50,2063,'/1/84/2203',3,0),(2204,50,2064,'/1/84/2204',3,0),(2205,50,2065,'/1/84/2205',3,0),(2206,50,2066,'/1/84/2206',3,0),(2207,50,2067,'/1/84/2207',3,0),(2208,50,2068,'/1/84/2208',3,0),(2209,50,2069,'/1/84/2209',3,0),(2210,50,2070,'/1/84/2210',3,0),(2211,50,2071,'/1/84/2211',3,0),(2212,50,2072,'/1/84/2212',3,0),(2213,50,2073,'/1/84/2213',3,0),(2214,50,2074,'/1/84/2214',3,0),(2215,50,2075,'/1/84/2215',3,0),(2216,50,2076,'/1/84/2216',3,0),(2217,50,2077,'/1/84/2217',3,0),(2218,50,2078,'/1/84/2218',3,0),(2219,50,2079,'/1/84/2219',3,0),(2220,50,2080,'/1/84/2220',3,0),(2221,50,2081,'/1/84/2221',3,0),(2222,50,2082,'/1/84/2222',3,0),(2223,50,2083,'/1/84/2223',3,0),(2224,50,2084,'/1/84/2224',3,0),(2225,50,2085,'/1/84/2225',3,0),(2226,50,2086,'/1/84/2226',3,0),(2227,50,2087,'/1/84/2227',3,0),(2228,50,2088,'/1/84/2228',3,0),(2229,50,2089,'/1/84/2229',3,0),(2230,50,2090,'/1/84/2230',3,0),(2231,50,2091,'/1/84/2231',3,0),(2232,50,2092,'/1/84/2232',3,0),(2233,50,2093,'/1/84/2233',3,0),(2234,50,2094,'/1/84/2234',3,0),(2235,50,2095,'/1/84/2235',3,0),(2236,50,2096,'/1/84/2236',3,0),(2237,50,2097,'/1/84/2237',3,0),(2238,50,2098,'/1/84/2238',3,0),(2239,50,2099,'/1/84/2239',3,0),(2240,50,2100,'/1/84/2240',3,0),(2241,50,2101,'/1/84/2241',3,0),(2242,50,2102,'/1/84/2242',3,0),(2243,50,2103,'/1/84/2243',3,0),(2244,50,2104,'/1/84/2244',3,0),(2245,50,2105,'/1/84/2245',3,0),(2246,50,2106,'/1/84/2246',3,0),(2247,50,2107,'/1/84/2247',3,0),(2248,50,2108,'/1/84/2248',3,0),(2249,50,2109,'/1/84/2249',3,0),(2250,50,2110,'/1/84/2250',3,0),(2251,50,2111,'/1/84/2251',3,0),(2252,50,2112,'/1/84/2252',3,0),(2253,50,2113,'/1/84/2253',3,0),(2254,50,2114,'/1/84/2254',3,0),(2255,50,2115,'/1/84/2255',3,0),(2256,50,2116,'/1/84/2256',3,0),(2257,50,2117,'/1/84/2257',3,0),(2258,50,2118,'/1/84/2258',3,0),(2259,50,2119,'/1/84/2259',3,0),(2260,50,2120,'/1/84/2260',3,0),(2261,50,2121,'/1/84/2261',3,0),(2262,50,2122,'/1/84/2262',3,0),(2263,50,2123,'/1/84/2263',3,0),(2264,50,2124,'/1/84/2264',3,0),(2265,50,2125,'/1/84/2265',3,0),(2266,50,2126,'/1/84/2266',3,0),(2267,50,2127,'/1/84/2267',3,0),(2268,50,2128,'/1/84/2268',3,0),(2269,50,2129,'/1/84/2269',3,0),(2270,50,2130,'/1/84/2270',3,0),(2271,50,2131,'/1/84/2271',3,0),(2272,50,2132,'/1/84/2272',3,0),(2273,50,2133,'/1/84/2273',3,0),(2274,50,2134,'/1/84/2274',3,0),(2275,50,2135,'/1/84/2275',3,0),(2276,50,2136,'/1/84/2276',3,0),(2277,50,2137,'/1/84/2277',3,0),(2278,50,2138,'/1/84/2278',3,0),(2279,50,2139,'/1/84/2279',3,0),(2280,50,2140,'/1/84/2280',3,0),(2281,50,2141,'/1/84/2281',3,0),(2282,50,2142,'/1/84/2282',3,0),(2283,50,2143,'/1/84/2283',3,0),(2284,50,2144,'/1/84/2284',3,0),(2285,50,2145,'/1/84/2285',3,0),(2286,50,2146,'/1/84/2286',3,0),(2287,50,2147,'/1/84/2287',3,0),(2288,50,2148,'/1/84/2288',3,0),(2289,50,2149,'/1/84/2289',3,0),(2290,50,2150,'/1/84/2290',3,0),(2291,50,2151,'/1/84/2291',3,0),(2292,50,2152,'/1/84/2292',3,0),(2293,50,2153,'/1/84/2293',3,0),(2294,50,2154,'/1/84/2294',3,0),(2295,50,2155,'/1/84/2295',3,0),(2296,50,2156,'/1/84/2296',3,0),(2297,50,2157,'/1/84/2297',3,0),(2298,50,2158,'/1/84/2298',3,0),(2299,50,2159,'/1/84/2299',3,0),(2300,50,2160,'/1/84/2300',3,0),(2301,50,2161,'/1/84/2301',3,0),(2302,50,2162,'/1/84/2302',3,0),(2303,50,2163,'/1/84/2303',3,0),(2304,50,2164,'/1/84/2304',3,0),(2305,50,2165,'/1/84/2305',3,0),(2306,50,2166,'/1/84/2306',3,0),(2307,50,2167,'/1/84/2307',3,0),(2308,50,2168,'/1/84/2308',3,0),(2309,50,2169,'/1/84/2309',3,0),(2310,50,2170,'/1/84/2310',3,0),(2311,50,2171,'/1/84/2311',3,0),(2312,50,2172,'/1/84/2312',3,0),(2313,50,2173,'/1/84/2313',3,0),(2314,50,2174,'/1/84/2314',3,0),(2315,50,2175,'/1/84/2315',3,0),(2316,50,2176,'/1/84/2316',3,0),(2317,50,2177,'/1/84/2317',3,0),(2318,50,2178,'/1/84/2318',3,0),(2319,50,2179,'/1/84/2319',3,0),(2320,50,2180,'/1/84/2320',3,0),(2321,50,2181,'/1/84/2321',3,0),(2322,50,2182,'/1/84/2322',3,0),(2323,50,2183,'/1/84/2323',3,0),(2324,50,2184,'/1/84/2324',3,0),(2325,50,2185,'/1/84/2325',3,0),(2326,50,2186,'/1/84/2326',3,0),(2327,50,2187,'/1/84/2327',3,0),(2328,50,2188,'/1/84/2328',3,0),(2329,50,2189,'/1/84/2329',3,0),(2330,50,2190,'/1/84/2330',3,0),(2331,50,2191,'/1/84/2331',3,0),(2332,50,2192,'/1/84/2332',3,0),(2333,50,2193,'/1/84/2333',3,0),(2334,50,2194,'/1/84/2334',3,0),(2335,50,2195,'/1/84/2335',3,0),(2336,50,2196,'/1/84/2336',3,0),(2337,50,2197,'/1/84/2337',3,0),(2338,50,2198,'/1/84/2338',3,0),(2339,50,2199,'/1/84/2339',3,0),(2340,50,2200,'/1/84/2340',3,0),(2341,50,2201,'/1/84/2341',3,0),(2342,50,2202,'/1/84/2342',3,0),(2343,50,2203,'/1/84/2343',3,0),(2344,50,2204,'/1/84/2344',3,0),(2345,50,2205,'/1/84/2345',3,0),(2346,50,2206,'/1/84/2346',3,0),(2347,50,2207,'/1/84/2347',3,0),(2348,50,2208,'/1/84/2348',3,0),(2349,50,2209,'/1/84/2349',3,0),(2350,50,2210,'/1/84/2350',3,0),(2351,50,2211,'/1/84/2351',3,0),(2352,50,2212,'/1/84/2352',3,0),(2353,50,2213,'/1/84/2353',3,0),(2354,50,2214,'/1/84/2354',3,0),(2355,50,2215,'/1/84/2355',3,0),(2356,50,2216,'/1/84/2356',3,0),(2357,50,2217,'/1/84/2357',3,0),(2358,50,2218,'/1/84/2358',3,0),(2359,50,2219,'/1/84/2359',3,0),(2360,50,2220,'/1/84/2360',3,0),(2361,50,2221,'/1/84/2361',3,0),(2362,50,2222,'/1/84/2362',3,0),(2363,50,2223,'/1/84/2363',3,0),(2364,50,2224,'/1/84/2364',3,0),(2365,50,2225,'/1/84/2365',3,0),(2366,50,2226,'/1/84/2366',3,0),(2367,50,2227,'/1/84/2367',3,0),(2368,50,2228,'/1/84/2368',3,0),(2369,50,2229,'/1/84/2369',3,0),(2370,50,2230,'/1/84/2370',3,0),(2371,50,2231,'/1/84/2371',3,0),(2372,50,2232,'/1/84/2372',3,0),(2373,50,2233,'/1/84/2373',3,0),(2374,50,2234,'/1/84/2374',3,0),(2375,50,2235,'/1/84/2375',3,0),(2376,50,2236,'/1/84/2376',3,0),(2377,50,2237,'/1/84/2377',3,0),(2378,50,2238,'/1/84/2378',3,0),(2379,50,2239,'/1/84/2379',3,0),(2380,50,2240,'/1/84/2380',3,0),(2381,50,2241,'/1/84/2381',3,0),(2382,50,2242,'/1/84/2382',3,0),(2383,50,2243,'/1/84/2383',3,0),(2384,50,2244,'/1/84/2384',3,0),(2385,50,2245,'/1/84/2385',3,0),(2386,50,2246,'/1/84/2386',3,0),(2387,50,2247,'/1/84/2387',3,0),(2388,50,2248,'/1/84/2388',3,0),(2389,50,2249,'/1/84/2389',3,0),(2390,50,2250,'/1/84/2390',3,0),(2391,50,2251,'/1/84/2391',3,0),(2392,50,2252,'/1/84/2392',3,0),(2393,50,2253,'/1/84/2393',3,0),(2394,50,2254,'/1/84/2394',3,0),(2395,50,2255,'/1/84/2395',3,0),(2396,50,2256,'/1/84/2396',3,0),(2397,50,2257,'/1/84/2397',3,0),(2398,50,2258,'/1/84/2398',3,0),(2399,50,2259,'/1/84/2399',3,0),(2400,50,2260,'/1/84/2400',3,0),(2401,50,2261,'/1/84/2401',3,0),(2402,50,2262,'/1/84/2402',3,0),(2403,50,2263,'/1/84/2403',3,0),(2404,50,2264,'/1/84/2404',3,0),(2405,50,2265,'/1/84/2405',3,0),(2406,50,2266,'/1/84/2406',3,0),(2407,50,2267,'/1/84/2407',3,0),(2408,50,2268,'/1/84/2408',3,0),(2409,50,2269,'/1/84/2409',3,0),(2410,50,2270,'/1/84/2410',3,0),(2411,50,2271,'/1/84/2411',3,0),(2412,50,2272,'/1/84/2412',3,0),(2413,50,2273,'/1/84/2413',3,0),(2414,50,2274,'/1/84/2414',3,0),(2415,50,2275,'/1/84/2415',3,0),(2416,50,2276,'/1/84/2416',3,0),(2417,50,2277,'/1/84/2417',3,0),(2418,50,2278,'/1/84/2418',3,0),(2419,50,2279,'/1/84/2419',3,0),(2420,50,2280,'/1/84/2420',3,0),(2421,50,2281,'/1/84/2421',3,0),(2422,50,2282,'/1/84/2422',3,0),(2423,50,2283,'/1/84/2423',3,0),(2424,50,2284,'/1/84/2424',3,0),(2425,50,2285,'/1/84/2425',3,0),(2426,50,2286,'/1/84/2426',3,0),(2427,50,2287,'/1/84/2427',3,0),(2428,50,2288,'/1/84/2428',3,0),(2429,50,2289,'/1/84/2429',3,0),(2430,50,2290,'/1/84/2430',3,0),(2431,50,2291,'/1/84/2431',3,0),(2432,50,2292,'/1/84/2432',3,0),(2433,50,2293,'/1/84/2433',3,0),(2434,50,2294,'/1/84/2434',3,0),(2435,50,2295,'/1/84/2435',3,0),(2436,50,2296,'/1/84/2436',3,0),(2437,50,2297,'/1/84/2437',3,0),(2438,50,2298,'/1/84/2438',3,0),(2439,50,2299,'/1/84/2439',3,0),(2440,50,2300,'/1/84/2440',3,0),(2441,50,2301,'/1/84/2441',3,0),(2442,50,2302,'/1/84/2442',3,0),(2443,50,2303,'/1/84/2443',3,0),(2444,50,2304,'/1/84/2444',3,0),(2445,50,2305,'/1/84/2445',3,0),(2446,50,2306,'/1/84/2446',3,0),(2447,50,2307,'/1/84/2447',3,0),(2448,50,2308,'/1/84/2448',3,0),(2449,50,2309,'/1/84/2449',3,0),(2450,50,2310,'/1/84/2450',3,0),(2451,50,2311,'/1/84/2451',3,0),(2452,50,2312,'/1/84/2452',3,0),(2453,50,2313,'/1/84/2453',3,0),(2454,50,2314,'/1/84/2454',3,0),(2455,50,2315,'/1/84/2455',3,0),(2456,50,2316,'/1/84/2456',3,0),(2457,50,2317,'/1/84/2457',3,0),(2458,50,2318,'/1/84/2458',3,0),(2459,50,2319,'/1/84/2459',3,0),(2460,50,2320,'/1/84/2460',3,0),(2461,50,2321,'/1/84/2461',3,0),(2462,50,2322,'/1/84/2462',3,0),(2463,50,2323,'/1/84/2463',3,0),(2464,50,2324,'/1/84/2464',3,0),(2465,50,2325,'/1/84/2465',3,0),(2466,50,2326,'/1/84/2466',3,0),(2467,50,2327,'/1/84/2467',3,0),(2468,50,2328,'/1/84/2468',3,0),(2469,50,2329,'/1/84/2469',3,0),(2470,50,2330,'/1/84/2470',3,0),(2471,50,2331,'/1/84/2471',3,0),(2472,50,2332,'/1/84/2472',3,0),(2473,50,2333,'/1/84/2473',3,0),(2474,50,2334,'/1/84/2474',3,0),(2475,50,2335,'/1/84/2475',3,0),(2476,50,2336,'/1/84/2476',3,0),(2477,50,2337,'/1/84/2477',3,0),(2478,50,2338,'/1/84/2478',3,0),(2479,50,2339,'/1/84/2479',3,0),(2480,50,2340,'/1/84/2480',3,0),(2481,50,2341,'/1/84/2481',3,0),(2482,50,2342,'/1/84/2482',3,0),(2483,50,2343,'/1/84/2483',3,0),(2484,50,2344,'/1/84/2484',3,0),(2485,50,2345,'/1/84/2485',3,0),(2486,50,2346,'/1/84/2486',3,0),(2487,50,2347,'/1/84/2487',3,0),(2488,50,2348,'/1/84/2488',3,0),(2489,50,2349,'/1/84/2489',3,0),(2490,50,2350,'/1/84/2490',3,0),(2491,50,2351,'/1/84/2491',3,0),(2492,50,2352,'/1/84/2492',3,0),(2493,50,2353,'/1/84/2493',3,0),(2494,50,2354,'/1/84/2494',3,0),(2495,50,2355,'/1/84/2495',3,0),(2496,50,2356,'/1/84/2496',3,0),(2497,50,2357,'/1/84/2497',3,0),(2498,50,2358,'/1/84/2498',3,0),(2499,50,2359,'/1/84/2499',3,0),(2500,50,2360,'/1/84/2500',3,0),(2501,50,2361,'/1/84/2501',3,0),(2502,50,2362,'/1/84/2502',3,0),(2503,50,2363,'/1/84/2503',3,0),(2504,50,2364,'/1/84/2504',3,0),(2505,50,2365,'/1/84/2505',3,0),(2506,50,2366,'/1/84/2506',3,0),(2507,50,2367,'/1/84/2507',3,0),(2508,50,2368,'/1/84/2508',3,0),(2509,50,2369,'/1/84/2509',3,0),(2510,50,2370,'/1/84/2510',3,0),(2511,50,2371,'/1/84/2511',3,0),(2512,50,2372,'/1/84/2512',3,0),(2513,50,2373,'/1/84/2513',3,0),(2514,50,2374,'/1/84/2514',3,0),(2515,50,2375,'/1/84/2515',3,0),(2516,50,2376,'/1/84/2516',3,0),(2517,50,2377,'/1/84/2517',3,0),(2518,50,2378,'/1/84/2518',3,0),(2519,50,2379,'/1/84/2519',3,0),(2520,50,2380,'/1/84/2520',3,0),(2521,50,2381,'/1/84/2521',3,0),(2522,50,2382,'/1/84/2522',3,0),(2523,50,2383,'/1/84/2523',3,0),(2524,50,2384,'/1/84/2524',3,0),(2525,50,2385,'/1/84/2525',3,0),(2526,50,2386,'/1/84/2526',3,0),(2527,50,2387,'/1/84/2527',3,0),(2528,50,2388,'/1/84/2528',3,0),(2529,50,2389,'/1/84/2529',3,0),(2530,50,2390,'/1/84/2530',3,0),(2531,50,2391,'/1/84/2531',3,0),(2532,50,2392,'/1/84/2532',3,0),(2533,50,2393,'/1/84/2533',3,0),(2534,50,2394,'/1/84/2534',3,0),(2535,50,2395,'/1/84/2535',3,0),(2536,50,2396,'/1/84/2536',3,0),(2537,50,2397,'/1/84/2537',3,0),(2538,50,2398,'/1/84/2538',3,0),(2539,50,2399,'/1/84/2539',3,0),(2540,50,2400,'/1/84/2540',3,0),(2541,50,2401,'/1/84/2541',3,0),(2542,50,2402,'/1/84/2542',3,0),(2543,50,2403,'/1/84/2543',3,0),(2544,50,2404,'/1/84/2544',3,0),(2545,50,2405,'/1/84/2545',3,0),(2546,50,2406,'/1/84/2546',3,0),(2547,50,2407,'/1/84/2547',3,0),(2548,50,2408,'/1/84/2548',3,0),(2549,50,2409,'/1/84/2549',3,0),(2550,50,2410,'/1/84/2550',3,0),(2551,50,2411,'/1/84/2551',3,0),(2552,50,2412,'/1/84/2552',3,0),(2553,50,2413,'/1/84/2553',3,0),(2554,50,2414,'/1/84/2554',3,0),(2555,50,2415,'/1/84/2555',3,0),(2556,50,2416,'/1/84/2556',3,0),(2557,50,2417,'/1/84/2557',3,0),(2558,50,2418,'/1/84/2558',3,0),(2559,50,2419,'/1/84/2559',3,0),(2560,50,2420,'/1/84/2560',3,0),(2561,50,2421,'/1/84/2561',3,0),(2562,50,2422,'/1/84/2562',3,0),(2563,50,2423,'/1/84/2563',3,0),(2564,50,2424,'/1/84/2564',3,0),(2565,50,2425,'/1/84/2565',3,0),(2566,50,2426,'/1/84/2566',3,0),(2567,50,2427,'/1/84/2567',3,0),(2568,50,2428,'/1/84/2568',3,0),(2569,50,2429,'/1/84/2569',3,0),(2570,50,2430,'/1/84/2570',3,0),(2571,50,2431,'/1/84/2571',3,0),(2572,50,2432,'/1/84/2572',3,0),(2573,50,2433,'/1/84/2573',3,0),(2574,50,2434,'/1/84/2574',3,0),(2575,50,2435,'/1/84/2575',3,0),(2576,50,2436,'/1/84/2576',3,0),(2577,50,2437,'/1/84/2577',3,0),(2578,50,2438,'/1/84/2578',3,0),(2579,50,2439,'/1/84/2579',3,0),(2580,50,2440,'/1/84/2580',3,0),(2581,50,2441,'/1/84/2581',3,0),(2582,50,2442,'/1/84/2582',3,0),(2583,50,2443,'/1/84/2583',3,0),(2584,50,2444,'/1/84/2584',3,0),(2585,50,2445,'/1/84/2585',3,0),(2586,50,2446,'/1/84/2586',3,0),(2587,50,2447,'/1/84/2587',3,0),(2588,50,2448,'/1/84/2588',3,0),(2589,50,2449,'/1/84/2589',3,0),(2590,50,2450,'/1/84/2590',3,0),(2591,50,2451,'/1/84/2591',3,0),(2592,50,2452,'/1/84/2592',3,0),(2593,50,2453,'/1/84/2593',3,0),(2594,50,2454,'/1/84/2594',3,0),(2595,50,2455,'/1/84/2595',3,0),(2596,50,2456,'/1/84/2596',3,0),(2597,50,2457,'/1/84/2597',3,0),(2598,50,2458,'/1/84/2598',3,0),(2599,50,2459,'/1/84/2599',3,0),(2600,50,2460,'/1/84/2600',3,0),(2601,50,2461,'/1/84/2601',3,0),(2602,50,2462,'/1/84/2602',3,0),(2603,50,2463,'/1/84/2603',3,0),(2604,50,2464,'/1/84/2604',3,0),(2605,50,2465,'/1/84/2605',3,0),(2606,50,2466,'/1/84/2606',3,0),(2607,50,2467,'/1/84/2607',3,0),(2608,50,2468,'/1/84/2608',3,0),(2609,50,2469,'/1/84/2609',3,0),(2610,50,2470,'/1/84/2610',3,0),(2611,50,2471,'/1/84/2611',3,0),(2612,50,2472,'/1/84/2612',3,0),(2613,50,2473,'/1/84/2613',3,0),(2614,50,2474,'/1/84/2614',3,0),(2615,50,2475,'/1/84/2615',3,0),(2616,50,2476,'/1/84/2616',3,0),(2617,50,2477,'/1/84/2617',3,0),(2618,50,2478,'/1/84/2618',3,0),(2619,50,2479,'/1/84/2619',3,0),(2620,50,2480,'/1/84/2620',3,0),(2621,50,2481,'/1/84/2621',3,0),(2622,50,2482,'/1/84/2622',3,0),(2623,50,2483,'/1/84/2623',3,0),(2624,50,2484,'/1/84/2624',3,0),(2625,50,2485,'/1/84/2625',3,0),(2626,50,2486,'/1/84/2626',3,0),(2627,50,2487,'/1/84/2627',3,0),(2628,50,2488,'/1/84/2628',3,0),(2629,50,2489,'/1/84/2629',3,0),(2630,50,2490,'/1/84/2630',3,0),(2631,50,2491,'/1/84/2631',3,0),(2632,50,2492,'/1/84/2632',3,0),(2633,50,2493,'/1/84/2633',3,0),(2634,50,2494,'/1/84/2634',3,0),(2635,50,2495,'/1/84/2635',3,0),(2636,50,2496,'/1/84/2636',3,0),(2637,50,2497,'/1/84/2637',3,0),(2638,50,2498,'/1/84/2638',3,0),(2639,50,2499,'/1/84/2639',3,0),(2640,50,2500,'/1/84/2640',3,0),(2641,50,2501,'/1/84/2641',3,0),(2642,50,2502,'/1/84/2642',3,0),(2643,50,2503,'/1/84/2643',3,0),(2644,50,2504,'/1/84/2644',3,0),(2645,50,2505,'/1/84/2645',3,0),(2646,50,2506,'/1/84/2646',3,0),(2647,50,2507,'/1/84/2647',3,0),(2648,50,2508,'/1/84/2648',3,0),(2649,50,2509,'/1/84/2649',3,0),(2650,50,2510,'/1/84/2650',3,0),(2651,50,2511,'/1/84/2651',3,0),(2652,50,2512,'/1/84/2652',3,0),(2653,50,2513,'/1/84/2653',3,0),(2654,50,2514,'/1/84/2654',3,0),(2655,50,2515,'/1/84/2655',3,0),(2656,50,2516,'/1/84/2656',3,0),(2657,50,2517,'/1/84/2657',3,0),(2658,50,2518,'/1/84/2658',3,0),(2659,50,2519,'/1/84/2659',3,0),(2660,50,2520,'/1/84/2660',3,0),(2661,50,2521,'/1/84/2661',3,0),(2662,50,2522,'/1/84/2662',3,0),(2663,50,2523,'/1/84/2663',3,0),(2664,50,2524,'/1/84/2664',3,0),(2665,50,2525,'/1/84/2665',3,0),(2666,50,2526,'/1/84/2666',3,0),(2667,50,2527,'/1/84/2667',3,0),(2668,50,2528,'/1/84/2668',3,0),(2669,50,2529,'/1/84/2669',3,0),(2670,50,2530,'/1/84/2670',3,0),(2671,50,2531,'/1/84/2671',3,0),(2672,50,2532,'/1/84/2672',3,0),(2673,50,2533,'/1/84/2673',3,0),(2674,50,2534,'/1/84/2674',3,0),(2675,50,2535,'/1/84/2675',3,0),(2676,50,2536,'/1/84/2676',3,0),(2677,50,2537,'/1/84/2677',3,0),(2678,50,2538,'/1/84/2678',3,0),(2679,50,2539,'/1/84/2679',3,0),(2680,50,2540,'/1/84/2680',3,0),(2681,50,2541,'/1/84/2681',3,0),(2682,50,2542,'/1/84/2682',3,0),(2683,50,2543,'/1/84/2683',3,0),(2684,50,2544,'/1/84/2684',3,0),(2685,50,2545,'/1/84/2685',3,0),(2686,50,2546,'/1/84/2686',3,0),(2687,50,2547,'/1/84/2687',3,0),(2688,50,2548,'/1/84/2688',3,0),(2689,50,2549,'/1/84/2689',3,0),(2690,50,2550,'/1/84/2690',3,0),(2691,50,2551,'/1/84/2691',3,0),(2692,50,2552,'/1/84/2692',3,0),(2693,50,2553,'/1/84/2693',3,0),(2694,50,2554,'/1/84/2694',3,0),(2695,50,2555,'/1/84/2695',3,0),(2696,50,2556,'/1/84/2696',3,0),(2697,50,2557,'/1/84/2697',3,0),(2698,50,2558,'/1/84/2698',3,0),(2699,50,2559,'/1/84/2699',3,0),(2700,50,2560,'/1/84/2700',3,0),(2701,50,2561,'/1/84/2701',3,0),(2702,50,2562,'/1/84/2702',3,0),(2703,50,2563,'/1/84/2703',3,0),(2704,50,2564,'/1/84/2704',3,0),(2705,50,2565,'/1/84/2705',3,0),(2706,50,2566,'/1/84/2706',3,0),(2707,50,2567,'/1/84/2707',3,0),(2708,50,2568,'/1/84/2708',3,0),(2709,50,2569,'/1/84/2709',3,0),(2710,50,2570,'/1/84/2710',3,0),(2711,50,2571,'/1/84/2711',3,0),(2712,50,2572,'/1/84/2712',3,0),(2713,50,2573,'/1/84/2713',3,0),(2714,50,2574,'/1/84/2714',3,0),(2715,50,2575,'/1/84/2715',3,0),(2716,50,2576,'/1/84/2716',3,0),(2717,50,2577,'/1/84/2717',3,0),(2718,50,2578,'/1/84/2718',3,0),(2719,50,2579,'/1/84/2719',3,0),(2720,50,2580,'/1/84/2720',3,0),(2721,50,2581,'/1/84/2721',3,0),(2722,50,2582,'/1/84/2722',3,0),(2723,50,2583,'/1/84/2723',3,0),(2724,50,2584,'/1/84/2724',3,0),(2725,50,2585,'/1/84/2725',3,0),(2726,50,2586,'/1/84/2726',3,0),(2727,50,2587,'/1/84/2727',3,0),(2728,50,2588,'/1/84/2728',3,0),(2729,50,2589,'/1/84/2729',3,0),(2730,50,2590,'/1/84/2730',3,0),(2731,50,2591,'/1/84/2731',3,0),(2732,50,2592,'/1/84/2732',3,0),(2733,50,2593,'/1/84/2733',3,0),(2734,50,2594,'/1/84/2734',3,0),(2735,50,2595,'/1/84/2735',3,0),(2736,50,2596,'/1/84/2736',3,0),(2737,50,2597,'/1/84/2737',3,0),(2738,50,2598,'/1/84/2738',3,0),(2739,50,2599,'/1/84/2739',3,0),(2740,50,2600,'/1/84/2740',3,0),(2741,50,2601,'/1/84/2741',3,0),(2742,50,2602,'/1/84/2742',3,0),(2743,50,2603,'/1/84/2743',3,0),(2744,50,2604,'/1/84/2744',3,0),(2745,50,2605,'/1/84/2745',3,0),(2746,50,2606,'/1/84/2746',3,0),(2747,50,2607,'/1/84/2747',3,0),(2748,50,2608,'/1/84/2748',3,0),(2749,50,2609,'/1/84/2749',3,0),(2750,50,2610,'/1/84/2750',3,0),(2751,50,2611,'/1/84/2751',3,0),(2752,50,2612,'/1/84/2752',3,0),(2753,50,2613,'/1/84/2753',3,0),(2754,50,2614,'/1/84/2754',3,0),(2755,50,2615,'/1/84/2755',3,0),(2756,50,2616,'/1/84/2756',3,0),(2757,50,2617,'/1/84/2757',3,0),(2758,50,2618,'/1/84/2758',3,0),(2759,50,2619,'/1/84/2759',3,0),(2760,50,2620,'/1/84/2760',3,0),(2761,50,2621,'/1/84/2761',3,0),(2762,50,2622,'/1/84/2762',3,0),(2763,50,2623,'/1/84/2763',3,0),(2764,50,2624,'/1/84/2764',3,0),(2765,50,2625,'/1/84/2765',3,0),(2766,50,2626,'/1/84/2766',3,0),(2767,50,2627,'/1/84/2767',3,0),(2768,50,2628,'/1/84/2768',3,0),(2769,50,2629,'/1/84/2769',3,0),(2770,50,2630,'/1/84/2770',3,0),(2771,50,2631,'/1/84/2771',3,0),(2772,50,2632,'/1/84/2772',3,0),(2773,50,2633,'/1/84/2773',3,0),(2774,50,2634,'/1/84/2774',3,0),(2775,50,2635,'/1/84/2775',3,0),(2776,50,2636,'/1/84/2776',3,0),(2777,50,2637,'/1/84/2777',3,0),(2778,50,2638,'/1/84/2778',3,0),(2779,50,2639,'/1/84/2779',3,0),(2780,50,2640,'/1/84/2780',3,0),(2781,50,2641,'/1/84/2781',3,0),(2782,50,2642,'/1/84/2782',3,0),(2783,50,2643,'/1/84/2783',3,0),(2784,50,2644,'/1/84/2784',3,0),(2785,50,2645,'/1/84/2785',3,0),(2786,50,2646,'/1/84/2786',3,0),(2787,50,2647,'/1/84/2787',3,0),(2788,50,2648,'/1/84/2788',3,0),(2789,50,2649,'/1/84/2789',3,0),(2790,50,2650,'/1/84/2790',3,0),(2791,50,2651,'/1/84/2791',3,0),(2792,50,2652,'/1/84/2792',3,0),(2793,50,2653,'/1/84/2793',3,0),(2794,50,2654,'/1/84/2794',3,0),(2795,50,2655,'/1/84/2795',3,0),(2796,50,2656,'/1/84/2796',3,0),(2797,50,2657,'/1/84/2797',3,0),(2798,50,2658,'/1/84/2798',3,0),(2799,50,2659,'/1/84/2799',3,0),(2800,50,2660,'/1/84/2800',3,0),(2801,50,2661,'/1/84/2801',3,0),(2802,50,2662,'/1/84/2802',3,0),(2803,50,2663,'/1/84/2803',3,0),(2804,50,2664,'/1/84/2804',3,0),(2805,50,2665,'/1/84/2805',3,0),(2806,50,2666,'/1/84/2806',3,0),(2807,50,2667,'/1/84/2807',3,0),(2808,50,2668,'/1/84/2808',3,0),(2809,50,2669,'/1/84/2809',3,0),(2810,50,2670,'/1/84/2810',3,0),(2811,50,2671,'/1/84/2811',3,0),(2812,50,2672,'/1/84/2812',3,0),(2813,50,2673,'/1/84/2813',3,0),(2814,50,2674,'/1/84/2814',3,0),(2815,50,2675,'/1/84/2815',3,0),(2816,50,2676,'/1/84/2816',3,0),(2817,50,2677,'/1/84/2817',3,0),(2818,50,2678,'/1/84/2818',3,0),(2819,50,2679,'/1/84/2819',3,0),(2820,50,2680,'/1/84/2820',3,0),(2821,50,2681,'/1/84/2821',3,0),(2822,50,2682,'/1/84/2822',3,0),(2823,50,2683,'/1/84/2823',3,0),(2824,50,2684,'/1/84/2824',3,0),(2825,70,2692,'/1/84/2804/2825',4,0),(2885,70,89,'/1/84/201/2885',4,0),(2886,70,2725,'/1/84/201/2886',4,0),(2887,70,2724,'/1/84/200/2887',4,0),(2888,50,2685,'/1/84/2888',3,0),(2889,50,2686,'/1/84/2889',3,0),(2890,50,2687,'/1/84/2890',3,0),(2891,50,2688,'/1/84/2891',3,0),(2892,50,2689,'/1/84/2892',3,0),(2893,50,2690,'/1/84/2893',3,0),(2894,50,2691,'/1/84/2894',3,0),(2895,50,2692,'/1/84/2895',3,0),(2896,50,2693,'/1/84/2896',3,0),(2897,50,2694,'/1/84/2897',3,0),(2898,50,2695,'/1/84/2898',3,0),(2899,50,2696,'/1/84/2899',3,0),(2900,50,2697,'/1/84/2900',3,0),(2901,50,2698,'/1/84/2901',3,0),(2902,50,2699,'/1/84/2902',3,0),(2903,50,2700,'/1/84/2903',3,0),(2904,50,2701,'/1/84/2904',3,0),(2905,50,2702,'/1/84/2905',3,0),(2906,50,2703,'/1/84/2906',3,0),(2907,50,2704,'/1/84/2907',3,0),(2908,50,2705,'/1/84/2908',3,0),(2909,50,2706,'/1/84/2909',3,0),(2910,50,2707,'/1/84/2910',3,0),(2911,50,2708,'/1/84/2911',3,0),(2912,50,2709,'/1/84/2912',3,0),(2913,50,2710,'/1/84/2913',3,0),(2914,50,2711,'/1/84/2914',3,0),(2915,50,2712,'/1/84/2915',3,0),(2916,50,2713,'/1/84/2916',3,0),(2917,50,2714,'/1/84/2917',3,0),(2918,50,2715,'/1/84/2918',3,0),(2919,50,2716,'/1/84/2919',3,0),(2920,50,2717,'/1/84/2920',3,0),(2921,50,2718,'/1/84/2921',3,0),(2922,50,2719,'/1/84/2922',3,0),(2923,50,2720,'/1/84/2923',3,0),(2924,50,2721,'/1/84/2924',3,0),(2925,50,2722,'/1/84/2925',3,0),(2926,50,2723,'/1/84/2926',3,0),(2927,50,2724,'/1/84/2927',3,0),(2928,50,2725,'/1/84/2928',3,0),(2929,50,2726,'/1/84/2929',3,0),(2930,50,2727,'/1/84/2930',3,0),(2931,50,2728,'/1/84/2931',3,0),(2932,50,2729,'/1/84/2932',3,0),(2933,50,2730,'/1/84/2933',3,0),(2934,50,2731,'/1/84/2934',3,0),(2935,50,2732,'/1/84/2935',3,0),(2936,50,2733,'/1/84/2936',3,0),(2937,50,2734,'/1/84/2937',3,0),(2938,50,2735,'/1/84/2938',3,0),(2939,50,2736,'/1/84/2939',3,0),(2940,50,2737,'/1/84/2940',3,0),(2941,50,2738,'/1/84/2941',3,0),(2942,50,2739,'/1/84/2942',3,0),(2943,50,2740,'/1/84/2943',3,0),(2944,50,2741,'/1/84/2944',3,0),(2945,50,2742,'/1/84/2945',3,0),(2946,50,2743,'/1/84/2946',3,0),(2947,50,2744,'/1/84/2947',3,0),(2948,50,2745,'/1/84/2948',3,0),(2949,50,2746,'/1/84/2949',3,0),(2950,50,2747,'/1/84/2950',3,0),(2951,50,2748,'/1/84/2951',3,0),(2952,50,2749,'/1/84/2952',3,0),(2953,50,2750,'/1/84/2953',3,0),(2954,50,2751,'/1/84/2954',3,0),(2955,50,2752,'/1/84/2955',3,0),(2956,50,2753,'/1/84/2956',3,0),(2957,50,2754,'/1/84/2957',3,0),(2958,50,2755,'/1/84/2958',3,0),(2959,50,2756,'/1/84/2959',3,0),(2960,50,2757,'/1/84/2960',3,0),(2961,50,2758,'/1/84/2961',3,0),(2962,50,2759,'/1/84/2962',3,0),(2963,50,2760,'/1/84/2963',3,0),(2964,50,2761,'/1/84/2964',3,0),(2965,50,2762,'/1/84/2965',3,0),(2966,50,2763,'/1/84/2966',3,0),(2967,50,2764,'/1/84/2967',3,0),(2968,50,2765,'/1/84/2968',3,0),(2969,50,2766,'/1/84/2969',3,0),(2970,50,2767,'/1/84/2970',3,0),(2971,50,2768,'/1/84/2971',3,0),(2972,50,2769,'/1/84/2972',3,0),(2973,50,2770,'/1/84/2973',3,0),(2974,50,2771,'/1/84/2974',3,0),(2975,50,2772,'/1/84/2975',3,0),(2976,50,2773,'/1/84/2976',3,0),(2977,50,2774,'/1/84/2977',3,0),(2978,50,2775,'/1/84/2978',3,0),(2979,50,2776,'/1/84/2979',3,0),(2980,50,2777,'/1/84/2980',3,0),(2981,50,2778,'/1/84/2981',3,0),(2982,50,2779,'/1/84/2982',3,0),(2983,50,2780,'/1/84/2983',3,0),(2984,50,2781,'/1/84/2984',3,0),(2985,50,2782,'/1/84/2985',3,0),(2986,50,2783,'/1/84/2986',3,0),(2987,50,2784,'/1/84/2987',3,0),(2988,50,2785,'/1/84/2988',3,0),(2989,50,2786,'/1/84/2989',3,0),(2990,50,2787,'/1/84/2990',3,0),(2991,50,2788,'/1/84/2991',3,0),(2992,50,2789,'/1/84/2992',3,0),(2993,50,2790,'/1/84/2993',3,0),(2994,50,2791,'/1/84/2994',3,0),(2995,50,2792,'/1/84/2995',3,0),(2996,50,2793,'/1/84/2996',3,0),(2997,50,2794,'/1/84/2997',3,0),(2998,50,2795,'/1/84/2998',3,0),(2999,50,2796,'/1/84/2999',3,0),(3000,50,2797,'/1/84/3000',3,0),(3001,50,2798,'/1/84/3001',3,0),(3002,50,2799,'/1/84/3002',3,0),(3003,50,2800,'/1/84/3003',3,0),(3004,50,2801,'/1/84/3004',3,0),(3005,50,2802,'/1/84/3005',3,0),(3006,50,2803,'/1/84/3006',3,0),(3007,50,2804,'/1/84/3007',3,0),(3008,50,2805,'/1/84/3008',3,0),(3009,50,2806,'/1/84/3009',3,0),(3010,50,2807,'/1/84/3010',3,0),(3011,50,2808,'/1/84/3011',3,0),(3012,50,2809,'/1/84/3012',3,0),(3013,50,2810,'/1/84/3013',3,0),(3014,50,2811,'/1/84/3014',3,0),(3015,50,2812,'/1/84/3015',3,0),(3016,50,2813,'/1/84/3016',3,0),(3017,50,2814,'/1/84/3017',3,0),(3018,50,2815,'/1/84/3018',3,0),(3019,50,2816,'/1/84/3019',3,0),(3020,50,2817,'/1/84/3020',3,0),(3021,50,2818,'/1/84/3021',3,0),(3022,50,2819,'/1/84/3022',3,0),(3023,50,2820,'/1/84/3023',3,0),(3024,50,2821,'/1/84/3024',3,0),(3025,50,2822,'/1/84/3025',3,0),(3026,50,2823,'/1/84/3026',3,0),(3027,50,2824,'/1/84/3027',3,0),(3028,50,2825,'/1/84/3028',3,0),(3029,50,2826,'/1/84/3029',3,0),(3030,50,2827,'/1/84/3030',3,0),(3031,50,2828,'/1/84/3031',3,0),(3032,50,2829,'/1/84/3032',3,0),(3033,50,2830,'/1/84/3033',3,0),(3034,50,2831,'/1/84/3034',3,0),(3035,50,2832,'/1/84/3035',3,0),(3036,50,2833,'/1/84/3036',3,0),(3037,50,2834,'/1/84/3037',3,0),(3038,50,2835,'/1/84/3038',3,0),(3039,50,2836,'/1/84/3039',3,0),(3040,50,2837,'/1/84/3040',3,0),(3041,50,2838,'/1/84/3041',3,0),(3042,50,2839,'/1/84/3042',3,0),(3043,50,2840,'/1/84/3043',3,0),(3044,50,2841,'/1/84/3044',3,0),(3045,50,2842,'/1/84/3045',3,0),(3046,50,2843,'/1/84/3046',3,0),(3047,50,2844,'/1/84/3047',3,0),(3048,50,2845,'/1/84/3048',3,0),(3049,50,2846,'/1/84/3049',3,0),(3050,50,2847,'/1/84/3050',3,0),(3051,50,2848,'/1/84/3051',3,0),(3052,50,2849,'/1/84/3052',3,0),(3053,50,2850,'/1/84/3053',3,0),(3054,50,2851,'/1/84/3054',3,0),(3055,50,2852,'/1/84/3055',3,0),(3056,50,2853,'/1/84/3056',3,0),(3057,50,2854,'/1/84/3057',3,0),(3058,50,2855,'/1/84/3058',3,0),(3059,50,2856,'/1/84/3059',3,0),(3060,50,2857,'/1/84/3060',3,0),(3061,50,2858,'/1/84/3061',3,0),(3062,50,2859,'/1/84/3062',3,0),(3063,50,2860,'/1/84/3063',3,0),(3064,50,2861,'/1/84/3064',3,0),(3065,50,2862,'/1/84/3065',3,0),(3066,50,2863,'/1/84/3066',3,0),(3067,50,2864,'/1/84/3067',3,0),(3068,50,2865,'/1/84/3068',3,0),(3069,50,2866,'/1/84/3069',3,0),(3070,50,2867,'/1/84/3070',3,0),(3071,50,2868,'/1/84/3071',3,0),(3072,50,2869,'/1/84/3072',3,0),(3073,50,2870,'/1/84/3073',3,0),(3074,50,2871,'/1/84/3074',3,0),(3075,50,2872,'/1/84/3075',3,0),(3076,50,2873,'/1/84/3076',3,0),(3077,50,2874,'/1/84/3077',3,0),(3078,50,2875,'/1/84/3078',3,0),(3079,50,2876,'/1/84/3079',3,0),(3080,50,2877,'/1/84/3080',3,0),(3081,50,2878,'/1/84/3081',3,0),(3082,50,2879,'/1/84/3082',3,0),(3083,50,2880,'/1/84/3083',3,0),(3084,50,2881,'/1/84/3084',3,0),(3085,50,2882,'/1/84/3085',3,0),(3086,50,2883,'/1/84/3086',3,0),(3087,50,2884,'/1/84/3087',3,0),(3088,50,2885,'/1/84/3088',3,0),(3089,50,2886,'/1/84/3089',3,0),(3090,50,2887,'/1/84/3090',3,0),(3091,50,2888,'/1/84/3091',3,0),(3092,50,2889,'/1/84/3092',3,0),(3093,50,2890,'/1/84/3093',3,0),(3094,50,2891,'/1/84/3094',3,0),(3095,50,2892,'/1/84/3095',3,0),(3096,50,2893,'/1/84/3096',3,0),(3097,50,2894,'/1/84/3097',3,0),(3098,50,2895,'/1/84/3098',3,0),(3099,50,2896,'/1/84/3099',3,0),(3100,50,2897,'/1/84/3100',3,0),(3101,50,2898,'/1/84/3101',3,0),(3102,50,2899,'/1/84/3102',3,0),(3103,50,2900,'/1/84/3103',3,0),(3104,50,2901,'/1/84/3104',3,0),(3105,50,2902,'/1/84/3105',3,0),(3106,50,2903,'/1/84/3106',3,0),(3107,50,2904,'/1/84/3107',3,0),(3108,50,2905,'/1/84/3108',3,0),(3109,50,2906,'/1/84/3109',3,0),(3110,50,2907,'/1/84/3110',3,0),(3111,50,2908,'/1/84/3111',3,0),(3112,50,2909,'/1/84/3112',3,0),(3113,50,2910,'/1/84/3113',3,0),(3114,50,2911,'/1/84/3114',3,0),(3115,50,2912,'/1/84/3115',3,0),(3116,50,2913,'/1/84/3116',3,0),(3117,50,2914,'/1/84/3117',3,0),(3118,50,2915,'/1/84/3118',3,0),(3119,50,2916,'/1/84/3119',3,0),(3120,50,2917,'/1/84/3120',3,0),(3121,50,2918,'/1/84/3121',3,0),(3122,50,2919,'/1/84/3122',3,0),(3123,50,2920,'/1/84/3123',3,0),(3124,50,2921,'/1/84/3124',3,0),(3125,50,2922,'/1/84/3125',3,0),(3126,50,2923,'/1/84/3126',3,0),(3127,50,2924,'/1/84/3127',3,0),(3128,50,2925,'/1/84/3128',3,0),(3129,50,2926,'/1/84/3129',3,0),(3130,50,2927,'/1/84/3130',3,0),(3131,50,2928,'/1/84/3131',3,0),(3132,50,2929,'/1/84/3132',3,0),(3133,50,2930,'/1/84/3133',3,0),(3134,50,2931,'/1/84/3134',3,0),(3135,50,2932,'/1/84/3135',3,0),(3136,50,2933,'/1/84/3136',3,0),(3137,50,2934,'/1/84/3137',3,0),(3138,50,2935,'/1/84/3138',3,0),(3139,50,2936,'/1/84/3139',3,0),(3140,50,2937,'/1/84/3140',3,0),(3141,50,2938,'/1/84/3141',3,0),(3142,50,2939,'/1/84/3142',3,0),(3143,50,2940,'/1/84/3143',3,0),(3144,50,2941,'/1/84/3144',3,0),(3145,50,2942,'/1/84/3145',3,0),(3146,50,2943,'/1/84/3146',3,0),(3147,50,2944,'/1/84/3147',3,0),(3148,50,2945,'/1/84/3148',3,0),(3149,50,2946,'/1/84/3149',3,0),(3150,50,2947,'/1/84/3150',3,0),(3151,50,2948,'/1/84/3151',3,0),(3152,50,2949,'/1/84/3152',3,0),(3153,50,2950,'/1/84/3153',3,0),(3154,50,2951,'/1/84/3154',3,0),(3155,50,2952,'/1/84/3155',3,0),(3156,50,2953,'/1/84/3156',3,0),(3157,50,2954,'/1/84/3157',3,0),(3158,50,2955,'/1/84/3158',3,0),(3159,50,2956,'/1/84/3159',3,0),(3160,50,2957,'/1/84/3160',3,0),(3161,50,2958,'/1/84/3161',3,0),(3162,50,2959,'/1/84/3162',3,0),(3163,50,2960,'/1/84/3163',3,0),(3164,50,2961,'/1/84/3164',3,0),(3165,50,2962,'/1/84/3165',3,0),(3166,50,2963,'/1/84/3166',3,0),(3167,50,2964,'/1/84/3167',3,0),(3168,50,2965,'/1/84/3168',3,0),(3169,50,2966,'/1/84/3169',3,0),(3170,50,2967,'/1/84/3170',3,0),(3171,50,2968,'/1/84/3171',3,0),(3172,50,2969,'/1/84/3172',3,0),(3173,50,2970,'/1/84/3173',3,0),(3174,50,2971,'/1/84/3174',3,0),(3175,50,2972,'/1/84/3175',3,0),(3176,50,2973,'/1/84/3176',3,0),(3177,50,2974,'/1/84/3177',3,0),(3178,50,2975,'/1/84/3178',3,0),(3179,50,2976,'/1/84/3179',3,0),(3180,50,2977,'/1/84/3180',3,0),(3181,50,2978,'/1/84/3181',3,0),(3182,50,2979,'/1/84/3182',3,0),(3183,50,2980,'/1/84/3183',3,0),(3184,50,2981,'/1/84/3184',3,0),(3185,50,2982,'/1/84/3185',3,0),(3186,50,2983,'/1/84/3186',3,0),(3187,50,2984,'/1/84/3187',3,0),(3188,50,2985,'/1/84/3188',3,0),(3189,50,2986,'/1/84/3189',3,0),(3190,50,2987,'/1/84/3190',3,0),(3191,50,2988,'/1/84/3191',3,0),(3192,50,2989,'/1/84/3192',3,0),(3193,50,2990,'/1/84/3193',3,0),(3194,50,2991,'/1/84/3194',3,0),(3195,50,2992,'/1/84/3195',3,0),(3196,50,2993,'/1/84/3196',3,0),(3197,50,2994,'/1/84/3197',3,0),(3198,50,2995,'/1/84/3198',3,0),(3199,50,2996,'/1/84/3199',3,0),(3200,50,2997,'/1/84/3200',3,0),(3201,50,2998,'/1/84/3201',3,0),(3202,50,2999,'/1/84/3202',3,0),(3203,50,3000,'/1/84/3203',3,0),(3204,50,3001,'/1/84/3204',3,0),(3205,50,3002,'/1/84/3205',3,0),(3206,50,3003,'/1/84/3206',3,0),(3207,50,3004,'/1/84/3207',3,0),(3208,50,3005,'/1/84/3208',3,0),(3209,50,3006,'/1/84/3209',3,0),(3210,50,3007,'/1/84/3210',3,0),(3211,50,3008,'/1/84/3211',3,0),(3212,50,3009,'/1/84/3212',3,0),(3213,50,3010,'/1/84/3213',3,0),(3214,50,3011,'/1/84/3214',3,0),(3215,50,3012,'/1/84/3215',3,0),(3216,50,3013,'/1/84/3216',3,0),(3217,50,3014,'/1/84/3217',3,0),(3218,50,3015,'/1/84/3218',3,0),(3219,50,3016,'/1/84/3219',3,0),(3220,50,3017,'/1/84/3220',3,0),(3221,50,3018,'/1/84/3221',3,0),(3222,50,3019,'/1/84/3222',3,0),(3223,50,3020,'/1/84/3223',3,0),(3224,50,3021,'/1/84/3224',3,0),(3225,50,3022,'/1/84/3225',3,0),(3226,50,3023,'/1/84/3226',3,0),(3227,50,3024,'/1/84/3227',3,0),(3228,50,3025,'/1/84/3228',3,0),(3229,50,3026,'/1/84/3229',3,0),(3230,50,3027,'/1/84/3230',3,0),(3231,50,3028,'/1/84/3231',3,0),(3232,50,3029,'/1/84/3232',3,0),(3233,50,3030,'/1/84/3233',3,0),(3234,50,3031,'/1/84/3234',3,0),(3235,50,3032,'/1/84/3235',3,0),(3236,50,3033,'/1/84/3236',3,0),(3237,50,3034,'/1/84/3237',3,0),(3238,50,3035,'/1/84/3238',3,0),(3239,50,3036,'/1/84/3239',3,0),(3240,50,3037,'/1/84/3240',3,0),(3241,50,3038,'/1/84/3241',3,0),(3242,50,3039,'/1/84/3242',3,0),(3243,50,3040,'/1/84/3243',3,0),(3244,50,3041,'/1/84/3244',3,0),(3245,50,3042,'/1/84/3245',3,0),(3246,50,3043,'/1/84/3246',3,0),(3247,50,3044,'/1/84/3247',3,0),(3248,50,3045,'/1/84/3248',3,0),(3249,50,3046,'/1/84/3249',3,0),(3250,50,3047,'/1/84/3250',3,0),(3251,50,3048,'/1/84/3251',3,0),(3252,50,3049,'/1/84/3252',3,0),(3253,50,3050,'/1/84/3253',3,0),(3254,50,3051,'/1/84/3254',3,0),(3255,50,3052,'/1/84/3255',3,0),(3256,50,3053,'/1/84/3256',3,0),(3257,50,3054,'/1/84/3257',3,0),(3258,50,3055,'/1/84/3258',3,0),(3259,50,3056,'/1/84/3259',3,0),(3260,50,3057,'/1/84/3260',3,0),(3261,50,3058,'/1/84/3261',3,0),(3262,50,3059,'/1/84/3262',3,0),(3263,50,3060,'/1/84/3263',3,0),(3264,50,3061,'/1/84/3264',3,0),(3265,50,3062,'/1/84/3265',3,0),(3266,50,3063,'/1/84/3266',3,0),(3267,50,3064,'/1/84/3267',3,0),(3268,50,3065,'/1/84/3268',3,0),(3269,50,3066,'/1/84/3269',3,0),(3270,50,3067,'/1/84/3270',3,0),(3271,50,3068,'/1/84/3271',3,0),(3272,50,3069,'/1/84/3272',3,0),(3273,50,3070,'/1/84/3273',3,0),(3274,50,3071,'/1/84/3274',3,0),(3275,50,3072,'/1/84/3275',3,0),(3276,50,3073,'/1/84/3276',3,0),(3277,50,3074,'/1/84/3277',3,0),(3278,50,3075,'/1/84/3278',3,0),(3279,50,3076,'/1/84/3279',3,0),(3280,50,3077,'/1/84/3280',3,0),(3281,50,3078,'/1/84/3281',3,0),(3282,50,3079,'/1/84/3282',3,0),(3283,50,3080,'/1/84/3283',3,0),(3284,50,3081,'/1/84/3284',3,0),(3285,50,3082,'/1/84/3285',3,0),(3286,50,3083,'/1/84/3286',3,0),(3287,50,3084,'/1/84/3287',3,0),(3288,50,3085,'/1/84/3288',3,0),(3289,50,3086,'/1/84/3289',3,0),(3290,50,3087,'/1/84/3290',3,0),(3291,50,3088,'/1/84/3291',3,0),(3292,50,3089,'/1/84/3292',3,0),(3293,50,3090,'/1/84/3293',3,0),(3294,50,3091,'/1/84/3294',3,0),(3295,50,3092,'/1/84/3295',3,0),(3296,50,3093,'/1/84/3296',3,0),(3297,50,3094,'/1/84/3297',3,0),(3298,50,3095,'/1/84/3298',3,0),(3299,50,3096,'/1/84/3299',3,0),(3300,50,3097,'/1/84/3300',3,0),(3301,50,3098,'/1/84/3301',3,0),(3302,50,3099,'/1/84/3302',3,0),(3303,70,1492,'/1/84/1604/3303',4,0),(3304,70,3137,'/1/84/3299/3304',4,0),(3305,70,3139,'/1/84/3301/3305',4,0),(3306,70,3122,'/1/84/3284/3306',4,0),(3307,50,3100,'/1/84/3307',3,0),(3308,50,3101,'/1/84/3308',3,0),(3309,50,3102,'/1/84/3309',3,0),(3310,50,3103,'/1/84/3310',3,0),(3311,50,3104,'/1/84/3311',3,0),(3312,50,3105,'/1/84/3312',3,0),(3313,50,3106,'/1/84/3313',3,0),(3314,50,3107,'/1/84/3314',3,0),(3315,50,3108,'/1/84/3315',3,0),(3316,50,3109,'/1/84/3316',3,0),(3317,50,3110,'/1/84/3317',3,0),(3318,50,3111,'/1/84/3318',3,0),(3319,50,3112,'/1/84/3319',3,0),(3320,50,3113,'/1/84/3320',3,0),(3321,50,3114,'/1/84/3321',3,0),(3322,50,3115,'/1/84/3322',3,0),(3323,50,3116,'/1/84/3323',3,0),(3324,50,3117,'/1/84/3324',3,0),(3325,50,3118,'/1/84/3325',3,0),(3326,50,3119,'/1/84/3326',3,0),(3327,50,3120,'/1/84/3327',3,0),(3328,50,3121,'/1/84/3328',3,0),(3329,50,3122,'/1/84/3329',3,0),(3330,50,3123,'/1/84/3330',3,0),(3331,50,3124,'/1/84/3331',3,0),(3332,50,3125,'/1/84/3332',3,0),(3333,50,3126,'/1/84/3333',3,0),(3334,50,3127,'/1/84/3334',3,0),(3335,50,3128,'/1/84/3335',3,0),(3336,50,3129,'/1/84/3336',3,0),(3337,50,3130,'/1/84/3337',3,0),(3338,50,3131,'/1/84/3338',3,0),(3339,50,3132,'/1/84/3339',3,0),(3340,50,3133,'/1/84/3340',3,0),(3341,50,3134,'/1/84/3341',3,0),(3342,50,3135,'/1/84/3342',3,0),(3343,50,3136,'/1/84/3343',3,0),(3344,50,3137,'/1/84/3344',3,0),(3345,50,3138,'/1/84/3345',3,0),(3346,50,3139,'/1/84/3346',3,0),(3347,50,3140,'/1/84/3347',3,0),(3348,50,3141,'/1/84/3348',3,0),(3349,50,3142,'/1/84/3349',3,0),(3350,50,3143,'/1/84/3350',3,0),(3351,50,3144,'/1/84/3351',3,0),(3352,50,3145,'/1/84/3352',3,0),(3353,50,3146,'/1/84/3353',3,0),(3354,50,3147,'/1/84/3354',3,0),(3355,50,3148,'/1/84/3355',3,0),(3356,50,3149,'/1/84/3356',3,0),(3357,50,3150,'/1/84/3357',3,0),(3358,50,3151,'/1/84/3358',3,0),(3359,50,3152,'/1/84/3359',3,0),(3360,50,3153,'/1/84/3360',3,0),(3361,50,3154,'/1/84/3361',3,0),(3362,50,3155,'/1/84/3362',3,0),(3363,50,3156,'/1/84/3363',3,0),(3364,50,3157,'/1/84/3364',3,0),(3365,50,3158,'/1/84/3365',3,0),(3366,50,3159,'/1/84/3366',3,0),(3367,50,3160,'/1/84/3367',3,0),(3368,50,3161,'/1/84/3368',3,0),(3369,50,3162,'/1/84/3369',3,0),(3370,50,3163,'/1/84/3370',3,0),(3371,50,3164,'/1/84/3371',3,0),(3372,50,3165,'/1/84/3372',3,0),(3373,50,3166,'/1/84/3373',3,0),(3374,50,3167,'/1/84/3374',3,0),(3375,50,3168,'/1/84/3375',3,0),(3376,50,3169,'/1/84/3376',3,0),(3377,50,3170,'/1/84/3377',3,0),(3378,50,3171,'/1/84/3378',3,0),(3379,50,3172,'/1/84/3379',3,0),(3380,50,3173,'/1/84/3380',3,0),(3381,50,3174,'/1/84/3381',3,0),(3382,50,3175,'/1/84/3382',3,0),(3383,50,3176,'/1/84/3383',3,0),(3384,50,3177,'/1/84/3384',3,0),(3385,50,3178,'/1/84/3385',3,0),(3386,50,3179,'/1/84/3386',3,0),(3387,50,3180,'/1/84/3387',3,0),(3388,50,3181,'/1/84/3388',3,0),(3389,50,3182,'/1/84/3389',3,0),(3390,50,3183,'/1/84/3390',3,0),(3391,50,3184,'/1/84/3391',3,0),(3392,50,3185,'/1/84/3392',3,0),(3393,50,3186,'/1/84/3393',3,0),(3394,50,3187,'/1/84/3394',3,0),(3395,50,3188,'/1/84/3395',3,0),(3396,50,3189,'/1/84/3396',3,0),(3397,50,3190,'/1/84/3397',3,0),(3398,50,3191,'/1/84/3398',3,0),(3399,50,3192,'/1/84/3399',3,0),(3400,50,3193,'/1/84/3400',3,0),(3401,50,3194,'/1/84/3401',3,0),(3402,50,3195,'/1/84/3402',3,0),(3403,50,3196,'/1/84/3403',3,0),(3404,50,3197,'/1/84/3404',3,0),(3405,50,3198,'/1/84/3405',3,0),(3406,50,3199,'/1/84/3406',3,0),(3407,50,3200,'/1/84/3407',3,0),(3408,50,3201,'/1/84/3408',3,0),(3409,50,3202,'/1/84/3409',3,0),(3410,50,3203,'/1/84/3410',3,0),(3411,50,3204,'/1/84/3411',3,0),(3412,50,3205,'/1/84/3412',3,0),(3413,50,3206,'/1/84/3413',3,0),(3414,50,3207,'/1/84/3414',3,0),(3415,50,3208,'/1/84/3415',3,0),(3416,50,3209,'/1/84/3416',3,0),(3417,50,3210,'/1/84/3417',3,0),(3418,50,3211,'/1/84/3418',3,0),(3419,50,3212,'/1/84/3419',3,0),(3420,50,3213,'/1/84/3420',3,0),(3421,50,3214,'/1/84/3421',3,0),(3422,50,3215,'/1/84/3422',3,0),(3423,50,3216,'/1/84/3423',3,0),(3424,50,3217,'/1/84/3424',3,0),(3425,50,3218,'/1/84/3425',3,0),(3426,50,3219,'/1/84/3426',3,0),(3427,50,3220,'/1/84/3427',3,0),(3428,50,3221,'/1/84/3428',3,0),(3429,50,3222,'/1/84/3429',3,0),(3430,50,3223,'/1/84/3430',3,0),(3431,50,3224,'/1/84/3431',3,0),(3432,50,3225,'/1/84/3432',3,0),(3433,50,3226,'/1/84/3433',3,0),(3434,50,3227,'/1/84/3434',3,0),(3435,50,3228,'/1/84/3435',3,0),(3436,50,3229,'/1/84/3436',3,0),(3437,50,3230,'/1/84/3437',3,0),(3438,50,3231,'/1/84/3438',3,0),(3439,50,3232,'/1/84/3439',3,0),(3440,50,3233,'/1/84/3440',3,0),(3441,50,3234,'/1/84/3441',3,0),(3442,50,3235,'/1/84/3442',3,0),(3443,50,3236,'/1/84/3443',3,0),(3444,50,3237,'/1/84/3444',3,0),(3445,50,3238,'/1/84/3445',3,0),(3446,50,3239,'/1/84/3446',3,0),(3447,50,3240,'/1/84/3447',3,0),(3448,50,3241,'/1/84/3448',3,0),(3449,50,3242,'/1/84/3449',3,0),(3450,50,3243,'/1/84/3450',3,0),(3451,50,3244,'/1/84/3451',3,0),(3452,50,3245,'/1/84/3452',3,0),(3453,50,3246,'/1/84/3453',3,0),(3454,50,3247,'/1/84/3454',3,0),(3455,50,3248,'/1/84/3455',3,0),(3456,50,3249,'/1/84/3456',3,0),(3457,50,3250,'/1/84/3457',3,0),(3458,50,3251,'/1/84/3458',3,0),(3459,50,3252,'/1/84/3459',3,0),(3460,50,3253,'/1/84/3460',3,0),(3461,50,3254,'/1/84/3461',3,0),(3462,50,3255,'/1/84/3462',3,0),(3463,50,3256,'/1/84/3463',3,0),(3464,50,3257,'/1/84/3464',3,0),(3465,50,3258,'/1/84/3465',3,0),(3466,50,3259,'/1/84/3466',3,0),(3467,50,3260,'/1/84/3467',3,0),(3468,50,3261,'/1/84/3468',3,0),(3469,50,3262,'/1/84/3469',3,0),(3470,50,3263,'/1/84/3470',3,0),(3471,50,3264,'/1/84/3471',3,0),(3472,50,3265,'/1/84/3472',3,0),(3473,50,3266,'/1/84/3473',3,0),(3474,50,3267,'/1/84/3474',3,0),(3475,50,3268,'/1/84/3475',3,0),(3476,50,3269,'/1/84/3476',3,0),(3477,50,3270,'/1/84/3477',3,0),(3478,50,3271,'/1/84/3478',3,0),(3479,50,3272,'/1/84/3479',3,0),(3480,50,3273,'/1/84/3480',3,0),(3481,50,3274,'/1/84/3481',3,0),(3482,50,3275,'/1/84/3482',3,0),(3483,50,3276,'/1/84/3483',3,0),(3484,50,3277,'/1/84/3484',3,0),(3485,50,3278,'/1/84/3485',3,0),(3486,50,3279,'/1/84/3486',3,0),(3487,50,3280,'/1/84/3487',3,0),(3488,50,3281,'/1/84/3488',3,0),(3489,50,3282,'/1/84/3489',3,0),(3490,50,3283,'/1/84/3490',3,0),(3491,50,3284,'/1/84/3491',3,0),(3492,50,3285,'/1/84/3492',3,0),(3493,50,3286,'/1/84/3493',3,0),(3494,50,3287,'/1/84/3494',3,0),(3495,50,3288,'/1/84/3495',3,0),(3496,50,3289,'/1/84/3496',3,0),(3497,50,3290,'/1/84/3497',3,0),(3498,50,3291,'/1/84/3498',3,0),(3499,50,3292,'/1/84/3499',3,0),(3500,50,3293,'/1/84/3500',3,0),(3501,50,3294,'/1/84/3501',3,0),(3502,50,3295,'/1/84/3502',3,0),(3503,50,3296,'/1/84/3503',3,0),(3504,50,3297,'/1/84/3504',3,0),(3505,50,3298,'/1/84/3505',3,0),(3506,50,3299,'/1/84/3506',3,0),(3507,50,3300,'/1/84/3507',3,0),(3508,50,3301,'/1/84/3508',3,0),(3509,50,3302,'/1/84/3509',3,0),(3510,50,3303,'/1/84/3510',3,0),(3511,50,3304,'/1/84/3511',3,0),(3512,50,3305,'/1/84/3512',3,0),(3513,50,3306,'/1/84/3513',3,0),(3514,50,3307,'/1/84/3514',3,0),(3515,50,3308,'/1/84/3515',3,0),(3516,50,3309,'/1/84/3516',3,0),(3517,50,3310,'/1/84/3517',3,0),(3518,50,3311,'/1/84/3518',3,0),(3519,50,3312,'/1/84/3519',3,0),(3520,50,3313,'/1/84/3520',3,0),(3521,50,3314,'/1/84/3521',3,0),(3522,50,3315,'/1/84/3522',3,0),(3523,50,3316,'/1/84/3523',3,0),(3524,50,3317,'/1/84/3524',3,0),(3525,50,3318,'/1/84/3525',3,0),(3526,50,3319,'/1/84/3526',3,0),(3527,50,3320,'/1/84/3527',3,0),(3528,50,3321,'/1/84/3528',3,0),(3529,50,3322,'/1/84/3529',3,0),(3530,50,3323,'/1/84/3530',3,0),(3531,50,3324,'/1/84/3531',3,0),(3532,50,3325,'/1/84/3532',3,0),(3533,50,3326,'/1/84/3533',3,0),(3534,50,3327,'/1/84/3534',3,0),(3535,50,3328,'/1/84/3535',3,0),(3536,50,3329,'/1/84/3536',3,0),(3537,50,3330,'/1/84/3537',3,0),(3538,50,3331,'/1/84/3538',3,0),(3539,50,3332,'/1/84/3539',3,0),(3540,50,3333,'/1/84/3540',3,0),(3541,50,3334,'/1/84/3541',3,0),(3542,50,3335,'/1/84/3542',3,0),(3543,50,3336,'/1/84/3543',3,0),(3544,50,3337,'/1/84/3544',3,0),(3545,50,3338,'/1/84/3545',3,0),(3546,50,3339,'/1/84/3546',3,0),(3547,50,3340,'/1/84/3547',3,0),(3548,50,3341,'/1/84/3548',3,0),(3549,50,3342,'/1/84/3549',3,0),(3550,50,3343,'/1/84/3550',3,0),(3551,50,3344,'/1/84/3551',3,0),(3552,70,88,'/1/84/200/3552',4,0),(3553,70,90,'/1/84/202/3553',4,0),(3554,70,3386,'/1/84/202/3554',4,0),(3555,70,3373,'/1/84/3540/3555',4,0),(3556,70,6657,'/1/84/3540/3556',4,0),(3557,70,3383,'/1/84/3550/3557',4,0),(3558,70,6667,'/1/84/3550/3558',4,0),(3559,70,3382,'/1/84/3549/3559',4,0),(3560,70,6666,'/1/84/3549/3560',4,0),(3561,70,3366,'/1/84/3533/3561',4,0),(3562,70,6650,'/1/84/3533/3562',4,0),(3565,70,3384,'/1/84/3551/3565',4,0),(3566,70,6668,'/1/84/3551/3566',4,0),(3568,70,3357,'/1/84/3524/3568',4,0),(3569,70,6641,'/1/84/3524/3569',4,0),(3570,70,2790,'/1/84/2952/3570',4,0),(3571,70,6073,'/1/84/2952/3571',4,0),(3572,30,46,'/1/3572',2,0),(3573,30,47,'/1/3573',2,0),(3574,30,48,'/1/3574',2,0),(3575,30,49,'/1/3575',2,0),(3576,30,50,'/1/3576',2,0),(3577,30,51,'/1/3577',2,0),(3582,30,52,'/1/3582',2,0),(3587,70,4788,'/1/84/1604/3587',4,0),(3588,70,5203,'/1/84/2019/3588',4,0),(3589,70,5929,'/1/84/2745/3589',4,0),(3590,70,6485,'/1/84/3368/3590',4,0),(3591,70,3819,'/1/84/635/3591',4,0),(3592,70,3372,'/1/84/3539/3592',4,0),(3593,70,6656,'/1/84/3539/3593',4,0),(3594,70,6151,'/1/84/3030/3594',4,0),(3596,70,3378,'/1/84/3545/3596',4,0),(3597,70,6662,'/1/84/3545/3597',4,0),(3600,30,53,'/1/3600',2,0),(3601,30,54,'/1/3601',2,0),(3602,70,3379,'/1/84/3546/3602',4,0),(3603,70,6663,'/1/84/3546/3603',4,0),(3604,70,3820,'/1/84/636/3604',4,0),(3605,70,4389,'/1/84/1205/3605',4,0),(3606,70,6068,'/1/84/2947/3606',4,0),(3607,70,1907,'/1/84/2019/3607',4,0),(3608,70,523,'/1/84/635/3608',4,0),(3609,70,3201,'/1/84/3368/3609',4,0),(3610,70,6651,'/1/84/3534/3610',4,0),(3611,70,3367,'/1/84/3534/3611',4,0),(3612,70,2633,'/1/84/2745/3612',4,0),(3616,70,3377,'/1/84/3544/3616',4,0),(3617,70,6661,'/1/84/3544/3617',4,0),(3618,70,3365,'/1/84/3532/3618',4,0),(3619,70,6649,'/1/84/3532/3619',4,0),(3620,70,3375,'/1/84/3542/3620',4,0),(3621,70,6659,'/1/84/3542/3621',4,0),(3622,70,3368,'/1/84/3535/3622',4,0),(3623,70,6652,'/1/84/3535/3623',4,0),(3624,70,3262,'/1/84/3429/3624',4,0),(3625,70,6546,'/1/84/3429/3625',4,0),(3626,70,4576,'/1/84/1392/3626',4,0),(3627,70,1280,'/1/84/1392/3627',4,0),(3628,70,3818,'/1/84/634/3628',4,0),(3629,70,522,'/1/84/634/3629',4,0),(3630,70,1093,'/1/84/1205/3630',4,0),(3631,70,6071,'/1/84/2950/3631',4,0),(3632,70,4712,'/1/84/1528/3632',4,0),(3633,70,4972,'/1/84/1788/3633',4,0),(3634,70,2788,'/1/84/2950/3634',4,0),(3635,70,1416,'/1/84/1528/3635',4,0),(3636,70,1676,'/1/84/1788/3636',4,0),(3637,30,55,'/1/3637',2,0),(3638,70,4388,'/1/84/1204/3638',4,0),(3639,70,1092,'/1/84/1204/3639',4,0),(3640,30,56,'/1/3640',2,0),(3641,30,57,'/1/3641',2,0),(3642,30,58,'/1/3642',2,0),(3643,30,59,'/1/3643',2,0),(3644,30,60,'/1/3644',2,0),(3645,70,6635,'/1/84/3518/3645',4,0),(3646,30,61,'/1/3646',2,0),(3647,30,62,'/1/3647',2,0),(3648,30,63,'/1/3648',2,0),(3650,50,3347,'/1/3/3650',3,0),(3651,70,6673,'/1/3/3650/3651',4,0),(3652,70,3370,'/1/84/3537/3652',4,0),(3653,70,6654,'/1/84/3537/3653',4,0),(3656,50,3348,'/1/3/3656',3,0),(3657,70,6674,'/1/3/3656/3657',4,0),(3658,70,3381,'/1/84/3548/3658',4,0),(3659,70,6665,'/1/84/3548/3659',4,0),(3660,30,64,'/1/3660',2,0),(3661,30,65,'/1/3661',2,0),(3662,30,66,'/1/3662',2,0),(3663,30,67,'/1/3663',2,0),(3664,30,68,'/1/3664',2,0),(3665,30,69,'/1/3665',2,0),(3666,30,70,'/1/3666',2,0),(3667,30,71,'/1/3667',2,0),(3668,30,72,'/1/3668',2,0),(3669,30,73,'/1/3669',2,0),(3670,30,74,'/1/3670',2,0),(3671,30,75,'/1/3671',2,0),(3672,30,76,'/1/3672',2,0),(3673,30,77,'/1/3673',2,0),(3674,30,78,'/1/3674',2,0),(3675,50,3349,'/1/3/3675',3,0),(3676,70,6675,'/1/3/3675/3676',4,0),(3678,30,79,'/1/3678',2,0),(3679,30,80,'/1/3679',2,0),(3680,30,81,'/1/3680',2,0),(3681,70,3374,'/1/84/3541/3681',4,0),(3682,70,6658,'/1/84/3541/3682',4,0),(3683,30,82,'/1/3683',2,0),(3684,30,83,'/1/3684',2,0),(3685,30,84,'/1/3685',2,0),(3686,30,85,'/1/3686',2,0),(3687,30,86,'/1/3687',2,0),(3688,30,87,'/1/3688',2,0),(3689,30,88,'/1/3689',2,0),(3690,30,89,'/1/3690',2,0);
/*!40000 ALTER TABLE `mdl_context` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_context_temp`
--

DROP TABLE IF EXISTS `mdl_context_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_context_temp` (
  `id` bigint NOT NULL,
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `depth` tinyint NOT NULL,
  `locked` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Used by build_context_path() in upgrade and cron to keep con';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_context_temp`
--

LOCK TABLES `mdl_context_temp` WRITE;
/*!40000 ALTER TABLE `mdl_context_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_context_temp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course`
--

DROP TABLE IF EXISTS `mdl_course`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mdl_course` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `category` bigint NOT NULL DEFAULT '0',
  `sortorder` bigint NOT NULL DEFAULT '0',
  `fullname` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `shortname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `summary` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `summaryformat` tinyint NOT NULL DEFAULT '0',
  `format` varchar(21) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'topics',
  `showgrades` tinyint NOT NULL DEFAULT '1',
  `newsitems` mediumint NOT NULL DEFAULT '1',
  `startdate` bigint NOT NULL DEFAULT '0',
  `enddate` bigint NOT NULL DEFAULT '0',
  `relativedatesmode` tinyint(1) NOT NULL DEFAULT '0',
  `marker` bigint NOT NULL DEFAULT '0',
  `maxbytes` bigint NOT NULL DEFAULT '0',
  `legacyfiles` smallint NOT NULL DEFAULT '0',
  `showreports` smallint NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `downloadcontent` tinyint(1) DEFAULT NULL,
  `groupmode` smallint NOT NULL DEFAULT '0',
  `groupmodeforce` smallint NOT NULL DEFAULT '0',
  `defaultgroupingid` bigint NOT NULL DEFAULT '0',
  `lang` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `calendartype` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `theme` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `requested` tinyint(1) NOT NULL DEFAULT '0',
  `enablecompletion` tinyint(1) NOT NULL DEFAULT '0',
  `completionnotify` tinyint(1) NOT NULL DEFAULT '0',
  `cacherev` bigint NOT NULL DEFAULT '0',
  `originalcourseid` bigint DEFAULT NULL,
  `showactivitydates` tinyint(1) NOT NULL DEFAULT '0',
  `showcompletionconditions` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_cour_cat_ix` (`category`),
  KEY `mdl_cour_idn_ix` (`idnumber`),
  KEY `mdl_cour_sho_ix` (`shortname`),
  KEY `mdl_cour_sor_ix` (`sortorder`)
) ENGINE=InnoDB AUTO_INCREMENT=3350 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Central course table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course`
--

LOCK TABLES `mdl_course` WRITE;
/*!40000 ALTER TABLE `mdl_course` DISABLE KEYS */;
INSERT INTO `mdl_course` VALUES (1,0,1,'Learning Management System','lms','','',0,'site',1,3,0,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1753775869,1753855119,0,0,0,1758522880,NULL,0,NULL),(60,7,13285,'Fundamentals of Machine Learning and Artificial Intelligence (العربية)','Q36S7TXY2U','','في هذه الدورة التددريبية، ستتعرف على أسس machine learning (ML) والذكاء الاصطناعي (AI). سوف تستكشف الروابط بين الذكاء الاصطناعي (AI) وML والتعلم العميق والمجال الناشئ للذكاء الاصطناعي المولّد (generative AI). ستكتسب فهمًا قويًا لمصطلحات الذكاء الاصطناعي (AI) التأسيسية، مما يضع الأساس للتعمق في هذه المفاهيم. بالإضافة إلى ذلك، ستتعرف على مجموعة مختارة من خدمات Amazon Web Services (AWS) التي تستخدم إمكانات الذكاء الاصطناعي (AI) وML. سوف تكتسب رؤى متعمقة عملية حول كيفية استخدام هذه الأدوات لحل مشاكل العالم الحقيقي ودفع الابتكار عبر مختلف الصناعات. تتضمن هذه الدورة التدريبية عناصر تفاعلية ومقاطع فيديو وتعليمات نصية ورسومات توضيحية.',0,'topics',1,5,1756189680,1787725680,0,0,0,0,0,1,1,NULL,0,0,0,'ar-SA','','',1756103288,1756271583,0,1,0,1758522880,NULL,0,1),(61,7,13284,'Fundamentals of Machine Learning and Artificial Intelligence (Deutsch)','KYYP37WCVQ','','In diesem Kurs werden die Grundlagen von Machine Learning (ML) und künstlicher Intelligenz (KI) vermittelt. Es werden die Zusammenhänge zwischen KI, ML, Deep Learning und dem noch jungen Gebiet der generativen künstlichen Intelligenz (generative KI) untersucht. Du gewinnst ein solides Verständnis der grundlegenden KI-Begriffe, sodass du in der Lage bist, dich tiefergehend mit diesen Konzepten zu beschäftigen. Darüber hinaus werden dir einige Amazon Web Services (AWS) vorgestellt, die KI- und ML-Funktionen nutzen. Du erhältst praktische Einblicke dahingehend, wie diese Tools zur Lösung realer Probleme und zur Förderung von Innovationen in verschiedenen Branchen eingesetzt werden können. Dieser Kurs beinhaltet interaktive Elemente, Videos, Textanweisungen und anschauliche Grafiken.',0,'topics',1,5,1756189680,1787725680,0,0,0,0,0,1,1,NULL,0,0,0,'de-DE','','',1756103288,1756271583,0,1,0,1758522880,NULL,0,1),(62,7,13283,'A Hands-On Look at Amazon Q Business Expert','47NNFVPRZB','','*This course was developed by members of AWS Technical Field Communities (TFC), an AWS community of technical experts. The content is intended to complement our standard training curriculum and augment your AWS learning journey. We are aware some courses have accessibility limitations and are working to address. If you require accommodation, please contact [AWS Training and Certification Customer Support](https://console.learning-cms.training.aws.dev/products/details/).*\n\nThis course has been created with the help of Amazon Q business expert. Amazon Q business expert helps businesses solve the problem of empowering various business users to gain insights from company data and make better decisions. Amazon Q can be tailored to a business by connecting it to the company\'s data, information and systems through over 40 built-in connectors. This allows various business users such as marketers, project managers and sales representatives to have tailored conversations to solve problems, generate content, take actions and improve their decision-making. Join us for a deeper dive into the world of Amazon Q, to learn how to make better data-driven decisions and improve employee productivity through hands-on demonstrations, digital whiteboarding and relatable story-telling. Course Level: Intermediate, Duration: 1 hour. This course includes presentations based on practical examples, with use-cases and demonstrations.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190503,1756271583,0,1,0,1758522880,NULL,0,1),(63,7,13282,'Fundamentals of Machine Learning and Artificial Intelligence','M7JZCTA94N','','*This course was developed by members of AWS Technical Field Communities (TFC), an AWS community of technical experts. The content is intended to complement our standard training curriculum and augment your AWS learning journey. We are aware some courses have accessibility limitations and are working to address. If you require accommodation, please contact\n[AWS Training and Certification Customer Support](https://support.aws.amazon.com/#/contacts/aws-training).*\n\nIn this course, you will learn about the foundations of machine learning (ML) and artificial intelligence (AI). You will explore the connections between AI, ML, deep learning, and the emerging field of generative artificial intelligence (generative AI). You will gain a solid understanding of foundational AI terms, laying the groundwork for a deeper dive into these concepts. Additionally, you will learn about a selection of Amazon Web Services (AWS) services that use AI and ML capabilities. You will gain practical insights into how these tools can be used to solve real-world problems and drive innovation across various industries. Course level: Fundamental. Duration: 1 hour. This course includes interactive elements, videos, text instruction, and illustrative graphics.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190503,1756271583,0,1,0,1758522880,NULL,0,1),(64,7,13281,'Fundamentals of Machine Learning and Artificial Intelligence (Español LATAM)','H18JA3M4UU','','En este curso, aprenderá los aspectos básicos del machine learning (ML) y la inteligencia artificial (IA). Explorará las relaciones entre la IA, el ML, el aprendizaje profundo y el campo emergente de la inteligencia artificial generativa (IA generativa). Obtendrá una comprensión amplia de los términos básicos de la IA, sentando las bases para profundizar en estos conceptos. Además, aprenderá sobre una selección de servicios de Amazon Web Services (AWS) que utilizan capacidades de IA y ML. Obtendrá información práctica sobre cómo se pueden utilizar estas herramientas para resolver problemas del mundo real e impulsar la innovación en diversos sectores. Nivel del curso: Básico. Duración: 1 hora. Nota: Este curso tiene transcripciones o subtítulos localizados. La narración está en inglés. Para mostrar los subtítulos, haga clic en el botón CC en la esquina inferior derecha del reproductor. En este curso, se incluyen elementos interactivos, instrucciones por escrito, gráficos ilustrativos y evaluaciones de conocimientos.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-419','','',1756190503,1756271583,0,1,0,1758522880,NULL,0,1),(65,7,13280,'Fundamentals of Machine Learning and Artificial Intelligence (Español de España)','5NECBH7HCC','','En este curso, aprenderás sobre los fundamentos del machine learning (ML) y la inteligencia artificial (IA). Explorarás las conexiones entre la IA, el ML, el aprendizaje profundo y el campo emergente de la inteligencia artificial generativa (IA generativa). Obtendrás un gran conocimiento de los términos fundamentales de la IA, lo que sentará las bases para profundizar en estos conceptos. Además, conocerás una selección de servicios de Amazon Web Services (AWS) que utilizan capacidades de IA y ML. Obtendrás información práctica sobre cómo se pueden utilizar estas herramientas para resolver problemas del mundo real e impulsar la innovación en diversas industrias. Este curso contiene elementos interactivos, vídeos, instrucciones de texto y grafos ilustrativos.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-ES','','',1756190504,1756271584,0,1,0,1758522880,NULL,0,1),(66,7,13279,'Fundamentals of Machine Learning and Artificial Intelligence (Français)','MW2VBMW8X3','','Dans ce cours, vous découvrirez les fondements du machine learning (ML) et de l\'intelligence artificielle (IA). Vous explorerez les liens entre l\'IA, le ML, le deep learning et le domaine émergent de l\'intelligence artificielle générative (IA générative). Vous acquerrez une solide compréhension des termes fondamentaux de l\'IA, jetant ainsi les bases d\'une exploration plus approfondie de ces concepts. Vous découvrirez également une sélection de services Amazon Web Services (AWS) qui utilisent les fonctionnalités d\'IA et de ML. Vous obtiendrez des informations pratiques sur la manière dont ces outils peuvent être utilisés pour résoudre des problèmes du monde réel et stimuler l\'innovation dans divers secteurs. Ce cours comprend des éléments interactifs, des vidéos, des instructions textuelles et des graphiques illustratifs.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'fr-FR','','',1756190504,1756271584,0,1,0,1758522880,NULL,0,1),(67,7,13278,'Fundamentals of Machine Learning and Artificial Intelligence (Bahasa Indonesia)','RBU65YEJVY','','Dalam kursus ini, Anda akan belajar tentang dasar-dasar machine learning (ML) dan kecerdasan buatan (AI). Anda akan melihat berbagai bentuk hubungan antara AI, ML, deep learning, dan bidang kecerdasan buatan generatif yang sedang berkembang (AI generatif). Anda akan mendapatkan pemahaman yang sangat baik tentang istilah AI dasar, sehingga memiliki dasar untuk lebih mendalami konsep-konsep ini. Selain itu, Anda akan belajar tentang pilihan layanan Amazon Web Services (AWS) yang menggunakan kemampuan AI dan ML. Anda akan mendapatkan wawasan praktis tentang bagaimana alat-alat ini dapat digunakan untuk memecahkan masalah di dunia nyata dan mendorong inovasi di berbagai industri. Kursus ini meliputi unsur interaktif, video, instruksi teks, dan grafik ilustratif. Catatan: Kursus ini memiliki transkrip/subtitle lokal. Narasi disampaikan dalam bahasa Inggris. Untuk menampilkan subtitle, klik tombol CC di sudut kanan bawah pemutar.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'id-ID','','',1756190504,1756271584,0,1,0,1758522880,NULL,0,1),(68,7,13277,'Fundamentals of Machine Learning and Artificial Intelligence (Italiano)','E2KYS8VAKF','','In questo corso imparerai le basi del machine learning (ML) e dell\'intelligenza artificiale (IA). Esplorerai le connessioni tra IA, ML, deep learning e il campo emergente dell\'intelligenza artificiale generativa (IA generativa). Acquisirai un\'eccellente comprensione dei termini fondamentali dell\'IA e getterai le basi per immergerti in maniera più approfondita in questi concetti. Inoltre, scoprirai alcuni servizi di Amazon Web Services (AWS) che utilizzano funzionalità di AI e ML. Otterrai informazioni pratiche su come puoi utilizzare questi strumenti per risolvere problemi del mondo reale e guidare l\'innovazione in vari settori. Il corso include elementi interattivi, video, istruzioni testuali e grafica illustrativa.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'it-IT','','',1756190504,1756271584,0,1,0,1758522880,NULL,0,1),(69,7,13276,'Fundamentals of Machine Learning and Artificial Intelligence (日本語)','6UX99YCHBZ','','このコースでは、機械学習 (ML) と人工知能 (AI) の基礎について学びます。AI、ML、深層学習、そして生成人工知能 (生成 AI) という新たな分野の関係を探ります。基本的な AI 用語をしっかりと理解し、これらの概念をより深く掘り下げるための基礎を築きます。さらに、AI と ML の機能を使用するさまざまな Amazon Web Services (AWS) のサービスについても学びます。これらのツールを使って現実世界の問題を解決し、さまざまな業界でイノベーションを推進する方法について、実践的なインサイトを得ることができます。このコースには、インタラクティブな要素、テキストによる説明、イラスト入りのグラフィック、ナレッジチェックが含まれます。コースレベル: 基礎、所要時間: 60 分。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190504,1756271584,0,1,0,1758522880,NULL,0,1),(70,7,13275,'Fundamentals of Machine Learning and Artificial Intelligence (한국어)','NR7UT79P3H','','이 과정에서는 기계 학습(ML) 및 인공 지능의 기초에 대해 배웁니다. AI, ML, 딥 러닝 그리고 새로운 생성형 인공 지능(생성형 AI) 분야 간의 연관성을 살펴봅니다. 기본적인 AI 용어를 확실하게 이해하고, 이러한 개념을 심층적으로 탐구할 수 있는 토대를 마련합니다. 또한 AI 및 ML 기능을 사용하는 여러 Amazon Web Services(AWS) 서비스에 대해서도 배웁니다. 이러한 도구를 사용하여 다양한 산업 전반의 실제 문제를 해결하고 혁신을 주도하는 방법에 대한 실질적인 인사이트를 얻을 수 있습니다. 이 과정에는 대화형 요소, 비디오, 텍스트 지침, 예시 그래픽이 포함되어 있습니다.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190505,1756271585,0,1,0,1758522880,NULL,0,1),(71,7,13274,'Fundamentals of Machine Learning and Artificial Intelligence (Português)','Q8X7R47VG4','','Neste curso, você aprenderá sobre os fundamentos de machine learning (ML) e inteligência artificial (IA). Você explorará as conexões entre IA, ML, aprendizado profundo e o campo emergente da inteligência artificial generativa (IA generativa). Você desenvolverá uma compreensão sólida dos termos fundamentais da IA, estabelecendo as bases para uma análise mais aprofundada sobre esses conceitos. Além disso, você aprenderá sobre uma seleção de serviços da Amazon Web Services (AWS) que usam recursos de IA e ML. Você obterá informações práticas sobre como essas ferramentas podem ser usadas para resolver problemas reais e impulsionar a inovação em vários setores. Nível do curso: básico. Duração: 1 hora. Observação: Este curso tem transcrições/legendas traduzidas. A narração está em inglês. Para exibir as legendas, clique no botão CC no canto inferior direito do player. Este curso inclui elementos interativos, instruções de texto, gráficos ilustrativos e testes de conhecimento.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'pt-BR','','',1756190505,1756271585,0,1,0,1758522880,NULL,0,1),(72,7,13273,'Fundamentals of Machine Learning and Artificial Intelligence (简体中文)','4MES6X4445','','在本课程中，您将学习机器学习 (ML) 和人工智能 (AI) 的基础知识。您将探索 AI、ML、深度学习和新兴的生成式人工智能领域之间的联系。您将充分了解 AI 的基础术语，为深入探究这些概念奠定基础。此外，您将了解使用 AI 和 ML 功能的精选 Amazon Web Services (AWS) 服务。您将获得有关如何使用这些工具解决现实问题和推动各行业创新的实用见解。本课程包含互动元素、视频、文字说明，以及配文图表。注意：本课程具有本地化的注释/字幕。 旁白保留英语。要显示字幕，请单击播放器右下角的 CC 按钮。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190505,1756271585,0,1,0,1758522880,NULL,0,1),(73,7,13272,'Fundamentals of Machine Learning and Artificial Intelligence (繁體中文)','B81DQX16E8','','您將在本課程中了解機器學習 (ML) 和人工智慧 (AI) 的基礎。您將探索 AI、ML、深度學習和新興的生成式人工智慧 (生成式 AI) 領域之間的關係。您將深入了解基礎 AI 術語，為更深入探討這些概念奠定基礎。此外，您還將了解一系列 Amazon Web Services (AWS) 服務，這些服務都會使用 AI 和 ML 功能。您將獲得實用洞察，了解如何使用這些工具，來解決實際問題，以及在不同的產業推動創新。本課程包括互動元素、影片、文字指示和說明性圖形。課程等級：基礎。課程時長：1 小時。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-TW','','',1756190505,1756271585,0,1,0,1758522880,NULL,0,1),(74,7,13271,'Innovation and Transformation - Amazon’s Culture of Innovation Overview','GKT1VHA8UK','','This course provides a high-level overview of the Amazon approach to innovation. Amazon has a unique approach to innovation that is intrinsically linked to how the company uses technology and organizes teams. In this course, you will learn how Amazon innovates by focusing on four interdependent elements: culture, mechanisms, architecture, and organization. This course includes three videos.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190505,1756271585,0,1,0,1758522880,NULL,0,1),(75,7,13270,'Innovation and Transformation - Amazon’s Culture of Innovation Overview (日本語)','U4EGWGGBDB','','このコースでは、イノベーションに対する Amazon のアプローチについて大まかに説明します。Amazonのイノベーションに対する独自のアプローチは、企業がテクノロジーをどのように使用し、チームを編成するかと本質的に結びついています。このコースでは、文化、メカニズム、アーキテクチャ、組織という相互に依存する4つの要素に焦点を当てて、Amazonがどのように革新するかを学びます。\n',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190506,1756271586,0,1,0,1758522880,NULL,0,1),(76,7,13269,'AWS Skills Centers: Becoming a Cloud Practitioner - Mini-Quiz Review','DQXRXX3882','','In this quiz, you will be presented with 10 randomized questions to answer and review. These questions will help you to identify your knowledge in specific course objectives. The quiz review includes links into AWS documentation that will help you to study for the exam. Level: Foundational. Duration: 20 minutes. Format: Self-paced practice. Delivery method: Digital.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190506,1756271586,0,1,0,1758522880,NULL,0,1),(77,7,13268,'Getting Started with Amazon EKS Anywhere','JNFC398PCT','','With Amazon EKS Anywhere, you can create and operate on-premises Kubernetes clusters with support from Amazon Web Services (AWS). In this course, you will learn the benefits and technical concepts of Amazon EKS Anywhere. You will learn how to start with the service through a demonstration using the AWS Command Line Interface (AWS CLI). You will learn about the native architecture and how the built-in features can help you streamline on-premises Kubernetes management. This course includes presentations, graphics, tools, and interactive activities.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190506,1756271586,0,1,0,1758522880,NULL,0,1),(78,7,13267,'Getting Started with Amazon EKS Anywhere (한국어)','R591J1BBN2','','Amazon EKS Anywhere를 사용하면 Amazon Web Services(AWS)의 지원을 바탕으로 온프레미스 Kubernetes 클러스터를 만들고 운영할 수 있습니다. 이 과정에서는 Amazon EKS Anywhere의 이점과 기술적 개념을 배우게 됩니다. AWS Command Line Interface(AWS CLI)를 사용하는 데모를 통해 서비스를 시작하는 방법을 학습합니다. 기본 아키텍처와 기본 제공 기능을 통해 온프레미스 Kubernetes 관리를 간소화하는 방법에 대해 학습합니다. 과정 수준: 기초, 소요 시간: 30분. 참고: 이 과정의 동영상에는 한국어 트랜스크립트 또는 자막이 지원되며 음성은 영어로 출력됩니다. 자막을 표시하려면 동영상 화면 우측 하단의 CC 버튼을 클릭하세요. 이 과정은 Google Chrome(최신 주요 버전 2개), Microsoft Edge(최신 주요 버전 2개), Safari(최신 주요 버전 2개)에 최적화되어 있습니다. 이 과정에는 프레젠테이션, 그래픽, 도구, 대화형 활동이 포함되어 있습니다.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190506,1756271586,0,1,0,1758522880,NULL,0,1),(79,7,13266,'Generative AI in Action: Real-World Use Cases','3AA3EJ68HZ','','*This course was developed by members of AWS Technical Field Communities (TFC), an AWS community of technical experts. The content is intended to complement our standard training curriculum and augment your AWS learning journey. We are aware some courses have accessibility limitations and are working to address. If you require accommodation, please contact [AWS Training and Certification Customer Support](https://console.learning-cms.training.aws.dev/products/details/).*\n\nThis course provides an overview of generative AI use cases and the business value they provide. Including real-world applications for generative AI across major industries and case studies. This course was developed by members of AWS Technical Field Communities (TFC), an AWS community of technical experts. The content is intended to complement our standard training curriculum and augment your AWS learning journey. Course level: Fundamental. Duration: 75 min. This course includes presentations, real-world examples and case studies.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190506,1756271586,0,1,0,1758522880,NULL,0,1),(80,7,13265,'Generative AI in Action: Real-World Use Cases (Español LATAM)','5TG33EJPNN','','Este curso proporciona una descripción general de los casos prácticos de la IA generativa y el valor empresarial que proporcionan. Incluye aplicaciones del mundo real para la IA generativa en las principales industrias y estudios de casos. Nivel del curso: básico. Duración: 75 min. Nota: Este curso tiene transcripciones o subtítulos localizados. La narración está en inglés. Para mostrar los subtítulos, haga clic en el botón CC en la esquina inferior derecha del reproductor. Este curso incluye presentaciones, ejemplos reales y estudios de casos.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-419','','',1756190507,1756271586,0,1,0,1758522880,NULL,0,1),(81,7,13264,'Generative AI in Action: Real-World Use Cases (Bahasa Indonesia)','Q3MYQQ9R7U','','Kursus ini dikembangkan oleh anggota AWS Technical Field Communities (TFC), komunitas pakar teknis AWS. Konten ini dimaksudkan untuk melengkapi kurikulum pelatihan standar kami dan menambah perjalanan pembelajaran AWS Anda. Kursus ini memberikan gambaran umum tentang kasus penggunaan AI generatif dan nilai bisnis yang diberikan. Termasuk aplikasi dunia nyata untuk AI generatif di seluruh industri utama dan studi kasus. Kursus ini mencakup presentasi, contoh dunia nyata dan studi kasus.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'id-ID','','',1756190507,1756271587,0,1,0,1758522880,NULL,0,1),(82,7,13263,'Generative AI in Action: Real-World Use Cases (日本語)','7XJDSAEA8P','','このコースは、AWS Technical Field Communities (TFC) のメンバーによって開発されました。TFC は、AWS の技術エキスパートからなるコミュニティです。コースのコンテンツは、AWS の標準トレーニングカリキュラムを補完し、AWS に関する学習体験をさらに充実させることを目的としています。このコースでは、生成 AI のユースケースとそれがもたらすビジネス価値の概要について説明します。これには、主要産業における生成 AI の実際の応用方法とケーススタディが含まれます。このコースには、プレゼンテーション、実際の例、ケーススタディが含まれます。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190507,1756271587,0,1,0,1758522880,NULL,0,1),(83,7,13262,'Generative AI in Action: Real-World Use Cases (한국어)','VPK5A4CDYU','','이 과정은 기술 전문가용 AWS 커뮤니티인 AWS 기술 필드 커뮤니티(TFC) 회원이 개발했습니다. 콘텐츠는 표준 교육 커리큘럼을 보완하고 AWS 학습 여정을 확대하기 위한 것입니다. 이 과정에서는 생성형 AI 사용 사례 및 각 사례가 제공하는 비즈니스 가치에 대한 개요를 제공합니다. 주요 산업 및 사례 연구에서 생성형 AI를 실제 적용한 사례가 포함됩니다. 과정 수준: 기초, 소요 시간: 75분. 참고: 이 과정의 동영상에는 한국어 트랜스크립트 또는 자막이 지원되며 음성은 영어로 출력됩니다. 자막을 표시하려면 동영상 화면 우측 하단의 CC 버튼을 클릭하세요. 이 과정은 Google Chrome(최신 주요 버전 2개), Microsoft Edge(최신 주요 버전 2개), Safari(최신 주요 버전 2개)에 최적화되어 있습니다.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190507,1756271587,0,1,0,1758522880,NULL,0,1),(84,7,13261,'Generative AI in Action: Real-World Use Cases (Português)','ZWVHVUHY8T','','Este curso oferece uma visão geral dos casos de uso de IA generativa e do valor comercial que eles fornecem. Incluindo aplicações reais da IA generativa nos principais setores e estudos de caso. Nível do curso: básico. Duração: 75 minutos. Observação: Este curso tem transcrições/legendas traduzidas. A narração está em inglês. Para exibir as legendas, clique no botão CC no canto inferior direito do player. O curso inclui apresentações, exemplos e estudos de caso reais.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'pt-BR','','',1756190508,1756271587,0,1,0,1758522880,NULL,0,1),(85,7,13260,'Generative AI in Action: Real-World Use Cases (简体中文)','33SM3ESBQ6','','本课程由 AWS 技术专家社区 AWS 技术领域社区 (TFC) 的成员开发。课程内容是我们的标准培训课程的补充，可充实您的 AWS 学习之旅。本课程概述了生成式 AI 使用案例及其提供的商业价值。包括生成式 AI 在主要行业和案例研究中的实际应用。课程级别：基础级，时长：75 分钟。注意：本课程具有本地化的注释/字幕。 旁白保留英语。要显示字幕，请单击播放器右下角的 CC 按钮。本课程包括讲解、真实示例和案例研究。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190508,1756271587,0,1,0,1758522880,NULL,0,1),(86,7,13259,'Generative AI in Action: Real-World Use Cases (繁體中文)','6DWVNR45V7','','本課程由 AWS 技術專家社群 AWS Technical Field Communities (TFC) 的成員所制定。內容旨在補強我們的標準訓練課程，並強化您的 AWS 學習之旅。本課程概述了生成式 AI 的使用案例，及其帶來的商業價值。內容涵蓋生成式 AI 在各大產業中的實際應用和案例研究。注意：本課程具有本地化的註釋/字幕。旁白保留英語。要顯示字幕，請按一下播放器右下角的 CC 按鈕。本課程內容包括簡報、實際範例和案例研究。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-TW','','',1756190508,1756271588,0,1,0,1758522880,NULL,0,1),(87,7,13258,'Getting Started with AWS Systems Manager','PKCXBQX7M5','','AWS Systems Manager is a secure end-to-end management solution for hybrid cloud environments. It helps to simplify resource and application management and shortens the time it takes to detect and resolve operational problems. This Getting Started course provides an overview of the core features and functionality of Systems Manager to help give you an introductory understanding of the services it provides. This course includes presentation, architecture overview, and pricing information.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190508,1756271588,0,1,0,1758522880,NULL,0,1),(88,7,13257,'Getting Started with AWS Systems Manager (Español LATAM)','5ATHXF2Z8C','','AWS Systems Manager es una solución segura de administración end-to-end para entornos de nube híbrida. Ayuda a simplificar la administración de recursos y aplicaciones y acorta el tiempo que se tarda en detectar y resolver problemas operacionales. Este curso Primeros pasos proporciona una visión general de las características principales y la funcionalidad de Systems Manager para ayudarle a obtener una comprensión introductoria de los servicios que proporciona. Nivel del curso: Fundamental. Duración: 60 minutos. Nota: Este curso tiene transcripciones o subtítulos localizados. La narración está en inglés. Para mostrar los subtítulos, haga clic en el botón CC en la esquina inferior derecha del reproductor. Este curso incluye presentación, visión general de la arquitectura e información sobre precios.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-419','','',1756190508,1756271588,0,1,0,1758522880,NULL,0,1),(89,7,13256,'Getting Started with AWS Systems Manager (Français)','BPF3S98QFX','','AWS Systems Manager est une solution de gestion sécurisée de bout en bout pour les environnements cloud hybrides. Il permet de simplifier la gestion des ressources et des applications et de réduire le temps nécessaire pour détecter et résoudre les problèmes opérationnels. Ce cours de mise en route fournit un aperçu des principales caractéristiques et fonctionnalités de Systems Manager afin de vous aider à comprendre les services qu\'il fournit. Ce cours inclut une présentation, une présentation de l\'architecture et des informations sur les prix.\n',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'fr-FR','','',1756190509,1756271588,0,1,0,1758522880,NULL,0,1),(90,7,13255,'Getting Started with AWS Systems Manager (日本語)','UPMTG1XA89','','AWS Systems Manager は、ハイブリッドクラウド環境のための安全なエンドツーエンド管理ソリューションです。リソースとアプリケーションの管理を簡素化するのに役立ち、運用上の問題を検知して解決するのにかかる時間を短縮します。このコースは、Systems Manager の中核となる特徴や機能の概要を提供し、提供されるサービスの基本的な把握に役立ちます。このコースの中のビデオには日本語の字幕がついています。字幕を表示させるには、ビデオ画面下の [CC] アイコンをクリックしてください。コースレベル : 基礎、所要時間 : 60 分。このコースには、プレゼンテーション、アーキテクチャの概要、料金体系の情報が含まれます。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190509,1756271588,0,1,0,1758522880,NULL,0,1),(91,7,13254,'Getting Started with AWS Systems Manager (한국어)','E8MVB2P81P','','Systems Manager는 하이브리드 클라우드 환경을 위한 안전한 엔드 투 엔드 관리 솔루션입니다. 리소스 및 애플리케이션 관리를 간소화하고 운영 문제를 감지 및 해결하는 데 사용하는 시간을 단축하는 데 도움이 됩니다. Getting Started 과정은 Systems Manager의 핵심 특징 및 기능의 개요를 제공하여 제공하는 서비스를 개론적으로 이해하도록 해줍니다. 과정 수준: 기초, 소요 시간: 60분. 이 과정의 동영상에는 한국어 트랜스크립트 또는 자막이 지원되며 음성은 영어로 출력됩니다. 자막을 표시하려면 동영상 화면 우측 하단의 CC 버튼을 클릭하세요. 이 과정은 Google Chrome(최신 주요 버전 2개), Microsoft Edge(최신 주요 버전 2개), Safari(최신 주요 버전 2개)에 최적화되어 있습니다. 이 과정에는 프레젠테이션, 아키텍처 개요 및 가격 정보가 포함됩니다.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190509,1756271589,0,1,0,1758522880,NULL,0,1),(92,7,13253,'Getting Started with AWS Systems Manager (Português)','XVXKQ2Q48R','','O AWS Systems Manager é uma solução segura de gerenciamento de ponta a ponta para ambientes de nuvem híbrida. Isso ajuda a simplificar o gerenciamento de recursos e aplicativos e reduz o tempo necessário para detectar e resolver problemas operacionais. Este curso de introdução fornece uma visão geral dos principais recursos e funcionalidades do Systems Manager para ajudar você a ter uma compreensão introdutória dos serviços que ele fornece. Observação: Este curso tem transcrições/legendas traduzidas. A narração está em inglês. Para exibir as legendas, clique no botão CC no canto inferior direito do player. Este curso inclui apresentação, visão geral da arquitetura e informações sobre preços.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'pt-BR','','',1756190509,1756271589,0,1,0,1758522880,NULL,0,1),(93,7,13252,'AWS Mainframe Modernization - Using Refactor Tools','N33K82A349','','AWS Mainframe Modernization service is a platform for migration, modernization, running, and operation of mainframe applications. This course builds on AWS Mainframe Modernization Refactor with AWS Blu Age Getting Started. In this course, you will learn how to set up and use AWS Automated Refactor tools, AWS Blu Insights, and AWS Blu Age Developer IDE. This course includes presentations, architecture overview, and demonstrations.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190510,1756271589,0,1,0,1758522880,NULL,0,1),(94,7,13251,'Exam Readiness: AWS Certified Machine Learning - Specialty (MLS-C01) (日本語)','W78XBHN3PC','','このコースは、機械学習（ML）ソリューションを設計、実装、展開、および保守する能力を検証する AWS Certified Machine Learning – Specialty 認定試験の対策講座です。このコースでは、試験の概要と受験対策について学び、試験の技術分野について説明します。試験分野に関する主要なAWSサービスと次のようなキーとなる概念について確認します：データエンジニアリング、探究的データ分析、モデリング、ML 実装と運用。また受験対策を立ててそれを実行し、学習効果を高めることができます。学習が進んだらクイズを受けて、自分の得意分野と苦手分野を認識し、試験前の学習を強化すべき事項について知ることができます。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190510,1756271589,0,1,0,1758522880,NULL,0,1),(95,7,13250,'Exam Readiness: AWS Certified Machine Learning - Specialty (MLS-C01) (한국어)','CHJHZNG4XA','','이 과정에서는 기계 학습 솔루션을 설계, 구현, 배포 및 유지 관리하는 지원자의 능력을 검증하는 AWS Certified Machine Learning – Specialty 시험을 준비합니다. 이 과정에서는 시험의 안내 사항 및 시험 문항의 메커니즘에 대해 알아보고 시험의 기술 영역을 살펴봅니다. 시험 영역의 핵심 AWS 서비스 및 주요 개념을 살펴보겠습니다. 1.데이터 엔지니어링 2.탐색적 데이터 분석 3.모형화 4.기계 학습 구현 및 운영 또한 주요 테스트 전략을 배우고 여러 가지 학습 문항을 통해 실제로 적용해봅니다. 스킬을 연마한 후에는 강점과 약점을 평가하는 데 도움이 되는 퀴즈를 통해 시험 전 공부를 할 때 어떤 부분에 중점을 두어야 할지 알 수 있습니다. 참고: 과정의 각 모듈에 포함되어 있는 영역 퀴즈는 현재 영어로만 제공됩니다. 한국어 버전은 추후 업데이트될 예정입니다. 참고: 이 과정의 동영상에는 한국어 트랜스크립트 또는 자막이 지원되며 음성도 한국어로 출력됩니다. 자막을 표시하려면 동영상 우측 화면 하단의 CC 버튼을 클릭하세요.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190510,1756271589,0,1,0,1758522880,NULL,0,1),(96,7,13249,'Exam Readiness: AWS Certified Machine Learning - Specialty (MLS-C01) (简体中文)','XZGRF13PCH','','本课程用于帮助您准备 AWS Certified Machine Learning – Specialty 考试，该考试旨在检验您在设计、实施、部署以及维护机器学习 (ML) 解决方案方面的能力。通过本课程，您将会了解到考试的安排情况、考试题型以及考试涵盖的技术领域。您将会学习有关以下考试领域的核心 AWS 服务和关键概念：数据工程、探索性数据分析、建模、机器学习实施和操作。您还会学习一些重要的应试策略，并在回答练习题的过程中应用这些策略。磨练好技能后，您可以参加测验，以便评估自己的优势和不足，这样您就会知道自己在备考时应该重点学习哪些知识。级别：中级 授课方式：数字化 持续时间：4 小时 形式：多媒体演示、演练练习题、其他测验和练习题。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190510,1756271590,0,1,0,1758522880,NULL,0,1),(97,7,13248,'AWS Managed Services (AMS): Advanced Self Service Reporting','3T85HMMS72','','AWS Managed Services (AMS) Self-Service Reporting collects data from various AWS services and provides you with reports on AMS patch, backup, billing, and incident management services. AMS Senior Cloud Service Delivery Manager Jeremy Tennant addresses the challenges that AMS Self-Service Reporting solves, how you can integrate your business intelligence tools with Self-Service Reporting, and provides a demonstration of the service in the AMS Console. This course includes presentations.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190510,1756271590,0,1,0,1758522880,NULL,0,1),(98,7,13247,'Domain 4 Review: AWS Certified Advanced Networking - Specialty (ANS-C01 - English)','KWUFX15DQ3','','In this course, you will review Domain 4: Network Security, Compliance, and Governance of the AWS Certified Advanced Networking - Specialty (ANS-C01) exam. Prepare for the exam by exploring these topics and how they align to AWS services and to specific areas of study. Review videos for each topic area of the domain, delivered by expert instructors.This course is part of 4 steps that you can use to prepare for your exam with confidence. To follow the 4 steps, enroll in the Exam Prep Plan: AWS Certified Advanced Networking - Specialty (ANS-C01). Some of this content might require an AWS Skill Builder subscription.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190511,1756271590,0,1,0,1758522880,NULL,0,1),(99,7,13246,'Domain 4 Review: AWS Certified Advanced Networking - Specialty (ANS-C01 - 日本語)','XCEXKMH4SB','','このコースでは、AWS Certified Advanced Networking - Specialty (ANS-C01) 試験の第 4 分野: ネットワークのセキュリティ、コンプライアンス、ガバナンス を確認します。これらのトピックを確認し、AWS のサービスや特定の学習分野とそれらがどのように関連しているかを調べて、試験の準備をしましょう。このコースは、自信を持って試験の準備をするための 4 つのステップの一部です。この 4 つのステップを実行するには、Exam Prep Plan: AWS Certified Advanced Networking - Specialty (ANS-C01).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190511,1756271590,0,1,0,1758522880,NULL,0,1),(100,7,13245,'Domain 4 Review: AWS Certified Advanced Networking - Specialty (ANS-C01 - 한국어)','BQWGP96CAH','','이 과정에서는 AWS Certified Advanced Networking - Specialty (ANS-C01) 시험의 4: 네트워크 보안, 규정 준수 및 거버넌스 도메인을 검토합니다. 이러한 주제를 살펴보고 해당 주제가 AWS 서비스 및 특정 학습 영역에 어떻게 일치하는지 알아보며 시험을 준비합니다.이 과정은 자신 있게 시험을 준비할 수 있도록 마련된 4단계 중 일부입니다. 4단계를 진행하려면 Exam Prep Plan: AWS Certified Advanced Networking - Specialty (ANS-C01).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190511,1756271590,0,1,0,1758522880,NULL,0,1),(101,7,13244,'Domain 4 Review: AWS Certified Advanced Networking - Specialty (ANS-C01 - 简体中文)','YC2HQAKHTR','','在本课程中，您将检阅 AWS Certified Advanced Networking - Specialty (ANS-C01)考试的领域 4: 网络安全、合规性和监管。通过探索这些主题，了解其与 AWS 服务和特定研究领域的关联，为考试做好准备。本课程是四步骤备考的一部分，您可以使用这些步骤自信地准备考试。若要遵循这四个步骤，请注册 Exam Prep Plan: AWS Certified Advanced Networking - Specialty (ANS-C01)。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190511,1756271591,0,1,0,1758522880,NULL,0,1),(102,7,13243,'Domain 4 Review: AWS Certified Machine Learning Engineer - Associate (MLA-C01 - English)','3VGMPBSGXU','','In this course, you will review Domain 4: ML Solution Monitoring, Maintenance, and Security of the AWS Certified Machine Learning Engineer - Associate (MLA-C01) exam. Prepare for the exam by exploring these topics and how they align to AWS services and to specific areas of study. Review videos for each topic area of the domain, delivered by expert instructors.This course is part of 4 steps that you can use to prepare for your exam with confidence. To follow the 4 steps, enroll in the Exam Prep Plan: AWS Certified Machine Learning Engineer - Associate (MLA-C01). Some of this content might require an AWS Skill Builder subscription.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190512,1756271591,0,1,0,1758522880,NULL,0,1),(103,7,13242,'Domain 4 Review: AWS Certified Machine Learning Engineer - Associate (MLA-C01 - 日本語実写版)','NPV8HTFHP8','','このコースでは、AWS Certified Machine Learning Engineer - Associate (MLA-C01) 試験の第 4 分野: ML ソリューションのモニタリング、保守、セキュリティ を確認します。これらのトピックを確認し、AWS のサービスや特定の学習分野とそれらがどのように関連しているかを調べて、試験の準備をしましょう。このコースは、自信を持って試験の準備をするための 4 つのステップの一部です。この 4 つのステップを実行するには、Exam Prep Plan: AWS Certified Machine Learning Engineer - Associate (MLA-C01).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190512,1756271591,0,1,0,1758522880,NULL,0,1),(104,7,13241,'Domain 4 Review: AWS Certified Machine Learning Engineer - Associate (MLA-C01 - 한국어)','AHZZCA2RMT','','이 과정에서는 AWS Certified Machine Learning Engineer - Associate (MLA-C01) 시험의 4: ML 솔루션 모니터링, 유지 관리 및 보안 도메인을 검토합니다. 이러한 주제를 살펴보고 해당 주제가 AWS 서비스 및 특정 학습 영역에 어떻게 일치하는지 알아보며 시험을 준비합니다.이 과정은 자신 있게 시험을 준비할 수 있도록 마련된 4단계 중 일부입니다. 4단계를 진행하려면 Exam Prep Plan: AWS Certified Machine Learning Engineer - Associate (MLA-C01).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190512,1756271591,0,1,0,1758522880,NULL,0,1),(105,7,13240,'Domain 4 Review: AWS Certified Machine Learning Engineer - Associate (MLA-C01 - 简体中文)','7S9G6EHMJT','','在本课程中，您将检阅 AWS Certified Machine Learning Engineer - Associate (MLA-C01)考试的领域 4: ML 解决方案的监控、维护和安全保护。通过探索这些主题，了解其与 AWS 服务和特定研究领域的关联，为考试做好准备。本课程是四步骤备考的一部分，您可以使用这些步骤自信地准备考试。若要遵循这四个步骤，请注册 Exam Prep Plan: AWS Certified Machine Learning Engineer - Associate (MLA-C01)。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190512,1756271591,0,1,0,1758522880,NULL,0,1),(106,7,13239,'Responsible Artificial Intelligence Practices (العربية)','AUDGMPK3R1','','ستتعرف في هذه الدورة التدريبية على ممارسات الذكاء الاصطناعي (AI) المسؤولة. أولاً، سوف تتعرف على ماهية الذكاء الاصطناعي (AI) المسؤول. سوف تتعلم كيفية تعريف الذكاء الاصطناعي (AI) المسؤول، وفهم التحديات التي يحاول الذكاء الاصطناعي المسؤول التغلب عليها، واستكشاف الأبعاد الأساسية للذكاء الاصطناعي المسؤول. وبعد ذلك، سوف تتعمق في بعض الموضوعات لتطوير أنظمة الذكاء الاصطناعي (AI) المسؤولة. وسيتم تعريفك بالخدمات والأدوات التي تقدمها AWS لمساعدتك في الذكاء الاصطناعي (AI) المسؤول. وستتعرف أيضًا على اعتبارات الذكاء الاصطناعي (AI) المسؤولة لاختيار نموذج وإعداد البيانات لأنظمة الذكاء الاصطناعي الخاصة بك. وأخيرًا، ستتعرف على النماذج الشفافة والقابلة للتفسير. سوف تكتسب فهمًا راسخًا لما يعنيه أن يكون النموذج شفافًا وقابلاً للتفسير. ستستكشف أيضًا الاعتبارات المتعلقة بالمفاضلات في النماذج الشفافة، ومبادئ التصميم المرتكز على الإنسان في مجال الذكاء الاصطناعي (AI) القابل للتفسير. تتضمن هذه الدورة التدريبية عناصر تفاعلية وتعليمات نصية ورسومات توضيحية والتحقق من المعرفة. مستوى الدورة التدريبية: أساسي. المدة: ساعة واحدة.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ar-SA','','',1756190513,1756271591,0,1,0,1758522880,NULL,0,1),(107,7,13238,'Responsible Artificial Intelligence Practices (Deutsch)','SWA9BTEERH','','In diesem Kurs lernst du Praktiken der verantwortungsvollen künstlichen Intelligenz kennen. Zunächst erfährst du, was verantwortungsvolle KI ist. Du lernst, wie verantwortungsvolle KI definiert wird, welche Herausforderungen, die verantwortungsvolle KI zu bewältigen versucht und erkundest die Kerndimensionen verantwortungsvoller KI. Anschließend wirst du dich mit einigen Themen näher befassen, die die Entwicklung verantwortungsvoller KI-Systeme betreffen. Du erhältst eine Einführung in die Services und Tools, die AWS anbietet, um dich bei verantwortungsvoller KI zu unterstützen. Du erfährst auch, welche Überlegungen zur verantwortungsvollen KI bei der Auswahl eines Modells und der Datenaufbereitung für deine KI-Systeme zu berücksichtigen sind. Schließlich lernst du transparente und erklärbare Modelle kennen. Du erlangst ein fundiertes Verständnis davon, was es bedeutet, dass ein Modell transparent und erklärbar ist. Du wirst dich auch mit Kompromissüberlegungen für transparente Modelle und den Prinzipien des menschenzentrierten Designs für erklärbare KI beschäftigen. Kursstufe: Grundlagenkurs. Dauer: 1 Stunde. Dieser Kurs beinhaltet interaktive Elemente, Textanweisungen, illustrative Grafiken und Wissenschecks.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'de-DE','','',1756190513,1756271592,0,1,0,1758522880,NULL,0,1),(108,7,13237,'Responsible Artificial Intelligence Practices','BN51NEFJNG','','In this course, you will learn about responsible AI practices. First, you will be introduced to what responsible AI is. You will learn how to define responsible AI, understand the challenges that responsible AI attempt to overcome and explore the core dimensions of responsible AI. Then, you will dive into some topics for developing responsible AI systems. You will be introduced to the services and tools that AWS offers to help you with responsible AI. You will also learn about responsible AI considerations for selecting a model and preparing data for your AI systems. Finally, you learn about transparent and explainable models. You will gain a solid understanding for what it means for a model to be transparent and explainable. You will also explore tradeoff considerations for transparent models and the principles of human-centered design for explainable AI. This course includes interactive elements, text instruction, illustrative graphics and knowledge checks.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190513,1756271592,0,1,0,1758522880,NULL,0,1),(109,7,13236,'Responsible Artificial Intelligence Practices (Español LATAM)','UCPWCMQ9U6','','En este curso, aprenderá sobre las prácticas de la IA responsable. En primer lugar, tendrá acceso a una introducción en la que se explicará qué es la IA responsable. Aprenderá a definir la IA responsable, comprenderá los desafíos que la IA responsable intenta superar y explorará las dimensiones fundamentales de la IA responsable. Luego, profundizará en algunos temas sobre el desarrollo de sistemas de IA responsable. Recibirá una introducción a los servicios y herramientas que ofrece AWS para ayudarle a desarrollar una IA responsable. También aprenderá sobre las consideraciones de la IA responsable que se deben tener en cuenta al momento de seleccionar un modelo y preparar los datos para sus sistemas de IA. Finalmente, aprenderá sobre los modelos transparentes y explicables. Adquirirá una sólida comprensión de lo que significa que un modelo sea transparente y explicable. También explorará las ventajas y desventajas de los modelos transparentes y los principios del diseño centrado en el ser humano para una IA explicable. Nivel del curso: básico. Duración: 1 hora. En este curso, se incluyen elementos interactivos, instrucciones textuales, gráficos ilustrativos y evaluaciones de conocimientos.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-419','','',1756190513,1756271592,0,1,0,1758522880,NULL,0,1),(110,7,13235,'Responsible Artificial Intelligence Practices (Español de España)','GHQGFH7ABC','','En este curso, obtendrás información sobre las prácticas responsables de la IA. En primer lugar, se explicará qué es la IA responsable. Descubrirás cómo definir la IA responsable, comprender los desafíos que intenta superar y explorar sus principales dimensiones. A continuación, verás algunos temas con más detalle para desarrollar sistemas de IA responsable. Se explicarán los servicios y las herramientas que ofrece AWS para ayudarte a desarrollar una IA responsable. También obtendrás información sobre las consideraciones de la IA responsable a fin de seleccionar un modelo y preparar datos para tus sistemas de IA. Por último, obtendrás información sobre modelos transparentes y explicables. Obtendrás unos sólidos conocimientos de lo que significa que un modelo sea transparente y explicable. También explorarás las consideraciones de compensación para los modelos transparentes y los principios del diseño centrados en las personas para conseguir una IA explicable.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-ES','','',1756190513,1756271592,0,1,0,1758522880,NULL,0,1),(111,7,13234,'Responsible Artificial Intelligence Practices (Français)','1PU6ABD2KA','','Dans ce cours, vous découvrirez les pratiques responsables en matière d\'IA. Tout d\'abord, vous découvrirez à quoi correspond une IA responsable. Vous apprendrez à définir l\'IA responsable, à comprendre les défis que l\'IA responsable tente de surmonter et à explorer les aspects fondamentaux de l\'IA responsable. Ensuite, vous aborderez certaines rubriques liées au développement de systèmes d\'IA responsables. Vous découvrirez les services et outils proposés par AWS pour vous aider à utiliser une IA responsable. Vous découvrirez également les considérations relatives à l\'IA responsable lors de la sélection d\'un modèle et de la préparation de données pour vos systèmes d\'IA. Enfin, vous découvrirez les modèles transparents et explicables. Vous acquerrez une compréhension solide de ce que signifie la transparence et l\'explicabilité d\'un modèle. Vous explorerez également les compromis possibles entre les modèles transparents et les principes de conception centrée sur l\'humain pour une IA explicable. Ce cours comprend des éléments interactifs, des instructions textuelles, des graphiques illustratifs ainsi qu\'un contrôle des connaissances.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'fr-FR','','',1756190514,1756271592,0,1,0,1758522880,NULL,0,1),(112,7,13233,'Responsible Artificial Intelligence Practices (Bahasa Indonesia)','YJQ26WSDHX','','Dalam kursus ini, Anda akan belajar tentang praktik AI yang bertanggung jawab. Pertama, Anda akan diperkenalkan dengan apa itu AI yang bertanggung jawab. Anda akan belajar cara mendefinisikan AI yang bertanggung jawab, memahami tantangan yang coba diatasi oleh AI yang bertanggung jawab dan mengeksplorasi dimensi inti AI yang bertanggung jawab. Kemudian, Anda akan menyelami beberapa topik untuk mengembangkan sistem AI yang bertanggung jawab. Anda akan diperkenalkan dengan layanan dan alat yang ditawarkan AWS untuk membantu Anda dengan AI yang bertanggung jawab. Anda juga akan belajar tentang pertimbangan AI yang bertanggung jawab untuk memilih model dan menyiapkan data untuk sistem AI Anda. Akhirnya, Anda belajar tentang model yang transparan dan dapat dijelaskan. Anda akan mendapatkan pemahaman yang kuat tentang apa artinya model menjadi transparan dan dapat dijelaskan. Anda juga akan mengeksplorasi pertimbangan pertukaran untuk model transparan dan prinsip-prinsip desain yang berpusat pada manusia untuk AI yang dapat dijelaskan. Kursus ini mencakup elemen interaktif, instruksi teks, grafik ilustratif, dan pemeriksaan pengetahuan. Tingkat kursus: Dasar. Durasi: 1 jam.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'id-ID','','',1756190514,1756271593,0,1,0,1758522880,NULL,0,1),(113,7,13232,'Responsible Artificial Intelligence Practices (Italiano)','4PAKP3BVM9','','In questo corso apprenderai le pratiche di IA responsabile. Prima di tutto, ti verrà spiegato che cos\'è l\'IA responsabile. Apprenderai a definire l\'IA responsabile, scoprirai le sfide che tenta di affrontare e ne esplorerai le caratteristiche di base. Approfondirai quindi alcuni argomenti correlati allo sviluppo di sistemi di intelligenza artificiale responsabili. Scoprirai i servizi e gli strumenti offerti da AWS per supportare l\'IA responsabile. Presenteremo anche alcune considerazioni sull\'IA responsabile per la selezione di un modello e la preparazione dei dati per i sistemi di intelligenza artificiale. Infine, scoprirai che cosa sono i modelli trasparenti e spiegabili. Acquisirai una solida comprensione di cosa significhi per un modello essere trasparente e spiegabile. Esplorerai anche le considerazioni sui compromessi relativi ai modelli trasparenti e i principi della progettazione incentrata sulle persone per soluzioni di intelligenza artificiale spiegabili. Questo corso include elementi interattivi, istruzioni testuali, grafica illustrativa e verifiche delle conoscenze.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'it-IT','','',1756190514,1756271593,0,1,0,1758522880,NULL,0,1),(114,7,13231,'Responsible Artificial Intelligence Practices (日本語)','MN5A2M1UNY','','このコースでは、責任ある AI の実践について学びます。最初に、責任ある AI とは何かを説明します。責任ある AI の定義方法、直面している課題、その主な要素について学習します。次に、責任ある AI システムを開発するためのトピックをいくつか取り上げます。責任ある AI をサポートするために AWS が提供しているサービスとツールを紹介します。また、AI システム用にモデルを選択してデータを準備する際の責任ある AI の考慮事項についても学習します。さらに、透明性と説明可能性があるモデルについて学習します。モデルに透明性と説明可能性があるとはどういうことなのかをしっかりと理解できるようになります。また、透明性があるモデルに関するトレードオフの考慮事項と、説明可能性がある AI の人間中心設計の原則についても調べます。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190514,1756271593,0,1,0,1758522880,NULL,0,1),(115,7,13230,'Responsible Artificial Intelligence Practices (한국어)','K7DJWQNHS9','','이 과정에서는 책임감 있는 AI 관행에 대해 알아봅니다. 먼저 책임감 있는 AI가 무엇인지 소개합니다. 책임감 있는 AI를 정의하는 방법을 배우고, 책임감 있는 AI가 극복하려는 과제를 이해하고, 책임감 있는 AI의 핵심 요소를 탐구하게 됩니다. 그런 다음 책임감 있는 AI 시스템 개발을 위한 몇 가지 주제를 자세히 살펴봅니다. 책임감 있는 AI를 지원하기 위해 AWS에서 제공하는 서비스 및 도구를 소개합니다. 또한 모델을 선택하고 AI 시스템용 데이터를 준비하기 위한 책임감 있는 AI 고려 사항에 대해서도 배우게 됩니다. 마지막으로 투명하고 설명 가능한 모델에 대해 알아봅니다. 모델이 투명하고 설명 가능하다는 것이 무엇을 의미하는지 확실히 이해하게 될 것입니다. 또한 투명한 모델의 절충점 고려 사항과 설명 가능한 AI를 위한 인간 중심 설계 원칙에 대해서도 살펴봅니다. 이 과정에는 대화형 요소, 텍스트 지침, 예시 그래픽 및 지식 확인이 포함되어 있습니다. 과정 수준: 기초, 소요 시간: 1시간',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190515,1756271593,0,1,0,1758522880,NULL,0,1),(116,7,13229,'Responsible Artificial Intelligence Practices (Português)','71B8E85X93','','Neste curso, você verá práticas responsáveis de IA. Primeiro, você aprenderá o que é a IA responsável. Você aprenderá a defini-la, entender os desafios que ela busca superar e explorar suas principais dimensões. Em seguida, você se aprofundará em diversos tópicos relacionados ao desenvolvimento de sistemas de IA responsável. Você conhecerá os serviços e as ferramentas que a AWS oferece para ajudar você com a IA responsável. Você também aprenderá sobre as considerações de IA responsável na seleção de um modelo e no preparo de dados para seus sistemas de IA. Por fim, você verá modelos transparentes e explicáveis. Você obterá uma compreensão sólida do que significa um modelo transparente e explicável. Também explorará as vantagens e desvantagens dos modelos transparentes e os princípios do design centrado na pessoa para uma IA explicável. Este curso inclui elementos interativos, instruções de texto, gráficos ilustrativos e testes de conhecimento. Nível do curso: básico. Duração: 1 hora.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'pt-BR','','',1756190515,1756271593,0,1,0,1758522880,NULL,0,1),(117,7,13228,'Responsible Artificial Intelligence Practices (ไทย)','HDTVW7XJM3','','ในหลักสูตรนี้ คุณจะได้เรียนรู้เกี่ยวกับแนวทางปฏิบัติด้าน AI ที่มีความรับผิดชอบ ในขั้นแรก คุณจะได้เริ่มต้นเรียนรู้ว่า AI ที่มีความรับผิดชอบคืออะไร คุณจะได้เรียนรู้การนิยาม AI ที่มีความรับผิดชอบ, เข้าใจความท้าทายที่ AI ที่มีความรับผิดชอบพยายามก้าวข้าม และสำรวจมิติหลักของ AI ที่มีความรับผิดชอบ จากนั้นคุณจะได้เจาะลึกเกี่ยวกับการพัฒนาระบบ AI ที่มีความรับผิดชอบในบางหัวข้อ คุณจะได้ทำความรู้จักบริการและเครื่องมือที่ AWS นำเสนอเพื่อช่วยคุณในเรื่องเกี่ยวกับ AI ที่มีความรับผิดชอบ นอกจากนี้ คุณยังจะได้เรียนรู้ถึงข้อควรพิจารณาเกี่ยวกับ AI ที่มีความรับผิดชอบ ในการเลือกโมเดลและเตรียมข้อมูลสำหรับระบบ AI ของคุณ สุดท้ายคุณจะได้เรียนรู้เกี่ยวกับโมเดลที่โปร่งใสและอธิบายได้ คุณจะได้รับความเข้าใจอย่างชัดเจนว่า โมเดลที่โปร่งใสและอธิบายได้นั้นควรเป็นอย่างไร นอกจากนี้ คุณยังจะได้สำรวจข้อควรพิจารณาเกี่ยวกับสิ่งที่ต้องแลกเพื่อให้ได้มาซึ่งโมเดลที่โปร่งใส และหลักการของการออกแบบที่มุ่งเน้นมนุษย์สำหรับ AI ที่อธิบายได้ หลักสูตรนี้ประกอบด้วยองค์ประกอบเชิงโต้ตอบ ข้อความคำชี้แจง ภาพประกอบ และการทดสอบความรู้',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'th-TH','','',1756190515,1756271594,0,1,0,1758522880,NULL,0,1),(118,7,13227,'Responsible Artificial Intelligence Practices (Tiếng Việt)','RNAUWFC84S','','Trong khóa học này, bạn sẽ tìm hiểu về các phương pháp thực hành AI có trách nhiệm. Đầu tiên, bạn sẽ tìm hiểu định nghĩa về AI có trách nhiệm. Bạn sẽ tìm hiểu cách định nghĩa AI có trách nhiệm, những thách thức mà AI có trách nhiệm cần giải quyết và khám phá các phương diện cốt lõi của AI có trách nhiệm. Sau đó, bạn sẽ tìm hiểu sâu về một số chủ đề để phát triển hệ thống AI có trách nhiệm. Phần này sẽ giới thiệu các dịch vụ và công cụ mà AWS cung cấp để giúp bạn thực hành AI có trách nhiệm. Bạn cũng sẽ tìm hiểu các vấn đề cần cân nhắc về AI có trách nhiệm khi lựa chọn mô hình và chuẩn bị dữ liệu cho hệ thống AI. Cuối cùng, bạn sẽ tìm hiểu về các mô hình minh bạch và có thể giải thích. Bạn sẽ hiểu rõ mô hình minh bạch và có thể giải thích là gì. Bạn cũng sẽ khám phá sự đánh đổi cần cân nhắc cho các mô hình minh bạch và nguyên tắc thiết kế tập trung vào con người dành cho AI có thể giải thích. Khóa học này có các yếu tố tương tác, văn bản hướng dẫn, đồ họa minh họa và kiểm tra kiến thức.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'vi-VN','','',1756190515,1756271594,0,1,0,1758522880,NULL,0,1),(119,7,13226,'Responsible Artificial Intelligence Practices (简体中文)','4BVS1735Q5','','在本课程中，您将学习负责任的 AI 实践。首先，您将了解什么是负责任的 AI。您将学习如何定义负责任的 AI，了解负责任的 AI 需要克服的挑战，并探索负责任的 AI 的核心维度。然后，您将深入探讨有关开发负责任的 AI 系统的一些主题。您将了解 AWS 为帮助您使用负责任的 AI 而提供的服务和工具。此外，您还将了解为 AI 系统选择模型和准备数据时的负责任的 AI 注意事项。最后，您将了解透明且可解释的模型。您将深刻了解什么是透明且可解释的模型。您还将探索透明模型的权衡考虑因素和可解释的 AI 的以人为本设计原则。本课程包含互动元素、文字说明、配文图表和知识考核。课程级别：基础级，时长：1 小时。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190516,1756271594,0,1,0,1758522880,NULL,0,1),(120,7,13225,'Responsible Artificial Intelligence Practices (繁體中文)','VK6568Q5UG','','在本課程中，您將學習 AI 實踐。首先，將為您介紹什麼是負責任的 AI。您將學習如何定義負責任的 AI、瞭解負責任的 AI 嘗試克服之挑戰，以及探索負責任 AI 的核心維度。然後，您將深入探索一些主題，瞭解開發負責任的 AI 系統。將為您介紹由 AWS 提供，以協助您使用負責任的 AI 之服務和工具。您也將瞭解在為 AI 系統選擇模型和準備資料時，負責任 AI 之考量。最後，您會瞭解透明且可解釋的模型。您將深入瞭解若模型是透明且可解釋，其代表什麼意義。您也將探索透明模型的權衡取捨考量以及可解釋 AI 的以人為中心設計原則。本課程包括互動元素、文本說明、說明圖形，以及知識檢測。課程等級：基礎，課程時長：1 小時。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-TW','','',1756190516,1756271594,0,1,0,1758522880,NULL,0,1),(121,7,13224,'Amazon Connect Chat and Messaging Intermediate','VGWA5SVUYJ','','Amazon Connect chat and messaging channels allow organizations\' customers to reach their contact centers using text-based communication. The Amazon Connect messaging channels are: web chat, mobile chat, SMS, and third-party messaging applications like WhatsApp and Facebook Messenger. This course includes interactions and assessments.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190516,1756271594,0,1,0,1758522880,NULL,0,1),(122,7,13223,'Amazon Connect Chat and Messaging Intermediate (Français)','UN2JHEFX2Q','','Les canaux de chat et de messagerie d\'Amazon Connect permettent aux clients des organisations de contacter leurs centres de contact via une communication textuelle. Les canaux de messagerie d\'Amazon Connect sont : le chat web, le chat mobile, les SMS et les applications de messagerie tierces comme WhatsApp et Facebook Messenger. Ce cours comprend des interactions et des évaluations.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'fr-FR','','',1756190516,1756271595,0,1,0,1758522880,NULL,0,1),(123,7,13222,'Build and Deploy APIs with a Serverless CI/CD (Deutsch)','BYHT3GZ6KM','','Aufbau einer API-Engine, Verwaltung einer CI/CD-Pipeline: Für das Erreichen dieser DevOps-Ziele mussten in der Vergangenheit eine Reihe von Instances verwaltet werden, einschließlich des gesamten damit verbundenen operativen Overheads. Atul Bargaje und Rahul Sareen, AWS IoT Architects, führen Sie durch den Prozess der Vereinfachung Ihrer DevOps-Prozesse mit serverlosen Methoden. Sie werden zuerst erfahren, wie APIs derzeit mit traditionellen Methoden verwaltet werden, und erlernen dann die bewährten Methoden der realen Welt dazu, wie serverlose Anwendungsmethoden (SAM) Ihre Abläufe rationalisieren können. Hinweis: Dieser Kurs verfügt über lokalisierte Transkripte/Untertitel (e). Der Vortrag ist auf Englisch.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'de-DE','','',1756190517,1756271595,0,1,0,1758522880,NULL,0,1),(124,7,13221,'Build and Deploy APIs with a Serverless CI/CD','22YSR2UA4K','','Building an API engine, managing a CI/CD pipeline: achieving these DevOps goals historically took managing a number of instances with all the associated operational overhead. Atul Bargaje and Rahul Sareen, AWS IoT Architects, guide you through the process of simplifying your DevOps processes using serverless methods. You\'ll start by understanding how APIs are currently managed with traditional methods, then learn the real-world, best practices of how serverless application methods (SAM) can streamline your operations.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190517,1756271595,0,1,0,1758522880,NULL,0,1),(125,7,13220,'Build and Deploy APIs with a Serverless CI/CD (Español LATAM)','DWCXZPAKG4','','Este producto se actualizó el 17 dic 2024. En este momento, tiene acceso tanto a la versión anterior como a la nueva. Puede elegir entre dos opciones: Opción 1: continuar con la versión anterior. Tiene hasta el 16 ene 2025 para completarlo. Si no lo completa antes de esta fecha, su progreso se restablecerá y tendrá que volver a empezar con la versión más reciente. Opción 2: iniciar la nueva versión. El progreso anterior se restablecerá. Tiene acceso a la última versión y dispondrá de más de 30 días para completarlo. Construir un motor de API, administrar una canalización de CI/CD: el logro de estos objetivos de DevOps ha llevado históricamente la administración de una serie de instancias con toda la sobrecarga operativa asociada. Atul Bargaje y Rahul Sareen, de AWS IoT Architects, le guiarán a través del proceso de simplificación de sus procesos de DevOps utilizando métodos sin servidor. Comenzará por comprender cómo las API se administran actualmente con métodos tradicionales y, a continuación, aprenderá las prácticas recomendadas del mundo real sobre cómo los métodos de aplicación sin servidor (SAM) pueden optimizar sus operaciones. Nota: Este curso tiene transcripciones o subtítulos localizados. La narración está en inglés.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-419','','',1756190517,1756271595,0,1,0,1758522880,NULL,0,1),(126,7,13219,'Build and Deploy APIs with a Serverless CI/CD (Français)','GJU9T4W563','','Construire un moteur API et gérer un pipeline CI/CD : la réalisation de ces objectifs DevOps nécessitait traditionnellement de gérer de nombreuses instances, avec tous les frais généraux opérationnels associés. Les AWS IoT Architects Atul Bargaje et Rahul Sareen vous guident tout au long du processus qui vous permettra de simplifier vos processus DevOps à l\'aide de méthodes sans serveur. Vous commencerez par apprendre les méthodes de gestion d\'API traditionnelles, puis vous découvrirez de bonnes pratiques concrètes pour rationaliser vos applications à l\'aide des méthodes d\'application sans serveur (SAM, Serverless Application Methods). Remarque : ce cours comporte des transcriptions ou des sous-titres localisés. La narration est en anglais.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'fr-FR','','',1756190517,1756271596,0,1,0,1758522880,NULL,0,1),(127,7,13218,'Build and Deploy APIs with a Serverless CI/CD (Bahasa Indonesia)','M9Y5GJA85Y','','Membangun mesin API, mengelola jalur CI/CD: mencapai tujuan DevOps ini secara historis memerlukan pengelolaan sejumlah instans dengan semua biaya operasional terkait. Atul Bargaje dan Rahul Sareen, AWS IoT Architects, memandu Anda melalui cara menyederhanakan proses DevOps Anda menggunakan metode tanpa server. Anda akan mulai dengan memahami bagaimana API saat ini dikelola dengan metode tradisional, kemudian mempelajari praktik terbaik dunia nyata tentang bagaimana serverless application methods/metode aplikasi tanpa server (SAM) dapat merampingkan operasi Anda. Catatan: Kursus ini memiliki transkrip/subtitle lokal. Narasi disampaikan dalam bahasa Inggris.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'id-ID','','',1756190518,1756271596,0,1,0,1758522880,NULL,0,1),(128,7,13217,'Build and Deploy APIs with a Serverless CI/CD (日本語吹き替え版)','S5TNCSU41B','','これまで、API エンジンの構築と CI/CD パイプラインの管理、およびこれらの DevOps の目標達成には、関連するすべての運用オーバーヘッドをともなう多数のインスタンスの管理が必要でした。AWS IoT アーキテクトである Atul Bargaje と Rahul Sareen が、サーバーレスメソッドを使用して DevOps プロセスを簡素化するプロセスについてガイドします。API が従来のメソッドによって現状でどのように管理されているかを理解してから、サーバーレスアプリケーションメソッド (SAM) によってどのように運用が合理化されるか、実際のベストプラクティスについて学びます。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190518,1756271596,0,1,0,1758522880,NULL,0,1),(129,7,13216,'Build and Deploy APIs with a Serverless CI/CD (한국어)','UE9T155KZQ','','API 엔진 빌드와 CI/CD 파이프라인 관리 등의 DevOps 목표를 달성하기 위해 이전에는 관련 운영 오버헤드를 모두 포함한 수많은 인스턴스를 관리해야 했습니다. AWS IoT 아키텍트인 Atul Bargaje와 Rahul Sareen은 서버리스 방법을 사용하여 DevOps 프로세스를 간소화하는 과정을 안내합니다. 먼저 API가 기존 방법으로 어떻게 관리되는지 이해하고, 서버리스 애플리케이션 메소드(SAM)가 운영을 간소화하는 방법에 대한 실제 모범 사례를 배웁니다. 참고: 이 과정의 동영상에는 한국어 트랜스크립트 또는 자막이 지원되며 음성은 영어로 출력됩니다.자막을 표시하려면 동영상 화면 하단의 CC 버튼을 클릭하세요.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190518,1756271596,0,1,0,1758522880,NULL,0,1),(130,7,13215,'Build and Deploy APIs with a Serverless CI/CD (Português)','6HT12UE85X','','Criar um mecanismo de API, gerenciar um pipeline de CI/CD: historicamente, para alcançar essas metas de DevOps, foi preciso gerenciar várias instâncias com toda a sobrecarga operacional associada. Atul Bargaje e Rahul Sareen, arquitetos de AWS IoT, orientam você no processo de simplificação de seus processos de DevOps usando métodos sem servidor. Para começar, você entenderá como as APIs são gerenciadas atualmente com métodos tradicionais e, em seguida, conhecerá as melhores práticas do mundo real para simplificar suas operações usando métodos de aplicações sem servidor (SAM). Observação: Este curso tem transcrições/legendas traduzidas. A narração está em inglês.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'pt-BR','','',1756190518,1756271597,0,1,0,1758522880,NULL,0,1),(131,7,13214,'Build and Deploy APIs with a Serverless CI/CD (简体中文)','Q37CUENHUG','','构建 API 引擎，管理 CI/CD 管道：在历史上，要实现这些开发运维目标，就需要管理大量实例以及所有相关运营开销。AWS IoT 架构师 Atul Bargaje 和 Rahul Sareen 将引导您完成使用无服务器方法简化开发运维流程的过程。首先，您将了解目前如何使用传统方法管理 API，然后了解无服务器应用程序方法 (SAM) 如何简化操作的真实世界中的最佳实践。注意：本课程具有本地化的中文配音和注释/字幕。要显示字幕，请单击播放器右下角的 CC 按钮。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190519,1756271597,0,1,0,1758522880,NULL,0,1),(132,7,13213,'Building Secure Networks (한국어 강의)','X9HPXM7785','','이 과정은 기술 전문가용 AWS 커뮤니티인 AWS 기술 필드 커뮤니티(TFC) 회원이 개발했습니다. 콘텐츠는 표준 교육 커리큘럼을 보완하고 AWS 학습 여정을 확대하기 위한 것입니다. 이 과정에서는 AWS 계정에 안전한 동적 네트워크 인프라를 구축하는 방법에 대해 학습합니다.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190519,1756271597,0,1,0,1758522880,NULL,0,1),(133,7,13212,'Amazon Connect: Creating and Managing Amazon Connect Instances','XPNFM93V8Y','','This course is a part of the Amazon Connect curriculum. In this course, you will walk through how to create and manage an Amazon Connect instance that is customized to your contact center\'s needs. The course includes the various steps and features involved with the implementation process, which can help you adjust your existing Amazon Connect instance as your company grows. This course includes presentations, e-learning interactions, and knowledge checks.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190519,1756271597,0,1,0,1758522880,NULL,0,1),(134,7,13211,'Media & Entertainment: Direct-to-Consumer and Broadcast Foundations Knowledge Badge Assessment','E65EQVQQJH','','This assessment validates your comprehension of the Media & Entertainment: Direct-to-Consumer and Broadcast Foundations Knowledge Badge Readiness Path. The assessment questions are based on the courses in this learning path. Take all of the courses and then verify your knowledge. Already have some knowledge on Media & Entertainment: Direct-to-Consumer and Broadcast Foundations? Go directly to the assessment, test your knowledge. The score report will identify your areas of strength and direct you to the courses where you can improve any knowledge gaps. You can earn the Media & Entertainment: Direct-to-Consumer and Broadcast Foundations Knowledge badge with a score of 80% or better. Badges are issued by Credly within 5-7 business days. Don\'t worry if you didn\'t achieve 80% or better. You can re-take the assessment after a 24-hour wait period. Use your score report to identify the courses where you can improve any knowledge gaps, then take the assessment again. Use this assessment as a method to continue building your knowledge. Assessment questions are randomized on each attempt which allows you to get more questions.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190519,1756271597,0,1,0,1758522880,NULL,0,1),(135,7,13210,'Amazon DataZone Getting Started','R717WFP1V6','','In this course you will learn about the purpose and key capabilities of Amazon DataZone, including how it can help organizations better govern, share, and derive value from their data assets. The course will guide you through identifying the problems Amazon DataZone can solve, such as improving data visibility and enhancing cross-functional collaboration. Additionally, the course covers technical concepts, typical use cases for Amazon DataZone, and step-by-step processes for effectively using Amazon DataZone to enhance your organization\'s data management strategy.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190520,1756271598,0,1,0,1758522880,NULL,0,1),(136,7,13209,'Introduction to AWS Trusted Advisor','1VV6E4X2HE','','This course is an introduction to AWS Trusted Advisor, the AWS service that provides real-time guidance to help you provision your resources following AWS best practices. In this course, we will walk through a case study that highlights the usage of the service, and we give you a demonstration of the service.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190520,1756271598,0,1,0,1758522880,NULL,0,1),(137,7,13208,'Introduction to AWS Trusted Advisor (日本語吹き替え版)','N3W1396451','','これは、AWS Trusted Advisor の入門コースです。この AWS のサービスでは、AWS のベストプラクティスに従ってリソースをプロビジョニングするのに役立つリアルタイムのガイダンスが提供されます。このコースでは、サービスの使い方を中心に導入事例を紹介し、その後、デモンストレーションを行います。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190520,1756271598,0,1,0,1758522880,NULL,0,1),(138,7,13207,'Introduction to AWS Trusted Advisor (한국어)','79T32MTKDX','','이 과정에서는 AWS 모범 사례에 따라 리소스를 프로비저닝하는 데 도움이 되도록 실시간 지침을 제공하는 온라인 도구인 AWS Trusted Advisor를 소개합니다. 이 과정에서는 서비스 용도를 중시하는 사례 연구를 살펴보고 서비스에 대한 데모를 제공합니다. 참고: 이 과정의 동영상에는 한국어 트랜스크립트 또는 자막이 지원되며 음성도 한국어로 출력됩니다. 자막을 표시하려면 동영상 화면 우측 하단의 CC 버튼을 클릭하세요.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190520,1756271598,0,1,0,1758522880,NULL,0,1),(139,7,13206,'Introduction to AWS Trusted Advisor (简体中文)','PX1QX59NC1','','本课程介绍 AWS Trusted Advisor，这是一项为您提供实时指导以帮助您按照 AWS 最佳实践预置资源的 AWS 服务。在本课程中，我们会通过分析案例研究来着重介绍该服务的使用，还会为您进行相关演示。注意：本課程具有本地化的註釋/字幕。旁白保留英語。要顯示字幕，請按一下播放器右下角的 CC 按鈕。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190521,1756271598,0,1,0,1758522880,NULL,0,1),(140,7,13205,'Introduction to AWS Trusted Advisor (繁體中文)','HPXPWNC8Z1','','本課程將介紹 AWS Trusted Advisor，這項 AWS 服務可提供即時指引，協助使用者依據 AWS 最佳實務來佈建資源。在本課程中會逐步說明一項使用案例，展現服務的使用方式，再實際示範該服務。注意：本課程具有本地化的註釋/字幕。旁白保留英語。要顯示字幕，請按一下播放器右下角的 CC 按鈕。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-TW','','',1756190521,1756271599,0,1,0,1758522880,NULL,0,1),(141,7,13204,'Amazon Rekognition Getting Started','6G3YNAKN1G','','With Amazon Rekognition, you can analyze images and videos to detect and recognize objects, people, text, activities, and more. In this course, you will learn the benefits and technical concepts of Amazon Rekognition. If you are new to the service, you will learn how to start using Amazon Rekognition through a demonstration on the AWS Management Console. You will learn about integrating powerful image and video analysis capabilities into your applications without building complex machine learning (ML) models from scratch. You will also learn how to create an AWS Lambda function that uses the Amazon Rekognition API to detect labels in an image.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190521,1756271599,0,1,0,1758522880,NULL,0,1),(142,7,13203,'Domain 3 Review: AWS Certified Solutions Architect - Associate (SAA-C03 - English)','TKXSQ4NNZF','','In this course, you will review Domain 3: Design High-Performing Architectures of the AWS Certified Solutions Architect - Associate (SAA-C03) exam. Prepare for the exam by exploring these topics and how they align to AWS services and to specific areas of study. Review videos for each topic area of the domain, delivered by expert instructors.This course is part of 4 steps that you can use to prepare for your exam with confidence. To follow the 4 steps, enroll in the Exam Prep Plan: AWS Certified Solutions Architect - Associate (SAA-C03). Some of this content might require an AWS Skill Builder subscription.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190521,1756271599,0,1,0,1758522880,NULL,0,1),(143,7,13202,'Domain 3 Review: AWS Certified Solutions Architect - Associate (SAA-C03 - Español LATAM)','Y4SP9D3RPZ','','En este curso, revisará el dominio 3: diseñar arquitecturas de alto rendimiento del examen AWS Certified Solutions Architect - Associate (SAA-C03). Prepárese para el examen explorando estos temas y cómo se alinean con los servicios de AWS y con áreas de estudio específicas.Este curso forma parte de 4 pasos que puede utilizar para prepararse para el examen con confianza. Para seguir los 4 pasos, inscríbase en el Exam Prep Plan: AWS Certified Solutions Architect - Associate (SAA-C03).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-419','','',1756190522,1756271599,0,1,0,1758522880,NULL,0,1),(144,7,13201,'Domain 3 Review: AWS Certified Solutions Architect - Associate (SAA-C03 - Español de España)','N6GSNH3RS3','','En este curso, repasarás el dominio 3: diseñar arquitecturas de alto rendimiento del examen AWS Certified Solutions Architect - Associate (SAA-C03). Para prepararte para el examen, explora estos temas y descubre cómo se corresponden con los servicios de AWS y áreas de estudio específicas. Ve los vídeos de cada área temática del dominio realizados por instructores expertos.Este curso forma parte de los cuatro pasos que sirven para prepararte para el examen con confianza. Para seguir los cuatro pasos, matricúlate en el Exam Prep Plan: AWS Certified Solutions Architect - Associate (SAA-C03).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-ES','','',1756190522,1756271599,0,1,0,1758522880,NULL,0,1),(145,7,13200,'Domain 3 Review: AWS Certified Solutions Architect - Associate (SAA-C03 - Français)','GNBCCRCEYX','','Dans ce cours, vous passerez en revue le domaine 3: conception d\'architectures hautement performantes de l\'examen AWS Certified Solutions Architect - Associate (SAA-C03). Préparez-vous à l\'examen en explorant ces rubriques et la manière dont elles correspondent aux services AWS et à des domaines d\'études spécifiques.Ce cours fait partie des 4 étapes que vous pouvez suivre pour préparer votre examen en toute confiance. Pour suivre les 4 étapes, inscrivez-vous au Exam Prep Plan: AWS Certified Solutions Architect - Associate (SAA-C03).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'fr-FR','','',1756190522,1756271600,0,1,0,1758522880,NULL,0,1),(146,7,13199,'Domain 3 Review: AWS Certified Solutions Architect - Associate (SAA-C03 - Italiano)','S8DKZRHBYK','','In questo corso, rivedrai il dominio 3: Progettazione di architetture ad alte prestazioni dell\'esame AWS Certified Solutions Architect - Associate (SAA-C03). Preparati all\'esame esplorando questi argomenti e il modo in cui si allineano ai servizi AWS e a specifiche aree di studio.Questo corso fa parte di 4 passaggi che puoi utilizzare per prepararti all\'esame acquisendo la necessaria sicurezza. Per seguire i 4 passaggi, iscriviti al Exam Prep Plan: AWS Certified Solutions Architect - Associate (SAA-C03).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'it-IT','','',1756190522,1756271600,0,1,0,1758522880,NULL,0,1),(147,7,13198,'Domain 3 Review: AWS Certified Solutions Architect - Associate (SAA-C03 - 日本語)','2YCF5FYZYQ','','このコースでは、AWS Certified Solutions Architect - Associate (SAA-C03) 試験の第 3 分野: 高パフォーマンスなアーキテクチャの設計 を確認します。これらのトピックを確認し、AWS のサービスや特定の学習分野とそれらがどのように関連しているかを調べて、試験の準備をしましょう。このコースは、自信を持って試験の準備をするための 4 つのステップの一部です。この 4 つのステップを実行するには、Exam Prep Plan: AWS Certified Solutions Architect - Associate (SAA-C03).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190523,1756271600,0,1,0,1758522880,NULL,0,1),(148,7,13197,'Domain 3 Review: AWS Certified Solutions Architect - Associate (SAA-C03 - 한국어)','EGH3PWC88V','','이 과정에서는 AWS Certified Solutions Architect - Associate (SAA-C03) 시험의 3: 고성능 아키텍처 설계 도메인을 검토합니다. 이러한 주제를 살펴보고 해당 주제가 AWS 서비스 및 특정 학습 영역에 어떻게 일치하는지 알아보며 시험을 준비합니다.이 과정은 자신 있게 시험을 준비할 수 있도록 마련된 4단계 중 일부입니다. 4단계를 진행하려면 Exam Prep Plan: AWS Certified Solutions Architect - Associate (SAA-C03).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190523,1756271600,0,1,0,1758522880,NULL,0,1),(149,7,13196,'Domain 3 Review: AWS Certified Solutions Architect - Associate (SAA-C03 - Português)','D7EFTKQG8D','','Neste curso, você analisará o Domínio 3: Criação de arquiteturas de alto desempenho do exame AWS Certified Solutions Architect - Associate (SAA-C03). Prepare-se para o exame examinando esses tópicos e como eles se alinham aos serviços da AWS e a áreas específicas de estudo.Esse curso faz parte de quatro etapas que você pode usar para se preparar para o exame com confiança. Para seguir as quatro etapas, inscreva-se no Exam Prep Plan: AWS Certified Solutions Architect - Associate (SAA-C03). ',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'pt-BR','','',1756190523,1756271600,0,1,0,1758522880,NULL,0,1),(150,7,13195,'Domain 3 Review: AWS Certified Solutions Architect - Associate (SAA-C03 - 简体中文)','R336HA8T5H','','在本课程中，您将检阅 AWS Certified Solutions Architect - Associate (SAA-C03) 考试的领域 3: 设计高性能架构。通过探索这些主题，了解其与 AWS 服务和特定研究领域的关联，为考试做好准备。本课程是四步骤备考的一部分，您可以使用这些步骤自信地准备考试。若要遵循这四个步骤，请注册 Exam Prep Plan: AWS Certified Solutions Architect - Associate (SAA-C03)。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190523,1756271601,0,1,0,1758522880,NULL,0,1),(151,7,13194,'Domain 3 Review: AWS Certified Solutions Architect - Associate (SAA-C03 - 繁體中文)','E9EV5EZ1PC','','在本課程中，您將檢閱  3: 設計高效能架構 AWS Certified Solutions Architect - Associate (SAA-C03) 考試的領域。透過探索這些主題，了解其與 AWS 服務和特定研究領域的關聯，如此才能為考試做好準備。本課程是 4 個步驟的一部分，您可以使用這些步驟來放心準備考試。若要遵循這 4 個步驟，請註冊Exam Prep Plan: AWS Certified Solutions Architect - Associate (SAA-C03)。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-TW','','',1756190524,1756271601,0,1,0,1758522880,NULL,0,1),(152,7,13193,'AWS Cloud Essentials for Business Leaders - Telecommunications','GXWEMW22ZH','','In this course, you will learn the fundamental concepts of cloud computing and how a cloud strategy can help companies in the telecommunication (telecom) industry meet business objectives. It explores how Amazon Web Services (AWS) brings the most advanced and secure cloud services, the deepest collaborative business solution, and the fastest rate of innovation. With AWS, service providers can cloudify their business and create new revenue streams, differentiating and innovating at every stage of the customer journey. The course addresses concepts such as simplifying operations, accelerating growth through monetizing 5G, and delivering enterprise transformation while reimagining the customer experience. Course level: Fundamental. Duration: 120 minutes. This course includes reading text, interactive lessons, videos, and knowledge check questions.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190524,1756271601,0,1,0,1758522880,NULL,0,1),(153,7,13192,'AWS Mainframe Modernization - Using MicroFocus Managed Runtime Environment','GJ48M61NP6','','AWS Mainframe Modernization Replatform with Micro Focus is built for the cloud. It is a fully managed runtime for deploying migrated mainframe applications using Micro Focus Enterprise Server. In this course, you will learn how to build an AWS Replatform with Micro Focus environment using an AWS CloudFormation template, and then deploy and test an application. Course level: Intermediate. Duration: 60 minutes. This course includes presentations and demonstrations.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190524,1756271601,0,1,0,1758522880,NULL,0,1),(154,7,13191,'Advanced Testing Practices Using AWS DevOps Tools','A32U6G7NEQ','','This advanced course demonstrates how to integrate testing and security into continuous integration (CI), continuous delivery (CD), and continuous deployment (CD) pipelines. You will learn how to implement advanced testing practices in various phases of the application lifecycle to deliver application updates in a safer and more reliable manner. You will learn how to use AWS DevOps tools, such as AWS CodeCommit, AWS CodeBuild, AWS CodeDeploy, and AWS CodePipeline, to implement the advanced testing practices. You will also learn how to set up review mechanisms and perform static code analysis to identify issues earlier in the development. You will explore various types of testing, such as security, synthetic, and load testing, using AWS Lambda and Amazon CloudWatch.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190524,1756271602,0,1,0,1758522880,NULL,0,1),(155,7,13190,'Advanced Testing Practices Using AWS DevOps Tools (Español LATAM)','MAYXYM74WJ','','Este curso avanzado muestra cómo integrar las pruebas y la seguridad en canalizaciones de integración continua (CI), entrega continua (CD) e implementación continua (CD). Aprenderá a implementar prácticas de pruebas avanzadas en varias fases del ciclo de vida de las aplicaciones para ofrecer actualizaciones de las mismas de forma más segura y fiable. Aprenderá a utilizar las herramientas de DevOps de AWS, como AWS CodeCommit, AWS CodeBuild, AWS CodeDeploy y AWS CodePipeline, para implementar las prácticas de pruebas avanzadas. También aprenderá a configurar mecanismos de revisión y realizar análisis de código estático para identificar problemas en las primeras fases del desarrollo. Explorará varios tipos de pruebas, como pruebas de seguridad, sintéticas y de carga, utilizando AWS Lambda y Amazon CloudWatch. Nivel del curso: avanzado. Duración: 2,5 horas. Nota: Este curso tiene transcripciones o subtítulos localizados. La narración está en inglés. Para mostrar los subtítulos, haga clic en el botón CC en la esquina inferior derecha del reproductor. En el curso, se incluyen presentaciones de vídeo, demostraciones, enlaces a recursos y pruebas de conocimientos.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-419','','',1756190525,1756271602,0,1,0,1758522880,NULL,0,1),(156,7,13189,'Advanced Testing Practices Using AWS DevOps Tools (日本語)','2SE993E8X7','','このアドバンストコースでは、テストとセキュリティを継続的インテグレーション (CI)、継続的デリバリー (CD)、および継続的デプロイ (CD) パイプラインに統合する方法を説明します。アプリケーションの更新をより安全で信頼性の高い方法で提供するために、アプリケーションライフサイクルのさまざまな段階で高度な方法でテストを行う方法を学びます。高度な方法でテストを行うために、AWS CodeCommit、AWS CodeBuild、AWS CodeDeploy、AWS CodePipeline などの AWS DevOps ツールの使用方法を学習します。また、開発の初期段階で問題を特定するために、レビュー機能を設定する方法と静的コード分析を行う方法についても学習します。AWS Lambda と Amazon CloudWatch を使用して、セキュリティテスト、模擬テスト、ロードテストなどの各種テストについて説明します。コースレベルは上級で、所要時間は2時間30分です。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190525,1756271602,0,1,0,1758522880,NULL,0,1),(157,7,13188,'Amazon Braket Pre-assessment','WB2YXB3T5V','','This Amazon Braket pre-assessment allows you to determine your level of knowledge on core Amazon Braket concepts before you take courses in this Knowledge Badge Readiness Path. You can determine your knowledge, or identify any gaps that you might have. You can target those courses in this path to help you build that knowledge, taking the courses in any order.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190525,1756271602,0,1,0,1758522880,NULL,0,1),(158,7,13187,'AWS Skill Builder Learner Guide','JMJEXYJ4X7','','*This course was developed by members of AWS Technical Field Communities (TFC), an AWS community of technical experts. The content is intended to complement our standard training curriculum and augment your AWS learning journey. We are aware some courses have accessibility limitations and are working to address. If you require accommodation, please contact [AWS Training and Certification Customer Support](https://console.learning-cms.training.aws.dev/products/details/).*\n\nIn this guide, you will learn how to navigate AWS Skill Builder and use its features. Skill Builder contains hundreds of digital courses and interactive learning experiences, including many game-based learning options. This guide will help you navigate these resources.\n\n**Activities**\nThis course includes presentations and videos.\n\n**Course objectives**\n-	Navigate AWS Skill Builder\n-	The different types of training available in AWS Skill Builder\n\n**Intended audience**\nAll AWS Skill Builder users\n',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190525,1756271603,0,1,0,1758522880,NULL,0,1),(159,7,13186,'From Migration to Modernization: Discover, plan, and migrate a monolith to ECS and Fargate with the help of Application Discovery and no code changes (Deutsch)','4RZKJZDKNN','','Dieser Kurs bietet eine Methodik zum Erkennen, Planen und Migrieren eines Monolithen zu Amazon ECS und AWS Fargate mithilfe von AWS Application Discovery Service und ohne Codeänderungen.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'de-DE','','',1756190526,1756271603,0,1,0,1758522880,NULL,0,1),(160,7,13185,'Modernize a monolith to ECS and Fargate using Application Discovery','AQ37WHN3K1','','This course provides a methodology to discover, plan, and migrate a monolith to Amazon ECS and AWS Fargate with the help of AWS Application Discovery Service and no code changes.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190526,1756271603,0,1,0,1758522880,NULL,0,1),(161,7,13184,'Modernize a monolith to ECS and Fargate using Application Discovery (Español LATAM)','8KJ6PFPHTM','','Este producto se actualizó el 16 dic 2024. En este momento, tiene acceso tanto a la versión anterior como a la nueva. Puede elegir entre dos opciones: Opción 1: continuar con la versión anterior. Tiene hasta el 15 ene 2025 para completarlo. Si no lo completa antes de esta fecha, su progreso se restablecerá y tendrá que volver a empezar con la versión más reciente. Opción 2: iniciar la nueva versión. El progreso anterior se restablecerá. Tiene acceso a la última versión y dispondrá de más de 30 días para completarlo. Este curso proporciona una metodología para descubrir, planificar y migrar un monolito a Amazon ECS y AWS Fargate con la ayuda de AWS Application Discovery Service y sin cambios en el código.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-419','','',1756190526,1756271603,0,1,0,1758522880,NULL,0,1),(162,7,13183,'From Migration to Modernization: Discover, plan, and migrate a monolith to ECS and Fargate with the help of Application Discovery and no code changes (Français)','TDXN7ATNRZ','','Ce cours fournit une méthodologie pour découvrir, planifier et procéder à la migration d\'un monolithe vers Amazon ECS et AWS Fargate à l\'aide d\'AWS Application Discovery Service et sans modification du code.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'fr-FR','','',1756190526,1756271603,0,1,0,1758522880,NULL,0,1),(163,7,13182,'From Migration to Modernization: Discover, plan, and migrate a monolith to ECS and Fargate with the help of Application Discovery and no code changes (Bahasa Indonesia)','33T7TUFZBV','','Kursus ini menyediakan metodologi untuk menemukan, merencanakan, dan memigrasikan monolit ke Amazon ECS dan AWS Fargate dengan bantuan AWS Application Discovery Service dan tanpa ada perubahan kode.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'id-ID','','',1756190527,1756271604,0,1,0,1758522880,NULL,0,1),(164,7,13181,'From Migration to Modernization: Discover, plan, and migrate a monolith to ECS and Fargate with the help of Application Discovery and no code changes (Italiano)','3KH4MA4SVV','','Questo corso presenta la metodologia per scoprire, pianificare e migrare un monolite ad Amazon ECS e AWS Fargate con l\'aiuto di AWS Application Discovery Service e senza modifiche al codice.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'it-IT','','',1756190527,1756271604,0,1,0,1758522880,NULL,0,1),(165,7,13180,'From Migration to Modernization: Discover, plan, and migrate a monolith to ECS and Fargate with the help of Application Discovery and no code changes (日本語)','EBX4YTRH36','','この動画では、AWS Application Discovery Service を活用しながら、コードを変更せずにモノリスの検出や計画を行い、Amazon ECS および AWS Fargate に移行するための方法論について説明します。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190527,1756271604,0,1,0,1758522880,NULL,0,1),(166,7,13179,'From Migration to Modernization: Discover, plan, and migrate a monolith to ECS and Fargate with the help of Application Discovery and no code changes (한국어)','8G2JQWUU9P','','이 과정에서는 AWS Application Discovery Service를 통해 코드 변경 없이 모놀리스를 검색 및 계획하고 Amazon ECS 및 AWS Fargate로 마이그레이션하는 방법을 학습합니다. 참고: 이 과정의 동영상에는 한국어 트랜스크립트 또는 자막이 지원되며 음성도 한국어로 출력됩니다. 자막을 표시하려면 동영상 화면 우측 하단의 CC 버튼을 클릭하세요.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190527,1756271604,0,1,0,1758522880,NULL,0,1),(167,7,13178,'From Migration to Modernization: Discover, plan, and migrate a monolith to ECS and Fargate with the help of Application Discovery and no code changes (Português)','SRC55Q2GHW','','Este curso oferece uma metodologia para descobrir, planejar e migrar um monolito para o Amazon ECS e o AWS Fargate com a ajuda do AWS Application Discovery Service e sem a necessidade de alterar o código.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'pt-BR','','',1756190528,1756271605,0,1,0,1758522880,NULL,0,1),(168,7,13177,'From Migration to Modernization: Discover, plan, and migrate a monolith to ECS and Fargate with the help of Application Discovery and no code changes (简体中文)','UX3AAXDKSW','','本课程提供了一种方法，可在 AWS Application Discovery Service 的帮助下探索、规划并整体迁移到 Amazon ECS 和 AWS Fargate，而无需更改任何代码。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190528,1756271605,0,1,0,1758522880,NULL,0,1),(169,7,13176,'From Migration to Modernization: Discover, plan, and migrate a monolith to ECS and Fargate with the help of Application Discovery and no code changes (繁體中文)','46ZRGPB1US','','本課程提供了一種方法，可以在 AWS Application Discovery Service 的協助下探索和規劃巨型應用程式，並將其遷移至 Amazon ECS 和 AWS Fargate，而無須變更任何程式碼。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-TW','','',1756190528,1756271605,0,1,0,1758522880,NULL,0,1),(170,7,13175,'Domain 3 Review: AWS Certified AI Practitioner  (AIF-C01 - English)','RB2BVTHFPC','','In this course, you will review Domain 3: Applications of Foundation Models of the AWS Certified AI Practitioner (AIF-C01) exam. Prepare for the exam by exploring these topics and how they align to AWS services and to specific areas of study. Review videos for each topic area of the domain, delivered by expert instructors.This course is part of 4 steps that you can use to prepare for your exam with confidence. To follow the 4 steps, enroll in the Exam Prep Plan: AWS Certified AI Practitioner (AIF-C01). Some of this content might require an AWS Skill Builder subscription.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190528,1756271605,0,1,0,1758522880,NULL,0,1),(171,7,13174,'Domain 3 Review: AWS Certified AI Practitioner  (AIF-C01 - 日本語)','2K741ZFX6X','','このコースでは、AWS Certified AI Practitioner (AIF-C01) 試験の第 3 分野: 基盤モデルの応用 を確認します。これらのトピックを確認し、AWS のサービスや特定の学習分野とそれらがどのように関連しているかを調べて、試験の準備をしましょう。このコースは、自信を持って試験の準備をするための 4 つのステップの一部です。この 4 つのステップを実行するには、Exam Prep Plan: AWS Certified AI Practitioner (AIF-C01).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190529,1756271605,0,1,0,1758522880,NULL,0,1),(172,7,13173,'Domain 3 Review: AWS Certified AI Practitioner  (AIF-C01 - 한국어)','1QNKP4QKDV','','이 과정에서는 AWS Certified AI Practitioner (AIF-C01) 시험의 3: 파운데이션 모델의 적용 도메인을 검토합니다. 이러한 주제를 살펴보고 해당 주제가 AWS 서비스 및 특정 학습 영역에 어떻게 일치하는지 알아보며 시험을 준비합니다.이 과정은 자신 있게 시험을 준비할 수 있도록 마련된 4단계 중 일부입니다. 4단계를 진행하려면 Exam Prep Plan: AWS Certified AI Practitioner (AIF-C01).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190529,1756271606,0,1,0,1758522880,NULL,0,1),(173,7,13172,'Domain 3 Review: AWS Certified AI Practitioner  (AIF-C01 - Português)','ZBAJENRR1Q','','Neste curso, você analisará o Domínio 3: Aplicações de modelos de base do exame AWS Certified AI Practitioner (AIF-C01). Prepare-se para o exame examinando esses tópicos e como eles se alinham aos serviços da AWS e a áreas específicas de estudo.Esse curso faz parte de quatro etapas que você pode usar para se preparar para o exame com confiança. Para seguir as quatro etapas, inscreva-se no Exam Prep Plan: AWS Certified AI Practitioner (AIF-C01). ',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'pt-BR','','',1756190529,1756271606,0,1,0,1758522880,NULL,0,1),(174,7,13171,'Domain 3 Review: AWS Certified AI Practitioner  (AIF-C01 - 简体中文)','6T45BJJSGP','','在本课程中，您将检阅 AWS Certified AI Practitioner (AIF-C01) 考试的领域 3: 基础模型的应用。通过探索这些主题，了解其与 AWS 服务和特定研究领域的关联，为考试做好准备。本课程是四步骤备考的一部分，您可以使用这些步骤自信地准备考试。若要遵循这四个步骤，请注册 Exam Prep Plan: AWS Certified AI Practitioner (AIF-C01)。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190529,1756271606,0,1,0,1758522880,NULL,0,1),(175,7,13170,'Amazon Transcribe Getting Started','4SGMUYJC99','','Amazon Transcribe is a fully managed artificial intelligence (AI) service that helps you convert speech to text using automatic speech recognition (ASR) technology. In this Getting Started course, you will learn about the benefits, features, typical use cases, technical concepts, and costs of Amazon Transcribe. You will review an architecture for a transcription solution using Amazon Transcribe that you can further adapt to your use case. Through a guided tutorial consisting of narrated video, step-by-step instructions, and transcripts, you will also try real-time and batch transcription in your own Amazon Web Services (AWS) account. Course level: Fundamental Duration: 1.5 hours This course includes presentations, graphics, and a step-by-step tutorial to follow along.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190530,1756271606,0,1,0,1758522880,NULL,0,1),(176,7,13169,'Amazon Transcribe Getting Started (Español LATAM)','XB26CNGV9T','','Amazon Transcribe es un servicio de inteligencia artificial (IA) completamente administrado que ayuda a convertir voz en texto usando tecnología de reconocimiento de voz automático (ASR). En este curso introductorio, aprenderá sobre los beneficios, las funciones, los casos prácticos típicos, los conceptos técnicos y los costos de Amazon Transcribe. Revisará una arquitectura para una solución de búsqueda mediante Amazon Transcribe, la cual podrá adaptar a su caso práctico. A través de un tutorial guiado que consta de un video narrado, instrucciones paso a paso y una transcripción, podrá probar la transcripción en tiempo real y por lotes en su propia cuenta de Amazon Web Services (AWS). Nivel del curso: básico. Duración: 1,5 horas. Nota: Este curso tiene transcripciones o subtítulos localizados. La narración está en inglés. Para mostrar los subtítulos, haga clic en el botón CC en la esquina inferior derecha del reproductor. Este curso incluye presentaciones, gráficos y un tutorial paso a paso para seguirlo.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-419','','',1756190530,1756271606,0,1,0,1758522880,NULL,0,1),(177,7,13168,'Amazon Transcribe Getting Started (Español de España)','4G5Y46J58J','','Amazon Transcribe es un servicio de inteligencia artificial (IA) completamente administrado que te ayuda a convertir voz a texto usando la tecnología de reconocimiento automático de voz (ASR). En este curso de introducción, aprenderás los beneficios, funciones, casos prácticos típicos, conceptos técnicos y costes de Amazon Transcribe. Revisarás la arquitectura de una solución de transcripción mediante Amazon Transcribe que podrás adaptar a tu caso práctico. En un tutorial guiado que consta de un vídeo con narración, instrucciones paso a paso y una transcripción, también probarás la transcripción por lotes y en tiempo real en tu propia cuenta de Amazon Web Services (AWS). Este curso incluye presentaciones, gráficos y un tutorial paso a paso.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-ES','','',1756190530,1756271606,0,1,0,1758522880,NULL,0,1),(178,7,13167,'Amazon Transcribe Getting Started (Français)','C4T9SZ4EGD','','Amazon Transcribe est un service d\'intelligence artificielle (IA) entièrement géré qui vous aide à convertir la parole en texte à l\'aide de la technologie de la reconnaissance vocale automatique (ASR, Automatic Speech Recognition). Dans ce cours Guide de démarrage, vous allez découvrir les avantages, les fonctions, les cas d\'utilisation typiques, les concepts techniques et les coûts d\'Amazon Transcribe. Vous allez examiner une architecture pour une solution de transcription à l\'aide d\'Amazon Transcribe que vous pourrez ensuite adapter à votre cas d\'utilisation. Par le biais d\'un tutoriel guidé incluant une vidéo commentée, des instructions pas à pas et des transcriptions, vous testerez également la transcription en temps réel et par lots dans votre propre compte Amazon Web Services (AWS). Ce cours inclut des présentations, des graphiques et un tutoriel pas à pas à suivre.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'fr-FR','','',1756190531,1756271607,0,1,0,1758522880,NULL,0,1),(179,7,13166,'Amazon Transcribe Getting Started (Bahasa Indonesia)','TPBNZ7CFNG','','Amazon Transcribe adalah layanan kecerdasan buatan terkelola penuh yang membantu Anda mengubah percakapan ke teks menggunakan teknologi pengenalan suara otomatis (automatic speech recognition, ASR). Dalam kursus Getting Started ini, Anda akan mempelajari manfaat, fitur, kasus penggunaan umum, konsep teknis, dan biaya Amazon Transcribe. Anda akan meninjau arsitektur untuk solusi pencarian menggunakan Amazon Transcribe yang dapat Anda sesuaikan lebih jauh dengan kasus penggunaan Anda. Melalui tutorial panduan yang terdiri dari video bernarasi, instruksi langkah demi langkah, dan transkrip, Anda juga akan mencoba transkripsi batch dan real-time di akun Amazon Web Services (AWS) Anda. Kursus ini mencakup presentasi, grafik, dan tutorial langkah demi langkah untuk diikuti. Catatan: Kursus ini memiliki transkrip/subtitle lokal. Narasi disampaikan dalam bahasa Inggris. Untuk menampilkan subtitle, klik tombol CC di sudut kanan bawah pemutar.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'id-ID','','',1756190531,1756271607,0,1,0,1758522880,NULL,0,1),(180,7,13165,'Amazon Transcribe Getting Started (Italiano)','4BGVXB8XRG','','Amazon Transcribe è un servizio di intelligenza artificiale (AI) completamente gestito che ti aiuta a convertire il parlato in testo tramite la tecnologia del riconoscimento vocale automatico (automatic speech recognition, ASR). In questo corso della serie Come iniziare, scoprirai quali sono i vantaggi, le funzionalità, i casi d\'uso più frequenti, i concetti tecnici e i costi di Amazon Transcribe. Esaminerai l\'architettura per una soluzione di trascrizione mediante Amazon Transcribe, che puoi adattare ulteriormente al tuo caso d\'uso. Tramite un\'esercitazione guidata composta da un video narrato, istruzioni passo passo e trascrizioni, eseguirai anche una trascrizione in tempo reale e in batch nel tuo account Amazon Web Services (AWS). Questo corso comprende presentazioni, rappresentazioni grafiche e un tutorial con istruzioni dettagliate da seguire. Nota: questo corso fornisce trascrizioni/sottotitoli localizzati. La narrazione è in inglese. Per visualizzare i sottotitoli, fare clic sul pulsante CC nell\'angolo in basso a destra del lettore. Livello del corso: base. Durata: 1,5 ore.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'it-IT','','',1756190531,1756271607,0,1,0,1758522880,NULL,0,1),(181,7,13164,'Amazon Transcribe Getting Started (日本語吹き替え版)','N37QAJ3P73','','Amazon Transcribe は、音声をテキストに変換できるフルマネージドの人工知能 (AI) サービスで、自動音声認識技術 (ASR) を用いて音声をテキストに変換します。この Getting Started コースでは、Amazon Transcribe の利点、特徴、一般的なユースケース、技術的概念、コストについて学習します。また、各自のユースケースに十分に適応できるよう、Amazon Transcribe を使用したトランスクリプションソリューションのアーキテクチャについて確認します。ナレーション付き動画、ステップバイステップの手順、トランスクリプトで構成されるガイド付きチュートリアルを通じ、各自の Amazon Web Services (AWS) アカウントでリアルタイムのバッチトランスクリプションも体験します。このコースの中のビデオには日本語の字幕がついています。字幕を表示させるには、ビデオ画面下の [CC] アイコンをクリックしてください。コースレベル : 基礎、所要時間 : 1.5 時間。このコースには、プレゼンテーション、グラフィック、ステップバイステップのチュートリアルが含まれています。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190531,1756271607,0,1,0,1758522880,NULL,0,1),(182,7,13163,'Amazon Transcribe Getting Started (한국어)','3GT67MJESS','','Amazon Transcribe는 자동 음성 인식(ASR) 기술을 사용해 음성을 텍스트로 변환할 수 있는 완전관리형 인공 지능(AI) 서비스입니다. 이 Getting Started 과정에서는 Amazon Transcribe의 이점, 기능, 일반적인 사용 사례, 기술적 개념 및 비용을 학습합니다. Amazon Transcribe를 사용하는 트랜스크립션 솔루션의 아키텍처를 검토합니다. 사용 사례에 맞게 추가로 조정할 수 있습니다. 내레이션 동영상, 단계별 지침, 대본으로 구성된 가이드 자습서를 통해 자신의 Amazon Web Services(AWS) 계정으로 실시간 및 배치 트랜스크립션을 사용해 볼 수도 있습니다. 과정 수준: 기초, 소요 시간: 1시간 30분. 이 과정의 동영상에는 한국어 트랜스크립트 또는 자막이 지원되며 음성은 영어로 출력됩니다. 이 과정은 Google Chrome(최신 주요 버전 2개), Microsoft Edge(최신 주요 버전 2개), Safari(최신 주요 버전 2개)에 최적화되어 있습니다. 이 과정에는 프레젠테이션, 그래픽, 따라야 할 단계별 자습서가 포함되어 있습니다.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190532,1756271607,0,1,0,1758522880,NULL,0,1),(183,7,13162,'Amazon Transcribe Getting Started (Português)','KRYFJA46N4','','O Amazon Transcribe é um serviço de inteligência artificial (IA) totalmente gerenciado que ajuda você a converter fala em texto usando tecnologia de reconhecimento automático de fala (ASR). Neste curso de introdução, você aprenderá sobre os benefícios, recursos, casos de uso típicos, conceitos técnicos e custos do Amazon Transcribe. Você analisará uma arquitetura para uma solução de transcrição usando o Amazon Transcribe, que pode ser adaptada ao seu caso de uso. Por meio de um tutorial guiado que consiste em um vídeo narrado, instruções passo a passo e transcrição, você também testará transcrição em lote em tempo real em sua própria conta Amazon Web Services (AWS). Este curso inclui apresentações, gráficos e um tutorial passo a passo para acompanhar.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'pt-BR','','',1756190532,1756271608,0,1,0,1758522880,NULL,0,1),(184,7,13161,'Amazon Transcribe Getting Started (ไทย)','QWFKNDASY1','','Amazon Transcribe คือบริการปัญญาประดิษฐ์ (AI) ที่มีการจัดการเต็มรูปแบบที่จะช่วยคุณแปลงคำพูดเป็นข้อความโดยใช้เทคโนโลยีการรู้จำเสียงพูดอัตโนมัติ (ASR) ซึ่งในหลักสูตร Getting Started นี้ คุณจะได้เรียนรู้เกี่ยวกับข้อดี ฟีเจอร์ กรณีใช้งานทั่วไป แนวคิดทางเทคนิค และค่าใช้จ่ายของ Amazon Transcribe รวมทั้งจะได้ศึกษาสถาปัตยกรรมสำหรับโซลูชันการถอดเสียงโดยใช้ Amazon Transcribe ที่คุณสามารถปรับให้เข้ากับกรณีใช้งานของคุณเพิ่มเติมได้ อีกทั้งยังจะได้ลองถอดเสียงแบบเรียลไทม์และแบบแบทช์ในบัญชี Amazon Web Services (AWS) ของคุณเองผ่านบทแนะนำสอนการใช้งานที่ประกอบไปด้วยวิดีโอบรรยาย คำแนะนำทีละขั้นตอน และบทบรรยาย หลักสูตรนี้ประกอบด้วยการนำเสนอ กราฟิก และบทช่วยสอนทีละขั้นตอนที่สามารถปฏิบัติตามได้',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'th-TH','','',1756190532,1756271608,0,1,0,1758522880,NULL,0,1),(185,7,13160,'Amazon Transcribe Getting Started (Tiếng Việt)','WJDU18Y6T3','','Amazon Transcribe là dịch vụ trí tuệ nhân tạo (AI) được quản lý hoàn toàn, giúp bạn chuyển đổi giọng nói thành văn bản bằng công nghệ nhận dạng giọng nói tự động (ASR). Trong khóa học Getting Started này, bạn sẽ tìm hiểu về các lợi ích, tính năng, trường hợp sử dụng điển hình, khái niệm kỹ thuật và chi phí của Amazon Transcribe. Bạn sẽ xem xét kiến trúc của giải pháp ghi lời thoại sử dụng Amazon Transcribe để có thể điều chỉnh thêm cho phù hợp với trường hợp sử dụng của mình. Trong hướng dẫn kỹ càng bao gồm video có thuyết minh, hướng dẫn từng bước và bản ghi lời thoại này, bạn cũng sẽ dùng thử bản ghi lời thoại theo thời gian thực và theo lô trong tài khoản Amazon Web Services (AWS) của riêng mình. Khóa học này bao gồm các bài thuyết trình, đồ họa và hướng dẫn từng bước để bạn làm theo.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'vi-VN','','',1756190532,1756271608,0,1,0,1758522880,NULL,0,1),(186,7,13159,'Amazon Transcribe Getting Started (简体中文)','24S1Y8YDNW','','Amazon Transcribe 是一项完全托管式人工智能 (AI) 服务，可以帮助您使用自动语音识别 (ASR) 技术将语音转换为文本。在本入门课程中，您将了解 Amazon Transcribe 的优势、功能、典型使用案例、技术概念和成本。您将了解使用 Amazon Transcribe 的转录解决方案的架构，您可以根据您的使用案例进一步调整该架构。通过由解说视频、分步说明和转录文本组成的指导教程，您还将在自己的 Amazon Web Services (AWS) 账户中尝试实时转录和批量转录。注意：本课程具有本地化的注释/字幕。 旁白保留英语。要显示字幕，请单击播放器右下角的 CC 按钮。本课程包括演示文稿、图形和可以遵循的分步教程。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190533,1756271608,0,1,0,1758522880,NULL,0,1),(187,7,13158,'Amazon Transcribe Getting Started (繁體中文)','5MT5SSCABE','','Amazon Transcribe 是一項全受管人工智慧 (AI) 服務，可協助您使用自動語音辨識 (ASR) 技術將語音轉換為文字。在本「入門指南」課程中，您將學習 Amazon Transcribe 的優勢、功能、典型使用案例、技術概念及成本。您也會看到使用 Amazon Transcribe 建立的轉錄解決方案架構，並將其應用到您的使用案例。透過解說影片、逐步指引和文字稿等指南教學課程，您也將在自己的 Amazon Web Services (AWS) 帳戶中嘗試即時轉錄和批次轉錄。注意：本課程具有本地化的註釋/字幕。旁白保留英語。要顯示字幕，請按一下播放器右下角的 CC 按鈕。本節課程包含簡報、圖表與逐步教學供您遵循。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-TW','','',1756190533,1756271608,0,1,0,1758522880,NULL,0,1),(188,7,13157,'Monitor .NET applications using Amazon CloudWatch Application Signals','1WZ1NT16HJ','','*This course was developed by members of AWS Technical Field Communities (TFC), an AWS community of technical experts. The content is intended to complement our standard training curriculum and augment your AWS learning journey. We are aware some courses have accessibility limitations and are working to address. If you require accommodation, please contact [AWS Training and Certification Customer Support](https://console.learning-cms.training.aws.dev/products/details/).* \n\nThis intermediate-level Application Performance Monitoring (APM) course teaches builders how to monitor their .NET applications using Amazon CloudWatch Application Signals. You will learn to automatically instrument your applications with OpenTelemetry, visualize application health through service maps, create service level objectives (SLOs), and troubleshoot performance issues using correlated telemetry data. You will gain practical experience deploying and monitoring .NET microservices applications on Amazon EKS.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190533,1756271609,0,1,0,1758522880,NULL,0,1),(189,7,13156,'AWS Panorama - Building Edge Computer Vision (CV) Applications','YV72WRB64H','','AWS Panorama is a service that brings computer vision (CV) to your on-premises camera network. You install the AWS Panorama Appliance or another compatible device in your data center, register it with AWS Panorama, and deploy CV applications from the cloud. In this course, you will learn why AWS Panorama is useful for business and how to build edge applications powered by it. You will also walk through a typical application development workflow. Course level: Intermediate. Duration: 1 hour­­ 30 minutes. This course includes presentations, graphics, and a development workflow walk-through.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190534,1756271609,0,1,0,1758522880,NULL,0,1),(190,7,13155,'AWS Snowball Edge Logistics and Planning','Q5Z18Y6YBN','','Welcome to the AWS Snowball Edge Logistics and Planning course! This course consists of two courses or modules to help you gain a deeper understanding the processes of how to implement the AWS Snowball Edge service offering. AWS Snowball Edge Logistics and AWS Snowball Edge Job Planning. This course, you learn about the logistics for a Snowball Edge job and job planning. The logistics topics introduce you to AWS Snowball Edge availability, shipping practices, and pricing to help you understand the logistics and costs associated with a Snowball Edge job for planning purposes. You have the opportunity to apply logistics and practice information to use case scenarios. The job planning topics introduce you to access and network planning, planning large data transfer jobs, planning a proof of concept, and compute planning. Course Level: Advanced. Duration: 1 Hour 45 Minutes. This course includes interactive lessons, exercises, and knowledge check questions.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190534,1756271609,0,1,0,1758522880,NULL,0,1),(191,7,13154,'AWS Secrets Manager Getting Started','U1CPGYWQTK','','With AWS Secrets Manager, you can centrally manage and securely store sensitive information like passwords and API keys. This service helps you control access to your applications, services, and IT resources while automating the rotation of secrets throughout their lifecycle. In this course, you will learn the benefits and technical concepts of Secrets Manager. If you are new to the service, you will learn how to start using Secrets Manager through a demonstration using the AWS Management Console. You will learn about the service\'s architecture and its built-in features. These features help simplify secrets management, enhance security, and meet compliance requirements across your AWS and third-party resources.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190534,1756271609,0,1,0,1758522880,NULL,0,1),(192,7,13153,'AWS Secrets Manager Getting Started (Français)','BAWWJT52XT','','Avec AWS Secrets Manager, vous pouvez gérer de manière centralisée et stocker en toute sécurité des informations sensibles telles que les mots de passe et les clés d\'API. Ce service vous permet de contrôler l\'accès à vos applications, services et ressources informatiques tout en automatisant la rotation des secrets tout au long de leur cycle de vie. Dans ce cours, vous découvrirez les avantages et les concepts techniques de Secrets Manager. Si vous utilisez le service pour la première fois, vous apprendrez comment commencer à utiliser Secrets Manager grâce à une démonstration à l\'aide de l\'AWS Management Console. Vous découvrirez l\'architecture du service et ses fonctionnalités intégrées. Ces fonctionnalités permettent de simplifier la gestion des secrets, d\'améliorer la sécurité et de répondre aux exigences de conformité sur l\'ensemble de vos ressources AWS et tierces.\n',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'fr-FR','','',1756190534,1756271609,0,1,0,1758522880,NULL,0,1),(193,7,13152,'Building AWS Solutions: Scale-Out Computing on AWS','EMS54QJWYM','','In this course, you will learn about the benefits, architecture, deployment, and additional features of the Scale-Out Computing on AWS solution. This course includes presentations, demonstrations, videos, and an assessment.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190535,1756271610,0,1,0,1758522880,NULL,0,1),(194,7,13151,'Migrating from Elasticsearch to Amazon OpenSearch Service','RQKZBV6SV3','','This course presents the process you go through when performing a migration from Elasticsearch (1.5 to 7.10) to Amazon OpenSearch Service. This course also contains best practices for migration, whether your project has a few clusters or hundreds of thousands of clusters processing hundreds of trillions of requests per month. This course includes: a scenario, interactive content, and knowledge check questions.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190535,1756271610,0,1,0,1758522880,NULL,0,1),(195,7,13150,'Operationalize Generative AI Applications (FMOps/LLMOps)','437U37ZZMP','','*This course was developed by members of AWS Technical Field Communities (TFC), an AWS community of technical experts. The content is intended to complement our standard training curriculum and augment your AWS learning journey. We are aware some courses have accessibility limitations and are working to address. If you require accommodation, please contact [AWS Training and Certification Customer Support](https://console.learning-cms.training.aws.dev/products/details/).*\n\nThis course provides an overview of challenges in productionizing LLMs and a set of tools available to solve them. The course will provide an overview of the reference architecture for developing, deploying, and operationalizing LLMs, as well as expand on each stage of the process. This course includes presentations, real-world examples and case studies.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190535,1756271610,0,1,0,1758522880,NULL,0,1),(196,7,13149,'Operationalize Generative AI Applications (FMOps/LLMOps) (Español LATAM)','G7C8XBARBC','','Este curso fue desarrollado por miembros de las TFC (Technical Field Communities, Comunidades del campo técnico) de AWS, una comunidad de expertos técnicos de AWS. El contenido pretende complementar nuestro plan de estudios de formación estándar y mejorar su proceso de aprendizaje en AWS. En este curso se ofrece información general de los desafíos que conlleva la producción de los LLM y de un conjunto de herramientas disponibles para afrontarlos. En el curso se ofrecerá información general de la arquitectura de referencia para el desarrollo, la implementación y la operacionalización de los LLM, y se profundizará en cada etapa del proceso. Nivel del curso: intermedio. Duración: 90 minutos. Nota: Este curso tiene transcripciones o subtítulos localizados. La narración está en inglés. Para mostrar los subtítulos, haga clic en el botón CC en la esquina inferior derecha del reproductor. Este curso incluye presentaciones, ejemplos reales y estudios de casos.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-419','','',1756190535,1756271610,0,1,0,1758522880,NULL,0,1),(197,7,13148,'Operationalize Generative AI Applications (FMOps/LLMOps) (Bahasa Indonesia)','Z9EGPNSWYK','','Kursus ini dikembangkan oleh anggota AWS Technical Field Communities (TFC), komunitas pakar teknis AWS. Konten ini dimaksudkan untuk melengkapi kurikulum pelatihan standar kami dan menambah perjalanan pembelajaran AWS Anda. Kursus ini memberikan gambaran tentang tantangan dalam produksi LLM dan seperangkat alat yang tersedia untuk menyelesaikannya. Kursus ini akan memberikan gambaran tentang arsitektur referensi untuk mengembangkan, men-deploy, dan mengoperasionalkan LLM, serta memperluas pada setiap tahap proses. Catatan: Kursus ini memiliki transkrip/subtitle lokal. Narasi disampaikan dalam bahasa Inggris. Untuk menampilkan subtitle, klik tombol CC di sudut kanan bawah pemutar. Kursus ini mencakup presentasi, contoh dunia nyata dan studi kasus.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'id-ID','','',1756190536,1756271610,0,1,0,1758522880,NULL,0,1),(198,7,13147,'Operationalize Generative AI Applications (FMOps/LLMOps) (日本語)','CJTCM4S3G1','','このコースは、AWS Technical Field Communities (TFC) のメンバーによって開発されました。TFC は、AWS の技術エキスパートからなるコミュニティです。コースのコンテンツは、AWS の標準トレーニングカリキュラムを補完し、AWS に関する学習体験をさらに充実させることを目的としています。Amazon Comprehend は、テキストから価値あるインサイトやつながりを抽出するために使用できる自然言語処理 (NLP) サービスです。この「Getting Started」コースでは、Amazon Comprehend の利点、特徴、一般的なユースケース、技術的概念、コストについて学びます。また、Amazon Comprehend を使用したテキスト処理ソリューションのアーキテクチャを確認し、独自のユースケースに合わせて調整することができます。また、2 つのラボを活用して、コースで学んだことを実践することもできます。コースレベル: 基礎、所要時間: 1 時間 30 分。このコースには、プレゼンテーション、図、ステップバイステップのチュートリアルが用意されています。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190536,1756271611,0,1,0,1758522880,NULL,0,1),(199,7,13146,'Operationalize Generative AI Applications (FMOps/LLMOps) (한국어)','R9Q96PGHY1','','이 과정은 기술 전문가용 AWS 커뮤니티인 AWS 기술 필드 커뮤니티(TFC) 회원이 개발했습니다. 콘텐츠는 표준 교육 커리큘럼을 보완하고 AWS 학습 여정을 확대하기 위한 것입니다. 이 과정에서는 LLM을 프로덕션화할 때 직면하는 과제와 이를 해결하는 데 사용할 수 있는 일련의 도구에 대한 개요를 제공합니다. 이 과정에서는 LLM 개발, 배포, 운영을 위한 참조 아키텍처에 대한 개요를 제공하고 프로세스의 각 단계에 대해 자세히 설명합니다. 과정 수준: 중급, 소요 시간: 90분. 참고: 이 과정의 동영상에는 한국어 트랜스크립트 또는 자막이 지원되며 음성은 영어로 출력됩니다. 자막을 표시하려면 동영상 화면 우측 하단의 CC 버튼을 클릭하세요. 이 과정은 Google Chrome, Microsoft Edge, Safari의 최신 주요 버전 2개에 최적화되어 있습니다. 이 과정에는 프레젠테이션, 실제 예시 및 사례 연구가 포함되어 있습니다.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190536,1756271611,0,1,0,1758522880,NULL,0,1),(200,7,13145,'Operationalize Generative AI Applications (FMOps/LLMOps) (Português)','VXDCQ2GA4Y','','Este curso foi desenvolvido por membros da AWS Technical Field Communities (TFC), uma comunidade de especialistas técnicos da AWS. O conteúdo tem como objetivo complementar nosso currículo de treinamento padrão e ampliar sua jornada de aprendizado na AWS. Este curso fornece uma visão geral dos desafios na produção de LLMs e um conjunto de ferramentas disponíveis para resolvê-los. O curso fornecerá uma visão geral da arquitetura de referência para desenvolver, implantar e operacionalizar LLMs, além de expandir cada estágio do processo. Nível do curso: intermediário. Duração: 90 min. Observação: Este curso tem transcrições/legendas traduzidas. A narração está em inglês. Para exibir as legendas, clique no botão CC no canto inferior direito do player. Este curso inclui apresentações, exemplos reais e estudos de caso.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'pt-BR','','',1756190537,1756271611,0,1,0,1758522880,NULL,0,1),(201,7,13144,'Operationalize Generative AI Applications (FMOps/LLMOps) (简体中文)','V2EV51DCHY','','本课程由 AWS 技术专家社区 AWS 技术领域社区 (TFC) 的成员开发。课程内容是我们的标准培训课程的补充，可充实您的 AWS 学习之旅。本课程概述了生产 LLM 所面临的挑战以及一套可用于解决这些挑战的工具。该课程将概述开发、部署和实施 LLM 的参考架构，并展开介绍该过程的每个阶段。本课程包括演讲、真实示例和案例研究。课程级别：中级，时长：90 分钟。注意：本课程具有本地化的注释/字幕。 旁白保留英语。要显示字幕，请单击播放器右下角的 CC 按钮。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190537,1756271611,0,1,0,1758522880,NULL,0,1),(202,7,13143,'Amazon Simple Notification Service (Amazon SNS) - Troubleshooting','RYEZ1DFJJ1','','In this course, you will learn how to view configuration information, monitor processes, and gather diagnostic data about Amazon Simple Notification Service (Amazon SNS). You will also learn how to use this information to help troubleshoot common issues and provide effective support case details if you need to escalate an issue to Amazon Web Services (AWS) Support. This course includes presentations, troubleshooting scenarios, videos, and resources for problem determination.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190537,1756271611,0,1,0,1758522880,NULL,0,1),(203,7,13142,'AWS SimuLearn: Use AI Services with Amazon SageMaker','FQCRQT43XZ','','**Simulated business scenario**\n\n\nA global consulting firm processes over 10,000 multilingual client communications and documents daily with current manual processes costing $1.5M annually, showing a 15 percent error rate, and requiring 20+ full-time employees who take up to 48 hours per document. The company wants a comprehensive automated solution that reduces operational costs, improves accuracy, and decreases turnaround time while enhancing global client service delivery.\n\n\n**Overview**\n\n\nIn this AWS SimuLearn assignment, you review a real-world scenario, helping a fictional customer design a solution on AWS. \n\n\nAfter the design is completed, you build the proposed solution in a guided lab within a live AWS Management Console environment.\n\n\nYou gain hands-on experience working with AWS services, using the same tools technology professionals use to construct AWS solutions.\n\n\n**How it works**\n\n\nAWS SimuLearn is powered by generative AI to help develop your soft skills, such as communication and problem-solving, in life-like conversations with AI-generated customers. An AI quiz agent evaluates your conversation responses, and an AI helper agent, Dr. Newton, is available when you get stuck.\n\n\nAfter each solution-building conversation, you build and validate the solution in a live AWS Console environment.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190537,1756271612,0,1,0,1758522880,NULL,0,1),(204,7,13141,'AWS SimuLearn: Utilice los servicios de IA con Amazon SageMaker','MZUHRVKAHG','','*Actualmente, las conversaciones con la IA están disponibles solo en inglés.\n\n**Escenario empresarial simulado**\n\n\nUna consultora global procesa más de 10 000 comunicaciones y documentos multilingües con clientes a diario, y los procesos manuales actuales cuestan 1,5 millones de dólares al año, muestran una tasa de error del 15 % y requieren más de 20 empleados a tiempo completo que tardan hasta 48 horas por documento. La empresa quiere una solución automatizada integral que reduzca los costos operativos, mejore la precisión y reduzca el tiempo de respuesta, al tiempo que mejora la prestación global de servicios al cliente.\n\n\n**Descripción general**\n\nEn esta tarea de AWS SimuLearn, usted revisa un escenario del mundo real, ayudando a un cliente ficticio a diseñar una solución en AWS.\n\nDespués de completar el diseño, construya la solución propuesta en un laboratorio guiado dentro de un entorno AWS Management Console en vivo.\nObtenga experiencia práctica trabajando con servicios de AWS, utilizando las mismas herramientas que los profesionales de tecnología utilizan para construir soluciones AWS.\n\n\n**Cómo funciona**\n\nAWS SimuLearn está impulsado por IA generativa para ayudar a desarrollar sus habilidades blandas, como la comunicación y la resolución de problemas, en conversaciones realistas con clientes generados por IA. Un agente de prueba de IA evalúa sus respuestas en la conversación, y un agente auxiliar de IA, Dr. Newton, está disponible cuando se queda atascado.\n\nDespués de cada conversación de construcción de solución, construya y valide la solución en un entorno AWS Console en vivo.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-419','','',1756190538,1756271612,0,1,0,1758522880,NULL,0,1),(205,7,13140,'AWS SimuLearn: Utilisez les services d\'IA avec Amazon SageMaker','Z2YVJ87QST','','*Actuellement, les conversations avec l\'IA ne sont disponibles qu\'en anglais.\n\n**Scénario simulé**\n\n\nUne société de conseil mondiale traite plus de 10 000 communications et documents clients multilingues par jour avec des processus manuels actuels coûtant 1,5 million de dollars par an, affichant un taux d\'erreur de 15 pour cent, et nécessitant plus de 20 employés à temps plein qui prennent jusqu\'à 48 heures par document. L\'entreprise souhaite une solution automatisée complète qui réduit les coûts opérationnels, améliore la précision et diminue le délai de traitement tout en améliorant la prestation de services aux clients mondiaux.\n\n\n**Aperçu**\n\nDans cet exercice AWS SimuLearn, vous examinez un scénario réel en aidant un client fictif à concevoir une solution sur AWS.\n\nUne fois la conception terminée, vous construisez la solution proposée dans un laboratoire guidé au sein d\'un environnement AWS Management Console en direct.\n\nVous acquérez une expérience pratique en travaillant avec les services AWS, en utilisant les mêmes outils que les professionnels de la technologie utilisent pour construire des solutions AWS.\n\n**Fonctionnement**\n\nAWS SimuLearn est alimenté par l\'IA générative pour vous aider à développer vos compétences générales, telles que la communication et la résolution de problèmes, dans des conversations réalistes avec des clients générés par l\'IA. Un agent de quiz IA évalue vos réponses de conversation, et un agent assistant IA, Dr. Newton, est disponible lorsque vous êtes bloqué.\n\nAprès chaque conversation de construction de solution, vous construisez et validez la solution dans un environnement AWS Console en direct.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'fr-FR','','',1756190538,1756271612,0,1,0,1758522880,NULL,0,1),(206,7,13139,'AWS SimuLearn: Amazon SageMaker で AI サービスを利用する','2GMGFA2B8B','','*現在、AI との対話は英語のみとなっております。\n\n**ビジネスシナリオ**\n\n\nグローバルコンサルティング企業は、現在手動プロセスで年間150万ドルのコストがかかり、15 パーセントのエラー率を示し、20 人以上のフルタイム従業員が1ドキュメントあたり最大 48 時間かかる 10,000 件以上の多言語クライアントコミュニケーションとドキュメントを毎日処理しています。同社は、運用コストを削減し、精度を向上させ、処理時間を短縮しつつ、グローバルなクライアントサービス提供を強化する包括的な自動化ソリューションを望んでいます。\n\n\n**概要**\n\n\nこの AWS SimuLearn の課題では、実際のシナリオを確認し、架空の顧客が AWS 上でソリューションを設計するのを支援します。\n\n\n設計が完了したら、実際の AWS マネジメントコンソール環境内のガイド付きラボで提案されたソリューションを構築します。\n\n\nAWS サービスを使用して実践的な経験を積み、技術専門家が AWS ソリューションを構築するのと同じツールを使用します。\n\n\n**仕組み**\n\n\nAWS SimuLearn は、生成 AI を活用して、AI 生成の顧客とのリアルな会話を通じて、コミュニケーションや問題解決などのソフトスキルを開発するのに役立ちます。AI クイズエージェントが会話の応答を評価し、行き詰まった時には AI ヘルパーエージェントの Dr. Newton が利用可能です。\n\n\n各ソリューション構築の会話の後、実際の AWS マネジメントコンソール環境でソリューションを構築し、検証します。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190538,1756271612,0,1,0,1758522880,NULL,0,1),(207,7,13138,'AWS SimuLearn: Amazon SageMaker에서 AI 서비스 사용','3CR287P6AU','','*현재 AI와의 대화는 영어로만 가능합니다.\n\n**비즈니스 시나리오**\n\n\n글로벌 컨설팅 회사는 현재 수동 프로세스로 매일 10,000건 이상의 다국어 고객 커뮤니케이션과 문서를 처리하고 있으며, 연간 150만 달러의 비용이 발생하고 15%의 오류율을 보이며, 문서당 최대 48시간이 소요되는 20명 이상의 상근 직원이 필요합니다. 회사는 운영 비용을 절감하고 정확성을 개선하며 처리 시간을 단축하면서 글로벌 고객 서비스 제공을 향상시키는 포괄적인 자동화 솔루션을 원합니다.\n\n\n**개요**\n\n이 AWS SimuLearn 과제에서는 실제 시나리오를 검토하고 가상의 고객이 AWS에서 솔루션을 설계하는 것을 지원합니다.\n\n설계가 완료되면 실제 AWS Management Console 환경의 안내형 실습에서 제안된 솔루션을 구축합니다.\n\nAWS 서비스를 사용하여 실무 경험을 쌓고 기술 전문가가 AWS 솔루션을 구축할 때 사용하는 것과 동일한 도구를 사용합니다.\n\n**작동 방식**\n\nAWS SimuLearn은 생성형 AI를 기반으로 하여 AI로 생성된 고객들과의 실제와 같은 대화를 통해 의사소통과 문제 해결과 같은 소프트 스킬을 개발하도록 도와줍니다. AI 퀴즈 에이전트가 대화 응답을 평가하며, 막힐 때는 AI 도우미 에이전트인 Dr. Newton의 도움을 받을 수 있습니다.\n\n각 솔루션 구축 대화 후, 실제 AWS Management Console 환경에서 솔루션을 구축하고 검증합니다.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190539,1756271612,0,1,0,1758522880,NULL,0,1),(208,7,13137,'AWS SimuLearn: 基于 Amazon SageMaker 的人工智能服务','UDG24SNT6H','','*目前与 AI 的对话仅支持英语。\n**业务场景**\n\n\n一家全球咨询公司每天处理 10,000 多份多语言客户沟通文件，目前的人工处理流程每年花费 150 万美元，错误率为 15%，需要 20 多名全职员工，每份文档处理时间长达 48 小时。该公司希望有一个全面的自动化解决方案，以降低运营成本，提高准确性，缩短周转时间，同时提升全球客户服务交付质量。\n\n\n**概述**\n\n\n在这个 AWS SimuLearn 任务中，您将审查真实场景并协助虚拟客户在 AWS 上设计解决方案。\n\n完成设计后，您将在真实的 AWS 管理控制台环境中，通过引导式实验，构建您所建议的解决方案。\n\n使用 AWS 服务获得实践经验，并使用与技术专家构建 AWS 解决方案时使用到的相同工具。\n\n\n**运作方式**\n\nAWS SimuLearn 由生成式 AI 驱动，通过与 AI 生成的客户进行逼真对话，帮助您培养沟通和解决问题等软技能。AI 测评代理会评估您的对话响应，当您遇到困难时，还可以求助于 AI 助手代理\"\"Newton 博士\"\"。\n\n在每次构建解决方案的对话之后，您都可以在实际的 AWS 控制台环境中构建和验证解决方案。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190539,1756271613,0,1,0,1758522880,NULL,0,1),(209,7,13136,'Introduction to Amazon API Gateway','K51ZBCKRSK','','Amazon API Gateway is a fully managed service that makes it easy for you to create, publish, maintain, monitor, and secure APIs at any scale. This course will introduce you to this service and walk you through several use cases and important features offered with Amazon API Gateway. The course will also include a demonstration of how to define a resource and methods on that resource, and how to deploy the resource to an Amazon API Gateway stage.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190539,1756271613,0,1,0,1758522880,NULL,0,1),(210,7,13135,'AWS Security Champion Badge Assessment','G8PN86ZGNS','','This assessment validates your comprehension of the Amazon Security Champion Knowledge Badge Readiness Path. The assessment questions are based on the courses in this learning path. Take all of the courses and then verify your knowledge. Already have some knowledge on the courses in this ‘AWS Security Champion Knowledge Badge Readiness Path’? Go directly to the assessment, test your knowledge. The score report will identify your areas of strength and direct you to the courses where you can improve any knowledge gaps. You can earn the Amazon Security Champion Knowledge badge with a score of 80% or better. Badges are issued by Credly within 5-7 business days. Don\'t worry if you didn\'t achieve 80% or better. You can re-take the assessment after a 24-hour wait period. Use your score report to identify the courses where you can improve any knowledge gaps, then take the assessment again. Use this assessment as a method to continue building your knowledge. Assessment questions are randomized on each attempt which allows you to get more questions.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190539,1756271613,0,1,0,1758522880,NULL,0,1),(211,7,13134,'Amazon Security Lake Getting Started','6P34BCUR4K','','With Amazon Security Lake, you can automatically centralize security data from various sources into a purpose-built data lake in your account. These sources include Amazon Web Services (AWS) and software as a service (SaaS) providers, on premises, and cloud sources. In this course, you will learn the benefits and technical concepts of Amazon Security Lake. If you are new to the service, you will learn how to start with Security Lake through a demonstration using the AWS Management Console. You will learn about the standard architecture and how the built-in features can help you streamline Security Lake. This course includes presentations, demonstrations, videos, and assessments.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190540,1756271613,0,1,0,1758522880,NULL,0,1),(212,7,13133,'AWS Storage Gateway Deep Dive: Tape Gateway (Deutsch)','2CZFDQRNP7','','Willkommen beim Kurs \"AWS Storage Gateway Deep Dive: Tape Gateway\"! Tape Gateway ermöglicht die Umstellung von physischen On-Premises-Bandlaufwerken auf virtuelle Bandlaufwerke in AWS, ohne Backup-Workflows zu ändern. In diesem Kurs lernst du, wie du mit Tape Gateway On-Premises-Backup-Anwendungen mit Cloud-Speicher verbindest. Du vertiefst dein Wissen und untersuchst, wie Tape-Gateway-Bereitstellungen geplant, geschützt, verwaltet, überwacht und optimiert werden. Dieser Kurs beinhaltet interaktive Lektionen, Demonstrationen und Wissenschecks in Form von Fragen.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'de-DE','','',1756190540,1756271613,0,1,0,1758522880,NULL,0,1),(213,7,13132,'AWS Storage Gateway Deep Dive: Tape Gateway','BR25YH9GY8','','Tape Gateway replaces using physical tapes on premises with virtual tapes in AWS without you needing to change your existing backup workflows. In this course, you learn to connect your on-premises backup applications to cloud storage using Tape Gateway. You dive deep to examine how to plan, secure, manage, monitor, and optimize Tape Gateway deployments.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190540,1756271614,0,1,0,1758522880,NULL,0,1),(214,7,13131,'AWS Storage Gateway Deep Dive: Tape Gateway (Español LATAM)','1NH3RSUERJ','','¡Le damos la bienvenida al curso AWS Storage Gateway Deep Dive: Tape Gateway! Tape Gateway Reemplaza el uso de cintas físicas en las instalaciones por cintas virtuales en AWS sin necesidad de modificar los flujos de trabajo de los respaldos existentes. En este curso, aprenderá a conectar sus aplicaciones de respaldo en las instalaciones con el almacenamiento en la nube con Tape Gateway. Profundizará para examinar cómo planificar, proteger, administrar, supervisar y optimizar las implementaciones de Tape Gateway. Nivel del curso: avanzado. Duración: 75 minutos. Nota: Este curso tiene transcripciones o subtítulos localizados. La narración está en inglés. Para mostrar los subtítulos, haga clic en el botón CC en la esquina inferior derecha del reproductor. En este curso se incluyen lecciones interactivas, demostraciones y preguntas de pruebas de conocimientos.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-419','','',1756190541,1756271614,0,1,0,1758522880,NULL,0,1),(215,7,13130,'AWS Storage Gateway Deep Dive: Tape Gateway (Español de España)','QHK66351FD','','Te damos la bienvenida al curso Inmersión en AWS Storage Gateway: Tape Gateway. Tape Gateway sustituye el uso de cintas físicas en las instalaciones por cintas virtuales en AWS sin que tengas que cambiar tus actuales flujos de trabajo de copia de seguridad. En este curso, aprenderás a conectar tus aplicaciones de copia de seguridad en las instalaciones con el almacenamiento en la nube mediante Tape Gateway. Profundizaremos en este tema para examinar cómo planificar, proteger, administrar, supervisar y optimizar las implementaciones de Tape Gateway. Este curso incluye lecciones interactivas, demostraciones y preguntas de la prueba de conocimientos.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'es-ES','','',1756190541,1756271614,0,1,0,1758522880,NULL,0,1),(216,7,13129,'AWS Storage Gateway Deep Dive: Tape Gateway (Français)','CKCME7D78A','','Tape Gateway remplace les bandes physiques sur site par des bandes virtuelles sur AWS sans avoir à modifier les flux de travail de sauvegarde existants. Dans ce cours, vous apprendrez à connecter vos applications de sauvegarde sur site au stockage dans le cloud à l\'aide de Tape Gateway. Vous découvrirez également comment planifier, sécuriser, gérer, surveiller et optimiser les déploiements Tape Gateway. Niveau du cours : Advanced. Durée : 75 minutes. Remarque : ce cours comporte des transcriptions ou des sous-titres localisés. La narration est en anglais. Pour afficher les sous-titres, cliquez sur le bouton CC dans le coin inférieur droit du joueur. Ce cours comprend des leçons interactives, des démonstrations et des questions de contrôle des connaissances.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'fr-FR','','',1756190541,1756271614,0,1,0,1758522880,NULL,0,1),(217,7,13128,'AWS Storage Gateway Deep Dive: Tape Gateway (Bahasa Indonesia)','N5NFXXHRX4','','Tape Gateway menggantikan penggunaan kaset fisik on-premises dengan kaset virtual di AWS tanpa perlu mengubah alur kerja pencadangan yang ada. Dalam kursus ini, Anda akan mempelajari cara menghubungkan aplikasi pencadangan on-premises dengan penyimpanan cloud menggunakan Tape Gateway. Anda akan mendalami materi ini untuk mempelajari cara merencanakan, mengamankan, mengelola, memantau, dan mengoptimalkan pen-deploy-an Tape Gateway. Kursus digital ini mencakup presentasi, video, dan penilaian. Kursus ini mencakup pelajaran interaktif, demonstrasi, dan pertanyaan dalam tes pengetahuan.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'id-ID','','',1756190541,1756271614,0,1,0,1758522880,NULL,0,1),(218,7,13127,'AWS Storage Gateway Deep Dive: Tape Gateway (Italiano)','G92UND2DNQ','','Ti diamo il benvenuto al corso AWS Storage Gateway Deep Dive: Tape Gateway. Tape Gateway ti permette di sostituire l\'uso di nastri fisici on-premises con nastri virtuali in AWS senza dover modificare i flussi di lavoro di backup esistenti. In questo corso apprenderai a connettere le applicazioni di backup on-premises all\'archiviazione nel cloud usando Tape Gateway. Esaminerai in dettaglio come pianificare, proteggere, gestire, monitorare e ottimizzare le implementazioni di Tape Gateway. Questo corso include lezioni interattive, dimostrazioni e domande per la verifica delle conoscenze. Livello del corso: avanzato. Durata: 75 minuti. Nota: questo corso fornisce trascrizioni/sottotitoli localizzati. La narrazione è in inglese. Per visualizzare i sottotitoli, fare clic sul pulsante CC nell\'angolo in basso a destra del lettore.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'it-IT','','',1756190542,1756271614,0,1,0,1758522880,NULL,0,1),(219,7,13126,'AWS Storage Gateway Deep Dive: Tape Gateway (日本語)','ZSVVAGC2N2','','AWS Storage Gateway Deep Dive: Tape Gateway コースにようこそ。 Tape Gateway を使用すると、既存のバックアップワークフローを変更することなく、オンプレミスの物理テープの代替として AWS の仮想テープに置き換えることができます。このコースでは、Tape Gateway を使ってオンプレミスのバックアップアプリケーションをクラウドストレージに接続する方法について学習します。Tape Gateway デプロイを計画、セキュリティ保護、管理、モニタリング、最適化する方法について詳しく確認していきましょう。このコースの中のビデオには日本語の字幕がついています。字幕を表示させるには、ビデオ画面下の [CC] アイコンをクリックしてください。コースレベル: アドバンスト。演習時間: 75 分。このコースには、対話型レッスン、デモンストレーション、ナレッジチェック質問が含まれます。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190542,1756271615,0,1,0,1758522880,NULL,0,1),(220,7,13125,'AWS Storage Gateway Deep Dive: Tape Gateway (한국어)','B4XNDWQFMB','','AWS Storage Gateway Deep Dive: Tape Gateway 과정에 오신 것을 환영합니다. Tape Gateway를 사용하면 기존 백업 워크플로를 변경할 필요 없이 온프레미스의 물리적 테이프를 AWS에서 가상 테이프로 대체할 수 있습니다. 본 과정에서는 Tape Gateway를 사용하여 온프레미스 백업 애플리케이션을 클라우드 스토리지에 연결하는 방법을 다루며 Tape Gateway 배포를 계획, 보호, 관리, 모니터링, 최적화하는 방법을 자세히 살펴봅니다. 대화형 강의, 데모 및 이해도 확인을 위한 문제가 포함되어 있습니다. 참고: 이 과정의 동영상에는 한국어 트랜스크립트 또는 자막이 지원되며 음성은 영어로 출력됩니다. 자막을 표시하려면 동영상 화면 우측 하단의 CC 버튼을 클릭하세요. 참고: 이 과정은 Google Chrome(최신 주요 버전 2개), Microsoft Edge(최신 주요 버전 2개), Safari(최신 주요 버전 2개)에 최적화되어 있습니다.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190542,1756271615,0,1,0,1758522880,NULL,0,1),(221,7,13124,'AWS Storage Gateway Deep Dive: Tape Gateway (Português)','8QP112N9JB','','Boas-vindas! Este é o curso AWS Storage Gateway Deep Dive: Tape Gateway. O Tape Gateway substitui o uso de fitas físicas on-premises por fitas virtuais na AWS sem a necessidade de alterar os fluxos de trabalho de backup existentes. Neste curso, você aprenderá a conectar seus aplicativos de backup on-premises ao armazenamento na nuvem com o uso do Tape Gateway. Você examinará como planejar, proteger, gerenciar, monitorar e otimizar as implantações do Tape Gateway. Nível do curso: avançado. Duração: 75 minutos. Observação: Este curso tem transcrições/legendas traduzidas. A narração está em inglês. Para exibir as legendas, clique no botão CC no canto inferior direito do player. Este curso inclui lições interativas, demonstrações e testes de conhecimento.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'pt-BR','','',1756190543,1756271615,0,1,0,1758522880,NULL,0,1),(222,7,13123,'AWS Storage Gateway Deep Dive: Tape Gateway (简体中文)','CU5RVKS2MT','','欢迎学习 AWS Storage Gateway Deep Dive: Tape Gateway 课程！ Tape Gateway 将本地部署的物理磁带替换为 AWS 中的虚拟磁带，您无需更改现有的备份工作流。在本课程中，您将了解如何使用 Tape Gateway 将本地备份应用程序连接到云存储。您深入了解如何规划、保护、管理、监控和优化 Tape Gateway 部署。注意：本课程具有本地化的注释/字幕。 旁白保留英语。要显示字幕，请单击播放器右下角的 CC 按钮。本课程包括互动课程、演示和专业知识考核问题。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190543,1756271615,0,1,0,1758522880,NULL,0,1),(223,7,13122,'AWS Storage Gateway Deep Dive: Tape Gateway (繁體中文)','4PY4W1S6KU','','歡迎參與 AWS Storage Gateway Deep Dive: Tape Gateway 課程！ Tape Gateway 可將內部部署的實體磁帶替換成 AWS 中的虛擬磁帶，無需變更現有的備份工作流程。在本課程中，您會學習使用 Tape Gateway 將內部部署備份應用程式連線至雲端儲存體。您會深入探討並檢查如何規劃、保護、管理、監控及最佳化 Tape Gateway 部署。本課程等級為進階，持續時間為 75 分鐘。注意：本課程具有本地化的註釋/字幕。旁白保留英語。要顯示字幕，請按一下播放器右下角的 CC 按鈕。本課程包括互動式單元課程、示範和知識檢測問題。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-TW','','',1756190543,1756271616,0,1,0,1758522880,NULL,0,1),(224,7,13121,'Official Practice Question Set: AWS Certified Data Engineer - Associate (DEA-C01 - English)','VX268Y5VBA','','The Official Practice Question Set: AWS Certified Data Engineer - Associate (DEA-C01) consists of 20 questions. This question set aligns with the DEA-C01 version of the exam and exam guide. If you are looking for an assessment that is the same length as the AWS Certification exam, enroll in the Official Pretest or Official Practice Exam in the Exam Prep Plan. Official Practice Question Sets feature 20 questions developed by AWS to demonstrate the style of Certification exam questions. Each question includes detailed feedback for answer choices, including recommended resources to deepen your understanding of key topics. You can take the question set multiple times. Each time will include the same questions in a different order. This course is part of 4 steps that you can use to prepare for your exam with confidence. To follow the 4 steps, enroll in the Exam Prep Plan: AWS Certified Data Engineer - Associate (DEA-C01). Some of this content might require an AWS Skill Builder subscription.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190543,1756271616,0,1,0,1758522880,NULL,0,1),(225,7,13120,'Official Practice Question Set: AWS Certified Data Engineer - Associate (DEA-C01 - 日本語)','NJ3V6DQJ6U','','Official Practice Question Set: AWS Certified Data Engineer - Associate (DEA-C01) には、20 問の問題が含まれています。この問題セットは、DEA-C01 バージョンの試験および試験ガイドに対応しています。AWS 認定試験と同じ問題数の評価方法をお探しの場合は、Exam Prep Plan の Official Pretest または Official Practice Exam に登録してください。Official Practice Question Set には、AWS が作成した、認定試験形式の 20 問の問題が含まれています。この問題セットを使って、試験形式の問題を理解しましょう。各問題には、主なトピックの理解を深めるための推奨リソースと共に、各問題の解答選択肢に関する詳細なフィードバックが含まれます。また、問題セットは複数回、使用できます。毎回、問題は同じですが、順序が異なります。このコースは、自信を持って試験の準備をするための 4 つのステップの一部です。この 4 つのステップを実行するには、Exam Prep Plan: AWS Certified Data Engineer - Associate (DEA-C01).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190544,1756271616,0,1,0,1758522880,NULL,0,1),(226,7,13119,'Official Practice Question Set: AWS Certified Data Engineer - Associate (DEA-C01 - 한국어)','5K47SXYCY1','','Official Practice Question Set: AWS Certified Data Engineer - Associate (DEA-C01) 은(는) 20문항으로 구성되어 있습니다. 이 문항 세트는 DEA-C01 버전의 시험 및 시험 안내서를 따릅니다. AWS Certification 시험과 동일한 분량의 평가를 찾고 있다면 시험 준비 플랜의 공식 사전 테스트 또는 공식 연습 시험에 등록하십시오. 공식 연습 문항 세트는 Certification 시험의 유형을 보여주는 AWS에서 개발한 20개의 문항이 포함되어 있습니다. 각 문항에는 주요 주제에 대한 이해를 높이기 위한 권장 리소스를 포함하여 답변 선택에 대한 자세한 피드백이 포함되어 있습니다. 문항 세트는 여러 번 응시할 수 있습니다. 응시할 때마다 같은 질문이 다른 순서로 출제됩니다. 이 과정은 자신 있게 시험을 준비할 수 있도록 마련된 4단계 중 일부입니다. 4단계를 진행하려면 Exam Prep Plan: AWS Certified Data Engineer - Associate (DEA-C01).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190544,1756271616,0,1,0,1758522880,NULL,0,1),(227,7,13118,'Official Practice Question Set: AWS Certified Data Engineer - Associate (DEA-C01 - 简体中文)','VXJZ2FP3VM','','Official Practice Question Set: AWS Certified Data Engineer - Associate (DEA-C01)包含 20 道题。此题集与 DEA-C01 版考试和考试指南相一致。如果您正在寻找与 AWS Certification 考试相同长度的评估方式，请报名参加备考计划中的官方预考或官方模拟考试。官方练习题集包含由 AWS 开发的 20 道题，可使用题集来理解考试样题。每道题都包含答案选项的详细反馈，其中包括推荐资源，帮助您加深对关键主题的理解。您还将收到一个分数，您可以多次采用问题集。每次都会按不同顺序显示相同问题。本课程是四步骤备考的一部分，您可以使用这些步骤自信地准备考试。若要遵循这四个步骤，请注册 Exam Prep Plan: AWS Certified Data Engineer - Associate (DEA-C01)。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190544,1756271616,0,1,0,1758522880,NULL,0,1),(228,7,13117,'Amazon EC2 Getting Started','9XXKVZU682','','In this course, you will learn the benefits and technical concepts of Amazon Elastic Compute Cloud (Amazon EC2). If you are new to the service, you will learn how to start using Amazon EC2 through a demonstration using the AWS Management Console. You will learn about how to provision and manage virtual servers in the cloud without investing in physical hardware.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190545,1756271617,0,1,0,1758522880,NULL,0,1),(229,7,13116,'Amazon EC2 Getting Started (Français)','TK838HFEW1','','Dans ce cours, vous découvrirez les avantages et les concepts techniques d\'Amazon Elastic Compute Cloud (Amazon EC2). Si vous utilisez ce service pour la première fois, vous apprendrez comment commencer à utiliser Amazon EC2 grâce à une démonstration à l\'aide de l\'AWS Management Console. Vous découvrirez comment provisionner et gérer des serveurs virtuels dans le cloud sans investir dans du matériel physique.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'fr-FR','','',1756190545,1756271617,0,1,0,1758522880,NULL,0,1),(230,7,13115,'Exam Prep Overview: AWS Certified Machine Learning - Specialty (MLS-C01 - English)','CWNTYMB71J','','In this course, you will review the scope of the AWS Certified Machine Learning - Specialty (MLS-C01) exam, including the intended audience and exam topics.This course is part of 4 steps that you can use to prepare for your exam with confidence. To follow the 4 steps, enroll in the Exam Prep Plan: AWS Certified Machine Learning - Specialty (MLS-C01).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190545,1756271617,0,1,0,1758522880,NULL,0,1),(231,7,13114,'Exam Prep Overview: AWS Certified Machine Learning - Specialty (MLS-C01 - 日本語)','MDDXH25UMT','','このコースでは、試験の対象者やトピックなど、AWS Certified Machine Learning - Specialty (MLS-C01) 試験の範囲を確認します。Exam Prep Plan には、試験形式の問題、各試験分野とタスクステートメントを確認するビデオ、練習問題、含まれています。この計画には、AWS の知識とスキルを磨くためのロールベースのトレーニングも含まれています。このコンテンツの一部では、AWS Skill Builder のサブスクリプションが必要である場合があります。このコースは、自信を持って試験の準備をするための 4 つのステップの一部です。この 4 つのステップを実行するには、Exam Prep Plan: AWS Certified Machine Learning - Specialty (MLS-C01). に登録してください。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ja-JP','','',1756190546,1756271617,0,1,0,1758522880,NULL,0,1),(232,7,13113,'Exam Prep Overview: AWS Certified Machine Learning - Specialty (MLS-C01 - 한국어)','913Q7BCSK7','','이 과정에서는 수강 대상 및 시험 주제를 비롯해 AWS Certified Machine Learning - Specialty (MLS-C01) 시험의 범위를 검토합니다.이 과정은 자신 있게 시험을 준비할 수 있도록 마련된 4단계 중 일부입니다. 4단계를 진행하려면 AWS Certified Machine Learning - Specialty (MLS-C01). 에 등록합니다. 시험 준비 플랜에는 시험 유형 문항, 각 시험 도메인과 작업 설명을 검토하는 동영상,등이 포함됩니다.  이 플랜에는 AWS 지식과 기술을 새롭게 업데이트하기 위한 역할 기반 교육도 포함되어 있습니다. 이 콘텐츠 중 일부에 액세스하려면 AWS Skill Builder 구독이 필요할 수 있습니다. 이 과정은 자신 있게 시험을 준비할 수 있도록 마련된 4단계 중 일부입니다. 4단계를 진행하려면 Exam Prep Plan: AWS Certified Machine Learning - Specialty (MLS-C01).',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'ko-KR','','',1756190546,1756271617,0,1,0,1758522880,NULL,0,1),(233,7,13112,'Exam Prep Overview: AWS Certified Machine Learning - Specialty (MLS-C01 - 简体中文)','Q6U8RTF9WU','','在本课程中，您将了解 AWS Certified Machine Learning - Specialty (MLS-C01) 考试的范围，包括考察对象和考试主题。本课程是四步骤备考的一部分，您可以使用这些步骤自信地准备考试。若要遵循这四个步骤，请注册 Exam Prep Plan: AWS Certified Machine Learning - Specialty (MLS-C01)。备考计划，包含考试样题、检阅每个考试领域和任务表述的视频、模拟考试评估、等。该计划还包括基于角色的培训，帮助您温习 AWS 知识和技能。其中部分内容可能需要 AWS Skill Builder 订阅。',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'zh-CN','','',1756190546,1756271618,0,1,0,1758522880,NULL,0,1),(234,7,13111,'Amazon Connect: Implementing Chat in Connect','BY6E9DTUYA','','This is a course within the Amazon Connect curriculum. We introduce you to how you can use Amazon Connect Chat to communicate with customers. We explore how Amazon Connect Chat aligns with your organizational needs and integrates with AWS services to manage the chat experience. This course includes presentations, e-learning interactions, video, and knowledge checks.',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0,0,'en-US','','',1756190546,1756271618,0,1,0,1758522880,NULL,0,1),(235,7,13110,'Introduction to Information Retrieval with Amazon Q','G1D2BNCRJW','','This course has been created with the help of Amazon Q business expert. This course would provide a helpful overview of how Amazon Q can search for and summarize information to answer users\' questions in a safe, faithful, helpful and responsible manner. The focus would be on finding and presenting factual information from reliable sources to address users\' informational needs. Amazon Q aims to have thoughtful, nuanced discussions and looks forward to further conversations. Course level: Fundamental, Duration: 25 minutes',0,'topics',1,5,1756190400,1787812800,0,0,0,0,1,1,1,NULL,0,0