<?php
// /local/learningpath/create.php
require_once(__DIR__ . '/../../config.php');
require_login();
global $DB, $PAGE, $OUTPUT, $USER, $CFG;

$context = context_system::instance();
require_capability('moodle/site:config', $context);

// ---------- UNIQUE NAME AJAX CHECK (ADD HERE) ----------
if (optional_param('ajax', 0, PARAM_BOOL)) {
    require_sesskey();
    $name = required_param('name', PARAM_TEXT);

    $exists = $DB->record_exists('learning_paths', ['name' => $name]);

    echo json_encode(['exists' => $exists]);
    exit;
}


$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/local/learningpath/create.php'));
$PAGE->set_title('Create Learning Path');
$PAGE->set_heading('Create Learning Path');

// Fetch course categories
$categories = $DB->get_records('course_categories', null, 'name ASC');

echo $OUTPUT->header();
?>

<!-- CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/css/select2.min.css"/>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
<link rel="stylesheet" href="styles.css"/>

<div class="container-fluid">
  <div class="card shadow-sm p-4 mb-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h4 class="mb-0">Create Learning Path</h4>
      <a href="manage.php" class="btn btn-outline-secondary btn-sm">Back to list</a>
    </div>

    <form id="lpCreateForm" method="POST" action="update.php" enctype="multipart/form-data" novalidate>
      <input type="hidden" name="sesskey" value="<?= sesskey() ?>">
      <input type="hidden" name="id" value="0">
      <input type="hidden" name="structure_json" id="structure_json">

      <!-- Category -->
      <div class="mb-3">
        <label class="form-label"><strong>Category</strong></label>
        <select id="categorySelect" name="category_id" class="form-control" required>
          <option value="">Select Category</option>
          <?php foreach ($categories as $cat): ?>
            <option value="<?= $cat->id ?>"><?= format_string($cat->name) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <!-- Learning Path Details -->
      <div class="card bg-light p-3 mb-3">
        <h5>Learning Path Details</h5>

        <div class="mb-2">
          <label class="form-label">Name</label>
       <input type="text" name="name" id="lp_name" class="form-control" required>
<div id="lp_name_error" class="text-danger small d-none">
  Learning Path name already exists
</div>

        </div>

        <div class="mb-2">
          <label class="form-label">Type</label><br>
          <?php $types = ['Practice Test', 'Online Course', 'Lab', 'AWS Digital Course', 'Reading Material']; ?>
          <?php foreach ($types as $t): ?>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="checkbox" name="type[]" value="<?= $t ?>" id="type_<?= md5($t) ?>">
              <label class="form-check-label" for="type_<?= md5($t) ?>"><?= $t ?></label>
            </div>
          <?php endforeach; ?>
        </div>

        <div class="row g-2">
          <div class="col-md-6">
            <label class="form-label">Image</label>
            <input type="file" name="image" class="form-control">
          </div>
          <div class="col-md-6">
            <label class="form-label">Level</label>
            <select name="level" class="form-control">
              <option value="Beginner">Beginner</option>
              <option value="Intermediate">Intermediate</option>
              <option value="Advanced">Advanced</option>
            </select>
          </div>
        </div>
      </div>

      <!-- Sections -->
      <div class="card bg-light p-3 mb-3">
        <h5>Sections</h5>

        <div id="sectionsContainer">
          <div class="section-item p-3 mb-3" data-section-id="">
            <div class="d-flex justify-content-between align-items-center mb-2">
              <div>
                <i class="fa fa-bars drag-handle"></i>
                <strong contenteditable="true" class="section-title">Section 1</strong>
              </div>
              <div>
                <button type="button" class="btn btn-xs btn-outline-primary add-activity">+ Add Activity</button>
                <button type="button" class="btn btn-xs btn-outline-danger remove-section">×</button>
              </div>
            </div>
            <ul class="list-group course-list mb-2"></ul>
          </div>
        </div>

        <div class="mt-2">
          <button type="button" id="addSectionBtn" class="btn btn-primary">Add Heading</button>
          <div class="form-text mt-2">Use Add Activity to map courses from the selected category. Drag to reorder.</div>
        </div>
      </div>

      <!-- Status -->
      <div class="mb-3">
        <label class="form-label">Status</label>
        <select name="status" class="form-control">
          <option value="Publish">Publish</option>
          <option value="Unpublish">Unpublish</option>
        </select>
      </div>

      <div class="text-end">
        <button type="submit" class="btn btn-success"><i class="fa fa-save"></i> Create Learning Path</button>
      </div>
    </form>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="activityModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Add Activities (Courses)</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal">X</button>
      </div>

      <div class="modal-body">

        <!-- Language Filter -->
        <div class="mb-3">
          <label class="form-label"><strong>Filter by Language</strong></label>
          <select id="activityLanguageFilter" class="form-control">
            <option value="">All Languages</option>

            <?php
              $rawlangs = $DB->get_records_sql_menu("
                SELECT DISTINCT lang AS id, lang
                FROM {course}
                WHERE lang IS NOT NULL AND lang <> ''
                ORDER BY lang ASC
              ");

              $langnames = [
                'ar-SA'=>'Arabic (Saudi Arabia)','de-DE'=>'German (Germany)','en-US'=>'English (US)',
                'es-419'=>'Spanish (Latin America)','es-ES'=>'Spanish (Spain)','fr-FR'=>'French',
                'id-ID'=>'Indonesian','it-IT'=>'Italian','ja-JP'=>'Japanese','ko-KR'=>'Korean',
                'pt-BR'=>'Portuguese (Brazil)','zh-CN'=>'Chinese (Simplified)','zh-TW'=>'Chinese (Traditional)',
                'th-TH'=>'Thai','vi-VN'=>'Vietnamese','he-IL'=>'Hebrew','el-GR'=>'Greek','pl-PL'=>'Polish',
                'tr-TR'=>'Turkish','uk-UA'=>'Ukrainian'
              ];

              foreach ($rawlangs as $code => $v) {
                $label = $langnames[$code] ?? $code;
                echo "<option value='$code'>$label</option>";
              }
            ?>
          </select>
        </div>

        <label class="form-label">Search & select courses</label>
        <select id="activityCourseSelect" style="width:100%" multiple></select>
        <div class="form-text mt-2">Courses come from the selected category.</div>

      </div>

      <div class="modal-footer">
        <button id="activityCancel" type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button id="activityAddBtn" type="button" class="btn btn-primary">Add to section</button>
      </div>

    </div>
  </div>
</div>

<!-- JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.0/Sortable.min.js"></script>

<script>
window.lp_config = {
  sesskey: '<?= sesskey() ?>',
  ajaxCoursesUrl: '<?= (new moodle_url("/local/learningpath/get_courses.php"))->out(false) ?>',
  basepath: '<?= (new moodle_url("/local/learningpath/"))->out(false) ?>'
};
</script>

<script>
$(function () {

  // 🔹 Hide error immediately while typing
  $('#lp_name').on('input', function () {
    $('#lp_name_error').addClass('d-none');
  });

  // 🔹 Check uniqueness only when user leaves field
  $('#lp_name').on('blur', function () {
    let name = $(this).val().trim();
    if (!name) return;

    $.get(window.location.pathname, {
      ajax: 1,
      name: name,
      sesskey: '<?= sesskey() ?>'
    }, function (res) {
      if (res.exists) {
        $('#lp_name_error').removeClass('d-none');
      } else {
        $('#lp_name_error').addClass('d-none');
      }
    }, 'json');
  });

  // 🔹 Block submit if error exists
  $('#lpCreateForm').on('submit', function (e) {
    if (!$('#lp_name_error').hasClass('d-none')) {
      e.preventDefault();
      alert('Please use a unique Learning Path name.');
    }
  });

});
</script>



<script src="js/learningpath.js"></script>

<?php
echo $OUTPUT->footer();
