<?php
defined('MOODLE_INTERNAL') || die();

if ($hassiteconfig) {
    // Add new section in Site administration → Plugins → Local plugins
    $settings = new admin_settingpage('local_enrollmentmailer',
        get_string('pluginname', 'local_enrollmentmailer'));

    // Enrollment Mail enable
    $settings->add(new admin_setting_configcheckbox(
        'local_enrollmentmailer/enable_enrollment',
        get_string('enableenrollmentmail', 'local_enrollmentmailer'),
        '',
        1
    ));

    // Enrollment subject
    $settings->add(new admin_setting_configtext(
        'local_enrollmentmailer/enrollment_subject',
        get_string('enrollmentmailsubject', 'local_enrollmentmailer'),
        '',
        'Course Enrollment Notification'
    ));

    // Enrollment body
    $settings->add(new admin_setting_confightmleditor(
        'local_enrollmentmailer/enrollment_body',
        get_string('enrollmentmailbody', 'local_enrollmentmailer'),
        '',
        'Hello [[user_name]],<br>You are enrolled in [[enrollments]].'
    ));

    // Reminder enable
    $settings->add(new admin_setting_configcheckbox(
        'local_enrollmentmailer/enable_reminder',
        get_string('enableremindermail', 'local_enrollmentmailer'),
        '',
        0
    ));

    // Reminder subject
    $settings->add(new admin_setting_configtext(
        'local_enrollmentmailer/reminder_subject',
        get_string('remindermailsubject', 'local_enrollmentmailer'),
        '',
        'Course Reminder'
    ));

    // Reminder body
    $settings->add(new admin_setting_confightmleditor(
        'local_enrollmentmailer/reminder_body',
        get_string('remindermailbody', 'local_enrollmentmailer'),
        '',
        'Hello [[user_name]],<br>This is a reminder for [[enrollments]].'
    ));

    $ADMIN->add('localplugins', $settings);
}
