<?php
defined('MOODLE_INTERNAL') || die();

class local_enrollmentmailer_v2_observer {

    public static function user_enrolled_handler(\core\event\user_enrolment_created $event) {
        global $DB, $CFG;

        require_once($CFG->dirroot.'/user/lib.php');

        // Get enrolment record
        $ue = $event->get_record_snapshot('user_enrolments', $event->objectid);
        $user  = $DB->get_record('user',  ['id' => $ue->userid], '*', MUST_EXIST);
        $enrol = $DB->get_record('enrol', ['id' => $ue->enrolid], '*', MUST_EXIST);
        $course= $DB->get_record('course',['id' => $enrol->courseid], '*', MUST_EXIST);

        // --- Load subject/body from plugin settings ---
        $subject = get_config('local_enrollmentmailer', 'enrollment_subject');
        $body    = get_config('local_enrollmentmailer', 'enrollment_body');

        // Provide default text if settings are empty
        if (empty($subject)) {
            $subject = 'Course Enrollment Notification';
        }
        if (empty($body)) {
            $body = 'Hello [[user_name]],<br>You are enrolled in [[enrollments]].<br>Login: [[login_url]]';
        }

        // --- Replace placeholders ---
        $placeholders = [
            '[[user_name]]'   => fullname($user),
            '[[enrollments]]' => $course->fullname,
            '[[login_url]]'   => $CFG->wwwroot,
            '[[user_email]]'  => $user->email,
             '[[site_name]]'   => format_string($SITE->fullname),
    '[[site_url]]'    => $CFG->wwwroot
        ];
        $subject = str_replace(array_keys($placeholders), array_values($placeholders), $subject);
        $body    = str_replace(array_keys($placeholders), array_values($placeholders), $body);

        // Convert HTML to plain-text
        $messagetext = html_to_text($body);

        // // --- Send email ---
        // $result = email_to_user(
        //     $user,
        //     \core_user::get_support_user(),
        //     $subject,
        //     $messagetext,
        //     $body
        // );

        // if ($result) {
        //     debugging("✅ Enrollment email sent to {$user->email}", DEBUG_DEVELOPER);
        // } else {
        //     debugging("❌ Failed to send enrollment email to {$user->email}", DEBUG_DEVELOPER);
        // }

        return true;
    }
}
