<?php
defined('MOODLE_INTERNAL') || die();
require_once($CFG->libdir . '/formslib.php');

class cohort_edit_form extends moodleform {
    public function definition() {
        global $USER, $CFG, $COURSE, $DB;
        $mform = $this->_form;
        $editoroptions = $this->_customdata['editoroptions'];
        $data = $this->_customdata['data'];

        // Hidden fields
        $mform->addElement('hidden', 'contextid', $data->contextid);
        $mform->setType('contextid', PARAM_INT);
        $mform->addElement('hidden', 'id', $data->id);
        $mform->setType('id', PARAM_INT);

        // Cohort name
        $mform->addElement('text', 'name', get_string('name', 'cohort'), 'size="60"');
        $mform->setType('name', PARAM_TEXT);
        $mform->addRule('name', null, 'required', null, 'client');
        if (!empty($data->name)) $mform->setDefault('name', $data->name);

        $mform->addElement('text', 'batchid', 'Batch ID', 'size="40"');
        $mform->setType('batchid', PARAM_ALPHANUMEXT);
        $mform->addRule('batchid', null, 'required', null, 'client');
        if (!empty($data->batchid)) {
            $mform->setDefault('batchid', $data->batchid);
        }

        // Company dropdown (load from 'company' table)
        $companies = [];
        if ($DB->get_manager()->table_exists('company')) {
            $companies = $DB->get_records_menu('company', [], 'com_name ASC', 'id, com_name');
        }
        // Add a default empty option
        $companyoptions = array(0 => get_string('choose')) + (array)$companies;
        $mform->addElement('select', 'company_id', 'Company', $companyoptions);
        $mform->setType('company_id', PARAM_INT);

        // If editing, set default company. We support two fields: company_id (form) and company_id (DB column)
        $existingcompany = 0;
        if (!empty($user->company_id)) {
            $existingcompany = (int)$user->company_id;
        } else if (!empty($user->company_id)) {
            $existingcompany = (int)$user->company_id;
        }
        if ($existingcompany) {
            $mform->setDefault('company_id', $existingcompany);
        }

        // Make company required (if you want)
        $mform->addRule('company_id', get_string('required'), 'required', null, 'client');

        // Description
        /*$mform->addElement('editor', 'description_editor', get_string('description'), null, $editoroptions);
        if (!empty($data->description_editor)) $mform->setDefault('description_editor', $data->description_editor);*/

        // Start and End date
        $startdate = !empty($data->start_date) ? $data->start_date : '';
        $enddate = !empty($data->end_date) ? $data->end_date : '';
        $mform->addElement('html', '
        <div style="display:flex; gap:20px; margin-top:20px;">
            <div>
                <label for="startdate">Start Date</label><br>
                <input type="date" name="start_date" id="start_date" value="'.$startdate.'" style="padding:7px;width:200px;">
            </div>
            <div>
                <label for="enddate">End Date</label><br>
                <input type="date" name="end_date" id="end_date" value="'.$enddate.'" style="padding:7px;width:200px;">
            </div>
        </div>
        ');

        // Hidden field to store selected users
        $selectedusers = !empty($data->selectedusers) ? $data->selectedusers : '';
        $mform->addElement('hidden', 'selectedusers', $selectedusers);
        $mform->setType('selectedusers', PARAM_RAW);

        // Dual-list panel
        $dualhtml = <<<HTML
        <div class="dual-list" style="display:flex;gap:10px;margin-top:20px;">
            <div class="dual-panel all-users" style="flex:1;border:1px solid #ddd;padding:10px;">
                <div class="search"><input type="text" placeholder="Search User and add"></div>
                <div class="list">Loading users...</div>
            </div>
            <div class="dual-controls" style="display:flex;flex-direction:column;justify-content:center;gap:10px;">
                <button type="button" class="btn-move move-right">&gt;</button>
                <button type="button" class="btn-move move-left">&lt;</button>
            </div>
            <div class="dual-panel selected-users" style="flex:1;border:1px solid #ddd;padding:10px;">
                <div class="search"><input type="text" placeholder="Search User and remove"></div>
                <div class="list"></div>
            </div>
        </div>
HTML;
        $mform->addElement('html', $dualhtml);
        $mform->addElement('html', '<br>');
        // User selection mode
        $mform->addElement('select', 'userselectionmode', 'User Selection Mode', [
            'userslist'  => 'Users List',
            'bulkupload' => 'Bulk Upload'
        ]);
        $mform->setDefault('userselectionmode', 'userslist');

        // CSV upload
        $mform->addElement('filepicker', 'bulkfile', 'Upload Users CSV', null, ['accepted_types'=>['.csv']]);
        $mform->addHelpButton('bulkfile', 'uploaduserscsv', 'cohort');

        $this->add_action_buttons(true, get_string('savechanges'));
    }

    public function validation($data, $files) {
        $errors = parent::validation($data, $files);
        if (empty($data['name'])) $errors['name'] = get_string('required');
        if (!empty($data['start_date']) && !empty($data['end_date']) && $data['start_date'] > $data['end_date']) {
            $errors['end_date'] = 'End date cannot be before start date';
        }
        return $errors;
    }
}
