<?php
require_once(__DIR__ . '/../../config.php');
require_login();
global $DB, $OUTPUT, $PAGE;

$context = context_system::instance();
require_capability('moodle/site:config', $context);

$PAGE->set_url(new moodle_url('/local/learningpath/manage.php'));
$PAGE->set_context($context);
$PAGE->set_title('Learning Path Management');
$PAGE->set_heading('Learning Path Management');

// 🔍 Filters
$categoryid = optional_param('categoryid', 0, PARAM_INT);
$name = optional_param('name', '', PARAM_TEXT);

// Fetch categories
$categories = $DB->get_records_menu('course_categories', null, 'name ASC', 'id, name');

// Build query
$where = '1=1';
$params = [];
if ($categoryid) {
    $where .= ' AND categoryid = :cat';
    $params['cat'] = $categoryid;
}
if ($name) {
    $where .= ' AND name LIKE :nm';
    $params['nm'] = "%$name%";
}

$learningpaths = $DB->get_records_select('learning_paths', $where, $params, 'id DESC');

echo $OUTPUT->header();
?>

<div class="container-fluid mt-4">

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="fw-bold text-primary">List of Learning Paths</h3>
    <a href="create.php" class="btn btn-success">
      <i class="fa fa-plus"></i> Add New Learning Path
    </a>
  </div>

  <!-- Filters -->
  <form method="get" class="card shadow-sm border-0 mb-4 p-3">
    <div class="row g-3 align-items-end">
      <div class="col-md-4">
        <label class="form-label fw-semibold">Category</label>
        <select name="categoryid" class="form-select">
          <option value="">Please Select</option>
          <?php foreach ($categories as $id => $catname): ?>
            <option value="<?= $id ?>" <?= $categoryid == $id ? 'selected' : '' ?>>
              <?= format_string($catname) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-4">
        <label class="form-label fw-semibold">Name</label>
        <input type="text" name="name" class="form-control" value="<?= s($name) ?>" placeholder="Enter name">
      </div>

      <div class="col-md-4">
        <button type="submit" class="btn btn-primary">
          <i class="fa fa-search"></i> Search
        </button>
      </div>
    </div>
  </form>

  <!-- Table -->
  <div class="card shadow-sm border-0">
    <div class="table-responsive">
      <table class="table table-striped align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>S.No</th>
            <th>Name</th>
            <th>Category</th>
            <th>Level</th>
            <th>Status</th>
            <th>Created On</th>
            <th class="text-center">Action</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($learningpaths): 
            $i = 1;
            foreach ($learningpaths as $path): ?>
              <tr>
                <td><?= $i++ ?></td>
                <td><?= format_string($path->name) ?></td>
                <td><?= $categories[$path->categoryid] ?? '-' ?></td>
                <td><?= format_string($path->level) ?></td>
                <td><?= format_string($path->status) ?></td>
                <td><?= userdate($path->timecreated) ?></td>
                <td class="text-center">
                  <a href="edit.php?id=<?= $path->id ?>" class="btn btn-sm btn-warning me-1">
                    <i class="fa fa-pencil"></i>
                  </a>
                  <a href="view.php?id=<?= $path->id ?>" class="btn btn-sm btn-info me-1">
                    <i class="fa fa-eye"></i>
                  </a>
                  <button type="button" class="btn btn-sm btn-secondary moderation-btn" data-id="<?= $path->id ?>">
                    Course Moderation
                  </button>
                </td>
              </tr>
            <?php endforeach;
          else: ?>
            <tr><td colspan="7" class="text-center text-muted">No Learning Paths Found</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- Modal for Lab Points -->
<div class="modal fade" id="moderationModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content border-0 shadow-lg">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Learning Path Moderation</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <form method="post" action="moderation_update.php">
        <div class="modal-body">
          <input type="hidden" name="pathid" id="pathid">
          <div class="mb-3">
            <label class="form-label fw-semibold">Credit Point for LAB</label>
            <input type="number" name="lab_points" class="form-control" required min="1000" placeholder="1000 or more">
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success">Update</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
  document.querySelectorAll('.moderation-btn').forEach(btn => {
    btn.addEventListener('click', () => {
      document.getElementById('pathid').value = btn.dataset.id;
      new bootstrap.Modal(document.getElementById('moderationModal')).show();
    });
  });
});
</script>

<?php
echo $OUTPUT->footer();
