<?php
require_once(__DIR__ . '/../config.php');
require_login();

global $DB, $USER, $CFG;

// Set up page
$context = context_system::instance();
$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/course/waws_report.php'));
$PAGE->set_title('AWS Course Report');
$PAGE->set_heading('AWS Course Report');
$PAGE->set_pagelayout('report');

echo $OUTPUT->header();
echo $OUTPUT->heading('AWS Course Report');

// Check if current user is an admin/manager
$is_admin = has_capability('moodle/site:config', $context);

// Fetch courses based on role
if ($is_admin) {
    $courses = $DB->get_records_sql("
        SELECT id, fullname
        FROM {course}
        WHERE id <> 1
        ORDER BY fullname ASC
    ");
} else {
    $courses = $DB->get_records_sql("
        SELECT c.id, c.fullname
        FROM {course} c
        JOIN {enrol} e ON e.courseid = c.id
        JOIN {user_enrolments} ue ON ue.enrolid = e.id
        WHERE ue.userid = ?
        ORDER BY c.fullname ASC
    ", [$USER->id]);
}

echo '<div class="table-responsive">';
echo '<table id="courseReportTable" class="table table-striped table-bordered">';
echo '<thead>
        <tr>
            <th>S.No</th>
            <th>Course Name</th>
            <th>Enrollments</th>
            <th>Started</th>
            <th>In-Progress</th>
            <th>Completed</th>
        </tr>
      </thead>
      <tbody>';

if (!empty($courses)) {
    $count = 1;
    foreach ($courses as $course) {
        // Total active enrolments
        $enrolled = $DB->count_records_sql("
            SELECT COUNT(ue.id)
              FROM {user_enrolments} ue
              JOIN {enrol} e ON ue.enrolid = e.id
             WHERE e.courseid = ?
        ", [$course->id]);

        // Progress counts
        $started = $DB->count_records_sql("
            SELECT COUNT(lp.id)
              FROM {local_ltiprogress} lp
              JOIN {user} u ON u.id = lp.userid
              JOIN {user_enrolments} ue ON ue.userid = u.id
              JOIN {enrol} e ON e.id = ue.enrolid
             WHERE lp.ltiid = ?
               AND lp.activityprogress = ?
               AND e.courseid = ?
        ", [$course->id, 'Started', $course->id]);

        $inprogress = $DB->count_records_sql("
            SELECT COUNT(lp.id)
              FROM {local_ltiprogress} lp
              JOIN {user} u ON u.id = lp.userid
              JOIN {user_enrolments} ue ON ue.userid = u.id
              JOIN {enrol} e ON e.id = ue.enrolid
             WHERE lp.ltiid = ?
               AND lp.activityprogress = ?
               AND e.courseid = ?
        ", [$course->id, 'InProgress', $course->id]);

        $completed = $DB->count_records_sql("
            SELECT COUNT(lp.id)
              FROM {local_ltiprogress} lp
              JOIN {user} u ON u.id = lp.userid
              JOIN {user_enrolments} ue ON ue.userid = u.id
              JOIN {enrol} e ON e.id = ue.enrolid
             WHERE lp.ltiid = ?
               AND lp.activityprogress = ?
               AND e.courseid = ?
        ", [$course->id, 'Completed', $course->id]);

        echo '<tr>';
        echo '<td>' . $count++ . '</td>';
        $courseurl = new moodle_url('/local/custompage/enrollment_user_report.php', ['courseid' => $course->id]);
        echo '<td><a href="' . $courseurl . '">' . format_string($course->fullname) . '</a></td>';
        echo '<td>' . $enrolled . '</td>';
        echo '<td>' . $started . '</td>';
        echo '<td>' . $inprogress . '</td>';
        echo '<td>' . $completed . '</td>';
        echo '</tr>';
    }
} else {
    echo '<tr><td colspan="6" class="text-center">No courses found.</td></tr>';
}

echo '</tbody></table></div>';
?>

<!-- ✅ DataTables + Buttons Extension -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">

<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>

<!-- ✅ Buttons Scripts -->
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>

<script>
$(document).ready(function() {
    $('#courseReportTable').DataTable({
        responsive: true,
        pageLength: 10,
        order: [[1, 'asc']],
        dom: 'Bfrtip', // ✅ Enable buttons
        buttons: [
            {
                extend: 'excelHtml5',
                title: 'AWS_Course_Report',
                text: 'Download Excel'
            },
            {
                extend: 'pdfHtml5',
                title: 'AWS_Course_Report',
                text: ' Download PDF',
                orientation: 'landscape',
                pageSize: 'A4'
            }
        ],
        language: {
            search: 'Search Course:',
            lengthMenu: 'Show _MENU_ entries',
            info: 'Showing _START_ to _END_ of _TOTAL_ courses'
        }
    });
});
</script>

<?php
echo $OUTPUT->footer();
?>
