<?php
require_once(__DIR__ . '/../config.php');
require_login();
global $DB, $CFG, $OUTPUT;

echo $OUTPUT->header();
?>

<style>
/* Scoped only to .custom-add-user */
.custom-add-user .user-form-card {
    background: #fff;
    border-radius: 12px;
    padding: 30px;
    max-width: 700px;
    margin: 30px auto;
    box-shadow: 0 0 12px rgba(0, 0, 0, 0.05);
    font-family: 'Segoe UI', sans-serif;
}

.custom-add-user .nav-tabs .nav-link {
    border: none;
    color: #888;
    font-weight: 500;
}

.custom-add-user .nav-tabs .nav-link.active {
    color: #0066ff;
    border-bottom: 3px solid #0066ff;
    background: transparent;
}

.custom-add-user .form-control {
    border-radius: 6px;
    border: 1px solid #ddd;
    padding: 10px 15px;
    font-size: 14px;
}

.custom-add-user .role-box {
    border: 1px solid #ccc;
    border-radius: 8px;
    padding: 15px;
    margin-top: 15px;
}

.custom-add-user .btn-primary {
    background: #0066ff;
    border: none;
    border-radius: 6px;
    padding: 8px 20px;
}

.custom-add-user .btn-secondary {
    background: #eee;
    border: none;
    color: #444;
    border-radius: 6px;
    padding: 8px 20px;
}

.custom-add-user label {
    font-weight: 500;
    font-size: 14px;
    margin-top: 10px;
}

.custom-add-user input[type="checkbox"] {
    transform: scale(1.2);
    margin-right: 6px;
}
</style>

<div class="custom-add-user">
    <div class="user-form-card">
        <a href="#"><i class="fa fa-arrow-left"></i> Back to Users / Add User(s)</a>
        <h4 class="mt-3 mb-4">Add a New User</h4>

        <!-- Tabs -->
        <ul class="nav nav-tabs" id="userTabs" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="individual-tab" data-toggle="tab" href="#individual" role="tab">Individual User</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="bulk-tab" data-toggle="tab" href="#bulk" role="tab">Bulk Users Upload</a>
            </li>
        </ul>

        <!-- Tab Content -->
        <div class="tab-content mt-4" id="userTabsContent">
            <!-- Individual User Tab -->
            <div class="tab-pane fade show active" id="individual" role="tabpanel">
                <form method="post" action="#">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>First Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" placeholder="E.g. John" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Last Name</label>
                            <input type="text" class="form-control" placeholder="E.g. Smith">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Email Address <span class="text-danger">*</span></label>
                            <input type="email" class="form-control" placeholder="E.g. john@internia.com" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Phone</label>
                            <input type="text" class="form-control" placeholder="+91 240 240 2440">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Employee ID</label>
                            <input type="text" class="form-control">
                        </div>
                    </div>

                    <!-- Role Box -->
                    <div class="role-box">
                        <label>Assign Roles</label>
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <label><input type="checkbox"> Instructor</label><br>
                                <label><input type="checkbox" checked> User</label>
                            </div>
                            <div>
                                <strong>Select All</strong>
                            </div>
                        </div>
                    </div>

                    <!-- Buttons -->
                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">Add User</button>
                        <button type="button" class="btn btn-secondary">Cancel</button>
                    </div>
                </form>
            </div>

            <!-- Bulk Upload Tab -->
            <div class="tab-pane fade" id="bulk" role="tabpanel">
                <p>Bulk upload form here...</p>
            </div>
        </div>
    </div>
</div>

<?php
echo $OUTPUT->footer();
?>
