<?php
namespace local_quiztools\local;

defined('MOODLE_INTERNAL') || die();

require_once($GLOBALS['CFG']->dirroot . '/mod/quiz/locallib.php');
require_once($GLOBALS['CFG']->dirroot . '/question/editlib.php');

use external_api;
use external_function_parameters;
use external_multiple_structure;
use external_value;

class external extends external_api {

    public static function add_questions_parameters() {
        return new external_function_parameters([
            'cmid' => new external_value(PARAM_INT, 'Quiz CMID'),
            'questionids' => new external_multiple_structure(
                new external_value(PARAM_INT, 'Question ID')
            )
        ]);
    }

public static function add_questions($cmid, $questionids) {
    global $DB, $PAGE;

    self::validate_parameters(self::add_questions_parameters(), [
        'cmid' => $cmid,
        'questionids' => $questionids
    ]);

    // Load CM, quiz, course (SAME AS CORE)
    $cm     = get_coursemodule_from_id('quiz', $cmid, 0, false, MUST_EXIST);
    $quiz   = $DB->get_record('quiz', ['id' => $cm->instance], '*', MUST_EXIST);
    $course = $DB->get_record('course', ['id' => $quiz->course], '*', MUST_EXIST);

    require_login($course, false, $cm);
    $context = \context_module::instance($cmid);
    require_capability('mod/quiz:manage', $context);

    // 🔐 THIS WAS MISSING (CRITICAL)
    require_sesskey();

    // Mimic edit.php environment
    $PAGE->set_context($context);
    $PAGE->set_url('/mod/quiz/edit.php', ['cmid' => $cmid]);

    // Quiz structure
    $quizobj   = new \quiz($quiz, $cm, $course);
    $structure = $quizobj->get_structure();
    $structure->check_can_be_edited();

    // Correct page
    $addonpage = max(1, $structure->get_last_page_number());

    foreach ($questionids as $qid) {

        // Capability on question
        quiz_require_question_use($qid);

        // ✅ PROPER DUPLICATE CHECK (CORE-LIKE)
        $exists = $DB->record_exists_sql(
            "SELECT 1
               FROM {quiz_slots} qs
               JOIN {question_references} qr ON qr.itemid = qs.id
               JOIN {question_versions} qv ON qv.questionbankentryid = qr.questionbankentryid
              WHERE qs.quizid = ?
                AND qv.questionid = ?
                AND qv.status = 'ready'",
            [$quiz->id, $qid]
        );

        if ($exists) {
            continue; // same behaviour as default UI
        }

        // ✅ REAL ADD (slot is created here)
        quiz_add_quiz_question($qid, $quiz, $addonpage);
    }

    quiz_delete_previews($quiz);
    quiz_update_sumgrades($quiz);

    return true;
}


    public static function add_questions_returns() {
        return new external_value(PARAM_BOOL, 'Result');
    }
}
