<?php
require(__DIR__ . '/../../config.php');
require_once($CFG->dirroot . '/mod/quiz/locallib.php');
require_once($CFG->dirroot . '/question/editlib.php');

$cmid        = required_param('cmid', PARAM_INT);
$questionids = required_param_array('questionids', PARAM_INT);

$cm     = get_coursemodule_from_id('quiz', $cmid, 0, false, MUST_EXIST);
$quiz   = $DB->get_record('quiz', ['id' => $cm->instance], '*', MUST_EXIST);
$course = get_course($cm->course);

require_login($course, false, $cm);
require_sesskey();

$context = context_module::instance($cmid);
require_capability('mod/quiz:manage', $context);

// Quiz editable check
if (quiz_has_attempts($quiz->id)) {
    throw new moodle_exception('quizcannotbeedited', 'quiz');
}

// ❌ YAHAN KOI get_last_page_number() NAHI
// ❌ $structure ki zarurat bhi nahi

foreach ($questionids as $qid) {

    // Permission check
    quiz_require_question_use($qid);

    // ✅ YEHI LINE AAP POCHH RAHE THE
    quiz_add_quiz_question($qid, $quiz, 0);
}

quiz_update_sumgrades($quiz);
quiz_delete_previews($quiz);
redirect(new moodle_url('/local/custompage/assesment.php'));
