<?php
require_once('../../config.php');
require_login();

global $DB, $SESSION;

// Params
$redirect = required_param('redirect', PARAM_LOCALURL);
$courseid = required_param('courseid', PARAM_INT);
$sesskey  = required_param('sesskey', PARAM_RAW);

require_sesskey();

$context = context_course::instance($courseid);

// Only Manager/Teacher allowed
if (!has_capability('moodle/role:switchroles', $context)) {
    print_error('nopermissions', 'error', '', 'switch role');
}

// Get student role
$studentrole = $DB->get_record('role', ['shortname' => 'student'], '*', MUST_EXIST);

// Switch role
role_switch($studentrole->id, $context);

// Store flags
$SESSION->autoswitched = true;
$SESSION->switchedcourseid = $courseid;

// Redirect to quiz
redirect($redirect);
