<?php
require_once('../../config.php');
require_login();

global $DB, $USER, $CFG;

/* ✅ INCLUDE YOUR HELPER */
require_once($CFG->dirroot . '/local/learningpath/lib.php');
require_once($CFG->dirroot . '/mod/quiz/locallib.php');

/* ✅ PARAM */
$quizid = required_param('quizid', PARAM_INT);

/* ✅ GET QUIZ */
$quiz = $DB->get_record('quiz', ['id' => $quizid], '*', MUST_EXIST);

/* ✅ GLOBAL AUTO-ENROL (ONE COURSE FOR ALL QUIZZES) */
local_learningpath_auto_enrol_user(4815, $USER->id);

/* ✅ CREATE QUIZ OBJECT AFTER ENROL */
$quizobj = quiz::create($quizid, $USER->id);

/* ✅ REDIRECT TO QUIZ */
redirect($quizobj->start_attempt_url());
