<?php
require_once(__DIR__ . '/../../config.php');
require_login();
global $DB, $PAGE, $OUTPUT;

$context = context_system::instance();
require_capability('moodle/site:config', $context);

$PAGE->set_url(new moodle_url('/local/learningpath/progress.php'));
$PAGE->set_context($context);
$PAGE->set_title('Learning Path Progress (Admin)');
$PAGE->set_heading('Learning Path Progress (Admin)');

echo $OUTPUT->header();

$selectedpath = optional_param('pathid', 0, PARAM_INT);
if (!$selectedpath) {
    echo html_writer::div('No path selected.');
    echo $OUTPUT->footer();
    exit;
}

$courses = $DB->get_records('learning_path_courses', ['pathid' => $selectedpath]);
$totalcourses = count($courses);
if ($totalcourses == 0) {
    echo html_writer::div('No courses attached to this path.');
    echo $OUTPUT->footer();
    exit;
}

$enrols = $DB->get_records('learning_path_enrolments', ['pathid' => $selectedpath]);
if (!$enrols) {
    echo html_writer::div('No users enrolled in this path.');
    echo $OUTPUT->footer();
    exit;
}

echo '<table class="generaltable"><tr><th>User</th><th>Completed</th><th>Total</th><th>Progress</th></tr>';
foreach ($enrols as $e) {
    $userid = $e->userid;
    $user = $DB->get_record('user', ['id' => $userid], 'id, firstname, lastname');
    $courseids = array_map(function($c){ return isset($c->course_id) ? $c->course_id : (isset($c->courseid)?$c->courseid:0); }, $courses);
    list($insql, $params) = $DB->get_in_or_equal($courseids);
    $sql = "SELECT COUNT(*) FROM {course_completions} WHERE userid = ? AND course IN {$insql} AND status = 1";
    $params = array_merge([$userid], (array)$params);
    $completed = $DB->count_records_sql($sql, $params);
    $percent = round(($completed / $totalcourses) * 100, 2);
    echo '<tr><td>'.s($user->firstname.' '.$user->lastname).'</td><td>'.intval($completed).'</td><td>'.intval($totalcourses).'</td><td>'.intval($percent).'%</td></tr>';
}
echo '</table>';

echo $OUTPUT->footer();