<?php
require_once('../../config.php');
require_login();

global $DB, $PAGE, $OUTPUT;

$pathid = required_param('id', PARAM_INT);

$PAGE->set_url(new moodle_url('/local/learningpath/manage_detail.php', ['id' => $pathid]));
$PAGE->set_context(context_system::instance());
$PAGE->set_title('Learning Path Details');
$PAGE->set_heading('Learning Path Details');

echo $OUTPUT->header();

// ------------------------------------------------------
//  Fetch Learning Path Name
// ------------------------------------------------------
$learningpath = $DB->get_record('learning_paths', ['id' => $pathid], '*', MUST_EXIST);

// ------------------------------------------------------
//  Back Button
// ------------------------------------------------------
echo html_writer::start_div('mb-3');
echo html_writer::link(
    new moodle_url('/local/learningpath/manage.php'),
    $OUTPUT->pix_icon('t/left', 'Back') . ' Back',
    ['class' => 'btn btn-secondary']
);
echo html_writer::end_div();

// ------------------------------------------------------
//  Learning Path Name (Page Heading)
// ------------------------------------------------------
echo html_writer::tag('h2', format_string($learningpath->name), ['class' => 'mb-4']);


// -----------------
// 1) Fetch Courses
// -----------------
$courses = [];
try {
    $sql = "SELECT c.id, c.fullname
            FROM {learning_path_sections} s
            JOIN {learning_path_courses} lpc ON lpc.sectionid = s.id
            JOIN {course} c ON c.id = lpc.courseid
            WHERE s.learningpathid = :lpid
            ORDER BY s.position, lpc.sortorder ASC";
    $courses = $DB->get_records_sql($sql, ['lpid' => $pathid]);
} catch (Exception $e) {
    echo $OUTPUT->notification('Error fetching courses: ' . s($e->getMessage()), 'error');
}

// -----------------
// 2) Fetch Users
// -----------------
$users = [];
try {
    $sql = "SELECT u.id, u.firstname, u.lastname, u.email
            FROM {learning_path_enrolments} lpe
            JOIN {user} u ON u.id = lpe.userid
            WHERE lpe.learningpathid = :lpid
              AND lpe.userid IS NOT NULL
            ORDER BY u.lastname, u.firstname";
    $users = $DB->get_records_sql($sql, ['lpid' => $pathid]);
} catch (Exception $e) {
    echo $OUTPUT->notification('Error fetching users: ' . s($e->getMessage()), 'error');
}

// -----------------
// 3) Fetch Cohorts
// -----------------
$cohorts = [];
try {
    $sql = "SELECT ch.id, ch.name
            FROM {learning_path_enrolments} lpe
            JOIN {cohort} ch ON ch.id = lpe.cohortid
            WHERE lpe.learningpathid = :lpid
              AND lpe.cohortid IS NOT NULL
            ORDER BY ch.name";
    $cohorts = $DB->get_records_sql($sql, ['lpid' => $pathid]);
} catch (Exception $e) {
    echo $OUTPUT->notification('Error fetching cohorts: ' . s($e->getMessage()), 'error');
}

// -----------------
// Render Tables
// -----------------
function render_table_scrollable($title, $headers, $rows, $fieldnames) {
    echo html_writer::start_div('card mb-3 p-3');
    echo html_writer::tag('h4', $title);
    if (empty($rows)) {
        echo html_writer::tag('div', 'No data found.', ['class' => 'text-muted']);
        echo html_writer::end_div();
        return;
    }
    echo html_writer::start_tag('div', ['style'=>'overflow:auto; max-height:300px;']);
    echo html_writer::start_tag('table', ['class' => 'generaltable table-striped']);

    echo html_writer::start_tag('thead');
    echo html_writer::start_tag('tr');
    foreach ($headers as $h) {
        echo html_writer::tag('th', $h);
    }
    echo html_writer::end_tag('tr');
    echo html_writer::end_tag('thead');

    echo html_writer::start_tag('tbody');
    foreach ($rows as $r) {
        echo html_writer::start_tag('tr');
        foreach ($fieldnames as $f) {
            echo html_writer::tag('td', format_string($r->{$f}));
        }
        echo html_writer::end_tag('tr');
    }
    echo html_writer::end_tag('tbody');

    echo html_writer::end_tag('table');
    echo html_writer::end_tag('div');
    echo html_writer::end_div();
}

render_table_scrollable('Courses', ['Course Name'], $courses, ['fullname']);
render_table_scrollable('Users', ['First Name','Last Name','Email'], $users, ['firstname','lastname','email']);
render_table_scrollable('Batches', ['Batch Name'], $cohorts, ['name']);

echo $OUTPUT->footer();
