<?php
defined('MOODLE_INTERNAL') || die();

global $CFG; // ✅ REQUIRED

//require_once($CFG->dirroot . '/enrol/lib.php');
require_once($CFG->dirroot . '/lib/enrollib.php');

/**
 * Auto-enrol user into a course if not enrolled
 *
 * @param int $courseid
 * @param int $userid
 * @return bool
 */
function local_learningpath_auto_enrol_user(int $courseid, int $userid): bool {
    global $DB;

    $context = context_course::instance($courseid);

    // Already enrolled
    if (is_enrolled($context, $userid)) {
        return true;
    }

    // 1️⃣ Self enrolment
    $self = $DB->get_record('enrol', [
        'courseid' => $courseid,
        'enrol'    => 'self',
        'status'   => 0
    ]);

    if ($self) {
        $plugin = enrol_get_plugin('self');
        if ($plugin) {
            $plugin->enrol_user($self, $userid, 5); // student
            return true;
        }
    }

    // 2️⃣ Manual enrolment fallback
    $manual = $DB->get_record('enrol', [
        'courseid' => $courseid,
        'enrol'    => 'manual',
        'status'   => 0
    ]);

    if ($manual) {
        $plugin = enrol_get_plugin('manual');
        if ($plugin) {
            $plugin->enrol_user($manual, $userid, 5);
            return true;
        }
    }

    return false;
}

function local_learningpath_before_http_headers() {
    global $SESSION, $PAGE;

    if (empty($SESSION->autoswitched) || empty($SESSION->switchedcourseid)) {
        return;
    }

    $url = $PAGE->url->out(false);

    // ✅ Stay in student role for ALL quiz pages
    if (strpos($url, '/mod/quiz/') !== false || strpos($url, '/question/') !== false) {
        return;
    }

    // Restore role when leaving quiz
    $coursecontext = context_course::instance($SESSION->switchedcourseid);
    role_switch(0, $coursecontext);

    unset($SESSION->autoswitched);
    unset($SESSION->switchedcourseid);
}