console.log('Learning Path JS loaded ✅');

var currentSection = null;

$(document).ready(function () {

  console.log('Learning Path script initialized ✅');

  var $modal = $('#activityModal');
  var $courseSelect = $('#activityCourseSelect');
  var $categorySelect = $('#modalCategory');
  var $languageSelect = $('#activityLanguageFilter');

  /* =========================================================
     SECTION TYPE TEMPLATE
  ========================================================= */
  function getSectionTypeHtml(index) {
    return `
      <div class="mb-2 section-type-row">
        <strong>Section Type <span class="text-danger">*</span></strong><br>

        <label class="me-3">
          <input type="radio" class="section-type" name="section_type_${index}" value="aws">
          AWS Digital Course
        </label>

        <label class="me-3">
          <input type="radio" class="section-type" name="section_type_${index}" value="practice">
          Practice Test
        </label>

        <label class="me-3">
          <input type="radio" class="section-type" name="section_type_${index}" value="online">
          Online Course
        </label>

        <label class="me-3">
          <input type="radio" class="section-type" name="section_type_${index}" value="lab">
          Lab
        </label>

        <label class="me-3">
          <input type="radio" class="section-type" name="section_type_${index}" value="reading">
          Reading Material
        </label>
      </div>
    `;
  }

  /* =========================================================
     ADD NEW SECTION
  ========================================================= */
  $('#addSectionBtn').on('click', function () {

    var index = $('#sectionsContainer .section-item').length + 1;

    $('#sectionsContainer').append(`
      <div class="section-item p-3 mb-3 border">
        ${getSectionTypeHtml(index)}

        <div class="d-flex justify-content-between align-items-center mb-2">
          <strong contenteditable="true" class="section-title">
            Section ${index}
          </strong>
          <div>
            <button type="button" class="btn btn-xs btn-outline-primary add-activity">
              + Add Activity
            </button>
            <button type="button" class="btn btn-xs btn-outline-danger remove-section">
              ×
            </button>
          </div>
        </div>

        <ul class="list-group course-list"></ul>
      </div>
    `);
  });

  $(document).on('click', '.remove-section', function () {
    $(this).closest('.section-item').remove();
  });

  /* =========================================================
     INIT SELECT2 (ONCE)
  ========================================================= */
  function initSelect2() {
    if ($courseSelect.hasClass('select2-hidden-accessible')) {
      return;
    }

    $courseSelect.select2({
      placeholder: 'Search and select items...',
      width: '100%',
      multiple: true,
      dropdownParent: $modal
    });
  }

  /* =========================================================
     PRELOAD COURSES / QUIZZES (WORKING PATTERN)
  ========================================================= */
  function preloadItems(type) {

  var categoryId = $categorySelect.val();

  // ✅ NO ALERT — just don't load yet
  if (!categoryId && type !== 'practice') {
    $courseSelect.empty().trigger('change');
    return;
  }

  var url = (type === 'practice')
    ? window.lp_config.basepath + 'get_practice_quizzes.php'
    : window.lp_config.ajaxCoursesUrl;

  $.ajax({
    url: url,
    type: 'GET',
    data: {
      term: '',
      category: categoryId || 0,
      language: $languageSelect.val() || '',
      sesskey: window.lp_config.sesskey
    },
    success: function (data) {

      $courseSelect.empty();

      if (!data || !data.length) {
        return;
      }

      data.forEach(function (item) {
        var option = new Option(item.fullname, item.id, false, false);
        $courseSelect.append(option);
      });

      $courseSelect.trigger('change');
    }
  });
}

  /*function preloadItems(type) {

    var url = (type === 'practice')
      ? window.lp_config.basepath + 'get_practice_quizzes.php'
      : window.lp_config.ajaxCoursesUrl;

    $.ajax({
      url: url,
      type: 'GET',
      data: {
        term: '',
        category: $categorySelect.val() || 0,
        language: $languageSelect.val() || '',
        sesskey: window.lp_config.sesskey
      },
      success: function (data) {

        console.log('Items loaded:', data.length);

        $courseSelect.empty();

        data.forEach(function (item) {
          var option = new Option(item.fullname, item.id, false, false);
          $courseSelect.append(option);
        });

        $courseSelect.trigger('change');
      }
    });
  }*/
  
  

  /* =========================================================
     OPEN MODAL
  ========================================================= */
  $(document).on('click', '.add-activity', function () {

  currentSection = $(this).closest('.section-item');

  var type = currentSection.find('.section-type:checked').val();
  if (!type) {
    alert('Please select Section Type first');
    return;
  }

  var modal = bootstrap.Modal.getOrCreateInstance(
    document.getElementById('activityModal')
  );

  $courseSelect.val(null).empty();
  modal.show();

  initSelect2();

  // ⛔ DO NOT preload courses here anymore
});


  /* =========================================================
     RELOAD WHEN CATEGORY / LANGUAGE CHANGES
  ========================================================= */
  $categorySelect.add($languageSelect).on('change', function () {
    if (!currentSection) return;

    var type = currentSection.find('.section-type:checked').val();
    $courseSelect.val(null).empty();
    preloadItems(type);
  });

  /* =========================================================
     ADD SELECTED ITEMS TO SECTION
  ========================================================= */
  
  
  $('#activityAddBtn').on('click', function () {

    var selected = $courseSelect.select2('data');
    if (!selected.length) {
      alert('Please select at least one item');
      return;
    }

    var list = currentSection.find('.course-list');

    selected.forEach(function (item) {
      if (list.find('[data-id="' + item.id + '"]').length === 0) {
        list.append(`
          <li class="list-group-item d-flex justify-content-between align-items-center"
              data-id="${item.id}">
            ${item.text}
            <span class="text-danger remove-course" style="cursor:pointer">×</span>
          </li>
        `);
      }
    });

    $courseSelect.val(null).trigger('change');
    bootstrap.Modal.getInstance(document.getElementById('activityModal')).hide();
  });

  $(document).on('click', '.remove-course', function () {
    $(this).closest('li').remove();
  });

  /* =========================================================
     BUILD STRUCTURE JSON
  ========================================================= */
  $('#lpCreateForm').on('submit', function () {

    var structure = [];

    $('#sectionsContainer .section-item').each(function () {

      var $s = $(this);

      structure.push({
        title: $s.find('.section-title').text().trim(),
        type: $s.find('.section-type:checked').val(),
        items: $s.find('.course-list li').map(function () {
          return $(this).data('id');
        }).get()
      });
    });

    $('#structure_json').val(JSON.stringify(structure));
  });

});
