<?php
// /local/learningpath/edit.php
require_once(__DIR__ . '/../../config.php');
require_login();
global $DB, $PAGE, $OUTPUT, $USER, $CFG;

$context = context_system::instance();
require_capability('moodle/site:config', $context);

// ---------- UNIQUE NAME AJAX CHECK (EDIT) ----------
if (optional_param('ajax', 0, PARAM_BOOL)) {
    require_sesskey();

    $name = required_param('name', PARAM_TEXT);
    $id   = required_param('id', PARAM_INT); // current learning path id

    $sql = "SELECT id FROM {learning_paths} WHERE name = :name AND id <> :id";
    $exists = $DB->record_exists_sql($sql, [
        'name' => $name,
        'id'   => $id
    ]);

    echo json_encode(['exists' => $exists]);
    exit;
}


$id = required_param('id', PARAM_INT);
$path = $DB->get_record('learning_paths', ['id' => $id], '*', MUST_EXIST);

$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/local/learningpath/edit.php', ['id' => $id]));
$PAGE->set_title('Edit Learning Path');
$PAGE->set_heading('Edit Learning Path');

$categories = $DB->get_records('course_categories', null, 'name ASC');

$sections = $DB->get_records('learning_path_sections', ['learningpathid' => $id], 'position ASC');
foreach ($sections as $sid => $sec) {
    $sec->courses = $DB->get_records('learning_path_courses', ['sectionid' => $sid], 'sortorder ASC');
}

echo $OUTPUT->header();
?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/css/select2.min.css"/>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
<link rel="stylesheet" href="styles.css">

<div class="container-fluid">
  <div class="card shadow-sm p-4 mb-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h4 class="mb-0">Edit Learning Path</h4>
      <a href="manage.php" class="btn btn-outline-secondary btn-sm">Back to list</a>
    </div>

    <form id="lpEditForm" method="POST" action="update.php" enctype="multipart/form-data" novalidate>
      <input type="hidden" name="sesskey" value="<?= sesskey() ?>">
      <input type="hidden" name="id" value="<?= $path->id ?>">
      <input type="hidden" name="structure_json" id="structure_json">

      <div class="mb-3">
        <label class="form-label"><strong>Category</strong></label>
        <select id="categorySelect" name="category_id" class="form-control" required>
          <option value="">Select Category</option>
          <?php foreach ($categories as $cat): ?>
            <option value="<?= $cat->id ?>" <?= $cat->id == $path->categoryid ? 'selected' : '' ?>>
              <?= format_string($cat->name) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="card bg-light p-3 mb-3">
        <h5>Learning Path Details</h5>

        <div class="mb-2">
          <label class="form-label">Name</label>
       <input type="text" name="name" id="lp_name" class="form-control"
       value="<?= s($path->name) ?>" required>

<div id="lp_name_error" class="text-danger small d-none">
  Learning Path name already exists
</div>

        </div>

       <!--  <div class="row g-2 mb-2">
          <div class="col-md-6">
            <label class="form-label">Slug</label>
            <input type="text" name="slug" class="form-control" value="<?= s($path->slug) ?>">
          </div>
          <div class="col-md-6">
            <label class="form-label">SKU</label>
            <input type="text" name="sku" class="form-control" value="<?= s($path->sku) ?>">
          </div>
        </div> -->

        <div class="mb-2">
          <label class="form-label">Type</label><br>
          <?php $types = ['Practice Test','Online Course','Lab','AWS Digital Course','Reading Material'];
          $selected = explode(',', $path->type ?: '');
          foreach ($types as $t): ?>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="checkbox" name="type[]" value="<?= $t ?>" <?= in_array($t,$selected) ? 'checked' : '' ?>>
              <label class="form-check-label"><?= $t ?></label>
            </div>
          <?php endforeach; ?>
        </div>

        <div class="row g-2">
          <div class="col-md-6">
            <label class="form-label">Image</label>
            <?php if (!empty($path->image)): ?>
              <div class="mb-2"><img src="<?= $path->image ?>" style="max-height:80px"></div>
            <?php endif; ?>
            <input type="file" name="image" class="form-control">
          </div>
          <div class="col-md-6">
            <label class="form-label">Level</label>
            <select name="level" class="form-control">
              <option value="Beginner" <?= $path->level == 'Beginner' ? 'selected' : '' ?>>Beginner</option>
              <option value="Intermediate" <?= $path->level == 'Intermediate' ? 'selected' : '' ?>>Intermediate</option>
              <option value="Advanced" <?= $path->level == 'Advanced' ? 'selected' : '' ?>>Advanced</option>
            </select>
          </div>
        </div>

        <div class="mt-2">
          <label class="form-label">Status</label>
          <select name="status" class="form-control">
            <option value="Publish" <?= $path->status == 'Publish' ? 'selected' : '' ?>>Publish</option>
            <option value="Unpublish" <?= $path->status == 'Unpublish' ? 'selected' : '' ?>>Unpublish</option>
          </select>
        </div>

      </div>

      <div class="card bg-light p-3 mb-3">
        <h5>Sections</h5>

        <div id="sectionsContainer">
          <?php foreach ($sections as $sec): ?>
            <div class="section-item p-3 mb-3" data-section-id="<?= $sec->id ?>">
              <div class="d-flex justify-content-between align-items-center mb-2">
                <div><i class="fa fa-bars drag-handle"></i> <strong contenteditable="true" class="section-title"><?= format_string($sec->sectionname) ?></strong></div>
                <div>
                  <button type="button" class="btn btn-xs btn-outline-primary add-activity">+ Add Activity</button>
                  <button type="button" class="btn btn-xs btn-outline-danger remove-section">×</button>
                </div>
              </div>

              <ul class="list-group course-list mb-2">
                <?php foreach ($sec->courses as $c):
                  $coursename = format_string($DB->get_field('course','fullname',['id'=>$c->courseid]));
                ?>
                  <li class="list-group-item list-course-item draggable-course d-flex justify-content-between align-items-center" data-course-id="<?= $c->courseid ?>">
                    <span><i class="fa fa-grip-lines drag-handle me-2"></i> <?= $coursename ?></span>
                    <span><a href="<?= $CFG->wwwroot ?>/course/view.php?id=<?= $c->courseid ?>" target="_blank" class="me-2 small">Open</a>
                    <i class="fa fa-trash remove-course" style="cursor:pointer;color:#c00"></i></span>
                  </li>
                <?php endforeach; ?>
              </ul>

            </div>
          <?php endforeach; ?>
        </div>

        <div class="mt-2">
          <button type="button" id="addSectionBtn" class="btn btn-primary">Add Heading</button>
          <div class="form-text mt-2">Click Add Activity to map courses from the selected category.</div>
        </div>
      </div>

      <div class="text-end">
        <button type="submit" class="btn btn-success"><i class="fa fa-save"></i> Update Learning Path</button>
      </div>

    </form>
  </div>
</div>

<div class="modal fade" id="activityModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header"><h5 class="modal-title">Add Activities (Courses)</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
     <div class="modal-body">

  <!-- Language Filter (ADDED) -->
  <div class="mb-3">
    <label class="form-label"><strong>Filter by Language</strong></label>
    <select id="activityLanguageFilter" class="form-control">
      <option value="">All Languages</option>

      <?php
        $rawlangs = $DB->get_records_sql_menu("
          SELECT DISTINCT lang AS id, lang
          FROM {course}
          WHERE lang IS NOT NULL AND lang <> ''
          ORDER BY lang ASC
        ");

        $langnames = [
          'ar-SA'=>'Arabic (Saudi Arabia)','de-DE'=>'German (Germany)','en-US'=>'English (US)',
          'es-419'=>'Spanish (Latin America)','es-ES'=>'Spanish (Spain)','fr-FR'=>'French',
          'id-ID'=>'Indonesian','it-IT'=>'Italian','ja-JP'=>'Japanese','ko-KR'=>'Korean',
          'pt-BR'=>'Portuguese (Brazil)','zh-CN'=>'Chinese (Simplified)','zh-TW'=>'Chinese (Traditional)',
          'th-TH'=>'Thai','vi-VN'=>'Vietnamese','he-IL'=>'Hebrew','el-GR'=>'Greek','pl-PL'=>'Polish',
          'tr-TR'=>'Turkish','uk-UA'=>'Ukrainian'
        ];

        foreach ($rawlangs as $code => $v) {
          $label = $langnames[$code] ?? $code;
          echo "<option value='$code'>$label</option>";
        }
      ?>
    </select>
  </div>

  <!-- Course selector -->
  <label class="form-label">Search & select course(s)</label>
  <select id="activityCourseSelect" style="width:100%" multiple></select>
  <div class="form-text mt-2">Courses come from the selected category.</div>

</div>

      <div class="modal-footer">
        <button id="activityCancel" type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button id="activityAddBtn" type="button" class="btn btn-primary">Add to section</button>
      </div>
    </div>
  </div>
</div>

<!-- libs -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.0/Sortable.min.js"></script>

<script>
window.lp_config = {
  sesskey: '<?= sesskey() ?>',
  ajaxCoursesUrl: '<?= (new moodle_url('/local/learningpath/get_courses.php'))->out(false) ?>',
  basepath: '<?= (new moodle_url('/local/learningpath/'))->out(false) ?>'
};
</script>
<script>
$(function () {

  $('#lp_name').on('blur', function () {
    let name = $(this).val().trim();
    if (!name) return;

    $.get(window.location.pathname, {
      ajax: 1,
      name: name,
      id: <?= (int)$path->id ?>,
      sesskey: '<?= sesskey() ?>'
    }, function (res) {
      if (res.exists) {
        $('#lp_name_error').removeClass('d-none');
      } else {
        $('#lp_name_error').addClass('d-none');
      }
    }, 'json');
  });

  $('#lpEditForm').on('submit', function (e) {
    if (!$('#lp_name_error').hasClass('d-none')) {
      e.preventDefault();
      alert('Please use a unique Learning Path name.');
    }
  });

});
</script>

<script src="js/learningpath.js"></script>

<?php
echo $OUTPUT->footer();
