<?php
// admin_learningpath3.php
// Full file: list learning paths, modal assign/update enrollments (batches/users)
// Saves data to table: mdl_learning_path_enrolments (use shortname learning_path_enrolments)

require_once('../../config.php');
require_login();
global $DB, $PAGE, $OUTPUT, $CFG;

// -----------------
// AJAX Endpoints
// -----------------
if (optional_param('ajax', 0, PARAM_BOOL)) {
    require_login();
    $type = required_param('type', PARAM_ALPHA);

    // Return batches/cohorts
  // Return batches/cohorts
if ($type === 'batch') {
    $now = time();
    $sql = "SELECT * FROM {cohort} 
            WHERE visible = 1 
            AND (end_date IS NULL OR end_date = 0 OR end_date > :now) 
            ORDER BY name ASC";
    $cohorts = $DB->get_records_sql($sql, ['now' => $now]);
    
    $list = [];
    foreach ($cohorts as $c) {
        $cnt = $DB->count_records('cohort_members', ['cohortid' => $c->id]);
       $list[] = [
    'id'        => $c->id,          // internal use
    'name'      => $c->name,
    'idnumber'  => $c->idnumber,    // ✅ batch idnumber
    'count'     => $cnt,
    'visible'   => $c->visible,
    'end_date'  => $c->end_date
];

    }
    header('Content-Type: application/json');
    echo json_encode($list);
    exit;
}

    // Return users
   if ($type === 'user') {
    // Active users excluding IDs 1 and 2
    $users = $DB->get_records_select(
        'user',
        'deleted = 0 
         AND suspended = 0 
         AND id NOT IN (:uid1, :uid2)',
        [
            'uid1' => 1,
            'uid2' => 2
        ],
        'firstname ASC, lastname ASC',
        'id, firstname, lastname, email'
    );


        $list = [];
        foreach ($users as $u) {
           $list[] = [
    'id'    => $u->id,
    'name'  => trim($u->firstname . ' ' . $u->lastname),
    'email' => $u->email   // ✅ user email
];

        }
        header('Content-Type: application/json');
        echo json_encode($list);
        exit;
    }

    // Return assigned items for a learning path (batches and users)
    if ($type === 'assigned') {
        $lpid = required_param('lpid', PARAM_INT);
        $rows = $DB->get_records('learning_path_enrolments', ['learningpathid' => $lpid]);
        $batches = [];
        $users = [];
        foreach ($rows as $r) {
            if (!empty($r->enroltype) && $r->enroltype === 'batch' && !empty($r->cohortid)) {
                $batches[] = (int)$r->cohortid;
            } else if (!empty($r->enroltype) && $r->enroltype === 'user' && !empty($r->userid)) {
                $users[] = (int)$r->userid;
            }
        }
        header('Content-Type: application/json');
        echo json_encode(['batches' => array_values(array_unique($batches)), 'users' => array_values(array_unique($users))]);
        exit;
    }

    exit;
}

// -----------------
// Save handler (assign/update)
// -----------------
if ($_SERVER['REQUEST_METHOD'] === 'POST' && optional_param('save', 0, PARAM_BOOL)) {
    require_sesskey();
    require_login();

    $selected_lps = optional_param('selected_lps', '', PARAM_RAW);
    $selected_batches = optional_param('selected_batches', '', PARAM_RAW);
    $selected_users = optional_param('selected_users', '', PARAM_RAW);

    // Expect JSON strings
    $lpids = json_decode($selected_lps, true);
    $batches = json_decode($selected_batches, true);
    $users = json_decode($selected_users, true);

    if (!is_array($lpids) || count($lpids) === 0) {
        redirect(new moodle_url('/local/learningpath/admin_learningpath3.php'), get_string('noselection', 'local_learningpath') ?: 'No learning path selected', 3);
    }

    // We only allow single LP selection in the UI; take first
    $lpid = (int)$lpids[0];
    // Fetch learning path record
$lp = $DB->get_record('learning_paths', ['id' => $lpid]);

// If LP found, use name; else fallback
$lpName = $lp->name ?? 'Learning Path';


    if (!is_array($batches)) $batches = [];
    if (!is_array($users)) $users = [];

    // Normalize to ints
    $batches = array_map('intval', array_values(array_unique($batches)));
    $users = array_map('intval', array_values(array_unique($users)));

    // Fetch existing enrolments for this LP
    $existing = $DB->get_records('learning_path_enrolments', ['learningpathid' => $lpid]);

    $existingBatchIds = [];
    $existingUserIds = [];
    foreach ($existing as $e) {
        if (!empty($e->enroltype) && $e->enroltype === 'batch' && !empty($e->cohortid)) {
            $existingBatchIds[] = (int)$e->cohortid;
        } else if (!empty($e->enroltype) && $e->enroltype === 'user' && !empty($e->userid)) {
            $existingUserIds[] = (int)$e->userid;
        }
    }
    $existingBatchIds = array_values(array_unique($existingBatchIds));
    $existingUserIds = array_values(array_unique($existingUserIds));

    // Determine additions and removals for batches
    $toAddBatches = array_diff($batches, $existingBatchIds);
    $toRemoveBatches = array_diff($existingBatchIds, $batches);

    // Determine additions and removals for users
    $toAddUsers = array_diff($users, $existingUserIds);
    $toRemoveUsers = array_diff($existingUserIds, $users);

    $now = time();

    // Add batches
   // Add batches + also store each user in the batch
foreach ($toAddBatches as $bid) {

    // 1) Save batch record (optional — keep if you want batch row)
    $batchRec = new stdClass();
    $batchRec->learningpathid = $lpid;
    $batchRec->cohortid = $bid;
    $batchRec->userid = null;
    $batchRec->enroltype = 'batch';
    $batchRec->timecreated = $now;
    $DB->insert_record('learning_path_enrolments', $batchRec);

    // 2) Fetch all users inside this cohort
    $members = $DB->get_records('cohort_members', ['cohortid' => $bid]);

    // 3) Insert each user into the enrolments table
    foreach ($members as $m) {
        $userRec = new stdClass();
        $userRec->learningpathid = $lpid;
        $userRec->cohortid = $bid;
        $userRec->userid = $m->userid;
        $userRec->enroltype = 'batch_user';
        $userRec->timecreated = $now;

        $DB->insert_record('learning_path_enrolments', $userRec);
    }
}


    // Add users
    foreach ($toAddUsers as $uid) {
        $rec = new stdClass();
        $rec->learningpathid = $lpid;
        $rec->userid = $uid;
        $rec->cohortid = null;
        $rec->enroltype = 'user';
        $rec->timecreated = $now;
        $DB->insert_record('learning_path_enrolments', $rec);
    }

   foreach ($toRemoveBatches as $bid) {

    // Remove batch entry
    $DB->delete_records('learning_path_enrolments', [
        'learningpathid' => $lpid,
        'cohortid' => $bid,
        'enroltype' => 'batch'
    ]);

    // Remove all users added via this batch
    $DB->delete_records('learning_path_enrolments', [
        'learningpathid' => $lpid,
        'cohortid' => $bid,
        'enroltype' => 'batch_user'
    ]);
}


    // Remove users
    foreach ($toRemoveUsers as $uid) {
        $DB->delete_records('learning_path_enrolments', ['learningpathid' => $lpid, 'userid' => $uid, 'enroltype' => 'user']);
    }

    // ---- AUTO ENROLMENT SECTION WILL RUN AFTER DB INSERT/DELETE OPERATIONS ----

    // Redirect back with message will be done after enrolment block below
// Build unique list of users to enrol:
// - selected individual users ($users)
// - users from selected batches/cohorts ($batches)
$usersToEnrol = [];

// add explicit selected users
if (!empty($users) && is_array($users)) {
    foreach ($users as $uid) {
        $usersToEnrol[] = (int)$uid;
    }
}

// add cohort members
// add cohort members - only from active cohorts
if (!empty($batches) && is_array($batches)) {
    foreach ($batches as $cohortid) {
        // Check if cohort is still active
        $now = time();
        $cohort = $DB->get_record_sql(
            "SELECT * FROM {cohort} 
             WHERE id = :id 
             AND visible = 1 
             AND (end_date IS NULL OR end_date = 0 OR end_date > :now)",
            ['id' => $cohortid, 'now' => $now]
        );
        
        if (!$cohort) {
            continue; // Skip inactive/expired cohorts
        }
        
        $members = $DB->get_records('cohort_members', ['cohortid' => $cohortid]);
        if (!empty($members)) {
            foreach ($members as $m) {
                $usersToEnrol[] = (int)$m->userid;
            }
        }
    }
}

// deduplicate
$usersToEnrol = array_values(array_unique(array_map('intval', $usersToEnrol)));



// Build list of ONLY NEW USERS for email
$newUsersForMail = [];

// Users added directly
foreach ($toAddUsers as $uid) {
    $newUsersForMail[] = (int)$uid;
}

// Users added via newly added batches
foreach ($toAddBatches as $bid) {
    $members = $DB->get_records('cohort_members', ['cohortid' => $bid]);
    foreach ($members as $m) {
        $newUsersForMail[] = (int)$m->userid;
    }
}

// Remove duplicates
$newUsersForMail = array_values(array_unique($newUsersForMail));

/* ============================================================
   SEND EMAIL ONLY TO NEWLY ENROLLED USERS
   ============================================================ */

foreach ($newUsersForMail as $uid) {

    // Get user record
    $user = $DB->get_record('user', ['id' => $uid]);
    if (!$user) {
        continue;
    }

    $from = core_user::get_support_user();
    $subject = "You Are Enrolled in a Learning Path";

    // Plain text
    $messagetext = "Hi {$user->firstname},

You have been successfully enrolled into the following Learning Path:

Learning Path: {$lpName}

Now you can access your learning path.

Thanks,
Trainocate Team";

    // HTML Format
    $messagehtml = '
<div style="max-width:600px;margin:auto;border:1px solid #ddd;border-radius:6px;font-family:Arial, sans-serif;">
    <div style="background:#e67e22;padding:15px;border-radius:6px 6px 0 0;">
        <h2 style="margin:0;color:white;font-size:20px;">Learning Path Enrollment</h2>
    </div>

    <div style="padding:20px;font-size:15px;color:#333;">
        <p>Hi <strong>'.$user->firstname.'</strong>,</p>

        <p>You have been successfully enrolled into the following learning path:</p>

        <p><strong>Learning Path:</strong> '.$lpName.'</p>

        <p>You can now access your courses from your dashboard.</p>

        <p>Thanks,<br>Trainocate Team</p>
    </div>
</div>';

    // Send email
    email_to_user($user, $from, $subject, $messagetext, $messagehtml);
}


/* ============================================================
   END EMAIL SENDING
   ============================================================ */

// Redirect after save



// If no users to enrol, skip enrolment work
if (!empty($usersToEnrol)) {
    // Determine courses in this learning path
    $courseIds = [];
    $sections = $DB->get_records('learning_path_sections', ['learningpathid' => $lpid]);
    if (!empty($sections)) {
        foreach ($sections as $sec) {
            $lp_courses = $DB->get_records('learning_path_courses', ['sectionid' => $sec->id]);
            if (!empty($lp_courses)) {
               foreach ($lp_courses as $lc) {

    // only enrol into REAL courses
    if (!empty($lc->courseid) && $lc->courseid > 0) {
        $courseIds[] = (int)$lc->courseid;
    }
}

            }
        }
    }

      $courseIds[] = 4815;

    $courseIds = array_values(array_unique($courseIds));
   



    // Use Moodle enrol API to enrol users into each course's manual enrol instance
    if (!empty($courseIds)) {
        // ensure manual enrol plugin exists
        $manualplugin = enrol_get_plugin('manual');
        foreach ($courseIds as $courseid) {
            // Validate course exists
          $course = $DB->get_record('course', ['id' => $courseid]);
if (!$course) {
    continue; // skip missing courses
}

            // get enrol instances (only enabled ones)
            $instances = enrol_get_instances($course->id, true);
            if (empty($instances)) {
                // no enrol instances for course, skip
                continue;
            }
            // prefer manual enrol instances; if none, fallback to first enabled instance
            $targetInstances = [];
            foreach ($instances as $inst) {
                if ($inst->enrol === 'manual') {
                    $targetInstances[] = $inst;
                }
            }
            if (empty($targetInstances)) {
                // fallback: use any enabled instance
                foreach ($instances as $inst) {
                    if ($inst->status == ENROL_INSTANCE_ENABLED) {
                        $targetInstances[] = $inst;
                    }
                }
            }
            if (empty($targetInstances)) {
                continue;
            }

            // Enrol each user into the chosen instances
            foreach ($targetInstances as $instance) {
                // get the plugin for this instance (safeguard)
                $plugin = enrol_get_plugin($instance->enrol);
                if (!$plugin) continue;

                foreach ($usersToEnrol as $userid) {
                    // Check user exists and is not deleted
                    $u = $DB->get_record('user', ['id' => $userid, 'deleted' => 0, 'suspended' => 0], '*', IGNORE_MISSING);
                    if (!$u) continue;

                    // Check whether user is already enrolled in this instance
                    $ue = $DB->get_record('user_enrolments', ['enrolid' => $instance->id, 'userid' => $userid]);
                    if (!empty($ue)) {
                        // already enrolled via this instance - skip
                        continue;
                    }

                    // Enrol user using plugin's enrol_user method. Many enrol plugins accept (instance, userid, roleid)
                    // We won't force a roleid here — plugin will apply its defaults. If you want explicit role assignment
                    // pass a roleid (e.g. $studentroleid) to $plugin->enrol_user()
                    try {
                        // enrol_user signature varies slightly across plugins; this is standard usage
                        $plugin->enrol_user($instance, $userid);
                    } catch (Exception $ex) {
                        // swallow exception to avoid breaking the whole save flow; optionally log
                        debugging('Auto-enrol error: ' . $ex->getMessage(), DEBUG_DEVELOPER);
                    }
                } // foreach user
            } // foreach instance
        } // foreach course
    } // if courseIds
} // if usersToEnrol

// Redirect back with message
redirect(
    new moodle_url('/local/learningpath/admin_learningpath3.php'),
    'Updated Successfully',
    2
);

} // end POST save handler

// -----------------
// Page: list learning paths, modal UI
// -----------------
$PAGE->set_url('/local/learningpath/admin_learningpath3.php');
$PAGE->set_context(context_system::instance());
$PAGE->set_title('Admin Learning Paths');
$PAGE->set_heading('Admin Learning Paths');

// Pagination
$page    = optional_param('page', 0, PARAM_INT);
$perpage = optional_param('perpage', 10, PARAM_INT);
$search  = optional_param('search', '', PARAM_RAW_TRIMMED);

// Build where
$conditions = [];
$params = [];

// ✅ SHOW ONLY PUBLISHED LEARNING PATHS
$conditions[] = "status = :status";
$params['status'] = 'Publish';

// search filter
if (!empty($search)) {
    $conditions[] = $DB->sql_like('name', ':search', false);
    $params['search'] = '%' . $search . '%';
}

$where = 'WHERE ' . implode(' AND ', $conditions);


// count & fetch
$totalcount = $DB->count_records_sql("SELECT COUNT(*) FROM {learning_paths} $where", $params);
$lps = $DB->get_records_sql("SELECT * FROM {learning_paths} $where ORDER BY id DESC", $params, $page * $perpage, $perpage);

// Preload cohorts (for server-side listing in template)
$cohorts = $DB->get_records('cohort', null, 'name ASC');

echo $OUTPUT->header();
?>

<style>
/* Page container */
.container {
    max-width: 1100px;
    margin: 10px auto;
}

/* Header */
.lp-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 18px;
}
.lp-actions {
    display: flex;
    gap: 10px;
    align-items: center;
}

/* Learning path list */
.lp-list {
    background: var(--secondary-bg, var(--bg-color));
    padding: 12px;
    border-radius: 8px;
}
.lp-item {
    display: flex;
    align-items: center;
    gap: 12px;
    background: var(--surface-bg, #fff);
    border-radius: 6px;
    padding: 10px 12px;
    margin-bottom: 8px;
    border: 1px solid var(--border-color);
}
.lp-item .lp-checkbox {
    transform: scale(1.12);
    margin-right: 6px;
    cursor: pointer;
}
.lp-item .lp-title {
    font-weight: 500;
    font-size: 15px;
    flex: 1;
}

/* Buttons */
.assign-btn {
    background: var(--primary);
    color: #fff;
    border: none;
    padding: 8px 14px;
    border-radius: 6px;
    cursor: pointer;
}
.btn-secondary {
    background: var(--secondary);
    color: var(--primary-text, #333);
    border: none;
    padding: 8px 12px;
    border-radius: 6px;
    cursor: pointer;
}

/* Modal */
#assignModal {
    display: none;
    position: fixed;
    inset: 0;
    background: rgba(0, 0, 0, 0.55);
    z-index: 1100;
}
.modal-box {
    width: 1000px;
    max-width: 98%;
    margin: 40px auto;
    background: var(--surface-bg, #fff);
    border-radius: 8px;
    padding: 12px;
    box-shadow: 0 6px 30px rgba(0, 0, 0, 0.25);
    max-height: 85vh;
    overflow: auto;
}

/* Grid inside modal */
.assign-grid {
    display: flex;
    gap: 12px;
}
.col {
    flex: 1;
    background: var(--secondary-bg);
    border-radius: 6px;
    padding: 8px;
    min-height: 220px;
}
.col h4 {
    margin: 0 0 8px 0;
    font-size: 14px;
}

/* Compact lists */
.list {
    list-style: none;
    padding: 0;
    margin: 0;
    max-height: 36vh;
    overflow: auto;
}
.item {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 4px 6px;
    border-bottom: 1px solid var(--border-color);
    background: var(--surface-bg, #fff);
    border-radius: 4px;
    margin-bottom: 6px;
    font-size: 13px;
    line-height: 1.15;
}
.item .chk {
    transform: scale(1.02);
    margin-right: 6px;
    cursor: pointer;
}
.item .meta {
    color: var(--secondary-text);
    font-size: 12px;
    margin-left: 6px;
}

/* Actions column */
.actions {
    display: flex;
    flex-direction: column;
    gap: 8px;
    align-items: center;
    justify-content: center;
}

/* Modal footer */
.modal-footer {
    display: flex;
    justify-content: flex-end;
    gap: 10px;
    margin-top: 10px;
}

/* Small text */
.small {
    font-size: 13px;
    color: var(--secondary-text);
}

/* Search */
.search {
    width: 100%;
    padding: 6px 8px;
    border-radius: 6px;
    border: 1px solid var(--border-color);
    margin-bottom: 8px;
    font-size: 13px;
    background: var(--surface-bg, #fff);
    color: var(--primary-text);
}

/* compact text ellipsis */
.compact-text {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    display: inline-block;
    max-width: 100%;
    vertical-align: middle;
}

/* checkboxes */
.item input[type="checkbox"] {
    width: 16px;
    height: 16px;
}
/* Make only modal cancel/close buttons white text */
#closeModal.btn-secondary,
#assignCancel.btn-secondary {
    color: #fff !important;
}

/* responsive tweaks */
@media (max-width: 720px) {
    .assign-grid {
        flex-direction: column;
    }
    .modal-box {
        margin: 20px;
        padding: 10px;
    }
}
.lp-card {
    display: flex;
    align-items: center;
    gap: 14px;
    padding: 14px 16px;
    background: #fff;
    border: 1px solid #e5e7eb;
    border-radius: 10px;
    margin-bottom: 10px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.lp-card:hover {
    background: #f9fafb;
    border-color: #cbd5e1;
    transform: translateY(-1px);
}

.lp-card.selected {
    border-color: #2563eb;
    background: #eff6ff;
}

.lp-icon {
    font-size: 26px;
    width: 40px;
    text-align: center;
}

.lp-content {
    flex: 1;
}

.lp-title {
    font-size: 15px;
    font-weight: 600;
    color: #111827;
}

.lp-subtext {
    font-size: 12px;
    color: #6b7280;
}

.lp-actions-right {
    display: flex;
    align-items: center;
}


</style>
<div class="container">
    <div class="lp-header">
        <div>
            <h2 style="margin:0">Learning Paths</h2>
            <div class="small">Manage and assign learning paths to batches or users</div>
        </div>
        <div class="lp-actions">
<form method="get"
      action="<?= (new moodle_url('/local/learningpath/admin_learningpath3.php'))->out(false) ?>"
      style="display:flex; gap:8px; align-items:center;">

    <input type="search"
           id="lpSearch"
           name="search"
           value="<?= s($search) ?>"
           placeholder="Search learning paths..."
           class="form-control"
           style="max-width:260px;">

    <button type="submit" class="btn btn-primary">
        Search
    </button>
</form>

            <button id="openAssignBtn" class="assign-btn">Assign / Update Learning Paths</button>
        </div>
    </div>

    <div class="lp-list" id="lpList">
        <?php if (empty($lps)) : ?>
            <div style="padding:18px">No learning paths found.</div>
        <?php else: foreach ($lps as $lp): ?>
            <div class="lp-card"
     data-lpid="<?= $lp->id ?>"
     data-name="<?= s($lp->name) ?>"
     onclick="selectLearningPath(this)">

    <!-- Left icon -->
    <div class="lp-icon">
        📘
    </div>

    <!-- Center content -->
    <div class="lp-content">
        <div class="lp-title"><?= format_string($lp->name) ?></div>
       
    </div>

    <!-- Right actions -->
    <div class="lp-actions-right">
        <button type="button"
                class="toggle-btn"
                onclick="event.stopPropagation(); toggleSections(<?= $lp->id ?>)"
                id="lp-btn-<?= $lp->id ?>">
            ▶
        </button>
    </div>

    <!-- Hidden checkbox (logic still works) -->
    <input type="checkbox"
           class="lp-checkbox"
           value="<?= $lp->id ?>"
           data-name="<?= s($lp->name) ?>"
           hidden>
</div>

            <div id="sections-<?= $lp->id ?>" style="display:none; margin-left:30px;">
                <?php
                $sections = $DB->get_records('learning_path_sections', ['learningpathid' => $lp->id], 'id ASC');
                if (empty($sections)) {
                    echo '<div class="small">No sections available.</div>';
                } else {
                    foreach ($sections as $sec) {
                        echo '<div style="margin:8px 0; display:flex; align-items:center; gap:8px;">';
                        echo '<button type="button" class="toggle-btn" onclick="toggleCourses(' . $sec->id . ')" id="sec-btn-' . $sec->id . '">▶</button>';
                        echo '<span style="font-weight:600;">' . format_string($sec->sectionname) . '</span>';
                        echo '</div>';
                        echo '<div id="courses-' . $sec->id . '" style="display:none; margin-left:26px;">';
                        $lp_courses = $DB->get_records('learning_path_courses', ['sectionid' => $sec->id]);
                        if (empty($lp_courses)) {
                            echo '<div class="small">No courses in this section.</div>';
                        } else {
                            foreach ($lp_courses as $lc) {

    if ($lc->activitytype === 'quiz') {

        // quizzes are stored in quiz table
        $quiz = $DB->get_record('quiz', ['id' => $lc->quizid]);

        if ($quiz) {
            echo '<div class="course-item" style="margin:4px 0; font-size:13px;">
                     ' . format_string($quiz->name) . '
                  </div>';
        }

    } else {

        // courses
        $course = $DB->get_record('course', ['id' => $lc->courseid]);

        if ($course) {
            echo '<div class="course-item" style="margin:4px 0; font-size:13px;">
                     ' . format_string($course->fullname) . '
                  </div>';
        }
    }
}

                        }
                        echo '</div>';
                    }
                }
                ?>
            </div>
        <?php endforeach; endif; ?>
    </div>

    <div style="margin-top:12px; display:flex; justify-content:space-between; align-items:center;">
        <div class="small">Showing <?= ($page * $perpage) + 1 ?> - <?= min(($page * $perpage) + count($lps), $totalcount) ?> of <?= $totalcount ?></div>
        <div>
            <?php
            $baseurl = new moodle_url('/local/learningpath/admin_learningpath3.php', ['perpage' => $perpage, 'search' => $search]);
            echo $OUTPUT->paging_bar($totalcount, $page, $perpage, $baseurl);
            ?>
        </div>
    </div>
</div>

<!-- Modal -->
<div id="assignModal">
    <div class="modal-box">
        <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:8px;">
            <div style="flex:1;">
                <div id="assignModalTitle" style="font-weight:600; font-size:16px;">Assign / Update Learning Path</div>
                <div class="small" id="assignModalSub">Select batches and users to assign</div>
            </div>
            <div style="margin-left:12px;">
                <button id="closeModal" class="btn-secondary">Close</button>
            </div>
        </div>

        <!-- GRID: Left: Available lists | Right: Selected lists -->
        <div class="assign-grid">
            <!-- Left: Available -->
            <div class="col">
                <h4 style="margin-bottom:6px;">Available Batches</h4>
                <input id="searchAllBatches" class="search" placeholder="Search batches...">
                <ul id="allBatchesList" class="list"></ul>

                <hr style="margin:8px 0; border:none; border-top:1px solid #eef2f7;">

                <h4 style="margin-bottom:6px;">Available Users</h4>
                <input id="searchAllUsers" class="search" placeholder="Search users...">
                <ul id="allUsersList" class="list"></ul>
            </div>

            <!-- Actions column -->
            <div style="width:80px; display:flex; flex-direction:column; align-items:center; justify-content:space-between;">
                <div class="actions">
                    <button id="moveRightBatch" type="button" class="assign-btn">▶</button>
                    <button id="moveLeftBatch" type="button" class="btn-secondary">◀</button>
                </div>
                <div style="height:8px;"></div>
                <div class="actions">
                    <button id="moveRightUser" type="button" class="assign-btn">▶</button>
                    <button id="moveLeftUser" type="button" class="btn-secondary">◀</button>
                </div>
            </div>

            <!-- Right: Selected -->
            <div class="col">
                <h4 style="margin-bottom:6px;">Selected Batches</h4>
                <input id="searchSelectedBatches" class="search" placeholder="Search selected batches...">
                <ul id="selectedBatchesList" class="list"></ul>

                <hr style="margin:8px 0; border:none; border-top:1px solid #eef2f7;">

                <h4 style="margin-bottom:6px;">Selected Users</h4>
                <input id="searchSelectedUsers" class="search" placeholder="Search selected users...">
                <ul id="selectedUsersList" class="list"></ul>
            </div>
        </div>

        <!-- Form used to submit -->
        <form id="assignForm" method="post" action="<?= new moodle_url('/local/learningpath/admin_learningpath3.php') ?>">
            <input type="hidden" name="selected_lps" id="selected_lps" value="">
            <input type="hidden" name="selected_batches" id="selected_batches" value="">
            <input type="hidden" name="selected_users" id="selected_users" value="">
            <input type="hidden" name="save" value="1">
            <input type="hidden" name="sesskey" value="<?= sesskey() ?>">
            <div class="modal-footer">
                <button id="assignSubmit" type="button" class="assign-btn">SAVE</button>
                <button id="assignCancel" type="button" class="btn-secondary">CANCEL</button>
            </div>
        </form>
    </div>
</div>
<script>
function selectLearningPath(card) {
    // clear previous selection
    document.querySelectorAll('.lp-card').forEach(c => {
        c.classList.remove('selected');
        const cb = c.querySelector('.lp-checkbox');
        if (cb) cb.checked = false;
    });

    // select this card
    card.classList.add('selected');
    const checkbox = card.querySelector('.lp-checkbox');
    if (checkbox) checkbox.checked = true;
}
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script>
/* Globals */
let selectedBatches = [];
let selectedUsers = [];

/* Utility to escape HTML for insertion */
function esc(s) {
    return String(s).replace(/[&<>"']/g, function (m) {
        return {'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m];
    });
}

/* Load left lists */
function loadAllBatches() {
    return fetch('admin_learningpath3.php?ajax=1&type=batch')
        .then(r => r.json())
        .then(data => {
            renderAllBatches(data);
            return data;
        });
}
function loadAllUsers() {
    return fetch('admin_learningpath3.php?ajax=1&type=user')
        .then(r => r.json())
        .then(data => {
            renderAllUsers(data);
            return data;
        });
}

function renderAllBatches(items) {
    const ul = document.getElementById('allBatchesList');
    ul.innerHTML = '';

    const now = Math.floor(Date.now() / 1000);

    items.forEach(it => {
        // Skip if already selected
        if (selectedBatches.includes(it.id)) return;

        // Check if visible is 0
        const visible = parseInt(it.visible || 0);
        const enddate = parseInt(it.end_date || 0);

        // Hide if not visible OR end date has passed
        if (visible === 0) return;
        if (enddate > 0 && enddate < now) return;

        const li = document.createElement('li');
        li.className = 'item';
        li.dataset.id = it.id;
        li.dataset.idnumber = it.idnumber || '';

        li.innerHTML = `
            <input type="checkbox" class="chk batch-check" />
            <div style="flex:1; display:flex; align-items:center; justify-content:space-between;">
               <span class="compact-text" title="${esc(it.name)}">
    ${esc(it.name)} (${esc(it.idnumber || 'N/A')})
</span>

                <span class="meta">(${it.count} members)</span>
            </div>
        `;
        ul.appendChild(li);
    });
}

function renderAllUsers(items) {
    const ul = document.getElementById('allUsersList');
    ul.innerHTML = '';

    items.forEach(it => {
        if (selectedUsers.includes(it.id)) return;

        const li = document.createElement('li');
        li.className = 'item';
        li.dataset.id = it.id;
        li.dataset.email = it.email || ''; // ✅ store email

        li.innerHTML = `
            <input type="checkbox" class="chk user-check" />
            <div style="flex:1;">
                <span class="compact-text" title="${esc(it.name)}">
                    ${esc(it.name)} (${esc(it.email || 'N/A')})
                </span>
            </div>
        `;
        ul.appendChild(li);
    });
}


/* helper to render an item into the selected list (batches/users) */
function renderSelectedBatch(id, name, count, idnumber = '') {
    const ul = document.getElementById('selectedBatchesList');
    // if already present, skip
    if (ul.querySelector('.item[data-id="' + id + '"]')) return;
    const li = document.createElement('li');
    li.className = 'item';
    li.dataset.id = id;
    li.innerHTML = `
        <input type="checkbox" class="chk batch-check" checked />
        <div style="flex:1; display:flex; align-items:center; justify-content:space-between;">
           <span class="compact-text" title="${esc(name)}">
    ${esc(name)} (${esc(idnumber || 'N/A')})
</span>

            <span class="meta">(${count} members)</span>
        </div>
    `;
    ul.appendChild(li);
}
function renderSelectedUser(id, name, email = '') {
    const ul = document.getElementById('selectedUsersList');
    if (ul.querySelector('.item[data-id="' + id + '"]')) return;

    const li = document.createElement('li');
    li.className = 'item';
    li.dataset.id = id;
    li.dataset.email = email;

    li.innerHTML = `
        <input type="checkbox" class="chk user-check" checked />
        <div style="flex:1;">
            <span class="compact-text"
                  title="${esc(name)} (${esc(email || 'N/A')})">
                ${esc(name)} (${esc(email || 'N/A')})
            </span>
        </div>
    `;
    ul.appendChild(li);
}

/* Move selected from all to selected (batches/users) */
function moveRightBatch() {
    $('#allBatchesList .item').each(function() {
        const id = parseInt($(this).data('id'));
        const chk = $(this).find('.batch-check');
        if (chk.prop('checked') && !selectedBatches.includes(id)) {
            selectedBatches.push(id);
            const name = $(this).find('.compact-text').attr('title') || $(this).find('.compact-text').text();
            const meta = $(this).find('.meta').text().replace(/[()]/g, '').trim();
             const idnumber = $(this).data('idnumber') || '';

            $(this).remove();
          
renderSelectedBatch(id, name, meta.split(' ')[0] || '', idnumber);

        }
    });
}
function moveLeftBatch() {
    let removed = false;
    $('#selectedBatchesList .item').each(function() {
        const id = parseInt($(this).data('id'));
        const chk = $(this).find('.batch-check');
        if (chk.prop('checked')) {
            selectedBatches = selectedBatches.filter(x => x !== id);
            $(this).remove();
            removed = true;
        }
    });
    if (removed) {
        // reload left lists so removed ones reappear (selected arrays already updated)
        Promise.all([loadAllBatches(), loadAllUsers()]).catch(e => console.error(e));
    }
}

function moveRightUser() {
    $('#allUsersList .item').each(function() {
        const id = parseInt($(this).data('id'));
        const chk = $(this).find('.user-check');
        if (chk.prop('checked') && !selectedUsers.includes(id)) {
            selectedUsers.push(id);
            const name = $(this).find('.compact-text').attr('title') || $(this).find('.compact-text').text();
               const email = $(this).data('email') || '';                 // ✔ email

            $(this).remove();
            renderSelectedUser(id, name, email);
        }
    });
}
function moveLeftUser() {
    let removed = false;
    $('#selectedUsersList .item').each(function() {
        const id = parseInt($(this).data('id'));
        const chk = $(this).find('.user-check');
        if (chk.prop('checked')) {
            selectedUsers = selectedUsers.filter(x => x !== id);
            $(this).remove();
            removed = true;
        }
    });
    if (removed) {
        Promise.all([loadAllUsers(), loadAllBatches()]).catch(e => console.error(e));
    }
}

/* Search handlers */
$('#searchAllBatches').on('keyup', function() {
    let val = $(this).val().toLowerCase();
    $('#allBatchesList .item').each(function() {
        $(this).toggle($(this).text().toLowerCase().indexOf(val) !== -1);
    });
});
$('#searchSelectedBatches').on('keyup', function() {
    let val = $(this).val().toLowerCase();
    $('#selectedBatchesList .item').each(function() {
        $(this).toggle($(this).text().toLowerCase().indexOf(val) !== -1);
    });
});
$('#searchAllUsers').on('keyup', function() {
    let val = $(this).val().toLowerCase();
    $('#allUsersList .item').each(function() {
        $(this).toggle($(this).text().toLowerCase().indexOf(val) !== -1);
    });
});
$('#searchSelectedUsers').on('keyup', function() {
    let val = $(this).val().toLowerCase();
    $('#selectedUsersList .item').each(function() {
        $(this).toggle($(this).text().toLowerCase().indexOf(val) !== -1);
    });
});

/* Setup click on .item to toggle checkbox (both lists) */
$(document).on('click', '.item', function(e) {
    if ($(e.target).is('input')) return;
    let chk = $(this).find('input[type=checkbox]');
    chk.prop('checked', !chk.prop('checked'));
});

/* Toggle sections */
function toggleSections(lpId) {
    let div = document.getElementById("sections-" + lpId);
    let btn = document.getElementById("lp-btn-" + lpId);
    if (!div) return;
    if (div.style.display === "none" || div.style.display === "") {
        div.style.display = "block";
        btn.innerHTML = "▼";
    } else {
        div.style.display = "none";
        btn.innerHTML = "▶";
    }
}

/* Toggle courses (section) */
function toggleCourses(sectionId) {
    let div = document.getElementById("courses-" + sectionId);
    let btn = document.getElementById("sec-btn-" + sectionId);
    if (!div) return;
    if (div.style.display === "none" || div.style.display === "") {
        div.style.display = "block";
        btn.innerHTML = "▼";
    } else {
        div.style.display = "none";
        btn.innerHTML = "▶";
    }
}

/* Open modal - load lists and assigned */
function openAssignModal() {
    let selectedLP = document.querySelector('.lp-checkbox:checked');
    if (!selectedLP) {
        alert('Please select a Learning Path first.');
        return;
    }
    const lpid = parseInt(selectedLP.value);
    const lpName = selectedLP.dataset.name || ('LP #' + lpid);
    document.getElementById('assignModalTitle').innerText = 'Assign / Update: ' + lpName;

    // reset selections & lists
    selectedBatches = [];
    selectedUsers = [];
    $('#allBatchesList, #allUsersList, #selectedBatchesList, #selectedUsersList').empty();

    // STEP 1: Fetch assigned list
    fetch('admin_learningpath3.php?ajax=1&type=assigned&lpid=' + lpid)
        .then(r => r.json())
        .then(data => {
            selectedBatches = Array.isArray(data.batches) ? data.batches.map(Number) : [];
            selectedUsers   = Array.isArray(data.users)   ? data.users.map(Number)   : [];

            // STEP 2: load available lists (they will skip selected ids)
            return Promise.all([loadAllBatches(), loadAllUsers()]);
        })
        .then(([batchesData, usersData]) => {
            // STEP 3: move any matching left items to right (and render placeholders for missing ones)

            // Batches: for each selected batch id try to find in left list; if found move it; if not, render placeholder
            selectedBatches.forEach(function(id) {
                let li = $('#allBatchesList .item[data-id="' + id + '"]');
                if (li.length) {
                    const name = li.find('.compact-text').attr('title') || li.find('.compact-text').text();
                    const meta = li.find('.meta').text().replace(/[()]/g, '').trim();
                    const idnumber = li.data('idnumber') || '';
                    li.remove();
                    renderSelectedBatch(id, name, meta.split(' ')[0] || '', idnumber);
                } else {
                    // left list didn't include the batch (maybe filtered by visibility), render simple placeholder
                    // try to find name in batchesData
                    let found = (batchesData || []).find(x => parseInt(x.id) === id);
                    if (found) {
                        renderSelectedBatch(found.id, found.name, found.count || '');
                    } else {
                        renderSelectedBatch(id, 'Batch #' + id, '');
                    }
                }
            });

            // Users
            selectedUsers.forEach(function(id) {
                let li = $('#allUsersList .item[data-id="' + id + '"]');
                if (li.length) {
                    const name = li.find('.compact-text').attr('title') || li.find('.compact-text').text();
                      const email = li.data('email') || '';
                    li.remove();
                   renderSelectedUser(id, name, email); 
                } else {
                    // try to find in usersData
                    let found = (usersData || []).find(x => parseInt(x.id) === id);
                    if (found) {
                        renderSelectedUser(found.id, found.name, found.email || '');
                    } else {
                        renderSelectedUser(id, 'User #' + id);
                    }
                }
            });

            // Show modal
            document.getElementById('assignModal').style.display = 'block';
        })
        .catch(err => {
            console.error('Error loading modal data', err);
            alert('Failed to load modal data. See console for details.');
        });
}

/* Save submit */
function submitAssignForm() {
    let selectedLP = document.querySelector('.lp-checkbox:checked');
    if (!selectedLP) {
        alert('Please select a Learning Path.');
        return;
    }
    // Ensure arrays reflect right-side lists
    let rightBatchIds = [];
    $('#selectedBatchesList .item').each(function(){ rightBatchIds.push(parseInt($(this).data('id'))); });
    selectedBatches = rightBatchIds;

    let rightUserIds = [];
    $('#selectedUsersList .item').each(function(){ rightUserIds.push(parseInt($(this).data('id'))); });
    selectedUsers = rightUserIds;

    document.getElementById('selected_lps').value = JSON.stringify([selectedLP.value]);
    document.getElementById('selected_batches').value = JSON.stringify(selectedBatches);
    document.getElementById('selected_users').value = JSON.stringify(selectedUsers);

    // submit form
    document.getElementById('assignForm').submit();
}

/* Event wiring */
document.addEventListener('DOMContentLoaded', function() {
    // open modal button
    document.getElementById('openAssignBtn').addEventListener('click', openAssignModal);
    // close/cancel
    document.getElementById('closeModal').addEventListener('click', () => { document.getElementById('assignModal').style.display = 'none'; });
    document.getElementById('assignCancel').addEventListener('click', () => { document.getElementById('assignModal').style.display = 'none'; });
    // move buttons
    document.getElementById('moveRightBatch').addEventListener('click', moveRightBatch);
    document.getElementById('moveLeftBatch').addEventListener('click', moveLeftBatch);
    document.getElementById('moveRightUser').addEventListener('click', moveRightUser);
    document.getElementById('moveLeftUser').addEventListener('click', moveLeftUser);
    // submit
    document.getElementById('assignSubmit').addEventListener('click', submitAssignForm);

    // Single-select LP (so user selects one learning path at a time)
    document.querySelectorAll('.lp-checkbox').forEach(cb => {
        cb.addEventListener('change', function() {
            if (this.checked) {
                document.querySelectorAll('.lp-checkbox').forEach(other => {
                    if (other !== this) other.checked = false;
                });
            }
        });
    });

    // NOTE: removed automatic initial load of lists — lists load when modal opens after fetching assigned.
});

// document.getElementById('lpSearch').addEventListener('keyup', function () {
//     this.form.submit();
// });

</script>


<?php
echo $OUTPUT->footer();
