(function () {

    function waitForMoodleReady() {
        if (
            typeof window.M === 'undefined' ||
            typeof window.M.core_formchangechecker === 'undefined'
        ) {
            setTimeout(waitForMoodleReady, 500);
            return;
        }

        initCustomUI();
    }

    function initCustomUI() {
        const nav = document.querySelector('.quiznavigation');
        if (!nav) return;

        if (document.getElementById('custom-quiz-status')) return;

        const bar = document.createElement('div');
        bar.id = 'custom-quiz-status';
        bar.style.padding = '10px';
        bar.style.marginBottom = '10px';
        bar.style.background = '#f4f6fb';
        bar.style.borderRadius = '6px';

        bar.innerHTML = `
            <strong style="color:#198754">Attempted:</strong> <span id="qa">0</span> |
            <strong style="color:#dc3545">Skipped:</strong> <span id="qs">0</span> |
            <strong style="color:#fd7e14">Review:</strong> <span id="qr">0</span> |
            <strong style="color:#0d6efd">Total:</strong> <span id="qt">0</span>
            <div style="margin-top:8px">
                <button data-f="all">All</button>
                <button data-f="attempted">Attempted</button>
                <button data-f="skipped">Skipped</button>
                <button data-f="review">Review</button>
            </div>
        `;

        nav.parentNode.insertBefore(bar, nav);

        const buttons = nav.querySelectorAll('.qnbutton');

        function update() {
            let attempted = 0;
            let review = 0;

            buttons.forEach(b => {
                if (b.classList.contains('answersaved')) attempted++;
                if (b.classList.contains('marked')) review++;
            });

            document.getElementById('qa').innerText = attempted;
            document.getElementById('qs').innerText = buttons.length - attempted;
            document.getElementById('qr').innerText = review;
            document.getElementById('qt').innerText = buttons.length;
        }

        function filter(type) {
            buttons.forEach(b => {
                b.style.display = 'inline-flex';

                if (type === 'attempted' && !b.classList.contains('answersaved'))
                    b.style.display = 'none';

                if (type === 'skipped' && b.classList.contains('answersaved'))
                    b.style.display = 'none';

                if (type === 'review' && !b.classList.contains('marked'))
                    b.style.display = 'none';
            });
        }

        bar.querySelectorAll('button').forEach(btn => {
            btn.addEventListener('click', () => filter(btn.dataset.f));
        });

        update();
        document.addEventListener('click', update);
        document.addEventListener('change', update);
    }

    waitForMoodleReady();

})();
