(function () {

    console.log('✅ examui.js file loaded');

    function waitForMoodleReady() {
        console.log('⏳ Waiting for Moodle core JS...');

        if (
            typeof window.M === 'undefined' ||
            typeof window.M.core_formchangechecker === 'undefined'
        ) {
            console.log('❌ Moodle not ready yet, retrying...');
            setTimeout(waitForMoodleReady, 500);
            return;
        }

        console.log('✅ Moodle core JS ready');
        initCustomUI();
    }

    function initCustomUI() {
        console.log('🚀 initCustomUI() called');

        const nav = document.querySelector('.quiznavigation');
        if (!nav) {
            console.warn('❌ .quiznavigation not found');
            return;
        }

        console.log('✅ .quiznavigation found');

        if (document.getElementById('custom-quiz-status')) {
            console.warn('⚠️ custom UI already exists, skipping');
            return;
        }

        const bar = document.createElement('div');
        bar.id = 'custom-quiz-status';
        bar.style.padding = '10px';
        bar.style.marginBottom = '10px';
        bar.style.background = '#f4f6fb';
        bar.style.borderRadius = '6px';

        bar.innerHTML = `
            <strong style="color:#198754">Attempted:</strong> <span id="qa">0</span> |
            <strong style="color:#dc3545">Skipped:</strong> <span id="qs">0</span> |
            <strong style="color:#fd7e14">Review:</strong> <span id="qr">0</span> |
            <strong style="color:#0d6efd">Total:</strong> <span id="qt">0</span>
            <div style="margin-top:8px">
                <button data-f="all">All</button>
                <button data-f="attempted">Attempted</button>
                <button data-f="skipped">Skipped</button>
                <button data-f="review">Review</button>
            </div>
        `;

        nav.parentNode.insertBefore(bar, nav);
        console.log('✅ Custom status bar inserted');

        const buttons = nav.querySelectorAll('.qnbutton');
        console.log(`📊 Found ${buttons.length} question buttons`);

        function update() {
            let attempted = 0;
            let review = 0;

            buttons.forEach(b => {
                if (b.classList.contains('answersaved')) attempted++;
                if (b.classList.contains('marked')) review++;
            });

            document.getElementById('qa').innerText = attempted;
            document.getElementById('qs').innerText = buttons.length - attempted;
            document.getElementById('qr').innerText = review;
            document.getElementById('qt').innerText = buttons.length;

            console.log(`🔄 Update → Attempted: ${attempted}, Review: ${review}`);
        }

        function filter(type) {
            console.log(`🎯 Filter clicked: ${type}`);

            buttons.forEach(b => {
                b.style.display = 'inline-flex';

                if (type === 'attempted' && !b.classList.contains('answersaved'))
                    b.style.display = 'none';

                if (type === 'skipped' && b.classList.contains('answersaved'))
                    b.style.display = 'none';

                if (type === 'review' && !b.classList.contains('marked'))
                    b.style.display = 'none';
            });
        }

        bar.querySelectorAll('button').forEach(btn => {
            btn.addEventListener('click', () => filter(btn.dataset.f));
        });

        update();
        document.addEventListener('click', update);
        document.addEventListener('change', update);

        console.log('✅ Custom Quiz UI fully initialised');
    }

    waitForMoodleReady();

})();
