<?php
require_once(__DIR__ . '/../../config.php');
require_login();

$PAGE->set_url(new moodle_url('/local/custompage/training.php'));
$PAGE->set_context(context_system::instance());
$PAGE->set_pagelayout('standard');

$PAGE->set_title('Learning Path');
$PAGE->set_heading('Learning Path');

echo $OUTPUT->header();

/* Pagination */
global $DB, $USER;
$perpage = 10;
$page = optional_param('page', 0, PARAM_INT);
$start = $page * $perpage;

/* Fetch Only Learning Paths where user is enrolled */
$sql = "
    SELECT lp.*
    FROM {learning_paths} lp
    JOIN {learning_path_enrolments} e ON e.learningpathid = lp.id
    WHERE e.userid = :userid
    ORDER BY lp.id DESC
";

$allpaths = $DB->get_records_sql($sql, ['userid' => $USER->id]);
$total = count($allpaths);
$paths = array_slice($allpaths, $start, $perpage);

?>

<style>
/* ---------- COLORS FROM YOUR THEME ---------- */
:root {
    --primary: #FF4B00;
    --secondary: #F16521;
    --light-bg: #FFF5ED;
    --card-bg: #ffffff;
    --border: #f1e1d8;
    --text-dark: #2b1f1a;
}

/* ---------- PAGE UI ---------- */
.container {
    max-width: 1100px !important;
}

/* Title */
h3 {
    color: var(--primary);
    font-weight: 700;
    margin-bottom: 20px;
}

/* Learning Path Card */
.lp-item {
    background: var(--card-bg);
    padding: 18px 20px;
    border: 1px solid var(--border);
    border-radius: 12px;
    margin-bottom: 15px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    transition: 0.2s;
}

.lp-item:hover {
    box-shadow: 0 4px 14px rgba(0,0,0,0.08);
}

/* Path Name */
.lp-name {
    font-size: 18px;
    font-weight: 700;
    color: var(--text-dark);
}

/* Progress bar */
.lp-progress {
    width: 230px;
    height: 8px;
    background: #ffe1d3;
    border-radius: 6px;
    overflow: hidden;
    margin-top: 8px;
}

.lp-progress-fill {
    height: 8px;
    background: var(--primary);
    transition: width 0.3s ease;
}

/* Access Button */
.access-btn {
    background: var(--primary);
    color: #fff;
    padding: 6px 16px;
    border-radius: 6px;
    text-decoration: none;
    font-size: 14px;
    font-weight: 600;
    transition: 0.2s;
}

.access-btn:hover {
    background: var(--secondary);
    color: #fff;
}

/* Toggle buttons */
.toggle-btn {
    background: var(--light-bg);
    border: 1px solid var(--secondary);
    color: var(--primary);
    cursor: pointer;
    border-radius: 6px;
    font-size: 13px;
    padding: 2px 8px;
    transition: 0.2s;
}

.toggle-btn:hover {
    background: var(--secondary);
    color: #fff;
}

/* Section Title */
.section-title {
    font-weight: 700;
    font-size: 14px;
    color: var(--text-dark);
}

/* Course item */
.course-item {
    margin: 3px 0 3px 30px;
    font-size: 13px;
    padding: 3px 0;
    color: #5a463d;
}
</style>

<div class="container">

<h3>Learning Path</h3>

<?php if (empty($paths)): ?>
    <div style="padding:20px;">You are not enrolled in any learning path.</div>
<?php endif; ?>

<?php foreach ($paths as $lp):

    /* Count user progress */
    $completed = $DB->count_records_sql("
        SELECT COUNT(*)
        FROM {learning_path_courses} c
        JOIN {course_completions} cc ON cc.course = c.courseid AND cc.userid = ?
        WHERE c.sectionid IN (
            SELECT id FROM {learning_path_sections} WHERE learningpathid = ?
        )
        AND cc.timecompleted IS NOT NULL
    ", [$USER->id, $lp->id]);

    $totalcourses = $DB->count_records_sql("
        SELECT COUNT(*)
        FROM {learning_path_courses}
        WHERE sectionid IN (
            SELECT id FROM {learning_path_sections}
            WHERE learningpathid = ?
        )
    ", [$lp->id]);

    $progress = $totalcourses > 0 ? round(($completed / $totalcourses) * 100) : 0;
?>

<div class="lp-item">

    <div style="display:flex; justify-content:space-between; align-items:center;">
        <div>
            <div class="lp-name"><?= format_string($lp->name) ?></div>
            <div class="lp-progress"><div class="lp-progress-fill" style="width:<?= $progress ?>%"></div></div>
        </div>

        <div style="display:flex; gap:10px;">
            <?php 
            $url = new moodle_url('/local/learningpath/learner_path_view.php', ['id' => $lp->id]);
            ?>
            <a class="access-btn" href="<?= $url ?>">Access Now</a>

            <button class="toggle-btn" onclick="toggleSections(<?= $lp->id ?>)" id="btn-lp-<?= $lp->id ?>">▶</button>
        </div>
    </div>

    <div id="sections-<?= $lp->id ?>" style="display:none; margin-top:10px;">

        <?php
        $sections = $DB->get_records('learning_path_sections', ['learningpathid' => $lp->id], 'id ASC');

        foreach ($sections as $sec):
        ?>

        <div style="margin-top:10px;">
            <button class="toggle-btn" onclick="toggleCourses(<?= $sec->id ?>)" id="btn-sec-<?= $sec->id ?>">▶</button>
            <span class="section-title"><?= format_string($sec->sectionname) ?></span>
        </div>

        <div id="courses-<?= $sec->id ?>" style="display:none;">
            <?php
            $courses = $DB->get_records('learning_path_courses', ['sectionid' => $sec->id]);
            foreach ($courses as $c):
                $course = $DB->get_record('course', ['id' => $c->courseid]);
                if ($course):
            ?>
                <div class="course-item">• <?= format_string($course->fullname) ?></div>
            <?php endif; endforeach; ?>
        </div>

        <?php endforeach; ?>

    </div>

</div>

<?php endforeach; ?>

<!-- Pagination -->
<?php
echo $OUTPUT->paging_bar(
    $total, $page, $perpage,
    new moodle_url('/local/custompage/training.php')
);
?>

</div>

<script>
function toggleSections(id){
    let s=document.getElementById("sections-"+id);
    let b=document.getElementById("btn-lp-"+id);
    if(s.style.display==="none"){ s.style.display="block"; b.innerHTML="▼"; }
    else{ s.style.display="none"; b.innerHTML="▶"; }
}

function toggleCourses(id){
    let s=document.getElementById("courses-"+id);
    let b=document.getElementById("btn-sec-"+id);
    if(s.style.display==="none"){ s.style.display="block"; b.innerHTML="▼"; }
    else{ s.style.display="none"; b.innerHTML="▶"; }
}
</script>

<?php
echo $OUTPUT->footer();
?>
