<?php
require_once(__DIR__ . '/../../config.php');
require_once($CFG->dirroot . '/question/format.php');
require_once($CFG->dirroot . '/question/editlib.php');

require_login();



$PAGE->set_context(context_system::instance());
$PAGE->set_url('/local/customquestionimport/import.php');
$PAGE->set_title('CSV Question Import');
$PAGE->set_heading('CSV Question Import');
$syscontext = context_system::instance();


echo $OUTPUT->header();
echo html_writer::tag('h2', 'Bulk Question Upload');

/**
 * ----------------------------------------------------
 * FETCH ALL QUESTION CATEGORIES
 * ----------------------------------------------------
 */
$categories = $DB->get_records_sql("
    SELECT 
        qc.id,
        qc.name,
        qc.contextid
    FROM {question_categories} qc
    WHERE qc.idnumber LIKE 'coursecat_%'
    ORDER BY qc.name
");


/**
 * ----------------------------------------------------
 * CSV → GIFT CONVERTER
 * ----------------------------------------------------
 */
function csv_to_gift_advanced(string $csvfile): string {
    $handle = fopen($csvfile, 'r');
    if (!$handle) {
        throw new moodle_exception('Cannot open CSV file');
    }

    $headers = fgetcsv($handle);
    $gift = '';
    $qno = 1;

    while (($row = fgetcsv($handle)) !== false) {

        $data = array_combine($headers, $row);
        $question = trim($data['question']);

        if ($question === '') {
            continue;
        }

        // correct options like: 2 OR 1,3,4
        $correct = array_map('intval', explode(',', $data['correct_options']));
        $correctcount = count($correct);

        // weight only for MULTIPLE
        $correctweight = ($correctcount > 1)
            ? round(100 / $correctcount, 5)
            : 100;

        $gift .= "::Q{$qno}::\n";
        $gift .= $question . "\n{\n";

        for ($i = 1; $i <= 10; $i++) {
            $key = 'option' . $i;

            if (!empty($data[$key])) {
                $optiontext = trim($data[$key]);

                if (in_array($i, $correct)) {

                    if ($correctcount === 1) {
                        // ✅ SINGLE CORRECT → DEFAULT MOODLE
                        $gift .= "=" . $optiontext . "\n";
                    } else {
                        // ✅ MULTIPLE CORRECT → % REQUIRED
                        $gift .= "~%{$correctweight}%{$optiontext}\n";
                    }

                } else {
                    // WRONG ANSWER
                    $gift .= "~" . $optiontext . "\n";
                }
            }
        }

        $gift .= "}\n\n";
        $qno++;
    }

    fclose($handle);
    return $gift;
}


/**
 * ----------------------------------------------------
 * HANDLE FORM SUBMISSION
 * ----------------------------------------------------
 */
if (optional_param('submit', false, PARAM_BOOL)) {

    $categoryraw = required_param('category', PARAM_RAW);
    list($catid, $ctxid) = explode(',', $categoryraw);

    $category = $DB->get_record('question_categories', [
        'id' => $catid,
        'contextid' => $ctxid
    ], '*', MUST_EXIST);

    // Upload CSV
    $filename = $_FILES['importfile']['name'];
    $tmpname  = $_FILES['importfile']['tmp_name'];

    if (empty($filename)) {
        echo $OUTPUT->notification('Please select a CSV file', 'error');
    } else {

        $tempdir = make_request_directory();
        $csvfile = $tempdir . '/' . $filename;
        move_uploaded_file($tmpname, $csvfile);

        // Convert CSV → GIFT
        $giftcontent = csv_to_gift_advanced($csvfile);
        $giftfile = $tempdir . '/converted.gift';
        file_put_contents($giftfile, $giftcontent);

        // Import using GIFT
        require_once($CFG->dirroot . '/question/format/gift/format.php');

        $qformat = new qformat_gift();
        $qformat->setCategory($category);
        $qformat->setContexts(
            new core_question\local\bank\question_edit_contexts(
                context_system::instance()
            )
        );
        $qformat->setCourse($SITE);
        $qformat->setFilename($giftfile);
        $qformat->setRealfilename('converted.gift');
        $qformat->setStoponerror(false);

        if ($qformat->importprocess()) {
            $qformat->importpostprocess();
            //echo $OUTPUT->notification('Questions imported successfully ✅', 'success');
        } else {
            echo $OUTPUT->notification('Import failed ❌', 'error');
        }
    }
}
?>

<!-- ----------------------------------------------------
     IMPORT FORM UI
----------------------------------------------------- -->
<form method="post" enctype="multipart/form-data">
    <table class="generaltable">
        <tr>
            <td><strong>Question Category</strong></td>
            <td>
                <select name="category" required style="width:400px">
                    <option value="">-- Select Category --</option>
                    <?php foreach ($categories as $cat): ?>
                        <option value="<?php echo $cat->id . ',' . $cat->contextid; ?>">
                            <?php echo s($cat->name); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>

       <tr>
    <td><strong>CSV File</strong></td>
    <td>
        <input type="file" name="importfile" accept=".csv" required>

        <div class="form-description mt-2">
            <a href="<?= new moodle_url('/local/custompage/questions_template.csv') ?>">
                <?= $OUTPUT->pix_icon('i/import', '') ?>
                Example file (questions_template.csv)
            </a>
        </div>
    </td>
</tr>


        <tr>
            <td></td>
            <td>
                <input type="submit" name="submit" value="Import Questions" class="btn btn-primary">
            </td>
        </tr>
    </table>
</form>

<?php
echo $OUTPUT->footer();
