<?php
require_once(__DIR__ . '/../config.php');
require_login();

global $DB, $USER, $CFG;

// Set up page
$context = context_system::instance();
$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/course/waws_report.php'));
$PAGE->set_title('My AWS Course Report');
$PAGE->set_heading('My AWS Course Report');
$PAGE->set_pagelayout('report');

echo $OUTPUT->header();
echo $OUTPUT->heading('My AWS Course Report');

// Fetch courses for the current user
$courses = $DB->get_records_sql("
    SELECT DISTINCT c.id, c.fullname
    FROM {course} c
    JOIN {enrol} e ON e.courseid = c.id
    JOIN {user_enrolments} ue ON ue.enrolid = e.id

    -- check learning path mapping
    LEFT JOIN {learning_path_courses} lpc
           ON lpc.courseid = c.id
    LEFT JOIN {learning_path_sections} lps
           ON lps.id = lpc.sectionid
    LEFT JOIN {learning_paths} lp
           ON lp.id = lps.learningpathid

    -- check course enrol request
    LEFT JOIN {course_enrol_requests} cer
           ON cer.courseid = c.id
          AND cer.userid = ue.userid

    WHERE ue.userid = :userid
      AND ue.status = 0
      AND e.status = 0
      AND c.visible = 1

      AND (
            lp.id IS NULL                         -- not part of any learning path
            OR lp.status = 'Publish'              -- learning path is published
            OR cer.status = 1                     -- request approved → show anyway
          )

    ORDER BY c.fullname ASC
", [
    'userid' => $USER->id
]);



echo '<div class="table-responsive">';
echo '<table id="courseReportTable" class="table table-striped table-bordered">';
echo '<thead>
        <tr>
            <th>S.No</th>
            <th>Course Name</th>
            <th>Started</th>
            <th>In-Progress</th>
            <th>Completed</th>
        </tr>
      </thead>
      <tbody>';

if (!empty($courses)) {
    $count = 1;
    foreach ($courses as $course) {
        // Count directly from mdl_local_ltiprogress for this user
        $started = $DB->count_records('local_ltiprogress', [
            'ltiid' => $course->id,
            'userid' => $USER->id,
            'activityprogress' => 'Started'
        ]);

        $inprogress = $DB->count_records('local_ltiprogress', [
            'ltiid' => $course->id,
            'userid' => $USER->id,
            'activityprogress' => 'InProgress'
        ]);

        $completed = $DB->count_records('local_ltiprogress', [
            'ltiid' => $course->id,
            'userid' => $USER->id,
            'activityprogress' => 'Completed'
        ]);

        echo '<tr>';
        echo '<td>' . $count++ . '</td>';
        echo '<td>' . format_string($course->fullname) . '</td>';
        echo '<td>' . $started . '</td>';
        echo '<td>' . $inprogress . '</td>';
        echo '<td>' . $completed . '</td>';
        echo '</tr>';
    }
} else {
   echo '<tr>
        <td></td>
        <td>No courses found.</td>
        <td></td>
        <td></td>
        <td></td>
      </tr>';

}

echo '</tbody></table></div>';
?>

<!-- DataTables & Bootstrap -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<!-- DataTables + Buttons -->
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">

<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>

<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>

<script>
$(document).ready(function() {
    $('#courseReportTable').DataTable({
        responsive: true,
        pageLength: 10,
        order: [[1, "asc"]],
        dom: 'Bfrtip',   // ✅ IMPORTANT (buttons enable)

        buttons: [
            {
                extend: 'excelHtml5',
                title: 'AWS_Course_Report',
                text: 'Download Excel',
                exportOptions: {
                    columns: [0,1,2,3,4]
                }
            },
            {
                extend: 'pdfHtml5',
                title: 'AWS_Course_Report',
                text: 'Download PDF',
                orientation: 'landscape',
                pageSize: 'A4',
                exportOptions: {
                    columns: [0,1,2,3,4]
                }
            }
        ],

        language: {
            search: "Search Course:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ courses"
        }
    });
});
</script>


<?php
echo $OUTPUT->footer();
?>
