<?php
require('../../../config.php');
require_once($CFG->libdir.'/adminlib.php');
require_once($CFG->libdir.'/csvlib.class.php');
require_once($CFG->dirroot.'/'.$CFG->admin.'/tool/uploaduser/locallib.php');
require_once($CFG->dirroot.'/'.$CFG->admin.'/tool/uploaduser/user_form.php');
require_once($CFG->dirroot.'/cohort/lib.php'); // ✅ Added for cohort_edit_controls()

$iid         = optional_param('iid', '', PARAM_INT);
$previewrows = optional_param('previewrows', 10, PARAM_INT);
$contextid   = optional_param('contextid', 0, PARAM_INT); // ✅ Added

core_php_time_limit::raise(60 * 60);
raise_memory_limit(MEMORY_HUGE);

if ($contextid) {
    $context = context::instance_by_id($contextid, MUST_EXIST);
} else {
    $context = context_system::instance();
}

require_login();
require_capability('moodle/site:uploadusers', $context);

$PAGE->set_context($context);
$PAGE->set_pagelayout('admin');
$PAGE->set_url(new moodle_url('/admin/tool/uploaduser/index.php', ['contextid' => $context->id]));

echo $OUTPUT->header();
echo '<style>
#id_settingsheader {
    display: block !important;
}
</style>';

if ($contextid) {
    // When inside a specific context (e.g., cohort context)
    echo $OUTPUT->heading('Bulk user with batch');
} 



// ✅ Show same cohort navigation tabs (All batches / Add new batch / Upload batches / Bulk user with batch)
if ($contextid) {
    $currenturl = $PAGE->url;

    $allbatchesurl = new moodle_url('/cohort/index.php', ['contextid' => $context->id]);
    $addbatchurl = new moodle_url('/local/companycohort/index.php', ['contextid' => $context->id]);
    $uploadbatchesurl = new moodle_url('/cohort/upload.php', ['contextid' => $context->id]);
    $uploadbatchusersurl = new moodle_url('/admin/tool/uploaduser/index.php', ['contextid' => $context->id]);

    // ✅ Define tab structure
    $tabs = [];
    $tabs[] = new tabobject('allbatches', $allbatchesurl, 'All batches');
    $tabs[] = new tabobject('addbatch', $addbatchurl, 'Add new batch');
    $tabs[] = new tabobject('uploadbatches', $uploadbatchesurl, 'Upload batches');
    $tabs[] = new tabobject('uploadbatchusers', $uploadbatchusersurl, 'Bulk user with batch');

    // ✅ Detect which tab is active
    $currenttab = '';
    if ($currenturl->get_path() === $allbatchesurl->get_path()) {
        $currenttab = 'allbatches';
    } else if ($currenturl->get_path() === $addbatchurl->get_path()) {
        $currenttab = 'addbatch';
    } else if ($currenturl->get_path() === $uploadbatchesurl->get_path()) {
        $currenttab = 'uploadbatches';
    } else if ($currenturl->get_path() === $uploadbatchusersurl->get_path()) {
        $currenttab = 'uploadbatchusers';
    }

    // ✅ Display tabs
    echo $OUTPUT->tabtree($tabs, $currenttab);
}
// ✅ Return URL logic
if ($contextid) {
    // When inside cohort tab context, return to cohort/index.php
    $returnurl = new moodle_url('/cohort/index.php', ['contextid' => $context->id]);
} else {
    // Otherwise normal uploaduser page
    $returnurl = new moodle_url('/admin/tool/uploaduser/index.php');
}
$bulknurl  = new moodle_url('/admin/user/user_bulk.php');

// Start session for role assignment persistence
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (empty($iid)) {
    $mform1 = new admin_uploaduser_form1();

    if ($formdata = $mform1->get_data()) {
        $_SESSION['uploaduser_assignrole'] = $formdata->assignrole;
        $_SESSION['uploaduser_companyid'] = $formdata->companyid;

        $iid = csv_import_reader::get_new_iid('uploaduser');
        $cir = new csv_import_reader($iid, 'uploaduser');

        $content = $mform1->get_file_content('userfile');
        $delimiter = isset($formdata->delimiter_name) ? $formdata->delimiter_name : ',';
        $readcount = $cir->load_csv_content($content, $formdata->encoding, $delimiter);
        $csvloaderror = $cir->get_error();
        unset($content);

        if (!is_null($csvloaderror)) {
            print_error('csvloaderror', '', $returnurl, $csvloaderror);
        }
    } else {
        $mform1->display();
        echo $OUTPUT->footer();
        exit;
    }
} else {
    $cir = new csv_import_reader($iid, 'uploaduser');
}

// Test if columns ok
$process = new \tool_uploaduser\process($cir);
$filecolumns = $process->get_file_columns();

$mform2 = new admin_uploaduser_form2(null, [
    'columns' => $filecolumns,
    'data' => [
        'iid' => $iid,
        'previewrows' => $previewrows,
        'assignrole' => $_SESSION['uploaduser_assignrole'] ?? null,
        'companyid' => $_SESSION['uploaduser_companyid'] ?? 0
    ]
]);

if ($mform2->is_cancelled()) {
    $cir->cleanup(true);
    redirect($returnurl);
} else if ($formdata = $mform2->get_data()) {
    if (!isset($formdata->assignrole)) {
        $formdata->assignrole = $_SESSION['uploaduser_assignrole'] ?? null;
    }

    $process->set_form_data($formdata);
    $process->process();

    echo $OUTPUT->box_start('boxwidthnarrow boxaligncenter generalbox', 'uploadresults');
    echo html_writer::tag('p', join('<br />', $process->get_stats()));
    echo $OUTPUT->box_end();

    if ($process->get_bulk()) {
        echo $OUTPUT->continue_button($bulknurl);
    } else {
        echo $OUTPUT->continue_button($returnurl);
    }

    echo $OUTPUT->footer();
    exit;
}

// ✅ Preview section
echo $OUTPUT->heading(get_string('uploaduserspreview', 'tool_uploaduser'));
$table = new \tool_uploaduser\preview($cir, $filecolumns, $previewrows);
echo html_writer::div(html_writer::table($table), 'flexible-wrap');

if ($table->get_no_error()) {
    $mform2->display();
}
echo '<style>
#id_settingsheader > legend {
    display: none;
}
</style>';
echo '<style>
#id_settingsheader,
#id_defaultheader {
    display: none !important;
}
</style>';


echo $OUTPUT->footer();
