define("core_block/events",["exports","core/event_dispatcher"],(function(_exports,_event_dispatcher){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.notifyBlockContentUpdated=_exports.eventTypes=void 0;
/**
   * Javascript events for the `core_block` subsystem.
   *
   * @module     core_block/events
   * @copyright  2021 Andrew Nicols <andrew@nicols.co.uk>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   * @since      4.0
   *
   * @example <caption>Example of listening to a block event.</caption>
   * import {eventTypes as blockEventTypes} from 'core_block/events';
   *
   * document.addEventListener(blockEventTypes.blockContentUpdated, e => {
   *     window.console.log(e.target); // The HTMLElement relating to the block whose content was updated.
   *     window.console.log(e.detail.instanceId); // The instanceId of the block that was updated.
   * });
   */
const eventTypes={blockContentUpdated:"core_block/contentUpdated"};_exports.eventTypes=eventTypes;_exports.notifyBlockContentUpdated=element=>(0,_event_dispatcher.dispatchEvent)(eventTypes.blockContentUpdated,{instanceId:element.dataset.instanceId},element);let legacyEventsRegistered=!1;legacyEventsRegistered||(Y.use("event","moodle-core-event",(Y=>{document.addEventListener(eventTypes.blockContentUpdated,(e=>{Y.Global.fire(M.core.event.BLOCK_CONTENT_UPDATED,{instanceid:e.detail.instanceId})}))})),legacyEventsRegistered=!0)}));

//# sourceMappingURL=events.min.js.map