<?php

require_once(__DIR__ . '/../../config.php');
require_once($CFG->dirroot . '/question/editlib.php');

$cmid = required_param('cmid', PARAM_INT);
$cm   = get_coursemodule_from_id(null, $cmid, 0, false, MUST_EXIST);
$course = get_course($cm->course);

require_login($course, false, $cm);

$context = context_module::instance($cmid);
require_capability('local/qbankmanager:manage', $context);

// ---- FILTER PARAMS (ONLY ADD) ----
$filtercategory = optional_param('filtercategory', 0, PARAM_INT);
$filterqtype    = optional_param('filterqtype', '', PARAM_TEXT);

// EXACT SAME SETUP AS CORE question/edit.php
list($thispageurl, $contexts, $cmid, $cm, $module, $pagevars) =
    question_edit_setup('questions', '/local/qbankmanager/index.php');

$thispageurl->param('cmid', $cmid);

$PAGE->set_url($thispageurl);
$PAGE->set_context($contexts->lowest());
$PAGE->set_course($course);
$PAGE->set_pagelayout('standard');
$PAGE->set_title(get_string('editquestions', 'question'));
$PAGE->set_heading($course->fullname);
$PAGE->activityheader->disable();

$PAGE->requires->css(new moodle_url('/local/qbankmanager/styles.css'));

$questionbank = new \local_qbankmanager\custombank(
    $contexts,
    $thispageurl,
    $course,
    $cm
);

echo $OUTPUT->header();
echo '<style>
    fieldset.invisiblefieldset {
        display: none !important;
    }
</style>';

echo '<style>
    .questionbank-window,
    .questionbankform,
    .questionbank {
        display: none !important;
    }
</style>';
echo '<style>
    .singlebutton {
        text-align: right;
    }
</style>';



$questionbank->display($pagevars, 'questions');

// ---------------------------------------------
// CUSTOM QUESTION TABLE (SHOW ALL QUESTIONS)
// ---------------------------------------------
global $DB, $OUTPUT;

/* ========= FILTER FORM (ONLY CHANGE HERE) ========= */

// Course categories (NOT question categories!)
$categories = $DB->get_records_menu('course_categories', null, 'name ASC', 'id,name');

// Distinct question types
$qtypes = $DB->get_records_menu('question', null, 'qtype ASC', 'DISTINCT qtype, qtype');
?>
<!-- Filters -->
<form method="get" class="card mb-4 p-3">
    <input type="hidden" name="cmid" value="<?= $cmid ?>">

    <div class="row g-2 align-items-center">

        <!-- Category -->
        <div class="col-md-3">
            <select name="filtercategory" class="form-select filter-input">
                <option value="0">Select Category</option>

                <?php foreach ($categories as $id => $catname): ?>
                    <option value="<?= $id ?>" <?= ($filtercategory == $id) ? 'selected' : '' ?>>
                        <?= format_string($catname) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Question type -->
        <div class="col-md-5">
            <select name="filterqtype" class="form-select filter-input">
                <option value="">Select Question Type</option>

                <option value="truefalse"   <?= ($filterqtype == 'truefalse') ? 'selected' : '' ?>>
                    True / False
                </option>

                <option value="multichoice" <?= ($filterqtype == 'multichoice') ? 'selected' : '' ?>>
                    Multiple Choice
                </option>
            </select>
        </div>

        <!-- Search button -->
        <div class="col-md-4 d-grid">
            <button type="submit" class="btn btn-orange filter-btn">
                <?= $OUTPUT->pix_icon('a/search', 'Search'); ?> Search
            </button>
        </div>

    </div>
</form>

<style>
    .filter-input {
        height: 45px;
        border-radius: 8px;
    }

    .filter-btn {
        height: 45px;
        background-color: #ff5b00;
        color: #fff;
        font-weight: 600;
        border-radius: 8px;
    }

    .filter-btn:hover {
        background-color: #e44a00;
        color: #fff;
    }
</style>


<?php

/* ========= END FILTER FORM ========= */


/* ========= SQL WITH FILTER SUPPORT (ONLY CHANGE HERE) ========= */

$sql = "
    SELECT 
        q.id,
        q.qtype,
        q.timecreated,
        q.category,
        qc.name AS categoryname,
        cc.name AS coursecatname
    FROM {question} q
    LEFT JOIN {question_categories} qc
           ON qc.id = q.category
    LEFT JOIN {course_categories} cc
           ON (
                qc.idnumber IS NOT NULL
                AND qc.idnumber LIKE 'coursecat_%'
                AND cc.id = CAST(SUBSTRING(qc.idnumber, 11) AS UNSIGNED)
           )
    WHERE 1 = 1
";

$params = [];

// filter by COURSE CATEGORY
if ($filtercategory) {
    $sql .= " AND cc.id = :cc";
    $params['cc'] = $filtercategory;
}

// filter by QUESTION TYPE
if (!empty($filterqtype)) {
    $sql .= " AND q.qtype = :qt";
    $params['qt'] = $filterqtype;
}

$sql .= " ORDER BY q.id DESC";

$questions = $DB->get_records_sql($sql, $params);
/* ========= END SQL ========= */


echo '<div class="card mt-3">
        <div class="table-responsive">
          <table class="table table-striped align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th>S.No</th>
                <th>Category</th>
                <th>Question type</th>
                <th>Created On</th>
                <th class="text-center">Action</th>
              </tr>
            </thead>
            <tbody>';

if ($questions) {
    $i = 1;

    foreach ($questions as $q) {

        // Show course category name (fallback to '-')
        $catname = $q->coursecatname ?: '-';

        echo '<tr>
                <td>' . $i++ . '</td>
                <td>' . format_string($catname) . '</td>
                <td>' . ucfirst($q->qtype) . '</td>
                <td>' . userdate($q->timecreated, "%d %B %Y") . '</td>
                <td class="text-center">';

        // EDIT
        $editurl = new \moodle_url('/question/bank/editquestion/question.php', [
            'id' => $q->id,
            'cmid' => $cm->id,
            'returnurl' => $thispageurl->out_as_local_url(false)
        ]);

        echo \html_writer::link(
            $editurl,
            $OUTPUT->pix_icon('t/edit', get_string('edit')),
            ['class' => 'btn btn-link p-1', 'title' => get_string('edit')]
        );

        // PREVIEW
        $previewurl = new \moodle_url('/question/bank/previewquestion/preview.php', [
            'id' => $q->id,
            'restartversion' => 0,
            'cmid' => $cm->id,
            'returnurl' => (new \moodle_url('/local/qbankmanager/index.php',
                ['cmid' => $cm->id]))->out_as_local_url(false)
        ]);

        echo \html_writer::link(
            $previewurl,
            $OUTPUT->pix_icon('t/preview', get_string('preview')),
            ['class' => 'btn btn-link p-1', 'title' => get_string('preview')]
        );

        // DELETE
        $deleteurl = new \moodle_url('/question/bank/deletequestion/delete.php', [
            'deleteselected' => $q->id,
            'q' . $q->id => 1,
            'sesskey' => sesskey(),
            'cmid' => $cm->id,
            'courseid' => $course->id,
            'returnurl' => (new \moodle_url('/local/qbankmanager/index.php',
                ['cmid' => $cm->id]))->out_as_local_url(false)
        ]);

        echo \html_writer::link(
            $deleteurl,
            $OUTPUT->pix_icon('t/delete', get_string('delete')),
            ['class' => 'btn btn-link p-1', 'title' => get_string('delete')]
        );

        echo '</td></tr>';
    }

} else {
    echo '<tr>
            <td colspan="5" class="text-center text-muted">
                No Questions Found
            </td>
          </tr>';
}

echo '      </tbody>
          </table>
        </div>
      </div>';


if (!empty($pagevars['cat'])) {
    list($categoryid, $contextid) = explode(',', $pagevars['cat']);

    $category   = (object)['id' => $categoryid];
    $catcontext = context::instance_by_id($contextid);

    $event = \core\event\question_category_viewed::create_from_question_category_instance(
        $category,
        $catcontext
    );
    $event->trigger();
}

echo '<style>
.secondary-navigation.d-print-none {
    display: none !important;
}
</style>';

echo '<style>
#bulkactionsui-container {
    display: none !important;
}
</style>';

echo $OUTPUT->footer();
