<?php
require_once(__DIR__ . '/../../config.php');
require_login();

global $DB, $PAGE, $OUTPUT;

// Params
$pathid = required_param('id', PARAM_INT);
$path = $DB->get_record('learning_paths', ['id' => $pathid], '*', MUST_EXIST);

// Page setup
$PAGE->set_url(new moodle_url('/local/learningpath/view.php', ['id' => $pathid]));
$PAGE->set_context(context_system::instance());
$PAGE->set_title('Learning Path - ' . format_string($path->name));
$PAGE->set_heading('Learning Path Details');

// Breadcrumb navigation
$PAGE->navbar->add('Learning Paths', new moodle_url('/local/learningpath/manage.php'));
$PAGE->navbar->add(format_string($path->name));

echo $OUTPUT->header();

echo html_writer::start_div('container mt-4 mb-5');

// Back button
$backurl = new moodle_url('/local/learningpath/manage.php');
echo html_writer::div(
    html_writer::link($backurl, '← Back to Learning Paths', ['class' => 'btn btn-outline-secondary mb-3']),
    'mb-3'
);

// Main card
echo html_writer::start_div('card shadow-lg border-0 mb-4');
echo html_writer::start_div('card-body');

echo html_writer::tag('h2', format_string($path->name), ['class' => 'fw-bold text-primary']);
echo html_writer::tag('p', '<b>Level:</b> ' . format_string($path->level));
echo html_writer::tag('p', '<b>Status:</b> ' . format_string($path->status));
echo html_writer::div(format_text($path->description), 'mt-3 mb-3');

echo html_writer::end_div(); // card-body
echo html_writer::end_div(); // card

// Sections accordion
$sections = $DB->get_records('learning_path_sections', ['learningpathid' => $pathid], 'position ASC');

if ($sections) {
    echo html_writer::tag('h4', 'Learning Path Sections', ['class' => 'fw-bold mb-3 text-primary']);

    echo html_writer::start_div('accordion', ['id' => 'sectionsAccordion']);
    $i = 1;
    foreach ($sections as $section) {
        $sectionid = 'section' . $i;
        $headerid = 'heading' . $i;
        $collapseid = 'collapse' . $i;

        echo '
        <div class="accordion-item mb-2 shadow-sm rounded-2 border-0">
            <h2 class="accordion-header" id="'.$headerid.'">
                <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#'.$collapseid.'" aria-expanded="false" aria-controls="'.$collapseid.'">
                    '.format_string($section->sectionname).'
                </button>
            </h2>
            <div id="'.$collapseid.'" class="accordion-collapse collapse" aria-labelledby="'.$headerid.'" data-bs-parent="#sectionsAccordion">
                <div class="accordion-body">';

        // Courses inside each section
        $courses = $DB->get_records('learning_path_courses', ['sectionid' => $section->id], 'id ASC');
        if ($courses) {
            echo '<ul class="list-group list-group-flush">';
            foreach ($courses as $c) {
                // Make sure your course link column matches the DB schema
                $course = $DB->get_record('course', ['id' => $c->courseid], 'id, fullname');
                if ($course) {
                    $link = new moodle_url('/course/view.php', ['id' => $course->id]);
                    echo '<li class="list-group-item"><a href="'.$link.'" class="text-decoration-none">'.$course->fullname.'</a></li>';
                }
            }
            echo '</ul>';
        } else {
            echo '<p class="text-muted">No courses available in this section.</p>';
        }

        echo '</div></div></div>';
        $i++;
    }
    echo html_writer::end_div(); // accordion
} else {
    echo html_writer::div('No sections found.', 'alert alert-info');
}

echo html_writer::end_div(); // container
echo $OUTPUT->footer();
