<?php
require_once(__DIR__ . '/../../config.php');
require_login();
global $DB, $PAGE, $OUTPUT;

$context = context_system::instance();
require_capability('moodle/site:config', $context);

$pathid = required_param('pathid', PARAM_INT);
$PAGE->set_url(new moodle_url('/local/learningpath/enrol.php', ['pathid' => $pathid]));
$PAGE->set_context($context);
$PAGE->set_title('Enroll Users in Learning Path');
$PAGE->set_heading('Enroll Users in Learning Path');

$path = $DB->get_record('learning_paths', ['id' => $pathid]);
if (!$path) {
    throw new moodle_exception('invalidpath', 'local_learningpath');
}

echo $OUTPUT->header();

// simple user selector and cohort selector
require_once($CFG->dirroot . '/user/selector/lib.php');
$options = new \core_user\selector\options();
$selector = new \core_user\selector\user_selector('local_learningpath_user', $options, 'local_learningpath_user', true);

$cohorts = $DB->get_records_menu('cohort', null, 'name', 'id, name');

if (data_submitted() && confirm_sesskey()) {
    $selectedusers = optional_param_array('local_learningpath_user', [], PARAM_INT);
    $selectedcohorts = optional_param_array('cohortid', [], PARAM_INT);
    $selectedpaths = [$pathid];
    $total = 0;

    // resolve cohort members
    $cohortmembers = [];
    foreach ($selectedcohorts as $cid) {
        $members = $DB->get_records('cohort_members', ['cohortid' => $cid]);
        foreach ($members as $m) { $cohortmembers[] = $m->userid; }
    }
    $allusers = array_unique(array_merge($selectedusers, $cohortmembers));

    foreach ($selectedpaths as $pid) {
        $pathcourses = $DB->get_records('learning_path_courses', ['pathid' => $pid]);
        foreach ($allusers as $uid) {
            foreach ($pathcourses as $c) {
                // If using course_id in table mapping, adjust field name
                $courseid = isset($c->course_id) ? $c->course_id : (isset($c->courseid) ? $c->courseid : 0);
                if ($courseid) {
                    enrol_try_internal_enrol($courseid, $uid, 5);
                    $total++;
                }
            }
            $DB->insert_record('learning_path_enrolments', (object)[ 'pathid'=>$pid, 'userid'=>$uid, 'enrolldate'=>time(), 'completionstatus'=>0 ]);
        }
    }
    redirect(new moodle_url('/local/learningpath/manage.php'), 'Enrolled users successfully');
}

// display form
echo '<form method="post">';
echo sesskey();
echo '<div class="form-group"><label>Select Users</label>';
$selector->display();
echo '</div>';

echo '<div class="form-group"><label>Select Cohorts</label>';
echo '<select name="cohortid[]" multiple class="custom-select">';
foreach ($cohorts as $id => $name) {
    echo "<option value='{$id}'>".s($name)."</option>";
}
echo '</select></div>';

echo '<button type="submit" class="btn btn-primary">Enroll Selected</button>';
echo '</form>';

echo $OUTPUT->footer();