<?php
require_once('../../config.php');
require_login();
// -------------------------------------------
// AJAX Requests (same file endpoint)
// -------------------------------------------
if (optional_param('ajax', 0, PARAM_BOOL)) {
    require_login();
    global $DB, $USER;
    $type = required_param('type', PARAM_ALPHA);
    // ---------------- FETCH BATCHES ----------------
    if ($type === 'batch') {
        // YOU SAID your column is 'created_by'
        $cohorts = $DB->get_records('cohort');
        $list = [];
        foreach ($cohorts as $c) {
            $list[] = [
                'id'   => $c->id,
                'name' => $c->name,
                'count' => 0   // your JS expects "count"
            ];
        }
        echo json_encode($list);
        exit;
    }
    // ---------------- FETCH USERS ----------------
    if ($type === 'user') {
        $users = $DB->get_records('user', ['deleted' => 0, 'suspended' => 0]);
        $list = [];
        foreach ($users as $u) {
            $list[] = [
                'id'   => $u->id,
                'name' => $u->firstname . ' ' . $u->lastname
            ];
        }
        echo json_encode($list);
        exit;
    }
    exit; // Safety exit
}

global $DB, $PAGE, $OUTPUT;
// Page setup
$PAGE->set_url('/local/learningpath/admin_learningpath.php');
$PAGE->set_context(context_system::instance());
$PAGE->set_title('Admin Learning Paths');
$PAGE->set_heading('Admin Learning Paths');
// Pagination parameters (Moodle style)
$page     = optional_param('page', 0, PARAM_INT);
$perpage  = optional_param('perpage', 10, PARAM_INT);
// Fetch learning paths for this page (non-AJAX)
$search = optional_param('search', '', PARAM_RAW_TRIMMED);
$conditions = [];
$params = [];
if (!empty($search)) {
    $conditions[] = $DB->sql_like('name', ':search', false);
    $params['search'] = '%' . $search . '%';
}
$where = empty($conditions) ? '' : 'WHERE ' . implode(' AND ', $conditions);
$totalcount = $DB->count_records_sql("SELECT COUNT(*) FROM {learning_paths} $where", $params);
$lps = $DB->get_records_sql(
    "SELECT * FROM {learning_paths} $where ORDER BY id DESC",
    $params,
    $page * $perpage,
    $perpage
);
// Preload batches (cohorts)
$cohorts = $DB->get_records('cohort');
echo $OUTPUT->header();
?>
<!-- Styles (kept inside file for simplicity; move into theme CSS if desired) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/css/select2.min.css"/>
<style>
/* General */
.container { max-width:1100px; margin:10px auto; }
/* Header row */
.lp-header { display:flex; justify-content:space-between; align-items:center; margin-bottom:18px; }
.lp-actions { display:flex; gap:10px; align-items:center; }
/* Cards list */
.lp-list { background:#f6f8fb; padding:14px; border-radius:8px; }
.lp-item {
    display:flex; align-items:center; gap:16px;
    background:#fff; border-radius:6px; padding:14px 18px;
    margin-bottom:10px; border:1px solid #eceff3;
}
.lp-item .lp-checkbox { transform:scale(1.15); margin-right:6px; cursor:pointer; }
.lp-item .lp-title { font-weight:500; font-size:15px; flex:1; }
.lp-item .lp-meta { color:#6b7280; font-size:13px; margin-left:10px; }
/* Assign button */
.assign-btn { background:#1677ff; color:#fff; border:none; padding:8px 16px; border-radius:6px; cursor:pointer; }
.assign-btn:active{ transform:translateY(1px); }
/* Modal */
#assignModal { display:none; position:fixed; inset:0; background:rgba(0,0,0,0.55); z-index:1100; }
.modal-box { width:900px; max-width:95%; margin:60px auto; background:#fff; border-radius:8px; padding:18px; box-shadow:0 6px 30px rgba(0,0,0,0.25); max-height:80vh; overflow:auto; }
.modal-title { display:flex; align-items:center; gap:12px; margin-bottom:12px; }
.tabs { display:flex; gap:12px; margin-bottom:14px; }
/* Assign layout */
.assign-wrapper { display:flex; gap:12px; }
.assign-column { flex:1; background:#f8fafc; border-radius:6px; padding:10px; min-height:220px; }
.assign-column h4 { margin:0 0 8px 0; font-size:14px; }
.batch-list { list-style:none; padding:0; margin:0; max-height:44vh; overflow:auto; }
.batch-item { display:flex; align-items:center; gap:10px; padding:8px; border-bottom:1px solid #edf2f7; background:#fff; border-radius:4px; margin-bottom:8px; }
.batch-item .batch-check { transform:scale(1.05); margin-right:8px; cursor:pointer; }
/* Arrow controls */
.assign-arrows { width:48px; display:flex; flex-direction:column; gap:8px; align-items:center; justify-content:center; }
.assign-arrows button { width:36px; height:36px; border-radius:50%; border: none; background:#fff; box-shadow:0 4px 12px rgba(0,0,0,0.08); cursor:pointer; }
/* Footer */
.modal-footer { display:flex; justify-content:flex-end; gap:10px; margin-top:12px; }
.btn-secondary { background:#e6eefb; border:none; padding:8px 12px; border-radius:6px; cursor:pointer; }
/* Small helpers */
.small { font-size:13px; color:#6b7280; }
.progress-bar { width:160px; height:8px; background:#eef2ff; border-radius:6px; overflow:hidden; }
.progress-fill { height:8px; background:#4a8efc; width:0%; border-radius:6px; transition:0.3s; }
.toggle-btn {
    background: none;
    border: none;
    font-size: 12px;      /* SMALL ICON SIZE */
    cursor: pointer;
    padding: 2px 4px;     /* small click area */
    line-height: 1;
    color: #444;
}
.toggle-btn:hover {
    color: #000;
}
</style>
<div class="container">
    <div class="lp-header">
        <div>
            <h2 style="margin:0">Learning Paths</h2>
            <div class="small">Manage and assign learning paths to batches or users</div>
        </div>
        <div class="lp-actions">
            <input type="search" id="lpSearch" name="search" value="<?= $search ?>" placeholder="Search " style="padding:8px 10px; border-radius:6px; border:1px solid #d7e0ef;">
            <!-- <button class="btn-secondary" id="advancedFiltersBtn">Advanced Filters</button> -->
            <!-- Assign Button (right) -->
            <button id="openAssignBtn" class="assign-btn">Assign to batches/users</button>
        </div>
    </div>
    <!-- Top controls: select all + (batch selector removed here since modal handles) -->
    <div style="display:flex; align-items:center; justify-content:space-between; margin-bottom:10px;">
        <label style="display:flex; align-items:center; gap:8px;">
            <!-- <input type="checkbox" id="selectAll" style="transform:scale(1.15);">
            <strong>Select All</strong>-->
        </label> 
        <!-- Rows info & pagination will be shown below -->
        <div class="small">Rows per page: <?= $perpage ?></div>
    </div>
    <!-- Assign Form: will post selected LPs + selected Batches -->
    <form id="assignForm" method="post" action="assign_action.php">
        <input type="hidden" name="selected_lps" id="selected_lps" value="">
        <input type="hidden" name="selected_batches" id="selected_batches" value="">
        <!-- Learning Path list -->
        <div class="lp-list" id="lpList">
    <?php if (empty($lps)) : ?>
        <div style="padding:18px">No learning paths found.</div>
    <?php else: ?>
        <?php foreach ($lps as $lp): ?>
            <!-- LP ITEM -->
            <div class="lp-item" data-lpid="<?= $lp->id ?>">
                <input type="checkbox" class="lp-checkbox" value="<?= $lp->id ?>"  data-name="<?= $lp->name ?>"/>
                <div class="lp-title"><?= format_string($lp->name) ?></div>
                <button type="button" class="toggle-btn" onclick="toggleSections(<?= $lp->id ?>)" 
                        id="lp-btn-<?= $lp->id ?>">▶</button>
            </div>
            <!-- LP SECTIONS -->
            <div id="sections-<?= $lp->id ?>" class="lp-sections" style="display:none; margin-left:40px;">
                <?php 
                $sections = $DB->get_records('learning_path_sections', ['learningpathid' => $lp->id], 'id ASC');
                if (empty($sections)) : ?>
                    <div class="small">No sections available.</div>
                <?php else: ?>
                    <?php foreach ($sections as $sec): ?>
                        <!-- SECTION ITEM WITH NAME -->
                        <div class="section-item" style="margin:10px 0; display:flex; align-items:center; gap:8px;">
                            <button type="button" class="toggle-btn" onclick="toggleCourses(<?= $sec->id ?>)" 
                                    id="sec-btn-<?= $sec->id ?>">▶</button>
                            <span class="section-title" style="font-weight:600;">
                                <?= format_string($sec->sectionname) ?>
                            </span>
                        </div>
                        <!-- COURSE LIST -->
                        <div id="courses-<?= $sec->id ?>" style="display:none; margin-left:30px;">
                            <?php
                            $lp_courses = $DB->get_records('learning_path_courses', ['sectionid' => $sec->id]);
                            if (empty($lp_courses)): ?>
                                <div class="small">No courses in this section.</div>
                            <?php else: ?>
                                <?php foreach ($lp_courses as $lc): 
                                    $course = $DB->get_record('course', ['id' => $lc->courseid]);
                                    if ($course): ?>
                                        <div class="course-item" style="margin:4px 0;">
                                            • <?= format_string($course->fullname) ?>
                                        </div>
                                    <?php endif; endforeach; ?>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>
    <!-- Pagination (Moodle paging_bar) -->
    <div style="margin-top:14px; display:flex; justify-content:space-between; align-items:center;">
        <div class="small">Showing <?= ($page * $perpage) + 1 ?> - <?= min(($page * $perpage) + count($lps), $totalcount) ?> of <?= $totalcount ?></div>
        <div>
            <?php
                // Build URL object for paging links
                $baseurl = new moodle_url('/local/learningpath/admin_learningpath.php', ['perpage' => $perpage,'search' => $search]);
                echo $OUTPUT->paging_bar($totalcount, $page, $perpage, $baseurl);
            ?>
        </div>
    </div>
        
    </form>
</div> <!-- container -->
<!-- ASSIGN MODAL -->
<div id="assignModal">
    <div class="modal-box">
        <div class="modal-title">
            <div style="width:48px; height:48px; background:#f0f6ff; border-radius:8px; display:flex; align-items:center; justify-content:center;">
                <!-- icon -->
                <svg width="22" height="22" viewBox="0 0 24 24"><path fill="#1677ff" d="M12 2l3 6 6 .9-4.5 4 1 6L12 16l-5.5 3.9 1-6L3 8.9 9 8z"/></svg>
            </div>
            <div>
                <div id="assignModalTitle" style="font-weight:600; font-size:16px;">Assign Learning Path(s) to batches/users</div>
                <div class="small" id="assignModalSub">Select batches to assign the selected learning path(s)</div>
            </div>
        </div>
        <div class="tabs">
            <label style="display:flex; align-items:center; gap:6px;"><input type="checkbox" id="assignUsers"> Users</label>
            <label style="display:flex; align-items:center; gap:6px;"><input type="checkbox" id="assignBatches" checked> Batches</label>
        </div>
        <div class="assign-wrapper">
            <!-- Left: All batches -->
            <div class="assign-column">
                <h4>All Batches/Users</h4>
                <input type="text" id="searchAllBatches" placeholder="Search batch/user and add" style="width:100%; padding:8px; border-radius:6px; border:1px solid #e4e9f2; margin-bottom:10px;">
                <ul id="allBatchesList" class="batch-list">
                    <?php foreach ($cohorts as $c): 
                        $cnt = $DB->count_records('cohort_members', ['cohortid' => $c->id]);
                    ?>
                        <li class="batch-item" data-id="<?= $c->id ?>">
                            <input type="checkbox" class="batch-check" />
                            <div style="flex:1;">
                                <div style="font-weight:500"><?= format_string($c->name) ?></div>
                                <div class="small"><?= $cnt ?> users</div>
                            </div>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <!-- Arrows -->
            <div class="assign-arrows" style="display:flex; align-items:center;">
                <button id="moveRight" title="Add selected" type="button" style="color:orange;">▶</button>
                <button id="moveLeft" title="Remove selected" type="button" style="color:orange;">◀</button>
            </div>
            <!-- Right: Selected batches -->
            <div class="assign-column">
                <h4>Selected Batches/Users</h4>
                <input type="text" id="searchSelectedBatches" placeholder="Search batch/user and remove" style="width:100%; padding:8px; border-radius:6px; border:1px solid #e4e9f2; margin-bottom:10px;">
                <ul id="selectedBatchesList" class="batch-list">
                    <!-- Initially empty; user will move items here -->
                </ul>
            </div>
        </div>
        <div class="modal-footer">
            <button id="assignSubmit" class="assign-btn">ASSIGN</button>
            <button id="assignCancel" class="btn-secondary">CANCEL</button>
        </div>
    </div>
</div>
<!-- Scripts -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script>
    document.getElementById("lpSearch").addEventListener("keyup", function () {
    clearTimeout(window.lpSearchTimer);
    window.lpSearchTimer = setTimeout(() => {
        let url = new URL(window.location.href);
        url.searchParams.set("search", this.value);
        url.searchParams.set("page", 0);
        window.location.href = url.toString();
    }, 350);
});
document.addEventListener('DOMContentLoaded', function() {
    // If any course checkbox is clicked → update LP checkbox
    document.querySelectorAll('.course-checkbox').forEach(courseCheckbox => {
        courseCheckbox.addEventListener('change', function() {
            // Find LP ID by reading parent container ID
            let container = this.closest('div[id^="courses-"]');
            let lpId = container.id.replace('courses-', '');
            // All course checkboxes under SAME LP
            let all = document.querySelectorAll('#courses-' + lpId + ' .course-checkbox');
            let allChecked = true;
            all.forEach(cb => {
                if (!cb.checked) allChecked = false;
            });
            // Update LP checkbox
            document.querySelector('.lp-checkbox[value="' + lpId + '"]').checked = allChecked;
        });
    });
});
</script>
<script>
function toggleSections(lpId) {
    let div = document.getElementById("sections-" + lpId);
    let btn = document.getElementById("lp-btn-" + lpId);
    if (div.style.display === "none") {
        div.style.display = "block";
        btn.innerHTML = "▼"; // expanded
    } else {
        div.style.display = "none";
        btn.innerHTML = "▶"; // collapsed
    }
}
function toggleCourses(sectionId) {
    let div = document.getElementById("courses-" + sectionId);
    let btn = document.getElementById("sec-btn-" + sectionId);
    if (div.style.display === "none") {
        div.style.display = "block";
        btn.innerHTML = "▼"; // expanded
    } else {
        div.style.display = "none";
        btn.innerHTML = "▶"; // collapsed
    }
}
/* ============================
   GLOBAL ARRAYS
============================ */
let selectedBatches = [];
let selectedUsers = [];
/* ============================
   DOM READY
============================ */
document.addEventListener("DOMContentLoaded", function () {
    // Load batches by default
    loadBatches();
    // LP single-select
    document.querySelectorAll(".lp-checkbox").forEach(cb => {
        cb.addEventListener("change", function () {
            if (this.checked) {
                document.querySelectorAll(".lp-checkbox").forEach(other => {
                    if (other !== this) other.checked = false;
                });
            }
        });
    });
    // Assign modal open
    document.getElementById("openAssignBtn")
        .addEventListener("click", openAssignModal);
    // Close modal
    document.getElementById("assignCancel")
        .addEventListener("click", () => {
            document.getElementById("assignModal").style.display = "none";
        });
    // Move right
    document.getElementById("moveRight")
        .addEventListener("click", moveRight);
    // Move left
    document.getElementById("moveLeft")
        .addEventListener("click", moveLeft);
    // Submit
    document.getElementById("assignSubmit")
        .addEventListener("click", submitAssignForm);
    // Toggle between batch/user
    document.getElementById("assignUsers").addEventListener("change", function () {
        if (this.checked) {
            document.getElementById("assignBatches").checked = false;
            loadUsers();
        }
    });
    document.getElementById("assignBatches").addEventListener("change", function () {
        if (this.checked) {
            document.getElementById("assignUsers").checked = false;
            loadBatches();
        }
    });
    // Click list item to toggle checkbox
    $(document).on("click", ".batch-item", function (e) {
        if (e.target.tagName.toLowerCase() === "input") return;
        let chk = $(this).find(".batch-check");
        chk.prop("checked", !chk.prop("checked"));
    });
});

// ----------------------
// Search All Batches
// ----------------------
document.getElementById("searchAllBatches").addEventListener("keyup", function () {
    let keyword = this.value.toLowerCase();
    let items = document.querySelectorAll("#allBatchesList .batch-item");

    items.forEach(item => {
        let text = item.innerText.toLowerCase();
        item.style.display = text.includes(keyword) ? "flex" : "none";
    });
});

// ----------------------
// Search Selected Batches
// ----------------------
document.getElementById("searchSelectedBatches").addEventListener("keyup", function () {
    let keyword = this.value.toLowerCase();
    let items = document.querySelectorAll("#selectedBatchesList .batch-item");

    items.forEach(item => {
        let text = item.innerText.toLowerCase();
        item.style.display = text.includes(keyword) ? "flex" : "none";
    });
});
/* ============================
   LOAD BATCHES / USERS
============================ */
function loadBatches() {
    fetch("admin_learningpath.php?ajax=1&type=batch")
        .then(r => r.json())
        .then(data => renderList(data, false));
}
function loadUsers() {
    fetch("admin_learningpath.php?ajax=1&type=user")
        .then(r => r.json())
        .then(data => renderList(data, true));
}
/* ============================
   RENDER LEFT LIST
============================ */
function renderList(data, isUser = false) {
    const list = document.getElementById("allBatchesList");
    list.innerHTML = "";
    data.forEach(item => {
        const id = parseInt(item.id);
        // Check if already selected → disable + checked
        const alreadySelected = isUser
            ? selectedUsers.includes(id)
            : selectedBatches.includes(id);
        list.innerHTML += `
            <li class="batch-item" data-id="${item.id}">
                <input type="checkbox" class="batch-check" 
                    ${alreadySelected ? "disabled checked" : ""} />
                <div style="flex:1;">
                    <div style="font-weight:500">${item.name}</div>
                </div>
            </li>
        `;
    });
}
/* ============================
   MOVE SELECTED → RIGHT SIDE
============================ */
function moveRight() {
    $("#allBatchesList .batch-item").each(function () {
        const id = parseInt($(this).data("id"));
        const chk = $(this).find(".batch-check");
        if (chk.prop("checked")) {
            // USER MODE
            if (document.getElementById("assignUsers").checked) {
                if (!selectedUsers.includes(id)) {
                    selectedUsers.push(id);
                }
            }
            // BATCH MODE
            else {
                if (!selectedBatches.includes(id)) {
                    selectedBatches.push(id);
                }
            }
            // Move DOM element
            $(this).appendTo("#selectedBatchesList");
        }
    });
}
/* ============================
   MOVE SELECTED → LEFT SIDE
============================ */
function moveLeft() {
    let removedAny = false;
    $("#selectedBatchesList .batch-item").each(function () {
        const id = parseInt($(this).data("id"));
        const chk = $(this).find(".batch-check");
        if (chk.prop("checked")) {
            // Remove from arrays
            selectedUsers = selectedUsers.filter(x => x !== id);
            selectedBatches = selectedBatches.filter(x => x !== id);
            removedAny = true;
        }
    });
    // Clear and reload LEFT LIST again
    if (removedAny) {
        // User mode
        if (document.getElementById("assignUsers").checked) {
            loadUsers();
        }
        // Batch mode
        else {
            loadBatches();
        }
        // Clear selected panel (right)
        $("#selectedBatchesList").find(".batch-item .batch-check:checked").each(function () {
            $(this).closest(".batch-item").remove();
        });
    }
}

/* ============================
   OPEN MODAL
============================ */
function openAssignModal() {
    let selected = document.querySelector('.lp-checkbox:checked');
    if (!selected) {
        alert("Please select a Learning Path.");
        return;
    }
    const lpName = selected.dataset.name;
    document.getElementById('assignModalTitle').innerText = lpName;
    document.getElementById('assignModalSub').innerText = "Assign Learning Path";
    document.getElementById('assignModal').style.display = 'block';
}
/* ============================
   SUBMIT FORM
============================ */
function submitAssignForm() {
    let selectedLP = document.querySelector('.lp-checkbox:checked');
    if (!selectedLP) {
        alert("No learning path selected.");
        return;
    }

    document.getElementById("selected_lps").value =
        JSON.stringify([selectedLP.value]);

    // SEND BATCH IDS ONLY
    document.getElementById("selected_batches").value =
        JSON.stringify(selectedBatches);

    // SEND USER IDS ONLY
    document.getElementById("selected_users").value =
        JSON.stringify(selectedUsers);

    document.getElementById("assignForm").submit();
}

</script>
<?php
echo $OUTPUT->footer();
