<?php
require('../../config.php');
require_login();

$context = context_system::instance();
$PAGE->set_context($context);
$PAGE->set_url('/local/custompage/user_report.php');
$PAGE->set_title('User Report');
$PAGE->set_heading('User Report');

// Get user ID
$userid = optional_param('userid', 0, PARAM_INT);

echo $OUTPUT->header();

// --------------------
// Search Form
// --------------------
echo '<h2>User Enrollment Report</h2>';



if ($userid > 0) {

    // --------------------
    // Fetch User Data
    // --------------------
    $user = $DB->get_record('user', ['id' => $userid, 'deleted' => 0]);

    if (!$user) {
        echo $OUTPUT->notification("❌ User not found.", 'notifyproblem');
        echo $OUTPUT->footer();
        exit;
    }

    echo "<h3>User Details</h3>";
    echo "<p><strong>Name:</strong> {$user->firstname} {$user->lastname}<br>
          <strong>Email:</strong> {$user->email}</p>";

    // --------------------
    // Learning Paths (custom)
    // --------------------
    echo "<h3>Learning Paths</h3>";

    $sqlLP = "
        SELECT lpe.*, lp.name
        FROM {learning_path_enrolments} lpe
        JOIN {learning_paths} lp ON lp.id = lpe.learningpathid
        WHERE lpe.userid = :uid
    ";

    $learningpaths = $DB->get_records_sql($sqlLP, ['uid' => $userid]);

    if ($learningpaths) {
        echo '<table class="generaltable">';
        echo '<tr>
                <th>ID</th>
                <th>Learning Path</th>
               
                <th>Date</th>
              </tr>';

       $sr = 1;
foreach ($learningpaths as $lp) {
    echo "<tr>
            <td>{$sr}</td>
            <td>{$lp->name}</td>
            <td>".date('d-M-Y H:i', $lp->timecreated)."</td>
          </tr>";
    $sr++;
}


        echo '</table>';
    } else {
        echo $OUTPUT->notification("No learning path enrolments found.", 'notifyinfo');
    }

    // --------------------
    // Cohorts (Batches)
    // --------------------
    echo "<h3>Cohorts / Batches</h3>";

    $sqlCohorts = "
        SELECT c.id, c.name, c.idnumber
        FROM {cohort_members} cm
        JOIN {cohort} c ON c.id = cm.cohortid
        WHERE cm.userid = :uid
    ";

    $cohorts = $DB->get_records_sql($sqlCohorts, ['uid' => $userid]);
	
    if ($cohorts) {
        echo '<table class="generaltable">';
        echo '<tr>
                <th>ID</th>
                <th>Name</th>
                <th>Batch Code</th>
              </tr>';

        foreach ($cohorts as $c) {
            echo "<tr>
                    <td>{$c->id}</td>
                    <td>{$c->name}</td>
                    <td>{$c->idnumber}</td>
                  </tr>";
        }

        echo '</table>';
    } else {
        echo $OUTPUT->notification("User is not in any cohort.", 'notifyinfo');
    }
}

echo $OUTPUT->footer();
