<?php
require(__DIR__ . '/../../config.php');
require_once($CFG->dirroot . '/question/editlib.php');  
require_login();

$context = context_system::instance();
require_capability('moodle/question:viewall', $context);

$PAGE->set_url(new moodle_url('/local/custompage/questions_list.php'));
$PAGE->set_title('All Questions');
$PAGE->set_heading('All Questions');

/**
 * 1) Enable the question-type chooser popup
 */
$PAGE->requires->js_call_amd('qbank_chooser/chooser', 'init');

/**
 * 2) Make sure newly created questions return back to THIS page
 */
$PAGE->url->param('returnurl', $PAGE->url->out(false));

/**
 * 3) Default question category
 */
$defaultcategoryobj = question_make_default_categories([$context]);
if (is_array($defaultcategoryobj)) {
    $defaultcategoryobj = reset($defaultcategoryobj);
}
$PAGE->url->param('category', $defaultcategoryobj->id . ',' . $context->id);

echo $OUTPUT->header();
echo html_writer::start_div('questionbankwindow', ['data-region' => 'questionbank']);


global $DB;

// ------------------------------------------------
// Quiz / Activity cmid (only needed when previewing/editing)
// ------------------------------------------------
$cmid = 10845;

// Get ALL questions
$questions = $DB->get_records('question', null, 'id DESC');

if (!$questions) {
    echo $OUTPUT->notification('No questions found.', \core\output\notification::NOTIFY_INFO);
}

/**
 * 4) Button that opens the popup
 *    (the data-action attribute is what triggers the chooser)
 */
echo html_writer::div(
    '<button class="btn btn-primary" data-action="addquestion">
        Add New Question
     </button>',
    'mb-3 text-end'
);

echo html_writer::tag('h3', 'All Questions');

echo html_writer::start_tag('table', ['class' => 'generaltable']);
echo html_writer::start_tag('tr');
echo html_writer::tag('th', 'S.No');
echo html_writer::tag('th', 'Name');
echo html_writer::tag('th', 'Question');
echo html_writer::tag('th', 'Type');
echo html_writer::tag('th', 'Created');
echo html_writer::tag('th', 'Action');
echo html_writer::end_tag('tr');

$sn = 1;

foreach ($questions as $q) {

    $returnurl = '/mod/quiz/edit.php?cmid=' . $cmid;

    // Preview
    $viewurl = new moodle_url('/question/bank/previewquestion/preview.php', [
        'id' => $q->id,
        'restartversion' => 0,
        'cmid' => $cmid
    ]);

    // Edit
    $editurl = new moodle_url('/question/bank/editquestion/question.php', [
        'id' => $q->id,
        'cmid' => $cmid,
        'returnurl' => $returnurl
    ]);

    $viewicon = $OUTPUT->pix_icon('t/preview', 'Preview');
    $editicon = $OUTPUT->pix_icon('t/edit', 'Edit');

    $actions =
        html_writer::link($viewurl, $viewicon, ['title' => 'Preview', 'class' => 'me-2']) .
        html_writer::link($editurl, $editicon, ['title' => 'Edit', 'class' => 'me-2']);

    echo html_writer::start_tag('tr');

    echo html_writer::tag('td', $sn++);
    echo html_writer::tag('td', format_string($q->name));
    echo html_writer::tag('td', format_text($q->questiontext, $q->questiontextformat));
    echo html_writer::tag('td', $q->qtype);
    echo html_writer::tag('td', userdate($q->timecreated));
    echo html_writer::tag('td', $actions);

    echo html_writer::end_tag('tr');
}

echo html_writer::end_tag('table');

echo $OUTPUT->footer();
