<?php
require(__DIR__ . '/../../config.php');
require_login();
global $DB, $OUTPUT, $PAGE;

$context = context_system::instance();
$PAGE->set_url('/local/custompage/assesment.php');
$PAGE->set_context($context);
$PAGE->set_title('Assessment List');
$PAGE->set_heading('Assessment List');

$defaultcourseid = 4814;
$defaultsection  = 0;

// ---------------------
// FILTERS
// ---------------------
$categoryid = optional_param('categoryid', 0, PARAM_INT);
$name       = optional_param('name', '', PARAM_TEXT);

// Pagination
$page    = optional_param('page', 0, PARAM_INT);
$perpage = 10;
$start   = $page * $perpage;

// Categories list
$categories = $DB->get_records_menu('course_categories', null, 'name ASC', 'id, name');

// ---------------------
// BUILD WHERE
// ---------------------
$where  = '1=1';
$params = [];

if ($categoryid) {
    $where .= ' AND coursecategory = :cat';
    $params['cat'] = $categoryid;
}

if (!empty($name)) {
    $where .= ' AND name LIKE :nm';
    $params['nm'] = "%$name%";
}

// Count total
$totalquizzes = $DB->count_records_select('quiz', $where, $params);

// Fetch records
$quizzes = $DB->get_records_select(
    'quiz',
    $where,
    $params,
    'id DESC',
    'id, course, name, grade, timelimit, timecreated, coursecategory',
    $start,
    $perpage
);

echo $OUTPUT->header();
?>

<div class="container-fluid mt-4">

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="fw-bold text-primary">Assessment List</h3>

  <a href="<?= $CFG->wwwroot ?>/course/modedit.php?add=quiz&course=<?= $defaultcourseid ?>&section=<?= $defaultsection ?>&return=0"
   class="btn btn-primary">
    <?= $OUTPUT->pix_icon('t/add', 'Add'); ?> Add Assessment
</a>

  </div>

<!-- Filters -->
<form method="get" class="card mb-4 p-3">
    <div class="row g-2 align-items-center">

        <!-- Category -->
        <div class="col-md-3">
            <select name="categoryid" class="form-select filter-input">
                <option value="">Select Category</option>
                <?php foreach ($categories as $id => $catname): ?>
                    <option value="<?= $id ?>" <?= $categoryid == $id ? 'selected' : '' ?>>
                        <?= format_string($catname) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Name -->
        <div class="col-md-5">
            <input type="text"
                   name="name"
                   class="form-control filter-input"
                   value="<?= s($name) ?>"
                   placeholder="Search assessment name">
        </div>

        <!-- Search -->
        <div class="col-md-4 d-grid">
            <button class="btn btn-orange filter-btn">
                <?= $OUTPUT->pix_icon('a/search', 'Search'); ?> Search
            </button>
        </div>

    </div>
</form>

<style>
.filter-input { height:45px;border-radius:8px; }
.filter-btn { height:45px;background:#ff5b00;color:#fff;font-weight:600;border-radius:8px; }
.filter-btn:hover { background:#e44a00;color:#fff; }
</style>

<!-- Table -->
<div class="card">
  <div class="table-responsive">
    <table class="table table-striped align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>S.No</th>
          <th>Name</th>
          <th>Category</th>
          <th>Total Marks</th>
          <th>Passing Marks</th>
          <th>Weightage</th>
          <th>Duration</th>
          <th>Created</th>
          <th class="text-center">Action</th>
        </tr>
      </thead>
      <tbody>

<?php
if ($quizzes) {
    $i = $start + 1;

    foreach ($quizzes as $quiz) {

        // Category name
        $catname = $quiz->coursecategory
            ? ($categories[$quiz->coursecategory] ?? '-')
            : '-';

        // Duration
        $duration = $quiz->timelimit > 0 ? floor($quiz->timelimit / 60) : 0;

        // Passing marks
        $gradeitem = $DB->get_record('grade_items', [
            'itemtype'     => 'mod',
            'itemmodule'   => 'quiz',
            'iteminstance' => $quiz->id
        ]);

        $passing = ($gradeitem && $gradeitem->gradepass !== null)
            ? $gradeitem->gradepass
            : '-';

        $cm = get_coursemodule_from_instance('quiz', $quiz->id, $quiz->course);
?>
        <tr>
          <td><?= $i++ ?></td>
          <td><?= format_string($quiz->name) ?></td>
          <td><?= format_string($catname) ?></td>
          <td><?= $quiz->grade ?></td>
          <td><?= $passing ?></td>
          <td><?= $quiz->grade ?></td>  
          <td><?= $duration ?></td>
          <td><?= userdate($quiz->timecreated, '%d %B %Y') ?></td>

          <td class="text-center">
              <a href="/course/modedit.php?update=<?= $cm->id ?>" class="btn btn-link p-1">
                  <?= $OUTPUT->pix_icon('t/edit', 'Edit'); ?>
              </a>

              <a href="/course/mod.php?delete=<?= $cm->id ?>&sesskey=<?= sesskey() ?>"
                 class="btn btn-link p-1">
                  <?= $OUTPUT->pix_icon('t/delete', 'Delete'); ?>
              </a>
          </td>
        </tr>

<?php
    }
} else {
    echo '<tr><td colspan="8" class="text-center text-muted">No Assessments Found</td></tr>';
}
?>

      </tbody>
    </table>
  </div>

  <!-- Pagination -->
  <div class="p-3">
    <?php
      echo $OUTPUT->paging_bar(
          $totalquizzes,
          $page,
          $perpage,
          new moodle_url('/local/custompage/assesment.php', [
              'categoryid' => $categoryid,
              'name'       => $name
          ])
      );
    ?>
  </div>

</div>

<?php
echo $OUTPUT->footer();
