<?php
namespace local_customenrolmail;

defined('MOODLE_INTERNAL') || die();

class observer {

    public static function user_enrolled_handler(\core\event\user_enrolment_created $event) {
        global $DB, $CFG;

        debugging("CustomEnrolMail triggered for event: {$event->eventname}");

        $ue = $event->get_record_snapshot('user_enrolments', $event->objectid);
        if (!$ue) {
            debugging("CustomEnrolMail: No user_enrolments record for objectid {$event->objectid}");
            return true;
        }

        $user   = $DB->get_record('user', ['id' => $ue->userid], '*', MUST_EXIST);
        $course = $DB->get_record('course', ['id' => $ue->courseid], '*', MUST_EXIST);

        $from = \core_user::get_noreply_user();

        $subject = "Welcome to {$course->fullname}";
        $messagehtml = "
            <div style='font-family:Arial,sans-serif;'>
                <h2>Hello {$user->firstname},</h2>
                <p>You are now enrolled in <strong>{$course->fullname}</strong>.</p>
                <p><a href='{$CFG->wwwroot}/course/view.php?id={$course->id}'>Go to course</a></p>
            </div>";
        $messagetext = "Hello {$user->firstname},\n\n"
            ."You are now enrolled in {$course->fullname}.\n"
            ."Go to course: {$CFG->wwwroot}/course/view.php?id={$course->id}";

        $result = email_to_user($user, $from, $subject, $messagetext, $messagehtml);

        if ($result) {
            debugging("CustomEnrolMail: Email sent to {$user->email}");
        } else {
            debugging("CustomEnrolMail: Failed to send email to {$user->email}");
        }

        return true;
    }
}
