<?php

require_once("$CFG->libdir/formslib.php");

class local_companycohort_form extends moodleform {

    public function definition() {
        global $DB, $CFG;

        $mform = $this->_form;
        $data  = $this->_customdata['data'] ?? null;

        // Preselected users
        $preselected = [];
        if (!empty($data->selectedusers)) {
            $preselected = array_map('intval', explode(',', $data->selectedusers));
        }

        // Detect Add or Edit mode
        $editing = !empty($data->id);

        if ($editing) {
            $mform->addElement('html', '<h2>Edit Batch</h2>');
        } else {
            $mform->addElement('html', '<h2>Add New Batch</h2>');
        }

        // ------------------
        // BASIC FIELDS
        // ------------------
        $mform->addElement('hidden', 'id');
        $mform->setType('id', PARAM_INT);

        $mform->addElement('text', 'name', 'Batch Name');
        $mform->setType('name', PARAM_TEXT);
        $mform->addRule('name', null, 'required');

        $mform->addElement('text', 'idnumber', 'Batch ID');
        $mform->setType('idnumber', PARAM_TEXT);

        // Company selector
        $companyoptions = [0 => get_string('choose')];
        if ($DB->get_manager()->table_exists('company')) {
            $companyoptions += $DB->get_records_menu(
                'company',
                [],
                'com_name ASC',
                'id, com_name'
            );
        }

        $mform->addElement('select', 'company_id', 'Company', $companyoptions);
        $mform->setType('company_id', PARAM_INT);
        $mform->addRule('company_id', null, 'required');

        if (!empty($data->company_id)) {
            $mform->setDefault('company_id', $data->company_id);
        }

        $mform->addElement('date_selector', 'start_date', 'Start Date');
        $mform->addElement('date_selector', 'end_date', 'End Date');

        // =========================================================
        // USER SECTION → ADD MODE ONLY (HIDDEN IN EDIT MODE)
        // =========================================================
        if (!$editing) {

            // Hidden selected users
            $mform->addElement('hidden', 'selectedusers', implode(',', $preselected));
            $mform->setType('selectedusers', PARAM_TEXT);

            // USER SELECTOR HTML
            $html = "
            <style>
                .userbox { display:flex; gap:30px; margin-top:20px; }
                .userlist { width:45%; border:1px solid #ccc; padding:10px; height:350px; overflow-y:auto; }
                .controls { display:flex; flex-direction:column; justify-content:center; gap:10px; }
                .user-item { padding:6px; border-bottom:1px solid #eee; cursor:pointer; }
                .user-item:hover { background:#f5f5f5; }
            </style>

            <div class='userbox'>
                <div class='userlist' id='all-users-list'>
                    <h4>All Users</h4>
                    <input type='text' id='usersearch' placeholder='Search...' style='width:100%;margin-bottom:8px;'>
            ";

          $users = $DB->get_records_select(
    'user',
    'deleted = 0 AND id NOT IN (:uid1, :uid2)',
    [
        'uid1' => 1,
        'uid2' => 2
    ],
    'lastname ASC',
    'id, firstname, lastname, email'
);


            foreach ($users as $u) {
                $html .= "
                <div class='user-item' data-id='{$u->id}'>
                    <input type='checkbox' class='userchk' data-id='{$u->id}'>
                    {$u->firstname} {$u->lastname} ({$u->email})
                </div>";
            }

            $html .= "
                </div>

                <div class='controls'>
                    <button type='button' id='move-right'>▶</button>
                    <button type='button' id='move-left'>◀</button>
                </div>

                <div class='userlist' id='selected-users-list'>
                    <h4>Selected Users</h4>
                </div>
            </div>

            <script>
            document.addEventListener('DOMContentLoaded', function() {

                function updateHiddenField() {
                    let selected = [];
                    document.querySelectorAll('#selected-users-list .userchk:checked')
                        .forEach(chk => selected.push(chk.dataset.id));
                    document.querySelector('input[name=\"selectedusers\"]').value = selected.join(',');
                }

                document.addEventListener('click', function(e) {
                    let item = e.target.closest('.user-item');
                    if (!item) return;

                    if (!e.target.classList.contains('userchk')) {
                        let chk = item.querySelector('.userchk');
                        chk.checked = !chk.checked;
                    }
                });

                document.getElementById('move-right').addEventListener('click', function() {
                    document.querySelectorAll('#all-users-list .userchk:checked').forEach(chk => {
                        let div = chk.closest('.user-item');
                        document.getElementById('selected-users-list').appendChild(div);
                    });
                    updateHiddenField();
                });

                document.getElementById('move-left').addEventListener('click', function() {
                    document.querySelectorAll('#selected-users-list .userchk:checked').forEach(chk => {
                        let div = chk.closest('.user-item');
                        document.getElementById('all-users-list').appendChild(div);
                    });
                    updateHiddenField();
                });

                document.getElementById('usersearch').addEventListener('keyup', function () {
                    let term = this.value.toLowerCase();
                    document.querySelectorAll('#all-users-list .user-item').forEach(item => {
                        item.style.display = item.textContent.toLowerCase().includes(term) ? '' : 'none';
                    });
                });

            });
            </script>
            ";

            $mform->addElement('html', $html);

            // RADIO BUTTONS
            $mform->addElement('radio', 'usermode', '', 'Users List', 1, ['class' => 'fakecheckbox']);
            $mform->addElement('radio', 'usermode', '', 'Bulk Upload', 2, ['class' => 'fakecheckbox']);
            $mform->setDefault('usermode', 1);

            // Fake checkbox styling
            $mform->addElement('html', "
            <style>
            input.fakecheckbox[type=radio] {
                appearance: none;
                width: 18px;
                height: 18px;
                border: 2px solid #444;
                border-radius: 4px;
                cursor: pointer;
                margin-right: 6px;
            }
            input.fakecheckbox[type=radio]:checked::after {
                content: '✔';
                font-size: 14px;
                color: #2196f3;
                position: absolute;
                top: -3px;
                left: 1px;
            }
            </style>
            ");

            // CSV download + upload
            $csvfile = $CFG->wwwroot . '/local/companycohort/user.csv';
            $mform->addElement(
                'static',
                'examplecsv',
                'Download Sample CSV',
                html_writer::link($csvfile, 'user.csv', ['download' => 'user.csv'])
            );

            $mform->addElement('filepicker', 'csvfile', 'Upload CSV File', null, [
                'accepted_types' => ['.csv', '.txt'],
                'maxbytes' => 0,
            ]);
        }

        // SAVE BUTTON
        $this->add_action_buttons(true, 'Save');

        $this->set_data($data);
    }

    // ------------------
    // VALIDATION
    // ------------------
    public function validation($data, $files) {
        global $USER;

        $errors = parent::validation($data, $files);

        if (!empty($data['usermode']) && $data['usermode'] == 2) {
            $draftitemid = file_get_submitted_draft_itemid('csvfile');
            $fs = get_file_storage();
            $context = context_user::instance($USER->id);

            $uploadedfiles = $fs->get_area_files(
                $context->id,
                'user',
                'draft',
                $draftitemid,
                'id',
                false
            );

            if (empty($uploadedfiles)) {
                $errors['csvfile'] = 'You must upload a CSV file when Bulk Upload is selected.';
            }
        }

        return $errors;
    }
}
