<?php
require_once(__DIR__ . '/../config.php');
require_once($CFG->libdir . '/tablelib.php'); // for flexible_table
require_login();

global $DB, $OUTPUT, $PAGE;

$context = context_system::instance();
$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/course/companylist.php'));
$PAGE->set_title('Company List');
$PAGE->set_heading('Company List');

// Handle delete
$deleteid = optional_param('delete', 0, PARAM_INT);
if ($deleteid) {
    require_sesskey(); // security check
    $DB->delete_records('company', ['id' => $deleteid]);
    redirect(new moodle_url('/course/companylist.php'), 'Company deleted successfully.', 1);
}

// Header
echo $OUTPUT->header();

// Add button (top-right)
echo html_writer::div(
    $OUTPUT->single_button(
        new moodle_url('/course/company.php'),
        'Add Company',
        'get'
    ),
    'd-flex justify-content-end mb-3'
);

// Setup Moodle flexible table
$table = new flexible_table('company-list');
$table->define_columns(['sno', 'company', 'email', 'date', 'actions']);
$table->define_headers(['S.No', 'Company', 'Email', 'Date', 'Actions']);
$table->define_baseurl($PAGE->url);

$table->sortable(true, 'company', SORT_ASC); // enable sorting
$table->pageable(true);                      // enable paging
$totalcount = $DB->count_records('company');
$table->pagesize(20, $totalcount);

$table->set_attribute('class', 'generaltable generalbox boxaligncenter');
$table->setup();

// Fetch companies with paging + sorting
list($sort, $params) = $table->get_sql_sort();
if (empty($sort)) {
    $sort = 'id ASC';
}

$companies = $DB->get_records('company', null, $sort, '*', $table->get_page_start(), $table->get_page_size());

// Fill rows
$i = $table->get_page_start() + 1;
foreach ($companies as $company) {
    $editurl = new moodle_url('/course/company.php', ['id' => $company->id]);
    $deleteurl = new moodle_url('/course/companylist.php', [
        'delete'  => $company->id,
        'sesskey' => sesskey()
    ]);

    // Moodle standard icons
    $editicon = $OUTPUT->action_icon($editurl, new pix_icon('t/edit', get_string('edit')));
    $deleteicon = $OUTPUT->action_icon(
        $deleteurl,
        new pix_icon('t/delete', get_string('delete')),
        new confirm_action(get_string('deletecheck', '', $company->com_name))
    );

    $table->add_data([
        $i++,
        format_string($company->com_name),
        format_string($company->email ?? ''),
        userdate(strtotime($company->created_at), get_string('strftimedate')),
        $editicon . ' ' . $deleteicon
    ]);
}

$table->finish_output();

echo $OUTPUT->footer();
